/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.compat;

import buildcraft.BuildCraftCompat;
import buildcraft.api.blueprints.SchematicTile;
import buildcraft.compat.CompatModuleBase;
import buildcraft.compat.CompatUtils;
import buildcraft.compat.factorization.ChargeEnergyReceiver;
import buildcraft.compat.factorization.SchematicFZBarrel;
import buildcraft.compat.factorization.SchematicFZBase;
import com.google.common.collect.MapMaker;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import factorization.api.IChargeConductor;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;

public class CompatModuleFactorization
extends CompatModuleBase {
    public static float CHARGE_PER_RF = 0.13f;
    public static boolean ENABLE_ENERGY = false;
    public static boolean ENABLE_SERVO_RAILS = false;
    private static final Map<TileEntity, Object> energyProviders = new MapMaker().weakValues().makeMap();

    @Override
    public String name() {
        return "factorization";
    }

    @Override
    public boolean canLoad() {
        return super.canLoad();
    }

    @Override
    public void preInit() {
        ENABLE_SERVO_RAILS = BuildCraftCompat.instance.getConfig().getBoolean("builderServoRails", "balance", true, "Should Builders place (pre-configured) Servo Rails?");
    }

    @Override
    public void init() {
        if (Loader.isModLoaded((String)"BuildCraft|Builders")) {
            this.initBuilders();
        }
    }

    @Optional.Method(modid="BuildCraft|Builders")
    private void initBuilders() {
        CompatUtils.registerSchematic("factorization:FzBlock", 1, SchematicFZBase.class, new Object[0]);
        CompatUtils.registerSchematic("factorization:FzBlock", 2, SchematicFZBarrel.class, new Object[0]);
        CompatUtils.registerSchematic("factorization:FzBlock", 3, SchematicFZBase.class, new Object[0]);
        CompatUtils.registerSchematic("factorization:FzBlock", 4, SchematicTile.class, new Object[0]);
        CompatUtils.registerSchematic("factorization:FzBlock", 6, SchematicFZBase.class, new Object[0]);
        CompatUtils.registerSchematic("factorization:FzBlock", 7, SchematicFZBase.class, new Object[0]);
        CompatUtils.registerSchematic("factorization:FzBlock", 8, SchematicFZBase.class, new Object[0]);
        CompatUtils.registerSchematic("factorization:FzBlock", 9, SchematicFZBase.class, new Object[0]);
    }

    public static Object getEnergyProvider(TileEntity tile) {
        if (ENABLE_ENERGY && tile instanceof IChargeConductor) {
            if (!energyProviders.containsKey(tile)) {
                energyProviders.put(tile, new ChargeEnergyReceiver(tile));
            }
            return energyProviders.get(tile);
        }
        return null;
    }
}

