/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.utils;

import com.creativemd.creativecore.client.rendering.RenderHelper3D;
import com.creativemd.creativecore.common.utils.CubeObject;
import com.creativemd.littletiles.common.utils.small.LittleTileBox;
import com.creativemd.littletiles.common.utils.small.LittleTileSize;
import com.creativemd.littletiles.common.utils.small.LittleTileVec;
import com.creativemd.littletiles.utils.ShiftHandler;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public abstract class BoxShiftHandler
extends ShiftHandler {
    public ArrayList<LittleTileBox> boxes = new ArrayList();

    @Override
    public void init(World world, int x, int y, int z) {
        this.boxes = this.getBoxes(world, x, y, z);
    }

    public abstract ArrayList<LittleTileBox> getBoxes(World var1, int var2, int var3, int var4);

    @Override
    public void handleRendering(Minecraft mc, double x, double y, double z) {
        for (LittleTileBox box : this.boxes) {
            if (!box.isValidBox()) continue;
            GL11.glPushMatrix();
            CubeObject cube = box.getCube();
            LittleTileSize size = box.getSize();
            double cubeX = x + cube.minX + size.getPosX() / 2.0;
            double cubeY = y + cube.minY + size.getPosY() / 2.0;
            double cubeZ = z + cube.minZ + size.getPosZ() / 2.0;
            RenderHelper3D.renderBlock(cubeX, cubeY, cubeZ, size.getPosX(), size.getPosY(), size.getPosZ(), 0.0, 0.0, 0.0, 1.0, 1.0, 0.5, (Math.sin((double)System.nanoTime() / 2.0E8) + 1.5) * 0.2);
            GL11.glPopMatrix();
        }
    }

    @Override
    public double getDistance(LittleTileVec suggestedPos) {
        double distance = 2.0;
        for (LittleTileBox box : this.boxes) {
            distance = Math.min(distance, box.distanceTo(suggestedPos));
        }
        return 0.0;
    }

    @Override
    protected LittleTileBox getNewPos(World world, int x, int y, int z, LittleTileBox suggested) {
        return null;
    }
}

