/*
 * Decompiled with CFR 0.152.
 */
package pcl.openprinter.tileentity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import li.cil.oc.api.Network;
import li.cil.oc.api.fs.FileSystem;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Component;
import li.cil.oc.api.network.ComponentConnector;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import pcl.openprinter.ContentRegistry;
import pcl.openprinter.OpenPrinter;
import pcl.openprinter.items.PrintedPage;
import pcl.openprinter.items.PrinterInkBlack;
import pcl.openprinter.items.PrinterInkColor;
import pcl.openprinter.items.PrinterPaperRoll;

public class PrinterTE
extends TileEntity
implements Environment,
IInventory,
ISidedInventory {
    public Double PrinterFormatVersion = 2.0;
    protected ComponentConnector node = (ComponentConnector)Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent(this.getComponentName()).withConnector(32.0).create();
    protected boolean addedToNetwork = false;
    private Object oc_fs;
    private ItemStack[] printerItemStacks = new ItemStack[20];
    private List<String> lines = new ArrayList<String>();
    private List<String> align = new ArrayList<String>();
    private List<Integer> colors = new ArrayList<Integer>();
    private String pageTitle = "";
    Integer colorUses = 0;
    Integer blackUses = 0;
    private static final int[] slots_top = new int[]{2};
    private static final int[] slots_bottom = new int[]{3, 4, 5, 6, 7, 8, 9, 10, 11, 12};
    private static final int[] slots_sides = new int[]{0, 1};

    public PrinterTE() {
        if (this.node() != null) {
            this.initOCFilesystem();
        }
    }

    private String getComponentName() {
        return "openprinter";
    }

    protected ManagedEnvironment oc_fs() {
        return (ManagedEnvironment)this.oc_fs;
    }

    private void initOCFilesystem() {
        this.oc_fs = li.cil.oc.api.FileSystem.asManagedEnvironment((FileSystem)li.cil.oc.api.FileSystem.fromClass(OpenPrinter.class, (String)"openprinter", (String)"/lua/printer/"), (String)"printer");
        ((Component)this.oc_fs().node()).setVisibility(Visibility.Network);
    }

    public Node node() {
        return this.node;
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.node != null) {
            this.node.remove();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.node != null) {
            this.node.remove();
        }
    }

    public void onConnect(Node node) {
        if (node == this.node()) {
            node.connect(this.oc_fs().node());
        }
    }

    public void onDisconnect(Node node) {
        if (node.host() instanceof Context) {
            node.disconnect(this.oc_fs().node());
        } else if (node == this.node) {
            this.oc_fs().node().remove();
        }
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.addedToNetwork) {
            this.addToNetwork();
        }
    }

    protected void addToNetwork() {
        if (!this.addedToNetwork) {
            this.addedToNetwork = true;
            Network.joinOrCreateNetwork((TileEntity)this);
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (this.node != null && this.node.host() == this) {
            this.node.load(nbt.func_74775_l("oc:node"));
        }
        if (this.oc_fs != null && this.oc_fs().node() != null) {
            this.oc_fs().node().load(nbt.func_74775_l("oc:fs"));
        }
        NBTTagList var2 = nbt.func_150295_c("Items", (int)nbt.func_74732_a());
        this.printerItemStacks = new ItemStack[this.func_70302_i_()];
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = var2.func_150305_b(var3);
            byte var5 = var4.func_74771_c("Slot");
            if (var5 < 0 || var5 >= this.printerItemStacks.length) continue;
            this.printerItemStacks[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.node != null && this.node.host() == this) {
            NBTTagCompound nodeNbt = new NBTTagCompound();
            this.node.save(nodeNbt);
            nbt.func_74782_a("oc:node", (NBTBase)nodeNbt);
        }
        if (this.oc_fs != null && this.oc_fs().node() != null) {
            NBTTagCompound fsNbt = new NBTTagCompound();
            this.oc_fs().node().save(fsNbt);
            nbt.func_74782_a("oc:fs", (NBTBase)fsNbt);
        }
        NBTTagList var2 = new NBTTagList();
        for (int var3 = 0; var3 < this.printerItemStacks.length; ++var3) {
            if (this.printerItemStacks[var3] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)var3);
            this.printerItemStacks[var3].func_77955_b(var4);
            var2.func_74742_a((NBTBase)var4);
        }
        nbt.func_74782_a("Items", (NBTBase)var2);
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    @Callback
    public Object[] greet(Context context, Arguments args) {
        return new Object[]{"Lasciate ogne speranza, voi ch'intrate"};
    }

    @Callback
    public Object[] scanLine(Context context, Arguments args) {
        ItemStack scannedPage = this.func_70301_a(13);
        if (scannedPage.func_77973_b() instanceof PrintedPage && scannedPage.func_77942_o()) {
            return new Object[]{scannedPage.func_77978_p().func_74779_i("line" + args.checkInteger(0))};
        }
        return new Object[]{false};
    }

    @Callback
    public Object[] scan(Context context, Arguments args) {
        ItemStack scannedPage = this.func_70301_a(13);
        String outPageTitle = null;
        HashMap<Integer, String> output = new HashMap<Integer, String>();
        if (scannedPage.func_77973_b() instanceof PrintedPage) {
            if (scannedPage.field_77990_d.func_74779_i("pageTitle") != null) {
                outPageTitle = scannedPage.field_77990_d.func_74779_i("pageTitle");
            }
            for (int x = 0; x <= 20; ++x) {
                if (!scannedPage.func_77942_o() || !scannedPage.field_77990_d.func_74764_b("line" + x)) continue;
                output.put(x, scannedPage.field_77990_d.func_74779_i("line" + x));
            }
            return new Object[]{outPageTitle, output};
        }
        return new Object[]{false};
    }

    @Callback
    public Object[] printTag(Context context, Arguments args) throws Exception {
        if (OpenPrinter.cfg.enableNameTag) {
            if (this.func_70301_a(0) != null) {
                if (this.func_70301_a(2) != null && this.func_70301_a(2).func_77973_b().equals(Items.field_151057_cb)) {
                    for (int x = 3; x <= 12; ++x) {
                        if (this.func_70301_a(x) != null) continue;
                        this.printerItemStacks[x] = new ItemStack(Items.field_151057_cb);
                        this.printerItemStacks[x].func_77982_d(new NBTTagCompound());
                        NBTTagCompound nameTag = new NBTTagCompound();
                        nameTag.func_74778_a("Name", args.checkString(0));
                        this.printerItemStacks[x].field_77990_d.func_74782_a("display", (NBTBase)nameTag);
                        this.func_70301_a(0).func_77964_b(this.func_70301_a(0).func_77960_j() + 1);
                        if (this.func_70301_a(0).func_77960_j() >= this.func_70301_a(0).func_77958_k()) {
                            this.func_70299_a(0, null);
                        }
                        this.func_70298_a(2, 1);
                        return new Object[]{true};
                    }
                    throw new Exception("No empty output slots.");
                }
                throw new Exception("Please load Name Tags.");
            }
            throw new Exception("Please load Black Ink.");
        }
        throw new Exception("Name Tag printing is disabled.");
    }

    @Callback
    public Object[] print(Context context, Arguments args) throws Exception {
        int copies = args.optInteger(1, 9);
        boolean markColor = false;
        boolean markBlack = false;
        int i = 0;
        if (i < copies) {
            if (this.func_70301_a(0) != null && this.func_70301_a(1) != null) {
                if (this.func_70301_a(2) != null) {
                    for (int x = 3; x <= 12; ++x) {
                        if (this.func_70301_a(x) != null) continue;
                        this.printerItemStacks[x] = new ItemStack(ContentRegistry.printedPage);
                        this.printerItemStacks[x].func_77982_d(new NBTTagCompound());
                        if (this.pageTitle != "") {
                            this.printerItemStacks[x].field_77990_d.func_74778_a("pageTitle", this.pageTitle);
                            this.printerItemStacks[x].func_151001_c(this.pageTitle);
                            this.pageTitle = "";
                        }
                        this.printerItemStacks[x].field_77990_d.func_74780_a("version", this.PrinterFormatVersion.doubleValue());
                        int iter = 0;
                        for (String s : this.lines) {
                            Integer n;
                            Integer n2;
                            this.printerItemStacks[x].field_77990_d.func_74778_a("line" + iter, this.lines.get(iter) + "\u221e" + this.colors.get(iter) + "\u221e" + this.align.get(iter));
                            if (this.colors.get(iter) != 0) {
                                markColor = true;
                                n2 = this.colorUses;
                                n = this.colorUses = Integer.valueOf(this.colorUses + 1);
                            } else {
                                markBlack = true;
                                n2 = this.blackUses;
                                n = this.blackUses = Integer.valueOf(this.blackUses + 1);
                            }
                            if (this.lines.get(iter).matches(".*\u00a7[0-9a-f].*")) {
                                markColor = true;
                                markBlack = false;
                                Pattern regex = Pattern.compile("\u00a7[0-9a-f]*");
                                Matcher matcher = regex.matcher(this.lines.get(iter));
                                while (matcher.find()) {
                                    Integer n3 = this.colorUses;
                                    Integer n4 = this.colorUses = Integer.valueOf(this.colorUses + 1);
                                }
                            }
                            ++iter;
                        }
                        this.lines.clear();
                        this.colors.clear();
                        this.align.clear();
                        if (this.func_70301_a(2).func_77973_b() instanceof PrinterPaperRoll) {
                            this.func_70301_a(2).func_77964_b(this.func_70301_a(2).func_77960_j() + 1);
                            if (this.func_70301_a(2).func_77960_j() >= this.func_70301_a(2).func_77958_k()) {
                                this.func_70299_a(2, null);
                            }
                        } else {
                            this.func_70298_a(2, 1);
                        }
                        if (markColor) {
                            Integer n = this.colorUses;
                            Integer n5 = this.colorUses = Integer.valueOf(this.colorUses + 1);
                            this.func_70301_a(1).func_77964_b(this.func_70301_a(1).func_77960_j() + n);
                            if (this.func_70301_a(1).func_77960_j() >= this.func_70301_a(1).func_77958_k()) {
                                this.func_70299_a(1, null);
                            }
                        }
                        if (markBlack) {
                            this.func_70301_a(0).func_77964_b(this.func_70301_a(0).func_77960_j() + this.blackUses);
                            if (this.func_70301_a(0).func_77960_j() >= this.func_70301_a(0).func_77958_k()) {
                                this.func_70299_a(0, null);
                            }
                        }
                        return new Object[]{true};
                    }
                    throw new Exception("No empty output slots.");
                }
                throw new Exception("Please load Paper.");
            }
            throw new Exception("Please load Ink.");
        }
        return new Object[]{false};
    }

    @Callback
    public Object[] writeln(Context context, Arguments args) throws Exception {
        if (this.lines.size() >= 20) {
            throw new Exception("To many lines.");
        }
        int color = 0;
        String alignment = "left";
        if (args.count() == 2) {
            if (args.isInteger(1)) {
                color = args.checkInteger(1);
            } else if (args.isString(1)) {
                alignment = args.checkString(1);
            }
        }
        if (args.count() == 3) {
            if (args.isInteger(1)) {
                color = args.checkInteger(1);
            } else if (args.isString(2)) {
                alignment = args.checkString(2);
            }
        }
        this.lines.add(args.checkString(0));
        this.colors.add(color);
        this.align.add(alignment);
        return new Object[]{true};
    }

    @Callback
    public Object[] setTitle(Context context, Arguments args) {
        this.pageTitle = args.checkString(0);
        return new Object[]{true};
    }

    @Callback
    public Object[] getPaperLevel(Context context, Arguments args) {
        if (this.func_70301_a(2) != null) {
            if (this.func_70301_a(2).func_77973_b() instanceof PrinterPaperRoll) {
                return new Object[]{256 - this.func_70301_a(2).func_77960_j()};
            }
            return new Object[]{this.func_70301_a((int)2).field_77994_a};
        }
        return new Object[]{false};
    }

    @Callback
    public Object[] getBlackInkLevel(Context context, Arguments args) {
        if (this.func_70301_a(0) != null) {
            if (this.func_70301_a(0).func_77973_b() instanceof PrinterInkBlack) {
                return new Object[]{OpenPrinter.cfg.printerInkUse - this.func_70301_a(0).func_77960_j()};
            }
            return new Object[]{false};
        }
        return new Object[]{false};
    }

    @Callback
    public Object[] getColorInkLevel(Context context, Arguments args) {
        if (this.func_70301_a(1) != null) {
            if (this.func_70301_a(1).func_77973_b() instanceof PrinterInkColor) {
                return new Object[]{OpenPrinter.cfg.printerInkUse - this.func_70301_a(1).func_77960_j()};
            }
            return new Object[]{false};
        }
        return new Object[]{false};
    }

    @Callback(direct=true)
    public Object[] charCount(Context context, Arguments args) {
        return new Object[]{args.checkString(0).replaceAll("(?:\u00a7[0-9a-fk-or])+", "").length()};
    }

    @Callback
    public Object[] clear(Context context, Arguments args) {
        this.lines.clear();
        this.colors.clear();
        this.align.clear();
        this.pageTitle = "";
        return new Object[]{true};
    }

    public int func_70302_i_() {
        return this.printerItemStacks.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.printerItemStacks[i];
    }

    public ItemStack func_70298_a(int slot, int amt) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a <= amt) {
                this.func_70299_a(slot, null);
            } else {
                stack = stack.func_77979_a(amt);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int i) {
        if (this.func_70301_a(i) != null) {
            ItemStack var2 = this.func_70301_a(i);
            this.func_70299_a(i, null);
            return var2;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.printerItemStacks[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && entityplayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) < 64.0;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return i == 0 ? itemstack.func_77973_b() instanceof PrinterInkBlack : (i == 1 ? itemstack.func_77973_b() instanceof PrinterInkColor : i == 2 && (itemstack.func_77973_b() instanceof PrinterPaperRoll || itemstack.func_77973_b().equals(Items.field_151121_aF) || itemstack.func_77973_b().equals(Items.field_151057_cb)));
    }

    public int[] func_94128_d(int par1) {
        return par1 == 0 ? slots_bottom : (par1 == 1 ? slots_top : slots_sides);
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return this.func_94041_b(i, itemstack);
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return true;
    }

    public String func_145825_b() {
        return "openprinter";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public void onMessage(Message arg0) {
    }
}

