/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import crazypants.enderio.gui.GuiContainerBaseEIO;
import crazypants.enderio.machine.enchanter.EnchanterRecipe;
import crazypants.enderio.machine.enchanter.EnchanterRecipeManager;
import crazypants.enderio.machine.enchanter.GuiEnchanter;
import crazypants.enderio.machine.enchanter.TileEnchanter;
import crazypants.enderio.machine.recipe.RecipeInput;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public class EnchanterRecipeHandler
extends TemplateRecipeHandler {
    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"enderio.nei.enchanter");
    }

    public String getGuiTexture() {
        return GuiContainerBaseEIO.getGuiTexture("enchanter").toString();
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiEnchanter.class;
    }

    public String getOverlayIdentifier() {
        return "EIOEnchanter";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(97, 24, 22, 17), "EIOEnchanter", new Object[0]));
    }

    public void loadCraftingRecipes(ItemStack result) {
        if (result == null || result.func_77973_b() != Items.field_151134_bR) {
            return;
        }
        Map enchants = EnchantmentHelper.func_82781_a((ItemStack)result);
        List<EnchanterRecipe> recipes = EnchanterRecipeManager.getInstance().getRecipes();
        Iterator iterator = enchants.keySet().iterator();
        while (iterator.hasNext()) {
            Enchantment ench;
            int id = (Integer)iterator.next();
            if (id < 0 || id >= Enchantment.field_77331_b.length || (ench = Enchantment.field_77331_b[id]) == null || ench.func_77320_a() == null) continue;
            for (EnchanterRecipe recipe : recipes) {
                if (!recipe.isValid() || !recipe.getEnchantment().func_77320_a().equals(ench.func_77320_a())) continue;
                EnchanterRecipeNEI rec = new EnchanterRecipeNEI(recipe);
                this.arecipes.add(rec);
            }
        }
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("EIOEnchanter") && ((Object)((Object)this)).getClass() == EnchanterRecipeHandler.class) {
            List<EnchanterRecipe> recipes = EnchanterRecipeManager.getInstance().getRecipes();
            for (EnchanterRecipe recipe : recipes) {
                if (!recipe.isValid()) continue;
                EnchanterRecipeNEI rec = new EnchanterRecipeNEI(recipe);
                this.arecipes.add(rec);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        List<EnchanterRecipe> recipes = EnchanterRecipeManager.getInstance().getRecipes();
        for (EnchanterRecipe recipe : recipes) {
            EnchanterRecipeNEI rec;
            if (!recipe.isValid() || !(rec = new EnchanterRecipeNEI(recipe)).contains(rec.input, ingredient)) continue;
            rec.setIngredientPermutation(rec.input, ingredient);
            this.arecipes.add(rec);
        }
    }

    public void drawExtras(int recipeIndex) {
        int cost;
        EnchanterRecipeNEI recipe = (EnchanterRecipeNEI)((Object)this.arecipes.get(recipeIndex));
        GuiDraw.drawStringC((String)recipe.getEnchantName(), (int)83, (int)10, (int)0x808080, (boolean)false);
        int level = 1;
        List<PositionedStack> ingredients = recipe.getIngredients();
        if (ingredients != null && ingredients.size() == 2) {
            ItemStack item = ingredients.get((int)1).item;
            level = recipe.recipe.getLevelForStackSize(item.field_77994_a);
        }
        if ((cost = TileEnchanter.getEnchantmentCost(recipe.recipe, level)) > 0) {
            String s = I18n.func_135052_a((String)"container.repair.cost", (Object[])new Object[]{cost});
            GuiDraw.drawStringC((String)s, (int)83, (int)46, (int)8453920);
        }
    }

    public List<ItemStack> getInputs(RecipeInput input) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        result.add(input.getInput());
        ItemStack[] equivs = input.getEquivelentInputs();
        if (equivs != null && equivs.length > 0) {
            result.addAll(Arrays.asList(equivs));
        }
        return result;
    }

    public class EnchanterRecipeNEI
    extends TemplateRecipeHandler.CachedRecipe {
        private final ArrayList<PositionedStack> input;
        private final PositionedStack output;
        private final EnchanterRecipe recipe;

        public String getEnchantName() {
            int maxLevel = this.recipe.getEnchantment().func_77325_b();
            if (maxLevel > 1) {
                int cycle = EnchanterRecipeHandler.this.cycleticks / 20;
                int level = cycle % maxLevel + 1;
                return this.recipe.getEnchantment().func_77316_c(level);
            }
            return StatCollector.func_74838_a((String)this.recipe.getEnchantment().func_77320_a());
        }

        public List<PositionedStack> getIngredients() {
            int cycle = EnchanterRecipeHandler.this.cycleticks / 20;
            this.getCycledIngredients(cycle, this.input);
            int maxLevel = this.recipe.getEnchantment().func_77325_b();
            if (maxLevel > 1) {
                int level = cycle % maxLevel + 1;
                this.input.get((int)1).item.field_77994_a = this.recipe.getItemsPerLevel() * level;
            }
            return this.input;
        }

        public PositionedStack getResult() {
            int cycle = EnchanterRecipeHandler.this.cycleticks / 20;
            this.output.setPermutationToRender(cycle % this.output.items.length);
            return this.output;
        }

        public EnchanterRecipeNEI(EnchanterRecipe recipe) {
            super((TemplateRecipeHandler)EnchanterRecipeHandler.this);
            this.recipe = recipe;
            this.input = new ArrayList();
            this.input.add(new PositionedStack((Object)new ItemStack(Items.field_151099_bA), 22, 24));
            this.input.add(new PositionedStack(EnchanterRecipeHandler.this.getInputs(recipe.getInput()), 71, 24));
            int maxLevel = recipe.getEnchantment().func_77325_b();
            ItemStack[] outputItems = new ItemStack[maxLevel];
            for (int level = 0; level < maxLevel; ++level) {
                EnchantmentData enchantment = new EnchantmentData(recipe.getEnchantment(), level + 1);
                outputItems[level] = new ItemStack((Item)Items.field_151134_bR);
                Items.field_151134_bR.func_92115_a(outputItems[level], enchantment);
            }
            this.output = new PositionedStack((Object)outputItems, 129, 24);
        }
    }
}

