/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.ClientHandler;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.PresetsList;
import codechicken.nei.api.ItemFilter;
import codechicken.nei.filter.AnyMultiItemFilter;
import codechicken.nei.filter.EverythingItemFilter;
import codechicken.nei.filter.NothingItemFilter;
import codechicken.nei.util.ItemStackFilterParser;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;

public class CollapsibleItems {
    private static final String STATE_KEY = "collapsibleitems";
    protected static File statesFile;
    protected static final List<GroupItem> groups;
    protected static final Map<ItemStack, Integer> cache;

    private CollapsibleItems() {
    }

    public static void load() {
        groups.clear();
        cache.clear();
        for (int i = PresetsList.presets.size() - 1; i >= 0; --i) {
            PresetsList.Preset preset = PresetsList.presets.get(i);
            if (!preset.enabled || preset.mode != PresetsList.PresetMode.GROUP) continue;
            GroupItem group = new GroupItem();
            group.setFilter(preset, UUID.nameUUIDFromBytes(preset.items.toString().getBytes()).toString());
            group.displayName = preset.name;
            CollapsibleItems.addGroup(group);
        }
        if (NEIClientConfig.enableCollapsibleItems()) {
            ClientHandler.loadSettingsFile("collapsibleitems.cfg", lines -> CollapsibleItems.parseFile(lines.collect(Collectors.toCollection(ArrayList::new))));
        }
        CollapsibleItems.loadStates();
    }

    private static void parseFile(List<String> itemStrings) {
        JsonParser parser = new JsonParser();
        GroupItem group = new GroupItem();
        for (String itemStr : itemStrings) {
            try {
                if (itemStr.startsWith("; ")) {
                    String unlocalizedName;
                    String displayName;
                    JsonObject settings = parser.parse(itemStr.substring(2)).getAsJsonObject();
                    if (settings.get("displayName") != null) {
                        group.displayName = settings.get("displayName").getAsString();
                    }
                    if (settings.get("unlocalizedName") != null && !(displayName = StatCollector.func_74838_a((String)(unlocalizedName = settings.get("unlocalizedName").getAsString()))).equals(unlocalizedName)) {
                        group.displayName = displayName;
                    }
                    if (settings.get("expanded") != null) {
                        group.expanded = settings.get("expanded").getAsBoolean();
                    }
                } else {
                    group.setFilter(itemStr);
                }
                if (group == null || group.filter == null) continue;
                CollapsibleItems.addGroup(group);
                group = new GroupItem();
            }
            catch (JsonSyntaxException | IllegalArgumentException | IllegalStateException e) {
                NEIClientConfig.logger.error("Failed to load collapsible items from json string:\n{}", new Object[]{itemStr});
            }
        }
    }

    private static void addGroup(GroupItem group) {
        if (group == null || group.filter == null || group.filter instanceof EverythingItemFilter || group.filter instanceof NothingItemFilter) {
            return;
        }
        groups.add(group);
    }

    public static boolean isEmpty() {
        return groups.isEmpty();
    }

    public static ItemFilter getItemFilter() {
        AnyMultiItemFilter filter = new AnyMultiItemFilter();
        for (GroupItem group : groups) {
            filter.filters.add(group.filter);
        }
        return filter;
    }

    public static void clearCache() {
        cache.clear();
    }

    public static void putItem(ItemStack stack) {
        int groupIndex = -1;
        for (int i = 0; i < groups.size() && groupIndex == -1; ++i) {
            if (!groups.get(i).matches(stack)) continue;
            groupIndex = i;
        }
        if (groupIndex != -1) {
            cache.put(stack, groupIndex);
        }
    }

    public static int getGroupIndex(ItemStack stack) {
        if (stack == null) {
            return -1;
        }
        return cache.getOrDefault(stack, -1);
    }

    public static String getDisplayName(int groupIndex) {
        if (groupIndex < groups.size()) {
            return CollapsibleItems.groups.get((int)groupIndex).displayName;
        }
        return null;
    }

    public static boolean isExpanded(int groupIndex) {
        if (groupIndex < groups.size()) {
            return CollapsibleItems.groups.get((int)groupIndex).expanded;
        }
        return true;
    }

    public static void setExpanded(int groupIndex, boolean expanded) {
        if (groupIndex < groups.size()) {
            CollapsibleItems.groups.get((int)groupIndex).expanded = expanded;
        }
    }

    public static void toggleGroups(Boolean expanded) {
        if (expanded == null) {
            expanded = groups.stream().noneMatch(g -> g.expanded);
        }
        for (GroupItem group : groups) {
            group.expanded = expanded;
        }
    }

    public static void saveStates() {
        NBTTagCompound list = new NBTTagCompound();
        for (GroupItem group : groups) {
            list.func_74757_a(group.guid, group.expanded);
        }
        if (NEIClientConfig.world != null) {
            NEIClientConfig.world.nbt.func_74782_a(STATE_KEY, (NBTBase)list);
        }
    }

    private static void loadStates() {
        try {
            if (NEIClientConfig.world.nbt.func_74764_b(STATE_KEY)) {
                NBTTagCompound states = NEIClientConfig.world.nbt.func_74775_l(STATE_KEY);
                Map list = states.field_74784_a;
                HashMap<String, GroupItem> mapping = new HashMap<String, GroupItem>();
                for (GroupItem groupItem : groups) {
                    mapping.put(groupItem.guid, groupItem);
                }
                for (Map.Entry entry : list.entrySet()) {
                    if (!mapping.containsKey(entry.getKey())) continue;
                    ((GroupItem)mapping.get(entry.getKey())).expanded = ((NBTBase.NBTPrimitive)entry.getValue()).func_150290_f() == 1;
                }
            }
        }
        catch (Exception e) {
            NEIClientConfig.logger.error("Error loading collapsible items states", (Throwable)e);
        }
    }

    static {
        groups = new ArrayList<GroupItem>();
        cache = new ConcurrentHashMap<ItemStack, Integer>();
    }

    protected static class GroupItem {
        public String guid;
        public ItemFilter filter;
        public boolean expanded = false;
        public String displayName = "";

        protected GroupItem() {
        }

        public void setFilter(String filter) {
            this.filter = ItemStackFilterParser.parse(filter.trim());
            this.guid = this.filter != null ? UUID.nameUUIDFromBytes(filter.getBytes()).toString() : "";
        }

        public void setFilter(ItemFilter filter, String guid) {
            this.filter = filter;
            this.guid = guid;
        }

        public boolean matches(ItemStack stack) {
            return this.filter.matches(stack);
        }
    }
}

