/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.search;

import codechicken.nei.SearchTokenParser;
import codechicken.nei.api.IRecipeFilter;
import codechicken.nei.api.ItemFilter;
import codechicken.nei.filter.AllIngredientsRecipeFilter;
import codechicken.nei.filter.AllMultiRecipeFilter;
import codechicken.nei.filter.AllOthersRecipeFilter;
import codechicken.nei.filter.AllSmartResultRecipeFilter;
import codechicken.nei.filter.AnyIngredientsRecipeFilter;
import codechicken.nei.filter.AnyItemRecipeFilter;
import codechicken.nei.filter.AnyOthersRecipeFilter;
import codechicken.nei.filter.AnySmartResultRecipeFilter;
import codechicken.nei.filter.EverythingItemFilter;
import codechicken.nei.search.AbstractSearchExpressionVisitor;
import codechicken.nei.search.ItemFilterVisitor;
import codechicken.nei.search.SearchExpressionParser;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class RecipeFilterVisitor
extends AbstractSearchExpressionVisitor<IRecipeFilter> {
    private final ItemFilterVisitor itemFilterVisitor;

    public RecipeFilterVisitor(SearchTokenParser searchParser) {
        super(searchParser);
        this.itemFilterVisitor = new ItemFilterVisitor(searchParser);
    }

    @Override
    public IRecipeFilter visitRecipeSearchExpression(SearchExpressionParser.RecipeSearchExpressionContext ctx) {
        if (ctx.recipeClauseExpression() != null) {
            ArrayList<IRecipeFilter> filters = new ArrayList<IRecipeFilter>();
            for (SearchExpressionParser.RecipeClauseExpressionContext clauseCtx : ctx.recipeClauseExpression()) {
                filters.add(this.createRecipeFilter(clauseCtx.searchExpression()));
            }
            return this.constructFilter(filters);
        }
        return this.defaultResult();
    }

    @Override
    protected IRecipeFilter defaultResult() {
        return new AnyItemRecipeFilter(new EverythingItemFilter());
    }

    private IRecipeFilter createRecipeFilter(SearchExpressionParser.SearchExpressionContext ctx) {
        if (ctx == null) {
            return this.defaultResult();
        }
        ItemFilter itemFilter = (ItemFilter)this.itemFilterVisitor.visitSearchExpression(ctx);
        switch (ctx.type) {
            case 0: {
                return this.getAllOrAnyFilter(ctx.allRecipe, itemFilter, AnyIngredientsRecipeFilter::new, AllIngredientsRecipeFilter::new);
            }
            case 1: {
                return this.getAllOrAnyFilter(ctx.allRecipe, itemFilter, AnySmartResultRecipeFilter::new, AllSmartResultRecipeFilter::new);
            }
            case 2: {
                return this.getAllOrAnyFilter(ctx.allRecipe, itemFilter, AnyOthersRecipeFilter::new, AllOthersRecipeFilter::new);
            }
            case 3: {
                return this.getAllOrAnyFilter(ctx.allRecipe, itemFilter, AnyItemRecipeFilter::new, AnyItemRecipeFilter::new);
            }
        }
        return this.defaultResult();
    }

    private IRecipeFilter getAllOrAnyFilter(boolean allRecipe, ItemFilter itemFilter, Function<ItemFilter, IRecipeFilter> createAnyFilter, Function<ItemFilter, IRecipeFilter> createAllFilter) {
        if (allRecipe) {
            return createAllFilter.apply(itemFilter);
        }
        return createAnyFilter.apply(itemFilter);
    }

    private IRecipeFilter constructFilter(List<IRecipeFilter> filters) {
        if (!filters.isEmpty()) {
            if (filters.size() == 1) {
                return filters.get(0);
            }
            return new AllMultiRecipeFilter(filters);
        }
        return this.defaultResult();
    }
}

