/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.search;

import codechicken.nei.NEIClientConfig;
import codechicken.nei.SearchTokenParser;
import codechicken.nei.search.AbstractSearchExpressionVisitor;
import codechicken.nei.search.SearchExpressionParser;
import codechicken.nei.search.SearchExpressionUtils;
import codechicken.nei.shadow.org.antlr.v4.runtime.ParserRuleContext;
import codechicken.nei.shadow.org.antlr.v4.runtime.tree.ParseTree;
import codechicken.nei.shadow.org.antlr.v4.runtime.tree.RuleNode;
import codechicken.nei.shadow.org.antlr.v4.runtime.tree.TerminalNode;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.util.EnumChatFormatting;

public class SearchExpressionFormatVisitor
extends AbstractSearchExpressionVisitor<String> {
    private static final Pattern REGEX_ESCAPED_SPACE_PATTERN = Pattern.compile("([^\\\\](?:\\\\\\\\)+)?\\\\ ");
    private static final Pattern ESCAPED_SPACE_PATTERN = Pattern.compile("\\\\ ");

    public SearchExpressionFormatVisitor(SearchTokenParser searchParser) {
        super(searchParser);
    }

    @Override
    public String visitChildren(RuleNode node) {
        if (node instanceof ParserRuleContext) {
            return this.visitChildren((ParserRuleContext)node, null);
        }
        return this.defaultResult();
    }

    @Override
    public String visitPrefixedExpression(SearchExpressionParser.PrefixedExpressionContext ctx) {
        EnumChatFormatting format = this.getFormatting(ctx.prefix, null);
        return format + String.valueOf(ctx.prefix) + this.visitToken(ctx.token());
    }

    @Override
    public String visitToken(SearchExpressionParser.TokenContext ctx) {
        return this.getTokenCleanText(ctx, ctx.prefix);
    }

    @Override
    public String visitRegex(SearchExpressionParser.RegexContext ctx) {
        return this.visitChildren(ctx, ctx.prefix);
    }

    @Override
    public String visitQuoted(SearchExpressionParser.QuotedContext ctx) {
        return this.visitChildren(ctx, ctx.prefix);
    }

    @Override
    protected String defaultResult() {
        return "";
    }

    private String getTokenCleanText(SearchExpressionParser.TokenContext ctx, Character prefix) {
        String cleanText = null;
        int spaceModeEnabled = NEIClientConfig.getIntSetting("inventory.search.spaceMode");
        if (ctx.PLAIN_TEXT() != null) {
            cleanText = ctx.PLAIN_TEXT().getSymbol().getText();
            if (spaceModeEnabled == 1) {
                cleanText = ESCAPED_SPACE_PATTERN.matcher(cleanText).replaceAll(" ");
            }
            EnumChatFormatting format = this.getFormatting(prefix, EnumChatFormatting.RESET);
            return format + cleanText;
        }
        if (ctx.regex() != null) {
            cleanText = this.visitRegex(ctx.regex());
            if (spaceModeEnabled == 1) {
                cleanText = REGEX_ESCAPED_SPACE_PATTERN.matcher(cleanText).replaceAll("$1 ");
            }
        } else if (ctx.quoted() != null) {
            cleanText = this.visitQuoted(ctx.quoted());
            if (spaceModeEnabled == 1) {
                cleanText = ESCAPED_SPACE_PATTERN.matcher(cleanText).replaceAll(" ");
            }
        }
        return cleanText;
    }

    private String formatChild(ParseTree child, Character prefix) {
        if (child instanceof TerminalNode) {
            TerminalNode node = (TerminalNode)child;
            int type = node.getSymbol().getType();
            String format = Optional.ofNullable(Optional.ofNullable(SearchExpressionUtils.getHighlight(type)).orElse(this.getFormatting(prefix, null))).map(EnumChatFormatting::toString).orElse("");
            return format + node.getSymbol().getText();
        }
        return (String)this.visit(child);
    }

    private String visitChildren(ParserRuleContext node, Character prefix) {
        if (node.children != null && !node.children.isEmpty()) {
            return node.children.stream().map(child -> this.formatChild((ParseTree)child, prefix)).collect(Collectors.joining());
        }
        return this.defaultResult();
    }

    private EnumChatFormatting getFormatting(Character prefix, EnumChatFormatting defaultFormatting) {
        if (prefix != null) {
            if (prefix.charValue() == '\u0000') {
                return EnumChatFormatting.RESET;
            }
            SearchTokenParser.ISearchParserProvider provider = this.searchParser.getProvider(prefix.charValue());
            if (provider != null) {
                return provider.getHighlightedColor();
            }
        }
        return defaultFormatting;
    }
}

