/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.items;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.items.interfaces.IBindable;
import WayofTime.alchemicalWizardry.common.entity.projectile.EnergyBlastProjectile;
import WayofTime.alchemicalWizardry.common.items.EnergyItems;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class EnergyBlast
extends EnergyItems {
    @SideOnly(value=Side.CLIENT)
    public IIcon activeIcon;
    @SideOnly(value=Side.CLIENT)
    public IIcon activeIconTier2;
    @SideOnly(value=Side.CLIENT)
    public IIcon activeIconTier3;
    @SideOnly(value=Side.CLIENT)
    public IIcon passiveIcon;
    public int tier;
    public int damage;

    public EnergyBlast(int tier) {
        this.func_77625_d(1);
        this.func_77637_a(AlchemicalWizardry.tabBloodMagic);
        this.func_77655_b("energyBlaster");
        this.func_77664_n();
        this.func_77656_e(250);
        this.tier = tier;
        switch (this.tier) {
            case 1: {
                this.setEnergyUsed(AlchemicalWizardry.energyBlastLPPerShot);
                this.damage = AlchemicalWizardry.energyBlastDamage;
                break;
            }
            case 2: {
                this.setEnergyUsed(AlchemicalWizardry.energyBlastSecondTierLPPerShot);
                this.damage = AlchemicalWizardry.energyBlastSecondTierDamage;
                break;
            }
            case 3: {
                this.setEnergyUsed(AlchemicalWizardry.energyBlastThirdTierLPPerShot);
                this.damage = AlchemicalWizardry.energyBlastThirdTierDamage;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("AlchemicalWizardry:EnergyBlaster_activated");
        this.activeIcon = iconRegister.func_94245_a("AlchemicalWizardry:EnergyBlaster_activated");
        this.activeIconTier2 = iconRegister.func_94245_a("AlchemicalWizardry:EnergyBlaster2_activated");
        this.activeIconTier3 = iconRegister.func_94245_a("AlchemicalWizardry:EnergyBlaster3_activated");
        this.passiveIcon = iconRegister.func_94245_a("AlchemicalWizardry:SheathedItem");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        if (IBindable.isActive(stack)) {
            IIcon iIcon;
            switch (this.tier) {
                case 2: {
                    iIcon = this.activeIconTier2;
                    break;
                }
                case 3: {
                    iIcon = this.activeIconTier3;
                    break;
                }
                default: {
                    iIcon = this.activeIcon;
                }
            }
            return iIcon;
        }
        return this.passiveIcon;
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (this.getDelay(par1ItemStack) > 0 && IBindable.isActive(par1ItemStack) && !par3EntityPlayer.func_70093_af()) {
            return par1ItemStack;
        }
        if (this.checkRightClick(par1ItemStack, par2World, par3EntityPlayer)) {
            this.setDelay(par1ItemStack, this.drainTicks());
            return par1ItemStack;
        }
        par2World.func_72956_a((Entity)par3EntityPlayer, "random.bow", 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
        if (!par2World.field_72995_K) {
            this.shoot(par2World, par3EntityPlayer);
            this.setDelay(par1ItemStack, this.getShotDelay());
        }
        return par1ItemStack;
    }

    public void shoot(World par2World, EntityPlayer par3EntityPlayer) {
        par2World.func_72838_d((Entity)new EnergyBlastProjectile(par2World, (EntityLivingBase)par3EntityPlayer, this.damage));
    }

    public void func_77663_a(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5) {
        if (!(par3Entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer par3EntityPlayer = (EntityPlayer)par3Entity;
        int delay = this.getDelay(par1ItemStack);
        if (!par2World.field_72995_K && delay > 0) {
            this.setDelay(par1ItemStack, delay - 1);
        }
        this.checkPassiveDrain(par1ItemStack, par2World, par3EntityPlayer);
        par1ItemStack.func_77964_b(0);
    }

    public int getShotDelay() {
        switch (this.tier) {
            case 1: {
                return AlchemicalWizardry.energyBlastMaxDelay;
            }
            case 2: {
                return AlchemicalWizardry.energyBlastSecondTierMaxDelay;
            }
            case 3: {
                return AlchemicalWizardry.energyBlastThirdTierMaxDelay;
            }
        }
        return 1;
    }

    @Override
    public int drainTicks() {
        switch (this.tier) {
            case 1: {
                return AlchemicalWizardry.energyBlastMaxDelayAfterActivation;
            }
            case 2: {
                return AlchemicalWizardry.energyBlastSecondTierMaxDelayAfterActivation;
            }
            case 3: {
                return AlchemicalWizardry.energyBlastThirdTierMaxDelayAfterActivation;
            }
        }
        return 1;
    }

    @Override
    public int drainCost() {
        switch (this.tier) {
            case 1: {
                return AlchemicalWizardry.energyBlastLPPerActivation;
            }
            case 2: {
                return AlchemicalWizardry.energyBlastSecondTierLPPerActivation;
            }
            case 3: {
                return AlchemicalWizardry.energyBlastThirdTierLPPerActivation;
            }
        }
        return 0;
    }

    @Override
    public int rightClickCost() {
        return this.getEnergyUsed();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        par3List.add(StatCollector.func_74838_a((String)"tooltip.energyblast.desc1"));
        par3List.add(StatCollector.func_74838_a((String)"tooltip.energyblast.desc2"));
        par3List.add(StatCollector.func_74838_a((String)"tooltip.alchemy.damage") + " " + this.damage);
        this.addBindingInformation(par1ItemStack, par3List);
    }

    public void setDelay(ItemStack par1ItemStack, int delay) {
        IBindable.getTag(par1ItemStack).func_74768_a("delay", delay);
    }

    public int getDelay(ItemStack par1ItemStack) {
        return IBindable.getTag(par1ItemStack).func_74762_e("delay");
    }
}

