/*
 * Decompiled with CFR 0.152.
 */
package cofh.repack.codechicken.lib.render.uv;

import cofh.repack.codechicken.lib.math.MathHelper;
import cofh.repack.codechicken.lib.render.uv.UV;
import cofh.repack.codechicken.lib.render.uv.UVTransformation;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public class UVRotation
extends UVTransformation {
    public double angle;

    public UVRotation(double d) {
        this.angle = d;
    }

    @Override
    public void apply(UV uV) {
        double d = MathHelper.cos(this.angle);
        double d2 = MathHelper.sin(this.angle);
        double d3 = d * uV.u + d2 * uV.v;
        uV.v = -d2 * uV.u + d * uV.v;
        uV.u = d3;
    }

    @Override
    public UVTransformation inverse() {
        return new UVRotation(-this.angle);
    }

    @Override
    public UVTransformation merge(UVTransformation uVTransformation) {
        if (uVTransformation instanceof UVRotation) {
            return new UVRotation(this.angle + ((UVRotation)uVTransformation).angle);
        }
        return null;
    }

    @Override
    public boolean isRedundant() {
        return MathHelper.between(-1.0E-5, this.angle, 1.0E-5);
    }

    public String toString() {
        MathContext mathContext = new MathContext(4, RoundingMode.HALF_UP);
        return "UVRotation(" + new BigDecimal(this.angle, mathContext) + ")";
    }
}

