/*
 * Decompiled with CFR 0.152.
 */
package cofh.repack.codechicken.lib.render.uv;

import cofh.repack.codechicken.lib.math.MathHelper;
import cofh.repack.codechicken.lib.render.uv.UV;
import cofh.repack.codechicken.lib.render.uv.UVTransformation;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public class UVTranslation
extends UVTransformation {
    public double du;
    public double dv;

    public UVTranslation(double d, double d2) {
        this.du = d;
        this.dv = d2;
    }

    @Override
    public void apply(UV uV) {
        uV.u += this.du;
        uV.v += this.dv;
    }

    @Override
    public UVTransformation at(UV uV) {
        return this;
    }

    @Override
    public UVTransformation inverse() {
        return new UVTranslation(-this.du, -this.dv);
    }

    @Override
    public UVTransformation merge(UVTransformation uVTransformation) {
        if (uVTransformation instanceof UVTranslation) {
            UVTranslation uVTranslation = (UVTranslation)uVTransformation;
            return new UVTranslation(this.du + uVTranslation.du, this.dv + uVTranslation.dv);
        }
        return null;
    }

    @Override
    public boolean isRedundant() {
        return MathHelper.between(-1.0E-5, this.du, 1.0E-5) && MathHelper.between(-1.0E-5, this.dv, 1.0E-5);
    }

    public String toString() {
        MathContext mathContext = new MathContext(4, RoundingMode.HALF_UP);
        return "UVTranslation(" + new BigDecimal(this.du, mathContext) + ", " + new BigDecimal(this.dv, mathContext) + ")";
    }
}

