/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.api;

public final class Formatter {
    public static final String INTEGER_FORMAT = "%,d";
    public static final String FLOAT_FORMAT = "%.2f";

    private Formatter() {
    }

    public static String formatInteger(long i) {
        return String.format(INTEGER_FORMAT, i);
    }

    public static String smartFormatInteger(long i) {
        if (i >= 10000000L) {
            return String.format(INTEGER_FORMAT, Math.round((float)i / 1000000.0f)) + "M";
        }
        if (i >= 100000L) {
            return String.format(INTEGER_FORMAT, Math.round((float)i / 1000.0f)) + "K";
        }
        return String.format(INTEGER_FORMAT, i);
    }

    public static String formatFloat(double d) {
        return String.format(FLOAT_FORMAT, d);
    }
}

