/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs.entity.witch;

import com.kuba6000.mobsinfo.api.MobDrop;
import cpw.mods.fml.common.Optional;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import toast.specialMobs._SpecialMobs;
import toast.specialMobs.entity.SpecialMobData;
import toast.specialMobs.entity.spider.EntityBabySpider;
import toast.specialMobs.entity.spider.EntitySmallSpider;
import toast.specialMobs.entity.spider.Entity_SpecialSpider;
import toast.specialMobs.entity.witch.Entity_SpecialWitch;

public class EntityWildsWitch
extends Entity_SpecialWitch {
    public static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation(_SpecialMobs.TEXTURE_PATH + "witch/wilds.png")};
    public byte spiderCount;
    public byte babyCount;
    public byte babiesPerSpawn = (byte)3;

    public EntityWildsWitch(World world) {
        super(world);
        this.getSpecialData().setTextures(TEXTURES);
        this.getSpecialData().isImmuneToWebs = true;
        this.spiderCount = (byte)(this.field_70146_Z.nextInt(4) + 1);
        this.babyCount = (byte)(this.field_70146_Z.nextInt(3) + 2);
    }

    @Override
    public void adjustTypeAttributes() {
        this.getSpecialData().multAttribute(SharedMonsterAttributes.field_111263_d, 0.7);
    }

    @Override
    public void tryDrinkPotion() {
        if (this.potionThrowDelay <= 0) {
            EntityLivingBase riding;
            EntityLivingBase entityLivingBase = riding = this.field_70154_o instanceof EntityLivingBase ? (EntityLivingBase)this.field_70154_o : null;
            if (riding != null && riding.func_70027_ad() && !riding.func_70644_a(Potion.field_76426_n)) {
                this.drinkPotion(16387);
            } else if (this.func_70027_ad() && !this.func_70644_a(Potion.field_76426_n)) {
                this.drinkPotion(8195);
            } else if (this.field_70146_Z.nextFloat() < 0.2f && riding != null && riding.func_70055_a(Material.field_151586_h) && !riding.func_70644_a(Potion.field_76427_o) || this.field_70146_Z.nextFloat() < 0.15f && this.func_70055_a(Material.field_151586_h) && !this.func_70644_a(Potion.field_76427_o)) {
                if (riding != null && riding.func_70055_a(Material.field_151586_h) && !riding.func_70644_a(Potion.field_76427_o)) {
                    this.drinkPotion(16397);
                } else {
                    this.drinkPotion(8205);
                }
            } else if (this.field_70146_Z.nextFloat() < 0.1f && riding != null && riding.func_110143_aJ() < riding.func_110138_aP() || this.field_70146_Z.nextFloat() < 0.05f && this.func_110143_aJ() < this.func_110138_aP()) {
                if (riding != null && riding.func_110143_aJ() < riding.func_110138_aP()) {
                    this.drinkPotion(16389);
                } else {
                    this.drinkPotion(8197);
                }
            } else if (this.spiderCount > 0 && this.field_70154_o == null) {
                if (this.field_70146_Z.nextFloat() < 0.1f && this.func_70638_az() != null) {
                    this.potionThrowDelay = 8;
                    this.spiderCount = (byte)(this.spiderCount - 1);
                    Entity_SpecialSpider spider = new Entity_SpecialSpider(this.field_70170_p);
                    spider.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
                    if (!this.field_70170_p.func_72945_a((Entity)spider, spider.field_70121_D).isEmpty()) {
                        spider = new EntitySmallSpider(this.field_70170_p);
                        spider.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
                    }
                    spider.func_110161_a(null);
                    spider.isHostile = true;
                    spider.func_70784_b((Entity)this.func_70638_az());
                    SpecialMobData data = spider.getSpecialData();
                    data.arrowRefireMin = 0;
                    data.arrowRefireMax = 0;
                    data.arrowRange = 0.0f;
                    this.field_70170_p.func_72838_d((Entity)spider);
                    this.func_70078_a((Entity)spider);
                    this.field_70170_p.func_72956_a((Entity)spider, "mob.ghast.fireball", 0.5f, 2.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
                }
            } else if (this.field_70146_Z.nextFloat() < 0.2f && riding != null && this.func_70638_az() != null && !riding.func_70644_a(Potion.field_76424_c) && this.func_70638_az().func_70068_e((Entity)this) > 121.0) {
                this.drinkPotion(16418);
            } else if (this.field_70146_Z.nextFloat() < 0.1f && riding == null && this.func_70638_az() != null && !this.func_70644_a(Potion.field_76424_c) && this.func_70638_az().func_70068_e((Entity)this) > 121.0) {
                this.drinkPotion(16386);
            } else {
                this.tryDrinkPotionByType();
            }
        }
    }

    @Override
    public void func_82196_d(EntityLivingBase target, float range) {
        if (this.babyCount > 0 && this.field_70146_Z.nextInt(4) == 0) {
            this.babyCount = (byte)(this.babyCount - 1);
            EntityBabySpider baby = null;
            int i = this.babiesPerSpawn;
            while (i-- > 0) {
                baby = new EntityBabySpider(this.field_70170_p);
                baby.func_82149_j((Entity)this);
                baby.func_110161_a(null);
                baby.isHostile = true;
                baby.func_70784_b((Entity)this.func_70638_az());
                SpecialMobData data = baby.getSpecialData();
                data.arrowRefireMin = 0;
                data.arrowRefireMax = 0;
                data.arrowRange = 0.0f;
                this.field_70170_p.func_72838_d((Entity)baby);
            }
            if (baby != null) {
                this.field_70170_p.func_72956_a((Entity)baby, "mob.ghast.fireball", 0.5f, 2.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
                baby.func_70656_aK();
            }
        } else {
            super.func_82196_d(target, range);
        }
    }

    @Override
    protected boolean adjustSplashPotionByType(EntityPotion thrownPotion, EntityLivingBase target, float range, float distance) {
        thrownPotion.func_82340_a(16388);
        if (target.func_110143_aJ() <= 2.0f) {
            super.adjustSplashPotionByType(thrownPotion, target, range, distance);
        }
        return true;
    }

    @Override
    protected void func_70628_a(boolean hit, int looting) {
        super.func_70628_a(hit, looting);
        if (hit && (this.field_70146_Z.nextInt(3) == 0 || this.field_70146_Z.nextInt(1 + looting) > 0)) {
            this.func_145779_a(Items.field_151070_bp, 1);
        }
        if (hit && (this.field_70146_Z.nextInt(3) == 0 || this.field_70146_Z.nextInt(1 + looting) > 0)) {
            this.func_145779_a(Items.field_151071_bq, 1);
        }
    }

    protected void func_70600_l(int superRare) {
        this.func_70099_a(new ItemStack(Items.field_151063_bx, 1, ((Integer)EntityList.field_75624_e.get(EntitySkeleton.class)).intValue()), 0.0f);
    }

    @Override
    @Optional.Method(modid="mobsinfo")
    public void provideDropsInformation(@Nonnull ArrayList<MobDrop> drops) {
        super.provideDropsInformation(drops);
        drops.add(MobDrop.create((ItemStack)new ItemStack(Items.field_151070_bp)).withChance(0.3333).withLooting());
        drops.add(MobDrop.create((ItemStack)new ItemStack(Items.field_151071_bq)).withChance(0.3333).withLooting());
        drops.add(MobDrop.create((ItemStack)new ItemStack(Items.field_151063_bx, 1, ((Integer)EntityList.field_75624_e.get(EntitySkeleton.class)).intValue())).withType(MobDrop.DropType.Rare).withChance(0.025));
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        saveTag.func_74774_a("Spiders", this.spiderCount);
        saveTag.func_74774_a("BabyCount", this.babyCount);
        saveTag.func_74774_a("BabiesPerSpawn", this.babiesPerSpawn);
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        if (saveTag.func_74764_b("Spiders")) {
            this.spiderCount = saveTag.func_74771_c("Spiders");
        } else if (tag.func_74764_b("Spiders")) {
            this.spiderCount = tag.func_74771_c("Spiders");
        }
        if (saveTag.func_74764_b("BabyCount")) {
            this.babyCount = saveTag.func_74771_c("BabyCount");
        } else if (tag.func_74764_b("BabyCount")) {
            this.babyCount = tag.func_74771_c("BabyCount");
        }
        if (saveTag.func_74764_b("BabiesPerSpawn")) {
            this.babiesPerSpawn = saveTag.func_74771_c("BabiesPerSpawn");
        } else if (tag.func_74764_b("BabiesPerSpawn")) {
            this.babiesPerSpawn = tag.func_74771_c("BabiesPerSpawn");
        }
    }
}

