/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.guis.screens;

import gcewing.sg.SGAddressing;
import gcewing.sg.SGCraft;
import gcewing.sg.SGState;
import gcewing.sg.guis.DHDTE;
import gcewing.sg.guis.SGScreen;
import gcewing.sg.guis.widgets.DHDCentreButton;
import gcewing.sg.guis.widgets.DHDSymbolButton;
import gcewing.sg.packets.SGChannel;
import gcewing.sg.tileentities.SGBaseTE;
import gcewing.sg.utils.BaseBlockUtils;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.joml.Vector3i;
import org.lwjgl.opengl.GL11;

public class DHDScreen
extends SGScreen {
    static final int dhdWidth = 192;
    static final int dhdHeight = 192;
    static final int BaseId = 10;
    ResourceLocation background = SGCraft.mod.resourceLocation("textures/gui/dhd/classic_dhd_background.png");
    World world;
    Vector3i pos;
    public int centreX;
    public int centreY;
    int closingDelay = 0;
    int addressLength;
    DHDTE cte;

    public DHDScreen(EntityPlayer player, World world, Vector3i pos) {
        this.world = world;
        this.pos = pos;
        this.cte = this.getControllerTE();
        SGBaseTE te = this.getStargateTE();
        if (te != null) {
            this.addressLength = te.getNumChevrons();
        }
    }

    SGBaseTE getStargateTE() {
        if (this.cte != null) {
            return this.cte.getLinkedStargateTE();
        }
        return null;
    }

    DHDTE getControllerTE() {
        TileEntity te = BaseBlockUtils.getWorldTileEntity((IBlockAccess)this.world, this.pos);
        if (te instanceof DHDTE) {
            return (DHDTE)te;
        }
        return null;
    }

    public String getEnteredAddress() {
        return this.cte.enteredAddress;
    }

    void setEnteredAddress(String address) {
        this.cte.enteredAddress = address;
        SGChannel.sendEnteredAddressToServer(this.cte, address);
    }

    @Override
    public void func_73866_w_() {
        this.centreX = this.field_146294_l / 2;
        this.centreY = this.field_146295_m / 2;
        this.field_146292_n.add(new DHDSymbolButton(11, this.centreX - 88, this.centreY - 28, 0, 0, 28, 27, 1, true, 0, this));
        this.field_146292_n.add(new DHDSymbolButton(12, this.centreX - 82, this.centreY - 53, 28, 0, 31, 31, 2, true, 0, this));
        this.field_146292_n.add(new DHDSymbolButton(13, this.centreX - 69, this.centreY - 73, 59, 0, 34, 34, 3, true, 0, this));
        this.field_146292_n.add(new DHDSymbolButton(14, this.centreX - 46, this.centreY - 85, 93, 0, 29, 31, 4, true, 0, this));
        this.field_146292_n.add(new DHDSymbolButton(15, this.centreX - 21, this.centreY - 88, 122, 0, 28, 26, 5, true, 0, this));
        this.field_146292_n.add(new DHDSymbolButton(16, this.centreX + 7, this.centreY - 87, 150, 0, 28, 29, 6, true, 0, this));
        this.field_146292_n.add(new DHDSymbolButton(17, this.centreX + 26, this.centreY - 80, 178, 0, 33, 33, 7, true, 0, this));
        this.field_146292_n.add(new DHDSymbolButton(18, this.centreX + 44, this.centreY - 64, 211, 0, 33, 33, 8, true, 0, this));
        this.field_146292_n.add(new DHDSymbolButton(19, this.centreX + 56, this.centreY - 40, 0, 93, 30, 28, 9, true, 0, this));
        this.field_146292_n.add(new DHDSymbolButton(20, this.centreX + 62, this.centreY - 14, 30, 93, 26, 28, 10, true, 0, this));
        this.field_146292_n.add(new DHDSymbolButton(21, this.centreX + 56, this.centreY + 12, 0, 0, 30, 28, 11, true, 1, this));
        this.field_146292_n.add(new DHDSymbolButton(22, this.centreX + 44, this.centreY + 31, 30, 0, 33, 33, 12, true, 1, this));
        this.field_146292_n.add(new DHDSymbolButton(23, this.centreX + 26, this.centreY + 47, 63, 0, 33, 33, 13, true, 1, this));
        this.field_146292_n.add(new DHDSymbolButton(24, this.centreX + 7, this.centreY + 58, 96, 0, 28, 29, 14, true, 1, this));
        this.field_146292_n.add(new DHDSymbolButton(25, this.centreX - 21, this.centreY + 62, 124, 0, 28, 26, 15, true, 1, this));
        this.field_146292_n.add(new DHDSymbolButton(26, this.centreX - 46, this.centreY + 54, 152, 0, 29, 31, 16, true, 1, this));
        this.field_146292_n.add(new DHDSymbolButton(27, this.centreX - 69, this.centreY + 39, 181, 0, 34, 34, 17, true, 1, this));
        this.field_146292_n.add(new DHDSymbolButton(28, this.centreX - 82, this.centreY + 22, 215, 0, 31, 31, 18, true, 1, this));
        this.field_146292_n.add(new DHDSymbolButton(29, this.centreX - 88, this.centreY + 1, 0, 84, 28, 27, 19, true, 1, this));
        this.field_146292_n.add(new DHDSymbolButton(30, this.centreX - 61, this.centreY - 19, 0, 0, 29, 18, 20, false, 2, this));
        this.field_146292_n.add(new DHDSymbolButton(31, this.centreX - 57, this.centreY - 36, 29, 0, 30, 25, 21, false, 2, this));
        this.field_146292_n.add(new DHDSymbolButton(32, this.centreX - 47, this.centreY - 49, 59, 0, 28, 29, 22, false, 2, this));
        this.field_146292_n.add(new DHDSymbolButton(33, this.centreX - 32, this.centreY - 58, 87, 0, 22, 30, 23, false, 2, this));
        this.field_146292_n.add(new DHDSymbolButton(34, this.centreX - 14, this.centreY - 60, 109, 0, 18, 29, 24, false, 2, this));
        this.field_146292_n.add(new DHDSymbolButton(35, this.centreX + 3, this.centreY - 61, 127, 0, 20, 30, 25, false, 2, this));
        this.field_146292_n.add(new DHDSymbolButton(36, this.centreX + 14, this.centreY - 55, 147, 0, 27, 30, 26, false, 2, this));
        this.field_146292_n.add(new DHDSymbolButton(37, this.centreX + 23, this.centreY - 44, 174, 0, 30, 27, 27, false, 2, this));
        this.field_146292_n.add(new DHDSymbolButton(38, this.centreX + 30, this.centreY - 28, 204, 0, 30, 22, 28, false, 2, this));
        this.field_146292_n.add(new DHDSymbolButton(39, this.centreX + 33, this.centreY - 9, 0, 90, 28, 18, 29, false, 2, this));
        this.field_146292_n.add(new DHDSymbolButton(40, this.centreX + 30, this.centreY + 6, 28, 90, 30, 22, 30, false, 2, this));
        this.field_146292_n.add(new DHDSymbolButton(41, this.centreX + 23, this.centreY + 18, 58, 90, 30, 27, 31, false, 2, this));
        this.field_146292_n.add(new DHDSymbolButton(42, this.centreX + 14, this.centreY + 25, 88, 90, 27, 30, 32, false, 2, this));
        this.field_146292_n.add(new DHDSymbolButton(43, this.centreX + 3, this.centreY + 31, 115, 90, 20, 30, 33, false, 2, this));
        this.field_146292_n.add(new DHDSymbolButton(44, this.centreX - 14, this.centreY + 32, 135, 90, 18, 29, 34, false, 2, this));
        this.field_146292_n.add(new DHDSymbolButton(45, this.centreX - 32, this.centreY + 28, 153, 90, 22, 30, 35, false, 2, this));
        this.field_146292_n.add(new DHDSymbolButton(46, this.centreX - 47, this.centreY + 21, 175, 90, 28, 29, 36, false, 2, this));
        this.field_146292_n.add(new DHDSymbolButton(47, this.centreX - 57, this.centreY + 12, 203, 90, 30, 25, 37, false, 2, this));
        this.field_146292_n.add(new DHDSymbolButton(48, this.centreX - 61, this.centreY + 1, 0, 180, 29, 18, 38, false, 2, this));
        this.field_146292_n.add(new DHDCentreButton(90, this.centreX - 27, this.centreY - 27, 54, 54, this));
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.closingDelay > 0 && --this.closingDelay == 0) {
            this.setEnteredAddress("");
            this.close();
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l && button.field_146127_k == 90) {
            this.orangeButtonPressed(false);
        }
    }

    void closeAfterDelay(int ticks) {
        this.closingDelay = ticks;
    }

    public void dhdButtonPressed(int i) {
        this.buttonSound();
        if (i >= 37) {
            this.backspace();
        } else {
            this.enterCharacter(SGBaseTE.symbolToChar(i - 1));
        }
    }

    void buttonSound() {
        EntityClientPlayerMP player = this.field_146297_k.field_71439_g;
        PositionedSoundRecord sound = new PositionedSoundRecord(new ResourceLocation("random.click"), 1.0f, 1.0f, (float)player.field_70165_t, (float)player.field_70163_u, (float)player.field_70161_v);
        this.field_146297_k.func_147118_V().func_147682_a((ISound)sound);
    }

    @Override
    public void func_73869_a(char c, int key) {
        if (key == 1) {
            this.close();
        } else if (key == 14 || key == 211) {
            this.backspace();
        } else if (key == 28 || key == 156) {
            this.orangeButtonPressed(true);
        } else {
            String C = String.valueOf(c).toUpperCase();
            if (SGAddressing.isValidSymbolChar(C)) {
                this.enterCharacter(C.charAt(0));
            }
        }
    }

    void orangeButtonPressed(boolean connectOnly) {
        SGBaseTE te = this.getStargateTE();
        if (te != null) {
            if (te.state == SGState.Idle) {
                this.sendConnectOrDisconnect(te, this.getEnteredAddress());
            } else if (!connectOnly) {
                this.sendConnectOrDisconnect(te, "");
            }
        }
    }

    void sendConnectOrDisconnect(SGBaseTE te, String address) {
        SGChannel.sendConnectOrDisconnectToServer(te, address);
        this.closeAfterDelay(10);
    }

    void backspace() {
        if (this.stargateIsIdle()) {
            this.buttonSound();
            String a = this.getEnteredAddress();
            int n = a.length();
            if (n > 0) {
                this.setEnteredAddress(a.substring(0, n - 1));
            }
        }
    }

    void enterCharacter(char c) {
        if (this.stargateIsIdle()) {
            this.buttonSound();
            String a = this.getEnteredAddress();
            int n = a.length();
            if (n < this.addressLength) {
                this.setEnteredAddress(a + c);
            }
        }
    }

    boolean stargateIsIdle() {
        SGBaseTE te = this.getStargateTE();
        return te != null && te.state == SGState.Idle;
    }

    @Override
    protected void func_146976_a(float var1, int mouseX, int mouseY) {
        SGBaseTE te = this.getStargateTE();
        GL11.glPushAttrib((int)24576);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3008);
        this.drawBackgroundImage();
        if (te != null && te.state == SGState.Idle) {
            this.drawEnteredSymbols();
            this.drawEnteredString();
        }
        GL11.glPopAttrib();
    }

    void drawBackgroundImage() {
        this.bindTexture(this.background);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        this.drawTexturedRect((double)(this.field_146294_l - 192) / 2.0, (double)(this.field_146295_m - 192) / 2.0, 192.0, 192.0, 0.0, 0.0, 0.75, 0.75);
    }

    public boolean getConnected() {
        SGBaseTE te = this.getStargateTE();
        return te != null && te.isActive();
    }

    void drawEnteredSymbols() {
        this.drawAddressSymbols(this.centreX, 1, this.getEnteredAddress());
    }

    void drawEnteredString() {
        String address = SGAddressing.padAddress(this.getEnteredAddress(), "|", this.addressLength);
        this.drawAddressString(this.centreX, this.field_146295_m - 30, address);
    }
}

