/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter;

import com.cleanroommc.bogosorter.ClientEventHandler;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.minecraft.client.Minecraft;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class KeyBind {
    private static final List<KeyBind> keyBinds = new ArrayList<KeyBind>();
    private final String name;
    private final int[] keys;
    private final int[] notKeys;
    private final BooleanSupplier additionalValidator;
    private long pressedTick = -1L;

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public KeyBind(String name, int[] keys, int[] notKeys, BooleanSupplier additionalValidator) {
        this.name = name;
        this.keys = keys;
        this.notKeys = notKeys;
        this.additionalValidator = additionalValidator;
        keyBinds.add(this);
    }

    private static boolean isKey(int key) {
        return key != Integer.MIN_VALUE;
    }

    public static boolean isKeyPressed(int key) {
        if (key < 0) {
            return Mouse.isButtonDown((int)(key + 100));
        }
        return Keyboard.isKeyDown((int)key);
    }

    public static boolean areAllPressed(int[] keys) {
        if (keys.length == 0) {
            return true;
        }
        if (keys.length == 1) {
            return KeyBind.isKeyPressed(keys[0]);
        }
        for (int key : keys) {
            if (KeyBind.isKeyPressed(key)) continue;
            return false;
        }
        return true;
    }

    public static boolean areAllNotPressed(int[] keys) {
        if (keys.length == 0) {
            return true;
        }
        if (keys.length == 1) {
            return !KeyBind.isKeyPressed(keys[0]);
        }
        for (int key : keys) {
            if (!KeyBind.isKeyPressed(key)) continue;
            return false;
        }
        return true;
    }

    public static void checkKeys(long currentTick) {
        for (KeyBind key : keyBinds) {
            key.checkPressed(currentTick);
        }
    }

    protected void checkPressed(long currentTick) {
        if (KeyBind.areAllPressed(this.keys) && KeyBind.areAllNotPressed(this.notKeys) && this.additionalValidator.getAsBoolean()) {
            if (this.pressedTick < 0L) {
                this.pressedTick = currentTick;
            }
        } else {
            this.pressedTick = -1L;
        }
    }

    public boolean isPressed() {
        return this.pressedTick >= 0L;
    }

    public int getTicksPressed() {
        return this.pressedTick < 0L ? -1 : (int)(ClientEventHandler.getTicks() - this.pressedTick);
    }

    public boolean isFirstPress() {
        return this.getTicksPressed() == 0;
    }

    public boolean isFirstPressOrHeldLong(int amount) {
        int ticks = this.getTicksPressed();
        return ticks == 0 || ticks >= amount;
    }

    public String getName() {
        return this.name;
    }

    public static class Builder {
        private final String name;
        private final IntArrayList keys = new IntArrayList();
        private final IntArrayList notKeys = new IntArrayList();
        private BooleanSupplier validator = null;

        public Builder(String name) {
            this.name = name;
        }

        private Builder add(boolean press, int key) {
            if (press) {
                this.keys.add(key);
            } else {
                this.notKeys.add(key);
            }
            return this;
        }

        public Builder mustPress(int ... keys) {
            for (int key : keys) {
                this.keys.add(key);
            }
            return this;
        }

        public Builder mustNotPress(int ... keys) {
            for (int key : keys) {
                this.notKeys.add(key);
            }
            return this;
        }

        public Builder lmb(boolean press) {
            return this.add(press, -100);
        }

        public Builder rmb(boolean press) {
            return this.add(press, -99);
        }

        public Builder ctrl(boolean press) {
            if (Minecraft.field_142025_a) {
                return this.add(press, 219);
            }
            return this.add(press, 29);
        }

        public Builder shift(boolean press) {
            return this.add(press, 42);
        }

        public Builder alt(boolean press) {
            return this.add(press, 56);
        }

        public Builder space(boolean press) {
            return this.add(press, 57);
        }

        public Builder validator(BooleanSupplier validator) {
            this.validator = validator;
            return this;
        }

        public KeyBind build() {
            this.keys.trim();
            this.notKeys.trim();
            return new KeyBind(this.name, this.keys.elements(), this.notKeys.elements(), this.validator != null ? this.validator : () -> true);
        }
    }
}

