/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.recipe;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class AssemblyRecipes {
    private static final List<IRecipe> RECIPES = new ArrayList<IRecipe>();

    public static ShapedRecipes addRecipe(ItemStack output, Object ... inputList) {
        String s = "";
        int i = 0;
        int width = 0;
        int height = 0;
        String[] stringArray = inputList[i];
        if (stringArray instanceof String[]) {
            String[] rows;
            for (String row : rows = (String[])stringArray) {
                ++height;
                width = row.length();
                s = s + row;
            }
            ++i;
        } else {
            Object object;
            while ((object = inputList[i]) instanceof String) {
                String row = (String)object;
                ++i;
                ++height;
                width = row.length();
                s = s + row;
            }
        }
        HashMap<Character, ItemStack> hashmap = new HashMap<Character, ItemStack>();
        while (i < inputList.length) {
            ItemStack itemstack = null;
            if (inputList[i + 1] instanceof Item) {
                itemstack = new ItemStack((Item)inputList[i + 1]);
            } else if (inputList[i + 1] instanceof Block) {
                itemstack = new ItemStack((Block)inputList[i + 1]);
            } else if (inputList[i + 1] instanceof ItemStack) {
                itemstack = (ItemStack)inputList[i + 1];
            }
            hashmap.put((Character)inputList[i], itemstack);
            i += 2;
        }
        ItemStack[] items = new ItemStack[width * height];
        for (int j = 0; j < width * height; ++j) {
            char c0 = s.charAt(j);
            items[j] = hashmap.containsKey(Character.valueOf(c0)) ? ((ItemStack)hashmap.get(Character.valueOf(c0))).func_77946_l() : null;
        }
        ShapedRecipes shapedrecipes = new ShapedRecipes(width, height, items, output);
        RECIPES.add((IRecipe)shapedrecipes);
        return shapedrecipes;
    }

    public static void addShapelessRecipe(ItemStack output, Object ... input) {
        ArrayList<Object> recipe = new ArrayList<Object>();
        for (Object object : input) {
            if (object instanceof ItemStack) {
                recipe.add(((ItemStack)object).func_77946_l());
                continue;
            }
            if (object instanceof Item) {
                recipe.add(new ItemStack((Item)object));
                continue;
            }
            if (object instanceof String) {
                recipe.add(object);
                continue;
            }
            if (!(object instanceof Block)) {
                throw new RuntimeException("Invalid shapeless compressor recipe!");
            }
            recipe.add(new ItemStack((Block)object));
        }
        RECIPES.add((IRecipe)new ShapelessOreRecipe(output, recipe.toArray()));
    }

    public static ItemStack findMatchingRecipe(IInventory inventory) {
        int i = 0;
        ItemStack stack1 = null;
        ItemStack stack2 = null;
        for (int j = 0; j < inventory.func_70302_i_(); ++j) {
            ItemStack stack = inventory.func_70301_a(j);
            if (stack == null) continue;
            if (i == 0) {
                stack1 = stack;
            }
            if (i == 1) {
                stack2 = stack;
            }
            ++i;
        }
        if (i == 2 && stack1.func_77973_b() == stack2.func_77973_b() && stack1.field_77994_a == 1 && stack2.field_77994_a == 1 && stack1.func_77973_b().isRepairable()) {
            int damage1 = stack1.func_77973_b().func_77612_l() - stack1.func_77952_i();
            int damage2 = stack1.func_77973_b().func_77612_l() - stack2.func_77952_i();
            int totalDamage = damage1 + damage2 + stack1.func_77973_b().func_77612_l() * 5 / 100;
            int meta = stack1.func_77973_b().func_77612_l() - totalDamage;
            if (meta < 0) {
                meta = 0;
            }
            return new ItemStack(stack1.func_77973_b(), 1, meta);
        }
        for (IRecipe recipe : RECIPES) {
            if ((!(recipe instanceof ShapedRecipes) || !AssemblyRecipes.matches((ShapedRecipes)recipe, inventory)) && (!(recipe instanceof ShapelessOreRecipe) || !AssemblyRecipes.matchesShapeless((ShapelessOreRecipe)recipe, inventory))) continue;
            return recipe.func_77571_b().func_77946_l();
        }
        return null;
    }

    private static boolean matches(ShapedRecipes recipe, IInventory inventory) {
        for (int offsetWidth = 0; offsetWidth <= 3 - recipe.field_77576_b; ++offsetWidth) {
            for (int offsetHeight = 0; offsetHeight <= 3 - recipe.field_77577_c; ++offsetHeight) {
                if (!AssemblyRecipes.checkMatch(recipe, inventory, offsetWidth, offsetHeight, true) && !AssemblyRecipes.checkMatch(recipe, inventory, offsetWidth, offsetHeight, false)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean checkMatch(ShapedRecipes recipe, IInventory inventory, int offsetWidth, int offsetHeight, boolean mirrored) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int column = i - offsetWidth;
                int row = j - offsetHeight;
                ItemStack itemstack = null;
                if (column >= 0 && row >= 0 && column < recipe.field_77576_b && row < recipe.field_77577_c) {
                    itemstack = mirrored ? recipe.field_77574_d[recipe.field_77576_b - column - 1 + row * recipe.field_77576_b] : recipe.field_77574_d[column + row * recipe.field_77576_b];
                }
                ItemStack itemstack2 = null;
                if (i >= 0 && j < 3) {
                    int index = i + j * 3;
                    itemstack2 = inventory.func_70301_a(index);
                }
                if (itemstack2 == null && itemstack == null || itemstack2 == null != (itemstack != null) && itemstack.func_77973_b() == itemstack2.func_77973_b() && (itemstack.func_77960_j() == Short.MAX_VALUE || itemstack.func_77960_j() == itemstack2.func_77960_j())) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean matchesShapeless(ShapelessOreRecipe recipe, IInventory inventory) {
        ArrayList required = new ArrayList(recipe.getInput());
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack slot = inventory.func_70301_a(i);
            if (slot == null) continue;
            boolean inRecipe = false;
            for (Object next : required) {
                boolean match = false;
                if (next instanceof ItemStack) {
                    match = OreDictionary.itemMatches((ItemStack)((ItemStack)next), (ItemStack)slot, (boolean)false);
                } else if (next instanceof ArrayList) {
                    Iterator itr = ((ArrayList)next).iterator();
                    while (itr.hasNext() && !match) {
                        match = OreDictionary.itemMatches((ItemStack)((ItemStack)itr.next()), (ItemStack)slot, (boolean)false);
                    }
                }
                if (!match) continue;
                inRecipe = true;
                required.remove(next);
                break;
            }
            if (inRecipe) continue;
            return false;
        }
        return required.isEmpty();
    }

    public static List<IRecipe> getRecipeList() {
        return RECIPES;
    }
}

