/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.mixins.early.soulfire;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ganymedes01.etfuturum.ducks.ISoulFireInfo;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlockFire.class})
public abstract class MixinBlockFire
extends Block
implements ISoulFireInfo {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] soulFireIcons;

    protected MixinBlockFire(Material m) {
        super(m);
    }

    @Unique
    private boolean etfuturum$isVanillaFire() {
        return this == Blocks.field_150480_ab;
    }

    @Inject(method={"updateTick"}, at={@At(value="HEAD")}, cancellable=true)
    private void shouldSpread(World world, int x, int y, int z, Random random, CallbackInfo ci) {
        if (this.etfuturum$isVanillaFire() && this.isSoulFire((IBlockAccess)world, x, y, z)) {
            ci.cancel();
        }
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        if (this.etfuturum$isVanillaFire() && this.isSoulFire(world, x, y, z)) {
            return 10;
        }
        return super.getLightValue(world, x, y, z);
    }

    @Inject(method={"registerBlockIcons"}, at={@At(value="HEAD")})
    @SideOnly(value=Side.CLIENT)
    private void addSoulFireIcon(IIconRegister reg, CallbackInfo ci) {
        this.soulFireIcons = new IIcon[2];
        this.soulFireIcons[0] = reg.func_94245_a("soul_fire_0");
        this.soulFireIcons[1] = reg.func_94245_a("soul_fire_1");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getSoulFireIcon(int type) {
        return this.soulFireIcons[type % this.soulFireIcons.length];
    }
}

