/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.common.commands.arguments.handlers.named;

import com.google.common.collect.PeekingIterator;
import dev.rndmorris.salisarcana.common.commands.arguments.handlers.IArgumentHandler;
import dev.rndmorris.salisarcana.common.commands.arguments.handlers.named.INamedArgumentHandler;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.command.ICommandSender;

public class SearchHandler
implements INamedArgumentHandler {
    public static final IArgumentHandler INSTANCE = new SearchHandler();

    @Override
    public Object parse(ICommandSender sender, PeekingIterator<String> args) {
        return this.buildSearchTerm(args);
    }

    @Override
    public List<String> getAutocompleteOptions(ICommandSender sender, PeekingIterator<String> args) {
        this.buildSearchTerm(args);
        if (!args.hasNext()) {
            return Collections.emptyList();
        }
        return null;
    }

    @Override
    @Nonnull
    public Class<?> getOutputType() {
        return String.class;
    }

    private String buildSearchTerm(PeekingIterator<String> args) {
        boolean insideQuote = false;
        boolean escapeNext = false;
        StringBuilder str = new StringBuilder();
        block0: while (args.hasNext() && (insideQuote || str.length() <= 0)) {
            if (str.length() > 0) {
                str.append(' ');
            }
            String currentTerm = (String)args.next();
            for (int index = 0; index < currentTerm.length(); ++index) {
                char character = currentTerm.charAt(index);
                if (character == '\\') {
                    if (escapeNext) {
                        str.append(character);
                        escapeNext = false;
                        continue;
                    }
                    escapeNext = true;
                    continue;
                }
                if (character == '\"') {
                    if (escapeNext) {
                        str.append(character);
                        escapeNext = false;
                        continue;
                    }
                    if (insideQuote) {
                        insideQuote = false;
                        continue block0;
                    }
                    insideQuote = true;
                    continue;
                }
                str.append(character);
            }
        }
        return str.toString();
    }
}

