/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids.tile;

import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import micdoodle8.mods.galacticraft.api.power.EnergySource;
import micdoodle8.mods.galacticraft.api.power.IEnergyHandlerGC;
import micdoodle8.mods.galacticraft.api.power.ILaserNode;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConductor;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.energy.EnergyUtil;
import micdoodle8.mods.galacticraft.core.energy.tile.EnergyStorage;
import micdoodle8.mods.galacticraft.core.energy.tile.EnergyStorageTile;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseConductor;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalElectrical;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalElectricalSource;
import micdoodle8.mods.galacticraft.core.tile.ReceiverMode;
import micdoodle8.mods.galacticraft.core.util.Annotations;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityBeamOutput;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityBeamReceiver
extends TileEntityBeamOutput
implements IEnergyHandlerGC,
ILaserNode {
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int facing = ForgeDirection.UNKNOWN.ordinal();
    private int preLoadFacing = -1;
    private final float maxRate = 1500.0f;
    private final EnergyStorage storage = new EnergyStorage(10.0f * this.maxRate, this.maxRate);
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int modeReceive = ReceiverMode.UNDEFINED.ordinal();
    public Vector3 color = new Vector3(0.0, 1.0, 0.0);

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.preLoadFacing != -1) {
            this.setFacing(ForgeDirection.getOrientation((int)this.preLoadFacing));
            this.preLoadFacing = -1;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.getTarget() != null && this.modeReceive == ReceiverMode.EXTRACT.ordinal() && this.facing != ForgeDirection.UNKNOWN.ordinal()) {
                ForgeDirection inputAdj;
                float availableToSend;
                TileEntity tile = this.getAttachedTile();
                if (tile instanceof TileBaseUniversalElectricalSource) {
                    TileBaseUniversalElectricalSource electricalTile = (TileBaseUniversalElectricalSource)tile;
                    if (electricalTile.storage.getEnergyStoredGC() > 0.0f) {
                        EnergySource.EnergySourceAdjacent source = new EnergySource.EnergySourceAdjacent(ForgeDirection.getOrientation((int)(this.facing ^ 1)));
                        float toSend = Math.min(electricalTile.storage.getMaxExtract(), electricalTile.storage.getEnergyStoredGC());
                        float transmitted = this.getTarget().receiveEnergyGC(new EnergySource.EnergySourceWireless(Lists.newArrayList((Object[])new ILaserNode[]{this})), toSend, false);
                        electricalTile.extractEnergyGC(source, transmitted, false);
                    }
                } else if (!(tile instanceof EnergyStorageTile) && !(tile instanceof TileBaseConductor) && (availableToSend = EnergyUtil.otherModsEnergyExtract(tile, inputAdj = ForgeDirection.getOrientation((int)this.facing), this.maxRate, true)) > 0.0f) {
                    float transmitted = this.getTarget().receiveEnergyGC(new EnergySource.EnergySourceWireless(Lists.newArrayList((Object[])new ILaserNode[]{this})), availableToSend, false);
                    EnergyUtil.otherModsEnergyExtract(tile, inputAdj, transmitted, false);
                }
            } else if (this.modeReceive == ReceiverMode.RECEIVE.ordinal() && this.storage.getEnergyStoredGC() > 0.0f) {
                float maxTransfer = Math.min(this.storage.getEnergyStoredGC(), this.maxRate * 5.0f);
                if (maxTransfer < 0.01f) {
                    this.storage.extractEnergyGCnoMax(maxTransfer, false);
                } else {
                    ForgeDirection inputAdj;
                    float otherModTransferred;
                    TileEntity tileAdj = this.getAttachedTile();
                    if (tileAdj instanceof TileBaseUniversalElectrical) {
                        TileBaseUniversalElectrical electricalTile = (TileBaseUniversalElectrical)tileAdj;
                        EnergySource.EnergySourceAdjacent source = new EnergySource.EnergySourceAdjacent(ForgeDirection.getOrientation((int)(this.facing ^ 1)));
                        this.storage.extractEnergyGCnoMax(electricalTile.receiveEnergyGC(source, maxTransfer, false), false);
                    } else if (!(tileAdj instanceof EnergyStorageTile) && !(tileAdj instanceof TileBaseConductor) && (otherModTransferred = EnergyUtil.otherModsEnergyTransfer(tileAdj, inputAdj = ForgeDirection.getOrientation((int)this.facing), maxTransfer, false)) > 0.0f) {
                        this.storage.extractEnergyGCnoMax(otherModTransferred, false);
                    }
                }
            }
        }
    }

    @Override
    public double getPacketRange() {
        return 24.0;
    }

    @Override
    public int getPacketCooldown() {
        return 3;
    }

    @Override
    public boolean isNetworkedTile() {
        return true;
    }

    @Override
    public Vector3 getInputPoint() {
        Vector3 headVec = new Vector3((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5);
        ForgeDirection facingDir = ForgeDirection.getOrientation((int)this.facing);
        headVec.x += (double)((float)facingDir.offsetX * 0.1f);
        headVec.y += (double)((float)facingDir.offsetY * 0.1f);
        headVec.z += (double)((float)facingDir.offsetZ * 0.1f);
        return headVec;
    }

    @Override
    public Vector3 getOutputPoint(boolean offset) {
        Vector3 headVec = new Vector3((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5);
        ForgeDirection facingDir = ForgeDirection.getOrientation((int)this.facing);
        headVec.x += (double)((float)facingDir.offsetX * 0.1f);
        headVec.y += (double)((float)facingDir.offsetY * 0.1f);
        headVec.z += (double)((float)facingDir.offsetZ * 0.1f);
        return headVec;
    }

    @Override
    public TileEntity getTile() {
        return this;
    }

    public TileEntity getAttachedTile() {
        if (this.facing == ForgeDirection.UNKNOWN.ordinal()) {
            return null;
        }
        TileEntity tile = new BlockVec3(this).getTileEntityOnSide(this.field_145850_b, this.facing);
        if (tile == null || tile.func_145837_r()) {
            this.setFacing(ForgeDirection.UNKNOWN);
        }
        if (tile instanceof IConductor) {
            this.setFacing(ForgeDirection.UNKNOWN);
            return null;
        }
        if (tile instanceof EnergyStorageTile) {
            EnergyStorage attachedStorage = ((EnergyStorageTile)tile).storage;
            this.storage.setCapacity(attachedStorage.getCapacityGC() - attachedStorage.getEnergyStoredGC());
            this.storage.setMaxExtract(attachedStorage.getMaxExtract());
            this.storage.setMaxReceive(attachedStorage.getMaxReceive());
        }
        return tile;
    }

    @Override
    public float receiveEnergyGC(EnergySource from, float amount, boolean simulate) {
        if (this.modeReceive != ReceiverMode.RECEIVE.ordinal()) {
            return 0.0f;
        }
        this.getAttachedTile();
        if (this.facing == ForgeDirection.UNKNOWN.ordinal()) {
            return 0.0f;
        }
        return this.storage.receiveEnergyGC(amount, simulate);
    }

    @Override
    public float extractEnergyGC(EnergySource from, float amount, boolean simulate) {
        if (this.modeReceive != ReceiverMode.EXTRACT.ordinal()) {
            return 0.0f;
        }
        TileEntity tile = this.getAttachedTile();
        if (this.facing == ForgeDirection.UNKNOWN.ordinal()) {
            return 0.0f;
        }
        float extracted = this.storage.extractEnergyGC(amount, simulate);
        if (extracted < amount && tile instanceof EnergyStorageTile) {
            extracted += ((EnergyStorageTile)tile).storage.extractEnergyGC(amount - extracted, simulate);
        }
        return extracted;
    }

    @Override
    public float getEnergyStoredGC(EnergySource from) {
        if (this.facing == ForgeDirection.UNKNOWN.ordinal()) {
            return 0.0f;
        }
        return this.storage.getEnergyStoredGC();
    }

    @Override
    public float getMaxEnergyStoredGC(EnergySource from) {
        if (this.facing == ForgeDirection.UNKNOWN.ordinal()) {
            return 0.0f;
        }
        return this.storage.getCapacityGC();
    }

    @Override
    public boolean nodeAvailable(EnergySource from) {
        return this.facing != ForgeDirection.UNKNOWN.ordinal();
    }

    public void setFacing(ForgeDirection newDirection) {
        if (newDirection.ordinal() != this.facing) {
            if (newDirection == ForgeDirection.UNKNOWN) {
                this.modeReceive = ReceiverMode.UNDEFINED.ordinal();
            } else {
                TileEntity tile = new BlockVec3(this).getTileEntityOnSide(this.field_145850_b, newDirection);
                if (tile == null) {
                    this.modeReceive = ReceiverMode.UNDEFINED.ordinal();
                } else if (tile instanceof EnergyStorageTile) {
                    ReceiverMode mode = ((EnergyStorageTile)tile).getModeFromDirection(newDirection.getOpposite());
                    this.modeReceive = mode != null ? mode.ordinal() : ReceiverMode.UNDEFINED.ordinal();
                } else if (EnergyUtil.otherModCanReceive(tile, newDirection.getOpposite())) {
                    this.modeReceive = ReceiverMode.RECEIVE.ordinal();
                } else if (EnergyUtil.otherModCanProduce(tile, newDirection.getOpposite())) {
                    this.modeReceive = ReceiverMode.EXTRACT.ordinal();
                }
            }
        }
        this.facing = newDirection.ordinal();
    }

    @Override
    public boolean canConnectTo(ILaserNode laserNode) {
        if (this.modeReceive != ReceiverMode.UNDEFINED.ordinal() && this.color.equals(laserNode.getColor())) {
            if (laserNode instanceof TileEntityBeamReceiver) {
                return ((TileEntityBeamReceiver)laserNode).modeReceive != this.modeReceive;
            }
            return true;
        }
        return false;
    }

    @Override
    public Vector3 getColor() {
        return new Vector3(0.0, 1.0, 0.0);
    }

    @Override
    public ILaserNode getTarget() {
        if (this.modeReceive == ReceiverMode.EXTRACT.ordinal()) {
            return super.getTarget();
        }
        return null;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.preLoadFacing = nbt.func_74762_e("FacingSide");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("FacingSide", this.facing);
    }
}

