/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network.packets;

import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.PacketIdClient;
import forestry.core.network.packets.PacketCoordinates;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.IConfigurable;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;

public class PacketTileConfiguration
extends PacketCoordinates
implements IForestryPacketClient {
    private TileEntity tileEntity = null;

    public PacketTileConfiguration() {
    }

    public PacketTileConfiguration(TileEntity tileEntity) {
        super(tileEntity);
        this.tileEntity = tileEntity;
    }

    @Override
    protected void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        if (this.tileEntity instanceof IConfigurable) {
            ((IConfigurable)this.tileEntity).writeConfigurationData(data);
        }
    }

    @Override
    public void onPacketData(DataInputStreamForestry data, EntityPlayer player) throws IOException {
        TileEntity tile = this.getTarget(Proxies.common.getRenderWorld());
        if (tile instanceof IConfigurable) {
            ((IConfigurable)tile).readConfigurationData(data);
        }
    }

    @Override
    public PacketIdClient getPacketId() {
        return PacketIdClient.TILE_CONFIGURATION;
    }
}

