/*
 * Decompiled with CFR 0.152.
 */
package eu.usrv.legacylootgames;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import ru.timeconqueror.lootgames.common.config.LGConfigs;

public class LootGamesDungeonLogger {
    private FileHandler _mFileTxt;
    private VerySimpleFormatter _mFormatterTxt;
    private Logger _mLootgameLogger;

    public void setup() throws IOException {
        this._mLootgameLogger = Logger.getLogger("global");
        this._mLootgameLogger.setLevel(Level.ALL);
        this._mFileTxt = new FileHandler("logs/LootGames.log", true);
        this._mFormatterTxt = new VerySimpleFormatter();
        this._mFileTxt.setFormatter(this._mFormatterTxt);
        this._mLootgameLogger.addHandler(this._mFileTxt);
        this._mLootgameLogger.setUseParentHandlers(false);
        this.info("== LootGames logger initialized ==");
    }

    public void info(String pMessage) {
        this._mLootgameLogger.log(Level.INFO, pMessage);
    }

    public void debug(String pMessage) {
        if (LGConfigs.GENERAL.worldGen.dungeonLogLevel.equalsIgnoreCase("debug") || LGConfigs.GENERAL.worldGen.dungeonLogLevel.equalsIgnoreCase("trace")) {
            this._mLootgameLogger.log(Level.FINE, pMessage);
        }
    }

    public void trace(String pMessage) {
        if (LGConfigs.GENERAL.worldGen.dungeonLogLevel.equalsIgnoreCase("trace")) {
            this._mLootgameLogger.log(Level.FINEST, pMessage);
        }
    }

    public void info(String pMessage, Object ... pArgs) {
        this.info(String.format(pMessage, pArgs));
    }

    public void debug(String pMessage, Object ... pArgs) {
        this.debug(String.format(pMessage, pArgs));
    }

    public void trace(String pMessage, Object ... pArgs) {
        this.trace(String.format(pMessage, pArgs));
    }

    private static class VerySimpleFormatter
    extends Formatter {
        private static final DateFormat df = new SimpleDateFormat("dd.MM.yyyy hh:mm:ss.SSS");

        private VerySimpleFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            StringBuilder builder = new StringBuilder(1000);
            builder.append(df.format(new Date(record.getMillis()))).append(" - ");
            builder.append("[").append(record.getSourceClassName()).append("]");
            builder.append("[").append(record.getLevel()).append("] - ");
            builder.append(this.formatMessage(record));
            builder.append(System.lineSeparator());
            return builder.toString();
        }

        @Override
        public String getHead(Handler h) {
            return super.getHead(h);
        }

        @Override
        public String getTail(Handler h) {
            return super.getTail(h);
        }
    }
}

