/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.api.diagram.layout;

import com.github.dcysteine.neicustomdiagram.api.diagram.DiagramState;
import com.github.dcysteine.neicustomdiagram.api.diagram.interactable.Interactable;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.;
import com.github.dcysteine.neicustomdiagram.api.diagram.tooltip.Tooltip;
import com.github.dcysteine.neicustomdiagram.api.draw.Dimension;
import com.github.dcysteine.neicustomdiagram.api.draw.Draw;
import com.github.dcysteine.neicustomdiagram.api.draw.Point;
import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.toprettystring.ToPrettyString;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

@AutoValue
public abstract class Slot
implements Interactable {
    @Override
    public abstract Point position();

    public abstract int slotWidth();

    public abstract Tooltip tooltip();

    public abstract BiConsumer<DiagramState, Point> drawFunction();

    @Override
    public Dimension dimension() {
        return Dimension.create(16);
    }

    @Override
    public void draw(DiagramState diagramState) {
        this.drawFunction().accept(diagramState, this.position());
    }

    @Override
    public void drawOverlay(DiagramState diagramState) {
        Draw.drawOverlay(this.position(), -2130706433);
    }

    @Override
    public void drawTooltip(DiagramState diagramState, Point mousePos) {
        this.tooltip().draw(mousePos);
    }

    @ToPrettyString
    public abstract String toPrettyString();

    public static Builder builder(Point pos) {
        return new .AutoValue_Slot.Builder().setPosition(pos).setSlotWidth(18).setTooltip(Tooltip.EMPTY_TOOLTIP).setDrawFunction(Draw::drawSlot);
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setPosition(Point var1);

        public abstract Builder setSlotWidth(int var1);

        public abstract Builder setTooltip(Tooltip var1);

        public abstract Builder setDrawFunction(BiConsumer<DiagramState, Point> var1);

        public Builder setDrawFunction(Consumer<Point> fun) {
            this.setDrawFunction((DiagramState ticker, Point point) -> fun.accept((Point)point));
            return this;
        }

        public abstract Slot build();
    }
}

