/*
 * Decompiled with CFR 0.152.
 */
package detrav.net;

import bartworks.system.material.Werkstoff;
import com.google.common.base.Objects;
import detrav.DetravScannerMod;
import detrav.gui.DetravScannerGUI;
import detrav.gui.textures.DetravMapTexture;
import detrav.net.DetravPacket;
import detrav.utils.FluidColors;
import detrav.utils.GTppHelper;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.Materials;
import gregtech.api.util.GTLanguageManager;
import gtPlusPlus.core.material.Material;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class ProspectingPacket
extends DetravPacket {
    public final int chunkX;
    public final int chunkZ;
    public final int posX;
    public final int posZ;
    public final int size;
    public final int ptype;
    public final HashMap<Byte, Short>[][] map;
    public final HashMap<String, Integer> ores;
    public final HashMap<Short, String> metaMap;
    public int level = -1;

    public ProspectingPacket(int chunkX, int chunkZ, int posX, int posZ, int size, int ptype) {
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.posX = posX;
        this.posZ = posZ;
        this.size = size;
        this.ptype = ptype;
        this.map = new HashMap[(size * 2 + 1) * 16][(size * 2 + 1) * 16];
        this.ores = new HashMap();
        this.metaMap = new HashMap();
    }

    private static void addOre(ProspectingPacket packet, byte y, int i, int j, short meta) {
        String name;
        short[] rgba;
        block9: {
            try {
                if (packet.ptype == 0 || packet.ptype == 1) {
                    if (meta < 7000 || meta > 7500) {
                        if (meta > 0) {
                            Materials tMaterial = GregTechAPI.sGeneratedMaterials[meta % 1000];
                            rgba = tMaterial.getRGBA();
                            name = tMaterial.getLocalizedNameForItem(GTLanguageManager.getTranslation("gt.blockores." + meta + ".name"));
                        } else {
                            Werkstoff werkstoff = Werkstoff.werkstoffHashMap.getOrDefault((short)(meta * -1), null);
                            String translated = GTLanguageManager.getTranslation("bw.blocktype.ore");
                            name = translated.replace("%material", werkstoff.getLocalizedName());
                            rgba = werkstoff.getRGBA();
                        }
                    } else {
                        Material mat = GTppHelper.getMatFromMeta(meta);
                        rgba = mat.getRGBA();
                        name = mat.getLocalizedName() + " Ore";
                    }
                    break block9;
                }
                if (packet.ptype == 2) {
                    rgba = FluidColors.getColor(meta);
                    name = (String)Objects.firstNonNull((Object)FluidRegistry.getFluid((int)meta).getLocalizedName(new FluidStack(FluidRegistry.getFluid((int)meta), 0)), (Object)StatCollector.func_74838_a((String)"gui.detrav.scanner.unknown_fluid"));
                    break block9;
                }
                if (packet.ptype == 3) {
                    name = StatCollector.func_74838_a((String)"gui.detrav.scanner.pollution");
                    rgba = new short[]{125, 123, 118, 0};
                    break block9;
                }
                return;
            }
            catch (Exception ignored) {
                return;
            }
        }
        packet.ores.put(name, ((rgba[0] & 0xFF) << 16) + ((rgba[1] & 0xFF) << 8) + (rgba[2] & 0xFF));
        packet.metaMap.put(meta, name);
    }

    public static Object decode(InputStream in) throws IOException {
        DataInputStream aData = new DataInputStream(new GZIPInputStream(in));
        ProspectingPacket packet = new ProspectingPacket(aData.readInt(), aData.readInt(), aData.readInt(), aData.readInt(), aData.readInt(), aData.readInt());
        packet.level = aData.readInt();
        int aSize = (packet.size * 2 + 1) * 16;
        int checkOut = 0;
        for (int i = 0; i < aSize; ++i) {
            for (int j = 0; j < aSize; ++j) {
                int kSize = aData.readByte();
                if (kSize == 0) continue;
                packet.map[i][j] = new HashMap();
                for (int k = 0; k < kSize; ++k) {
                    byte y = aData.readByte();
                    if (y == 0) continue;
                    short meta = aData.readShort();
                    packet.map[i][j].put(y, meta);
                    if (packet.ptype != 2 || y == 1) {
                        ProspectingPacket.addOre(packet, y, i, j, meta);
                    }
                    ++checkOut;
                }
            }
        }
        int checkOut2 = aData.readInt();
        if (checkOut != checkOut2) {
            return null;
        }
        return packet;
    }

    @Override
    public int getPacketID() {
        return 0;
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        DataOutputStream tOut = new DataOutputStream(new GZIPOutputStream(out));
        tOut.writeInt(this.chunkX);
        tOut.writeInt(this.chunkZ);
        tOut.writeInt(this.posX);
        tOut.writeInt(this.posZ);
        tOut.writeInt(this.size);
        tOut.writeInt(this.ptype);
        tOut.writeInt(this.level);
        int aSize = (this.size * 2 + 1) * 16;
        int checkOut = 0;
        for (int i = 0; i < aSize; ++i) {
            for (int j = 0; j < aSize; ++j) {
                HashMap<Byte, Short> data = this.map[i][j];
                if (data == null) {
                    tOut.writeByte(0);
                    continue;
                }
                tOut.writeByte(data.keySet().size());
                for (byte key : data.keySet()) {
                    tOut.writeByte(key);
                    tOut.writeShort(data.get(key).shortValue());
                    ++checkOut;
                }
            }
        }
        tOut.writeInt(checkOut);
        tOut.close();
    }

    @Override
    public void process() {
        DetravScannerGUI.newMap(new DetravMapTexture(this));
        DetravScannerMod.proxy.openProspectorGUI();
    }

    public void addBlock(int x, int y, int z, short metaData) {
        int aX = x - (this.chunkX - this.size) * 16;
        int aZ = z - (this.chunkZ - this.size) * 16;
        if (this.map[aX][aZ] == null) {
            this.map[aX][aZ] = new HashMap();
        }
        this.map[aX][aZ].put((byte)y, metaData);
    }

    public int getSize() {
        return (this.size * 2 + 1) * 16;
    }
}

