/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.objects.overclockdescriber;

import com.google.common.primitives.Ints;
import gregtech.GTMod;
import gregtech.api.enums.GTValues;
import gregtech.api.objects.overclockdescriber.EUNoOverclockDescriber;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import gregtech.api.util.OverclockCalculator;
import gregtech.nei.RecipeDisplayInfo;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.StatCollector;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class EUOverclockDescriber
extends EUNoOverclockDescriber {
    public EUOverclockDescriber(byte tier, int amperage) {
        super(tier, amperage);
    }

    @Override
    public OverclockCalculator createCalculator(OverclockCalculator template, GTRecipe recipe) {
        return template.setEUt(Ints.saturatedCast((long)(GTValues.V[this.tier] * (long)this.amperage)));
    }

    @Override
    protected void drawEnergyInfoImpl(RecipeDisplayInfo recipeInfo) {
        if (!this.wasOverclocked(recipeInfo.calculator)) {
            super.drawEnergyInfoImpl(recipeInfo);
            return;
        }
        recipeInfo.drawText(this.getEUtDisplay(recipeInfo.calculator));
        if (this.shouldShowAmperage(recipeInfo.calculator)) {
            recipeInfo.drawText(this.getVoltageString(recipeInfo.calculator));
        }
        if (GTMod.proxy.mNEIOriginalVoltage) {
            recipeInfo.drawText(this.getOriginalEUtDisplay(recipeInfo));
        }
        if (this.shouldShowAmperage(recipeInfo.calculator)) {
            recipeInfo.drawText(this.getAmperageString(recipeInfo.calculator));
        }
    }

    @Override
    protected String getVoltageString(OverclockCalculator calculator) {
        String voltageString = super.getVoltageString(calculator);
        if (this.wasOverclocked(calculator)) {
            voltageString = voltageString + StatCollector.func_74838_a((String)"GT5U.nei.display.overclock");
        }
        return voltageString;
    }

    protected String getOriginalEUtDisplay(RecipeDisplayInfo recipeInfo) {
        OverclockCalculator originalPowerCalculator = OverclockCalculator.ofNoOverclock(recipeInfo.recipe).calculate();
        String original_tier_displayed = this.shouldShowAmperage(originalPowerCalculator) ? "" : GTUtility.getTierNameWithParentheses(originalPowerCalculator.getConsumption());
        String original_voltage = GTUtility.formatNumbers(originalPowerCalculator.getConsumption());
        return StatCollector.func_74837_a((String)"GT5U.nei.display.usage.original", (Object[])new Object[]{original_voltage, original_tier_displayed});
    }

    protected boolean wasOverclocked(OverclockCalculator calculator) {
        return calculator.getPerformedOverclocks() > 0;
    }
}

