/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing.advanced;

import gregtech.api.enums.Dyes;
import gregtech.api.enums.TAE;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.objects.overclockdescriber.OverclockDescriber;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.AdvancedFusionOverclockDescriber;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.tileentities.machines.multi.MTEFusionComputer;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import net.minecraft.block.Block;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;

public class MTEAdvFusionMk4
extends MTEFusionComputer {
    public MTEAdvFusionMk4(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEAdvFusionMk4(String aName) {
        super(aName);
    }

    @Override
    protected OverclockDescriber createOverclockDescriber() {
        return new AdvancedFusionOverclockDescriber((byte)this.tier(), this.capableStartupCanonical());
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Fusion Reactor").addInfo("HARNESSING THE POWER OF A BLUE GIANT").addInfo("\u00a7b131,072\u00a77 EU/t and \u00a7b320M\u00a77 EU capacity per Energy Hatch").addInfo("If the recipe has a startup cost greater than the").addInfo("number of energy hatches * cap, you can't do it").addInfo("Performs 4/4 overclocks").beginStructureBlock(15, 3, 15, false).addController("See diagram when placed").addCasingInfoMin("Fusion Machine Casings MK III", 79, false).addStructureInfo("Cover the coils with casing").addOtherStructurePart("Advanced Fusion Coils", "Center part of the ring").addEnergyHatch("1-16, Specified casings", 2).addInputHatch("2-16, Specified casings", 1).addOutputHatch("1-16, Specified casings", 3).addStructureInfo("ALL Hatches must be UHV or better").toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public int tier() {
        return 9;
    }

    @Override
    public long maxEUStore() {
        return 2560040000L * (long)Math.min(16, this.mEnergyHatches.size()) / 8L;
    }

    @Override
    public long capableStartupCanonical() {
        return 5120000000L;
    }

    @Override
    public int getRecipeCatalystPriority() {
        return -1;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEAdvFusionMk4(this.mName);
    }

    @Override
    public Block getCasing() {
        return this.getFusionCoil();
    }

    @Override
    public int getCasingMeta() {
        return 12;
    }

    @Override
    public Block getFusionCoil() {
        return ModBlocks.blockCasings3Misc;
    }

    @Override
    public int getFusionCoilMeta() {
        return 13;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return super.createProcessingLogic().enablePerfectOverclock();
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            return new ITexture[]{TextureFactory.of(Textures.BlockIcons.MACHINE_CASING_FUSION_GLASS, Dyes.getModulation(-1)), TextureFactory.builder().addIcon(this.getIconOverlay()).extFacing().build()};
        }
        if (!aActive) {
            return new ITexture[]{TextureFactory.of(Textures.BlockIcons.MACHINE_CASING_FUSION_GLASS, Dyes.getModulation(-1))};
        }
        return new ITexture[]{TextureFactory.of(TexturesGtBlock.TEXTURE_CASING_FUSION_CASING_ULTRA, Dyes.getModulation(-1))};
    }

    @Override
    public ITexture getTextureOverlay() {
        return TextureFactory.of(this.getBaseMetaTileEntity().isActive() ? TexturesGtBlock.Casing_Machine_Screen_3 : TexturesGtBlock.Casing_Machine_Screen_1);
    }

    public IIconContainer getIconOverlay() {
        return this.getBaseMetaTileEntity().isActive() ? TexturesGtBlock.Casing_Machine_Screen_3 : TexturesGtBlock.Casing_Machine_Screen_1;
    }

    @Override
    public boolean turnCasingActive(boolean status) {
        if (this.mEnergyHatches != null) {
            for (MTEHatch hatch : this.mEnergyHatches) {
                hatch.updateTexture(status ? TAE.getIndexFromPage(2, 14) : 53);
            }
        }
        if (this.mOutputHatches != null) {
            for (MTEHatch hatch : this.mOutputHatches) {
                hatch.updateTexture(status ? TAE.getIndexFromPage(2, 14) : 53);
            }
        }
        if (this.mInputHatches != null) {
            for (MTEHatch hatch : this.mInputHatches) {
                hatch.updateTexture(status ? TAE.getIndexFromPage(2, 14) : 53);
            }
        }
        return true;
    }

    @Override
    public String[] getInfoData() {
        String tier = "IV";
        float plasmaOut = 0.0f;
        int powerRequired = 0;
        if (this.mLastRecipe != null) {
            powerRequired = this.mLastRecipe.mEUt;
            if (this.mLastRecipe.getFluidOutput(0) != null) {
                plasmaOut = (float)this.mLastRecipe.getFluidOutput((int)0).amount / (float)this.mLastRecipe.mDuration;
            }
        }
        return new String[]{StatCollector.func_74837_a((String)"gtpp.infodata.adv_fusion.name", (Object[])new Object[]{tier}), StatCollector.func_74837_a((String)"gtpp.infodata.adv_fusion.eu_required", (Object[])new Object[]{powerRequired}), StatCollector.func_74837_a((String)"gtpp.infodata.adv_fusion.stored_eu", (Object[])new Object[]{this.mEUStore, this.maxEUStore()}), StatCollector.func_74837_a((String)"gtpp.infodata.adv_fusion.plasma_output", (Object[])new Object[]{Float.valueOf(plasmaOut)})};
    }
}

