/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production;

import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.TAE;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.pollution.PollutionConfig;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.MTEHatchElementalDataOrbHolder;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GTPPMultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MTEElementalDuplicator
extends GTPPMultiBlockBase<MTEElementalDuplicator>
implements ISurvivalConstructable {
    private final ArrayList<MTEHatchElementalDataOrbHolder> mReplicatorDataOrbHatches = new ArrayList();
    private static final int CASING_TEXTURE_ID = TAE.getIndexFromPage(0, 3);
    private int mCasing = 0;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static IStructureDefinition<MTEElementalDuplicator> STRUCTURE_DEFINITION = null;

    public MTEElementalDuplicator(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEElementalDuplicator(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEElementalDuplicator(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Replicator";
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(this.getMachineType()).addInfo("Produces Elemental Material from UU Matter").addBulkMachineInfo(8, 2.0f, 1.0f).addInfo("Maximum 1x of each bus/hatch").addInfo("Requires circuit 1-16 in your Data Orb Repository").addInfo("depending on what Data Orb you want to prioritize").addPerfectOCInfo().addPollutionAmount(this.getPollutionPerSecond(null)).beginStructureBlock(9, 6, 9, true).addController("Top Center").addCasingInfoMin("Elemental Confinement Shell", 120, false).addCasingInfoMin("Matter Fabricator Casing", 24, false).addCasingInfoMin("Particle Containment Casing", 24, false).addCasingInfoMin("Matter Generation Coil", 24, false).addCasingInfoMin("High Voltage Current Capacitor", 20, false).addCasingInfoMin("Resonance Chamber III", 24, false).addCasingInfoMin("Modulator III", 16, false).addOtherStructurePart(StatCollector.func_74838_a((String)"GTPP.tooltip.structure.data_orb_repository"), "1x", 1).addInputHatch("Any 1 dot hint", 1).addOutputBus("Any 1 dot hint", 1).addOutputHatch("Any 1 dot hint", 1).addEnergyHatch("Any 1 dot hint", 1).addMaintenanceHatch("Any 1 dot hint", 1).addMufflerHatch("Any 1 dot hint", 1).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public IStructureDefinition<MTEElementalDuplicator> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(STRUCTURE_PIECE_MAIN, (String[][])new String[][]{{"   ccc   ", "  ccccc  ", " ccccccc ", "ccccccccc", "cccc~cccc", "ccccccccc", " ccccccc ", "  ccccc  ", "   ccc   "}, {"   cac   ", "  abfba  ", " abfgfba ", "cbfgdgfbc", "afgdddgfa", "cbfgdgfbc", " abfgfba ", "  abfba  ", "   cac   "}, {"   cec   ", "  e   e  ", " e     e ", "c   d   c", "e  ddd  e", "c   d   c", " e     e ", "  e   e  ", "   cec   "}, {"   cec   ", "  e   e  ", " e     e ", "c   d   c", "e  ddd  e", "c   d   c", " e     e ", "  e   e  ", "   cec   "}, {"   cac   ", "  abfba  ", " abfgfba ", "cbfgdgfbc", "afgdddgfa", "cbfgdgfbc", " abfgfba ", "  abfba  ", "   cac   "}, {"   ccc   ", "  ccccc  ", " ccccccc ", "ccccccccc", "ccccccccc", "ccccccccc", " ccccccc ", "  ccccc  ", "   ccc   "}}).addElement('a', StructureUtility.ofBlock((Block)MTEElementalDuplicator.getCasingBlock4(), (int)MTEElementalDuplicator.getCasingMeta6())).addElement('b', StructureUtility.ofBlock((Block)MTEElementalDuplicator.getCasingBlock4(), (int)MTEElementalDuplicator.getCasingMeta7())).addElement('d', StructureUtility.ofBlock((Block)MTEElementalDuplicator.getCasingBlock2(), (int)MTEElementalDuplicator.getCasingMeta2())).addElement('e', StructureUtility.ofBlock((Block)MTEElementalDuplicator.getCasingBlock2(), (int)MTEElementalDuplicator.getCasingMeta3())).addElement('f', StructureUtility.ofBlock((Block)MTEElementalDuplicator.getCasingBlock3(), (int)MTEElementalDuplicator.getCasingMeta4())).addElement('g', StructureUtility.ofBlock((Block)MTEElementalDuplicator.getCasingBlock3(), (int)MTEElementalDuplicator.getCasingMeta5())).addElement('c', (IStructureElement)StructureUtility.lazy(t -> StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.buildHatchAdder(MTEElementalDuplicator.class).atLeast(HatchElement.InputHatch, HatchElement.OutputBus, HatchElement.OutputHatch, HatchElement.Maintenance, HatchElement.Muffler, HatchElement.Energy).casingIndex(MTEElementalDuplicator.getCasingTextureIndex()).dot(1).build(), GTStructureUtility.buildHatchAdder(MTEElementalDuplicator.class).hatchClass(MTEHatchElementalDataOrbHolder.class).shouldReject(x -> !x.mReplicatorDataOrbHatches.isEmpty()).adder(MTEElementalDuplicator::addDataOrbHatch).casingIndex(MTEElementalDuplicator.getCasingTextureIndex()).dot(1).build(), StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)MTEElementalDuplicator.getCasingBlock(), (int)MTEElementalDuplicator.getCasingMeta()))}))).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 4, 4, 0);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        boolean aDidBuild = this.checkPiece(STRUCTURE_PIECE_MAIN, 4, 4, 0);
        if (this.mReplicatorDataOrbHatches.size() != 1) {
            return false;
        }
        this.log("Casings: " + this.mCasing);
        return aDidBuild && this.mCasing >= 120 && this.checkHatch();
    }

    public int survivalConstruct(ItemStack itemStack, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivalBuildPiece(STRUCTURE_PIECE_MAIN, itemStack, 4, 4, 0, elementBudget, env, false, true);
    }

    protected static int getCasingTextureIndex() {
        return CASING_TEXTURE_ID;
    }

    protected static Block getCasingBlock() {
        return ModBlocks.blockCasings5Misc;
    }

    protected static Block getCasingBlock2() {
        return ModBlocks.blockSpecialMultiCasings;
    }

    protected static Block getCasingBlock3() {
        return ModBlocks.blockSpecialMultiCasings2;
    }

    protected static Block getCasingBlock4() {
        return ModBlocks.blockCasingsMisc;
    }

    protected static int getCasingMeta() {
        return 3;
    }

    protected static int getCasingMeta2() {
        return 12;
    }

    protected static int getCasingMeta3() {
        return 13;
    }

    protected static int getCasingMeta4() {
        return 2;
    }

    protected static int getCasingMeta5() {
        return 6;
    }

    protected static int getCasingMeta6() {
        return 9;
    }

    protected static int getCasingMeta7() {
        return 8;
    }

    private boolean addDataOrbHatch(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchElementalDataOrbHolder) {
            try {
                return this.addToMachineListInternal(this.mReplicatorDataOrbHatches, aMetaTileEntity, aBaseCasingIndex);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return false;
    }

    @Override
    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d == ForgeDirection.UP;
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return TexturesGtBlock.oMCAElementalDuplicatorActive;
    }

    @Override
    protected IIconContainer getActiveGlowOverlay() {
        return TexturesGtBlock.oMCAElementalDuplicatorActiveGlow;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return TexturesGtBlock.oMCAElementalDuplicator;
    }

    @Override
    protected IIconContainer getInactiveGlowOverlay() {
        return TexturesGtBlock.oMCAElementalDuplicatorGlow;
    }

    @Override
    protected int getCasingTextureId() {
        return CASING_TEXTURE_ID;
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.replicatorRecipes;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic().setSpeedBonus(0.5).enablePerfectOverclock().setMaxParallelSupplier(this::getTrueParallel);
    }

    @Override
    protected void setupProcessingLogic(ProcessingLogic logic) {
        block0: {
            super.setupProcessingLogic(logic);
            Iterator iterator = GTUtility.validMTEList(this.mReplicatorDataOrbHatches).iterator();
            if (!iterator.hasNext()) break block0;
            MTEHatchElementalDataOrbHolder hatch = (MTEHatchElementalDataOrbHolder)iterator.next();
            ItemStack orb = hatch.getOrbByCircuit();
            logic.setSpecialSlotItem(orb);
        }
    }

    @Override
    public int getMaxParallelRecipes() {
        return 8 * GTUtility.getTier(this.getMaxInputVoltage());
    }

    @Override
    public int getPollutionPerSecond(ItemStack aStack) {
        return PollutionConfig.pollutionPerSecondElementalDuplicator;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide() && (this.mUpdate == 1 || this.mStartUpCheck == 1)) {
            this.mReplicatorDataOrbHatches.clear();
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    @Override
    public ArrayList<ItemStack> getStoredInputsForColor(Optional<Byte> color) {
        ArrayList<ItemStack> tItems = super.getStoredInputsForColor(Optional.empty());
        for (MTEHatchElementalDataOrbHolder tHatch : GTUtility.validMTEList(this.mReplicatorDataOrbHatches)) {
            byte busColor = tHatch.getBaseMetaTileEntity().getColorization();
            if (color.isPresent() && busColor != -1 && busColor != color.get()) continue;
            tItems.add(tHatch.getOrbByCircuit());
        }
        tItems.removeAll(Collections.singleton(null));
        return tItems;
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74768_a("maxParallelRecipes", this.getMaxParallelRecipes());
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currentTip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        currentTip.add(StatCollector.func_74838_a((String)"GT5U.multiblock.parallelism") + ": " + EnumChatFormatting.WHITE + tag.func_74762_e("maxParallelRecipes"));
    }
}

