/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production.chemplant;

import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.AutoPlaceEnvironment;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.enums.SoundResource;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.metatileentity.implementations.MTEHatchEnergy;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.metatileentity.implementations.MTEHatchInputBus;
import gregtech.api.metatileentity.implementations.MTEHatchMaintenance;
import gregtech.api.metatileentity.implementations.MTEHatchOutput;
import gregtech.api.metatileentity.implementations.MTEHatchOutputBus;
import gregtech.api.metatileentity.implementations.MTETieredMachineBlock;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.tooltip.TooltipHelper;
import gregtech.api.util.tooltip.TooltipTier;
import gregtech.common.misc.GTStructureChannels;
import gregtech.common.tileentities.machines.IDualInputHatch;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.item.chemistry.general.ItemGenericChemBase;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechItemList;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GTPPMultiBlockBase;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.nbthandlers.MTEHatchCatalysts;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;

public class MTEChemicalPlant
extends GTPPMultiBlockBase<MTEChemicalPlant>
implements ISurvivalConstructable {
    private int mSolidCasingTier = 0;
    private int mMachineCasingTier = 0;
    private int mPipeCasingTier = 0;
    private int mCoilTier = 0;
    private HeatingCoilLevel checkCoil;
    private final int[] checkCasing = new int[8];
    private int checkMachine;
    private int checkPipe;
    private int maxTierOfHatch;
    private int mCasing;
    private static IStructureDefinition<MTEChemicalPlant> STRUCTURE_DEFINITION = null;
    public static final ItemStack[] chemplantCatalysts = new ItemStack[]{GregtechItemList.BlueMetalCatalyst.get(1L, new Object[0]), GregtechItemList.BrownMetalCatalyst.get(1L, new Object[0]), GregtechItemList.OrangeMetalCatalyst.get(1L, new Object[0]), GregtechItemList.PurpleMetalCatalyst.get(1L, new Object[0]), GregtechItemList.RedMetalCatalyst.get(1L, new Object[0]), GregtechItemList.YellowMetalCatalyst.get(1L, new Object[0]), GregtechItemList.PinkMetalCatalyst.get(1L, new Object[0]), GregtechItemList.FormaldehydeCatalyst.get(1L, new Object[0]), GregtechItemList.SolidAcidCatalyst.get(1L, new Object[0]), GregtechItemList.InfiniteMutationCatalyst.get(1L, new Object[0]), GregtechItemList.GreenMetalCatalyst.get(1L, new Object[0]), GregtechItemList.PlatinumGroupCatalyst.get(1L, new Object[0]), GregtechItemList.PlasticPolymerCatalyst.get(1L, new Object[0]), GregtechItemList.RubberPolymerCatalyst.get(1L, new Object[0]), GregtechItemList.AdhesionPromoterCatalyst.get(1L, new Object[0]), GregtechItemList.TitaTungstenIndiumCatalyst.get(1L, new Object[0]), GregtechItemList.RadioactivityCatalyst.get(1L, new Object[0]), GregtechItemList.RareEarthGroupCatalyst.get(1L, new Object[0]), GregtechItemList.SimpleNaquadahCatalyst.get(1L, new Object[0]), GregtechItemList.HellishForceCatalyst.get(1L, new Object[0]), GregtechItemList.CrystalColorizationCatalyst.get(1L, new Object[0]), GregtechItemList.AdvancedNaquadahCatalyst.get(1L, new Object[0]), GregtechItemList.RawIntelligenceCatalyst.get(1L, new Object[0]), GregtechItemList.UltimatePlasticCatalyst.get(1L, new Object[0]), GregtechItemList.BiologicalIntelligenceCatalyst.get(1L, new Object[0]), GregtechItemList.TemporalHarmonyCatalyst.get(1L, new Object[0]), GregtechItemList.ParticleAccelerationCatalyst.get(1L, new Object[0]), GregtechItemList.SynchrotronCapableCatalyst.get(1L, new Object[0]), GregtechItemList.AlgagenicGrowthPromoterCatalyst.get(1L, new Object[0])};
    private final ArrayList<MTEHatchCatalysts> mCatalystBuses = new ArrayList();
    private static final HashMap<Integer, Triple<Block, Integer, Integer>> mTieredBlockRegistry = new HashMap();

    public MTEChemicalPlant(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEChemicalPlant(String aName) {
        super(aName);
    }

    public static boolean registerMachineCasingForTier(int aTier, Block aBlock, int aMeta, int aCasingTextureID) {
        Triple aCasingData = Triple.of((Object)aBlock, (Object)aMeta, (Object)aCasingTextureID);
        if (mTieredBlockRegistry.containsKey(aTier)) {
            Logger.ERROR("Tried to register a Machine casing for tier " + aTier + " to the Chemical Plant, however this tier already contains one.");
            throw new IllegalStateException();
        }
        mTieredBlockRegistry.put(aTier, (Triple<Block, Integer, Integer>)aCasingData);
        GTStructureChannels.METAL_MACHINE_CASING.registerAsIndicator(new ItemStack(aBlock, 1, aMeta), aTier + 1);
        return true;
    }

    private static int getCasingTextureIdForTier(int aTier) {
        if (!mTieredBlockRegistry.containsKey(aTier)) {
            return 10;
        }
        return (Integer)mTieredBlockRegistry.get(aTier).getRight();
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEChemicalPlant(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Chemical Plant";
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        return new MultiblockTooltipBuilder().addMachineType(this.getMachineType()).addInfo("Heavy Industry, now right at your doorstep!").addInfo("Plant tier is determined by casing tier").addInfo("Hatch tiers can't be higher than machine casing tier, UHV casing unlocks all tiers").addDynamicParallelInfo(2, TooltipTier.PIPE_CASING).addInfo("+20% chance of not damaging catalyst per " + TooltipHelper.tierText(TooltipTier.PIPE_CASING) + " Tier").addDynamicSpeedInfo(0.5f, TooltipTier.COIL).addInfo("Any catalyst must be placed in the catalyst housing").addInfo("Awakened Draconium coils combined with Tungstensteel pipe casing makes catalyst unbreakable").addController("Bottom Center").addOtherStructurePart("Catalyst Housing", "Bottom Casing").addStructureHint("item.GTPP.catalyst_housing.name", 1).addInputBus("Bottom Casing", 1).addOutputBus("Bottom Casing", 1).addInputHatch("Bottom Casing", 1).addOutputHatch("Bottom Casing", 1).addEnergyHatch("Bottom Casing", 1).addMaintenanceHatch("Bottom Casing", 1).addSubChannelUsage(GTStructureChannels.METAL_MACHINE_CASING, "metal machine casing (minimum 70)").addSubChannelUsage(GTStructureChannels.TIER_MACHINE_CASING).addSubChannelUsage(GTStructureChannels.HEATING_COIL).addSubChannelUsage(GTStructureChannels.PIPE_CASING).toolTipFinisher(new String[0]);
    }

    public void setMachineMeta(int meta) {
        this.checkMachine = meta;
    }

    public int getMachineMeta() {
        return this.checkMachine;
    }

    public void setPipeMeta(int meta) {
        this.checkPipe = meta;
    }

    public int getPipeMeta() {
        return this.checkPipe;
    }

    public void setCoilMeta(HeatingCoilLevel meta) {
        this.checkCoil = meta;
    }

    public HeatingCoilLevel getCoilMeta() {
        return this.checkCoil;
    }

    @Override
    public IStructureDefinition<MTEChemicalPlant> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            IStructureElement allCasingsElement = GTStructureChannels.METAL_MACHINE_CASING.use(StructureUtility.ofChain(IntStream.range(0, 8).mapToObj(MTEChemicalPlant::ofSolidCasing).collect(Collectors.toList())));
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"XXXXXXX", "XXXXXXX", "XXXXXXX", "XXXXXXX", "XXXXXXX", "XXXXXXX", "XXXXXXX"}, {"X     X", " MMMMM ", " MHHHM ", " MHHHM ", " MHHHM ", " MMMMM ", "X     X"}, {"X     X", "       ", "  PPP  ", "  PPP  ", "  PPP  ", "       ", "X     X"}, {"X     X", "       ", "  HHH  ", "  HHH  ", "  HHH  ", "       ", "X     X"}, {"X     X", "       ", "  PPP  ", "  PPP  ", "  PPP  ", "       ", "X     X"}, {"X     X", " MMMMM ", " MHHHM ", " MHHHM ", " MHHHM ", " MMMMM ", "X     X"}, {"CCC~CCC", "CMMMMMC", "CMMMMMC", "CMMMMMC", "CMMMMMC", "CMMMMMC", "CCCCCCC"}})).addElement('C', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.buildHatchAdder(MTEChemicalPlant.class).atLeast(HatchElement.Maintenance).casingIndex(this.getCasingTextureID()).dot(1).build(), GTStructureUtility.buildHatchAdder(MTEChemicalPlant.class).atLeast(HatchElement.InputHatch, HatchElement.OutputHatch, HatchElement.InputBus, HatchElement.OutputBus).adder(MTEChemicalPlant::addChemicalPlantList).hatchItemFilterAnd((t, s) -> GTStructureUtility.filterByMTETier(Integer.MIN_VALUE, s.field_77994_a >= 10 ? Integer.MAX_VALUE : s.field_77994_a)).casingIndex(this.getCasingTextureID()).dot(1).build(), GTStructureUtility.buildHatchAdder(MTEChemicalPlant.class).hatchClass(MTEHatchCatalysts.class).shouldReject(t -> !t.mCatalystBuses.isEmpty()).adder(MTEChemicalPlant::addChemicalPlantList).casingIndex(this.getCasingTextureID()).dot(1).build(), allCasingsElement})).addElement('X', allCasingsElement).addElement('M', GTStructureChannels.TIER_MACHINE_CASING.use(MTEChemicalPlant.addTieredBlock(GregTechAPI.sBlockCasings1, MTEChemicalPlant::setMachineMeta, MTEChemicalPlant::getMachineMeta, 10))).addElement('H', GTStructureChannels.HEATING_COIL.use(GTStructureUtility.activeCoils(GTStructureUtility.ofCoil(MTEChemicalPlant::setCoilMeta, MTEChemicalPlant::getCoilMeta)))).addElement('P', GTStructureChannels.PIPE_CASING.use(MTEChemicalPlant.addTieredBlock(GregTechAPI.sBlockCasings2, MTEChemicalPlant::setPipeMeta, MTEChemicalPlant::getPipeMeta, 12, 16))).build();
        }
        return STRUCTURE_DEFINITION;
    }

    private static IStructureElement<MTEChemicalPlant> ofSolidCasing(final int aIndex) {
        return new IStructureElement<MTEChemicalPlant>(){

            public boolean check(MTEChemicalPlant t, World world, int x, int y, int z) {
                if (this.check(aIndex, world, x, y, z)) {
                    int[] nArray = t.checkCasing;
                    int n = aIndex;
                    nArray[n] = nArray[n] + 1;
                    t.mCasing++;
                    return true;
                }
                return false;
            }

            public boolean couldBeValid(MTEChemicalPlant mteChemicalPlant, World world, int x, int y, int z, ItemStack trigger) {
                return this.check(aIndex, world, x, y, z);
            }

            private boolean check(int aIndex2, World world, int x, int y, int z) {
                Block block = world.func_147439_a(x, y, z);
                int meta = world.func_72805_g(x, y, z);
                Block target = (Block)((Triple)mTieredBlockRegistry.get(aIndex2)).getLeft();
                int targetMeta = (Integer)((Triple)mTieredBlockRegistry.get(aIndex2)).getMiddle();
                return target.equals(block) && meta == targetMeta;
            }

            int getIndex(int size) {
                if (size > 8) {
                    size = 8;
                }
                return size - 1;
            }

            public boolean spawnHint(MTEChemicalPlant t, World world, int x, int y, int z, ItemStack trigger) {
                StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)((Block)((Triple)mTieredBlockRegistry.get(this.getIndex(trigger.field_77994_a))).getLeft()), (int)((Integer)((Triple)mTieredBlockRegistry.get(this.getIndex(trigger.field_77994_a))).getMiddle()));
                return true;
            }

            public boolean placeBlock(MTEChemicalPlant t, World world, int x, int y, int z, ItemStack trigger) {
                return world.func_147465_d(x, y, z, (Block)((Triple)mTieredBlockRegistry.get(this.getIndex(trigger.field_77994_a))).getLeft(), ((Integer)((Triple)mTieredBlockRegistry.get(this.getIndex(trigger.field_77994_a))).getMiddle()).intValue(), 3);
            }

            @Nullable
            public IStructureElement.BlocksToPlace getBlocksToPlace(MTEChemicalPlant gregtechMTE_chemicalPlant, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return IStructureElement.BlocksToPlace.create((Block)((Block)((Triple)mTieredBlockRegistry.get(this.getIndex(trigger.field_77994_a))).getLeft()), (int)((Integer)((Triple)mTieredBlockRegistry.get(this.getIndex(trigger.field_77994_a))).getMiddle()));
            }

            public IStructureElement.PlaceResult survivalPlaceBlock(MTEChemicalPlant t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                if (this.check(this.getIndex(trigger.field_77994_a), world, x, y, z)) {
                    return IStructureElement.PlaceResult.SKIP;
                }
                return StructureUtility.survivalPlaceBlock((Block)((Block)((Triple)mTieredBlockRegistry.get(this.getIndex(trigger.field_77994_a))).getLeft()), (int)((Integer)((Triple)mTieredBlockRegistry.get(this.getIndex(trigger.field_77994_a))).getMiddle()), (World)world, (int)x, (int)y, (int)z, (IItemSource)env.getSource(), (EntityPlayer)env.getActor(), (Consumer)env.getChatter());
            }
        };
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 3, 6, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivalBuildPiece(this.mName, stackSize, 3, 6, 0, elementBudget, env, false, true);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        int i;
        this.mCasing = 0;
        for (i = 0; i < 8; ++i) {
            this.checkCasing[i] = 0;
        }
        this.checkPipe = 0;
        this.checkMachine = 0;
        this.mSolidCasingTier = 0;
        this.mMachineCasingTier = 0;
        this.mPipeCasingTier = 0;
        this.mCoilTier = 0;
        this.maxTierOfHatch = 0;
        this.mCatalystBuses.clear();
        this.setCoilMeta(HeatingCoilLevel.None);
        if (this.checkPiece(this.mName, 3, 6, 0) && this.mCasing >= 70) {
            for (i = 0; i < 8; ++i) {
                if (this.checkCasing[i] == this.mCasing) {
                    this.mSolidCasingTier = i;
                    continue;
                }
                if (this.checkCasing[i] <= 0) continue;
                return false;
            }
            this.mMachineCasingTier = this.checkMachine - 1;
            this.mPipeCasingTier = this.checkPipe - 12;
            this.mCoilTier = this.checkCoil.getTier();
            this.getBaseMetaTileEntity().sendBlockEvent((byte)1, this.getUpdateData());
            this.updateHatchTexture();
            return (this.mMachineCasingTier >= 9 || this.mMachineCasingTier >= this.maxTierOfHatch) && this.mCatalystBuses.size() <= 1;
        }
        return false;
    }

    public void updateHatchTexture() {
        for (MTEHatch mTEHatch : this.mCatalystBuses) {
            mTEHatch.updateTexture(this.getCasingTextureID());
        }
        for (IDualInputHatch iDualInputHatch : this.mDualInputHatches) {
            iDualInputHatch.updateTexture(this.getCasingTextureID());
        }
        for (MTEHatch mTEHatch : this.mInputBusses) {
            mTEHatch.updateTexture(this.getCasingTextureID());
        }
        for (MTEHatch mTEHatch : this.mMaintenanceHatches) {
            mTEHatch.updateTexture(this.getCasingTextureID());
        }
        for (MTEHatch mTEHatch : this.mEnergyHatches) {
            mTEHatch.updateTexture(this.getCasingTextureID());
        }
        for (MTEHatch mTEHatch : this.mOutputBusses) {
            mTEHatch.updateTexture(this.getCasingTextureID());
        }
        for (MTEHatch mTEHatch : this.mInputHatches) {
            mTEHatch.updateTexture(this.getCasingTextureID());
        }
        for (MTEHatch mTEHatch : this.mOutputHatches) {
            mTEHatch.updateTexture(this.getCasingTextureID());
        }
    }

    public final boolean addChemicalPlantList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof MTEHatchCatalysts) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof MTEHatchInputBus) {
            this.maxTierOfHatch = Math.max(this.maxTierOfHatch, ((MTEHatchInputBus)aMetaTileEntity).mTier);
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof MTEHatchMaintenance) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof MTEHatchEnergy) {
            this.maxTierOfHatch = Math.max(this.maxTierOfHatch, ((MTEHatchEnergy)aMetaTileEntity).mTier);
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof MTEHatchOutputBus) {
            this.maxTierOfHatch = Math.max(this.maxTierOfHatch, ((MTEHatchOutputBus)aMetaTileEntity).mTier);
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof MTEHatchInput) {
            this.maxTierOfHatch = Math.max(this.maxTierOfHatch, ((MTEHatchInput)aMetaTileEntity).mTier);
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof MTEHatchOutput) {
            this.maxTierOfHatch = Math.max(this.maxTierOfHatch, ((MTEHatchOutput)aMetaTileEntity).mTier);
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    @Override
    protected SoundResource getProcessStartSound() {
        return SoundResource.GTCEU_LOOP_CHEMICAL;
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return TexturesGtBlock.oMCAChemicalPlantActive;
    }

    @Override
    protected IIconContainer getActiveGlowOverlay() {
        return TexturesGtBlock.oMCAChemicalPlantActiveGlow;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return TexturesGtBlock.oMCAChemicalPlant;
    }

    @Override
    protected IIconContainer getInactiveGlowOverlay() {
        return TexturesGtBlock.oMCAChemicalPlantGlow;
    }

    @Override
    protected int getCasingTextureId() {
        return this.getCasingTextureID();
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return GTPPRecipeMaps.chemicalPlantRecipes;
    }

    @Override
    public int getMaxParallelRecipes() {
        return 2 * this.getPipeCasingTier();
    }

    private int getSolidCasingTier() {
        return this.mSolidCasingTier;
    }

    private int getMachineCasingTier() {
        return this.mMachineCasingTier;
    }

    private int getPipeCasingTier() {
        return this.mPipeCasingTier;
    }

    private int getCasingTextureID() {
        int aTier = this.mSolidCasingTier;
        return MTEChemicalPlant.getCasingTextureIdForTier(aTier);
    }

    public boolean addToMachineList(IGregTechTileEntity aTileEntity) {
        int aMaxTier = this.getMachineCasingTier();
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof MTETieredMachineBlock) {
            MTETieredMachineBlock aMachineBlock = (MTETieredMachineBlock)aMetaTileEntity;
            byte aTileTier = aMachineBlock.mTier;
            if (aTileTier > aMaxTier) {
                this.log("Hatch tier too high.");
                return false;
            }
            return this.addToMachineList(aTileEntity, this.getCasingTextureID());
        }
        this.log("Bad Tile Entity being added to hatch map.");
        return false;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("mSolidCasingTier", this.mSolidCasingTier);
        aNBT.func_74768_a("mMachineCasingTier", this.mMachineCasingTier);
        aNBT.func_74768_a("mPipeCasingTier", this.mPipeCasingTier);
        aNBT.func_74768_a("mCoilTier", this.mCoilTier);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mSolidCasingTier = aNBT.func_74762_e("mSolidCasingTier");
        this.mMachineCasingTier = aNBT.func_74762_e("mMachineCasingTier");
        this.mPipeCasingTier = aNBT.func_74762_e("mPipeCasingTier");
        this.mCoilTier = aNBT.func_74762_e("mCoilTier");
    }

    @Override
    public boolean addToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchCatalysts) {
            this.log("Found MTEHatchCatalysts");
            return this.addToMachineListInternal(this.mCatalystBuses, aMetaTileEntity, aBaseCasingIndex);
        }
        return super.addToMachineList(aTileEntity, aBaseCasingIndex);
    }

    public int getMaxCatalystDurability() {
        return 50;
    }

    @Override
    public byte getUpdateData() {
        return (byte)this.mSolidCasingTier;
    }

    @Override
    public void receiveClientEvent(byte aEventID, byte aValue) {
        super.receiveClientEvent(aEventID, aValue);
        if (aEventID == 1 && (aValue & 0x80) == 0) {
            this.mSolidCasingTier = aValue;
        }
    }

    private boolean damageCatalyst(@Nonnull ItemStack aStack, int minParallel) {
        if (!this.isCatalystDamageable()) {
            return false;
        }
        for (int i = 0; i < minParallel; ++i) {
            if (!((double)(MathUtils.randFloat(0.0f, 1.0E7f) / 1.0E7f) < (double)1.2f - 0.2 * (double)this.mPipeCasingTier)) continue;
            int damage = this.getDamage(aStack) + 1;
            if (damage >= this.getMaxCatalystDurability()) {
                this.addOutput(CI.getEmptyCatalyst(1));
                --aStack.field_77994_a;
                return aStack.field_77994_a == 0;
            }
            this.setDamage(aStack, damage);
        }
        return false;
    }

    private boolean isCatalystDamageable() {
        return this.mCoilTier < 10 || this.mPipeCasingTier < 4;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){
            ItemStack catalyst;

            @Override
            @NotNull
            protected CheckRecipeResult validateRecipe(@NotNull GTRecipe recipe) {
                if (recipe.mSpecialValue > MTEChemicalPlant.this.mSolidCasingTier) {
                    return CheckRecipeResultRegistry.insufficientMachineTier(recipe.mSpecialValue + 1);
                }
                ItemStack catalystInRecipe = null;
                for (ItemStack item : recipe.mInputs) {
                    if (!MTEChemicalPlant.isCatalyst(item)) continue;
                    catalystInRecipe = item;
                    break;
                }
                if (catalystInRecipe != null) {
                    this.catalyst = MTEChemicalPlant.this.findCatalyst(MTEChemicalPlant.this.getCatalystInputs().toArray(new ItemStack[0]), catalystInRecipe);
                    if (this.catalyst == null) {
                        return SimpleCheckRecipeResult.ofFailure("no_catalyst");
                    }
                } else {
                    this.catalyst = null;
                }
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            @Override
            @NotNull
            public CheckRecipeResult process() {
                ArrayList<ItemStack> inputItemsList = new ArrayList<ItemStack>(Arrays.asList(this.inputItems));
                inputItemsList.addAll(MTEChemicalPlant.this.getCatalystInputs());
                this.inputItems = inputItemsList.toArray(new ItemStack[0]);
                return super.process();
            }

            @Override
            @NotNull
            protected CheckRecipeResult onRecipeStart(@NotNull GTRecipe recipe) {
                if (!GTUtility.isStackValid(this.catalyst) || MTEChemicalPlant.this.damageCatalyst(this.catalyst, this.getCurrentParallels())) {
                    this.catalyst = null;
                }
                return super.onRecipeStart(recipe);
            }
        }.setMaxParallelSupplier(this::getTrueParallel);
    }

    @Override
    protected void setupProcessingLogic(ProcessingLogic logic) {
        super.setupProcessingLogic(logic);
        logic.setSpeedBonus(2.0f / (float)(1 + this.mCoilTier));
    }

    @Override
    public void updateSlots() {
        super.updateSlots();
        for (MTEHatchCatalysts h : this.mCatalystBuses) {
            h.updateSlots();
            h.tryFillUsageSlots();
        }
    }

    private ItemStack findCatalyst(ItemStack[] aItemInputs, ItemStack catalyst) {
        if (aItemInputs != null) {
            for (ItemStack item : aItemInputs) {
                if (!GTUtility.areStacksEqual(item, catalyst, true)) continue;
                return item;
            }
        }
        return null;
    }

    private int getDamage(@Nonnull ItemStack aStack) {
        return ItemGenericChemBase.getCatalystDamage(aStack);
    }

    private void setDamage(@Nonnull ItemStack aStack, int aAmount) {
        ItemGenericChemBase.setCatalystDamage(aStack, aAmount);
    }

    public ArrayList<ItemStack> getCatalystInputs() {
        ArrayList<ItemStack> tItems = new ArrayList<ItemStack>();
        for (MTEHatchCatalysts tHatch : GTUtility.validMTEList(this.mCatalystBuses)) {
            ArrayList<ItemStack> aHatchContent = tHatch.getContentUsageSlots();
            if (aHatchContent.isEmpty()) continue;
            tItems.addAll(aHatchContent);
        }
        return tItems;
    }

    public static boolean isCatalyst(ItemStack aStack) {
        for (ItemStack chemplantCatalyst : chemplantCatalysts) {
            if (!GTUtility.areStacksEqual(aStack, chemplantCatalyst, true)) continue;
            return true;
        }
        return false;
    }
}

