/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.item;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.util.GTUtility;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import tectech.TecTech;
import tectech.thing.CustomItemList;
import tectech.thing.metaTileEntity.multi.base.Parameters;
import tectech.thing.metaTileEntity.multi.base.TTMultiblockBase;
import tectech.util.CommonValues;

public final class ItemParametrizerMemoryCard
extends Item {
    public static ItemParametrizerMemoryCard INSTANCE;
    private static IIcon locked;
    private static IIcon unlocked;

    private ItemParametrizerMemoryCard() {
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77655_b("em.parametrizerMemoryCard");
        this.func_111206_d("tectech:itemParametrizerMemoryCardUnlocked");
        this.func_77637_a(TecTech.creativeTabTecTech);
    }

    public boolean onItemUseFirst(ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, int ordinalSide, float hitX, float hitY, float hitZ) {
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (!(aPlayer instanceof EntityPlayerMP)) {
            return false;
        }
        if (!(tTileEntity instanceof IGregTechTileEntity)) {
            return false;
        }
        aStack.field_77994_a = 1;
        IMetaTileEntity metaTE = ((IGregTechTileEntity)tTileEntity).getMetaTileEntity();
        if (metaTE instanceof TTMultiblockBase) {
            TTMultiblockBase controller = (TTMultiblockBase)metaTE;
            if (aStack.func_77978_p() == null) {
                aStack.func_77982_d(new NBTTagCompound());
            }
            NBTTagCompound tNBT = aStack.func_77978_p();
            if (aStack.func_77960_j() == 1) {
                if (!this.hasIdenticalParameterList(this.getControllerParameters(controller), tNBT)) {
                    String reason = !tNBT.func_74764_b("controller") ? StatCollector.func_74838_a((String)"item.em.parametrizerMemoryCard.noConfig") : StatCollector.func_74837_a((String)"item.em.parametrizerMemoryCard.controllerMismatch", (Object[])new Object[]{tNBT.func_74779_i("controller"), controller.getLocalName()});
                    GTUtility.sendChatToPlayer(aPlayer, reason);
                    return true;
                }
                NBTTagList tagList = tNBT.func_150295_c("paramList", 10);
                for (int hatch = 0; hatch < 10; ++hatch) {
                    NBTTagCompound tag = tagList.func_150305_b(hatch);
                    controller.parametrization.trySetParameters(hatch, tag.func_74769_h("value0D"), tag.func_74769_h("value1D"));
                }
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"item.em.parametrizerMemoryCard.pasteMessage"));
            } else {
                NBTTagCompound newTag = new NBTTagCompound();
                NBTTagList tagList = new NBTTagList();
                for (int hatch = 0; hatch < 10; ++hatch) {
                    NBTTagCompound tagChild = new NBTTagCompound();
                    Parameters.Group.ParameterIn[] parameters = controller.parametrization.getGroup((int)hatch).parameterIn;
                    if (parameters[0] != null && !parameters[0].getBrief().equals(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.cfgi.9"))) {
                        tagChild.func_74780_a("value0D", parameters[0].get());
                        tagChild.func_74778_a("name0", parameters[0].getBrief());
                    }
                    if (parameters[1] != null && !parameters[1].getBrief().equals(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.cfgi.9"))) {
                        tagChild.func_74780_a("value1D", parameters[1].get());
                        tagChild.func_74778_a("name1", parameters[1].getBrief());
                    }
                    tagList.func_74742_a((NBTBase)tagChild);
                }
                newTag.func_74778_a("controller", controller.getLocalName());
                newTag.func_74778_a("coords", aX + ", " + aY + ", " + aZ);
                newTag.func_74782_a("paramList", (NBTBase)tagList);
                aStack.func_77982_d(newTag);
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"item.em.parametrizerMemoryCard.copyMessage"));
            }
            return true;
        }
        return false;
    }

    private ArrayList<String> getControllerParameters(TTMultiblockBase controller) {
        ArrayList<String> parameterList = new ArrayList<String>();
        for (int hatch = 0; hatch < 10; ++hatch) {
            Parameters.Group.ParameterIn[] parameters = controller.parametrization.getGroup((int)hatch).parameterIn;
            if (parameters[0] != null) {
                parameterList.add(parameters[0].getBrief());
            }
            if (parameters[1] == null) continue;
            parameterList.add(parameters[1].getBrief());
        }
        return parameterList;
    }

    private boolean hasIdenticalParameterList(ArrayList<String> controllerParameters, NBTTagCompound tNBT) {
        if (tNBT.func_150297_b("paramList", 9)) {
            NBTTagList tagList = tNBT.func_150295_c("paramList", 10);
            for (int hatch = 0; hatch < 10; ++hatch) {
                NBTTagCompound tag = tagList.func_150305_b(hatch);
                if (tag.func_82582_d()) continue;
                if (tag.func_74764_b("name0") && !controllerParameters.contains(tag.func_74779_i("name0"))) {
                    return false;
                }
                if (!tag.func_74764_b("name1") || controllerParameters.contains(tag.func_74779_i("name1"))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public ItemStack func_77659_a(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        if (aPlayer instanceof EntityPlayerMP && aPlayer.func_70093_af()) {
            aStack.field_77994_a = 1;
            if (aStack.func_77960_j() == 1) {
                aStack.func_77964_b(0);
            } else {
                aStack.func_77964_b(1);
            }
            return aStack;
        }
        return aStack;
    }

    public String func_77653_i(ItemStack stack) {
        if (stack.func_77960_j() == 1) {
            return StatCollector.func_74838_a((String)"item.em.parametrizerMemoryCard.name.paste");
        }
        return StatCollector.func_74838_a((String)"item.em.parametrizerMemoryCard.name.copy");
    }

    public void func_77624_a(ItemStack aStack, EntityPlayer ep, List<String> aList, boolean boo) {
        NBTTagCompound tNBT = aStack.func_77978_p();
        aList.add(CommonValues.THETA_MOVEMENT);
        aList.add(StatCollector.func_74838_a((String)"item.em.parametrizerMemoryCard.desc.0"));
        if (aStack.func_77960_j() == 1) {
            aList.add(EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"item.em.parametrizerMemoryCard.desc.1"));
        } else {
            aList.add(EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"item.em.parametrizerMemoryCard.desc.2"));
        }
        aList.add(EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"item.em.parametrizerMemoryCard.desc.3"));
        if (tNBT == null) {
            return;
        }
        if (tNBT.func_74764_b("controller")) {
            aList.add(StatCollector.func_74837_a((String)"item.em.parametrizerMemoryCard.desc.copied_controller", (Object[])new Object[]{EnumChatFormatting.RED + tNBT.func_74779_i("controller") + EnumChatFormatting.RESET, EnumChatFormatting.GREEN + tNBT.func_74779_i("coords")}));
        }
        if (tNBT.func_150297_b("paramList", 9)) {
            NBTTagList tagList = tNBT.func_150295_c("paramList", 10);
            for (int hatch = 0; hatch < 10; ++hatch) {
                NBTTagCompound tag = tagList.func_150305_b(hatch);
                if (tag.func_74764_b("name0")) {
                    aList.add(EnumChatFormatting.AQUA + tag.func_74779_i("name0") + ": " + EnumChatFormatting.GRAY + tag.func_74769_h("value0D"));
                }
                if (!tag.func_74764_b("name1")) continue;
                aList.add(EnumChatFormatting.AQUA + tag.func_74779_i("name1") + ": " + EnumChatFormatting.GRAY + tag.func_74769_h("value1D"));
            }
        }
    }

    public static void run() {
        INSTANCE = new ItemParametrizerMemoryCard();
        GameRegistry.registerItem((Item)INSTANCE, (String)INSTANCE.func_77658_a());
        CustomItemList.parametrizerMemory.set(INSTANCE);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        locked = iconRegister.func_94245_a("tectech:itemParametrizerMemoryCardLocked");
        unlocked = this.field_77791_bV = iconRegister.func_94245_a(this.func_111208_A());
    }

    public IIcon func_77617_a(int damage) {
        if (damage == 1) {
            return locked;
        }
        return unlocked;
    }

    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        ItemStack that = new ItemStack((Item)this, 1);
        that.func_77982_d(new NBTTagCompound());
        list.add(that);
    }
}

