/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.tileentity;

import chylex.hee.packets.AbstractPacket;
import chylex.hee.packets.PacketPipeline;
import chylex.hee.packets.client.C10ParticleEnergyTransfer;
import chylex.hee.system.logging.Stopwatch;
import chylex.hee.system.savedata.WorldDataHandler;
import chylex.hee.system.savedata.types.EnergySavefile;
import chylex.hee.system.util.MathUtil;
import chylex.hee.tileentity.TileEntityAbstractInventory;
import chylex.hee.tileentity.TileEntityEnergyCluster;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkPosition;

public abstract class TileEntityAbstractEnergyInventory
extends TileEntityAbstractInventory {
    protected static final byte[] chunkOffX = new byte[]{-1, -1, -1, 0, 0, 0, 1, 1, 1};
    protected static final byte[] chunkOffZ = new byte[]{-1, 0, 1, -1, 0, 1, -1, 0, 1};
    private byte drainTimer;
    private float energyLeft = -1.0f;
    private boolean draining;
    private boolean hasInsufficientEnergy;

    protected abstract byte getDrainTimer();

    protected abstract float getDrainAmount();

    protected abstract boolean isWorking();

    protected abstract void onWork();

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.isWorking()) {
            this.draining = true;
            if (MathUtil.floatEquals(this.energyLeft, 0.0f)) {
                this.onWork();
                if (this.hasInsufficientEnergy) {
                    this.hasInsufficientEnergy = false;
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            } else if (!this.hasInsufficientEnergy && !MathUtil.floatEquals(this.energyLeft, -1.0f)) {
                this.hasInsufficientEnergy = true;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        } else {
            this.hasInsufficientEnergy = false;
            this.draining = false;
            this.energyLeft = -1.0f;
        }
        if (this.draining && (this.drainTimer == 0 || (this.drainTimer = (byte)(this.drainTimer - 1)) == 0)) {
            float drain;
            Stopwatch.timeAverage("TileEntityAbstractEnergyInventory - drain", 1000);
            float f = drain = this.energyLeft <= 0.0f ? this.getDrainAmount() : this.energyLeft;
            if (this.field_145850_b.field_73011_w.field_76574_g == 1) {
                float newDrain = ((EnergySavefile)WorldDataHandler.get(EnergySavefile.class)).getFromBlockCoords(this.field_145850_b, this.field_145851_c, this.field_145849_e, true).drainEnergy(drain);
                if (!MathUtil.floatEquals(newDrain, drain)) {
                    PacketPipeline.sendToAllAround(this, 64.0, (AbstractPacket)new C10ParticleEnergyTransfer(this, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 96.0, (double)this.field_145849_e + 0.5, 80, 80, 80));
                }
                drain = newDrain;
            }
            if (drain > 1.0E-4f) {
                ArrayList<TileEntityEnergyCluster> clusters = new ArrayList<TileEntityEnergyCluster>();
                int chunkX = this.field_145851_c >> 4;
                int chunkZ = this.field_145849_e >> 4;
                for (int a = 0; a < 9; ++a) {
                    Map tiles = this.field_145850_b.func_72964_e((int)(chunkX + TileEntityAbstractEnergyInventory.chunkOffX[a]), (int)(chunkZ + TileEntityAbstractEnergyInventory.chunkOffZ[a])).field_150816_i;
                    int cx = chunkX * 16 + chunkOffX[a] * 16;
                    int cz = chunkZ * 16 + chunkOffZ[a] * 16;
                    for (Map.Entry entry : tiles.entrySet()) {
                        ChunkPosition pos = (ChunkPosition)entry.getKey();
                        if (((TileEntity)entry.getValue()).getClass() != TileEntityEnergyCluster.class || !(MathUtil.distance(cx + pos.field_151329_a - this.field_145851_c, pos.field_151327_b - this.field_145848_d, cz + pos.field_151328_c - this.field_145849_e) <= 16.0)) continue;
                        clusters.add((TileEntityEnergyCluster)((Object)entry.getValue()));
                    }
                }
                if (!clusters.isEmpty()) {
                    Collections.shuffle(clusters, this.field_145850_b.field_73012_v);
                    Iterator iter = clusters.iterator();
                    while (iter.hasNext()) {
                        float f2;
                        drain = ((TileEntityEnergyCluster)((Object)iter.next())).drainEnergy(drain, this);
                        if (!(f2 < 1.0E-4f)) continue;
                    }
                }
            }
            this.drainTimer = this.getDrainTimer();
            this.energyLeft = drain < 1.0E-4f ? 0.0f : drain;
            Stopwatch.finish("TileEntityAbstractEnergyInventory - drain");
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("engInsuf", this.hasInsufficientEnergy);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.hasInsufficientEnergy = packet.func_148857_g().func_74767_n("engInsuf");
        this.field_145850_b.func_147458_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @SideOnly(value=Side.CLIENT)
    public final boolean hasInsufficientEnergy() {
        return this.hasInsufficientEnergy;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74774_a("drainTim", this.drainTimer);
        nbt.func_74776_a("engLeft", this.energyLeft);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.drainTimer = nbt.func_74771_c("drainTim");
        this.energyLeft = nbt.func_74760_g("engLeft");
    }
}

