/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.entity.mob;

import cpw.mods.fml.common.eventhandler.Event;
import galaxyspace.GalaxySpace;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import micdoodle8.mods.galacticraft.api.entity.IEntityBreathable;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.items.GCItems;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;

public class EntityEvolvedEnderman
extends EntityMob
implements IEntityBreathable {
    private static final Set<Block> CARRIABLE = new HashSet<Block>();
    private static final UUID ATTACK_SPEED_BOOST_MODIFIER_UUID = UUID.fromString("020E0DFB-87AE-4653-9556-831010E291A0");
    private static final AttributeModifier ATTACK_SPEED_BOOST_MODIFIER = new AttributeModifier(ATTACK_SPEED_BOOST_MODIFIER_UUID, "Attacking speed boost", (double)6.2f, 0).func_111168_a(false);
    private int teleportDelay;
    private int stareTimer;
    private Entity lastEntityToAttack;
    private boolean isAggressive;

    public EntityEvolvedEnderman(World world) {
        super(world);
        this.func_70105_a(0.6f, 2.9f);
        this.field_70138_W = 1.0f;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.300000011920929);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(7.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)0);
        this.field_70180_af.func_75682_a(18, (Object)0);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74777_a("carried", (short)Block.func_149682_b((Block)this.getCarried()));
        nbt.func_74777_a("carriedData", (short)this.getCarryingData());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setCarried(Block.func_149729_e((int)nbt.func_74765_d("carried")));
        this.setCarryingData(nbt.func_74765_d("carriedData"));
    }

    protected Entity func_70782_k() {
        EntityPlayer entityplayer = this.field_70170_p.func_72856_b((Entity)this, 64.0);
        if (entityplayer != null) {
            if (this.shouldAttackPlayer(entityplayer)) {
                this.isAggressive = true;
                if (this.stareTimer == 0) {
                    this.field_70170_p.func_72908_a(entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, "mob.endermen.stare", 1.0f, 1.0f);
                }
                if (this.stareTimer++ == 5) {
                    this.stareTimer = 0;
                    this.setScreaming(true);
                    return entityplayer;
                }
            } else {
                this.stareTimer = 0;
            }
        }
        return null;
    }

    private boolean shouldAttackPlayer(EntityPlayer player) {
        ItemStack itemstack = player.field_71071_by.field_70460_b[3];
        if (itemstack != null && itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150423_aK)) {
            return false;
        }
        Vec3 lookVec = player.func_70676_i(1.0f).func_72432_b();
        Vec3 posDiffVec = Vec3.func_72443_a((double)(this.field_70165_t - player.field_70165_t), (double)(this.field_70121_D.field_72338_b + (double)(this.field_70131_O / 2.0f) - (player.field_70163_u + (double)player.func_70047_e())), (double)(this.field_70161_v - player.field_70161_v));
        double length = posDiffVec.func_72433_c();
        return lookVec.func_72430_b(posDiffVec = posDiffVec.func_72432_b()) > 1.0 - 0.025 / length && player.func_70685_l((Entity)this);
    }

    public void func_70636_d() {
        float f;
        if (this.func_70026_G()) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
        if (this.lastEntityToAttack != this.field_70789_a) {
            IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
            iattributeinstance.func_111124_b(ATTACK_SPEED_BOOST_MODIFIER);
            if (this.field_70789_a != null) {
                iattributeinstance.func_111121_a(ATTACK_SPEED_BOOST_MODIFIER);
            }
        }
        this.lastEntityToAttack = this.field_70789_a;
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
            int rZ;
            int rY;
            Block block;
            if (this.getCarried().func_149688_o() == Material.field_151579_a) {
                int rX;
                if (this.field_70146_Z.nextInt(20) == 0 && EntityEvolvedEnderman.getCarriable(block = this.field_70170_p.func_147439_a(rX = MathHelper.func_76128_c((double)(this.field_70165_t - 2.0 + this.field_70146_Z.nextDouble() * 4.0)), rY = MathHelper.func_76128_c((double)(this.field_70163_u + this.field_70146_Z.nextDouble() * 3.0)), rZ = MathHelper.func_76128_c((double)(this.field_70161_v - 2.0 + this.field_70146_Z.nextDouble() * 4.0))))) {
                    this.setCarried(block);
                    this.setCarryingData(this.field_70170_p.func_72805_g(rX, rY, rZ));
                    this.field_70170_p.func_147449_b(rX, rY, rZ, Blocks.field_150350_a);
                }
            } else if (this.field_70146_Z.nextInt(2000) == 0) {
                int rX = MathHelper.func_76128_c((double)(this.field_70165_t - 1.0 + this.field_70146_Z.nextDouble() * 2.0));
                rY = MathHelper.func_76128_c((double)(this.field_70163_u + this.field_70146_Z.nextDouble() * 2.0));
                rZ = MathHelper.func_76128_c((double)(this.field_70161_v - 1.0 + this.field_70146_Z.nextDouble() * 2.0));
                block = this.field_70170_p.func_147439_a(rX, rY, rZ);
                Block block2 = this.field_70170_p.func_147439_a(rX, rY - 1, rZ);
                if (block.func_149688_o() == Material.field_151579_a && block2.func_149688_o() != Material.field_151579_a && block2.func_149686_d()) {
                    this.field_70170_p.func_147465_d(rX, rY, rZ, this.getCarried(), this.getCarryingData(), 3);
                    this.setCarried(Blocks.field_150350_a);
                }
            }
        }
        for (int k = 0; k < 2; ++k) {
            GalaxySpace.proxy.spawnParticle("greenportal", new Vector3(this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N), new Vector3((this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0), new Object[0]);
        }
        if (this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K && (f = this.func_70013_c(1.0f)) > 0.5f && this.field_70170_p.func_72937_j(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v)) && this.field_70146_Z.nextFloat() * 30.0f < (f - 0.4f) * 2.0f) {
            this.field_70789_a = null;
            this.setScreaming(false);
            this.isAggressive = false;
            this.teleportRandomly();
        }
        if (this.func_70026_G() || this.func_70027_ad()) {
            this.field_70789_a = null;
            this.setScreaming(false);
            this.isAggressive = false;
            this.teleportRandomly();
        }
        if (this.isScreaming() && !this.isAggressive && this.field_70146_Z.nextInt(100) == 0) {
            this.setScreaming(false);
        }
        this.field_70703_bu = false;
        if (this.field_70789_a != null) {
            this.func_70625_a(this.field_70789_a, 100.0f, 100.0f);
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            if (this.field_70789_a != null) {
                if (this.field_70789_a instanceof EntityPlayer && this.shouldAttackPlayer((EntityPlayer)this.field_70789_a)) {
                    if (this.field_70789_a.func_70068_e((Entity)this) < 16.0) {
                        this.teleportRandomly();
                    }
                    this.teleportDelay = 0;
                } else if (this.field_70789_a.func_70068_e((Entity)this) > 256.0 && this.teleportDelay++ >= 30 && this.teleportToEntity(this.field_70789_a)) {
                    this.teleportDelay = 0;
                }
            } else {
                this.setScreaming(false);
                this.teleportDelay = 0;
            }
        }
        super.func_70636_d();
    }

    protected boolean teleportRandomly() {
        double rX = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        double rY = this.field_70163_u + (double)(this.field_70146_Z.nextInt(64) - 32);
        double rZ = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        return this.teleportTo(rX, rY, rZ);
    }

    protected boolean teleportToEntity(Entity entity) {
        Vec3 vec3 = Vec3.func_72443_a((double)(this.field_70165_t - entity.field_70165_t), (double)(this.field_70121_D.field_72338_b + (double)(this.field_70131_O / 2.0f) - entity.field_70163_u + (double)entity.func_70047_e()), (double)(this.field_70161_v - entity.field_70161_v));
        vec3 = vec3.func_72432_b();
        double rX = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3.field_72450_a * 16.0;
        double rY = this.field_70163_u + (double)(this.field_70146_Z.nextInt(16) - 8) - vec3.field_72448_b * 16.0;
        double rZ = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3.field_72449_c * 16.0;
        return this.teleportTo(rX, rY, rZ);
    }

    protected boolean teleportTo(double targetX, double targetY, double targetZ) {
        int zFloor;
        int yFloor;
        EnderTeleportEvent event = new EnderTeleportEvent((EntityLivingBase)this, targetX, targetY, targetZ, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        double xExact = this.field_70165_t;
        double yExact = this.field_70163_u;
        double zExact = this.field_70161_v;
        this.field_70165_t = event.targetX;
        this.field_70163_u = event.targetY;
        this.field_70161_v = event.targetZ;
        boolean flag = false;
        int xFloor = MathHelper.func_76128_c((double)this.field_70165_t);
        if (this.field_70170_p.func_72899_e(xFloor, yFloor = MathHelper.func_76128_c((double)this.field_70163_u), zFloor = MathHelper.func_76128_c((double)this.field_70161_v))) {
            boolean flag2 = false;
            while (!flag2 && yFloor > 0) {
                Block block = this.field_70170_p.func_147439_a(xFloor, yFloor - 1, zFloor);
                if (block.func_149688_o().func_76230_c()) {
                    flag2 = true;
                    continue;
                }
                this.field_70163_u -= 1.0;
                --yFloor;
            }
            if (flag2) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).isEmpty() && !this.field_70170_p.func_72953_d(this.field_70121_D)) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            this.func_70107_b(xExact, yExact, zExact);
            return false;
        }
        int short1 = 128;
        for (int l = 0; l < short1; ++l) {
            double d6 = (double)l / ((double)short1 - 1.0);
            float velX = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float velY = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float velZ = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            double posX_ = xExact + (this.field_70165_t - xExact) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            double posY_ = yExact + (this.field_70163_u - yExact) * d6 + this.field_70146_Z.nextDouble() * (double)this.field_70131_O;
            double posZ_ = zExact + (this.field_70161_v - zExact) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            GalaxySpace.proxy.spawnParticle("greenportal", new Vector3(posX_, posY_, posZ_), new Vector3((double)velX, (double)velY, (double)velZ), new Object[0]);
        }
        this.field_70170_p.func_72908_a(xExact, yExact, zExact, "mob.endermen.portal", 1.0f, 1.0f);
        this.func_85030_a("mob.endermen.portal", 1.0f, 1.0f);
        return true;
    }

    protected String func_70639_aQ() {
        return this.isScreaming() ? "mob.endermen.scream" : "mob.endermen.idle";
    }

    protected String func_70621_aR() {
        return "mob.endermen.hit";
    }

    protected String func_70673_aS() {
        return "mob.endermen.death";
    }

    protected Item func_146068_u() {
        return Items.field_151079_bi;
    }

    protected void func_70628_a(boolean recentlyHit_, int looting) {
        Item item = this.func_146068_u();
        if (item != null) {
            int amount = this.field_70146_Z.nextInt(2 + looting);
            for (int k = 0; k < amount; ++k) {
                this.func_145779_a(item, 1);
            }
        }
    }

    public void setCarried(Block block) {
        this.field_70180_af.func_75692_b(16, (Object)((byte)(Block.func_149682_b((Block)block) & 0xFF)));
    }

    public Block getCarried() {
        return Block.func_149729_e((int)((Byte)this.field_70180_af.func_75691_i(16).func_75669_b()).byteValue());
    }

    public void setCarryingData(int meta) {
        this.field_70180_af.func_75692_b(17, (Object)((byte)(meta & 0xFF)));
    }

    public int getCarryingData() {
        return ((Byte)this.field_70180_af.func_75691_i(17).func_75669_b()).byteValue();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_85032_ar()) {
            return false;
        }
        this.setScreaming(true);
        if (source instanceof EntityDamageSource && source.func_76346_g() instanceof EntityPlayer) {
            this.isAggressive = true;
        }
        if (source instanceof EntityDamageSourceIndirect) {
            this.isAggressive = false;
            for (int i = 0; i < 64; ++i) {
                if (!this.teleportRandomly()) continue;
                return true;
            }
        }
        return super.func_70097_a(source, amount);
    }

    public boolean isScreaming() {
        return (Byte)this.field_70180_af.func_75691_i(18).func_75669_b() > 0;
    }

    public void setScreaming(boolean bool) {
        this.field_70180_af.func_75692_b(18, (Object)((byte)(bool ? 1 : 0)));
    }

    public static void setCarriable(Block block, boolean canCarry) {
        if (canCarry) {
            CARRIABLE.add(block);
        } else {
            CARRIABLE.remove(block);
        }
    }

    public static boolean getCarriable(Block block) {
        return CARRIABLE.contains(block);
    }

    public boolean canBreath() {
        return true;
    }

    protected void func_70600_l(int p_70600_1_) {
        switch (this.field_70146_Z.nextInt(10)) {
            case 6: {
                this.func_70099_a(new ItemStack(GCItems.oxTankMedium, 1, 901 + this.field_70146_Z.nextInt(900)), 0.0f);
                break;
            }
            case 7: 
            case 8: {
                this.func_145779_a(Items.field_151061_bv, 1);
                break;
            }
            case 9: {
                this.func_145779_a(GCItems.oxygenConcentrator, 1);
                break;
            }
            case 10: {
                this.func_145779_a(GCItems.oxMask, 1);
            }
        }
    }

    static {
        CARRIABLE.add((Block)Blocks.field_150349_c);
        CARRIABLE.add(Blocks.field_150346_d);
        CARRIABLE.add((Block)Blocks.field_150354_m);
        CARRIABLE.add(Blocks.field_150351_n);
        CARRIABLE.add((Block)Blocks.field_150327_N);
        CARRIABLE.add((Block)Blocks.field_150328_O);
        CARRIABLE.add((Block)Blocks.field_150338_P);
        CARRIABLE.add((Block)Blocks.field_150337_Q);
        CARRIABLE.add(Blocks.field_150335_W);
        CARRIABLE.add(Blocks.field_150434_aF);
        CARRIABLE.add(Blocks.field_150435_aG);
        CARRIABLE.add(Blocks.field_150423_aK);
        CARRIABLE.add(Blocks.field_150440_ba);
        CARRIABLE.add((Block)Blocks.field_150391_bh);
    }
}

