/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.bytebuf;

import com.gtnewhorizon.gtnhlib.bytebuf.MemoryUtilities;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class CheckIntrinsics {
    private CheckIntrinsics() {
    }

    public static int classVersion() {
        return 8;
    }

    public static int checkIndex(int index, int length) {
        if (index < 0 || length <= index) {
            throw new IndexOutOfBoundsException();
        }
        return index;
    }

    public static int checkFromToIndex(int fromIndex, int toIndex, int length) {
        if (fromIndex < 0 || toIndex < fromIndex || length < toIndex) {
            throw new IndexOutOfBoundsException();
        }
        return fromIndex;
    }

    public static int checkFromIndexSize(int fromIndex, int size, int length) {
        if ((length | fromIndex | size) < 0 || length - fromIndex < size) {
            throw new IndexOutOfBoundsException();
        }
        return fromIndex;
    }

    public static ByteBuffer NewDirectByteBuffer(long address, int capacity) {
        try {
            Class<?> dbb = Class.forName("java.nio.DirectByteBuffer");
            Constructor<?> newDbb = dbb.getDeclaredConstructor(Long.TYPE, Integer.TYPE);
            newDbb.setAccessible(true);
            return (ByteBuffer)newDbb.newInstance(address, capacity);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static MemoryUtilities.MemoryAllocator getLwjgl3ifyAllocator() {
        return null;
    }
}

