/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import logisticspipes.interfaces.ISpecialTankAccessHandler;
import logisticspipes.interfaces.ISpecialTankHandler;
import logisticspipes.interfaces.routing.IAdditionalTargetInformation;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.interfaces.routing.IProvideFluids;
import logisticspipes.interfaces.routing.IRequestFluid;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.pipes.basic.fluid.FluidRoutedPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.request.RequestTree;
import logisticspipes.request.RequestTreeNode;
import logisticspipes.request.resources.FluidResource;
import logisticspipes.routing.FluidLogisticsPromise;
import logisticspipes.routing.order.IOrderInfoProvider;
import logisticspipes.routing.order.LogisticsFluidOrder;
import logisticspipes.textures.Textures;
import logisticspipes.transport.LPTravelingItem;
import logisticspipes.utils.FluidIdentifier;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class PipeFluidProvider
extends FluidRoutedPipe
implements IProvideFluids {
    public PipeFluidProvider(Item item) {
        super(item);
    }

    @Override
    public void enabledUpdateEntity() {
        int attemptedAmount;
        super.enabledUpdateEntity();
        if (!this.getFluidOrderManager().hasOrders(IOrderInfoProvider.ResourceType.PROVIDER) || !this.isNthTick(6)) {
            return;
        }
        LogisticsFluidOrder order = (LogisticsFluidOrder)this.getFluidOrderManager().peekAtTopRequest(IOrderInfoProvider.ResourceType.PROVIDER);
        int amountToSend = attemptedAmount = Math.min(order.getAmount(), 5000);
        block0: for (Pair<TileEntity, ForgeDirection> pair : this.getAdjacentTanks(false)) {
            FluidTankInfo[] tanks;
            ISpecialTankHandler handler;
            if (amountToSend <= 0) break;
            boolean fallback = true;
            if (SimpleServiceLocator.specialTankHandler.hasHandlerFor(pair.getValue1()) && (handler = SimpleServiceLocator.specialTankHandler.getTankHandlerFor(pair.getValue1())) instanceof ISpecialTankAccessHandler) {
                fallback = false;
                FluidStack drained = ((ISpecialTankAccessHandler)handler).drainFrom(pair.getValue1(), order.getFluid(), amountToSend, false);
                if (drained != null && drained.amount > 0 && order.getFluid().equals(FluidIdentifier.get(drained))) {
                    drained = ((ISpecialTankAccessHandler)handler).drainFrom(pair.getValue1(), order.getFluid(), amountToSend, true);
                    int amount = drained.amount;
                    amountToSend -= amount;
                    ItemIdentifierStack stack = SimpleServiceLocator.logisticsFluidManager.getFluidContainer(drained);
                    LPTravelingItem.LPTravelingItemServer item = SimpleServiceLocator.routedItemHelper.createNewTravelItem(stack);
                    item.setDestination(order.getRouter().getSimpleID());
                    item.setTransportMode(IRoutedItem.TransportMode.Active);
                    this.queueRoutedItem(item, pair.getValue2());
                    this.getFluidOrderManager().sendSuccessfull(amount, false, item);
                    if (amountToSend <= 0) break;
                }
            }
            if (!fallback || (tanks = ((IFluidHandler)pair.getValue1()).getTankInfo(pair.getValue2().getOpposite())) == null) continue;
            for (FluidTankInfo tank : tanks) {
                FluidStack addition;
                FluidStack liquid;
                if (tank == null || (liquid = tank.fluid) == null || liquid.getFluidID() == 0 || !order.getFluid().equals(FluidIdentifier.get(liquid))) continue;
                int amount = Math.min(liquid.amount, amountToSend);
                FluidStack drained = ((IFluidHandler)pair.getValue1()).drain(pair.getValue2().getOpposite(), amount, false);
                if (drained == null || drained.amount <= 0 || !order.getFluid().equals(FluidIdentifier.get(drained))) continue;
                drained = ((IFluidHandler)pair.getValue1()).drain(pair.getValue2().getOpposite(), amount, true);
                while (drained.amount < amountToSend && (addition = ((IFluidHandler)pair.getValue1()).drain(pair.getValue2().getOpposite(), amountToSend - drained.amount, false)) != null && addition.amount > 0 && order.getFluid().equals(FluidIdentifier.get(addition))) {
                    addition = ((IFluidHandler)pair.getValue1()).drain(pair.getValue2().getOpposite(), amountToSend - drained.amount, true);
                    drained.amount += addition.amount;
                }
                amount = drained.amount;
                amountToSend -= amount;
                ItemIdentifierStack stack = SimpleServiceLocator.logisticsFluidManager.getFluidContainer(drained);
                LPTravelingItem.LPTravelingItemServer item = SimpleServiceLocator.routedItemHelper.createNewTravelItem(stack);
                item.setDestination(order.getRouter().getSimpleID());
                item.setTransportMode(IRoutedItem.TransportMode.Active);
                this.queueRoutedItem(item, pair.getValue2());
                this.getFluidOrderManager().sendSuccessfull(amount, false, item);
                if (amountToSend <= 0) continue block0;
            }
        }
        if (amountToSend >= attemptedAmount) {
            this.getFluidOrderManager().sendFailed();
        }
    }

    @Override
    public Map<FluidIdentifier, Integer> getAvailableFluids() {
        HashMap<FluidIdentifier, Integer> map = new HashMap<FluidIdentifier, Integer>();
        for (Pair<TileEntity, ForgeDirection> pair : this.getAdjacentTanks(false)) {
            FluidTankInfo[] tanks;
            ISpecialTankHandler handler;
            boolean fallback = true;
            if (SimpleServiceLocator.specialTankHandler.hasHandlerFor(pair.getValue1()) && (handler = SimpleServiceLocator.specialTankHandler.getTankHandlerFor(pair.getValue1())) instanceof ISpecialTankAccessHandler) {
                fallback = false;
                Map<FluidIdentifier, Long> tmp = ((ISpecialTankAccessHandler)handler).getAvailableLiquid(pair.getValue1());
                for (Map.Entry<FluidIdentifier, Long> entry : tmp.entrySet()) {
                    if (map.containsKey(entry.getKey())) {
                        long addition;
                        map.put(entry.getKey(), (addition = (long)((Integer)map.get(entry.getKey())).intValue() + entry.getValue()) > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)addition);
                        continue;
                    }
                    map.put(entry.getKey(), entry.getValue() > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)entry.getValue().longValue());
                }
            }
            if (!fallback || (tanks = ((IFluidHandler)pair.getValue1()).getTankInfo(pair.getValue2().getOpposite())) == null) continue;
            for (FluidTankInfo tank : tanks) {
                FluidStack liquid;
                if (tank == null || (liquid = tank.fluid) == null || liquid.getFluidID() == 0) continue;
                FluidIdentifier ident = FluidIdentifier.get(liquid);
                if (!((IFluidHandler)pair.getValue1()).canDrain(pair.getValue2().getOpposite(), liquid.getFluid()) || ((IFluidHandler)pair.getValue1()).drain(pair.getValue2().getOpposite(), 1, false) == null) continue;
                if (map.containsKey(ident)) {
                    long addition = (long)((Integer)map.get(ident)).intValue() + (long)tank.fluid.amount;
                    map.put(ident, addition > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)addition);
                    continue;
                }
                map.put(ident, tank.fluid.amount);
            }
        }
        HashMap<FluidIdentifier, Integer> result = new HashMap<FluidIdentifier, Integer>();
        for (Map.Entry fluid : map.entrySet()) {
            int remaining = (Integer)fluid.getValue() - this.getFluidOrderManager().totalFluidsCountInOrders((FluidIdentifier)fluid.getKey());
            if (remaining < 1) continue;
            result.put((FluidIdentifier)fluid.getKey(), remaining);
        }
        return result;
    }

    @Override
    public boolean disconnectPipe(TileEntity tile, ForgeDirection dir) {
        return SimpleServiceLocator.pipeInformationManager.isFluidPipe(tile);
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.LOGISTICSPIPE_LIQUID_PROVIDER;
    }

    @Override
    public void canProvide(RequestTreeNode tree, RequestTree root, List<IFilter> filter) {
        if (tree.isDone()) {
            return;
        }
        if (!(tree.getRequestType() instanceof FluidResource)) {
            return;
        }
        FluidIdentifier fluid = ((FluidResource)tree.getRequestType()).getFluid();
        int containedAmount = 0;
        for (Pair<TileEntity, ForgeDirection> pair : this.getAdjacentTanks(false)) {
            FluidTankInfo[] tanks;
            ISpecialTankHandler handler;
            boolean fallback = true;
            if (SimpleServiceLocator.specialTankHandler.hasHandlerFor(pair.getValue1()) && (handler = SimpleServiceLocator.specialTankHandler.getTankHandlerFor(pair.getValue1())) instanceof ISpecialTankAccessHandler) {
                fallback = false;
                Map<FluidIdentifier, Long> map = ((ISpecialTankAccessHandler)handler).getAvailableLiquid(pair.getValue1());
                if (map.containsKey(fluid)) {
                    long addition = (long)containedAmount + map.get(fluid);
                    int n = containedAmount = addition > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)addition;
                }
            }
            if (!fallback || (tanks = ((IFluidHandler)pair.getValue1()).getTankInfo(pair.getValue2().getOpposite())) == null) continue;
            for (FluidTankInfo tank : tanks) {
                FluidStack liquid;
                if (tank == null || (liquid = tank.fluid) == null || liquid.getFluidID() == 0 || !fluid.equals(FluidIdentifier.get(liquid)) || !((IFluidHandler)pair.getValue1()).canDrain(pair.getValue2().getOpposite(), liquid.getFluid()) || ((IFluidHandler)pair.getValue1()).drain(pair.getValue2().getOpposite(), 1, false) == null) continue;
                long addition = (long)containedAmount + (long)liquid.amount;
                containedAmount = addition > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)addition;
            }
        }
        int promiseAmount = Math.min(tree.getMissingAmount(), containedAmount - root.getAllPromissesFor(this, fluid.getItemIdentifier()));
        FluidLogisticsPromise promise = new FluidLogisticsPromise(fluid, promiseAmount, this, IOrderInfoProvider.ResourceType.PROVIDER);
        if (promise.getAmount() > 0) {
            tree.addPromise(promise);
        }
    }

    @Override
    public IOrderInfoProvider fullFill(FluidLogisticsPromise promise, IRequestFluid destination, IOrderInfoProvider.ResourceType type, IAdditionalTargetInformation info) {
        return this.getFluidOrderManager().addOrder(promise, destination, type, info);
    }

    @Override
    public boolean canInsertToTanks() {
        return true;
    }

    @Override
    public boolean canInsertFromSideToTanks() {
        return true;
    }

    @Override
    public Set<ItemIdentifier> getSpecificInterests() {
        TreeSet<ItemIdentifier> l1 = new TreeSet<ItemIdentifier>();
        for (Pair<TileEntity, ForgeDirection> pair : this.getAdjacentTanks(false)) {
            FluidTankInfo[] tanks;
            ISpecialTankHandler handler;
            boolean fallback = true;
            if (SimpleServiceLocator.specialTankHandler.hasHandlerFor(pair.getValue1()) && (handler = SimpleServiceLocator.specialTankHandler.getTankHandlerFor(pair.getValue1())) instanceof ISpecialTankAccessHandler) {
                fallback = false;
                Map<FluidIdentifier, Long> map = ((ISpecialTankAccessHandler)handler).getAvailableLiquid(pair.getValue1());
                for (FluidIdentifier ident : map.keySet()) {
                    l1.add(ident.getItemIdentifier());
                }
            }
            if (!fallback || (tanks = ((IFluidHandler)pair.getValue1()).getTankInfo(pair.getValue2().getOpposite())) == null) continue;
            for (FluidTankInfo tank : tanks) {
                FluidStack liquid;
                if (tank == null || (liquid = tank.fluid) == null || liquid.getFluidID() == 0 || !((IFluidHandler)pair.getValue1()).canDrain(pair.getValue2().getOpposite(), liquid.getFluid()) || ((IFluidHandler)pair.getValue1()).drain(pair.getValue2().getOpposite(), 1, false) == null) continue;
                FluidIdentifier ident = FluidIdentifier.get(liquid);
                l1.add(ident.getItemIdentifier());
            }
        }
        return l1;
    }

    @Override
    public boolean canReceiveFluid() {
        return false;
    }
}

