/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.request;

import java.util.ArrayList;
import java.util.List;
import logisticspipes.interfaces.routing.ICraftItems;
import logisticspipes.interfaces.routing.IProvideItems;
import logisticspipes.request.BaseCraftingTemplate;
import logisticspipes.request.IExtraPromise;
import logisticspipes.request.resources.DictResource;
import logisticspipes.request.resources.IResource;
import logisticspipes.routing.LogisticsDictPromise;
import logisticspipes.routing.LogisticsExtraPromise;
import logisticspipes.routing.LogisticsPromise;
import logisticspipes.routing.order.IOrderInfoProvider;
import logisticspipes.utils.item.ItemIdentifierStack;

public class DictCraftingTemplate
extends BaseCraftingTemplate {
    protected DictResource _result;
    protected ICraftItems _crafter;
    protected ArrayList<ItemIdentifierStack> _byproduct = new ArrayList(9);

    public DictCraftingTemplate(DictResource result, ICraftItems crafter, int priority) {
        super(9, priority);
        this._result = result;
        this._crafter = crafter;
    }

    @Override
    public void addByproduct(ItemIdentifierStack stack) {
        for (ItemIdentifierStack i : this._byproduct) {
            if (!i.getItem().equals(stack.getItem())) continue;
            i.setStackSize(i.getStackSize() + stack.getStackSize());
            return;
        }
        this._byproduct.add(stack);
    }

    @Override
    public LogisticsPromise generatePromise(int nResultSets) {
        return new LogisticsDictPromise(this._result, this._result.stack.getStackSize() * nResultSets, (IProvideItems)this._crafter, IOrderInfoProvider.ResourceType.CRAFTING);
    }

    @Override
    public ICraftItems getCrafter() {
        return this._crafter;
    }

    @Override
    public boolean canCraft(IResource type) {
        if (type instanceof DictResource) {
            return type.matches(this._result.getItem(), IResource.MatchSettings.NORMAL) && this._result.matches(((DictResource)type).getItem(), IResource.MatchSettings.NORMAL) && this._result.getBitSet().equals(((DictResource)type).getBitSet());
        }
        return false;
    }

    @Override
    public IResource getResultResource() {
        return this._result;
    }

    @Override
    public ItemIdentifierStack getResultStack() {
        return this._result.stack;
    }

    @Override
    public List<IExtraPromise> getByproducts(int workSets) {
        ArrayList<IExtraPromise> list = new ArrayList<IExtraPromise>();
        for (ItemIdentifierStack stack : this._byproduct) {
            list.add(new LogisticsExtraPromise(stack.getItem(), stack.getStackSize() * workSets, (IProvideItems)this.getCrafter(), false));
        }
        return list;
    }
}

