/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.containers;

import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import shedar.mods.ic2.nuclearcontrol.IC2NuclearControl;
import shedar.mods.ic2.nuclearcontrol.InventoryItem;
import shedar.mods.ic2.nuclearcontrol.SlotFilter;
import shedar.mods.ic2.nuclearcontrol.api.IPanelDataSource;
import shedar.mods.ic2.nuclearcontrol.items.ItemRemoteMonitor;

public class ContainerRemoteMonitor
extends Container {
    protected ItemStack is;
    public InventoryItem item;
    private static final String NBT_KEY_UID = "UID";
    private final ItemStack itemStack;
    private final int itemSlot;

    private static boolean isSameItemInventory(ItemStack base, ItemStack comparison) {
        if (base == null || comparison == null) {
            return false;
        }
        if (base.func_77973_b() != comparison.func_77973_b()) {
            return false;
        }
        if (!base.func_77942_o() || !comparison.func_77942_o()) {
            return false;
        }
        String baseUID = base.func_77978_p().func_74779_i(NBT_KEY_UID);
        String comparisonUID = comparison.func_77978_p().func_74779_i(NBT_KEY_UID);
        return baseUID != null && comparisonUID != null && baseUID.equals(comparisonUID);
    }

    public ContainerRemoteMonitor(InventoryPlayer inv, ItemStack stack, InventoryItem iItem) {
        this.is = stack;
        this.item = iItem;
        Slot slot = this.func_75146_a(new SlotFilter(this.item, 0, 177, 21));
        this.itemStack = stack;
        this.itemSlot = slot.field_75222_d;
        if (stack != null && stack.func_77973_b() instanceof ItemRemoteMonitor) {
            NBTTagCompound nbt;
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            if (!(nbt = stack.func_77978_p()).func_74764_b(NBT_KEY_UID)) {
                nbt.func_74778_a(NBT_KEY_UID, UUID.randomUUID().toString());
            }
        }
        this.bindPlayerInventory(inv);
    }

    protected void bindPlayerInventory(InventoryPlayer inventoryPlayer) {
        for (int i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, i, 8 + i * 18, 142));
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return ContainerRemoteMonitor.isSameItemInventory(player.func_70694_bm(), this.itemStack);
    }

    public ItemStack func_82846_b(EntityPlayer player, int slot) {
        if (slot == this.itemSlot) {
            return null;
        }
        if (!ContainerRemoteMonitor.isSameItemInventory(player.func_70694_bm(), this.itemStack)) {
            return null;
        }
        ItemStack stack = null;
        Slot slots = (Slot)this.field_75151_b.get(slot);
        if (slots.func_75211_c() != null && slots.func_75211_c().func_77973_b() == IC2NuclearControl.itemRemoteMonitor) {
            return null;
        }
        if (slots != null && slots.func_75216_d()) {
            ItemStack itemstackR = slots.func_75211_c();
            stack = itemstackR.func_77946_l();
            if (slot == 0) {
                boolean fixed = false;
                for (int h = 1; h < 10; ++h) {
                    Slot know = (Slot)this.field_75151_b.get(h);
                    if (know.func_75216_d()) continue;
                    know.func_75215_d(slots.func_75211_c());
                    slots.func_75209_a(1);
                    fixed = true;
                }
                if (!fixed) {
                    return null;
                }
                slots.func_75220_a(itemstackR, stack);
            } else if (slots.func_75211_c().func_77973_b() instanceof IPanelDataSource && !((Slot)this.field_75151_b.get(0)).func_75216_d()) {
                ((Slot)this.field_75151_b.get(0)).func_75215_d(itemstackR);
                slots.func_75209_a(1);
                slots.func_75220_a(itemstackR, stack);
                ((Slot)this.field_75151_b.get(0)).func_75218_e();
            } else {
                return null;
            }
        }
        return stack;
    }

    public ItemStack func_75144_a(int slot, int button, int flag, EntityPlayer player) {
        if (slot == this.itemSlot) {
            return null;
        }
        if (flag == 2 && button == this.itemSlot) {
            return null;
        }
        if (!ContainerRemoteMonitor.isSameItemInventory(player.func_70694_bm(), this.itemStack)) {
            return null;
        }
        if (slot >= 0 && this.func_75139_a(slot) != null && this.func_75139_a(slot).func_75211_c() == player.func_70694_bm()) {
            return null;
        }
        return super.func_75144_a(slot, button, flag, player);
    }
}

