/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.block;

import binnie.core.block.BlockMetadata;
import binnie.core.block.IBlockMetadata;
import binnie.core.block.TileEntityMetadata;
import binnie.core.util.I18N;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.block.DoorType;
import binnie.extratrees.block.IPlankType;
import binnie.extratrees.block.PlankType;
import binnie.extratrees.block.WoodManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.Tabs;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.IconFlipped;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockETDoor
extends BlockDoor
implements IBlockMetadata {
    protected BlockETDoor() {
        super(Material.field_151575_d);
        this.func_149711_c(3.0f);
        this.func_149672_a(Block.field_149766_f);
        this.func_149647_a(Tabs.tabArboriculture);
        this.func_149663_c("door");
    }

    public static DoorType getDoorType(int tileMeta) {
        int type = (tileMeta & 0xF00) >> 8;
        if (type < DoorType.values().length) {
            return DoorType.values()[type];
        }
        return DoorType.STANDARD;
    }

    private IIcon getFlippedIcon(boolean upper, boolean flip, int tileMeta) {
        DoorType type = BlockETDoor.getDoorType(tileMeta);
        if (upper) {
            return flip ? type.iconDoorUpperFlip : type.iconDoorUpper;
        }
        return flip ? type.iconDoorLowerFlip : type.iconDoorLower;
    }

    public IIcon func_149691_a(int side, int meta) {
        return DoorType.STANDARD.iconDoorLower;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess blockAccess, int x, int y, int z, int meta) {
        if (meta != 1 && meta != 0) {
            boolean flag2;
            boolean flag3;
            int i1 = this.getFullMetadata(blockAccess, x, y, z);
            int j1 = i1 & 3;
            boolean flag = (i1 & 4) != 0;
            boolean bl = flag3 = (i1 & 8) != 0;
            if (flag) {
                flag2 = j1 == 0 && meta == 2 || j1 == 1 && meta == 5 || j1 == 2 && meta == 3 || j1 == 3 && meta == 4;
            } else {
                boolean bl2 = flag2 = j1 == 0 && meta == 5 || j1 == 1 && meta == 3 || j1 == 2 && meta == 4 || j1 == 3 && meta == 2;
                if ((i1 & 0x10) != 0) {
                    flag2 = !flag2;
                }
            }
            int tileMeta = flag3 ? TileEntityMetadata.getTileMetadata(blockAccess, x, y - 1, z) : TileEntityMetadata.getTileMetadata(blockAccess, x, y, z);
            return this.getFlippedIcon(flag3, flag2, tileMeta);
        }
        return DoorType.STANDARD.iconDoorLower;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        for (DoorType type : DoorType.values()) {
            type.iconDoorLower = ExtraTrees.proxy.getIcon(register, "door." + type.id + ".lower");
            type.iconDoorUpper = ExtraTrees.proxy.getIcon(register, "door." + type.id + ".upper");
            type.iconDoorLowerFlip = new IconFlipped(type.iconDoorLower, true, false);
            type.iconDoorUpperFlip = new IconFlipped(type.iconDoorUpper, true, false);
        }
    }

    public int func_149645_b() {
        return ExtraTrees.doorRenderId;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess blockAccess, int x, int y, int z) {
        int i1 = this.getFullMetadata(blockAccess, x, y, z);
        if ((i1 & 8) != 0) {
            int meta = TileEntityMetadata.getTileMetadata(blockAccess, x, y - 1, z);
            return WoodManager.getPlankType(meta & 0xFF).getColor();
        }
        int meta = TileEntityMetadata.getTileMetadata(blockAccess, x, y, z);
        return WoodManager.getPlankType(meta & 0xFF).getColor();
    }

    public int getFullMetadata(IBlockAccess blockAccess, int x, int y, int z) {
        int j1;
        int i1;
        boolean flag;
        int l = blockAccess.func_72805_g(x, y, z);
        boolean bl = flag = (l & 8) != 0;
        if (flag) {
            i1 = blockAccess.func_72805_g(x, y - 1, z);
            j1 = l;
        } else {
            i1 = l;
            j1 = blockAccess.func_72805_g(x, y + 1, z);
        }
        boolean flag2 = (j1 & 1) != 0;
        return i1 & 7 | (flag ? 8 : 0) | (flag2 ? 16 : 0);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        int meta = world.func_72805_g(x, y, z);
        if ((meta & 8) == 0) {
            boolean flag = false;
            if (world.func_147439_a(x, y + 1, z) != this) {
                world.func_147468_f(x, y, z);
                flag = true;
            }
            if (!World.func_147466_a((IBlockAccess)world, (int)x, (int)(y - 1), (int)z)) {
                flag = true;
            }
            if (flag) {
                if (!world.field_72995_K) {
                    this.func_149697_b(world, x, y, z, meta, 0);
                }
            } else {
                boolean flag1;
                boolean bl = flag1 = world.func_72864_z(x, y, z) || world.func_72864_z(x, y + 1, z);
                if ((flag1 || block.func_149744_f()) && block != this) {
                    this.func_150014_a(world, x, y, z, flag1);
                }
            }
            if (!World.func_147466_a((IBlockAccess)world, (int)x, (int)(y - 1), (int)z)) {
                world.func_147468_f(x, y, z);
                if (world.func_147439_a(x, y + 1, z) == this) {
                    world.func_147468_f(x, y + 1, z);
                }
            }
        } else {
            if (world.func_147439_a(x, y - 1, z) != this) {
                world.func_147468_f(x, y, z);
            }
            if (block != this) {
                this.func_149695_a(world, x, y - 1, z, block);
            }
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int meta, int fortune) {
        if ((meta & 8) != 0) {
            --y;
        }
        return BlockMetadata.getBlockDropped(this, world, x, y, z, meta);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        return BlockMetadata.breakBlock(this, player, world, x, y, z);
    }

    public TileEntity func_149915_a(World world, int k) {
        return new TileEntityMetadata();
    }

    public boolean hasTileEntity(int meta) {
        return true;
    }

    @Override
    public int getPlacedMeta(ItemStack stack, World world, int x, int y, int z, ForgeDirection direction) {
        return TileEntityMetadata.getItemDamage(stack);
    }

    @Override
    public int getDroppedMeta(int blockMeta, int tileMeta) {
        return tileMeta;
    }

    @Override
    public String getBlockName(ItemStack stack) {
        int meta = TileEntityMetadata.getItemDamage(stack);
        String typeName = BlockETDoor.getDoorType(meta).getName();
        String woodName = WoodManager.getPlankType(meta & 0xFF).getName();
        if (typeName.isEmpty()) {
            return I18N.localise("extratrees.block.door.name", woodName);
        }
        return I18N.localise("extratrees.block.door.name.adv", woodName, typeName);
    }

    @Override
    public void addBlockTooltip(ItemStack stack, List<String> tooltip) {
    }

    @Override
    public void dropAsStack(World world, int x, int y, int z, ItemStack stack) {
        this.func_149642_a(world, x, y, z, stack);
    }

    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> itemList) {
        for (PlankType.ExtraTreePlanks extraTreePlanks : PlankType.ExtraTreePlanks.values()) {
            itemList.add(WoodManager.getDoor(extraTreePlanks, DoorType.STANDARD));
        }
        for (Enum enum_ : PlankType.ForestryPlanks.values()) {
            itemList.add(WoodManager.getDoor((IPlankType)((Object)enum_), DoorType.STANDARD));
        }
        for (Enum enum_ : PlankType.ExtraBiomesPlank.values()) {
            if (enum_.getStack() == null) continue;
            itemList.add(WoodManager.getDoor((IPlankType)((Object)enum_), DoorType.STANDARD));
        }
        for (Enum enum_ : PlankType.VanillaPlanks.values()) {
            itemList.add(WoodManager.getDoor((IPlankType)((Object)enum_), DoorType.STANDARD));
        }
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return 20;
    }

    public boolean isFlammable(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return true;
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return 5;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        return BlockMetadata.getPickBlock(world, x, y, z);
    }
}

