/*
 * Decompiled with CFR 0.152.
 */
package com.arc.bloodarsenal.common.items.bauble;

import WayofTime.alchemicalWizardry.api.items.IAltarManipulator;
import WayofTime.alchemicalWizardry.common.tileEntity.TEAltar;
import baubles.api.BaubleType;
import baubles.api.IBauble;
import baubles.common.container.InventoryBaubles;
import baubles.common.lib.PlayerHandler;
import com.arc.bloodarsenal.common.BloodArsenalConfig;
import com.arc.bloodarsenal.common.items.ModItems;
import com.arc.bloodarsenal.common.items.bauble.ItemBauble;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class SacrificeAmulet
extends ItemBauble
implements IAltarManipulator,
IBauble {
    public SacrificeAmulet() {
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
    }

    public void sacrificeHandler(LivingDeathEvent event) {
        Entity killer = event.source.func_76346_g();
        if (killer != null && killer instanceof EntityPlayerMP && !(killer instanceof FakePlayer) && BloodArsenalConfig.baublesIntegration) {
            EntityLivingBase victim = event.entityLiving;
            EntityPlayer player = (EntityPlayer)killer;
            InventoryBaubles inv = PlayerHandler.getPlayerBaubles((EntityPlayer)player);
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                boolean shouldExecute;
                ItemStack stack = inv.func_70301_a(i);
                if (stack == null || stack.func_77973_b() != ModItems.sacrifice_amulet) continue;
                SacrificeAmulet sacrificeAmulet = (SacrificeAmulet)ModItems.sacrifice_amulet;
                float victimHealth = victim.func_110138_aP();
                boolean healthGood = victimHealth > 4.0f;
                int lpReceived = healthGood ? 200 : 50;
                boolean bl = shouldExecute = sacrificeAmulet.getStoredLP(stack) < 10000;
                if (!shouldExecute) continue;
                sacrificeAmulet.setStoredLP(stack, Math.min(sacrificeAmulet.getStoredLP(stack) + lpReceived * 2, 10000));
            }
        }
    }

    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        par3List.add(StatCollector.func_74838_a((String)"tooltip.bauble.sacrifice"));
        if (par1ItemStack.field_77990_d != null) {
            par3List.add("Stored LP: " + EnumChatFormatting.RED + this.getStoredLP(par1ItemStack));
        }
    }

    @Override
    public void onWornTick(ItemStack par1ItemStack, EntityLivingBase player) {
        super.onWornTick(par1ItemStack, player);
    }

    public BaubleType getBaubleType(ItemStack par1ItemStack) {
        return BaubleType.AMULET;
    }

    @Override
    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        if (world.field_72995_K) {
            return itemStack;
        }
        MovingObjectPosition movingobjectposition = this.func_77621_a(world, player, false);
        if (movingobjectposition == null) {
            return super.func_77659_a(itemStack, world, player);
        }
        if (movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            int amount;
            int x = movingobjectposition.field_72311_b;
            int y = movingobjectposition.field_72312_c;
            int z = movingobjectposition.field_72309_d;
            TileEntity tile = world.func_147438_o(x, y, z);
            if (!(tile instanceof TEAltar)) {
                return super.func_77659_a(itemStack, world, player);
            }
            TEAltar altar = (TEAltar)tile;
            if (!altar.isActive() && (amount = this.getStoredLP(itemStack)) > 0) {
                int filledAmount = altar.fillMainTank(amount);
                this.setStoredLP(itemStack, amount -= filledAmount);
                world.func_147471_g(x, y, z);
            }
        }
        return itemStack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("BloodArsenal:sacrifice_amulet");
    }

    public void setStoredLP(ItemStack itemStack, int lp) {
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tag = itemStack.func_77978_p();
        tag.func_74768_a("storedLP", lp);
    }

    public int getStoredLP(ItemStack itemStack) {
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tag = itemStack.func_77978_p();
        return tag.func_74762_e("storedLP");
    }

    public class EventHandler {
        @SubscribeEvent
        public void sacrificeHandlerWrapper(LivingDeathEvent event) {
            SacrificeAmulet.this.sacrificeHandler(event);
        }
    }
}

