/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.gui;

import binnie.botany.Botany;
import binnie.botany.api.EnumAcidity;
import binnie.botany.api.EnumMoisture;
import binnie.botany.api.IFlower;
import binnie.botany.gardening.BlockSoil;
import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.controls.ControlText;
import binnie.core.craftgui.controls.ControlTextCentered;
import binnie.core.craftgui.geometry.IArea;
import binnie.core.craftgui.geometry.TextJustification;
import binnie.core.craftgui.minecraft.control.ControlItemDisplay;
import binnie.core.genetics.Tolerance;
import binnie.core.util.I18N;
import binnie.genetics.genetics.AlleleHelper;
import binnie.genetics.gui.ControlAnalystPage;
import binnie.genetics.gui.ControlToleranceBar;
import forestry.api.genetics.EnumTolerance;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;

public class AnalystPageSoil
extends ControlAnalystPage {
    public AnalystPageSoil(IWidget parent, IArea area, IFlower flower) {
        super(parent, area);
        this.setColor(0x663300);
        EnumMoisture moisture = flower.getGenome().getPrimary().getMoisture();
        EnumTolerance moistureTol = flower.getGenome().getToleranceMoisture();
        EnumAcidity pH = flower.getGenome().getPrimary().getPH();
        EnumTolerance pHTol = flower.getGenome().getTolerancePH();
        int y = 4;
        new ControlTextCentered((IWidget)this, y, EnumChatFormatting.UNDERLINE + this.getTitle()).setColor(this.getColor());
        new ControlText(this, new IArea(4.0f, y += 16, this.w() - 8.0f, 14.0f), I18N.localise("genetics.gui.analyst.soil.moistureTolerance"), TextJustification.MIDDLE_CENTER).setColor(this.getColor());
        this.createMoisture(this, (this.w() - 100.0f) / 2.0f, y += 12, 100.0f, 10.0f, moisture, moistureTol);
        new ControlText(this, new IArea(4.0f, y += 16, this.w() - 8.0f, 14.0f), I18N.localise("genetics.gui.analyst.soil.pHTolerance"), TextJustification.MIDDLE_CENTER).setColor(this.getColor());
        this.createAcidity(this, (this.w() - 100.0f) / 2.0f, y += 12, 100.0f, 10.0f, pH, pHTol);
        new ControlText(this, new IArea(4.0f, y += 16, this.w() - 8.0f, 14.0f), I18N.localise("genetics.gui.analyst.soil.recommendedSoil"), TextJustification.MIDDLE_CENTER).setColor(this.getColor());
        y += 12;
        EnumMoisture recomMoisture = EnumMoisture.NORMAL;
        boolean canTolNormal = Tolerance.canTolerate(moisture, EnumMoisture.NORMAL, moistureTol);
        boolean canTolDamp = Tolerance.canTolerate(moisture, EnumMoisture.DAMP, moistureTol);
        boolean canTolDry = Tolerance.canTolerate(moisture, EnumMoisture.DRY, moistureTol);
        if (canTolNormal) {
            if (canTolDamp && !canTolDry) {
                recomMoisture = EnumMoisture.DAMP;
            } else if (canTolDry && !canTolDamp) {
                recomMoisture = EnumMoisture.DRY;
            }
        } else if (canTolDry) {
            recomMoisture = EnumMoisture.DRY;
        } else if (canTolDamp) {
            recomMoisture = EnumMoisture.DAMP;
        }
        EnumAcidity recomPH = EnumAcidity.NEUTRAL;
        boolean canTolNeutral = Tolerance.canTolerate(pH, EnumAcidity.NEUTRAL, pHTol);
        boolean canTolAcid = Tolerance.canTolerate(pH, EnumAcidity.ACID, pHTol);
        boolean canTolAlkaline = Tolerance.canTolerate(pH, EnumAcidity.ALKALINE, pHTol);
        if (canTolNeutral) {
            if (canTolAcid && !canTolAlkaline) {
                recomPH = EnumAcidity.ACID;
            } else if (canTolAlkaline && !canTolAcid) {
                recomPH = EnumAcidity.ALKALINE;
            }
        } else {
            if (canTolAcid) {
                recomPH = EnumAcidity.ACID;
            }
            if (canTolAlkaline) {
                recomPH = EnumAcidity.ALKALINE;
            }
        }
        ItemStack stack = new ItemStack((Block)Botany.soil, 1, BlockSoil.getMeta(recomPH, recomMoisture));
        ControlItemDisplay recomSoil = new ControlItemDisplay(this, (this.w() - 24.0f) / 2.0f, y, 24.0f);
        recomSoil.setItemStack(stack);
        recomSoil.setTooltip();
        new ControlText(this, new IArea(4.0f, y += 32, this.w() - 8.0f, 14.0f), I18N.localise("genetics.gui.analyst.soil.otherSoils"), TextJustification.MIDDLE_CENTER).setColor(this.getColor());
        y += 12;
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (EnumAcidity a : EnumSet.range(EnumAcidity.ACID, EnumAcidity.ALKALINE)) {
            for (EnumMoisture b : EnumSet.range(EnumMoisture.DRY, EnumMoisture.DAMP)) {
                if (!Tolerance.canTolerate(pH, a, pHTol) || !Tolerance.canTolerate(moisture, b, moistureTol) || a == recomPH && b == recomMoisture) continue;
                stacks.add(new ItemStack((Block)Botany.soil, 1, BlockSoil.getMeta(a, b)));
            }
        }
        float soilListWidth = 17 * stacks.size() - 1;
        float soilListX = (this.w() - soilListWidth) / 2.0f;
        int t = 0;
        for (ItemStack soilStack : stacks) {
            ControlItemDisplay display = new ControlItemDisplay(this, soilListX + (float)(17 * t++), y);
            display.setItemStack(soilStack);
            display.setTooltip();
        }
    }

    protected void createMoisture(IWidget parent, float x, float y, float w, float h, EnumMoisture value, EnumTolerance tol) {
        new ControlToleranceBar<EnumMoisture>(parent, x, y, w, h, EnumMoisture.class){

            @Override
            protected String getName(EnumMoisture value) {
                return AlleleHelper.toDisplay(value);
            }

            @Override
            protected int getColor(EnumMoisture value) {
                return (new int[]{0xCCFFCC, 0x66CCFF, 0x3366FF})[value.ordinal()];
            }
        }.setValues(value, tol);
    }

    protected void createAcidity(IWidget parent, float x, float y, float w, float h, EnumAcidity value, EnumTolerance tol) {
        new ControlToleranceBar<EnumAcidity>(parent, x, y, w, h, EnumAcidity.class){

            @Override
            protected String getName(EnumAcidity value) {
                return AlleleHelper.toDisplay(value);
            }

            @Override
            protected int getColor(EnumAcidity value) {
                return (new int[]{0xFF0066, 65280, 26367})[value.ordinal()];
            }
        }.setValues(value, tol);
    }

    @Override
    public String getTitle() {
        return I18N.localise("genetics.gui.analyst.soil");
    }
}

