/*
 * Decompiled with CFR 0.152.
 */
package gttweaker.mods.gregtech;

import gregtech.api.util.GT_Recipe;
import gttweaker.GTTweaker;
import gttweaker.mods.gregtech.GTRecipeMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IIngredient;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.RecipeRemover")
@ModOnly(value={"gregtech"})
public class RecipeRemover {
    @ZenMethod
    public static void remove(String map, IIngredient[] inputs, IIngredient[] fluidInputs) {
        GT_Recipe.GT_Recipe_Map recipeMap = GTRecipeMap.getRecipeMap(map);
        if (recipeMap == null) {
            MineTweakerAPI.logError((String)("Could not find recipe map named \"" + map + "\""));
            return;
        }
        GT_Recipe recipe = recipeMap.findRecipe(null, false, true, Long.MAX_VALUE, (FluidStack[])Arrays.stream(fluidInputs).map(GTTweaker::getFluidStackOrNull).filter(Objects::nonNull).toArray(FluidStack[]::new), (ItemStack[])Arrays.stream(inputs).map(GTTweaker::getItemStackOrNull).filter(Objects::nonNull).toArray(ItemStack[]::new));
        if (recipe == null) {
            MineTweakerAPI.logWarning((String)"Could not find recipe to remove!");
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new RecipeRemoveAction(recipe, recipeMap));
    }

    public static class RecipeRemoveAction
    implements IUndoableAction {
        GT_Recipe recipe;
        GT_Recipe.GT_Recipe_Map map;

        public RecipeRemoveAction(GT_Recipe recipe, GT_Recipe.GT_Recipe_Map map) {
            this.recipe = recipe;
            this.map = map;
        }

        public void apply() {
            this.map.mRecipeList.remove(this.recipe);
            this.map.mRecipeItemMap.entrySet().stream().filter(e -> ((Collection)e.getValue()).removeIf(r -> r == this.recipe) && ((Collection)e.getValue()).size() == 0).map(Map.Entry::getKey).collect(Collectors.toSet()).forEach(k -> {
                Collection cfr_ignored_0 = (Collection)this.map.mRecipeItemMap.remove(k);
            });
            this.map.mRecipeFluidMap.entrySet().stream().filter(e -> ((Collection)e.getValue()).removeIf(r -> r == this.recipe) && ((Collection)e.getValue()).size() == 0).map(Map.Entry::getKey).collect(Collectors.toSet()).forEach(k -> {
                Collection cfr_ignored_0 = (Collection)this.map.mRecipeFluidMap.remove(k);
            });
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            this.map.add(this.recipe);
        }

        public String describe() {
            return "Remove recipe from GT Machine";
        }

        public String describeUndo() {
            return "Re-add recipe to GT Machine";
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

