/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.power;

import gregtech.api.util.GT_Utility;
import gregtech.common.power.Power;

public class SteamPower
extends Power {
    private final double euPerTickOverride;
    private final double durationOverride;
    private final String[] STEAM_TIER_NAMES = new String[]{"Bronze", "Steel"};

    public SteamPower(byte tier, double euPerTickMultiplier, double durationMultiplier) {
        super(tier);
        this.euPerTickOverride = euPerTickMultiplier;
        this.durationOverride = durationMultiplier;
    }

    @Override
    public byte getTier() {
        return 1;
    }

    @Override
    public String getTierString() {
        return this.STEAM_TIER_NAMES[this.tier - 1];
    }

    @Override
    public void computePowerUsageAndDuration(int euPerTick, int duration) {
        this.recipeEuPerTick = (int)((double)euPerTick * this.euPerTickOverride);
        this.recipeDuration = (int)((double)duration * this.durationOverride);
    }

    @Override
    public String getTotalPowerString() {
        return GT_Utility.formatNumbers(2L * (long)this.recipeDuration * (long)this.recipeEuPerTick) + " Steam";
    }

    @Override
    public String getPowerUsageString() {
        return GT_Utility.formatNumbers(40L * (long)this.recipeEuPerTick) + " L/s Steam";
    }

    @Override
    public String getVoltageString() {
        return null;
    }

    @Override
    public String getAmperageString() {
        return null;
    }
}

