/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mc1710;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import minetweaker.MineTweakerAPI;
import minetweaker.MineTweakerImplementationAPI;
import minetweaker.api.logger.FileLogger;
import minetweaker.mc1710.FMLEventHandler;
import minetweaker.mc1710.ForgeEventHandler;
import minetweaker.mc1710.MCPlatformFunctions;
import minetweaker.mc1710.MineTweakerConfig;
import minetweaker.mc1710.MineTweakerRegistry;
import minetweaker.mc1710.brackets.ItemBracketHandler;
import minetweaker.mc1710.brackets.LiquidBracketHandler;
import minetweaker.mc1710.client.MCClient;
import minetweaker.mc1710.formatting.MCFormatter;
import minetweaker.mc1710.furnace.FuelTweaker;
import minetweaker.mc1710.furnace.MCFurnaceManager;
import minetweaker.mc1710.game.MCGame;
import minetweaker.mc1710.mods.MCLoadedMods;
import minetweaker.mc1710.network.MineTweakerCopyClipboardHandler;
import minetweaker.mc1710.network.MineTweakerCopyClipboardPacket;
import minetweaker.mc1710.network.MineTweakerLoadScriptsHandler;
import minetweaker.mc1710.network.MineTweakerLoadScriptsPacket;
import minetweaker.mc1710.network.MineTweakerOpenBrowserHandler;
import minetweaker.mc1710.network.MineTweakerOpenBrowserPacket;
import minetweaker.mc1710.oredict.MCOreDict;
import minetweaker.mc1710.recipes.MCRecipeManager;
import minetweaker.mc1710.server.MCServer;
import minetweaker.mc1710.util.MineTweakerHacks;
import minetweaker.mc1710.util.MineTweakerPlatformUtils;
import minetweaker.mc1710.vanilla.MCVanilla;
import minetweaker.runtime.IScriptProvider;
import minetweaker.runtime.providers.ScriptProviderCascade;
import minetweaker.runtime.providers.ScriptProviderCustom;
import minetweaker.runtime.providers.ScriptProviderDirectory;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="MineTweaker3", version="3.2.13")
public class MineTweakerMod {
    public static final String MODID = "MineTweaker3";
    public static final String MCVERSION = "1.7.10";
    public static final SimpleNetworkWrapper NETWORK = NetworkRegistry.INSTANCE.newSimpleChannel("MineTweaker3");
    private static final String[] REGISTRIES = new String[]{"minetweaker.mods.ic2.ClassRegistry", "minetweaker.mods.nei.ClassRegistry", "minetweaker.mods.mfr.ClassRegistry", "minetweaker.mods.gregtech.ClassRegistry", "minetweaker.mods.buildcraft.ClassRegistry"};
    private static final String[] REGISTRY_DESCRIPTIONS = new String[]{"IC2 mod support", "NEI mod support", "MFR mod support", "GregTech mod support", "Buildcraft mod support"};
    @Mod.Instance(value="MineTweaker3")
    public static MineTweakerMod INSTANCE;
    private final IScriptProvider scriptsGlobal;
    private final ScriptProviderCustom scriptsIMC;
    private volatile boolean loaded = false;

    public MineTweakerMod() {
        MCRecipeManager.recipes = CraftingManager.func_77594_a().func_77592_b();
        MineTweakerImplementationAPI.init(new MCOreDict(), new MCRecipeManager(), new MCFurnaceManager(), MCGame.INSTANCE, new MCLoadedMods(), new MCFormatter(), new MCVanilla());
        MineTweakerImplementationAPI.logger.addLogger(new FileLogger(new File("minetweaker.log")));
        MineTweakerImplementationAPI.platform = MCPlatformFunctions.INSTANCE;
        File globalDir = new File("scripts");
        if (!globalDir.exists()) {
            globalDir.mkdirs();
        }
        this.scriptsIMC = new ScriptProviderCustom("intermod");
        this.scriptsGlobal = new ScriptProviderDirectory(globalDir);
        MineTweakerImplementationAPI.setScriptProvider(this.scriptsGlobal);
    }

    @Mod.EventHandler
    public void onIMCEvent(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage imcMessage : event.getMessages()) {
            if (!imcMessage.key.equalsIgnoreCase("addMineTweakerScript")) continue;
            if (imcMessage.isStringMessage()) {
                this.scriptsIMC.add(imcMessage.getSender() + "::imc", imcMessage.getStringValue());
                continue;
            }
            if (!imcMessage.isNBTMessage()) continue;
            NBTTagCompound message = imcMessage.getNBTValue();
            this.scriptsIMC.add(imcMessage.getSender() + "::" + message.func_74779_i("name"), message.func_74779_i("content"));
        }
    }

    @Mod.EventHandler
    public void onLoad(FMLPreInitializationEvent ev) {
        MineTweakerConfig.file = new File(ev.getModConfigurationDirectory(), "MineTweaker3.cfg");
        MineTweakerConfig.load();
        MinecraftForge.EVENT_BUS.register((Object)new ForgeEventHandler());
        FMLCommonHandler.instance().bus().register((Object)new FMLEventHandler());
    }

    @Mod.EventHandler
    public void onPostInit(FMLPostInitializationEvent ev) {
        MineTweakerAPI.registerClassRegistry(MineTweakerRegistry.class);
        for (int i = 0; i < REGISTRIES.length; ++i) {
            MineTweakerAPI.registerClassRegistry(REGISTRIES[i], REGISTRY_DESCRIPTIONS[i]);
        }
        FuelTweaker.INSTANCE.register();
    }

    @Mod.EventHandler
    public void onComplete(FMLLoadCompleteEvent ev) {
        MineTweakerAPI.logInfo("MineTweaker: Building registry");
        ItemBracketHandler.rebuildItemRegistry();
        LiquidBracketHandler.rebuildLiquidRegistry();
        MineTweakerAPI.logInfo("MineTweaker: Sucessfully built item registry");
        if (MineTweakerPlatformUtils.isClient()) {
            MineTweakerAPI.client = new MCClient();
        }
    }

    @Mod.EventHandler
    public void onServerAboutToStart(FMLServerAboutToStartEvent ev) {
        File scriptsDir = new File(MineTweakerHacks.getWorldDirectory(ev.getServer()), "scripts");
        if (!scriptsDir.exists()) {
            scriptsDir.mkdir();
        }
        ScriptProviderDirectory scriptsLocal = new ScriptProviderDirectory(scriptsDir);
        ScriptProviderCascade cascaded = new ScriptProviderCascade(this.scriptsIMC, this.scriptsGlobal, scriptsLocal);
        MineTweakerImplementationAPI.setScriptProvider(cascaded);
        MCServer srv = new MCServer(ev.getServer());
        if (this.loaded && MineTweakerConfig.antiStuck) {
            MineTweakerAPI.server = srv;
        } else {
            MineTweakerImplementationAPI.onServerStart(srv);
            this.loaded = true;
        }
    }

    public void onClientAboutToConnect() {
        if (!MineTweakerConfig.loadScriptsBeforeConnection) {
            return;
        }
        ScriptProviderCascade cascaded = new ScriptProviderCascade(this.scriptsIMC, this.scriptsGlobal);
        MineTweakerImplementationAPI.setScriptProvider(cascaded);
        if (this.loaded && MineTweakerConfig.antiStuck) {
            return;
        }
        MineTweakerImplementationAPI.reload();
        this.loaded = true;
    }

    @Mod.EventHandler
    public void onServerStopped(FMLServerStoppedEvent ev) {
        MineTweakerImplementationAPI.onServerStop();
        MineTweakerImplementationAPI.setScriptProvider(this.scriptsGlobal);
    }

    static {
        NETWORK.registerMessage(MineTweakerLoadScriptsHandler.class, MineTweakerLoadScriptsPacket.class, 0, Side.CLIENT);
        NETWORK.registerMessage(MineTweakerOpenBrowserHandler.class, MineTweakerOpenBrowserPacket.class, 1, Side.CLIENT);
        NETWORK.registerMessage(MineTweakerCopyClipboardHandler.class, MineTweakerCopyClipboardPacket.class, 2, Side.CLIENT);
    }
}

