/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.extraUtils.handlers;

import com.rwtema.extrautils.tileentity.enderconstructor.EnderConstructorRecipesHandler;
import java.util.LinkedList;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.ShapedOreRecipe;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.extraUtils.QED")
public class QED {
    public static final String name = "ExtraUtilities Q.E.D.";

    @ZenMethod
    public static void addShapedRecipe(IItemStack output, IIngredient[][] recipe) {
        MineTweakerAPI.apply((IUndoableAction)new Add((IRecipe)new ShapedOreRecipe(InputHelper.toStack(output), InputHelper.toShapedObjects(recipe))));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output) {
        LinkedList<IRecipe> recipes = new LinkedList<IRecipe>();
        for (IRecipe recipe : EnderConstructorRecipesHandler.recipes) {
            if (recipe == null || recipe.func_77571_b() == null || !StackHelper.matches(output, InputHelper.toIItemStack(recipe.func_77571_b()))) continue;
            recipes.add(recipe);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe found for %s. Command ignored!", name, LogHelper.getStackDescription(output)));
        }
    }

    public static class Remove
    extends BaseListRemoval<IRecipe> {
        protected Remove(LinkedList<IRecipe> stacks) {
            super("QED", EnderConstructorRecipesHandler.recipes, stacks);
        }

        @Override
        protected String getRecipeInfo(IRecipe recipe) {
            return recipe.toString();
        }
    }

    private static class Add
    extends BaseListAddition<IRecipe> {
        public Add(IRecipe recipe) {
            super("QED", EnderConstructorRecipesHandler.recipes);
            this.recipes.add(recipe);
        }

        @Override
        protected String getRecipeInfo(IRecipe recipe) {
            return recipe.toString();
        }
    }
}

