/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.tconstruct.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import mantle.utils.ItemMetaWrapper;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.mods.tconstruct.TConstructHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import modtweaker2.utils.BaseMapAddition;
import modtweaker2.utils.BaseMapRemoval;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import tconstruct.library.crafting.AlloyMix;

@ZenClass(value="mods.tconstruct.Smeltery")
public class Smeltery {
    public static final String nameFuel = "TConstruct Smeltery - Fuel";
    public static final String nameMelting = "TConstruct Smeltery - Melting";
    public static final String nameAlloy = "TConstruct Smeltery - Alloy";

    @ZenMethod
    public static void addAlloy(ILiquidStack output, ILiquidStack[] input) {
        if (input == null || output == null) {
            LogHelper.logError(String.format("Required parameters missing for %s Recipe.", nameAlloy));
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new AddAlloy(new AlloyMix(InputHelper.toFluid(output), new ArrayList<FluidStack>(Arrays.asList(InputHelper.toFluids(input))))));
    }

    @ZenMethod
    public static void removeAlloy(IIngredient output) {
        LinkedList<AlloyMix> recipes = new LinkedList<AlloyMix>();
        for (AlloyMix r : TConstructHelper.alloys) {
            if (r == null || !StackHelper.matches(output, InputHelper.toILiquidStack(r.result))) continue;
            recipes.add(r);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveAlloy(recipes));
        } else {
            LogHelper.logError(String.format("No %s recipes found for %s. Command ignored!", nameAlloy, output.toString()));
        }
    }

    @ZenMethod
    public static void addMelting(IIngredient input, ILiquidStack output, int temp, @Optional IItemStack block) {
        if (input == null || output == null) {
            LogHelper.logError(String.format("Required parameters missing for %s Recipe.", nameMelting));
            return;
        }
        LinkedList<MeltingRecipe> recipes = new LinkedList<MeltingRecipe>();
        for (IItemStack in : input.getItems()) {
            if (block == null && !InputHelper.isABlock(InputHelper.toStack(in))) {
                LogHelper.logWarning(String.format("Item %s is not a block and no block renderer is provided for %s recipe. Input ignored!", in.toString(), nameMelting));
                continue;
            }
            recipes.add(new MeltingRecipe(InputHelper.toStack(in), InputHelper.toFluid(output), temp, block == null ? InputHelper.toStack(in) : InputHelper.toStack(block)));
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new AddMelting(recipes));
        } else {
            LogHelper.logError(String.format("No %s recipes could be added for input %s.", nameMelting, input.toString()));
        }
    }

    @ZenMethod
    public static void removeMelting(IIngredient input) {
        LinkedList<MeltingRecipe> recipes = new LinkedList<MeltingRecipe>();
        for (ItemMetaWrapper meta : TConstructHelper.smeltingList.keySet()) {
            ItemStack in = new ItemStack(meta.item, 1, meta.meta.intValue());
            if (!StackHelper.matches(input, InputHelper.toIItemStack(in))) continue;
            recipes.add(new MeltingRecipe(in, TConstructHelper.smeltingList.get(meta), TConstructHelper.temperatureList.get(meta), TConstructHelper.renderIndex.get(meta)));
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveMelting(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe found for %s. Command ignored!", nameMelting, input.toString()));
        }
    }

    @ZenMethod
    public static void removeFuel(IIngredient input) {
        HashMap<Fluid, Integer[]> recipes = new HashMap<Fluid, Integer[]>();
        for (Map.Entry<Fluid, Integer[]> fuel : TConstructHelper.fuelList.entrySet()) {
            if (fuel == null || fuel.getKey() == null || !StackHelper.matches(input, InputHelper.toILiquidStack(new FluidStack(fuel.getKey(), 1)))) continue;
            recipes.put(fuel.getKey(), fuel.getValue());
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveFuel(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe for %s found. Command ignored!", nameFuel, input.toString()));
        }
    }

    @ZenMethod
    public static void addFuel(ILiquidStack liquid, int power, int duration) {
        if (liquid == null) {
            LogHelper.logError(String.format("Required parameters missing for %s Recipe.", nameFuel));
            return;
        }
        HashMap<Fluid, Integer[]> recipes = new HashMap<Fluid, Integer[]>();
        recipes.put(InputHelper.toFluid(liquid).getFluid(), new Integer[]{power, duration});
        MineTweakerAPI.apply((IUndoableAction)new AddFuel(recipes));
    }

    public static class AddFuel
    extends BaseMapAddition<Fluid, Integer[]> {
        public AddFuel(Map<Fluid, Integer[]> recipes) {
            super(Smeltery.nameFuel, TConstructHelper.fuelList, recipes);
        }

        @Override
        public String getRecipeInfo(Map.Entry<Fluid, Integer[]> recipe) {
            return LogHelper.getStackDescription(new FluidStack(recipe.getKey(), 1));
        }
    }

    public static class RemoveFuel
    extends BaseMapRemoval<Fluid, Integer[]> {
        public RemoveFuel(Map<Fluid, Integer[]> recipes) {
            super(Smeltery.nameFuel, TConstructHelper.fuelList, recipes);
        }

        @Override
        public String getRecipeInfo(Map.Entry<Fluid, Integer[]> recipe) {
            return LogHelper.getStackDescription(new FluidStack(recipe.getKey(), 1));
        }
    }

    protected static class MeltingRecipe {
        public final ItemMetaWrapper meta;
        public final ItemStack input;
        public final FluidStack fluid;
        public final Integer temperature;
        public final ItemStack renderer;

        protected MeltingRecipe(ItemStack input, FluidStack fluid, int temperature, ItemStack renderer) {
            this.input = input;
            this.fluid = fluid;
            this.temperature = temperature;
            this.renderer = renderer;
            this.meta = new ItemMetaWrapper(input);
        }

        public Block getRendererBlock() {
            return Block.func_149634_a((Item)this.renderer.func_77973_b());
        }

        public int getRendererMeta() {
            return this.renderer.func_77960_j();
        }
    }

    private static class RemoveMelting
    extends BaseListRemoval<MeltingRecipe> {
        public RemoveMelting(List<MeltingRecipe> recipes) {
            super(Smeltery.nameMelting, null, recipes);
        }

        @Override
        public void apply() {
            for (MeltingRecipe recipe : this.recipes) {
                TConstructHelper.smeltingList.remove(recipe.meta);
                TConstructHelper.temperatureList.remove(recipe.meta);
                TConstructHelper.renderIndex.remove(recipe.meta);
                this.successful.add(recipe);
            }
        }

        @Override
        public void undo() {
            for (MeltingRecipe recipe : this.successful) {
                tconstruct.library.crafting.Smeltery.addMelting((ItemStack)recipe.input, (Block)recipe.getRendererBlock(), (int)recipe.getRendererMeta(), (int)recipe.temperature, (FluidStack)recipe.fluid);
            }
        }

        @Override
        public String getRecipeInfo(MeltingRecipe recipe) {
            return LogHelper.getStackDescription(recipe.input);
        }
    }

    private static class AddMelting
    extends BaseListAddition<MeltingRecipe> {
        public AddMelting(List<MeltingRecipe> recipes) {
            super(Smeltery.nameMelting, null, recipes);
        }

        @Override
        public void apply() {
            for (MeltingRecipe recipe : this.recipes) {
                tconstruct.library.crafting.Smeltery.addMelting((ItemStack)recipe.input, (Block)recipe.getRendererBlock(), (int)recipe.getRendererMeta(), (int)recipe.temperature, (FluidStack)recipe.fluid);
                this.successful.add(recipe);
            }
        }

        @Override
        public void undo() {
            for (MeltingRecipe recipe : this.successful) {
                TConstructHelper.smeltingList.remove(recipe.meta);
                TConstructHelper.temperatureList.remove(recipe.meta);
                TConstructHelper.renderIndex.remove(recipe.meta);
            }
        }

        @Override
        public String getRecipeInfo(MeltingRecipe recipe) {
            return LogHelper.getStackDescription(recipe.input);
        }
    }

    private static class RemoveAlloy
    extends BaseListRemoval<AlloyMix> {
        public RemoveAlloy(List<AlloyMix> recipes) {
            super(Smeltery.nameAlloy, TConstructHelper.alloys, recipes);
        }

        @Override
        protected String getRecipeInfo(AlloyMix recipe) {
            return LogHelper.getStackDescription(recipe.result);
        }
    }

    private static class AddAlloy
    extends BaseListAddition<AlloyMix> {
        public AddAlloy(AlloyMix recipe) {
            super(Smeltery.nameAlloy, TConstructHelper.alloys);
            this.recipes.add(recipe);
        }

        @Override
        protected String getRecipeInfo(AlloyMix recipe) {
            return LogHelper.getStackDescription(recipe.result);
        }
    }
}

