/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.entity.boss.dragon.managers;

import chylex.hee.entity.boss.EntityBossDragon;
import chylex.hee.init.ItemList;
import chylex.hee.system.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class DragonRewardManager {
    private static byte[] difficultyHandicap = new byte[]{7, 20, 70, 100};
    private final EntityBossDragon dragon;
    private final List<UUID> deadPlayers = new ArrayList<UUID>();
    private int[] difficultyTimer = new int[4];
    private float extraHandicap;
    private int finalDifficulty = -1;
    private byte difficultyCooldown = (byte)120;
    private boolean deadPlayerCheck;

    public DragonRewardManager(EntityBossDragon dragon) {
        this.dragon = dragon;
        this.extraHandicap = 0.0f;
    }

    public void addHandicap(float v, boolean playerAffect) {
        this.extraHandicap = playerAffect ? (this.extraHandicap += v / Math.max(1.0f, (float)this.dragon.field_70170_p.field_73010_i.size() / 1.5f)) : (this.extraHandicap += v);
    }

    public float getExtraHandicap() {
        return this.extraHandicap;
    }

    private int getEssencePerTick() {
        return 1 + MathUtil.floor((float)this.getFinalDifficulty() / 6.0f);
    }

    public void updateManager() {
        byte diff = (byte)this.dragon.field_70170_p.field_73013_u.func_151525_a();
        if (this.deadPlayerCheck ^= true) {
            for (EntityPlayer p : this.dragon.field_70170_p.field_73010_i) {
                boolean wasDead = this.deadPlayers.contains(p.getPersistentID());
                if (p.field_70128_L && !wasDead) {
                    float v;
                    switch (diff) {
                        case 3: {
                            v = 2.9f;
                            break;
                        }
                        case 2: {
                            v = 3.5f;
                            break;
                        }
                        case 1: {
                            v = 3.8f;
                            break;
                        }
                        default: {
                            v = 4.0f;
                        }
                    }
                    this.addHandicap(v, true);
                    this.deadPlayers.add(p.getPersistentID());
                    continue;
                }
                if (p.field_70128_L || !wasDead) continue;
                this.deadPlayers.remove(p.getPersistentID());
            }
        }
        if ((this.difficultyCooldown = (byte)(this.difficultyCooldown - 1)) > 0 || diff < 0 || diff > 3) {
            return;
        }
        this.difficultyCooldown = (byte)80;
        byte by = diff;
        this.difficultyTimer[by] = this.difficultyTimer[by] + (this.dragon.angryStatus ? 2 : 1);
    }

    public int getFinalDifficultyRaw() {
        return this.getFinalDifficulty() + MathUtil.ceil(this.extraHandicap);
    }

    public int getFinalDifficulty() {
        if (this.finalDifficulty >= 0) {
            return this.finalDifficulty;
        }
        int total = 0;
        int finalDiff = 0;
        for (int i : this.difficultyTimer) {
            total += i;
        }
        if (total == 0) {
            this.finalDifficulty = 0;
            return 0;
        }
        for (int a = 0; a < difficultyHandicap.length; a = (int)((byte)(a + 1))) {
            finalDiff += MathUtil.floor((float)difficultyHandicap[a] * ((float)this.difficultyTimer[a] / (float)total));
        }
        this.finalDifficulty = finalDiff = (int)((double)finalDiff - Math.ceil(this.extraHandicap));
        return finalDiff;
    }

    public void spawnEssence(World world, int x, int z) {
        float len = Math.min(44.0f, (float)(Math.abs(world.field_73012_v.nextGaussian()) * 24.0));
        double ang = world.field_73012_v.nextDouble() * Math.PI * 2.0;
        double fx = (double)x + Math.cos(ang) * (double)len;
        double fz = (double)z + Math.sin(ang) * (double)len;
        EntityItem item = new EntityItem(world, fx + world.field_73012_v.nextDouble() - 0.5, 128.0, fz + world.field_73012_v.nextDouble() - 0.5, new ItemStack(ItemList.essence, this.getEssencePerTick(), 0));
        item.field_145804_b = 10;
        world.func_72838_d((Entity)item);
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74776_a("ehc", this.extraHandicap);
        for (int a = 0; a < this.difficultyTimer.length; ++a) {
            tag.func_74768_a("dt" + a, this.difficultyTimer[a]);
        }
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.extraHandicap = tag.func_74760_g("ehc");
        for (int a = 0; a < difficultyHandicap.length; a = (int)((byte)(a + 1))) {
            this.difficultyTimer[a] = tag.func_74762_e("dt" + a);
        }
    }
}

