/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.holoInventory.client;

import java.text.DecimalFormat;
import java.util.List;
import net.dries007.holoInventory.Config;
import net.dries007.holoInventory.HoloInventory;
import net.dries007.holoInventory.client.ClientHandler;
import net.dries007.holoInventory.util.Helper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import org.lwjgl.opengl.GL11;

public class GroupRenderer {
    private static float time;
    private final EntityItem fakeEntityItem;
    private static final int TEXT_COLOR = -1426063361;
    static int stackSizeDebugOverride;
    private float scale;
    private float width;
    private float height;
    private float spacing;
    private float offset;
    private int columns;
    private int rows;
    private boolean renderText;
    private static final DecimalFormat DF_ONE_FRACTION_DIGIT;
    private static final DecimalFormat DF_TWO_FRACTION_DIGIT;
    private static final String[] suffixNormal;
    private static final String[] suffixDarkened;

    public GroupRenderer() {
        this.fakeEntityItem = new EntityItem((World)Minecraft.func_71410_x().field_71441_e);
        this.fakeEntityItem.func_92058_a(new ItemStack((Item)HoloInventory.fluidRenderFakeItem));
        this.fakeEntityItem.field_70290_d = 0.0f;
    }

    public static void updateTime() {
        time = (float)(360.0 * (double)(System.currentTimeMillis() & 0x3FFFL) / 16383.0);
    }

    public void calculateColumns(int totalAmount) {
        this.columns = totalAmount < 9 ? totalAmount : (totalAmount <= 27 ? 9 : (totalAmount <= 54 ? 11 : (totalAmount <= 90 ? 14 : (totalAmount <= 109 ? 18 : 21))));
    }

    public void calculateRows(int totalAmount) {
        this.setRows(totalAmount % this.columns == 0 ? totalAmount / this.columns - 1 : totalAmount / this.columns);
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public void setScale(float scaleAddition) {
        float scaleModifier = this.columns > 9 ? 0.2f - (float)this.columns * 0.005f : 0.2f + (float)(9 - this.columns) * 0.05f;
        this.scale = scaleModifier + scaleAddition;
    }

    public void setSpacing(float spacing) {
        this.spacing = spacing;
        this.width = (float)this.columns * this.getActualSpacing();
        this.height = (float)this.rows * this.getActualSpacing();
    }

    public void setOffset(float offset) {
        this.offset = offset;
    }

    public void setRenderText(boolean renderText) {
        this.renderText = renderText;
    }

    public void reset() {
        this.scale = 0.0f;
        this.width = 0.0f;
        this.height = 0.0f;
        this.spacing = 0.0f;
        this.offset = 0.0f;
        this.columns = 0;
        this.rows = 0;
        this.renderText = false;
    }

    private float getActualSpacing() {
        return this.scale * (this.spacing + 0.1f) * 0.4f;
    }

    public float calculateOffset() {
        return this.height + this.getActualSpacing() * 2.0f;
    }

    public void renderItems(List<ItemStack> itemStacks) {
        int column = 0;
        int row = 0;
        for (ItemStack stack : itemStacks) {
            this.renderItem(stack, column, row);
            if (++column < this.columns) continue;
            column = 0;
            ++row;
        }
    }

    private void renderItem(ItemStack itemStack, int column, int row) {
        if (itemStack == null) {
            return;
        }
        this.fakeEntityItem.func_92058_a(itemStack);
        if (itemStack.hasEffect(0)) {
            GL11.glDisable((int)2896);
        }
        this.doRenderEntityItem(column, row, (String)(itemStack.func_77976_d() == 1 && itemStack.field_77994_a == 1 ? null : this.doStackSizeCrap(itemStack.field_77994_a)));
    }

    public void renderFluids(List<FluidTankInfo> fluidTankInfos) {
        int column = 0;
        int row = 0;
        for (FluidTankInfo tankInfo : fluidTankInfos) {
            this.renderFluid(tankInfo.fluid, column, row);
            if (++column < this.columns) continue;
            column = 0;
            ++row;
        }
    }

    private void renderFluid(FluidStack fluidStack, int column, int row) {
        Fluid fluid = fluidStack.getFluid();
        HoloInventory.fluidRenderFakeItem.setFluid(fluid);
        String suffix = Config.renderSuffixDarkened ? EnumChatFormatting.GRAY + "L" : "L";
        this.doRenderEntityItem(column, row, this.doStackSizeCrap(fluidStack.amount) + suffix);
    }

    private void doRenderEntityItem(int column, int row, String stackSizeText) {
        RenderHelper.func_74519_b();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(this.width - ((float)column + 0.2f) * this.scale * this.spacing), (float)(this.height - ((float)row + 0.05f) * this.scale * this.spacing), (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)this.offset, (float)0.0f);
        GL11.glScalef((float)this.scale, (float)this.scale, (float)this.scale);
        if (Minecraft.func_71410_x().field_71474_y.field_74347_j) {
            GL11.glRotatef((float)(Config.rotateItems ? time : 0.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        } else {
            GL11.glRotatef((float)RenderManager.field_78727_a.field_78735_i, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        ClientHandler.RENDER_ITEM.func_76986_a(this.fakeEntityItem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
        GL11.glPopMatrix();
        RenderHelper.func_74518_a();
        if (this.renderText && stackSizeText != null) {
            GL11.glPushMatrix();
            GL11.glDisable((int)2929);
            GL11.glTranslatef((float)(this.width - ((float)column + 0.2f) * this.scale * this.spacing), (float)(this.height - ((float)row + 0.05f) * this.scale * this.spacing), (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)this.offset, (float)0.0f);
            GL11.glScalef((float)this.scale, (float)this.scale, (float)this.scale);
            GL11.glScalef((float)0.03f, (float)0.03f, (float)0.03f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)-1.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)((float)(-RenderManager.field_78727_a.func_78716_a().func_78256_a(stackSizeText)) / 2.0f), (float)0.0f, (float)0.0f);
            RenderManager.field_78727_a.func_78716_a().func_85187_a(stackSizeText, 0, 0, -1426063361, true);
            GL11.glDisable((int)32826);
            GL11.glEnable((int)2929);
            GL11.glPopMatrix();
        }
    }

    public static void renderBG(GroupRenderer ... renderers) {
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        GL11.glDisable((int)2929);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        Tessellator tess = Tessellator.field_78398_a;
        Tessellator.renderingWorldRenderer = false;
        tess.func_78371_b(7);
        tess.func_78370_a(Config.colorR, Config.colorG, Config.colorB, Config.colorAlpha);
        float x0 = Helper.max(renderer -> Float.valueOf(renderer.width + renderer.scale / 3.0f), renderers);
        float x1 = Helper.min(renderer -> Float.valueOf(-renderer.width - renderer.scale / 3.0f), renderers);
        float y0 = Helper.max(renderer -> Float.valueOf(renderer.scale / 3.0f + renderer.height + renderer.offset), renderers);
        float y1 = Helper.min(renderer -> Float.valueOf(-renderer.scale / 3.0f - renderer.height), renderers);
        tess.func_78377_a((double)x0, (double)y1, 0.0);
        tess.func_78377_a((double)x1, (double)y1, 0.0);
        tess.func_78377_a((double)x1, (double)y0, 0.0);
        tess.func_78377_a((double)x0, (double)y0, 0.0);
        tess.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glDisable((int)32826);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3553);
        GL11.glPopMatrix();
    }

    public static void renderName(String name, GroupRenderer ... renderers) {
        FontRenderer fontRenderer = RenderManager.field_78727_a.func_78716_a();
        name = Config.nameOverrides.containsKey(name) ? Config.nameOverrides.get(name) : StatCollector.func_74838_a((String)name);
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        GL11.glDisable((int)2929);
        GL11.glTranslatef((float)0.0f, (float)Helper.sum(renderer -> Float.valueOf(renderer.height + renderer.scale / 1.25f), renderers), (float)0.0f);
        float scale = Helper.max(renderer -> Float.valueOf(renderer.scale), renderers);
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        GL11.glScalef((float)1.5f, (float)1.5f, (float)1.5f);
        GL11.glScalef((float)0.03f, (float)0.03f, (float)0.03f);
        GL11.glTranslated((double)((float)fontRenderer.func_78256_a(name) / 2.0f), (double)0.0, (double)0.0);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        fontRenderer.func_85187_a(name, 0, 0, -1426063361, true);
        GL11.glDisable((int)32826);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2929);
        GL11.glPopMatrix();
    }

    private String doStackSizeCrap(int stackSize) {
        if (stackSizeDebugOverride != 0) {
            stackSize = stackSizeDebugOverride;
        }
        return GroupRenderer.formatStackSize(stackSize);
    }

    private static String formatStackSize(long i) {
        int level;
        String[] suffixSelected = Config.renderSuffixDarkened ? suffixDarkened : suffixNormal;
        for (level = 0; i > 1000L && level < suffixSelected.length - 1; ++level, i /= 1000L) {
            if (i >= 100000L) {
                continue;
            }
            if (i >= 10000L) {
                return DF_ONE_FRACTION_DIGIT.format((double)i / 1000.0) + suffixSelected[level];
            }
            return DF_TWO_FRACTION_DIGIT.format((double)i / 1000.0) + suffixSelected[level];
        }
        return i + suffixSelected[level];
    }

    static {
        stackSizeDebugOverride = 0;
        DF_ONE_FRACTION_DIGIT = new DecimalFormat("##.0");
        DF_TWO_FRACTION_DIGIT = new DecimalFormat("#.00");
        suffixNormal = new String[]{"", "K", "M", "B"};
        suffixDarkened = new String[]{"", EnumChatFormatting.GRAY + "K", EnumChatFormatting.GRAY + "M", EnumChatFormatting.GRAY + "B"};
    }
}

