/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.util.math;

import gregtech.api.enums.GT_Values;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.api.objects.data.Pair;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.Utils;
import java.text.NumberFormat;
import java.util.Map;
import java.util.Random;

public class MathUtils {
    static final Random rand = CORE.RANDOM;
    private static final NumberFormat sNumberFormat = NumberFormat.getInstance();

    public static int randInt(int min, int max) {
        return rand.nextInt(max - min + 1) + min;
    }

    public static double getChanceOfXOverYRuns(double x, double y) {
        return 1.0 - Math.pow(1.0 - x, y);
    }

    public static long randLong(long min, long max) {
        return MathUtils.nextLong(rand, max - min + 1L) + min;
    }

    private static long nextLong(Random rng, long n) {
        long val;
        long bits;
        while ((bits = rng.nextLong() << 1 >>> 1) - (val = bits % n) + (n - 1L) < 0L) {
        }
        return val;
    }

    public static double randDouble(double min, double max) {
        return MathUtils.nextDouble(rand, max - min + 1.0) + min;
    }

    private static double nextDouble(Random rng, double n) {
        double val;
        double bits;
        while ((bits = (double)(rng.nextLong() << 1 >>> 1)) - (val = bits % n) + (n - 1.0) < 0.0) {
        }
        return val;
    }

    public static float randFloat(float min, float max) {
        return MathUtils.nextFloat(rand, max - min + 1.0f) + min;
    }

    private static float nextFloat(Random rng, float n) {
        float val;
        float bits;
        while ((bits = (float)(rng.nextLong() << 1 >>> 1)) - (val = bits % n) + (n - 1.0f) < 0.0f) {
        }
        return val;
    }

    public static double findPercentage(double current, double max) {
        return (double)Math.round(current / max * 100.0 * 100.0) / 100.0;
    }

    public static float findPercentage(float current, float max) {
        return (float)((double)Math.round((double)(current / max * 100.0f) * 100.0) / 100.0);
    }

    public static int findPercentageOfInt(long input, float percentage) {
        return (int)((float)input * (percentage / 100.0f));
    }

    public static double decimalRounding(double d) {
        return (double)Math.round(d * 2.0) / 2.0;
    }

    public static double decimalRoundingToWholes(double d) {
        return 5L * Math.round(d / 5.0);
    }

    public static int roundToClosestInt(double d) {
        return (int)((double)Math.round(d * 2.0) / 2.0);
    }

    public static int roundToClosestMultiple(double number, int multiple) {
        int result = multiple;
        if (number % (double)multiple == 0.0) {
            return (int)number;
        }
        if (number % (double)multiple != 0.0) {
            int division = (int)(number / (double)multiple + 1.0);
            result = division * multiple;
        }
        return result;
    }

    public static long roundToClosestLong(double d) {
        return (long)((double)Math.round(d * 2.0) / 2.0);
    }

    public static boolean divideXintoY(int x, int y) {
        return x % y == 0;
    }

    public static boolean isNumberEven(long x) {
        return x % 2L == 0L;
    }

    public static float celsiusToKelvin(int i) {
        double f = (float)i + 273.15f;
        return (int)MathUtils.decimalRoundingToWholes(f);
    }

    public static int getHexNumberFromInt(int input) {
        String result = Integer.toHexString(input);
        int resultINT = Integer.getInteger(result);
        return resultINT;
    }

    public static int generateRandomHexValue(int min, int max) {
        return MathUtils.getHexNumberFromInt(MathUtils.randInt(min, max));
    }

    public static int generateSingularRandomHexValue() {
        int randomInt = MathUtils.randInt(1, 5);
        Map<Integer, String> colours = Utils.hexColourGeneratorRandom(5);
        String temp = colours.get(randomInt) != null && colours.size() > 0 ? colours.get(randomInt) : "0F0F0F";
        Logger.WARNING("Operating with " + temp);
        temp = Utils.appenedHexNotationToString(String.valueOf(temp));
        return Integer.decode(temp);
    }

    public static long[] simplifyNumbersToSmallestForm(long[] inputArray) {
        long GCD = MathUtils.gcd(inputArray);
        long[] outputArray = new long[inputArray.length];
        for (int i = 0; i < inputArray.length; ++i) {
            outputArray[i] = GCD != 0L ? inputArray[i] / GCD : inputArray[i];
        }
        if (outputArray.length > 0) {
            return outputArray;
        }
        return new long[0];
    }

    private static long gcd(long a, long b) {
        while (b > 0L) {
            long temp = b;
            b = a % b;
            a = temp;
        }
        return a;
    }

    private static long gcd(long[] input) {
        long result = input[0];
        for (int i = 1; i < input.length; ++i) {
            result = MathUtils.gcd(result, input[i]);
        }
        return result;
    }

    public static final int getRgbAsHex(short[] RGBA) {
        int returnValue = Utils.rgbtoHexValue(RGBA[0], RGBA[1], RGBA[2]);
        return returnValue == 0 ? 0 : returnValue;
    }

    public static final int returnLargestNumber(int a, int b) {
        if (a > b) {
            return a;
        }
        if (a == b) {
            return a;
        }
        return b;
    }

    public static byte safeByte(long number) {
        return number > 127L ? (byte)127 : (byte)number;
    }

    public static short safeShort(long number) {
        return number > 32767L ? (short)Short.MAX_VALUE : (short)number;
    }

    public static int safeInt(long number, int margin) {
        return number > (long)(Integer.MAX_VALUE - margin) ? Integer.MAX_VALUE - margin : (int)number;
    }

    public static int safeInt(long number) {
        return number > GT_Values.V[GT_Values.V.length - 1] ? MathUtils.safeInt(GT_Values.V[GT_Values.V.length - 1], 1) : (number < Integer.MIN_VALUE ? Integer.MIN_VALUE : (int)number);
    }

    public static int getRandomFromArray(int[] mValues) {
        int[] mLargeChanceArray = new int[(mValues.length - 1) * 1000];
        for (int g = 0; g < mLargeChanceArray.length; ++g) {
            int mValueSelection = MathUtils.randInt(0, mValues.length - 1);
            mLargeChanceArray[g] = mValues[mValueSelection];
        }
        return mLargeChanceArray[MathUtils.randInt(0, mLargeChanceArray.length - 1)];
    }

    public static byte getByteAverage(AutoMap<Byte> aDataSet) {
        byte[] aNewSet = new byte[aDataSet.size()];
        for (int u = 0; u < aDataSet.size(); ++u) {
            byte b;
            aNewSet[u] = b = MathUtils.getSafeByte(aDataSet.get(u));
        }
        return MathUtils.getByteAverage(aNewSet);
    }

    public static short getShortAverage(AutoMap<Short> aDataSet) {
        short[] aNewSet = new short[aDataSet.size()];
        for (int u = 0; u < aDataSet.size(); ++u) {
            short b;
            aNewSet[u] = b = MathUtils.getSafeShort(aDataSet.get(u));
        }
        return MathUtils.getShortAverage(aNewSet);
    }

    public static int getIntAverage(AutoMap<Integer> aDataSet) {
        int[] aNewSet = new int[aDataSet.size()];
        for (int u = 0; u < aDataSet.size(); ++u) {
            int b;
            aNewSet[u] = b = MathUtils.getSafeInt(aDataSet.get(u));
        }
        return MathUtils.getIntAverage(aNewSet);
    }

    public static float getFloatAverage(AutoMap<Float> aDataSet) {
        float[] aNewSet = new float[aDataSet.size()];
        for (int u = 0; u < aDataSet.size(); ++u) {
            float b;
            aNewSet[u] = b = MathUtils.getSafeFloat(aDataSet.get(u));
        }
        return MathUtils.getFloatAverage(aNewSet);
    }

    public static long getLongAverage(AutoMap<Long> aDataSet) {
        long[] aNewSet = new long[aDataSet.size()];
        for (int u = 0; u < aDataSet.size(); ++u) {
            long b;
            aNewSet[u] = b = MathUtils.getSafeLong(aDataSet.get(u));
        }
        return MathUtils.getLongAverage(aNewSet);
    }

    public static double getDoubleAverage(AutoMap<Double> aDataSet) {
        double[] aNewSet = new double[aDataSet.size()];
        for (int u = 0; u < aDataSet.size(); ++u) {
            double b;
            aNewSet[u] = b = MathUtils.getSafeDouble(aDataSet.get(u));
        }
        return MathUtils.getDoubleAverage(aNewSet);
    }

    public static byte getByteAverage(byte[] aDataSet) {
        if (aDataSet.length <= 0) {
            return 0;
        }
        int divisor = aDataSet.length;
        int total = 0;
        for (byte i : aDataSet) {
            total = (byte)(total + i);
        }
        byte result = MathUtils.safeByte(total / divisor);
        return result;
    }

    public static short getShortAverage(short[] aDataSet) {
        if (aDataSet.length <= 0) {
            return 0;
        }
        int divisor = aDataSet.length;
        Logger.WARNING("Calculating Average Short. Divisor: " + divisor);
        int total = 0;
        for (short i : aDataSet) {
            Logger.WARNING("Adding " + i);
            total = (short)(total + i);
        }
        short result = MathUtils.safeShort(total / divisor);
        Logger.WARNING("Average: " + result);
        return result;
    }

    public static int getIntAverage(int[] aDataSet) {
        if (aDataSet.length <= 0) {
            return 0;
        }
        int divisor = aDataSet.length;
        int total = 0;
        for (int i : aDataSet) {
            total += i;
        }
        int result = MathUtils.safeInt(total / divisor);
        return result;
    }

    public static float getFloatAverage(float[] aDataSet) {
        if (aDataSet.length <= 0) {
            return 0.0f;
        }
        int divisor = aDataSet.length;
        float total = 0.0f;
        for (float i : aDataSet) {
            total += i;
        }
        float result = total / (float)divisor;
        return result;
    }

    public static long getLongAverage(long[] aDataSet) {
        if (aDataSet.length <= 0) {
            return 0L;
        }
        int divisor = aDataSet.length;
        long total = 0L;
        for (long i : aDataSet) {
            total += i;
        }
        long result = total / (long)divisor;
        return result;
    }

    public static double getDoubleAverage(double[] aDataSet) {
        if (aDataSet.length <= 0) {
            return 0.0;
        }
        int divisor = aDataSet.length;
        double total = 0.0;
        for (double i : aDataSet) {
            total += i;
        }
        double result = total / (double)divisor;
        return result;
    }

    public static int howManyPlaces(int aValueForGen) {
        if (aValueForGen < 0) {
            aValueForGen = MathUtils.makeNegative(aValueForGen);
        }
        String a = String.valueOf(aValueForGen);
        return a.length();
    }

    public static int makeNegative(int aPositive) {
        if (aPositive > 0) {
            return -aPositive;
        }
        if (aPositive < 0) {
            return aPositive;
        }
        return 0;
    }

    public static <V> V safeCast(Object aNumberType) {
        long a1 = Long.parseLong(aNumberType.toString());
        double a2 = Double.parseDouble(aNumberType.toString());
        if (aNumberType.getClass() == Byte.TYPE || aNumberType instanceof Byte) {
            if (a1 >= -128L && a1 <= 127L) {
                String s = "" + a1;
                Byte s1 = Byte.valueOf(s);
                return (V)s1;
            }
        } else if (aNumberType.getClass() == Short.TYPE || aNumberType instanceof Short) {
            if (a1 >= -32768L && a1 <= 32767L) {
                String s = "" + a1;
                Short s1 = Short.valueOf(s);
                return (V)s1;
            }
        } else if (aNumberType.getClass() == Integer.TYPE || aNumberType instanceof Integer) {
            if (a1 >= Integer.MIN_VALUE && a1 <= Integer.MAX_VALUE) {
                String s = "" + a1;
                Integer s1 = Integer.valueOf(s);
                return (V)s1;
            }
        } else if (aNumberType.getClass() == Long.TYPE || aNumberType instanceof Long) {
            if (a1 >= Long.MIN_VALUE && a1 <= Long.MAX_VALUE) {
                String s = "" + a1;
                Long s1 = Long.valueOf(s);
                return (V)s1;
            }
        } else if (aNumberType.getClass() == Float.TYPE || aNumberType instanceof Float) {
            if (a2 >= (double)1.4E-45f && a2 <= 3.4028234663852886E38) {
                String s = "" + a1;
                Float s1 = Float.valueOf(s);
                return (V)s1;
            }
        } else if ((aNumberType.getClass() == Double.TYPE || aNumberType instanceof Double) && a2 >= Double.MIN_VALUE && a2 <= Double.MAX_VALUE) {
            String s = "" + a1;
            Double s1 = Double.valueOf(s);
            return (V)s1;
        }
        Integer o = 0;
        return (V)o;
    }

    public static byte getSafeByte(Byte b) {
        Byte a = (Byte)MathUtils.safeCast(b);
        return a;
    }

    public static short getSafeShort(Short b) {
        Short a = (Short)MathUtils.safeCast(b);
        return a;
    }

    public static int getSafeInt(Integer b) {
        Integer a = (Integer)MathUtils.safeCast(b);
        return a;
    }

    public static long getSafeLong(Long b) {
        Long a = (Long)MathUtils.safeCast(b);
        return a;
    }

    public static float getSafeFloat(Float b) {
        Float a = (Float)MathUtils.safeCast(b);
        return a.floatValue();
    }

    public static double getSafeDouble(Double b) {
        Double a = (Double)MathUtils.safeCast(b);
        return a;
    }

    public static long safeCast_IntToLong(int o) {
        long i = o;
        return i;
    }

    public static int safeCast_LongToInt(long o) {
        if (o > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        int i = (int)o;
        return i;
    }

    public static short safeCast_IntToShort(int o) {
        if (o > Short.MAX_VALUE) {
            return Short.MAX_VALUE;
        }
        short i = (short)o;
        return i;
    }

    public static int safeCast_ShortToInt(short o) {
        short i = o;
        return i;
    }

    public static byte safeCast_ShortToByte(short o) {
        if (o > 127) {
            return 127;
        }
        byte i = (byte)o;
        return i;
    }

    public static short safeCast_ByteToshort(byte o) {
        short i = o;
        return i;
    }

    public static int balance(int aInput, int aMin, int aMax) {
        return Math.max(Math.min(aInput, aMax), aMin);
    }

    public static Number balance(Number aInput, Number aMin, Number aMax) {
        return MathUtils.max(MathUtils.min(aInput, aMax), aMin);
    }

    public static int balanceInt(Number aInput, Number aMin, Number aMax) {
        return MathUtils.safeCast_LongToInt((Long)MathUtils.balance(MathUtils.max(MathUtils.min(aInput, aMax), aMin), (Number)Integer.MIN_VALUE, (Number)Integer.MAX_VALUE));
    }

    public static long balanceLong(Number aInput, Number aMin, Number aMax) {
        return (Long)MathUtils.balance(MathUtils.max(MathUtils.min(aInput, aMax), aMin), Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public static int getValueWithinRange(int i, int aMin, int aMax) {
        int aAmount = Math.max(Math.min(i, aMax), aMin);
        return aAmount;
    }

    public static Pair<Integer, Integer> splitLongIntoIntegers(long aLong) {
        int aIntMaxInLong = (int)Math.min(2.147483647E9, Math.floor(aLong / Integer.MAX_VALUE));
        int aRemainder = (int)(aLong - (long)(aIntMaxInLong * Integer.MAX_VALUE));
        return new Pair<Integer, Integer>(aIntMaxInLong, aRemainder);
    }

    public static Number min(Number a, Number b) {
        return a.longValue() <= b.longValue() ? (Number)a : (Number)b;
    }

    public static Number max(Number a, Number b) {
        return a.longValue() >= b.longValue() ? (Number)a : (Number)b;
    }

    public static long combineTwoIntegersToLong(int a, int b) {
        long val = (long)a << 32 | (long)b & 0xFFFFFFFFL;
        return val;
    }

    public static int[] splitLongIntoTwoIntegers(long aNum) {
        int a = (int)(aNum >> 32);
        int b = (int)aNum;
        return new int[]{a, b};
    }

    public static String formatNumbers(long aNumber) {
        return sNumberFormat.format(aNumber);
    }

    public static String formatNumbers(double aNumber) {
        return sNumberFormat.format(aNumber);
    }

    static {
        sNumberFormat.setMaximumFractionDigits(2);
    }
}

