/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.util.minecraft;

import gregtech.api.items.GT_MetaGenerated_Tool;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.item.ModItems;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class NBTUtils {
    public static NBTTagCompound getNBT(ItemStack aStack) {
        NBTTagCompound rNBT = aStack.func_77978_p();
        return rNBT == null ? new NBTTagCompound() : rNBT;
    }

    public static void setBookTitle(ItemStack aStack, String aTitle) {
        NBTTagCompound tNBT = NBTUtils.getNBT(aStack);
        tNBT.func_74778_a("title", aTitle);
        GT_Utility.ItemNBT.setNBT((ItemStack)aStack, (NBTTagCompound)tNBT);
    }

    public static String getBookTitle(ItemStack aStack) {
        NBTTagCompound tNBT = NBTUtils.getNBT(aStack);
        return tNBT.func_74779_i("title");
    }

    public static ItemStack[] readItemsFromNBT(ItemStack itemstack) {
        NBTTagCompound tNBT = NBTUtils.getNBT(itemstack);
        NBTTagList list = tNBT.func_150295_c("Items", 10);
        ItemStack[] inventory = new ItemStack[list.func_74745_c()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound data = list.func_150305_b(i);
            int slot = data.func_74762_e("Slot");
            if (slot < 0 || slot >= list.func_74745_c()) continue;
            inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)data) == ItemUtils.getSimpleStack(ModItems.ZZZ_Empty) ? null : ItemStack.func_77949_a((NBTTagCompound)data);
        }
        return inventory;
    }

    public static ItemStack[] readItemsFromNBT(ItemStack itemstack, String customkey) {
        NBTTagCompound tNBT = NBTUtils.getNBT(itemstack);
        NBTTagList list = tNBT.func_150295_c(customkey, 10);
        ItemStack[] inventory = new ItemStack[list.func_74745_c()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound data = list.func_150305_b(i);
            int slot = data.func_74762_e("Slot");
            if (slot < 0 || slot >= list.func_74745_c()) continue;
            inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)data) == ItemUtils.getSimpleStack(ModItems.ZZZ_Empty) ? null : ItemStack.func_77949_a((NBTTagCompound)data);
        }
        return inventory;
    }

    public static ItemStack writeItemsToNBT(ItemStack itemstack, ItemStack[] stored) {
        NBTTagCompound tNBT = NBTUtils.getNBT(itemstack);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < stored.length; ++i) {
            NBTTagCompound data;
            ItemStack stack = stored[i];
            if (stack != null) {
                data = new NBTTagCompound();
                stack.func_77955_b(data);
                data.func_74768_a("Slot", i);
                list.func_74742_a((NBTBase)data);
                continue;
            }
            data = new NBTTagCompound();
            ItemStack nullstack = ItemUtils.getSimpleStack(ModItems.ZZZ_Empty);
            nullstack.func_77955_b(data);
            data.func_74768_a("Slot", i);
            list.func_74742_a((NBTBase)data);
        }
        tNBT.func_74782_a("Items", (NBTBase)list);
        itemstack.func_77982_d(tNBT);
        return itemstack;
    }

    public static ItemStack writeItemsToNBT(ItemStack itemstack, ItemStack[] stored, String customkey) {
        NBTTagCompound tNBT = NBTUtils.getNBT(itemstack);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < stored.length; ++i) {
            ItemStack stack = stored[i];
            if (stack == null) continue;
            NBTTagCompound data = new NBTTagCompound();
            stack.func_77955_b(data);
            data.func_74768_a("Slot", i);
            list.func_74742_a((NBTBase)data);
        }
        tNBT.func_74782_a(customkey, (NBTBase)list);
        itemstack.func_77982_d(tNBT);
        return itemstack;
    }

    public static ItemStack writeItemsToGtCraftingComponents(ItemStack rStack, ItemStack[] input, boolean copyTags) {
        try {
            ItemStack[] stored = new ItemStack[9];
            if (input.length != 9) {
                for (int e = 0; e < input.length; ++e) {
                    if (input[e] == null) continue;
                    stored[e] = input[e];
                }
            }
            if (copyTags) {
                for (int i = 0; i < stored.length; ++i) {
                    if (stored[i] == null || !stored[i].func_77942_o()) continue;
                    rStack.func_77982_d((NBTTagCompound)stored[i].func_77978_p().func_74737_b());
                    break;
                }
            }
            NBTTagCompound rNBT = rStack.func_77978_p();
            NBTTagCompound tNBT = new NBTTagCompound();
            if (rNBT == null) {
                rNBT = new NBTTagCompound();
            }
            for (int i = 0; i < 9; ++i) {
                ItemStack tStack = stored[i];
                if (tStack == null || GT_Utility.getContainerItem((ItemStack)tStack, (boolean)true) != null || tStack.func_77973_b() instanceof GT_MetaGenerated_Tool || !GT_Utility.isStackValid((Object)(tStack = GT_Utility.copyAmount((long)1L, (Object[])new Object[]{tStack})))) continue;
                GT_ModHandler.dischargeElectricItem((ItemStack)tStack, (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE, (boolean)true, (boolean)false, (boolean)true);
                tNBT.func_74782_a("Ingredient." + i, (NBTBase)tStack.func_77955_b(new NBTTagCompound()));
            }
            rNBT.func_74782_a("GT.CraftingComponents", (NBTBase)tNBT);
            rStack.func_77982_d(rNBT);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return rStack;
    }

    public static void setBoolean(ItemStack aStack, String aTag, boolean aBoolean) {
        NBTTagCompound tNBT = NBTUtils.getNBT(aStack);
        tNBT.func_74757_a(aTag, aBoolean);
        GT_Utility.ItemNBT.setNBT((ItemStack)aStack, (NBTTagCompound)tNBT);
    }

    public static boolean getBoolean(ItemStack aStack, String aTag) {
        NBTTagCompound tNBT = NBTUtils.getNBT(aStack);
        return tNBT.func_74767_n(aTag);
    }

    public static void setInteger(ItemStack aStack, String aTag, int aInt) {
        NBTTagCompound tNBT = NBTUtils.getNBT(aStack);
        tNBT.func_74768_a(aTag, aInt);
        GT_Utility.ItemNBT.setNBT((ItemStack)aStack, (NBTTagCompound)tNBT);
    }

    public static int getInteger(ItemStack aStack, String aTag) {
        NBTTagCompound tNBT = NBTUtils.getNBT(aStack);
        return tNBT.func_74762_e(aTag);
    }

    public static void setLong(ItemStack aStack, String aTag, long aInt) {
        NBTTagCompound tNBT = NBTUtils.getNBT(aStack);
        tNBT.func_74772_a(aTag, aInt);
        GT_Utility.ItemNBT.setNBT((ItemStack)aStack, (NBTTagCompound)tNBT);
    }

    public static long getLong(ItemStack aStack, String aTag) {
        NBTTagCompound tNBT = NBTUtils.getNBT(aStack);
        return tNBT.func_74763_f(aTag);
    }

    public static void setFloat(ItemStack aStack, String aTag, float aInt) {
        NBTTagCompound tNBT = NBTUtils.getNBT(aStack);
        tNBT.func_74776_a(aTag, aInt);
        GT_Utility.ItemNBT.setNBT((ItemStack)aStack, (NBTTagCompound)tNBT);
    }

    public static float getFloat(ItemStack aStack, String aTag) {
        NBTTagCompound tNBT = NBTUtils.getNBT(aStack);
        return tNBT.func_74760_g(aTag);
    }

    public static void setString(ItemStack aStack, String aTag, String aString) {
        NBTTagCompound tNBT = NBTUtils.getNBT(aStack);
        tNBT.func_74778_a(aTag, aString);
        GT_Utility.ItemNBT.setNBT((ItemStack)aStack, (NBTTagCompound)tNBT);
    }

    public static String getString(ItemStack aStack, String aTag) {
        NBTTagCompound tNBT = NBTUtils.getNBT(aStack);
        return tNBT.func_74779_i(aTag);
    }

    public static boolean doesStringExist(ItemStack aStack, String aTag) {
        NBTTagCompound tNBT = NBTUtils.getNBT(aStack);
        return tNBT.func_74764_b(aTag);
    }

    public static boolean tryIterateNBTData(ItemStack aStack) {
        try {
            NBTTagCompound aNBT = NBTUtils.getNBT(aStack);
            if (aNBT != null && !aNBT.func_82582_d()) {
                Map mInternalMap = (Map)ReflectionUtils.getField(aNBT, "tagMap");
                if (mInternalMap != null) {
                    for (Map.Entry e : mInternalMap.entrySet()) {
                        Logger.INFO("Key: " + e.getKey().toString() + " | Value: " + e.getValue());
                    }
                    return true;
                }
                Logger.INFO("Data map reflected from NBTTagCompound was not valid.");
                return false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static boolean setBotanicaSoulboundOwner(ItemStack aStack, String aName) {
        String TAG_SOULBIND = "soulbind";
        NBTTagCompound tNBT = NBTUtils.getNBT(aStack);
        tNBT.func_74778_a("soulbind", aName);
        GT_Utility.ItemNBT.setNBT((ItemStack)aStack, (NBTTagCompound)tNBT);
        return NBTUtils.doesStringExist(aStack, "soulbind");
    }

    public static String getBotanicaSoulboundOwner(ItemStack aStack) {
        String TAG_SOULBIND = "soulbind";
        NBTTagCompound tNBT = NBTUtils.getNBT(aStack);
        return tNBT.func_74779_i("soulbind");
    }

    public static boolean hasKey(ItemStack stack, String key) {
        NBTTagCompound itemData = NBTUtils.getNBT(stack);
        return itemData.func_74764_b(key);
    }

    public static boolean createIntegerTagCompound(ItemStack rStack, String tagName, String keyName, int keyValue) {
        NBTTagCompound tagMain = NBTUtils.getNBT(rStack);
        NBTTagCompound tagNBT = new NBTTagCompound();
        tagNBT.func_74768_a(keyName, keyValue);
        tagMain.func_74782_a(tagName, (NBTBase)tagNBT);
        rStack.func_77982_d(tagMain);
        return true;
    }

    public static boolean createLongTagCompound(ItemStack rStack, String tagName, String keyName, long keyValue) {
        NBTTagCompound tagMain = NBTUtils.getNBT(rStack);
        NBTTagCompound tagNBT = new NBTTagCompound();
        tagNBT.func_74772_a(keyName, keyValue);
        tagMain.func_74782_a(tagName, (NBTBase)tagNBT);
        rStack.func_77982_d(tagMain);
        return true;
    }

    public static boolean createStringTagCompound(ItemStack rStack, String tagName, String keyName, String keyValue) {
        NBTTagCompound tagMain = NBTUtils.getNBT(rStack);
        NBTTagCompound tagNBT = new NBTTagCompound();
        tagNBT.func_74778_a(keyName, keyValue);
        tagMain.func_74782_a(tagName, (NBTBase)tagNBT);
        rStack.func_77982_d(tagMain);
        return true;
    }

    public static boolean createFloatTagCompound(ItemStack rStack, String tagName, String keyName, float keyValue) {
        NBTTagCompound tagMain = NBTUtils.getNBT(rStack);
        NBTTagCompound tagNBT = new NBTTagCompound();
        tagNBT.func_74776_a(keyName, keyValue);
        tagMain.func_74782_a(tagName, (NBTBase)tagNBT);
        rStack.func_77982_d(tagMain);
        return true;
    }

    public static boolean createDoubleTagCompound(ItemStack rStack, String tagName, String keyName, double keyValue) {
        NBTTagCompound tagMain = NBTUtils.getNBT(rStack);
        NBTTagCompound tagNBT = new NBTTagCompound();
        tagNBT.func_74780_a(keyName, keyValue);
        tagMain.func_74782_a(tagName, (NBTBase)tagNBT);
        rStack.func_77982_d(tagMain);
        return true;
    }

    public static boolean createBooleanTagCompound(ItemStack rStack, String tagName, String keyName, boolean keyValue) {
        NBTTagCompound tagMain = NBTUtils.getNBT(rStack);
        NBTTagCompound tagNBT = new NBTTagCompound();
        tagNBT.func_74757_a(keyName, keyValue);
        tagMain.func_74782_a(tagName, (NBTBase)tagNBT);
        rStack.func_77982_d(tagMain);
        return true;
    }

    public static boolean createTagCompound(ItemStack rStack, String tagName, NBTTagCompound keyValue) {
        NBTTagCompound tagMain = NBTUtils.getNBT(rStack);
        NBTTagCompound tagNBT = keyValue;
        tagMain.func_74782_a(tagName, (NBTBase)tagNBT);
        rStack.func_77982_d(tagMain);
        return true;
    }

    public static int getIntegerTagCompound(ItemStack aStack, String tagName, String keyName) {
        NBTTagCompound aNBT = NBTUtils.getNBT(aStack);
        if (aNBT != null && (aNBT = aNBT.func_74775_l(tagName)) != null) {
            return aNBT.func_74762_e(keyName);
        }
        return 0;
    }

    public static long getLongTagCompound(ItemStack aStack, String tagName, String keyName) {
        NBTTagCompound aNBT = NBTUtils.getNBT(aStack);
        if (aNBT != null && (aNBT = aNBT.func_74775_l(tagName)) != null) {
            return aNBT.func_74763_f(keyName);
        }
        return 0L;
    }

    public static String getStringTagCompound(ItemStack aStack, String tagName, String keyName) {
        NBTTagCompound aNBT = NBTUtils.getNBT(aStack);
        if (aNBT != null && (aNBT = aNBT.func_74775_l(tagName)) != null) {
            return aNBT.func_74779_i(keyName);
        }
        return null;
    }

    public static float getFloatTagCompound(ItemStack aStack, String tagName, String keyName) {
        NBTTagCompound aNBT = NBTUtils.getNBT(aStack);
        if (aNBT != null && (aNBT = aNBT.func_74775_l(tagName)) != null) {
            return aNBT.func_74760_g(keyName);
        }
        return 0.0f;
    }

    public static double getDoubleTagCompound(ItemStack aStack, String tagName, String keyName) {
        NBTTagCompound aNBT = NBTUtils.getNBT(aStack);
        if (aNBT != null && (aNBT = aNBT.func_74775_l(tagName)) != null) {
            return aNBT.func_74769_h(keyName);
        }
        return 0.0;
    }

    public static boolean getBooleanTagCompound(ItemStack aStack, String tagName, String keyName) {
        NBTTagCompound aNBT = NBTUtils.getNBT(aStack);
        if (aNBT != null && (aNBT = aNBT.func_74775_l(tagName)) != null) {
            return aNBT.func_74767_n(keyName);
        }
        return false;
    }

    public static NBTTagCompound getTagCompound(ItemStack aStack, String tagName) {
        NBTTagCompound aNBT = NBTUtils.getNBT(aStack);
        if (aNBT != null && NBTUtils.hasKey(aStack, tagName) && (aNBT = aNBT.func_74775_l(tagName)) != null) {
            return aNBT;
        }
        return null;
    }

    public static boolean hasKeyInTagCompound(ItemStack stack, String tag, String key) {
        NBTTagCompound aNBT = stack.func_77978_p();
        return aNBT != null && (aNBT = aNBT.func_74775_l(tag)).func_74764_b(key);
    }

    public static Map getTagMap(NBTTagCompound aNBT) {
        Map mInternalMap;
        HashMap tagMap = new HashMap();
        if (!aNBT.func_82582_d() && (mInternalMap = (Map)ReflectionUtils.getField(aNBT, "tagMap")) != null && !mInternalMap.isEmpty()) {
            tagMap.putAll(mInternalMap);
        }
        return tagMap;
    }

    public static boolean isTagString(NBTTagCompound aNBT, String aTagName) {
        Map aTagMap = NBTUtils.getTagMap(aNBT);
        if (aTagMap != null && !aTagMap.isEmpty()) {
            for (Map.Entry e : aTagMap.entrySet()) {
                Object aValue;
                if (!e.getKey().equals(aTagName) || !((aValue = e.getValue()) instanceof String)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isTagInteger(NBTTagCompound aNBT, String aTagName) {
        Map aTagMap = NBTUtils.getTagMap(aNBT);
        if (aTagMap != null && !aTagMap.isEmpty()) {
            for (Map.Entry e : aTagMap.entrySet()) {
                Object aValue;
                if (!e.getKey().equals(aTagName) || !Integer.TYPE.isInstance(aValue = e.getValue()) && !(aValue instanceof Integer)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isTagLong(NBTTagCompound aNBT, String aTagName) {
        Map aTagMap = NBTUtils.getTagMap(aNBT);
        if (aTagMap != null && !aTagMap.isEmpty()) {
            for (Map.Entry e : aTagMap.entrySet()) {
                Object aValue;
                if (!e.getKey().equals(aTagName) || !Long.TYPE.isInstance(aValue = e.getValue()) && !(aValue instanceof Long)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isTagFloat(NBTTagCompound aNBT, String aTagName) {
        Map aTagMap = NBTUtils.getTagMap(aNBT);
        if (aTagMap != null && !aTagMap.isEmpty()) {
            for (Map.Entry e : aTagMap.entrySet()) {
                Object aValue;
                if (!e.getKey().equals(aTagName) || !Float.TYPE.isInstance(aValue = e.getValue()) && !(aValue instanceof Float)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isTagDouble(NBTTagCompound aNBT, String aTagName) {
        Map aTagMap = NBTUtils.getTagMap(aNBT);
        if (aTagMap != null && !aTagMap.isEmpty()) {
            for (Map.Entry e : aTagMap.entrySet()) {
                Object aValue;
                if (!e.getKey().equals(aTagName) || !Double.TYPE.isInstance(aValue = e.getValue()) && !(aValue instanceof Double)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isTagBoolean(NBTTagCompound aNBT, String aTagName) {
        Map aTagMap = NBTUtils.getTagMap(aNBT);
        if (aTagMap != null && !aTagMap.isEmpty()) {
            for (Map.Entry e : aTagMap.entrySet()) {
                Object aValue;
                if (!e.getKey().equals(aTagName) || !Boolean.TYPE.isInstance(aValue = e.getValue()) && !(aValue instanceof Boolean)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean tryCloneTagCompoundDataIntoSubTag(ItemStack aStack, NBTTagCompound aTagCompound) {
        try {
            Map mInternalMap;
            NBTTagCompound aNBT = aTagCompound;
            if (aNBT != null && !aNBT.func_82582_d() && (mInternalMap = (Map)ReflectionUtils.getField(aNBT, "tagMap")) != null) {
                for (Map.Entry e : mInternalMap.entrySet()) {
                    Logger.INFO("Key: " + e.getKey().toString() + " | Value: " + e.getValue().toString());
                    if (e.getValue().getClass() == String.class) {
                        NBTUtils.createStringTagCompound(aStack, "mEntityTag", (String)e.getKey(), (String)e.getValue());
                        continue;
                    }
                    if (e.getValue().getClass() == Boolean.class || e.getValue().getClass() == Boolean.TYPE) {
                        NBTUtils.createBooleanTagCompound(aStack, "mEntityTag", (String)e.getKey(), (Boolean)e.getValue());
                        continue;
                    }
                    if (e.getValue().getClass() == Integer.class || e.getValue().getClass() == Integer.TYPE) {
                        NBTUtils.createIntegerTagCompound(aStack, "mEntityTag", (String)e.getKey(), (Integer)e.getValue());
                        continue;
                    }
                    if (e.getValue().getClass() == Double.class || e.getValue().getClass() == Double.TYPE) {
                        NBTUtils.createDoubleTagCompound(aStack, "mEntityTag", (String)e.getKey(), (Double)e.getValue());
                        continue;
                    }
                    if (e.getValue().getClass() == Long.class || e.getValue().getClass() == Long.TYPE) {
                        NBTUtils.createLongTagCompound(aStack, "mEntityTag", (String)e.getKey(), (Long)e.getValue());
                        continue;
                    }
                    if (e.getValue().getClass() != Float.class && e.getValue().getClass() != Float.TYPE) continue;
                    NBTUtils.createFloatTagCompound(aStack, "mEntityTag", (String)e.getKey(), ((Float)e.getValue()).floatValue());
                }
                return true;
            }
            return false;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static NBTTagCompound getEntityCustomData(Entity aEntity) {
        return (NBTTagCompound)ReflectionUtils.getField(aEntity, "customEntityData");
    }

    public static boolean setEntityCustomData(Entity aEntity, NBTTagCompound aTag) {
        return ReflectionUtils.setField((Object)aEntity, "customEntityData", (Object)aTag);
    }

    public static boolean hasTagCompound(ItemStack aStack) {
        return aStack.func_77942_o();
    }

    public static void createEmptyTagCompound(ItemStack aStack) {
        if (!NBTUtils.hasTagCompound(aStack)) {
            NBTTagCompound aTag = new NBTTagCompound();
            aStack.func_77982_d(aTag);
        }
    }
}

