/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.plugin.agrichem;

import gtPlusPlus.plugin.agrichem.AlgaeUtils;

public enum AlgaeDefinition {
    Euglenophyta("Euglenophyta", "Euglenoids", true, false, AlgaeDefinition.getRGB(147, 168, 50)),
    Chrysophyta("Chrysophyta", "Golden-Brown Algae", true, true, AlgaeDefinition.getRGB(186, 146, 0)),
    Pyrrophyta("Pyrrophyta", "Fire Algae", true, true, AlgaeDefinition.getRGB(250, 118, 2)),
    Chlorophyta("Chlorophyta", "Green Algae", true, true, AlgaeDefinition.getRGB(99, 181, 62)),
    Rhodophyta("Rhodophyta", "Red Algae", false, true, AlgaeDefinition.getRGB(153, 5, 22)),
    Paeophyta("Paeophyta", "Brown Algae", false, true, AlgaeDefinition.getRGB(94, 78, 47)),
    Xanthophyta("Xanthophyta", "Yellow-Green Algae", true, false, AlgaeDefinition.getRGB(118, 138, 16));

    public final String mScientificName;
    public final String mSimpleName;
    public final boolean mSaltWater;
    public final boolean mFreshWater;
    public final int mColour;

    private AlgaeDefinition(String aScientificName, String aSimpleName, boolean aFresh, boolean aSalt, int aColour) {
        this.mScientificName = aScientificName;
        this.mSimpleName = aSimpleName;
        this.mFreshWater = aFresh;
        this.mSaltWater = aSalt;
        this.mColour = aColour;
    }

    public static AlgaeDefinition getByIndex(int aIndex) {
        switch (aIndex) {
            default: {
                return Euglenophyta;
            }
            case 1: {
                return Chrysophyta;
            }
            case 2: {
                return Pyrrophyta;
            }
            case 3: {
                return Chlorophyta;
            }
            case 4: {
                return Rhodophyta;
            }
            case 5: {
                return Paeophyta;
            }
            case 6: 
        }
        return Xanthophyta;
    }

    private static final int getRGB(int r, int g, int b) {
        return AlgaeUtils.rgbtoHexValue(r, g, b);
    }
}

