/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.plugin.fixes.vanilla.music;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gtPlusPlus.api.interfaces.IPlugin;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.random.XSTR;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import gtPlusPlus.preloader.CORE_Preloader;
import java.lang.reflect.Field;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.MusicTicker;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public class MusicTocker
extends MusicTicker
implements Runnable {
    private final Random mRandom = new XSTR();
    private final Minecraft mMinecraft;
    private final IPlugin mPlugin;
    private ISound mSound;
    private int mTimeUntilNextTrack = 100;
    public boolean mVanillaManager = false;

    public MusicTocker(IPlugin aPlugin) {
        super(Minecraft.func_71410_x());
        this.mPlugin = aPlugin;
        this.mMinecraft = Minecraft.func_71410_x();
        this.mPlugin.log("[BGM] Created BGM Watchdog with a delay of " + MusicTocker.getDelay() + " ticks.");
        this.inject();
    }

    private static int getDelay() {
        return CORE_Preloader.enableWatchdogBGM;
    }

    private boolean inject() {
        this.mPlugin.log("[BGM] Inject new Watchdog into Minecraft instance.");
        ReflectionUtils.setField((Object)Minecraft.func_71410_x(), "mcMusicTicker", (Object)this);
        this.mPlugin.log("[BGM] Verifying...");
        Field f = ReflectionUtils.getField(Minecraft.class, "mcMusicTicker");
        try {
            Object m = f.get(this.mMinecraft);
            if (m != null) {
                if (m instanceof MusicTocker || m.getClass().isAssignableFrom(this.getClass())) {
                    this.mPlugin.log("[BGM] Success.");
                    return true;
                }
                if (m instanceof MusicTicker || m.getClass().isAssignableFrom(MusicTicker.class)) {
                    this.mPlugin.log("[BGM] Found Vanilla MusicTicker, but may be instance of MusicTocker.");
                    return true;
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            // empty catch block
        }
        this.mPlugin.log("[BGM] Failed.");
        return false;
    }

    private final void updateInternalNumber() {
        if (ReflectionUtils.doesFieldExist(this.getClass(), "field_147676_d")) {
            ReflectionUtils.setField((Object)this, "field_147676_d", (Object)this.mTimeUntilNextTrack);
        }
    }

    private final void updateInternalSound(ISound aSound) {
        if (ReflectionUtils.doesFieldExist(this.getClass(), "field_147678_c")) {
            ReflectionUtils.setField((Object)this, "field_147678_c", (Object)aSound);
        }
    }

    public void func_73660_a() {
        this.run();
        this.mVanillaManager = true;
    }

    @Override
    public void run() {
        MusicTicker.MusicType musictype = this.mMinecraft.func_147109_W();
        if (this.mSound != null) {
            if (!musictype.func_148635_a().equals((Object)this.mSound.func_147650_b())) {
                this.mMinecraft.func_147118_V().func_147683_b(this.mSound);
                this.mTimeUntilNextTrack = MathHelper.func_76136_a((Random)this.mRandom, (int)0, (int)(MusicTocker.getDelay() / 2));
                this.updateInternalNumber();
                Logger.INFO("[BGM] Adjusted BGM delay 1");
            }
            if (!this.mMinecraft.func_147118_V().func_147692_c(this.mSound)) {
                this.mSound = null;
                this.updateInternalSound(null);
                this.mTimeUntilNextTrack = Math.min(MathHelper.func_76136_a((Random)this.mRandom, (int)MusicTocker.getDelay(), (int)(MusicTocker.getDelay() * 2)), this.mTimeUntilNextTrack);
                this.updateInternalNumber();
                Logger.INFO("[BGM] Adjusted BGM delay 2");
            }
        } else if (this.mSound == null && this.mTimeUntilNextTrack-- <= 0) {
            this.mSound = PositionedSoundRecord.func_147673_a((ResourceLocation)musictype.func_148635_a());
            this.updateInternalSound(this.mSound);
            this.mMinecraft.func_147118_V().func_147682_a(this.mSound);
            this.mTimeUntilNextTrack = MusicTocker.getDelay();
            this.updateInternalNumber();
            Logger.INFO("[BGM] Adjusted BGM 3");
        }
    }
}

