/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.preloader;

import gtPlusPlus.api.objects.data.Pair;
import gtPlusPlus.api.objects.data.weakref.WeakAutoMap;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import gtPlusPlus.preloader.Preloader_Logger;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.launchwrapper.Launch;

public class DevHelper {
    private static final DevHelper mInstance = new DevHelper();
    public static final boolean mIsValidHelper = DevHelperInternals.access$000();

    public static boolean isObfuscatedEnvironment() {
        boolean deobfuscatedEnvironment = false;
        try {
            byte[] bs = Launch.classLoader.getClassBytes("net.minecraft.world.World");
            deobfuscatedEnvironment = bs != null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return !deobfuscatedEnvironment;
    }

    public static Method getForgeMethod(Class c, String s, Class ... varags) {
        String s1 = s;
        String s2 = DevHelper.getSRG(s);
        try {
            Method a = ReflectionUtils.getMethod(c, s1, varags);
            if (a != null) {
                return a;
            }
            Method b = ReflectionUtils.getMethod(c, s2, varags);
            if (b != null) {
                return b;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static final synchronized DevHelper getInstance() {
        return mInstance;
    }

    public static final synchronized boolean isValidHelperObject() {
        return mIsValidHelper;
    }

    public static String getSRG(String mForgeName) {
        String aSRG = DevHelperInternals.forgeToSrg.get(mForgeName);
        return aSRG != null ? aSRG : "BAD_SRG_NAME";
    }

    public static String getForge(String mSrgName) {
        String aForgeName = DevHelperInternals.srgToForge.get(mSrgName);
        return aForgeName != null ? aForgeName : "BAD_FORGE_NAME";
    }

    public static String getMinecraftClassName(String adeObName, boolean obfuscated) {
        if (obfuscated) {
            return DevHelper.getObfuscated(adeObName);
        }
        return adeObName;
    }

    public static String getObfuscated(String mDeob) {
        String obfuscatedClassname = DevHelperInternals.deObToOb.get(mDeob);
        String string = obfuscatedClassname = obfuscatedClassname != null ? obfuscatedClassname : "BAD_OBFUSCATED_CLASS_NAME";
        if (obfuscatedClassname.equals("BAD_OBFUSCATED_CLASS_NAME")) {
            Preloader_Logger.INFO("[Fix] Failed to Get Deobfuscated name for " + mDeob);
        }
        return obfuscatedClassname;
    }

    public static String getDeobfuscated(String mOb) {
        String deobfuscatedClassname = DevHelperInternals.obToDeOb.get(mOb);
        return deobfuscatedClassname != null ? deobfuscatedClassname : "BAD_DEOBFUSCATED_CLASS_NAME";
    }

    public static class DevHelperInternals {
        public static final Map<String, String> srgToForge = new HashMap<String, String>();
        public static final Map<String, String> forgeToSrg = new HashMap<String, String>();
        private static WeakAutoMap<Pair<String, String>> mInitMap = new WeakAutoMap();
        public static final Map<String, String> obToDeOb = new HashMap<String, String>();
        public static final Map<String, String> deObToOb = new HashMap<String, String>();
        private static WeakAutoMap<Pair<String, String>> mObInitMap = new WeakAutoMap();

        /*
         * WARNING - void declaration
         */
        private static boolean init() {
            DevHelperInternals.init1();
            DevHelperInternals.init2();
            DevHelperInternals.init3();
            DevHelperInternals.init4();
            if (mInitMap.size() > 0) {
                for (Pair pair : mInitMap) {
                    if (pair == null) continue;
                    String srg = (String)pair.getKey();
                    String forge = (String)pair.getValue();
                    srgToForge.put(srg, forge);
                    forgeToSrg.put(forge, srg);
                }
            }
            if (mObInitMap.size() > 0) {
                for (Pair pair : mObInitMap) {
                    if (pair == null) continue;
                    String ob = (String)pair.getKey();
                    String deOb = (String)pair.getValue();
                    obToDeOb.put(ob, deOb);
                    deObToOb.put(deOb, ob);
                }
            }
            Preloader_Logger.INFO("[DevHelper] mInitMap size: " + mInitMap.size());
            Preloader_Logger.INFO("[DevHelper] mObInitMap size: " + mObInitMap.size());
            Preloader_Logger.INFO("[DevHelper] srgToForge size: " + srgToForge.size());
            Preloader_Logger.INFO("[DevHelper] forgeToSrg size: " + forgeToSrg.size());
            Preloader_Logger.INFO("[DevHelper] obToDeOb size: " + obToDeOb.size());
            Preloader_Logger.INFO("[DevHelper] deObToOb size: " + deObToOb.size());
            if (srgToForge.size() > 0 && forgeToSrg.size() > 0 && obToDeOb.size() > 0 && deObToOb.size() > 0) {
                if (srgToForge.size() == forgeToSrg.size() && obToDeOb.size() == deObToOb.size()) {
                    return true;
                }
                if (srgToForge.size() != forgeToSrg.size()) {
                    int aKey1 = 0;
                    boolean bl = false;
                    HashMap<Integer, String> aMissingForgeNames = new HashMap<Integer, String>();
                    HashMap<Integer, String> aMissingSrgNames = new HashMap<Integer, String>();
                    Preloader_Logger.INFO("Mismatch between mapped Forge and Srg names, finding missing values.");
                    if (srgToForge.size() > forgeToSrg.size()) {
                        Preloader_Logger.INFO("More SRG Keys detected.");
                        for (String aKey : srgToForge.keySet()) {
                            if (forgeToSrg.containsValue(aKey)) continue;
                            aMissingSrgNames.put(aKey1++, aKey);
                        }
                    } else if (srgToForge.size() < forgeToSrg.size()) {
                        Preloader_Logger.INFO("More Forge Keys detected.");
                        for (String aKey : forgeToSrg.keySet()) {
                            void var1_7;
                            if (srgToForge.containsValue(aKey)) continue;
                            aMissingForgeNames.put((int)(++var1_7), aKey);
                        }
                    }
                    if (!aMissingForgeNames.isEmpty()) {
                        for (String aKey : aMissingForgeNames.values()) {
                        }
                    }
                    if (!aMissingSrgNames.isEmpty()) {
                        for (String aKey : aMissingSrgNames.values()) {
                        }
                    }
                }
                if (obToDeOb.size() != deObToOb.size()) {
                    int aKey1 = 0;
                    boolean bl = false;
                    HashMap<Integer, String> aMissingObfNames = new HashMap<Integer, String>();
                    HashMap<Integer, String> aMissingDeObfNames = new HashMap<Integer, String>();
                    Preloader_Logger.INFO("Mismatch between mapped Obfuscated and Deobfuscated names, finding missing values.");
                    if (obToDeOb.size() > deObToOb.size()) {
                        Preloader_Logger.INFO("More Obfuscated Keys detected.");
                        for (String aKey : obToDeOb.keySet()) {
                            if (deObToOb.containsValue(aKey)) continue;
                            aMissingObfNames.put(aKey1++, aKey);
                        }
                    } else if (obToDeOb.size() < deObToOb.size()) {
                        Preloader_Logger.INFO("More Deobfuscated Keys detected.");
                        for (String aKey : deObToOb.keySet()) {
                            void var1_9;
                            if (obToDeOb.containsValue(aKey)) continue;
                            aMissingDeObfNames.put((int)(++var1_9), aKey);
                        }
                    }
                    if (!aMissingObfNames.isEmpty()) {
                        for (String missingVal : aMissingObfNames.values()) {
                            Preloader_Logger.WARNING("Missing Obfuscated value: " + missingVal);
                        }
                    }
                    if (!aMissingDeObfNames.isEmpty()) {
                        for (String missingVal : aMissingDeObfNames.values()) {
                            Preloader_Logger.WARNING("Missing Deobfuscated value: " + missingVal);
                        }
                    }
                }
            }
            return true;
        }

        private static void init1() {
            mInitMap.put(new Pair<String, String>("func_100011_g", "getIsPotionDurationMax"));
            mInitMap.put(new Pair<String, String>("func_100012_b", "setPotionDurationMax"));
            mInitMap.put(new Pair<String, String>("func_100015_a", "isKeyDown"));
            mInitMap.put(new Pair<String, String>("func_102007_a", "canInsertItem"));
            mInitMap.put(new Pair<String, String>("func_102008_b", "canExtractItem"));
            mInitMap.put(new Pair<String, String>("func_104002_bU", "isNoDespawnRequired"));
            mInitMap.put(new Pair<String, String>("func_104055_i", "setForceGamemode"));
            mInitMap.put(new Pair<String, String>("func_104056_am", "getForceGamemode"));
            mInitMap.put(new Pair<String, String>("func_104112_b", "saveExtraData"));
            mInitMap.put(new Pair<String, String>("func_104140_m", "saveChunkData"));
            mInitMap.put(new Pair<String, String>("func_110123_P", "onChunkLoad"));
            mInitMap.put(new Pair<String, String>("func_110124_au", "getUniqueID"));
            mInitMap.put(new Pair<String, String>("func_110125_a", "setParticleIcon"));
            mInitMap.put(new Pair<String, String>("func_110128_b", "onBroken"));
            mInitMap.put(new Pair<String, String>("func_110130_b", "getKnotForBlock"));
            mInitMap.put(new Pair<String, String>("func_110131_b", "removeFrameFromMap"));
            mInitMap.put(new Pair<String, String>("func_110138_aP", "getMaxHealth"));
            mInitMap.put(new Pair<String, String>("func_110139_bj", "getAbsorptionAmount"));
            mInitMap.put(new Pair<String, String>("func_110140_aT", "getAttributeMap"));
            mInitMap.put(new Pair<String, String>("func_110142_aN", "getCombatTracker"));
            mInitMap.put(new Pair<String, String>("func_110143_aJ", "getHealth"));
            mInitMap.put(new Pair<String, String>("func_110144_aD", "getLastAttacker"));
            mInitMap.put(new Pair<String, String>("func_110145_l", "dismountEntity"));
            mInitMap.put(new Pair<String, String>("func_110147_ax", "applyEntityAttributes"));
            mInitMap.put(new Pair<String, String>("func_110148_a", "getEntityAttribute"));
            mInitMap.put(new Pair<String, String>("func_110149_m", "setAbsorptionAmount"));
            mInitMap.put(new Pair<String, String>("func_110159_bB", "updateLeashedState"));
            mInitMap.put(new Pair<String, String>("func_110160_i", "clearLeashed"));
            mInitMap.put(new Pair<String, String>("func_110161_a", "onSpawnWithEgg"));
            mInitMap.put(new Pair<String, String>("func_110162_b", "setLeashedToEntity"));
            mInitMap.put(new Pair<String, String>("func_110163_bv", "enablePersistence"));
            mInitMap.put(new Pair<String, String>("func_110164_bC", "allowLeashing"));
            mInitMap.put(new Pair<String, String>("func_110165_bF", "recreateLeash"));
            mInitMap.put(new Pair<String, String>("func_110166_bE", "getLeashedToEntity"));
            mInitMap.put(new Pair<String, String>("func_110167_bD", "getLeashed"));
            mInitMap.put(new Pair<String, String>("func_110171_b", "setHomeArea"));
            mInitMap.put(new Pair<String, String>("func_110172_bL", "getHomePosition"));
            mInitMap.put(new Pair<String, String>("func_110173_bK", "isWithinHomeDistanceCurrentPosition"));
            mInitMap.put(new Pair<String, String>("func_110174_bM", "getMaximumHomeDistance"));
            mInitMap.put(new Pair<String, String>("func_110175_bO", "hasHome"));
            mInitMap.put(new Pair<String, String>("func_110176_b", "isWithinHomeDistance"));
            mInitMap.put(new Pair<String, String>("func_110177_bN", "detachHome"));
            mInitMap.put(new Pair<String, String>("func_110195_a", "addGrowth"));
            mInitMap.put(new Pair<String, String>("func_110198_t", "increaseTemper"));
            mInitMap.put(new Pair<String, String>("func_110199_f", "openGUI"));
            mInitMap.put(new Pair<String, String>("func_110200_cJ", "canMate"));
            mInitMap.put(new Pair<String, String>("func_110202_bQ", "getHorseVariant"));
            mInitMap.put(new Pair<String, String>("func_110204_cc", "isEatingHaystack"));
            mInitMap.put(new Pair<String, String>("func_110206_u", "setJumpPower"));
            mInitMap.put(new Pair<String, String>("func_110207_m", "setChested"));
            mInitMap.put(new Pair<String, String>("func_110208_b", "setHorseWatchableBoolean"));
            mInitMap.put(new Pair<String, String>("func_110209_cd", "isRearing"));
            mInitMap.put(new Pair<String, String>("func_110212_cp", "getVariantTexturePaths"));
            mInitMap.put(new Pair<String, String>("func_110214_p", "setHorseType"));
            mInitMap.put(new Pair<String, String>("func_110215_cj", "getHorseJumpStrength"));
            mInitMap.put(new Pair<String, String>("func_110216_r", "spawnHorseParticles"));
            mInitMap.put(new Pair<String, String>("func_110217_cl", "getAngrySoundName"));
            mInitMap.put(new Pair<String, String>("func_110218_cm", "getMaxTemper"));
            mInitMap.put(new Pair<String, String>("func_110219_q", "setRearing"));
            mInitMap.put(new Pair<String, String>("func_110220_cK", "makeHorseRear"));
            mInitMap.put(new Pair<String, String>("func_110221_n", "setHasReproduced"));
            mInitMap.put(new Pair<String, String>("func_110222_cv", "isSterile"));
            mInitMap.put(new Pair<String, String>("func_110223_p", "getRearingAmount"));
            mInitMap.put(new Pair<String, String>("func_110224_ci", "dropChests"));
            mInitMap.put(new Pair<String, String>("func_110227_p", "setEatingHaystack"));
            mInitMap.put(new Pair<String, String>("func_110228_bR", "isAdultHorse"));
            mInitMap.put(new Pair<String, String>("func_110229_cs", "canCarryChest"));
            mInitMap.put(new Pair<String, String>("func_110231_cz", "makeHorseRearWithSound"));
            mInitMap.put(new Pair<String, String>("func_110233_w", "getHorseWatchableBoolean"));
            mInitMap.put(new Pair<String, String>("func_110234_j", "setHorseTamed"));
            mInitMap.put(new Pair<String, String>("func_110235_q", "setHorseVariant"));
            mInitMap.put(new Pair<String, String>("func_110238_s", "setTemper"));
            mInitMap.put(new Pair<String, String>("func_110240_a", "dropItemsInChest"));
            mInitMap.put(new Pair<String, String>("func_110243_cf", "getHasReproduced"));
            mInitMap.put(new Pair<String, String>("func_110244_cA", "dropChestItems"));
            mInitMap.put(new Pair<String, String>("func_110246_bZ", "isHorseJumping"));
            mInitMap.put(new Pair<String, String>("func_110247_cG", "setHorseTexturePaths"));
            mInitMap.put(new Pair<String, String>("func_110248_bS", "isTame"));
            mInitMap.put(new Pair<String, String>("func_110249_cI", "openHorseMouth"));
            mInitMap.put(new Pair<String, String>("func_110250_a", "getClosestHorse"));
            mInitMap.put(new Pair<String, String>("func_110251_o", "setHorseSaddled"));
            mInitMap.put(new Pair<String, String>("func_110252_cg", "getTemper"));
            mInitMap.put(new Pair<String, String>("func_110254_bY", "getHorseSize"));
            mInitMap.put(new Pair<String, String>("func_110255_k", "setHorseJumping"));
            mInitMap.put(new Pair<String, String>("func_110256_cu", "isUndead"));
            mInitMap.put(new Pair<String, String>("func_110257_ck", "isHorseSaddled"));
            mInitMap.put(new Pair<String, String>("func_110258_o", "getGrassEatingAmount"));
            mInitMap.put(new Pair<String, String>("func_110259_cr", "canWearArmor"));
            mInitMap.put(new Pair<String, String>("func_110260_d", "getHorseArmorIndex"));
            mInitMap.put(new Pair<String, String>("func_110261_ca", "isChested"));
            mInitMap.put(new Pair<String, String>("func_110262_ch", "prepareChunkForSpawn"));
            mInitMap.put(new Pair<String, String>("func_110263_g", "setTamedBy"));
            mInitMap.put(new Pair<String, String>("func_110264_co", "getHorseTexture"));
            mInitMap.put(new Pair<String, String>("func_110265_bP", "getHorseType"));
            mInitMap.put(new Pair<String, String>("func_110297_a_", "verifySellingItem"));
            mInitMap.put(new Pair<String, String>("func_110298_a", "displayGUIHorse"));
            mInitMap.put(new Pair<String, String>("func_110303_q", "getLocationCape"));
            mInitMap.put(new Pair<String, String>("func_110304_a", "getDownloadImageSkin"));
            mInitMap.put(new Pair<String, String>("func_110306_p", "getLocationSkin"));
            mInitMap.put(new Pair<String, String>("func_110311_f", "getLocationSkin"));
            mInitMap.put(new Pair<String, String>("func_110317_t", "isRidingHorse"));
            mInitMap.put(new Pair<String, String>("func_110318_g", "sendHorseJump"));
            mInitMap.put(new Pair<String, String>("func_110319_bJ", "getHorseJumpPower"));
            mInitMap.put(new Pair<String, String>("func_110322_i", "sendHorseInteraction"));
            mInitMap.put(new Pair<String, String>("func_110326_a", "setRecordPlaying"));
            mInitMap.put(new Pair<String, String>("func_110327_a", "renderIcons"));
            mInitMap.put(new Pair<String, String>("func_110430_a", "setEntityActionState"));
            mInitMap.put(new Pair<String, String>("func_110432_I", "getSession"));
            mInitMap.put(new Pair<String, String>("func_110434_K", "getTextureManager"));
            mInitMap.put(new Pair<String, String>("func_110435_P", "addDefaultResourcePack"));
            mInitMap.put(new Pair<String, String>("func_110436_a", "refreshResources"));
            mInitMap.put(new Pair<String, String>("func_110437_J", "getProxy"));
            mInitMap.put(new Pair<String, String>("func_110438_M", "getResourcePackRepository"));
            mInitMap.put(new Pair<String, String>("func_110441_Q", "updateDisplayMode"));
            mInitMap.put(new Pair<String, String>("func_110442_L", "getResourceManager"));
            mInitMap.put(new Pair<String, String>("func_110454_ao", "getServerProxy"));
            mInitMap.put(new Pair<String, String>("func_110455_j", "getOpPermissionLevel"));
            mInitMap.put(new Pair<String, String>("func_110462_b", "getPackFormat"));
            mInitMap.put(new Pair<String, String>("func_110468_c", "getFrameIndex"));
            mInitMap.put(new Pair<String, String>("func_110469_d", "getFrameTime"));
            mInitMap.put(new Pair<String, String>("func_110470_b", "frameHasTime"));
            mInitMap.put(new Pair<String, String>("func_110471_a", "getFrameHeight"));
            mInitMap.put(new Pair<String, String>("func_110472_a", "getFrameTimeSingle"));
            mInitMap.put(new Pair<String, String>("func_110473_c", "getFrameCount"));
            mInitMap.put(new Pair<String, String>("func_110474_b", "getFrameWidth"));
            mInitMap.put(new Pair<String, String>("func_110479_a", "getTextureBlur"));
            mInitMap.put(new Pair<String, String>("func_110480_b", "getTextureClamp"));
            mInitMap.put(new Pair<String, String>("func_110483_a", "getSectionName"));
            mInitMap.put(new Pair<String, String>("func_110492_a", "parseAnimationFrame"));
            mInitMap.put(new Pair<String, String>("func_110495_a", "hasNoTime"));
            mInitMap.put(new Pair<String, String>("func_110496_c", "getFrameIndex"));
            mInitMap.put(new Pair<String, String>("func_110497_b", "getFrameTime"));
            mInitMap.put(new Pair<String, String>("func_110503_a", "parseMetadataSection"));
            mInitMap.put(new Pair<String, String>("func_110504_a", "registerMetadataSectionType"));
            mInitMap.put(new Pair<String, String>("func_110505_a", "getGson"));
            mInitMap.put(new Pair<String, String>("func_110514_c", "getResourcePack"));
            mInitMap.put(new Pair<String, String>("func_110515_d", "getResourcePackName"));
            mInitMap.put(new Pair<String, String>("func_110516_a", "updateResourcePack"));
            mInitMap.put(new Pair<String, String>("func_110517_b", "closeResourcePack"));
            mInitMap.put(new Pair<String, String>("func_110518_a", "bindTexturePackIcon"));
            mInitMap.put(new Pair<String, String>("func_110519_e", "getTexturePackDescription"));
            mInitMap.put(new Pair<String, String>("func_110526_a", "getMetadata"));
            mInitMap.put(new Pair<String, String>("func_110527_b", "getInputStream"));
            mInitMap.put(new Pair<String, String>("func_110528_c", "hasMetadata"));
            mInitMap.put(new Pair<String, String>("func_110536_a", "getResource"));
            mInitMap.put(new Pair<String, String>("func_110537_b", "getLocationMcmeta"));
            mInitMap.put(new Pair<String, String>("func_110538_a", "addResourcePack"));
            mInitMap.put(new Pair<String, String>("func_110541_a", "reloadResources"));
            mInitMap.put(new Pair<String, String>("func_110542_a", "registerReloadListener"));
            mInitMap.put(new Pair<String, String>("func_110543_a", "clearResources"));
            mInitMap.put(new Pair<String, String>("func_110544_b", "notifyReloadListeners"));
            mInitMap.put(new Pair<String, String>("func_110545_a", "reloadResourcePack"));
            mInitMap.put(new Pair<String, String>("func_110549_a", "onResourceManagerReload"));
            mInitMap.put(new Pair<String, String>("func_110550_d", "tick"));
            mInitMap.put(new Pair<String, String>("func_110551_a", "loadTexture"));
            mInitMap.put(new Pair<String, String>("func_110552_b", "getGlTextureId"));
            mInitMap.put(new Pair<String, String>("func_110564_a", "updateDynamicTexture"));
            mInitMap.put(new Pair<String, String>("func_110565_c", "getTextureData"));
            mInitMap.put(new Pair<String, String>("func_110569_e", "initMissingImage"));
            mInitMap.put(new Pair<String, String>("func_110571_b", "loadTextureAtlas"));
            mInitMap.put(new Pair<String, String>("func_110572_b", "getAtlasSprite"));
            mInitMap.put(new Pair<String, String>("func_110573_f", "registerIcons"));
            mInitMap.put(new Pair<String, String>("func_110577_a", "bindTexture"));
            mInitMap.put(new Pair<String, String>("func_110578_a", "getDynamicTextureLocation"));
            mInitMap.put(new Pair<String, String>("func_110579_a", "loadTexture"));
            mInitMap.put(new Pair<String, String>("func_110580_a", "loadTickableTexture"));
            mInitMap.put(new Pair<String, String>("func_110581_b", "getTexture"));
            mInitMap.put(new Pair<String, String>("func_110586_a", "getPackImage"));
            mInitMap.put(new Pair<String, String>("func_110587_b", "getResourceDomains"));
            mInitMap.put(new Pair<String, String>("func_110589_b", "resourceExists"));
            mInitMap.put(new Pair<String, String>("func_110590_a", "getInputStream"));
            mInitMap.put(new Pair<String, String>("func_110591_a", "getInputStreamByName"));
            mInitMap.put(new Pair<String, String>("func_110592_c", "locationToName"));
            mInitMap.put(new Pair<String, String>("func_110593_b", "hasResourceName"));
            mInitMap.put(new Pair<String, String>("func_110594_c", "logNameNotLowercase"));
            mInitMap.put(new Pair<String, String>("func_110595_a", "getRelativeName"));
            mInitMap.put(new Pair<String, String>("func_110596_a", "readMetadata"));
            mInitMap.put(new Pair<String, String>("func_110599_c", "getResourcePackZipFile"));
            mInitMap.put(new Pair<String, String>("func_110605_c", "getResourceStream"));
            mInitMap.put(new Pair<String, String>("func_110609_b", "getRepositoryEntriesAll"));
            mInitMap.put(new Pair<String, String>("func_110611_a", "updateRepositoryEntriesAll"));
            mInitMap.put(new Pair<String, String>("func_110612_e", "getDirResourcepacks"));
            mInitMap.put(new Pair<String, String>("func_110613_c", "getRepositoryEntries"));
            mInitMap.put(new Pair<String, String>("func_110614_g", "getResourcePackFiles"));
            mInitMap.put(new Pair<String, String>("func_110616_f", "fixDirResourcepacks"));
            mInitMap.put(new Pair<String, String>("func_110623_a", "getResourcePath"));
            mInitMap.put(new Pair<String, String>("func_110624_b", "getResourceDomain"));
            mInitMap.put(new Pair<String, String>("func_110646_a", "getTextWithoutFormattingCodes"));
            mInitMap.put(new Pair<String, String>("func_110647_a", "getOSType"));
            mInitMap.put(new Pair<String, String>("func_110661_a", "parseDouble"));
            mInitMap.put(new Pair<String, String>("func_110662_c", "parseBoolean"));
            mInitMap.put(new Pair<String, String>("func_110664_a", "parseDouble"));
            mInitMap.put(new Pair<String, String>("func_110665_a", "clamp_double"));
            mInitMap.put(new Pair<String, String>("func_110666_a", "clamp_coord"));
            mInitMap.put(new Pair<String, String>("func_110682_a", "setBoxRotation"));
            mInitMap.put(new Pair<String, String>("func_110683_a", "updateHorseRotation"));
            mInitMap.put(new Pair<String, String>("func_110738_j", "isRidingHorse"));
            mInitMap.put(new Pair<String, String>("func_110775_a", "getEntityTexture"));
            mInitMap.put(new Pair<String, String>("func_110776_a", "bindTexture"));
            mInitMap.put(new Pair<String, String>("func_110777_b", "bindEntityTexture"));
            mInitMap.put(new Pair<String, String>("func_110813_b", "canRenderName"));
            mInitMap.put(new Pair<String, String>("func_110934_a", "addSprite"));
            mInitMap.put(new Pair<String, String>("func_110935_a", "getCurrentWidth"));
            mInitMap.put(new Pair<String, String>("func_110936_b", "getCurrentHeight"));
            mInitMap.put(new Pair<String, String>("func_110966_b", "setIconWidth"));
            mInitMap.put(new Pair<String, String>("func_110967_i", "getOriginY"));
            mInitMap.put(new Pair<String, String>("func_110968_a", "setFramesTextureData"));
            mInitMap.put(new Pair<String, String>("func_110969_c", "setIconHeight"));
            mInitMap.put(new Pair<String, String>("func_110970_k", "getFrameCount"));
            mInitMap.put(new Pair<String, String>("func_110971_a", "initSprite"));
            mInitMap.put(new Pair<String, String>("func_110985_a", "updateAnaglyph"));
            mInitMap.put(new Pair<String, String>("func_110986_a", "readImageData"));
            mInitMap.put(new Pair<String, String>("func_110987_a", "uploadTextureImage"));
            mInitMap.put(new Pair<String, String>("func_110988_a", "uploadTexture"));
            mInitMap.put(new Pair<String, String>("func_110989_a", "uploadTextureImageAllocate"));
            mInitMap.put(new Pair<String, String>("func_110990_a", "copyToBuffer"));
            mInitMap.put(new Pair<String, String>("func_110991_a", "allocateTexture"));
            mInitMap.put(new Pair<String, String>("func_110993_a", "uploadTextureImageSubImpl"));
            mInitMap.put(new Pair<String, String>("func_110994_a", "copyToBufferPos"));
            mInitMap.put(new Pair<String, String>("func_110995_a", "uploadTextureImageSub"));
            mInitMap.put(new Pair<String, String>("func_110996_a", "glGenTextures"));
            mInitMap.put(new Pair<String, String>("func_110997_a", "setTextureClamped"));
            mInitMap.put(new Pair<String, String>("func_111108_a", "getAttributeUnlocalizedName"));
            mInitMap.put(new Pair<String, String>("func_111109_a", "clampValue"));
            mInitMap.put(new Pair<String, String>("func_111110_b", "getDefaultValue"));
            mInitMap.put(new Pair<String, String>("func_111111_c", "getShouldWatch"));
            mInitMap.put(new Pair<String, String>("func_111112_a", "setShouldWatch"));
            mInitMap.put(new Pair<String, String>("func_111116_f", "getDescription"));
            mInitMap.put(new Pair<String, String>("func_111117_a", "setDescription"));
            mInitMap.put(new Pair<String, String>("func_111121_a", "applyModifier"));
            mInitMap.put(new Pair<String, String>("func_111123_a", "getAttribute"));
            mInitMap.put(new Pair<String, String>("func_111124_b", "removeModifier"));
            mInitMap.put(new Pair<String, String>("func_111125_b", "getBaseValue"));
            mInitMap.put(new Pair<String, String>("func_111126_e", "getAttributeValue"));
            mInitMap.put(new Pair<String, String>("func_111127_a", "getModifier"));
            mInitMap.put(new Pair<String, String>("func_111128_a", "setBaseValue"));
            mInitMap.put(new Pair<String, String>("func_111129_g", "computeValue"));
            mInitMap.put(new Pair<String, String>("func_111130_a", "getModifiersByOperation"));
            mInitMap.put(new Pair<String, String>("func_111131_f", "flagForUpdate"));
            mInitMap.put(new Pair<String, String>("func_111145_d", "getWatchableObjectFloat"));
            mInitMap.put(new Pair<String, String>("func_111146_a", "getAllAttributes"));
            mInitMap.put(new Pair<String, String>("func_111147_b", "applyAttributeModifiers"));
            mInitMap.put(new Pair<String, String>("func_111148_a", "removeAttributeModifiers"));
            mInitMap.put(new Pair<String, String>("func_111149_a", "addAttributeInstance"));
            mInitMap.put(new Pair<String, String>("func_111150_b", "registerAttribute"));
            mInitMap.put(new Pair<String, String>("func_111151_a", "getAttributeInstance"));
            mInitMap.put(new Pair<String, String>("func_111152_a", "getAttributeInstanceByName"));
            mInitMap.put(new Pair<String, String>("func_111160_c", "getWatchedAttributes"));
            mInitMap.put(new Pair<String, String>("func_111161_b", "getAttributeInstanceSet"));
            mInitMap.put(new Pair<String, String>("func_111164_d", "getAmount"));
            mInitMap.put(new Pair<String, String>("func_111165_e", "isSaved"));
            mInitMap.put(new Pair<String, String>("func_111166_b", "getName"));
            mInitMap.put(new Pair<String, String>("func_111167_a", "getID"));
            mInitMap.put(new Pair<String, String>("func_111168_a", "setSaved"));
            mInitMap.put(new Pair<String, String>("func_111169_c", "getOperation"));
            mInitMap.put(new Pair<String, String>("func_111175_f", "getTargetDistance"));
            mInitMap.put(new Pair<String, String>("func_111184_a", "registerPotionAttributeModifier"));
            mInitMap.put(new Pair<String, String>("func_111185_a", "applyAttributesModifiersToEntity"));
            mInitMap.put(new Pair<String, String>("func_111187_a", "removeAttributesModifiersFromEntity"));
            mInitMap.put(new Pair<String, String>("func_111190_b", "sendMetadataToAllAssociatedPlayers"));
            mInitMap.put(new Pair<String, String>("func_111194_a", "processChunk"));
            mInitMap.put(new Pair<String, String>("func_111196_a", "increaseInhabitedTime"));
            mInitMap.put(new Pair<String, String>("func_111205_h", "getItemAttributeModifiers"));
            mInitMap.put(new Pair<String, String>("func_111206_d", "setTextureName"));
            mInitMap.put(new Pair<String, String>("func_111207_a", "itemInteractionForEntity"));
            mInitMap.put(new Pair<String, String>("func_111208_A", "getIconString"));
            mInitMap.put(new Pair<String, String>("func_111225_m", "getRelevantEnchantmentTypes"));
            mInitMap.put(new Pair<String, String>("func_111229_a", "setRelevantEnchantmentTypes"));
            mInitMap.put(new Pair<String, String>("func_111238_b", "canBeHovered"));
            mInitMap.put(new Pair<String, String>("func_111257_a", "writeBaseAttributeMapToNBT"));
            mInitMap.put(new Pair<String, String>("func_111258_a", "applyModifiersToAttributeInstance"));
            mInitMap.put(new Pair<String, String>("func_111259_a", "readAttributeModifierFromNBT"));
            mInitMap.put(new Pair<String, String>("func_111261_a", "writeAttributeInstanceToNBT"));
            mInitMap.put(new Pair<String, String>("func_111262_a", "writeAttributeModifierToNBT"));
            mInitMap.put(new Pair<String, String>("func_111269_d", "getPathSearchRange"));
            mInitMap.put(new Pair<String, String>("func_111270_a", "union"));
            mInitMap.put(new Pair<String, String>("func_111271_a", "getUnicodePageLocation"));
            mInitMap.put(new Pair<String, String>("func_111272_d", "readFontTexture"));
            mInitMap.put(new Pair<String, String>("func_111282_a", "interactWithEntity"));
            mInitMap.put(new Pair<String, String>("func_111283_C", "getAttributeModifiers"));
            mInitMap.put(new Pair<String, String>("func_111285_a", "getUsername"));
            mInitMap.put(new Pair<String, String>("func_111286_b", "getSessionID"));
            mInitMap.put(new Pair<String, String>("func_120011_ar", "setGuiEnabled"));
            mInitMap.put(new Pair<String, String>("func_120016_a", "createServerGui"));
            mInitMap.put(new Pair<String, String>("func_120018_d", "getLogComponent"));
            mInitMap.put(new Pair<String, String>("func_120019_b", "getStatsComponent"));
            mInitMap.put(new Pair<String, String>("func_120020_c", "getPlayerListComponent"));
            mInitMap.put(new Pair<String, String>("func_130001_d", "getCurrentMoonPhaseFactor"));
            mInitMap.put(new Pair<String, String>("func_130002_c", "interactFirst"));
            mInitMap.put(new Pair<String, String>("func_130010_a", "getOriginX"));
            mInitMap.put(new Pair<String, String>("func_130011_c", "setLastAttacker"));
            mInitMap.put(new Pair<String, String>("func_130014_f_", "getEntityWorld"));
            mInitMap.put(new Pair<String, String>("func_130071_aq", "getCurrentTimeMillis"));
            mInitMap.put(new Pair<String, String>("func_130072_d", "getAnimationFrame"));
            mInitMap.put(new Pair<String, String>("func_130073_e", "getFrameIndexSet"));
            mInitMap.put(new Pair<String, String>("func_130077_b", "getPackName"));
            mInitMap.put(new Pair<String, String>("func_130086_a", "getTextureType"));
            mInitMap.put(new Pair<String, String>("func_130087_a", "getResourceLocation"));
            mInitMap.put(new Pair<String, String>("func_130088_a", "loadTextureMap"));
            mInitMap.put(new Pair<String, String>("func_130098_m", "hasAnimationMetadata"));
            mInitMap.put(new Pair<String, String>("func_130099_d", "allocateFrameTextureData"));
            mInitMap.put(new Pair<String, String>("func_130102_n", "resetSprite"));
            mInitMap.put(new Pair<String, String>("func_130103_l", "clearFramesTextureData"));
            mInitMap.put(new Pair<String, String>("func_130105_g", "getMinecraftStartTimeMillis"));
            mInitMap.put(new Pair<String, String>("func_135016_M", "getLanguageManager"));
            mInitMap.put(new Pair<String, String>("func_135018_a", "getLanguages"));
            mInitMap.put(new Pair<String, String>("func_135021_a", "loadLocaleData"));
            mInitMap.put(new Pair<String, String>("func_135022_a", "loadLocaleDataFiles"));
            mInitMap.put(new Pair<String, String>("func_135023_a", "formatMessage"));
            mInitMap.put(new Pair<String, String>("func_135024_b", "checkUnicode"));
            mInitMap.put(new Pair<String, String>("func_135025_a", "isUnicode"));
            mInitMap.put(new Pair<String, String>("func_135026_c", "translateKeyPrivate"));
            mInitMap.put(new Pair<String, String>("func_135028_a", "loadLocaleData"));
            mInitMap.put(new Pair<String, String>("func_135034_a", "getLanguageCode"));
            mInitMap.put(new Pair<String, String>("func_135035_b", "isBidirectional"));
            mInitMap.put(new Pair<String, String>("func_135040_d", "getLanguages"));
            mInitMap.put(new Pair<String, String>("func_135041_c", "getCurrentLanguage"));
            mInitMap.put(new Pair<String, String>("func_135042_a", "isCurrentLocaleUnicode"));
            mInitMap.put(new Pair<String, String>("func_135043_a", "parseLanguageMetadata"));
            mInitMap.put(new Pair<String, String>("func_135044_b", "isCurrentLanguageBidirectional"));
            mInitMap.put(new Pair<String, String>("func_135045_a", "setCurrentLanguage"));
            mInitMap.put(new Pair<String, String>("func_135051_a", "setLocale"));
            mInitMap.put(new Pair<String, String>("func_135052_a", "format"));
            mInitMap.put(new Pair<String, String>("func_135055_a", "getResourceDomains"));
            mInitMap.put(new Pair<String, String>("func_135056_b", "getAllResources"));
            mInitMap.put(new Pair<String, String>("func_135058_a", "getPackMetadata"));
            mInitMap.put(new Pair<String, String>("func_135063_a", "replaceWith"));
            mInitMap.put(new Pair<String, String>("func_135064_c", "tryTranslateKey"));
            mInitMap.put(new Pair<String, String>("func_140005_i", "switchToRealms"));
            mInitMap.put(new Pair<String, String>("func_142008_O", "shouldSetPosAfterLoading"));
            mInitMap.put(new Pair<String, String>("func_142012_a", "isOnTeam"));
            mInitMap.put(new Pair<String, String>("func_142013_aG", "getLastAttackerTime"));
            mInitMap.put(new Pair<String, String>("func_142014_c", "isOnSameTeam"));
            mInitMap.put(new Pair<String, String>("func_142015_aE", "getRevengeTimer"));
            mInitMap.put(new Pair<String, String>("func_142020_c", "setClientBrand"));
            mInitMap.put(new Pair<String, String>("func_142021_k", "getClientBrand"));
            mInitMap.put(new Pair<String, String>("func_142049_d", "removeAllModifiers"));
            mInitMap.put(new Pair<String, String>("func_142053_d", "formatString"));
            mInitMap.put(new Pair<String, String>("func_142054_a", "isSameTeam"));
            mInitMap.put(new Pair<String, String>("func_143004_u", "markPlayerActive"));
            mInitMap.put(new Pair<String, String>("func_143006_e", "setPlayerIdleTimeout"));
            mInitMap.put(new Pair<String, String>("func_143007_ar", "getMaxPlayerIdleMinutes"));
            mInitMap.put(new Pair<String, String>("func_143011_b", "readStructureFromNBT"));
            mInitMap.put(new Pair<String, String>("func_143012_a", "writeStructureToNBT"));
            mInitMap.put(new Pair<String, String>("func_143016_a", "registerVillagePieces"));
            mInitMap.put(new Pair<String, String>("func_143025_a", "getStructureName"));
            mInitMap.put(new Pair<String, String>("func_143031_a", "registerStructureComponent"));
            mInitMap.put(new Pair<String, String>("func_143034_b", "registerStructure"));
            mInitMap.put(new Pair<String, String>("func_143045_a", "registerScatteredFeaturePieces"));
            mInitMap.put(new Pair<String, String>("func_143046_a", "registerStrongholdPieces"));
            mInitMap.put(new Pair<String, String>("func_143048_a", "registerStructurePieces"));
            mInitMap.put(new Pair<String, String>("func_143049_a", "registerNetherFortressPieces"));
            mInitMap.put(new Pair<String, String>("func_145747_a", "addChatMessage"));
            mInitMap.put(new Pair<String, String>("func_145748_c_", "getFormattedCommandSenderName"));
            mInitMap.put(new Pair<String, String>("func_145749_h", "getLastOutput"));
            mInitMap.put(new Pair<String, String>("func_145752_a", "setCommand"));
            mInitMap.put(new Pair<String, String>("func_145753_i", "getCustomName"));
            mInitMap.put(new Pair<String, String>("func_145758_a", "writeDataToNBT"));
            mInitMap.put(new Pair<String, String>("func_145759_b", "readDataFromNBT"));
            mInitMap.put(new Pair<String, String>("func_145760_g", "getSuccessCount"));
            mInitMap.put(new Pair<String, String>("func_145769_d", "setEntityId"));
            mInitMap.put(new Pair<String, String>("func_145770_h", "isInRangeToRender3d"));
            mInitMap.put(new Pair<String, String>("func_145771_j", "pushOutOfBlocks"));
            mInitMap.put(new Pair<String, String>("func_145772_a", "getExplosionResistance"));
            mInitMap.put(new Pair<String, String>("func_145773_az", "doesEntityNotTriggerPressurePlate"));
            mInitMap.put(new Pair<String, String>("func_145775_I", "doBlockCollisions"));
            mInitMap.put(new Pair<String, String>("func_145776_H", "getSwimSound"));
            mInitMap.put(new Pair<String, String>("func_145777_O", "getSplashSound"));
            mInitMap.put(new Pair<String, String>("func_145778_a", "dropItemWithOffset"));
            mInitMap.put(new Pair<String, String>("func_145779_a", "dropItem"));
            mInitMap.put(new Pair<String, String>("func_145780_a", "playStepSound"));
            mInitMap.put(new Pair<String, String>("func_145782_y", "getEntityId"));
            mInitMap.put(new Pair<String, String>("func_145797_a", "setOwner"));
            mInitMap.put(new Pair<String, String>("func_145798_i", "getOwner"));
            mInitMap.put(new Pair<String, String>("func_145799_b", "setThrower"));
            mInitMap.put(new Pair<String, String>("func_145800_j", "getThrower"));
            mInitMap.put(new Pair<String, String>("func_145805_f", "getBlock"));
            mInitMap.put(new Pair<String, String>("func_145806_a", "setHurtEntities"));
            mInitMap.put(new Pair<String, String>("func_145807_e", "getWorldObj"));
            mInitMap.put(new Pair<String, String>("func_145817_o", "getDefaultDisplayTile"));
            mInitMap.put(new Pair<String, String>("func_145818_k_", "isCustomInventoryName"));
            mInitMap.put(new Pair<String, String>("func_145820_n", "getDisplayTile"));
            mInitMap.put(new Pair<String, String>("func_145825_b", "getInventoryName"));
            mInitMap.put(new Pair<String, String>("func_145826_a", "addMapping"));
            mInitMap.put(new Pair<String, String>("func_145827_c", "createAndLoadEntity"));
            mInitMap.put(new Pair<String, String>("func_145828_a", "addInfoToCrashReport"));
            mInitMap.put(new Pair<String, String>("func_145829_t", "validate"));
            mInitMap.put(new Pair<String, String>("func_145830_o", "hasWorldObj"));
            mInitMap.put(new Pair<String, String>("func_145831_w", "getWorld"));
            mInitMap.put(new Pair<String, String>("func_145832_p", "getBlockMetadata"));
            mInitMap.put(new Pair<String, String>("func_145833_n", "getMaxRenderDistanceSquared"));
            mInitMap.put(new Pair<String, String>("func_145834_a", "setWorldObj"));
            mInitMap.put(new Pair<String, String>("func_145835_a", "getDistanceSq"));
            mInitMap.put(new Pair<String, String>("func_145836_u", "updateContainingBlockInfo"));
            mInitMap.put(new Pair<String, String>("func_145837_r", "isInvalid"));
            mInitMap.put(new Pair<String, String>("func_145838_q", "getBlockType"));
            mInitMap.put(new Pair<String, String>("func_145839_a", "readFromNBT"));
            mInitMap.put(new Pair<String, String>("func_145841_b", "writeToNBT"));
            mInitMap.put(new Pair<String, String>("func_145842_c", "receiveClientEvent"));
            mInitMap.put(new Pair<String, String>("func_145843_s", "invalidate"));
            mInitMap.put(new Pair<String, String>("func_145844_m", "getDescriptionPacket"));
            mInitMap.put(new Pair<String, String>("func_145845_h", "updateEntity"));
            mInitMap.put(new Pair<String, String>("func_145861_a", "getStoredBlockID"));
            mInitMap.put(new Pair<String, String>("func_145864_c", "getPistonOrientation"));
            mInitMap.put(new Pair<String, String>("func_145866_f", "clearPistonTileEntity"));
            mInitMap.put(new Pair<String, String>("func_145867_d", "shouldPistonHeadBeRendered"));
            mInitMap.put(new Pair<String, String>("func_145868_b", "isExtending"));
            mInitMap.put(new Pair<String, String>("func_145877_a", "changePitch"));
            mInitMap.put(new Pair<String, String>("func_145878_a", "triggerNote"));
            mInitMap.put(new Pair<String, String>("func_145888_j", "isOnTransferCooldown"));
            mInitMap.put(new Pair<String, String>("func_145896_c", "setTransferCooldown"));
            mInitMap.put(new Pair<String, String>("func_145903_a", "setSkullRotation"));
            mInitMap.put(new Pair<String, String>("func_145904_a", "getSkullType"));
            mInitMap.put(new Pair<String, String>("func_145906_b", "getSkullRotation"));
            mInitMap.put(new Pair<String, String>("func_145913_a", "setEditable"));
            mInitMap.put(new Pair<String, String>("func_145914_a", "getIsEditable"));
            mInitMap.put(new Pair<String, String>("func_145934_k", "canBrew"));
            mInitMap.put(new Pair<String, String>("func_145935_i", "getBrewTime"));
            mInitMap.put(new Pair<String, String>("func_145938_d", "setBrewTime"));
            mInitMap.put(new Pair<String, String>("func_145939_j", "getFilledSlots"));
            mInitMap.put(new Pair<String, String>("func_145940_l", "brewPotions"));
            mInitMap.put(new Pair<String, String>("func_145948_k", "canSmelt"));
            mInitMap.put(new Pair<String, String>("func_145949_j", "smeltItem"));
            mInitMap.put(new Pair<String, String>("func_145950_i", "isBurning"));
            mInitMap.put(new Pair<String, String>("func_145951_a", "setCustomInventoryName"));
            mInitMap.put(new Pair<String, String>("func_145952_a", "getItemBurnTime"));
            mInitMap.put(new Pair<String, String>("func_145953_d", "getCookProgressScaled"));
            mInitMap.put(new Pair<String, String>("func_145954_b", "isItemFuel"));
            mInitMap.put(new Pair<String, String>("func_145955_e", "getBurnTimeRemainingScaled"));
            mInitMap.put(new Pair<String, String>("func_145965_a", "getFlowerPotItem"));
            mInitMap.put(new Pair<String, String>("func_145966_b", "getFlowerPotData"));
            mInitMap.put(new Pair<String, String>("func_145976_a", "setCustomName"));
            mInitMap.put(new Pair<String, String>("func_145977_a", "isSameTypeChestAt"));
            mInitMap.put(new Pair<String, String>("func_145979_i", "checkForAdjacentChests"));
            mInitMap.put(new Pair<String, String>("func_145980_j", "getChestType"));
            mInitMap.put(new Pair<String, String>("func_145995_a", "setOutputSignal"));
            mInitMap.put(new Pair<String, String>("func_145996_a", "getOutputSignal"));
            mInitMap.put(new Pair<String, String>("func_145998_l", "getLevels"));
            mInitMap.put(new Pair<String, String>("func_146001_d", "setPrimaryEffect"));
            mInitMap.put(new Pair<String, String>("func_146002_i", "shouldBeamRender"));
            mInitMap.put(new Pair<String, String>("func_146004_e", "setSecondaryEffect"));
            mInitMap.put(new Pair<String, String>("func_146006_k", "getSecondaryEffect"));
            mInitMap.put(new Pair<String, String>("func_146007_j", "getPrimaryEffect"));
            mInitMap.put(new Pair<String, String>("func_146023_a", "getStrVsBlock"));
            mInitMap.put(new Pair<String, String>("func_146024_c", "getInventorySlotContainItemAndDamage"));
            mInitMap.put(new Pair<String, String>("func_146026_a", "consumeInventoryItem"));
            mInitMap.put(new Pair<String, String>("func_146027_a", "clearInventory"));
            mInitMap.put(new Pair<String, String>("func_146028_b", "hasItem"));
            mInitMap.put(new Pair<String, String>("func_146029_c", "getInventorySlotContainItem"));
            mInitMap.put(new Pair<String, String>("func_146030_a", "setCurrentItem"));
            mInitMap.put(new Pair<String, String>("func_146031_a", "setChestTileEntity"));
            mInitMap.put(new Pair<String, String>("func_146034_e", "handleHookRetraction"));
            mInitMap.put(new Pair<String, String>("func_146035_c", "handleHookCasting"));
            mInitMap.put(new Pair<String, String>("func_146068_u", "getDropItem"));
            mInitMap.put(new Pair<String, String>("func_146080_bZ", "getCarriedBlock"));
            mInitMap.put(new Pair<String, String>("func_146081_a", "setCarriedBlock"));
            mInitMap.put(new Pair<String, String>("func_146082_f", "setInLove"));
            mInitMap.put(new Pair<String, String>("func_146086_d", "setHorseArmorStack"));
            mInitMap.put(new Pair<String, String>("func_146094_a", "getUUID"));
            mInitMap.put(new Pair<String, String>("func_146096_a", "getBreakSpeed"));
            mInitMap.put(new Pair<String, String>("func_146099_a", "canHarvestBlock"));
            mInitMap.put(new Pair<String, String>("func_146100_a", "displayGUIEditSign"));
            mInitMap.put(new Pair<String, String>("func_146103_bH", "getGameProfile"));
            mInitMap.put(new Pair<String, String>("func_146105_b", "addChatComponentMessage"));
            mInitMap.put(new Pair<String, String>("func_146107_m", "getStatFileWriter"));
            mInitMap.put(new Pair<String, String>("func_146110_a", "drawModalRectWithCustomSizedTexture"));
            mInitMap.put(new Pair<String, String>("func_146111_b", "drawButtonForegroundLayer"));
            mInitMap.put(new Pair<String, String>("func_146112_a", "drawButton"));
            mInitMap.put(new Pair<String, String>("func_146113_a", "playPressSound"));
            mInitMap.put(new Pair<String, String>("func_146114_a", "getHoverState"));
            mInitMap.put(new Pair<String, String>("func_146115_a", "isMouseOver"));
            mInitMap.put(new Pair<String, String>("func_146116_c", "mousePressed"));
            mInitMap.put(new Pair<String, String>("func_146117_b", "getButtonWidth"));
            mInitMap.put(new Pair<String, String>("func_146118_a", "mouseReleased"));
            mInitMap.put(new Pair<String, String>("func_146119_b", "mouseDragged"));
            mInitMap.put(new Pair<String, String>("func_146136_c", "returnEnumOptions"));
            mInitMap.put(new Pair<String, String>("func_146158_b", "getChatGUI"));
            mInitMap.put(new Pair<String, String>("func_146159_a", "drawLabel"));
            mInitMap.put(new Pair<String, String>("func_146160_b", "drawLabelBackground"));
            mInitMap.put(new Pair<String, String>("func_146175_b", "deleteFromCursor"));
            mInitMap.put(new Pair<String, String>("func_146176_q", "getVisible"));
            mInitMap.put(new Pair<String, String>("func_146177_a", "deleteWords"));
            mInitMap.put(new Pair<String, String>("func_146178_a", "updateCursorCounter"));
            mInitMap.put(new Pair<String, String>("func_146179_b", "getText"));
            mInitMap.put(new Pair<String, String>("func_146180_a", "setText"));
            mInitMap.put(new Pair<String, String>("func_146181_i", "getEnableBackgroundDrawing"));
            mInitMap.put(new Pair<String, String>("func_146182_d", "moveCursorBy"));
            mInitMap.put(new Pair<String, String>("func_146183_a", "getNthWordFromPos"));
            mInitMap.put(new Pair<String, String>("func_146184_c", "setEnabled"));
            mInitMap.put(new Pair<String, String>("func_146185_a", "setEnableBackgroundDrawing"));
            mInitMap.put(new Pair<String, String>("func_146186_n", "getSelectionEnd"));
            mInitMap.put(new Pair<String, String>("func_146187_c", "getNthWordFromCursor"));
            mInitMap.put(new Pair<String, String>("func_146188_c", "drawCursorVertical"));
            mInitMap.put(new Pair<String, String>("func_146189_e", "setVisible"));
            mInitMap.put(new Pair<String, String>("func_146190_e", "setCursorPosition"));
            mInitMap.put(new Pair<String, String>("func_146191_b", "writeText"));
            mInitMap.put(new Pair<String, String>("func_146192_a", "mouseClicked"));
            mInitMap.put(new Pair<String, String>("func_146193_g", "setTextColor"));
            mInitMap.put(new Pair<String, String>("func_146194_f", "drawTextBox"));
            mInitMap.put(new Pair<String, String>("func_146195_b", "setFocused"));
            mInitMap.put(new Pair<String, String>("func_146196_d", "setCursorPositionZero"));
            mInitMap.put(new Pair<String, String>("func_146198_h", "getCursorPosition"));
            mInitMap.put(new Pair<String, String>("func_146199_i", "setSelectionPos"));
            mInitMap.put(new Pair<String, String>("func_146200_o", "getWidth"));
            mInitMap.put(new Pair<String, String>("func_146201_a", "textboxKeyTyped"));
            mInitMap.put(new Pair<String, String>("func_146202_e", "setCursorPositionEnd"));
            mInitMap.put(new Pair<String, String>("func_146203_f", "setMaxStringLength"));
            mInitMap.put(new Pair<String, String>("func_146204_h", "setDisabledTextColour"));
            mInitMap.put(new Pair<String, String>("func_146205_d", "setCanLoseFocus"));
            mInitMap.put(new Pair<String, String>("func_146206_l", "isFocused"));
            mInitMap.put(new Pair<String, String>("func_146207_c", "getSelectedText"));
            mInitMap.put(new Pair<String, String>("func_146208_g", "getMaxStringLength"));
            mInitMap.put(new Pair<String, String>("func_146227_a", "printChatMessage"));
            mInitMap.put(new Pair<String, String>("func_146228_f", "getChatWidth"));
            mInitMap.put(new Pair<String, String>("func_146229_b", "scroll"));
            mInitMap.put(new Pair<String, String>("func_146230_a", "drawChat"));
            mInitMap.put(new Pair<String, String>("func_146231_a", "clearChatMessages"));
            mInitMap.put(new Pair<String, String>("func_146232_i", "getLineCount"));
            mInitMap.put(new Pair<String, String>("func_146233_a", "calculateChatboxWidth"));
            mInitMap.put(new Pair<String, String>("func_146234_a", "printChatMessageWithOptionalDeletion"));
            mInitMap.put(new Pair<String, String>("func_146235_b", "formatColors"));
            mInitMap.put(new Pair<String, String>("func_146236_a", "getChatComponent"));
            mInitMap.put(new Pair<String, String>("func_146237_a", "setChatLine"));
            mInitMap.put(new Pair<String, String>("func_146238_c", "getSentMessages"));
            mInitMap.put(new Pair<String, String>("func_146239_a", "addToSentMessages"));
            mInitMap.put(new Pair<String, String>("func_146240_d", "resetScroll"));
            mInitMap.put(new Pair<String, String>("func_146241_e", "getChatOpen"));
            mInitMap.put(new Pair<String, String>("func_146242_c", "deleteChatLine"));
            mInitMap.put(new Pair<String, String>("func_146243_b", "calculateChatboxHeight"));
            mInitMap.put(new Pair<String, String>("func_146244_h", "getChatScale"));
            mInitMap.put(new Pair<String, String>("func_146245_b", "refreshChat"));
            mInitMap.put(new Pair<String, String>("func_146246_g", "getChatHeight"));
            mInitMap.put(new Pair<String, String>("func_146254_a", "updateAchievementWindow"));
            mInitMap.put(new Pair<String, String>("func_146255_b", "displayUnformattedAchievement"));
            mInitMap.put(new Pair<String, String>("func_146256_a", "displayAchievement"));
            mInitMap.put(new Pair<String, String>("func_146257_b", "clearAchievements"));
            mInitMap.put(new Pair<String, String>("func_146258_c", "updateAchievementWindowScale"));
            mInitMap.put(new Pair<String, String>("func_146269_k", "handleInput"));
            mInitMap.put(new Pair<String, String>("func_146270_b", "drawWorldBackground"));
            mInitMap.put(new Pair<String, String>("func_146271_m", "isCtrlKeyDown"));
            mInitMap.put(new Pair<String, String>("func_146272_n", "isShiftKeyDown"));
            mInitMap.put(new Pair<String, String>("func_146273_a", "mouseClickMove"));
            mInitMap.put(new Pair<String, String>("func_146274_d", "handleMouseInput"));
            mInitMap.put(new Pair<String, String>("func_146275_d", "setClipboardString"));
            mInitMap.put(new Pair<String, String>("func_146276_q_", "drawDefaultBackground"));
            mInitMap.put(new Pair<String, String>("func_146277_j", "getClipboardString"));
            mInitMap.put(new Pair<String, String>("func_146278_c", "drawBackground"));
            mInitMap.put(new Pair<String, String>("func_146279_a", "drawCreativeTabHoveringText"));
            mInitMap.put(new Pair<String, String>("func_146280_a", "setWorldAndResolution"));
            mInitMap.put(new Pair<String, String>("func_146281_b", "onGuiClosed"));
            mInitMap.put(new Pair<String, String>("func_146282_l", "handleKeyboardInput"));
            mInitMap.put(new Pair<String, String>("func_146283_a", "drawHoveringText"));
            mInitMap.put(new Pair<String, String>("func_146284_a", "actionPerformed"));
            mInitMap.put(new Pair<String, String>("func_146285_a", "renderToolTip"));
            mInitMap.put(new Pair<String, String>("func_146286_b", "mouseReleased"));
            mInitMap.put(new Pair<String, String>("func_146350_a", "setButtonDelay"));
            mInitMap.put(new Pair<String, String>("func_146358_g", "disableSecurityWarning"));
            mInitMap.put(new Pair<String, String>("func_146359_e", "copyLinkToClipboard"));
            mInitMap.put(new Pair<String, String>("func_146367_a", "connect"));
            mInitMap.put(new Pair<String, String>("func_146402_a", "getSentHistory"));
            mInitMap.put(new Pair<String, String>("func_146403_a", "submitChatMessage"));
            mInitMap.put(new Pair<String, String>("func_146404_p_", "autocompletePlayerNames"));
            mInitMap.put(new Pair<String, String>("func_146405_a", "sendAutocompleteRequest"));
            mInitMap.put(new Pair<String, String>("func_146406_a", "onAutocompleteResponse"));
            mInitMap.put(new Pair<String, String>("func_146407_a", "openLink"));
            mInitMap.put(new Pair<String, String>("func_146418_g", "wakeFromSleep"));
            mInitMap.put(new Pair<String, String>("func_146456_p", "pageGetCurrent"));
            mInitMap.put(new Pair<String, String>("func_146457_a", "pageSetCurrent"));
            mInitMap.put(new Pair<String, String>("func_146459_b", "pageInsertIntoCurrent"));
            mInitMap.put(new Pair<String, String>("func_146460_c", "keyTypedInTitle"));
            mInitMap.put(new Pair<String, String>("func_146461_i", "addmInitMap.put(newPage"));
            mInitMap.put(new Pair<String, String>("func_146462_a", "sendBookToServer"));
            mInitMap.put(new Pair<String, String>("func_146463_b", "keyTypedInBook"));
            mInitMap.put(new Pair<String, String>("func_146464_h", "updateButtons"));
            mInitMap.put(new Pair<String, String>("func_146504_a", "getSoundVolume"));
            mInitMap.put(new Pair<String, String>("func_146509_g", "doneLoading"));
            mInitMap.put(new Pair<String, String>("func_146521_a", "drawStatsScreen"));
            mInitMap.put(new Pair<String, String>("func_146527_c", "drawSprite"));
            mInitMap.put(new Pair<String, String>("func_146531_b", "drawButtonBackground"));
            mInitMap.put(new Pair<String, String>("func_146541_h", "createButtons"));
            mInitMap.put(new Pair<String, String>("func_146552_b", "drawAchievementScreen"));
            mInitMap.put(new Pair<String, String>("func_146553_h", "drawTitle"));
            mInitMap.put(new Pair<String, String>("func_146574_g", "sendRespawnPacket"));
            mInitMap.put(new Pair<String, String>("func_146575_b", "drawWinGameScreen"));
            mInitMap.put(new Pair<String, String>("func_146586_a", "setDomInitMap.put(neworking"));
            mInitMap.put(new Pair<String, String>("func_146789_i", "getOldServerPinger"));
            mInitMap.put(new Pair<String, String>("func_146790_a", "selectServer"));
            mInitMap.put(new Pair<String, String>("func_146791_a", "connectToServer"));
            mInitMap.put(new Pair<String, String>("func_146792_q", "refreshServerList"));
            mInitMap.put(new Pair<String, String>("func_146794_g", "createButtons"));
            mInitMap.put(new Pair<String, String>("func_146795_p", "getServerList"));
            mInitMap.put(new Pair<String, String>("func_146796_h", "connectToSelected"));
            mInitMap.put(new Pair<String, String>("func_146961_a", "hasResourcePackEntry"));
            mInitMap.put(new Pair<String, String>("func_146975_c", "getSlotAtPosition"));
            mInitMap.put(new Pair<String, String>("func_146976_a", "drawGuiContainerBackgroundLayer"));
            mInitMap.put(new Pair<String, String>("func_146977_a", "drawSlot"));
            mInitMap.put(new Pair<String, String>("func_146978_c", "isPointInRegion"));
            mInitMap.put(new Pair<String, String>("func_146979_b", "drawGuiContainerForegroundLayer"));
            mInitMap.put(new Pair<String, String>("func_146980_g", "updateDragSplitting"));
            mInitMap.put(new Pair<String, String>("func_146981_a", "isMouseOverSlot"));
            mInitMap.put(new Pair<String, String>("func_146982_a", "drawItemStack"));
            mInitMap.put(new Pair<String, String>("func_146983_a", "checkHotbarKeys"));
            mInitMap.put(new Pair<String, String>("func_146984_a", "handleMouseClick"));
            mInitMap.put(new Pair<String, String>("func_147035_g", "getMerchant"));
            mInitMap.put(new Pair<String, String>("func_147044_g", "drawActivePotionEffects"));
            mInitMap.put(new Pair<String, String>("func_147046_a", "drawEntityOnScreen"));
            mInitMap.put(new Pair<String, String>("func_147050_b", "setCurrentCreativeTab"));
            mInitMap.put(new Pair<String, String>("func_147052_b", "renderCreativeInventoryHoveringText"));
            mInitMap.put(new Pair<String, String>("func_147053_i", "updateCreativeSearch"));
            mInitMap.put(new Pair<String, String>("func_147055_p", "needsScrollBars"));
            mInitMap.put(new Pair<String, String>("func_147090_g", "renameItem"));
            mInitMap.put(new Pair<String, String>("func_147095_a", "requestTexturePackLoad"));
            mInitMap.put(new Pair<String, String>("func_147099_x", "getStatFile"));
            mInitMap.put(new Pair<String, String>("func_147104_D", "getCurrentServerData"));
            mInitMap.put(new Pair<String, String>("func_147106_B", "scheduleResourcesRefresh"));
            mInitMap.put(new Pair<String, String>("func_147107_h", "isFramerateLimitBelowMax"));
            mInitMap.put(new Pair<String, String>("func_147108_a", "displayGuiScreen"));
            mInitMap.put(new Pair<String, String>("func_147109_W", "getAmbientMusicType"));
            mInitMap.put(new Pair<String, String>("func_147110_a", "getFramebuffer"));
            mInitMap.put(new Pair<String, String>("func_147111_S", "isJava64bit"));
            mInitMap.put(new Pair<String, String>("func_147112_ai", "middleClickMouse"));
            mInitMap.put(new Pair<String, String>("func_147113_T", "isGamePaused"));
            mInitMap.put(new Pair<String, String>("func_147114_u", "getNetHandler"));
            mInitMap.put(new Pair<String, String>("func_147115_a", "sendClickBlockToController"));
            mInitMap.put(new Pair<String, String>("func_147116_af", "clickMouse"));
            mInitMap.put(new Pair<String, String>("func_147117_R", "getTextureMapBlocks"));
            mInitMap.put(new Pair<String, String>("func_147118_V", "getSoundHandler"));
            mInitMap.put(new Pair<String, String>("func_147119_ah", "updateFramebufferSize"));
            mInitMap.put(new Pair<String, String>("func_147120_f", "resetSize"));
            mInitMap.put(new Pair<String, String>("func_147121_ag", "rightClickMouse"));
            mInitMap.put(new Pair<String, String>("func_147122_X", "isJvm64bit"));
            mInitMap.put(new Pair<String, String>("func_147130_as", "getMinecraftSessionService"));
            mInitMap.put(new Pair<String, String>("func_147132_au", "refreshStatusNextTick"));
            mInitMap.put(new Pair<String, String>("func_147133_T", "getTexturePack"));
            mInitMap.put(new Pair<String, String>("func_147134_at", "getServerStatusResponse"));
            mInitMap.put(new Pair<String, String>("func_147135_j", "getDifficulty"));
            mInitMap.put(new Pair<String, String>("func_147136_ar", "isAnnouncingPlayerAchievements"));
            mInitMap.put(new Pair<String, String>("func_147137_ag", "getNetworkSystem"));
            mInitMap.put(new Pair<String, String>("func_147138_a", "addFaviconToStatusResponse"));
            mInitMap.put(new Pair<String, String>("func_147139_a", "setDifficultyForAllWorlds"));
            mInitMap.put(new Pair<String, String>("func_147149_a", "saveToFile"));
            mInitMap.put(new Pair<String, String>("func_147153_a", "addBlockInfo"));
            mInitMap.put(new Pair<String, String>("func_147155_a", "getCategoryName"));
            mInitMap.put(new Pair<String, String>("func_147156_b", "getCategoryId"));
            mInitMap.put(new Pair<String, String>("func_147176_a", "getChatComponentFromNthArg"));
            mInitMap.put(new Pair<String, String>("func_147177_a", "joinNiceString"));
            mInitMap.put(new Pair<String, String>("func_147178_a", "getChatComponentFromNthArg"));
            mInitMap.put(new Pair<String, String>("func_147179_f", "getItemByText"));
            mInitMap.put(new Pair<String, String>("func_147180_g", "getBlockByText"));
            mInitMap.put(new Pair<String, String>("func_147185_d", "addTeam"));
            mInitMap.put(new Pair<String, String>("func_147186_g", "listTeams"));
            mInitMap.put(new Pair<String, String>("func_147187_n", "resetPlayers"));
            mInitMap.put(new Pair<String, String>("func_147188_j", "emptyTeam"));
            mInitMap.put(new Pair<String, String>("func_147190_h", "joinTeam"));
            mInitMap.put(new Pair<String, String>("func_147191_h", "removeObjective"));
            mInitMap.put(new Pair<String, String>("func_147192_d", "getScoreboard"));
            mInitMap.put(new Pair<String, String>("func_147193_c", "addObjective"));
            mInitMap.put(new Pair<String, String>("func_147194_f", "removeTeam"));
            mInitMap.put(new Pair<String, String>("func_147195_l", "listPlayers"));
            mInitMap.put(new Pair<String, String>("func_147196_d", "listObjectives"));
            mInitMap.put(new Pair<String, String>("func_147197_m", "setPlayer"));
            mInitMap.put(new Pair<String, String>("func_147198_k", "setObjectiveDisplay"));
            mInitMap.put(new Pair<String, String>("func_147199_i", "leaveTeam"));
            mInitMap.put(new Pair<String, String>("func_147200_e", "setTeamOption"));
            mInitMap.put(new Pair<String, String>("func_147215_a", "addBlockDestroyEffects"));
            mInitMap.put(new Pair<String, String>("func_147223_a", "pingPendingNetworks"));
            mInitMap.put(new Pair<String, String>("func_147224_a", "ping"));
            mInitMap.put(new Pair<String, String>("func_147225_b", "tryCompatibilityPing"));
            mInitMap.put(new Pair<String, String>("func_147226_b", "clearPendingNetworks"));
            mInitMap.put(new Pair<String, String>("func_147231_a", "onDisconnect"));
            mInitMap.put(new Pair<String, String>("func_147232_a", "onConnectionStateTransition"));
            mInitMap.put(new Pair<String, String>("func_147233_a", "onNetworkTick"));
            mInitMap.put(new Pair<String, String>("func_147234_a", "handleBlockChange"));
            mInitMap.put(new Pair<String, String>("func_147235_a", "handleSpawnObject"));
            mInitMap.put(new Pair<String, String>("func_147236_a", "handleEntityStatus"));
            mInitMap.put(new Pair<String, String>("func_147237_a", "handleSpawnPlayer"));
            mInitMap.put(new Pair<String, String>("func_147238_a", "handleDestroyEntities"));
            mInitMap.put(new Pair<String, String>("func_147239_a", "handleConfirmTransaction"));
            mInitMap.put(new Pair<String, String>("func_147240_a", "handleCustomPayload"));
            mInitMap.put(new Pair<String, String>("func_147241_a", "handleWindowItems"));
            mInitMap.put(new Pair<String, String>("func_147242_a", "handleEntityEquipment"));
            mInitMap.put(new Pair<String, String>("func_147243_a", "handleEntityAttach"));
            mInitMap.put(new Pair<String, String>("func_147244_a", "handleEntityVelocity"));
            mInitMap.put(new Pair<String, String>("func_147245_a", "handleWindowProperty"));
            mInitMap.put(new Pair<String, String>("func_147246_a", "handleCollectItem"));
            mInitMap.put(new Pair<String, String>("func_147247_a", "handleTeams"));
            mInitMap.put(new Pair<String, String>("func_147248_a", "handleUpdateSign"));
            mInitMap.put(new Pair<String, String>("func_147249_a", "handleUpdateHealth"));
            mInitMap.put(new Pair<String, String>("func_147250_a", "handleUpdateScore"));
            mInitMap.put(new Pair<String, String>("func_147251_a", "handleChat"));
            mInitMap.put(new Pair<String, String>("func_147252_a", "handleChangeGameState"));
            mInitMap.put(new Pair<String, String>("func_147253_a", "handleDisconnect"));
            mInitMap.put(new Pair<String, String>("func_147254_a", "handleDisplayScoreboard"));
            mInitMap.put(new Pair<String, String>("func_147255_a", "handleSoundEffect"));
            mInitMap.put(new Pair<String, String>("func_147256_a", "handlePlayerListItem"));
            mInitMap.put(new Pair<String, String>("func_147257_a", "handleHeldItemChange"));
            mInitMap.put(new Pair<String, String>("func_147258_a", "handlePlayerPosLook"));
            mInitMap.put(new Pair<String, String>("func_147259_a", "handleEntityMovement"));
            mInitMap.put(new Pair<String, String>("func_147260_a", "handleEntityEffect"));
            mInitMap.put(new Pair<String, String>("func_147261_a", "handleBlockAction"));
            mInitMap.put(new Pair<String, String>("func_147262_a", "handleRemoveEntityEffect"));
            mInitMap.put(new Pair<String, String>("func_147263_a", "handleChunkData"));
            mInitMap.put(new Pair<String, String>("func_147264_a", "handleMaps"));
            mInitMap.put(new Pair<String, String>("func_147265_a", "handleOpenWindow"));
            mInitMap.put(new Pair<String, String>("func_147266_a", "handleSetSlot"));
            mInitMap.put(new Pair<String, String>("func_147267_a", "handleEntityHeadLook"));
            mInitMap.put(new Pair<String, String>("func_147268_a", "handleSignEditorOpen"));
            mInitMap.put(new Pair<String, String>("func_147269_a", "handleMapChunkBulk"));
            mInitMap.put(new Pair<String, String>("func_147270_a", "handlePlayerAbilities"));
            mInitMap.put(new Pair<String, String>("func_147271_a", "handleSpawnPosition"));
            mInitMap.put(new Pair<String, String>("func_147272_a", "handleKeepAlive"));
            mInitMap.put(new Pair<String, String>("func_147273_a", "handleUpdateTileEntity"));
            mInitMap.put(new Pair<String, String>("func_147274_a", "handleTabComplete"));
            mInitMap.put(new Pair<String, String>("func_147275_a", "handleEntityTeleport"));
            mInitMap.put(new Pair<String, String>("func_147276_a", "handleCloseWindow"));
            mInitMap.put(new Pair<String, String>("func_147277_a", "handleEffect"));
            mInitMap.put(new Pair<String, String>("func_147278_a", "handleUseBed"));
            mInitMap.put(new Pair<String, String>("func_147279_a", "handleAnimation"));
            mInitMap.put(new Pair<String, String>("func_147280_a", "handleRespawn"));
            mInitMap.put(new Pair<String, String>("func_147281_a", "handleSpawnMob"));
            mInitMap.put(new Pair<String, String>("func_147282_a", "handleJoinGame"));
            mInitMap.put(new Pair<String, String>("func_147283_a", "handleExplosion"));
            mInitMap.put(new Pair<String, String>("func_147284_a", "handleEntityMetadata"));
            mInitMap.put(new Pair<String, String>("func_147285_a", "handleTimeUpdate"));
            mInitMap.put(new Pair<String, String>("func_147286_a", "handleSpawnExperienceOrb"));
            mInitMap.put(new Pair<String, String>("func_147287_a", "handleMultiBlockChange"));
            mInitMap.put(new Pair<String, String>("func_147288_a", "handleSpawnPainting"));
            mInitMap.put(new Pair<String, String>("func_147289_a", "handleParticles"));
            mInitMap.put(new Pair<String, String>("func_147290_a", "handleEntityProperties"));
            mInitMap.put(new Pair<String, String>("func_147291_a", "handleScoreboardObjective"));
            mInitMap.put(new Pair<String, String>("func_147292_a", "handleSpawnGlobalEntity"));
            mInitMap.put(new Pair<String, String>("func_147293_a", "handleStatistics"));
            mInitMap.put(new Pair<String, String>("func_147294_a", "handleBlockBreakAnim"));
            mInitMap.put(new Pair<String, String>("func_147295_a", "handleSetExperience"));
            mInitMap.put(new Pair<String, String>("func_147296_c", "cleanup"));
            mInitMap.put(new Pair<String, String>("func_147297_a", "addToSendQueue"));
            mInitMap.put(new Pair<String, String>("func_147298_b", "getNetworkManager"));
            mInitMap.put(new Pair<String, String>("func_147311_a", "processPing"));
            mInitMap.put(new Pair<String, String>("func_147312_a", "processServerQuery"));
            mInitMap.put(new Pair<String, String>("func_147315_a", "processEncryptionResponse"));
            mInitMap.put(new Pair<String, String>("func_147316_a", "processLoginStart"));
            mInitMap.put(new Pair<String, String>("func_147322_a", "closeConnection"));
            mInitMap.put(new Pair<String, String>("func_147338_a", "processEnchantItem"));
            mInitMap.put(new Pair<String, String>("func_147339_a", "processConfirmTransaction"));
            mInitMap.put(new Pair<String, String>("func_147340_a", "processUseEntity"));
            mInitMap.put(new Pair<String, String>("func_147341_a", "processTabComplete"));
            mInitMap.put(new Pair<String, String>("func_147342_a", "processClientStatus"));
            mInitMap.put(new Pair<String, String>("func_147343_a", "processUpdateSign"));
            mInitMap.put(new Pair<String, String>("func_147344_a", "processCreativeInventoryAction"));
            mInitMap.put(new Pair<String, String>("func_147345_a", "processPlayerDigging"));
            mInitMap.put(new Pair<String, String>("func_147346_a", "processPlayerBlockPlacement"));
            mInitMap.put(new Pair<String, String>("func_147347_a", "processPlayer"));
            mInitMap.put(new Pair<String, String>("func_147348_a", "processPlayerAbilities"));
            mInitMap.put(new Pair<String, String>("func_147349_a", "processVanilla250Packet"));
            mInitMap.put(new Pair<String, String>("func_147350_a", "processAnimation"));
            mInitMap.put(new Pair<String, String>("func_147351_a", "processClickWindow"));
            mInitMap.put(new Pair<String, String>("func_147352_a", "processClientSettings"));
            mInitMap.put(new Pair<String, String>("func_147353_a", "processKeepAlive"));
            mInitMap.put(new Pair<String, String>("func_147354_a", "processChatMessage"));
            mInitMap.put(new Pair<String, String>("func_147355_a", "processHeldItemChange"));
            mInitMap.put(new Pair<String, String>("func_147356_a", "processCloseWindow"));
            mInitMap.put(new Pair<String, String>("func_147357_a", "processEntityAction"));
            mInitMap.put(new Pair<String, String>("func_147358_a", "processInput"));
            mInitMap.put(new Pair<String, String>("func_147359_a", "sendPacket"));
            mInitMap.put(new Pair<String, String>("func_147360_c", "kickPlayerFromServer"));
            mInitMap.put(new Pair<String, String>("func_147361_d", "handleSlashCommand"));
            mInitMap.put(new Pair<String, String>("func_147362_b", "getNetworkManager"));
            mInitMap.put(new Pair<String, String>("func_147363_d", "currentTimeMillis"));
            mInitMap.put(new Pair<String, String>("func_147364_a", "setPlayerLocation"));
            mInitMap.put(new Pair<String, String>("func_147383_a", "processHandshake"));
            mInitMap.put(new Pair<String, String>("func_147388_a", "handleDisconnect"));
            mInitMap.put(new Pair<String, String>("func_147389_a", "handleEncryptionRequest"));
            mInitMap.put(new Pair<String, String>("func_147390_a", "handleLoginSuccess"));
            mInitMap.put(new Pair<String, String>("func_147397_a", "handleServerInfo"));
            mInitMap.put(new Pair<String, String>("func_147398_a", "handlePong"));
            mInitMap.put(new Pair<String, String>("func_147407_a", "setBase64EncodedIconData"));
            mInitMap.put(new Pair<String, String>("func_147409_e", "getBase64EncodedIconData"));
            mInitMap.put(new Pair<String, String>("func_147416_a", "findClosestStructure"));
            mInitMap.put(new Pair<String, String>("func_147422_a", "replaceBlocksForBiome"));
            mInitMap.put(new Pair<String, String>("func_147437_c", "isAirBlock"));
            mInitMap.put(new Pair<String, String>("func_147438_o", "getTileEntity"));
            mInitMap.put(new Pair<String, String>("func_147439_a", "getBlock"));
            mInitMap.put(new Pair<String, String>("func_147440_b", "findClosestStructure"));
            mInitMap.put(new Pair<String, String>("func_147441_b", "notifyBlocksOfNeighborChange"));
            mInitMap.put(new Pair<String, String>("func_147442_i", "setThunderStrength"));
            mInitMap.put(new Pair<String, String>("func_147443_d", "destroyBlockInWorldPartially"));
            mInitMap.put(new Pair<String, String>("func_147444_c", "notifyBlockChange"));
            mInitMap.put(new Pair<String, String>("func_147445_c", "isBlockNormalCubeDefault"));
            mInitMap.put(new Pair<String, String>("func_147447_a", "rayTraceBlocks"));
            mInitMap.put(new Pair<String, String>("func_147449_b", "setBlock"));
            mInitMap.put(new Pair<String, String>("func_147451_t", "updateAllLightTypes"));
            mInitMap.put(new Pair<String, String>("func_147452_c", "addBlockEvent"));
            mInitMap.put(new Pair<String, String>("func_147453_f", "updateNeighborsAboutBlockChange"));
            mInitMap.put(new Pair<String, String>("func_147454_a", "scheduleBlockUpdateWithPriority"));
            mInitMap.put(new Pair<String, String>("func_147455_a", "setTileEntity"));
            mInitMap.put(new Pair<String, String>("func_147457_a", "markTileEntityForRemoval"));
            mInitMap.put(new Pair<String, String>("func_147458_c", "markBlockRangeForRenderUpdate"));
            mInitMap.put(new Pair<String, String>("func_147459_d", "notifyBlocksOfNeighborChange"));
            mInitMap.put(new Pair<String, String>("func_147460_e", "notifyBlockOfNeighborChange"));
            mInitMap.put(new Pair<String, String>("func_147462_b", "getTensionFactorForBlock"));
            mInitMap.put(new Pair<String, String>("func_147463_c", "updateLightByType"));
            mInitMap.put(new Pair<String, String>("func_147464_a", "scheduleBlockUpdate"));
            mInitMap.put(new Pair<String, String>("func_147465_d", "setBlock"));
            mInitMap.put(new Pair<String, String>("func_147466_a", "doesBlockHaveSolidTopSurface"));
            mInitMap.put(new Pair<String, String>("func_147468_f", "setBlockToAir"));
            mInitMap.put(new Pair<String, String>("func_147469_q", "isBlockFullCube"));
            mInitMap.put(new Pair<String, String>("func_147471_g", "markBlockForUpdate"));
            mInitMap.put(new Pair<String, String>("func_147472_a", "canPlaceEntityOnSide"));
            mInitMap.put(new Pair<String, String>("func_147474_b", "getTopBlock"));
            mInitMap.put(new Pair<String, String>("func_147475_p", "removeTileEntity"));
            mInitMap.put(new Pair<String, String>("func_147476_b", "markTileEntityChunkModified"));
            mInitMap.put(new Pair<String, String>("func_147477_a", "isBlockTickScheduledThisTick"));
            mInitMap.put(new Pair<String, String>("func_147478_e", "canSnowAt"));
            mInitMap.put(new Pair<String, String>("func_147479_m", "markBlockForRenderUpdate"));
            mInitMap.put(new Pair<String, String>("func_147480_a", "breakBlock"));
            mInitMap.put(new Pair<String, String>("func_147493_a", "createPlayer"));
            mInitMap.put(new Pair<String, String>("func_147496_a", "onWorldChange"));
            mInitMap.put(new Pair<String, String>("func_147499_a", "bindTexture"));
            mInitMap.put(new Pair<String, String>("func_147500_a", "renderTileEntityAt"));
            mInitMap.put(new Pair<String, String>("func_147542_a", "cacheActiveRenderInfo"));
            mInitMap.put(new Pair<String, String>("func_147544_a", "renderTileEntity"));
            mInitMap.put(new Pair<String, String>("func_147545_a", "hasSpecialRenderer"));
            mInitMap.put(new Pair<String, String>("func_147546_a", "getSpecialRendererByClass"));
            mInitMap.put(new Pair<String, String>("func_147547_b", "getSpecialRenderer"));
            mInitMap.put(new Pair<String, String>("func_147548_a", "getFontRenderer"));
            mInitMap.put(new Pair<String, String>("func_147549_a", "renderTileEntityAt"));
            mInitMap.put(new Pair<String, String>("func_147564_a", "getVertexState"));
            mInitMap.put(new Pair<String, String>("func_147565_a", "setVertexState"));
            mInitMap.put(new Pair<String, String>("func_147570_f", "getHasNormals"));
            mInitMap.put(new Pair<String, String>("func_147571_e", "getHasBrightness"));
            mInitMap.put(new Pair<String, String>("func_147572_a", "getRawBuffer"));
            mInitMap.put(new Pair<String, String>("func_147573_d", "getHasTexture"));
            mInitMap.put(new Pair<String, String>("func_147574_g", "getHasColor"));
            mInitMap.put(new Pair<String, String>("func_147575_c", "getVertexCount"));
            mInitMap.put(new Pair<String, String>("func_147576_b", "getRawBufferIndex"));
            mInitMap.put(new Pair<String, String>("func_147584_b", "onStaticEntitiesChanged"));
            mInitMap.put(new Pair<String, String>("func_147585_a", "markBlockRangeForRenderUpdate"));
            mInitMap.put(new Pair<String, String>("func_147586_a", "markBlockForUpdate"));
            mInitMap.put(new Pair<String, String>("func_147587_b", "destroyBlockPartially"));
            mInitMap.put(new Pair<String, String>("func_147588_b", "markBlockForRenderUpdate"));
            mInitMap.put(new Pair<String, String>("func_147589_a", "renderEntities"));
            mInitMap.put(new Pair<String, String>("func_147590_a", "drawOutlinedBoundingBox"));
            mInitMap.put(new Pair<String, String>("func_147591_f", "rebuildDisplayListEntities"));
            mInitMap.put(new Pair<String, String>("func_147604_a", "setFramebufferColor"));
            mInitMap.put(new Pair<String, String>("func_147605_b", "createFramebuffer"));
            mInitMap.put(new Pair<String, String>("func_147606_d", "unbindFramebufferTexture"));
            mInitMap.put(new Pair<String, String>("func_147607_a", "setFramebufferFilter"));
            mInitMap.put(new Pair<String, String>("func_147608_a", "deleteFramebuffer"));
            mInitMap.put(new Pair<String, String>("func_147609_e", "unbindFramebuffer"));
            mInitMap.put(new Pair<String, String>("func_147610_a", "bindFramebuffer"));
            mInitMap.put(new Pair<String, String>("func_147611_b", "checkFramebufferComplete"));
            mInitMap.put(new Pair<String, String>("func_147612_c", "bindFramebufferTexture"));
            mInitMap.put(new Pair<String, String>("func_147613_a", "createBindFramebuffer"));
            mInitMap.put(new Pair<String, String>("func_147614_f", "framebufferClear"));
            mInitMap.put(new Pair<String, String>("func_147615_c", "framebufferRender"));
            mInitMap.put(new Pair<String, String>("func_147631_c", "deleteGlTexture"));
            mInitMap.put(new Pair<String, String>("func_147632_b", "setAnisotropicFiltering"));
            mInitMap.put(new Pair<String, String>("func_147633_a", "setMipmapLevels"));
            mInitMap.put(new Pair<String, String>("func_147634_a", "completeResourceLocation"));
            mInitMap.put(new Pair<String, String>("func_147640_e", "checkTextureUploaded"));
            mInitMap.put(new Pair<String, String>("func_147641_a", "setBufferedImage"));
            mInitMap.put(new Pair<String, String>("func_147645_c", "deleteTexture"));
            mInitMap.put(new Pair<String, String>("func_147647_b", "bidiReorder"));
            mInitMap.put(new Pair<String, String>("func_147649_g", "getXPosF"));
            mInitMap.put(new Pair<String, String>("func_147650_b", "getSoundLocation"));
            mInitMap.put(new Pair<String, String>("func_147651_i", "getZPosF"));
            mInitMap.put(new Pair<String, String>("func_147652_d", "getRepeatDelay"));
            mInitMap.put(new Pair<String, String>("func_147653_e", "getVolume"));
            mInitMap.put(new Pair<String, String>("func_147654_h", "getYPosF"));
            mInitMap.put(new Pair<String, String>("func_147655_f", "getPitch"));
            mInitMap.put(new Pair<String, String>("func_147656_j", "getAttenuationType"));
            mInitMap.put(new Pair<String, String>("func_147657_c", "canRepeat"));
            mInitMap.put(new Pair<String, String>("func_147667_k", "isDonePlaying"));
            mInitMap.put(new Pair<String, String>("func_147673_a", "createPositionedSoundRecord"));
            mInitMap.put(new Pair<String, String>("func_147674_a", "createPositionedSoundRecord"));
            mInitMap.put(new Pair<String, String>("func_147675_a", "createRecordSoundAtPosition"));
            mInitMap.put(new Pair<String, String>("func_147680_a", "getSound"));
            mInitMap.put(new Pair<String, String>("func_147681_a", "playDelayedSound"));
            mInitMap.put(new Pair<String, String>("func_147682_a", "playSound"));
            mInitMap.put(new Pair<String, String>("func_147683_b", "stopSound"));
            mInitMap.put(new Pair<String, String>("func_147684_a", "setSoundLevel"));
            mInitMap.put(new Pair<String, String>("func_147685_d", "unloadSounds"));
            mInitMap.put(new Pair<String, String>("func_147686_a", "getRandomSoundFromCategories"));
            mInitMap.put(new Pair<String, String>("func_147687_e", "resumeSounds"));
            mInitMap.put(new Pair<String, String>("func_147689_b", "pauseSounds"));
            mInitMap.put(new Pair<String, String>("func_147690_c", "stopSounds"));
            mInitMap.put(new Pair<String, String>("func_147691_a", "setListener"));
            mInitMap.put(new Pair<String, String>("func_147692_c", "isSoundPlaying"));
            mInitMap.put(new Pair<String, String>("func_147693_a", "loadSoundResource"));
            mInitMap.put(new Pair<String, String>("func_147701_i", "getMapItemRenderer"));
            mInitMap.put(new Pair<String, String>("func_147702_a", "isShaderActive"));
            mInitMap.put(new Pair<String, String>("func_147703_b", "deactivateShader"));
            mInitMap.put(new Pair<String, String>("func_147704_a", "updateShaderGroupSize"));
            mInitMap.put(new Pair<String, String>("func_147705_c", "activateNextShader"));
            mInitMap.put(new Pair<String, String>("func_147706_e", "getShaderGroup"));
            mInitMap.put(new Pair<String, String>("func_147715_a", "renderChest"));
            mInitMap.put(new Pair<String, String>("func_147721_p", "renderBlockLiquid"));
            mInitMap.put(new Pair<String, String>("func_147722_a", "renderBlockStairs"));
            mInitMap.put(new Pair<String, String>("func_147723_f", "renderBlockTripWireSource"));
            mInitMap.put(new Pair<String, String>("func_147724_m", "renderBlockStem"));
            mInitMap.put(new Pair<String, String>("func_147725_a", "renderBlockAnvil"));
            mInitMap.put(new Pair<String, String>("func_147726_j", "renderBlockVine"));
            mInitMap.put(new Pair<String, String>("func_147727_a", "mixAoBrightness"));
            mInitMap.put(new Pair<String, String>("func_147728_a", "renderBlockAnvilOrient"));
            mInitMap.put(new Pair<String, String>("func_147729_a", "getLiquidHeight"));
            mInitMap.put(new Pair<String, String>("func_147730_a", "renderBlockStemSmall"));
            mInitMap.put(new Pair<String, String>("func_147731_b", "renderPistonBase"));
            mInitMap.put(new Pair<String, String>("func_147732_a", "renderBlockRedstoneDiodeMetadata"));
            mInitMap.put(new Pair<String, String>("func_147733_k", "renderBlockStainedGlassPane"));
            mInitMap.put(new Pair<String, String>("func_147734_d", "renderFaceZPos"));
            mInitMap.put(new Pair<String, String>("func_147735_a", "renderBlockFence"));
            mInitMap.put(new Pair<String, String>("func_147736_d", "renderStandardBlockWithColorMultiplier"));
            mInitMap.put(new Pair<String, String>("func_147737_a", "renderBlockAnvilRotate"));
            mInitMap.put(new Pair<String, String>("func_147738_c", "renderPistonRodEW"));
            mInitMap.put(new Pair<String, String>("func_147739_a", "renderItemIn3d"));
            mInitMap.put(new Pair<String, String>("func_147740_a", "renderBlockStemBig"));
            mInitMap.put(new Pair<String, String>("func_147741_a", "renderBlockBrewingStand"));
            mInitMap.put(new Pair<String, String>("func_147742_r", "renderBlockLog"));
            mInitMap.put(new Pair<String, String>("func_147743_a", "renderBlockEndPortalFrame"));
            mInitMap.put(new Pair<String, String>("func_147744_b", "hasOverrideBlockTexture"));
            mInitMap.put(new Pair<String, String>("func_147745_b", "getBlockIcon"));
            mInitMap.put(new Pair<String, String>("func_147746_l", "renderCrossedSquares"));
            mInitMap.put(new Pair<String, String>("func_147747_a", "renderTorchAtAngle"));
            mInitMap.put(new Pair<String, String>("func_147748_a", "renderBlockRedstoneDiode"));
            mInitMap.put(new Pair<String, String>("func_147749_a", "renderBlockSandFalling"));
            mInitMap.put(new Pair<String, String>("func_147750_a", "renderPistonExtensionAllFaces"));
            mInitMap.put(new Pair<String, String>("func_147751_a", "renderStandardBlockWithAmbientOcclusion"));
            mInitMap.put(new Pair<String, String>("func_147752_a", "renderBlockFlowerpot"));
            mInitMap.put(new Pair<String, String>("func_147753_b", "setRenderAllFaces"));
            mInitMap.put(new Pair<String, String>("func_147754_e", "renderBlockCactusImpl"));
            mInitMap.put(new Pair<String, String>("func_147755_t", "renderBlockCactus"));
            mInitMap.put(new Pair<String, String>("func_147756_g", "renderBlockTripWire"));
            mInitMap.put(new Pair<String, String>("func_147757_a", "setOverrideBlockTexture"));
            mInitMap.put(new Pair<String, String>("func_147758_b", "getIconSafe"));
            mInitMap.put(new Pair<String, String>("func_147759_a", "renderBlockRepeater"));
            mInitMap.put(new Pair<String, String>("func_147760_u", "renderBlockDoor"));
            mInitMap.put(new Pair<String, String>("func_147761_c", "renderFaceZNeg"));
            mInitMap.put(new Pair<String, String>("func_147762_c", "unlockBlockBounds"));
            mInitMap.put(new Pair<String, String>("func_147763_a", "renderPistonRodUD"));
            mInitMap.put(new Pair<String, String>("func_147764_f", "renderFaceXPos"));
            mInitMap.put(new Pair<String, String>("func_147765_a", "drawCrossedSquares"));
            mInitMap.put(new Pair<String, String>("func_147766_a", "renderBlockMinecartTrack"));
            mInitMap.put(new Pair<String, String>("func_147767_a", "renderBlockPane"));
            mInitMap.put(new Pair<String, String>("func_147768_a", "renderFaceYNeg"));
            mInitMap.put(new Pair<String, String>("func_147769_a", "renderBlockAllFaces"));
            mInitMap.put(new Pair<String, String>("func_147770_b", "overrideBlockBounds"));
            mInitMap.put(new Pair<String, String>("func_147771_a", "clearOverrideBlockTexture"));
            mInitMap.put(new Pair<String, String>("func_147772_a", "renderBlockCocoa"));
            mInitMap.put(new Pair<String, String>("func_147773_v", "renderBlockBed"));
            mInitMap.put(new Pair<String, String>("func_147774_a", "renderBlockDoublePlant"));
            mInitMap.put(new Pair<String, String>("func_147775_a", "setRenderBoundsFromBlock"));
            mInitMap.put(new Pair<String, String>("func_147776_a", "renderBlockFenceGate"));
            mInitMap.put(new Pair<String, String>("func_147777_a", "getBlockIconFromSide"));
            mInitMap.put(new Pair<String, String>("func_147778_a", "getAoBrightness"));
            mInitMap.put(new Pair<String, String>("func_147779_s", "renderBlockQuartz"));
            mInitMap.put(new Pair<String, String>("func_147780_a", "renderBlockAnvilMetadata"));
            mInitMap.put(new Pair<String, String>("func_147781_a", "renderBlockRedstoneComparator"));
            mInitMap.put(new Pair<String, String>("func_147782_a", "setRenderBounds"));
            mInitMap.put(new Pair<String, String>("func_147783_o", "renderBlockLilyPad"));
            mInitMap.put(new Pair<String, String>("func_147784_q", "renderStandardBlock"));
            mInitMap.put(new Pair<String, String>("func_147785_a", "renderBlockCauldron"));
            mInitMap.put(new Pair<String, String>("func_147786_a", "setRenderFromInside"));
            mInitMap.put(new Pair<String, String>("func_147787_a", "getBlockIconFromSideAndMetadata"));
            mInitMap.put(new Pair<String, String>("func_147788_h", "renderBlockRedstomInitMap.put(newire"));
            mInitMap.put(new Pair<String, String>("func_147789_b", "renderPistonRodSN"));
            mInitMap.put(new Pair<String, String>("func_147790_e", "renderBlockLever"));
            mInitMap.put(new Pair<String, String>("func_147791_c", "renderBlockTorch"));
            mInitMap.put(new Pair<String, String>("func_147792_a", "renderBlockUsingTexture"));
            mInitMap.put(new Pair<String, String>("func_147793_a", "getBlockIcon"));
            mInitMap.put(new Pair<String, String>("func_147794_i", "renderBlockLadder"));
            mInitMap.put(new Pair<String, String>("func_147795_a", "renderBlockCropsImpl"));
            mInitMap.put(new Pair<String, String>("func_147796_n", "renderBlockCrops"));
            mInitMap.put(new Pair<String, String>("func_147797_a", "renderBlockBeacon"));
            mInitMap.put(new Pair<String, String>("func_147798_e", "renderFaceXNeg"));
            mInitMap.put(new Pair<String, String>("func_147799_a", "renderBlockHopperMetadata"));
            mInitMap.put(new Pair<String, String>("func_147800_a", "renderBlockAsItem"));
            mInitMap.put(new Pair<String, String>("func_147801_a", "renderBlockFire"));
            mInitMap.put(new Pair<String, String>("func_147802_a", "renderBlockDragonEgg"));
            mInitMap.put(new Pair<String, String>("func_147803_a", "renderBlockHopper"));
            mInitMap.put(new Pair<String, String>("func_147804_d", "renderPistonBaseAllFaces"));
            mInitMap.put(new Pair<String, String>("func_147805_b", "renderBlockByRenderType"));
            mInitMap.put(new Pair<String, String>("func_147806_b", "renderFaceYPos"));
            mInitMap.put(new Pair<String, String>("func_147807_a", "renderBlockWall"));
            mInitMap.put(new Pair<String, String>("func_147808_b", "renderStandardBlockWithAmbientOcclusionPartial"));
            mInitMap.put(new Pair<String, String>("func_147809_c", "renderPistonExtension"));
            mInitMap.put(new Pair<String, String>("func_147889_b", "updateRendererSort"));
            mInitMap.put(new Pair<String, String>("func_147890_b", "preRenderBlocks"));
            mInitMap.put(new Pair<String, String>("func_147891_a", "postRenderBlocks"));
            mInitMap.put(new Pair<String, String>("func_147892_a", "updateRenderer"));
            mInitMap.put(new Pair<String, String>("func_147905_a", "isStaticEntity"));
            mInitMap.put(new Pair<String, String>("func_147906_a", "renderLivingLabel"));
            mInitMap.put(new Pair<String, String>("func_147936_a", "renderEntityStatic"));
            mInitMap.put(new Pair<String, String>("func_147937_a", "renderEntitySimple"));
            mInitMap.put(new Pair<String, String>("func_147938_a", "cacheActiveRenderInfo"));
            mInitMap.put(new Pair<String, String>("func_147939_a", "doRenderEntity"));
            mInitMap.put(new Pair<String, String>("func_147940_a", "renderEntityWithPosYaw"));
            mInitMap.put(new Pair<String, String>("func_147942_a", "deleteTexture"));
            mInitMap.put(new Pair<String, String>("func_147946_a", "allocateTextureImpl"));
            mInitMap.put(new Pair<String, String>("func_147947_a", "uploadTextureSub"));
            mInitMap.put(new Pair<String, String>("func_147948_a", "prepareAnisotropicData"));
            mInitMap.put(new Pair<String, String>("func_147949_a", "generateMipmapData"));
        }

        private static void init2() {
            mInitMap.put(new Pair<String, String>("func_147951_b", "setTextureBlurred"));
            mInitMap.put(new Pair<String, String>("func_147955_a", "uploadTextureMipmap"));
            mInitMap.put(new Pair<String, String>("func_147960_a", "prepareAnisotropicFiltering"));
            mInitMap.put(new Pair<String, String>("func_147961_a", "fixTransparentPixels"));
            mInitMap.put(new Pair<String, String>("func_147962_a", "getFrameTextureData"));
            mInitMap.put(new Pair<String, String>("func_147963_d", "generateMipmaps"));
            mInitMap.put(new Pair<String, String>("func_147964_a", "loadSprite"));
            mInitMap.put(new Pair<String, String>("func_147965_a", "getFrameTextureData"));
            mInitMap.put(new Pair<String, String>("func_147969_b", "getMipmapDimension"));
            mInitMap.put(new Pair<String, String>("func_147984_b", "getShaderUniformOrDefault"));
            mInitMap.put(new Pair<String, String>("func_147985_d", "markDirty"));
            mInitMap.put(new Pair<String, String>("func_147986_h", "getProgram"));
            mInitMap.put(new Pair<String, String>("func_147987_b", "parseUniform"));
            mInitMap.put(new Pair<String, String>("func_147988_a", "deleteShader"));
            mInitMap.put(new Pair<String, String>("func_147989_e", "getVertexShaderLoader"));
            mInitMap.put(new Pair<String, String>("func_147990_i", "setupUniforms"));
            mInitMap.put(new Pair<String, String>("func_147991_a", "getShaderUniform"));
            mInitMap.put(new Pair<String, String>("func_147992_a", "addSamplerTexture"));
            mInitMap.put(new Pair<String, String>("func_147993_b", "endShader"));
            mInitMap.put(new Pair<String, String>("func_147994_f", "getFragmentShaderLoader"));
            mInitMap.put(new Pair<String, String>("func_147995_c", "useShader"));
            mInitMap.put(new Pair<String, String>("func_147996_a", "parseSampler"));
            mInitMap.put(new Pair<String, String>("func_148017_a", "getFramebuffer"));
            mInitMap.put(new Pair<String, String>("func_148018_a", "loadShaderGroup"));
            mInitMap.put(new Pair<String, String>("func_148020_a", "addFramebuffer"));
            mInitMap.put(new Pair<String, String>("func_148021_a", "deleteShaderGroup"));
            mInitMap.put(new Pair<String, String>("func_148022_b", "getShaderGroupName"));
            mInitMap.put(new Pair<String, String>("func_148023_a", "addShader"));
            mInitMap.put(new Pair<String, String>("func_148024_c", "resetProjectionMatrix"));
            mInitMap.put(new Pair<String, String>("func_148026_a", "createBindFramebuffers"));
            mInitMap.put(new Pair<String, String>("func_148027_a", "initTarget"));
            mInitMap.put(new Pair<String, String>("func_148028_c", "initUniform"));
            mInitMap.put(new Pair<String, String>("func_148040_d", "preLoadShader"));
            mInitMap.put(new Pair<String, String>("func_148041_a", "addAuxFramebuffer"));
            mInitMap.put(new Pair<String, String>("func_148042_a", "loadShader"));
            mInitMap.put(new Pair<String, String>("func_148043_c", "getShaderManager"));
            mInitMap.put(new Pair<String, String>("func_148044_b", "deleteShader"));
            mInitMap.put(new Pair<String, String>("func_148045_a", "setProjectionMatrix"));
            mInitMap.put(new Pair<String, String>("func_148054_b", "deleteShader"));
            mInitMap.put(new Pair<String, String>("func_148055_a", "getShaderFilename"));
            mInitMap.put(new Pair<String, String>("func_148056_a", "attachShader"));
            mInitMap.put(new Pair<String, String>("func_148057_a", "loadShader"));
            mInitMap.put(new Pair<String, String>("func_148062_a", "getShaderName"));
            mInitMap.put(new Pair<String, String>("func_148063_b", "getShaderExtension"));
            mInitMap.put(new Pair<String, String>("func_148064_d", "getLoadedShaders"));
            mInitMap.put(new Pair<String, String>("func_148065_c", "getShaderMode"));
            mInitMap.put(new Pair<String, String>("func_148074_b", "getStaticShaderLinkHelper"));
            mInitMap.put(new Pair<String, String>("func_148075_b", "linkProgram"));
            mInitMap.put(new Pair<String, String>("func_148076_a", "setmInitMap.put(newStaticShaderLinkHelper"));
            mInitMap.put(new Pair<String, String>("func_148077_a", "deleteShader"));
            mInitMap.put(new Pair<String, String>("func_148078_c", "createProgram"));
            mInitMap.put(new Pair<String, String>("func_148081_a", "set"));
            mInitMap.put(new Pair<String, String>("func_148082_k", "uploadFloatMatrix"));
            mInitMap.put(new Pair<String, String>("func_148083_a", "set"));
            mInitMap.put(new Pair<String, String>("func_148084_b", "setUniformLocation"));
            mInitMap.put(new Pair<String, String>("func_148085_a", "parseType"));
            mInitMap.put(new Pair<String, String>("func_148086_a", "getShaderName"));
            mInitMap.put(new Pair<String, String>("func_148087_a", "set"));
            mInitMap.put(new Pair<String, String>("func_148088_a", "set"));
            mInitMap.put(new Pair<String, String>("func_148089_j", "uploadFloat"));
            mInitMap.put(new Pair<String, String>("func_148090_a", "set"));
            mInitMap.put(new Pair<String, String>("func_148091_i", "uploadInt"));
            mInitMap.put(new Pair<String, String>("func_148093_b", "upload"));
            mInitMap.put(new Pair<String, String>("func_148094_a", "set"));
            mInitMap.put(new Pair<String, String>("func_148095_a", "set"));
            mInitMap.put(new Pair<String, String>("func_148096_h", "markDirty"));
            mInitMap.put(new Pair<String, String>("func_148097_a", "set"));
            mInitMap.put(new Pair<String, String>("func_148120_b", "drawSelectionBox"));
            mInitMap.put(new Pair<String, String>("func_148121_k", "bindAmountScrolled"));
            mInitMap.put(new Pair<String, String>("func_148122_a", "setDimensions"));
            mInitMap.put(new Pair<String, String>("func_148123_a", "drawBackground"));
            mInitMap.put(new Pair<String, String>("func_148124_c", "getSlotIndexFromScreenCoords"));
            mInitMap.put(new Pair<String, String>("func_148125_i", "getEnabled"));
            mInitMap.put(new Pair<String, String>("func_148126_a", "drawSlot"));
            mInitMap.put(new Pair<String, String>("func_148127_b", "getSize"));
            mInitMap.put(new Pair<String, String>("func_148128_a", "drawScreen"));
            mInitMap.put(new Pair<String, String>("func_148129_a", "drawListHeader"));
            mInitMap.put(new Pair<String, String>("func_148130_a", "setShowSelectionBox"));
            mInitMap.put(new Pair<String, String>("func_148131_a", "isSelected"));
            mInitMap.put(new Pair<String, String>("func_148133_a", "setHasListHeader"));
            mInitMap.put(new Pair<String, String>("func_148134_d", "registerScrollButtons"));
            mInitMap.put(new Pair<String, String>("func_148136_c", "overlayBackground"));
            mInitMap.put(new Pair<String, String>("func_148137_d", "getScrollBarX"));
            mInitMap.put(new Pair<String, String>("func_148138_e", "getContentHeight"));
            mInitMap.put(new Pair<String, String>("func_148139_c", "getListWidth"));
            mInitMap.put(new Pair<String, String>("func_148140_g", "setSlotXBoundsFromLeft"));
            mInitMap.put(new Pair<String, String>("func_148141_e", "isMouseYWithinSlotBounds"));
            mInitMap.put(new Pair<String, String>("func_148143_b", "setEnabled"));
            mInitMap.put(new Pair<String, String>("func_148144_a", "elementClicked"));
            mInitMap.put(new Pair<String, String>("func_148145_f", "scrollBy"));
            mInitMap.put(new Pair<String, String>("func_148146_j", "getSlotHeight"));
            mInitMap.put(new Pair<String, String>("func_148147_a", "actionPerformed"));
            mInitMap.put(new Pair<String, String>("func_148148_g", "getAmountScrolled"));
            mInitMap.put(new Pair<String, String>("func_148180_b", "getListEntry"));
            mInitMap.put(new Pair<String, String>("func_148201_l", "getList"));
            mInitMap.put(new Pair<String, String>("func_148202_k", "getListHeader"));
            mInitMap.put(new Pair<String, String>("func_148254_d", "getToken"));
            mInitMap.put(new Pair<String, String>("func_148255_b", "getPlayerID"));
            mInitMap.put(new Pair<String, String>("func_148256_e", "getProfile"));
            mInitMap.put(new Pair<String, String>("func_148259_a", "saveScreenshot"));
            mInitMap.put(new Pair<String, String>("func_148260_a", "saveScreenshot"));
            mInitMap.put(new Pair<String, String>("func_148262_d", "denormalizeValue"));
            mInitMap.put(new Pair<String, String>("func_148263_a", "setValueMax"));
            mInitMap.put(new Pair<String, String>("func_148264_f", "snapToStep"));
            mInitMap.put(new Pair<String, String>("func_148266_c", "normalizeValue"));
            mInitMap.put(new Pair<String, String>("func_148267_f", "getValueMax"));
            mInitMap.put(new Pair<String, String>("func_148268_e", "snapToStepClamp"));
            mInitMap.put(new Pair<String, String>("func_148277_b", "mouseReleased"));
            mInitMap.put(new Pair<String, String>("func_148278_a", "mousePressed"));
            mInitMap.put(new Pair<String, String>("func_148279_a", "drawEntry"));
            mInitMap.put(new Pair<String, String>("func_148289_a", "getLanServer"));
            mInitMap.put(new Pair<String, String>("func_148296_a", "getServerData"));
            mInitMap.put(new Pair<String, String>("func_148297_b", "prepareServerIcon"));
            mInitMap.put(new Pair<String, String>("func_148329_a", "scrollTo"));
            mInitMap.put(new Pair<String, String>("func_148334_a", "generatemInitMap.put(newRandomName"));
            mInitMap.put(new Pair<String, String>("func_148335_a", "reseedRandomGenerator"));
            mInitMap.put(new Pair<String, String>("func_148522_a", "onDownloadComplete"));
            mInitMap.put(new Pair<String, String>("func_148526_a", "obtainResourcePack"));
            mInitMap.put(new Pair<String, String>("func_148530_e", "getResourcePackInstance"));
            mInitMap.put(new Pair<String, String>("func_148535_c", "getListMipmaps"));
            mInitMap.put(new Pair<String, String>("func_148537_a", "sendPacketToAllPlayersInDimension"));
            mInitMap.put(new Pair<String, String>("func_148539_a", "sendChatMsg"));
            mInitMap.put(new Pair<String, String>("func_148540_a", "sendPacketToAllPlayers"));
            mInitMap.put(new Pair<String, String>("func_148541_a", "sendToAllNear"));
            mInitMap.put(new Pair<String, String>("func_148542_a", "allowUserToConnect"));
            mInitMap.put(new Pair<String, String>("func_148543_a", "sendToAllNearExcept"));
            mInitMap.put(new Pair<String, String>("func_148544_a", "sendChatMsgImpl"));
            mInitMap.put(new Pair<String, String>("func_148545_a", "createPlayerForUser"));
            mInitMap.put(new Pair<String, String>("func_148552_f", "isStreaming"));
            mInitMap.put(new Pair<String, String>("func_148553_a", "setSoundEntryVolume"));
            mInitMap.put(new Pair<String, String>("func_148554_a", "setSoundEntryWeight"));
            mInitMap.put(new Pair<String, String>("func_148555_d", "getSoundEntryWeight"));
            mInitMap.put(new Pair<String, String>("func_148556_a", "getSoundEntryName"));
            mInitMap.put(new Pair<String, String>("func_148557_a", "setStreaming"));
            mInitMap.put(new Pair<String, String>("func_148558_b", "getSoundEntryVolume"));
            mInitMap.put(new Pair<String, String>("func_148559_b", "setSoundEntryPitch"));
            mInitMap.put(new Pair<String, String>("func_148560_c", "getSoundEntryPitch"));
            mInitMap.put(new Pair<String, String>("func_148561_a", "setSoundEntryName"));
            mInitMap.put(new Pair<String, String>("func_148562_a", "setSoundEntryType"));
            mInitMap.put(new Pair<String, String>("func_148563_e", "getSoundEntryType"));
            mInitMap.put(new Pair<String, String>("func_148570_a", "getSoundList"));
            mInitMap.put(new Pair<String, String>("func_148571_a", "setSoundCategory"));
            mInitMap.put(new Pair<String, String>("func_148572_a", "setReplaceExisting"));
            mInitMap.put(new Pair<String, String>("func_148573_c", "getSoundCategory"));
            mInitMap.put(new Pair<String, String>("func_148574_b", "canReplaceExisting"));
            mInitMap.put(new Pair<String, String>("func_148580_a", "getType"));
            mInitMap.put(new Pair<String, String>("func_148586_a", "getTypeInt"));
            mInitMap.put(new Pair<String, String>("func_148594_a", "getNormalizedVolume"));
            mInitMap.put(new Pair<String, String>("func_148595_a", "getSoundCategoryVolume"));
            mInitMap.put(new Pair<String, String>("func_148596_a", "reloadSoundSystem"));
            mInitMap.put(new Pair<String, String>("func_148597_a", "isSoundPlaying"));
            mInitMap.put(new Pair<String, String>("func_148599_a", "playDelayedSound"));
            mInitMap.put(new Pair<String, String>("func_148601_a", "setSoundCategoryVolume"));
            mInitMap.put(new Pair<String, String>("func_148602_b", "stopSound"));
            mInitMap.put(new Pair<String, String>("func_148604_f", "resumeAllSounds"));
            mInitMap.put(new Pair<String, String>("func_148605_d", "updateAllSounds"));
            mInitMap.put(new Pair<String, String>("func_148606_a", "getNormalizedPitch"));
            mInitMap.put(new Pair<String, String>("func_148608_i", "loadSoundSystem"));
            mInitMap.put(new Pair<String, String>("func_148610_e", "pauseAllSounds"));
            mInitMap.put(new Pair<String, String>("func_148611_c", "playSound"));
            mInitMap.put(new Pair<String, String>("func_148612_a", "getURLForSoundResource"));
            mInitMap.put(new Pair<String, String>("func_148613_b", "unloadSoundSystem"));
            mInitMap.put(new Pair<String, String>("func_148614_c", "stopAllSounds"));
            mInitMap.put(new Pair<String, String>("func_148615_a", "setListener"));
            mInitMap.put(new Pair<String, String>("func_148633_c", "getMaxDelay"));
            mInitMap.put(new Pair<String, String>("func_148634_b", "getMinDelay"));
            mInitMap.put(new Pair<String, String>("func_148635_a", "getMusicTickerLocation"));
            mInitMap.put(new Pair<String, String>("func_148647_b", "setVolume"));
            mInitMap.put(new Pair<String, String>("func_148648_d", "isStreamingSound"));
            mInitMap.put(new Pair<String, String>("func_148649_c", "getVolume"));
            mInitMap.put(new Pair<String, String>("func_148650_b", "getPitch"));
            mInitMap.put(new Pair<String, String>("func_148651_a", "setPitch"));
            mInitMap.put(new Pair<String, String>("func_148652_a", "getSoundPoolEntryLocation"));
            mInitMap.put(new Pair<String, String>("func_148727_a", "addSoundToEventPool"));
            mInitMap.put(new Pair<String, String>("func_148728_d", "getSoundCategory"));
            mInitMap.put(new Pair<String, String>("func_148729_c", "getSoundEventLocation"));
            mInitMap.put(new Pair<String, String>("func_148740_a", "createUnderlyingMap"));
            mInitMap.put(new Pair<String, String>("func_148741_d", "containsKey"));
            mInitMap.put(new Pair<String, String>("func_148742_b", "getKeys"));
            mInitMap.put(new Pair<String, String>("func_148750_c", "getNameForObject"));
            mInitMap.put(new Pair<String, String>("func_148753_b", "containsId"));
            mInitMap.put(new Pair<String, String>("func_148754_a", "getObjectById"));
            mInitMap.put(new Pair<String, String>("func_148755_c", "ensureNamespaced"));
            mInitMap.put(new Pair<String, String>("func_148756_a", "addObject"));
            mInitMap.put(new Pair<String, String>("func_148757_b", "getIDForObject"));
            mInitMap.put(new Pair<String, String>("func_148762_a", "registerSound"));
            mInitMap.put(new Pair<String, String>("func_148763_c", "clearMap"));
            mInitMap.put(new Pair<String, String>("func_148821_a", "glBlendFunc"));
            mInitMap.put(new Pair<String, String>("func_148822_b", "isFramebufferEnabled"));
            mInitMap.put(new Pair<String, String>("func_148833_a", "processPacket"));
            mInitMap.put(new Pair<String, String>("func_148834_a", "readBlob"));
            mInitMap.put(new Pair<String, String>("func_148835_b", "serialize"));
            mInitMap.put(new Pair<String, String>("func_148836_a", "hasPriority"));
            mInitMap.put(new Pair<String, String>("func_148837_a", "readPacketData"));
            mInitMap.put(new Pair<String, String>("func_148838_a", "writeBlob"));
            mInitMap.put(new Pair<String, String>("func_148839_a", "generatePacket"));
            mInitMap.put(new Pair<String, String>("func_148840_b", "writePacketData"));
            mInitMap.put(new Pair<String, String>("func_148853_f", "getTileEntityType"));
            mInitMap.put(new Pair<String, String>("func_148854_e", "getZ"));
            mInitMap.put(new Pair<String, String>("func_148855_d", "getY"));
            mInitMap.put(new Pair<String, String>("func_148856_c", "getX"));
            mInitMap.put(new Pair<String, String>("func_148857_g", "getNbtCompound"));
            mInitMap.put(new Pair<String, String>("func_148864_h", "getData2"));
            mInitMap.put(new Pair<String, String>("func_148865_f", "getZ"));
            mInitMap.put(new Pair<String, String>("func_148866_e", "getY"));
            mInitMap.put(new Pair<String, String>("func_148867_d", "getX"));
            mInitMap.put(new Pair<String, String>("func_148868_c", "getBlockType"));
            mInitMap.put(new Pair<String, String>("func_148869_g", "getData1"));
            mInitMap.put(new Pair<String, String>("func_148916_d", "isChat"));
            mInitMap.put(new Pair<String, String>("func_149089_e", "getZ"));
            mInitMap.put(new Pair<String, String>("func_149090_d", "getY"));
            mInitMap.put(new Pair<String, String>("func_149091_a", "getPlayer"));
            mInitMap.put(new Pair<String, String>("func_149092_c", "getX"));
            mInitMap.put(new Pair<String, String>("func_149101_g", "getFlySpeed"));
            mInitMap.put(new Pair<String, String>("func_149102_b", "setFlying"));
            mInitMap.put(new Pair<String, String>("func_149103_f", "isCreativeMode"));
            mInitMap.put(new Pair<String, String>("func_149104_a", "setFlySpeed"));
            mInitMap.put(new Pair<String, String>("func_149105_e", "isAllowFlying"));
            mInitMap.put(new Pair<String, String>("func_149106_d", "isFlying"));
            mInitMap.put(new Pair<String, String>("func_149107_h", "getWalkSpeed"));
            mInitMap.put(new Pair<String, String>("func_149108_a", "setInvulnerable"));
            mInitMap.put(new Pair<String, String>("func_149109_c", "setAllowFlying"));
            mInitMap.put(new Pair<String, String>("func_149110_b", "setWalkSpeed"));
            mInitMap.put(new Pair<String, String>("func_149111_d", "setCreativeMode"));
            mInitMap.put(new Pair<String, String>("func_149112_c", "isInvulnerable"));
            mInitMap.put(new Pair<String, String>("func_149187_d", "getData"));
            mInitMap.put(new Pair<String, String>("func_149188_c", "getMapId"));
            mInitMap.put(new Pair<String, String>("func_149239_h", "getPosZ"));
            mInitMap.put(new Pair<String, String>("func_149240_f", "getPosX"));
            mInitMap.put(new Pair<String, String>("func_149241_e", "getSoundData"));
            mInitMap.put(new Pair<String, String>("func_149242_d", "getSoundType"));
            mInitMap.put(new Pair<String, String>("func_149243_g", "getPosY"));
            mInitMap.put(new Pair<String, String>("func_149244_c", "isSoundServerwide"));
            mInitMap.put(new Pair<String, String>("func_149289_c", "getClientTime"));
            mInitMap.put(new Pair<String, String>("func_149304_c", "getProfile"));
            mInitMap.put(new Pair<String, String>("func_149330_d", "getFoodLevel"));
            mInitMap.put(new Pair<String, String>("func_149331_e", "getSaturationLevel"));
            mInitMap.put(new Pair<String, String>("func_149332_c", "getHealth"));
            mInitMap.put(new Pair<String, String>("func_149419_c", "getMessage"));
            mInitMap.put(new Pair<String, String>("func_149421_d", "getType"));
            mInitMap.put(new Pair<String, String>("func_149435_c", "getStatus"));
            mInitMap.put(new Pair<String, String>("func_149439_c", "getMessage"));
            mInitMap.put(new Pair<String, String>("func_149460_c", "getKey"));
            mInitMap.put(new Pair<String, String>("func_149462_g", "getYaw"));
            mInitMap.put(new Pair<String, String>("func_149463_k", "getRotating"));
            mInitMap.put(new Pair<String, String>("func_149464_c", "getPositionX"));
            mInitMap.put(new Pair<String, String>("func_149467_d", "getPositionY"));
            mInitMap.put(new Pair<String, String>("func_149470_h", "getPitch"));
            mInitMap.put(new Pair<String, String>("func_149471_f", "getStance"));
            mInitMap.put(new Pair<String, String>("func_149472_e", "getPositionZ"));
            mInitMap.put(new Pair<String, String>("func_149482_g", "getFlySpeed"));
            mInitMap.put(new Pair<String, String>("func_149483_b", "setFlying"));
            mInitMap.put(new Pair<String, String>("func_149484_f", "isCreativeMode"));
            mInitMap.put(new Pair<String, String>("func_149485_a", "setFlySpeed"));
            mInitMap.put(new Pair<String, String>("func_149486_e", "isAllowFlying"));
            mInitMap.put(new Pair<String, String>("func_149488_d", "isFlying"));
            mInitMap.put(new Pair<String, String>("func_149489_h", "getWalkSpeed"));
            mInitMap.put(new Pair<String, String>("func_149490_a", "setInvulnerable"));
            mInitMap.put(new Pair<String, String>("func_149491_c", "setAllowFlying"));
            mInitMap.put(new Pair<String, String>("func_149492_b", "setWalkSpeed"));
            mInitMap.put(new Pair<String, String>("func_149493_d", "setCreativeMode"));
            mInitMap.put(new Pair<String, String>("func_149494_c", "isInvulnerable"));
            mInitMap.put(new Pair<String, String>("func_149501_f", "getDiggingBlockFace"));
            mInitMap.put(new Pair<String, String>("func_149502_e", "getDiggedBlockZ"));
            mInitMap.put(new Pair<String, String>("func_149503_d", "getDiggedBlockY"));
            mInitMap.put(new Pair<String, String>("func_149505_c", "getDiggedBlockX"));
            mInitMap.put(new Pair<String, String>("func_149506_g", "getDiggedBlockStatus"));
            mInitMap.put(new Pair<String, String>("func_149518_g", "getDifficulty"));
            mInitMap.put(new Pair<String, String>("func_149519_h", "isShowCape"));
            mInitMap.put(new Pair<String, String>("func_149520_f", "isColorsEnabled"));
            mInitMap.put(new Pair<String, String>("func_149521_d", "getView"));
            mInitMap.put(new Pair<String, String>("func_149523_e", "getChatVisibility"));
            mInitMap.put(new Pair<String, String>("func_149524_c", "getLang"));
            mInitMap.put(new Pair<String, String>("func_149532_c", "getId"));
            mInitMap.put(new Pair<String, String>("func_149533_d", "getUid"));
            mInitMap.put(new Pair<String, String>("func_149537_d", "getButton"));
            mInitMap.put(new Pair<String, String>("func_149539_c", "getId"));
            mInitMap.put(new Pair<String, String>("func_149542_h", "getMode"));
            mInitMap.put(new Pair<String, String>("func_149543_e", "getUsedButton"));
            mInitMap.put(new Pair<String, String>("func_149544_d", "getSlotId"));
            mInitMap.put(new Pair<String, String>("func_149546_g", "getClickedItem"));
            mInitMap.put(new Pair<String, String>("func_149547_f", "getActionNumber"));
            mInitMap.put(new Pair<String, String>("func_149548_c", "getWindowId"));
            mInitMap.put(new Pair<String, String>("func_149558_e", "getData"));
            mInitMap.put(new Pair<String, String>("func_149559_c", "getChannel"));
            mInitMap.put(new Pair<String, String>("func_149564_a", "getEntityFromWorld"));
            mInitMap.put(new Pair<String, String>("func_149565_c", "getAction"));
            mInitMap.put(new Pair<String, String>("func_149568_f", "getPlacedBlockDirection"));
            mInitMap.put(new Pair<String, String>("func_149569_i", "getPlacedBlockOffsetY"));
            mInitMap.put(new Pair<String, String>("func_149570_e", "getPlacedBlockZ"));
            mInitMap.put(new Pair<String, String>("func_149571_d", "getPlacedBlockY"));
            mInitMap.put(new Pair<String, String>("func_149573_h", "getPlacedBlockOffsetX"));
            mInitMap.put(new Pair<String, String>("func_149574_g", "getStack"));
            mInitMap.put(new Pair<String, String>("func_149575_j", "getPlacedBlockOffsetZ"));
            mInitMap.put(new Pair<String, String>("func_149576_c", "getPlacedBlockX"));
            mInitMap.put(new Pair<String, String>("func_149585_e", "getZ"));
            mInitMap.put(new Pair<String, String>("func_149586_d", "getY"));
            mInitMap.put(new Pair<String, String>("func_149588_c", "getX"));
            mInitMap.put(new Pair<String, String>("func_149589_f", "getLines"));
            mInitMap.put(new Pair<String, String>("func_149594_c", "getRequestedState"));
            mInitMap.put(new Pair<String, String>("func_149595_d", "getProtocolVersion"));
            mInitMap.put(new Pair<String, String>("func_149614_c", "getSlotId"));
            mInitMap.put(new Pair<String, String>("func_149616_d", "getForwardSpeed"));
            mInitMap.put(new Pair<String, String>("func_149617_f", "isSneaking"));
            mInitMap.put(new Pair<String, String>("func_149618_e", "isJumping"));
            mInitMap.put(new Pair<String, String>("func_149620_c", "getStrafeSpeed"));
            mInitMap.put(new Pair<String, String>("func_149625_d", "getStack"));
            mInitMap.put(new Pair<String, String>("func_149627_c", "getSlotId"));
            mInitMap.put(new Pair<String, String>("func_149633_g", "getSelectedBoundingBoxFromPool"));
            mInitMap.put(new Pair<String, String>("func_149634_a", "getBlockFromItem"));
            mInitMap.put(new Pair<String, String>("func_149635_D", "getBlockColor"));
            mInitMap.put(new Pair<String, String>("func_149636_a", "harvestBlock"));
            mInitMap.put(new Pair<String, String>("func_149637_q", "isBlockNormalCube"));
            mInitMap.put(new Pair<String, String>("func_149638_a", "getExplosionResistance"));
            mInitMap.put(new Pair<String, String>("func_149639_l", "fillWithRain"));
            mInitMap.put(new Pair<String, String>("func_149640_a", "modifyEntityVelocity"));
            mInitMap.put(new Pair<String, String>("func_149641_N", "getTextureName"));
            mInitMap.put(new Pair<String, String>("func_149642_a", "dropBlockAsItem"));
            mInitMap.put(new Pair<String, String>("func_149643_k", "getDamageValue"));
            mInitMap.put(new Pair<String, String>("func_149644_j", "createStackedBlock"));
            mInitMap.put(new Pair<String, String>("func_149645_b", "getRenderType"));
            mInitMap.put(new Pair<String, String>("func_149646_a", "shouldSideBeRendered"));
            mInitMap.put(new Pair<String, String>("func_149647_a", "setCreativeTab"));
            mInitMap.put(new Pair<String, String>("func_149648_K", "isFlowerPot"));
            mInitMap.put(new Pair<String, String>("func_149649_H", "disableStats"));
            mInitMap.put(new Pair<String, String>("func_149650_a", "getItemDropped"));
            mInitMap.put(new Pair<String, String>("func_149651_a", "registerIcons"));
            mInitMap.put(new Pair<String, String>("func_149652_G", "getEnableStats"));
            mInitMap.put(new Pair<String, String>("func_149653_t", "getTickRandomly"));
            mInitMap.put(new Pair<String, String>("func_149654_a", "isVecInsideYZBounds"));
            mInitMap.put(new Pair<String, String>("func_149655_b", "isPassable"));
            mInitMap.put(new Pair<String, String>("func_149656_h", "getMobilityFlag"));
            mInitMap.put(new Pair<String, String>("func_149657_c", "dropXpOnBlockBreak"));
            mInitMap.put(new Pair<String, String>("func_149658_d", "setTextureName"));
            mInitMap.put(new Pair<String, String>("func_149659_a", "canDropFromExplosion"));
            mInitMap.put(new Pair<String, String>("func_149660_a", "onBlockPlaced"));
            mInitMap.put(new Pair<String, String>("func_149661_c", "isVecInsideXYBounds"));
            mInitMap.put(new Pair<String, String>("func_149662_c", "isOpaqueCube"));
            mInitMap.put(new Pair<String, String>("func_149663_c", "setUnlocalizedName"));
            mInitMap.put(new Pair<String, String>("func_149664_b", "onBlockDestroyedByPlayer"));
            mInitMap.put(new Pair<String, String>("func_149665_z", "getBlockBoundsMinY"));
            mInitMap.put(new Pair<String, String>("func_149666_a", "getSubBlocks"));
            mInitMap.put(new Pair<String, String>("func_149667_c", "isAssociatedBlock"));
            mInitMap.put(new Pair<String, String>("func_149668_a", "getCollisionBoundingBoxFromPool"));
            mInitMap.put(new Pair<String, String>("func_149669_A", "getBlockBoundsMaxY"));
            mInitMap.put(new Pair<String, String>("func_149670_a", "onEntityCollidedWithBlock"));
            mInitMap.put(new Pair<String, String>("func_149671_p", "registerBlocks"));
            mInitMap.put(new Pair<String, String>("func_149672_a", "setStepSound"));
            mInitMap.put(new Pair<String, String>("func_149673_e", "getIcon"));
            mInitMap.put(new Pair<String, String>("func_149674_a", "updateTick"));
            mInitMap.put(new Pair<String, String>("func_149675_a", "setTickRandomly"));
            mInitMap.put(new Pair<String, String>("func_149676_a", "setBlockBounds"));
            mInitMap.put(new Pair<String, String>("func_149677_c", "getMixedBrightnessForBlock"));
            mInitMap.put(new Pair<String, String>("func_149678_a", "canStopRayTrace"));
            mInitMap.put(new Pair<String, String>("func_149679_a", "quantityDroppedWithBonus"));
            mInitMap.put(new Pair<String, String>("func_149680_a", "isEqualTo"));
            mInitMap.put(new Pair<String, String>("func_149681_a", "onBlockHarvested"));
            mInitMap.put(new Pair<String, String>("func_149682_b", "getIdFromBlock"));
            mInitMap.put(new Pair<String, String>("func_149683_g", "setBlockBoundsForItemRender"));
            mInitMap.put(new Pair<String, String>("func_149684_b", "getBlockFromName"));
            mInitMap.put(new Pair<String, String>("func_149685_I", "getAmbientOcclusionLightValue"));
            mInitMap.put(new Pair<String, String>("func_149686_d", "renderAsNormalBlock"));
            mInitMap.put(new Pair<String, String>("func_149687_b", "isVecInsideXZBounds"));
            mInitMap.put(new Pair<String, String>("func_149688_o", "getMaterial"));
            mInitMap.put(new Pair<String, String>("func_149689_a", "onBlockPlacedBy"));
            mInitMap.put(new Pair<String, String>("func_149690_a", "dropBlockAsItemWithChance"));
            mInitMap.put(new Pair<String, String>("func_149691_a", "getIcon"));
            mInitMap.put(new Pair<String, String>("func_149692_a", "damageDropped"));
            mInitMap.put(new Pair<String, String>("func_149693_C", "getBlockBoundsMaxZ"));
            mInitMap.put(new Pair<String, String>("func_149694_d", "getItem"));
            mInitMap.put(new Pair<String, String>("func_149695_a", "onNeighborBlockChange"));
            mInitMap.put(new Pair<String, String>("func_149696_a", "onBlockEventReceived"));
            mInitMap.put(new Pair<String, String>("func_149697_b", "dropBlockAsItem"));
            mInitMap.put(new Pair<String, String>("func_149698_L", "requiresUpdates"));
            mInitMap.put(new Pair<String, String>("func_149699_a", "onBlockClicked"));
            mInitMap.put(new Pair<String, String>("func_149700_E", "canSilkHarvest"));
            mInitMap.put(new Pair<String, String>("func_149701_w", "getRenderBlockPass"));
            mInitMap.put(new Pair<String, String>("func_149702_O", "getItemIconName"));
            mInitMap.put(new Pair<String, String>("func_149703_v", "isCollidable"));
            mInitMap.put(new Pair<String, String>("func_149704_x", "getBlockBoundsMinX"));
            mInitMap.put(new Pair<String, String>("func_149705_a", "canReplace"));
            mInitMap.put(new Pair<String, String>("func_149706_B", "getBlockBoundsMinZ"));
            mInitMap.put(new Pair<String, String>("func_149707_d", "canPlaceBlockOnSide"));
            mInitMap.put(new Pair<String, String>("func_149708_J", "getCreativeTabToDisplayOn"));
            mInitMap.put(new Pair<String, String>("func_149709_b", "isProvidingWeakPower"));
            mInitMap.put(new Pair<String, String>("func_149710_n", "getUseNeighborBrightness"));
            mInitMap.put(new Pair<String, String>("func_149711_c", "setHardness"));
            mInitMap.put(new Pair<String, String>("func_149712_f", "getBlockHardness"));
            mInitMap.put(new Pair<String, String>("func_149713_g", "setLightOpacity"));
            mInitMap.put(new Pair<String, String>("func_149714_e", "onPostBlockPlaced"));
            mInitMap.put(new Pair<String, String>("func_149715_a", "setLightLevel"));
            mInitMap.put(new Pair<String, String>("func_149716_u", "hasTileEntity"));
            mInitMap.put(new Pair<String, String>("func_149717_k", "getLightOpacity"));
            mInitMap.put(new Pair<String, String>("func_149718_j", "canBlockStay"));
            mInitMap.put(new Pair<String, String>("func_149719_a", "setBlockBoundsBasedOnState"));
            mInitMap.put(new Pair<String, String>("func_149720_d", "colorMultiplier"));
            mInitMap.put(new Pair<String, String>("func_149721_r", "isNormalCube"));
            mInitMap.put(new Pair<String, String>("func_149722_s", "setBlockUnbreakable"));
            mInitMap.put(new Pair<String, String>("func_149723_a", "onBlockDestroyedByExplosion"));
            mInitMap.put(new Pair<String, String>("func_149724_b", "onEntityWalking"));
            mInitMap.put(new Pair<String, String>("func_149725_f", "onBlockPreDestroy"));
            mInitMap.put(new Pair<String, String>("func_149726_b", "onBlockAdded"));
            mInitMap.put(new Pair<String, String>("func_149727_a", "onBlockActivated"));
            mInitMap.put(new Pair<String, String>("func_149728_f", "getMapColor"));
            mInitMap.put(new Pair<String, String>("func_149729_e", "getBlockById"));
            mInitMap.put(new Pair<String, String>("func_149730_j", "isFullBlock"));
            mInitMap.put(new Pair<String, String>("func_149731_a", "collisionRayTrace"));
            mInitMap.put(new Pair<String, String>("func_149732_F", "getLocalizedName"));
            mInitMap.put(new Pair<String, String>("func_149733_h", "getBlockTextureFromSide"));
            mInitMap.put(new Pair<String, String>("func_149734_b", "randomDisplayTick"));
            mInitMap.put(new Pair<String, String>("func_149735_b", "getItemIcon"));
            mInitMap.put(new Pair<String, String>("func_149736_g", "getComparatorInputOverride"));
            mInitMap.put(new Pair<String, String>("func_149737_a", "getPlayerRelativeBlockHardness"));
            mInitMap.put(new Pair<String, String>("func_149738_a", "tickRate"));
            mInitMap.put(new Pair<String, String>("func_149739_a", "getUnlocalizedName"));
            mInitMap.put(new Pair<String, String>("func_149740_M", "hasComparatorInputOverride"));
            mInitMap.put(new Pair<String, String>("func_149741_i", "getRenderColor"));
            mInitMap.put(new Pair<String, String>("func_149742_c", "canPlaceBlockAt"));
            mInitMap.put(new Pair<String, String>("func_149743_a", "addCollisionBoxesToList"));
            mInitMap.put(new Pair<String, String>("func_149744_f", "canProvidePower"));
            mInitMap.put(new Pair<String, String>("func_149745_a", "quantityDropped"));
            mInitMap.put(new Pair<String, String>("func_149746_a", "onFallenUpon"));
            mInitMap.put(new Pair<String, String>("func_149747_d", "isBlockSolid"));
            mInitMap.put(new Pair<String, String>("func_149748_c", "isProvidingStrongPower"));
            mInitMap.put(new Pair<String, String>("func_149749_a", "breakBlock"));
            mInitMap.put(new Pair<String, String>("func_149750_m", "getLightValue"));
            mInitMap.put(new Pair<String, String>("func_149751_l", "isTranslucent"));
            mInitMap.put(new Pair<String, String>("func_149752_b", "setResistance"));
            mInitMap.put(new Pair<String, String>("func_149753_y", "getBlockBoundsMaxX"));
            mInitMap.put(new Pair<String, String>("func_149798_e", "getEffectiveFlowDecay"));
            mInitMap.put(new Pair<String, String>("func_149800_f", "getFlowVector"));
            mInitMap.put(new Pair<String, String>("func_149801_b", "getLiquidHeightPercent"));
            mInitMap.put(new Pair<String, String>("func_149802_a", "getFlowDirection"));
            mInitMap.put(new Pair<String, String>("func_149803_e", "getLiquidIcon"));
            mInitMap.put(new Pair<String, String>("func_149817_o", "isFlammable"));
            mInitMap.put(new Pair<String, String>("func_149818_n", "setNotStationary"));
            mInitMap.put(new Pair<String, String>("func_149819_b", "invertMetadata"));
            mInitMap.put(new Pair<String, String>("func_149825_a", "isFence"));
            mInitMap.put(new Pair<String, String>("func_149826_e", "canConnectFenceTo"));
            mInitMap.put(new Pair<String, String>("func_149828_a", "playSoundWhenFallen"));
            mInitMap.put(new Pair<String, String>("func_149829_a", "onStartFalling"));
            mInitMap.put(new Pair<String, String>("func_149831_e", "canFallBelow"));
            mInitMap.put(new Pair<String, String>("func_149840_c", "getFireIcon"));
            mInitMap.put(new Pair<String, String>("func_149841_a", "tryCatchFire"));
            mInitMap.put(new Pair<String, String>("func_149844_e", "canBlockCatchFire"));
            mInitMap.put(new Pair<String, String>("func_149845_m", "getChanceOfNeighborsEncouragingFire"));
            mInitMap.put(new Pair<String, String>("func_149847_e", "canNeighborBurn"));
            mInitMap.put(new Pair<String, String>("func_149851_a", "canFertilize"));
            mInitMap.put(new Pair<String, String>("func_149852_a", "shouldFertilize"));
            mInitMap.put(new Pair<String, String>("func_149853_b", "fertilize"));
            mInitMap.put(new Pair<String, String>("func_149854_a", "canPlaceBlockOn"));
            mInitMap.put(new Pair<String, String>("func_149855_e", "checkAndDropBlock"));
            mInitMap.put(new Pair<String, String>("func_149863_m", "fertilize"));
            mInitMap.put(new Pair<String, String>("func_149865_P", "getCrop"));
            mInitMap.put(new Pair<String, String>("func_149866_i", "getSeed"));
            mInitMap.put(new Pair<String, String>("func_149872_i", "getStemIcon"));
            mInitMap.put(new Pair<String, String>("func_149873_e", "getState"));
            mInitMap.put(new Pair<String, String>("func_149874_m", "fertilizeStem"));
            mInitMap.put(new Pair<String, String>("func_149878_d", "growTree"));
            mInitMap.put(new Pair<String, String>("func_149879_c", "markOrGrowMarked"));
            mInitMap.put(new Pair<String, String>("func_149884_c", "fertilizeMushroom"));
            mInitMap.put(new Pair<String, String>("func_149895_l", "getDirection"));
            mInitMap.put(new Pair<String, String>("func_149896_b", "isFenceGateOpen"));
            mInitMap.put(new Pair<String, String>("func_149898_i", "getBlockUnpowered"));
            mInitMap.put(new Pair<String, String>("func_149900_a", "isGettingInput"));
            mInitMap.put(new Pair<String, String>("func_149903_h", "getInputStrength"));
            mInitMap.put(new Pair<String, String>("func_149906_e", "getBlockPowered"));
            mInitMap.put(new Pair<String, String>("func_149909_d", "isRedstoneRepeaterBlockID"));
            mInitMap.put(new Pair<String, String>("func_149915_a", "createmInitMap.put(newTileEntity"));
            mInitMap.put(new Pair<String, String>("func_149916_e", "getHopperIcon"));
            mInitMap.put(new Pair<String, String>("func_149917_c", "getActiveStateFromMetadata"));
            mInitMap.put(new Pair<String, String>("func_149918_b", "getDirectionFromMetadata"));
            mInitMap.put(new Pair<String, String>("func_149919_e", "updateBlockData"));
            mInitMap.put(new Pair<String, String>("func_149931_a", "updateFurnaceBlockState"));
            mInitMap.put(new Pair<String, String>("func_149937_b", "getFacingDirection"));
            mInitMap.put(new Pair<String, String>("func_149939_a", "getIPositionFromBlockSource"));
            mInitMap.put(new Pair<String, String>("func_149951_m", "getInventory"));
            mInitMap.put(new Pair<String, String>("func_149952_n", "isDoubleChest"));
            mInitMap.put(new Pair<String, String>("func_149953_o", "isOcelotSittingOnTop"));
            mInitMap.put(new Pair<String, String>("func_149954_e", "initMetadata"));
            mInitMap.put(new Pair<String, String>("func_149959_e", "getIconBrewingStandBase"));
            mInitMap.put(new Pair<String, String>("func_149962_a", "getTileEntity"));
            mInitMap.put(new Pair<String, String>("func_149965_a", "makeWither"));
            mInitMap.put(new Pair<String, String>("func_149970_j", "getOutputStrength"));
            mInitMap.put(new Pair<String, String>("func_149971_e", "getTileEntityComparator"));
            mInitMap.put(new Pair<String, String>("func_149975_b", "isBlockHeadOfBed"));
            mInitMap.put(new Pair<String, String>("func_149976_c", "isBedOccupied"));
            mInitMap.put(new Pair<String, String>("func_149977_a", "getSafeExitLocation"));
            mInitMap.put(new Pair<String, String>("func_149978_e", "setBedBounds"));
            mInitMap.put(new Pair<String, String>("func_149979_a", "setBedOccupied"));
            mInitMap.put(new Pair<String, String>("func_149988_b", "getCocoaIcon"));
            mInitMap.put(new Pair<String, String>("func_149990_e", "getIconSideOverlay"));
            mInitMap.put(new Pair<String, String>("func_150000_e", "tryToCreatePortal"));
            mInitMap.put(new Pair<String, String>("func_150002_b", "getFullSlabName"));
            mInitMap.put(new Pair<String, String>("func_150012_g", "getFullMetadata"));
            mInitMap.put(new Pair<String, String>("func_150020_b", "isEnderEyeInserted"));
            mInitMap.put(new Pair<String, String>("func_150021_e", "getIconEndPortalFrameEye"));
            mInitMap.put(new Pair<String, String>("func_150024_a", "setWaterLevel"));
            mInitMap.put(new Pair<String, String>("func_150025_c", "getRenderLiquidLevel"));
            mInitMap.put(new Pair<String, String>("func_150026_e", "getCauldronIcon"));
            mInitMap.put(new Pair<String, String>("func_150027_b", "getPowerFromMeta"));
            mInitMap.put(new Pair<String, String>("func_150042_a", "updateNeighbor"));
            mInitMap.put(new Pair<String, String>("func_150043_b", "setBlockBoundsFromMeta"));
            mInitMap.put(new Pair<String, String>("func_150044_m", "canStay"));
            mInitMap.put(new Pair<String, String>("func_150045_e", "findSolidSide"));
            mInitMap.put(new Pair<String, String>("func_150046_n", "activateButton"));
            mInitMap.put(new Pair<String, String>("func_150048_a", "onRedstoneSignal"));
            mInitMap.put(new Pair<String, String>("func_150049_b_", "isRailBlockAt"));
            mInitMap.put(new Pair<String, String>("func_150050_e", "isPowered"));
            mInitMap.put(new Pair<String, String>("func_150051_a", "isRailBlock"));
            mInitMap.put(new Pair<String, String>("func_150052_a", "refreshTrackShape"));
            mInitMap.put(new Pair<String, String>("func_150060_c", "getPowerFromMeta"));
            mInitMap.put(new Pair<String, String>("func_150061_a", "getSensitiveAABB"));
            mInitMap.put(new Pair<String, String>("func_150062_a", "setStateIfMobInteractsWithPlate"));
            mInitMap.put(new Pair<String, String>("func_150063_b", "setBlockBoundsFromMeta"));
            mInitMap.put(new Pair<String, String>("func_150064_a_", "updateNeighbors"));
            mInitMap.put(new Pair<String, String>("func_150065_e", "getPlateState"));
            mInitMap.put(new Pair<String, String>("func_150066_d", "getMetaFromPower"));
            mInitMap.put(new Pair<String, String>("func_150071_a", "determineOrientation"));
            mInitMap.put(new Pair<String, String>("func_150072_a", "isIndirectlyPowered"));
            mInitMap.put(new Pair<String, String>("func_150073_e", "getPistonExtensionTexture"));
            mInitMap.put(new Pair<String, String>("func_150074_e", "getPistonBaseIcon"));
            mInitMap.put(new Pair<String, String>("func_150075_c", "isExtended"));
            mInitMap.put(new Pair<String, String>("func_150076_b", "getPistonOrientation"));
            mInitMap.put(new Pair<String, String>("func_150077_h", "canExtend"));
            mInitMap.put(new Pair<String, String>("func_150078_e", "updatePistonState"));
            mInitMap.put(new Pair<String, String>("func_150079_i", "tryExtend"));
            mInitMap.put(new Pair<String, String>("func_150080_a", "canPushBlock"));
            mInitMap.put(new Pair<String, String>("func_150085_b", "getDirectionMeta"));
            mInitMap.put(new Pair<String, String>("func_150089_b", "setBlockBoundsFromMeta"));
            mInitMap.put(new Pair<String, String>("func_150091_e", "canConnectWallTo"));
            mInitMap.put(new Pair<String, String>("func_150098_a", "canPaneConnectToBlock"));
            mInitMap.put(new Pair<String, String>("func_150107_m", "canPlaceTorchOn"));
            mInitMap.put(new Pair<String, String>("func_150109_e", "dropTorchIfCantStay"));
            mInitMap.put(new Pair<String, String>("func_150118_d", "isTrapdoorOpen"));
            mInitMap.put(new Pair<String, String>("func_150119_a", "isValidSupportBlock"));
            mInitMap.put(new Pair<String, String>("func_150122_b", "setGraphicsLevel"));
            mInitMap.put(new Pair<String, String>("func_150126_e", "removeLeaves"));
            mInitMap.put(new Pair<String, String>("func_150147_e", "setBaseBounds"));
            mInitMap.put(new Pair<String, String>("func_150148_a", "isBlockStairs"));
            mInitMap.put(new Pair<String, String>("func_150161_d", "getTopIcon"));
            mInitMap.put(new Pair<String, String>("func_150163_b", "getSideIcon"));
            mInitMap.put(new Pair<String, String>("func_150173_e", "getRedstomInitMap.put(newireIcon"));
            mInitMap.put(new Pair<String, String>("func_150174_f", "isPowerProviderOrWire"));
            mInitMap.put(new Pair<String, String>("func_150206_m", "createDeepCopy"));
            mInitMap.put(new Pair<String, String>("func_150209_a", "setChatHoverEvent"));
            mInitMap.put(new Pair<String, String>("func_150210_i", "getChatHoverEvent"));
            mInitMap.put(new Pair<String, String>("func_150215_a", "getColor"));
            mInitMap.put(new Pair<String, String>("func_150217_b", "setItalic"));
            mInitMap.put(new Pair<String, String>("func_150218_j", "getFormattingCode"));
            mInitMap.put(new Pair<String, String>("func_150221_a", "setParentStyle"));
            mInitMap.put(new Pair<String, String>("func_150223_b", "getBold"));
            mInitMap.put(new Pair<String, String>("func_150224_n", "getParent"));
            mInitMap.put(new Pair<String, String>("func_150225_c", "setStrikethrough"));
            mInitMap.put(new Pair<String, String>("func_150227_a", "setBold"));
            mInitMap.put(new Pair<String, String>("func_150228_d", "setUnderlined"));
            mInitMap.put(new Pair<String, String>("func_150229_g", "isEmpty"));
            mInitMap.put(new Pair<String, String>("func_150232_l", "createShallowCopy"));
            mInitMap.put(new Pair<String, String>("func_150233_f", "getObfuscated"));
            mInitMap.put(new Pair<String, String>("func_150234_e", "getUnderlined"));
            mInitMap.put(new Pair<String, String>("func_150235_h", "getChatClickEvent"));
            mInitMap.put(new Pair<String, String>("func_150236_d", "getStrikethrough"));
            mInitMap.put(new Pair<String, String>("func_150237_e", "setObfuscated"));
            mInitMap.put(new Pair<String, String>("func_150238_a", "setColor"));
            mInitMap.put(new Pair<String, String>("func_150241_a", "setChatClickEvent"));
            mInitMap.put(new Pair<String, String>("func_150242_c", "getItalic"));
            mInitMap.put(new Pair<String, String>("func_150253_a", "getSiblings"));
            mInitMap.put(new Pair<String, String>("func_150254_d", "getFormattedText"));
            mInitMap.put(new Pair<String, String>("func_150255_a", "setChatStyle"));
            mInitMap.put(new Pair<String, String>("func_150256_b", "getChatStyle"));
            mInitMap.put(new Pair<String, String>("func_150257_a", "appendSibling"));
            mInitMap.put(new Pair<String, String>("func_150258_a", "appendText"));
            mInitMap.put(new Pair<String, String>("func_150259_f", "createCopy"));
            mInitMap.put(new Pair<String, String>("func_150260_c", "getUnformattedText"));
            mInitMap.put(new Pair<String, String>("func_150261_e", "getUnformattedTextForChat"));
            mInitMap.put(new Pair<String, String>("func_150262_a", "createDeepCopyIterator"));
            mInitMap.put(new Pair<String, String>("func_150265_g", "getChatComponentText_TextValue"));
            mInitMap.put(new Pair<String, String>("func_150268_i", "getKey"));
            mInitMap.put(new Pair<String, String>("func_150269_b", "initializeFromFormat"));
            mInitMap.put(new Pair<String, String>("func_150270_g", "ensureInitialized"));
            mInitMap.put(new Pair<String, String>("func_150271_j", "getFormatArgs"));
            mInitMap.put(new Pair<String, String>("func_150272_a", "getFormatArgumentAsComponent"));
            mInitMap.put(new Pair<String, String>("func_150284_a", "createmInitMap.put(newByType"));
            mInitMap.put(new Pair<String, String>("func_150285_a_", "getString"));
            mInitMap.put(new Pair<String, String>("func_150286_g", "getDouble"));
            mInitMap.put(new Pair<String, String>("func_150287_d", "getInt"));
            mInitMap.put(new Pair<String, String>("func_150288_h", "getFloat"));
            mInitMap.put(new Pair<String, String>("func_150289_e", "getShort"));
            mInitMap.put(new Pair<String, String>("func_150290_f", "getByte"));
            mInitMap.put(new Pair<String, String>("func_150291_c", "getLong"));
            mInitMap.put(new Pair<String, String>("func_150292_c", "getByteArray"));
            mInitMap.put(new Pair<String, String>("func_150295_c", "getTagList"));
            mInitMap.put(new Pair<String, String>("func_150296_c", "getKeySet"));
            mInitMap.put(new Pair<String, String>("func_150297_b", "hasKey"));
            mInitMap.put(new Pair<String, String>("func_150298_a", "writeEntry"));
            mInitMap.put(new Pair<String, String>("func_150299_b", "getTagId"));
            mInitMap.put(new Pair<String, String>("func_150302_c", "getIntArray"));
            mInitMap.put(new Pair<String, String>("func_150303_d", "getTagType"));
            mInitMap.put(new Pair<String, String>("func_150304_a", "setTag"));
            mInitMap.put(new Pair<String, String>("func_150305_b", "getCompoundTagAt"));
            mInitMap.put(new Pair<String, String>("func_150306_c", "getIntArrayAt"));
            mInitMap.put(new Pair<String, String>("func_150307_f", "getStringTagAt"));
            mInitMap.put(new Pair<String, String>("func_150308_e", "getFloatAt"));
            mInitMap.put(new Pair<String, String>("func_150309_d", "getDoubleAt"));
            mInitMap.put(new Pair<String, String>("func_150494_d", "getFrequency"));
            mInitMap.put(new Pair<String, String>("func_150495_a", "getDigResourcePath"));
            mInitMap.put(new Pair<String, String>("func_150496_b", "getPlaceSound"));
            mInitMap.put(new Pair<String, String>("func_150497_c", "getVolume"));
            mInitMap.put(new Pair<String, String>("func_150498_e", "getStepSound"));
            mInitMap.put(new Pair<String, String>("func_150503_a", "decipher"));
            mInitMap.put(new Pair<String, String>("func_150504_a", "cipher"));
            mInitMap.put(new Pair<String, String>("func_150510_c", "getLastUpdateTimeInMilliseconds"));
            mInitMap.put(new Pair<String, String>("func_150512_a", "decorateChunk"));
            mInitMap.put(new Pair<String, String>("func_150513_a", "genDecorations"));
            mInitMap.put(new Pair<String, String>("func_150516_a", "setBlockAndNotifyAdequately"));
            mInitMap.put(new Pair<String, String>("func_150558_b", "getBiomeGrassColor"));
            mInitMap.put(new Pair<String, String>("func_150560_b", "genBiomeTerrain"));
            mInitMap.put(new Pair<String, String>("func_150561_m", "getTempCategory"));
            mInitMap.put(new Pair<String, String>("func_150562_l", "getBiomeClass"));
            mInitMap.put(new Pair<String, String>("func_150564_a", "getFloatTemperature"));
            mInitMap.put(new Pair<String, String>("func_150565_n", "getBiomeGenArray"));
            mInitMap.put(new Pair<String, String>("func_150566_k", "createMutation"));
            mInitMap.put(new Pair<String, String>("func_150568_d", "getBiome"));
            mInitMap.put(new Pair<String, String>("func_150569_a", "isEqualTo"));
            mInitMap.put(new Pair<String, String>("func_150570_a", "setHeight"));
            mInitMap.put(new Pair<String, String>("func_150571_c", "getBiomeFoliageColor"));
            mInitMap.put(new Pair<String, String>("func_150573_a", "genTerrainBlocks"));
            mInitMap.put(new Pair<String, String>("func_150633_b", "mutateHills"));
            mInitMap.put(new Pair<String, String>("func_150646_a", "isRailBlockAt"));
            mInitMap.put(new Pair<String, String>("func_150650_a", "countAdjacentRails"));
            mInitMap.put(new Pair<String, String>("func_150663_a", "writeTag"));
            mInitMap.put(new Pair<String, String>("func_150668_b", "getValue"));
            mInitMap.put(new Pair<String, String>("func_150669_a", "getAction"));
            mInitMap.put(new Pair<String, String>("func_150672_a", "getValueByCanonicalName"));
            mInitMap.put(new Pair<String, String>("func_150673_b", "getCanonicalName"));
            mInitMap.put(new Pair<String, String>("func_150674_a", "shouldAllowInChat"));
            mInitMap.put(new Pair<String, String>("func_150684_a", "getValueByCanonicalName"));
            mInitMap.put(new Pair<String, String>("func_150685_b", "getCanonicalName"));
            mInitMap.put(new Pair<String, String>("func_150686_a", "shouldAllowInChat"));
            mInitMap.put(new Pair<String, String>("func_150695_a", "serializeChatStyle"));
            mInitMap.put(new Pair<String, String>("func_150696_a", "componentToJson"));
            mInitMap.put(new Pair<String, String>("func_150699_a", "jsonToComponent"));
            mInitMap.put(new Pair<String, String>("func_150701_a", "getAction"));
            mInitMap.put(new Pair<String, String>("func_150702_b", "getValue"));
            mInitMap.put(new Pair<String, String>("func_150706_a", "generateDispenserContents"));
            mInitMap.put(new Pair<String, String>("func_150707_a", "setEnchantable"));
            mInitMap.put(new Pair<String, String>("func_150708_a", "getItemStack"));
            mInitMap.put(new Pair<String, String>("func_150709_a", "setMaxDamagePercent"));
            mInitMap.put(new Pair<String, String>("func_150718_a", "closeChannel"));
            mInitMap.put(new Pair<String, String>("func_150719_a", "setNetHandler"));
            mInitMap.put(new Pair<String, String>("func_150721_g", "disableAutoRead"));
            mInitMap.put(new Pair<String, String>("func_150722_a", "provideLocalClient"));
            mInitMap.put(new Pair<String, String>("func_150723_a", "setConnectionState"));
            mInitMap.put(new Pair<String, String>("func_150724_d", "isChannelOpen"));
            mInitMap.put(new Pair<String, String>("func_150725_a", "scheduleOutboundPacket"));
            mInitMap.put(new Pair<String, String>("func_150726_a", "provideLanClient"));
            mInitMap.put(new Pair<String, String>("func_150727_a", "enableEncryption"));
            mInitMap.put(new Pair<String, String>("func_150729_e", "getNetHandler"));
            mInitMap.put(new Pair<String, String>("func_150730_f", "getExitMessage"));
            mInitMap.put(new Pair<String, String>("func_150731_c", "isLocalChannel"));
            mInitMap.put(new Pair<String, String>("func_150732_b", "dispatchPacket"));
            mInitMap.put(new Pair<String, String>("func_150733_h", "flushOutboundQueue"));
            mInitMap.put(new Pair<String, String>("func_150752_a", "getFromPacket"));
            mInitMap.put(new Pair<String, String>("func_150759_c", "getId"));
            mInitMap.put(new Pair<String, String>("func_150760_a", "getById"));
            mInitMap.put(new Pair<String, String>("func_150775_a", "attenuate"));
            mInitMap.put(new Pair<String, String>("func_150785_a", "writeStringToBuffer"));
            mInitMap.put(new Pair<String, String>("func_150786_a", "writeNBTTagCompoundToBuffer"));
            mInitMap.put(new Pair<String, String>("func_150787_b", "writeVarIntToBuffer"));
            mInitMap.put(new Pair<String, String>("func_150788_a", "writeItemStackToBuffer"));
            mInitMap.put(new Pair<String, String>("func_150789_c", "readStringFromBuffer"));
            mInitMap.put(new Pair<String, String>("func_150790_a", "getVarIntSize"));
            mInitMap.put(new Pair<String, String>("func_150791_c", "readItemStackFromBuffer"));
            mInitMap.put(new Pair<String, String>("func_150792_a", "readVarIntFromBuffer"));
            mInitMap.put(new Pair<String, String>("func_150793_b", "readNBTTagCompoundFromBuffer"));
            mInitMap.put(new Pair<String, String>("func_150795_a", "findBiomePosition"));
            mInitMap.put(new Pair<String, String>("func_150803_c", "recheckGaps"));
            mInitMap.put(new Pair<String, String>("func_150805_f", "removeTileEntity"));
            mInitMap.put(new Pair<String, String>("func_150806_e", "getBlockTileEntityInChunk"));
            mInitMap.put(new Pair<String, String>("func_150807_a", "setBlockIDWithMetadata"));
            mInitMap.put(new Pair<String, String>("func_150808_b", "getBlockLightOpacity"));
            mInitMap.put(new Pair<String, String>("func_150810_a", "getBlock"));
            mInitMap.put(new Pair<String, String>("func_150812_a", "setBlockTileEntityInChunk"));
            mInitMap.put(new Pair<String, String>("func_150813_a", "addTileEntity"));
            mInitMap.put(new Pair<String, String>("func_150818_a", "setExtBlockID"));
            mInitMap.put(new Pair<String, String>("func_150819_a", "getBlockByExtId"));
            mInitMap.put(new Pair<String, String>("func_150826_b", "translateToFallback"));
            mInitMap.put(new Pair<String, String>("func_150827_a", "getLastTranslationUpdateTimeInMilliseconds"));
            mInitMap.put(new Pair<String, String>("func_150835_j", "getBlockTileEntity"));
            mInitMap.put(new Pair<String, String>("func_150891_b", "getIdFromItem"));
            mInitMap.put(new Pair<String, String>("func_150892_m", "isPotionIngredient"));
            mInitMap.put(new Pair<String, String>("func_150893_a", "getStrVsBlock"));
            mInitMap.put(new Pair<String, String>("func_150894_a", "onBlockDestroyed"));
            mInitMap.put(new Pair<String, String>("func_150895_a", "getSubItems"));
            mInitMap.put(new Pair<String, String>("func_150896_i", "getPotionEffect"));
            mInitMap.put(new Pair<String, String>("func_150897_b", "canItemHarvestBlock"));
            mInitMap.put(new Pair<String, String>("func_150898_a", "getItemFromBlock"));
            mInitMap.put(new Pair<String, String>("func_150899_d", "getItemById"));
            mInitMap.put(new Pair<String, String>("func_150900_l", "registerItems"));
            mInitMap.put(new Pair<String, String>("func_150905_g", "getHealAmount"));
            mInitMap.put(new Pair<String, String>("func_150906_h", "getSaturationModifier"));
            mInitMap.put(new Pair<String, String>("func_150911_c", "createMapDataPacket"));
            mInitMap.put(new Pair<String, String>("func_150912_a", "loadMapData"));
            mInitMap.put(new Pair<String, String>("func_150913_i", "getToolMaterial"));
            mInitMap.put(new Pair<String, String>("func_150924_a", "placeDoorBlock"));
            mInitMap.put(new Pair<String, String>("func_150926_b", "getRecord"));
            mInitMap.put(new Pair<String, String>("func_150927_i", "getRecordNameLocal"));
            mInitMap.put(new Pair<String, String>("func_150930_a", "validBookPageTagContents"));
            mInitMap.put(new Pair<String, String>("func_150932_j", "getToolMaterialName"));
            mInitMap.put(new Pair<String, String>("func_150951_e", "getStatName"));
            mInitMap.put(new Pair<String, String>("func_150967_d", "getUncookedSaturationModifier"));
            mInitMap.put(new Pair<String, String>("func_150968_a", "registerIcon"));
            mInitMap.put(new Pair<String, String>("func_150970_e", "getCookedHealAmount"));
            mInitMap.put(new Pair<String, String>("func_150971_g", "getUncookedIcon"));
            mInitMap.put(new Pair<String, String>("func_150972_b", "getUnlocalizedNamePart"));
            mInitMap.put(new Pair<String, String>("func_150973_i", "getCookable"));
            mInitMap.put(new Pair<String, String>("func_150974_a", "getFishTypeForItemDamage"));
            mInitMap.put(new Pair<String, String>("func_150975_c", "getUncookedHealAmount"));
            mInitMap.put(new Pair<String, String>("func_150976_a", "getItemDamage"));
            mInitMap.put(new Pair<String, String>("func_150977_f", "getCookedSaturationModifier"));
            mInitMap.put(new Pair<String, String>("func_150978_a", "getFishTypeForItemStack"));
            mInitMap.put(new Pair<String, String>("func_150979_h", "getCookedIcon"));
            mInitMap.put(new Pair<String, String>("func_150995_f", "getBaseItemForRepair"));
            mInitMap.put(new Pair<String, String>("func_150996_a", "setItem"));
            mInitMap.put(new Pair<String, String>("func_150997_a", "getStrVsBlock"));
            mInitMap.put(new Pair<String, String>("func_150998_b", "canItemHarvestBlock"));
            mInitMap.put(new Pair<String, String>("func_150999_a", "onBlockDestroyed"));
            mInitMap.put(new Pair<String, String>("func_151001_c", "setStackDisplayName"));
            mInitMap.put(new Pair<String, String>("func_151003_a", "getSerializableElement"));
            mInitMap.put(new Pair<String, String>("func_151177_a", "getOneShotStat"));
            mInitMap.put(new Pair<String, String>("func_151187_b", "getJsonSerializableValue"));
            mInitMap.put(new Pair<String, String>("func_151188_a", "setIntegerValue"));
            mInitMap.put(new Pair<String, String>("func_151189_a", "getIntegerValue"));
            mInitMap.put(new Pair<String, String>("func_151190_a", "setJsonSerializableValue"));
            mInitMap.put(new Pair<String, String>("func_151200_h", "getJsonObjectStringFieldValue"));
            mInitMap.put(new Pair<String, String>("func_151201_f", "jsonObjectFieldTypeIsPrimitive"));
            mInitMap.put(new Pair<String, String>("func_151202_d", "jsonObjectFieldTypeIsArray"));
            mInitMap.put(new Pair<String, String>("func_151203_m", "getJsonObjectIntegerFieldValue"));
            mInitMap.put(new Pair<String, String>("func_151204_g", "jsonObjectHasNamedField"));
            mInitMap.put(new Pair<String, String>("func_151205_a", "jsonObjectFieldTypeIsString"));
            mInitMap.put(new Pair<String, String>("func_151206_a", "getJsonElementStringValue"));
            mInitMap.put(new Pair<String, String>("func_151207_m", "getJsonElementAsJsonArray"));
            mInitMap.put(new Pair<String, String>("func_151208_a", "getJsonObjectIntegerFieldValueOrDefault"));
            mInitMap.put(new Pair<String, String>("func_151209_a", "getJsonObjectBooleanFieldValueOrDefault"));
            mInitMap.put(new Pair<String, String>("func_151210_l", "getElementAsJsonObject"));
            mInitMap.put(new Pair<String, String>("func_151211_a", "jsonElementTypeIsString"));
            mInitMap.put(new Pair<String, String>("func_151212_i", "getJsonObjectBooleanFieldValue"));
            mInitMap.put(new Pair<String, String>("func_151213_a", "getJsonObjectJsonArrayFieldOrDefault"));
            mInitMap.put(new Pair<String, String>("func_151214_t", "getJsonObjectJsonArrayField"));
            mInitMap.put(new Pair<String, String>("func_151215_f", "getJsonElementIntegerValue"));
            mInitMap.put(new Pair<String, String>("func_151216_b", "getJsonElementBooleanValue"));
            mInitMap.put(new Pair<String, String>("func_151217_k", "getJsonObjectFloatFieldValue"));
            mInitMap.put(new Pair<String, String>("func_151218_a", "getJsonObjectFieldOrDefault"));
            mInitMap.put(new Pair<String, String>("func_151219_a", "getJsonObjectStringFieldValueOrDefault"));
            mInitMap.put(new Pair<String, String>("func_151220_d", "getJsonElementFloatValue"));
            mInitMap.put(new Pair<String, String>("func_151221_a", "getJsonObjectFloatFieldValueOrDefault"));
            mInitMap.put(new Pair<String, String>("func_151222_d", "getJsonElementTypeDescription"));
            mInitMap.put(new Pair<String, String>("func_151223_a", "downloadResourcePack"));
            mInitMap.put(new Pair<String, String>("func_151225_a", "post"));
            mInitMap.put(new Pair<String, String>("func_151226_a", "postMap"));
            mInitMap.put(new Pair<String, String>("func_151235_d", "isPowerOfTwo"));
            mInitMap.put(new Pair<String, String>("func_151236_b", "roundUpToPowerOfTwo"));
            mInitMap.put(new Pair<String, String>("func_151237_a", "clamp_double"));
            mInitMap.put(new Pair<String, String>("func_151238_b", "denormalizeClamp"));
            mInitMap.put(new Pair<String, String>("func_151239_c", "calculateLogBaseTwo"));
            mInitMap.put(new Pair<String, String>("func_151240_a", "randomFloatClamp"));
            mInitMap.put(new Pair<String, String>("func_151241_e", "calculateLogBaseTwoDeBruijn"));
            mInitMap.put(new Pair<String, String>("func_151243_f", "getIconItemDamage"));
            mInitMap.put(new Pair<String, String>("func_151244_d", "getIconItemStack"));
            mInitMap.put(new Pair<String, String>("func_151246_b", "isNullOrEmpty"));
            mInitMap.put(new Pair<String, String>("func_151247_a", "sendToAllTrackingEntity"));
            mInitMap.put(new Pair<String, String>("func_151250_a", "markBlockForUpdate"));
            mInitMap.put(new Pair<String, String>("func_151251_a", "sendToAllPlayersWatchingChunk"));
            mInitMap.put(new Pair<String, String>("func_151252_a", "sendTileToAllPlayersWatchingChunk"));
            mInitMap.put(new Pair<String, String>("func_151253_a", "flagChunkForUpdate"));
            mInitMap.put(new Pair<String, String>("func_151255_a", "getStringBuffer"));
            mInitMap.put(new Pair<String, String>("func_151256_a", "writeAndFlush"));
            mInitMap.put(new Pair<String, String>("func_151265_a", "addLanEndpoint"));
            mInitMap.put(new Pair<String, String>("func_151267_d", "getServer"));
            mInitMap.put(new Pair<String, String>("func_151268_b", "terminateEndpoints"));
            mInitMap.put(new Pair<String, String>("func_151269_c", "networkTick"));
            mInitMap.put(new Pair<String, String>("func_151270_a", "addLocalEndpoint"));
            mInitMap.put(new Pair<String, String>("func_151303_a", "getName"));
            mInitMap.put(new Pair<String, String>("func_151304_b", "getProtocol"));
            mInitMap.put(new Pair<String, String>("func_151315_a", "setServerDescription"));
            mInitMap.put(new Pair<String, String>("func_151316_d", "getFavicon"));
            mInitMap.put(new Pair<String, String>("func_151317_a", "getServerDescription"));
            mInitMap.put(new Pair<String, String>("func_151318_b", "getPlayerCountData"));
            mInitMap.put(new Pair<String, String>("func_151319_a", "setPlayerCountData"));
            mInitMap.put(new Pair<String, String>("func_151320_a", "setFavicon"));
            mInitMap.put(new Pair<String, String>("func_151321_a", "setProtocolVersionInfo"));
            mInitMap.put(new Pair<String, String>("func_151322_c", "getProtocolVersionInfo"));
            mInitMap.put(new Pair<String, String>("func_151330_a", "setPlayers"));
            mInitMap.put(new Pair<String, String>("func_151331_c", "getPlayers"));
            mInitMap.put(new Pair<String, String>("func_151332_a", "getMaxPlayers"));
            mInitMap.put(new Pair<String, String>("func_151333_b", "getOnlinePlayerCount"));
            mInitMap.put(new Pair<String, String>("func_151337_f", "getBlock"));
            mInitMap.put(new Pair<String, String>("func_151338_e", "getEventParameter"));
            mInitMap.put(new Pair<String, String>("func_151339_d", "getEventID"));
            mInitMap.put(new Pair<String, String>("func_151353_a", "registerDispenserBehaviors"));
            mInitMap.put(new Pair<String, String>("func_151354_b", "register"));
            mInitMap.put(new Pair<String, String>("func_151357_h", "showWorldInfoNotice"));
            mInitMap.put(new Pair<String, String>("func_151358_j", "setNotificationData"));
            mInitMap.put(new Pair<String, String>("func_151393_a", "addSmeltingRecipeForBlock"));
            mInitMap.put(new Pair<String, String>("func_151394_a", "addSmeltingRecipe"));
            mInitMap.put(new Pair<String, String>("func_151395_a", "getSmeltingResult"));
            mInitMap.put(new Pair<String, String>("func_151396_a", "addSmelting"));
            mInitMap.put(new Pair<String, String>("func_151398_b", "getSmeltingExperience"));
            mInitMap.put(new Pair<String, String>("func_151426_a", "getEnumChatVisibility"));
            mInitMap.put(new Pair<String, String>("func_151428_a", "getChatVisibility"));
            mInitMap.put(new Pair<String, String>("func_151429_b", "getResourceKey"));
            mInitMap.put(new Pair<String, String>("func_151438_a", "getSoundLevel"));
            mInitMap.put(new Pair<String, String>("func_151439_a", "setSoundLevel"));
            mInitMap.put(new Pair<String, String>("func_151440_a", "setOptionKeyBinding"));
            mInitMap.put(new Pair<String, String>("func_151460_a", "getBlockAtEntityViewpoint"));
            mInitMap.put(new Pair<String, String>("func_151461_a", "getChatComponent"));
            mInitMap.put(new Pair<String, String>("func_151462_b", "setKeyCode"));
            mInitMap.put(new Pair<String, String>("func_151463_i", "getKeyCode"));
            mInitMap.put(new Pair<String, String>("func_151464_g", "getKeyDescription"));
            mInitMap.put(new Pair<String, String>("func_151466_e", "getKeyCategory"));
            mInitMap.put(new Pair<String, String>("func_151467_c", "getKeybinds"));
            mInitMap.put(new Pair<String, String>("func_151468_f", "isPressed"));
            mInitMap.put(new Pair<String, String>("func_151469_h", "getKeyCodeDefault"));
            mInitMap.put(new Pair<String, String>("func_151470_d", "getIsKeyPressed"));
            mInitMap.put(new Pair<String, String>("func_151498_a", "isStairOrSlab"));
            mInitMap.put(new Pair<String, String>("func_151499_f", "getEatingGrassTimer"));
            mInitMap.put(new Pair<String, String>("func_151503_a", "getWoodenDoorBlock"));
            mInitMap.put(new Pair<String, String>("func_151507_a", "writeWatchedListToPacketBuffer"));
            mInitMap.put(new Pair<String, String>("func_151508_b", "readWatchedListFromPacketBuffer"));
            mInitMap.put(new Pair<String, String>("func_151510_a", "writeWatchableObjectToPacketBuffer"));
            mInitMap.put(new Pair<String, String>("func_151517_h", "isDamageAbsolute"));
            mInitMap.put(new Pair<String, String>("func_151518_m", "setDamageIsAbsolute"));
            mInitMap.put(new Pair<String, String>("func_151519_b", "getDeathMessage"));
            mInitMap.put(new Pair<String, String>("func_151523_a", "getDifficultyEnum"));
            mInitMap.put(new Pair<String, String>("func_151525_a", "getDifficultyId"));
            mInitMap.put(new Pair<String, String>("func_151526_b", "getDifficultyResourceKey"));
            mInitMap.put(new Pair<String, String>("func_151539_a", "generate"));
            mInitMap.put(new Pair<String, String>("func_151545_a", "getNearestInstance"));
            mInitMap.put(new Pair<String, String>("func_151548_a", "getBlockAtCurrentPosition"));
            mInitMap.put(new Pair<String, String>("func_151549_a", "fillWithBlocks"));
            mInitMap.put(new Pair<String, String>("func_151550_a", "placeBlockAtCurrentPosition"));
            mInitMap.put(new Pair<String, String>("func_151551_a", "randomlyFillWithBlocks"));
            mInitMap.put(new Pair<String, String>("func_151555_a", "getMetadataWithOffset"));
            mInitMap.put(new Pair<String, String>("func_151556_a", "fillWithMetadataBlocks"));
            mInitMap.put(new Pair<String, String>("func_151565_r", "getMaterialMapColor"));
            mInitMap.put(new Pair<String, String>("func_151616_a", "biomesEqualOrMesaPlateau"));
            mInitMap.put(new Pair<String, String>("func_151617_b", "selectModeOrRandom"));
            mInitMap.put(new Pair<String, String>("func_151618_b", "isBiomeOceanic"));
            mInitMap.put(new Pair<String, String>("func_151619_a", "selectRandom"));
            mInitMap.put(new Pair<String, String>("func_151624_d", "getIntsHeatIce"));
            mInitMap.put(new Pair<String, String>("func_151625_e", "getIntsSpecial"));
            mInitMap.put(new Pair<String, String>("func_151626_c", "getIntsCoolWarm"));
            mInitMap.put(new Pair<String, String>("func_151634_b", "canBiomesBeNeighbors"));
            mInitMap.put(new Pair<String, String>("func_151635_b", "replaceBiomeEdge"));
            mInitMap.put(new Pair<String, String>("func_151636_a", "replaceBiomeEdgeIfNecessary"));
            mInitMap.put(new Pair<String, String>("func_151644_a", "getMapColorForBlockColored"));
            mInitMap.put(new Pair<String, String>("func_151685_b", "getBaseItemForRepair"));
            mInitMap.put(new Pair<String, String>("func_151686_a", "addStats"));
            mInitMap.put(new Pair<String, String>("func_152121_a", "onSkinAvailable"));
            mInitMap.put(new Pair<String, String>("func_152122_n", "hasCape"));
            mInitMap.put(new Pair<String, String>("func_152123_o", "hasSkin"));
            mInitMap.put(new Pair<String, String>("func_152125_a", "drawScaledCustomSizeModalRect"));
            mInitMap.put(new Pair<String, String>("func_152126_a", "renderStreamIndicator"));
            mInitMap.put(new Pair<String, String>("func_152340_a", "readImageToBuffer"));
            mInitMap.put(new Pair<String, String>("func_152341_N", "getTwitchDetails"));
            mInitMap.put(new Pair<String, String>("func_152342_ad", "getSkinManager"));
            mInitMap.put(new Pair<String, String>("func_152343_a", "addScheduledTask"));
            mInitMap.put(new Pair<String, String>("func_152344_a", "addScheduledTask"));
            mInitMap.put(new Pair<String, String>("func_152345_ab", "isCallingFromMinecraftThread"));
            mInitMap.put(new Pair<String, String>("func_152346_Z", "getTwitchStream"));
            mInitMap.put(new Pair<String, String>("func_152347_ac", "getSessionService"));
            mInitMap.put(new Pair<String, String>("func_152348_aa", "dispatchKeypresses"));
            mInitMap.put(new Pair<String, String>("func_152349_b", "isUnicode"));
            mInitMap.put(new Pair<String, String>("func_152357_F", "getGameProfiles"));
            mInitMap.put(new Pair<String, String>("func_152358_ax", "getPlayerProfileCache"));
            mInitMap.put(new Pair<String, String>("func_152359_aw", "getGameProfileRepository"));
            mInitMap.put(new Pair<String, String>("func_152361_a", "setConfigManager"));
            mInitMap.put(new Pair<String, String>("func_152368_aE", "convertFiles"));
            mInitMap.put(new Pair<String, String>("func_152369_aG", "sleepFiveSeconds"));
            mInitMap.put(new Pair<String, String>("func_152372_a", "notifyOperators"));
            mInitMap.put(new Pair<String, String>("func_152373_a", "notifyOperators"));
            mInitMap.put(new Pair<String, String>("func_152374_a", "notifyOperators"));
            mInitMap.put(new Pair<String, String>("func_152378_a", "getPlayerEntityByUUID"));
            mInitMap.put(new Pair<String, String>("func_152379_p", "getRenderDistanceChunks"));
            mInitMap.put(new Pair<String, String>("func_152421_a", "setSessionType"));
            mInitMap.put(new Pair<String, String>("func_152428_f", "getSessionType"));
            mInitMap.put(new Pair<String, String>("func_152436_a", "render"));
            mInitMap.put(new Pair<String, String>("func_152437_a", "render"));
            mInitMap.put(new Pair<String, String>("func_152446_a", "read"));
            mInitMap.put(new Pair<String, String>("func_152447_a", "readType"));
            mInitMap.put(new Pair<String, String>("func_152448_b", "readKey"));
            mInitMap.put(new Pair<String, String>("func_152449_a", "readNBT"));
            mInitMap.put(new Pair<String, String>("func_152450_a", "addSpaceRead"));
            mInitMap.put(new Pair<String, String>("func_152457_a", "decompress"));
            mInitMap.put(new Pair<String, String>("func_152458_a", "readFromFile"));
            mInitMap.put(new Pair<String, String>("func_152459_a", "readGameProfileFromNBT"));
            mInitMap.put(new Pair<String, String>("func_152460_a", "writeGameProfileToNBT"));
            mInitMap.put(new Pair<String, String>("func_152493_a", "getTotalBytes"));
            mInitMap.put(new Pair<String, String>("func_152495_b", "getCount"));
            mInitMap.put(new Pair<String, String>("func_152506_a", "getOfflineProfile"));
            mInitMap.put(new Pair<String, String>("func_152583_a", "copyFrom"));
            mInitMap.put(new Pair<String, String>("func_152584_a", "setResourceMode"));
            mInitMap.put(new Pair<String, String>("func_152585_d", "isLanServer"));
            mInitMap.put(new Pair<String, String>("func_152586_b", "getResourceMode"));
            mInitMap.put(new Pair<String, String>("func_152589_a", "getMotd"));
            mInitMap.put(new Pair<String, String>("func_152596_g", "canSendCommands"));
            mInitMap.put(new Pair<String, String>("func_152597_c", "removePlayerFromWhitelist"));
            mInitMap.put(new Pair<String, String>("func_152598_l", "getWhitelistedPlayerNames"));
            mInitMap.put(new Pair<String, String>("func_152599_k", "getWhitelistedPlayers"));
            mInitMap.put(new Pair<String, String>("func_152600_g", "getAllProfiles"));
            mInitMap.put(new Pair<String, String>("func_152601_d", "addWhitelistedPlayer"));
            mInitMap.put(new Pair<String, String>("func_152602_a", "getPlayerStatsFile"));
            mInitMap.put(new Pair<String, String>("func_152603_m", "getOppedPlayers"));
            mInitMap.put(new Pair<String, String>("func_152605_a", "addOp"));
            mInitMap.put(new Pair<String, String>("func_152606_n", "getOppedPlayerNames"));
            mInitMap.put(new Pair<String, String>("func_152607_e", "canJoin"));
            mInitMap.put(new Pair<String, String>("func_152608_h", "getBannedPlayers"));
            mInitMap.put(new Pair<String, String>("func_152609_b", "getPlayerNamesString"));
            mInitMap.put(new Pair<String, String>("func_152610_b", "removeOp"));
            mInitMap.put(new Pair<String, String>("func_152611_a", "setViewDistance"));
            mInitMap.put(new Pair<String, String>("func_152612_a", "getPlayerByUsername"));
            mInitMap.put(new Pair<String, String>("func_152617_w", "saveUserBanList"));
            mInitMap.put(new Pair<String, String>("func_152618_v", "saveIpBanList"));
            mInitMap.put(new Pair<String, String>("func_152619_x", "loadIpBanList"));
            mInitMap.put(new Pair<String, String>("func_152620_y", "loadUserBansList"));
            mInitMap.put(new Pair<String, String>("func_152640_f", "getValue"));
            mInitMap.put(new Pair<String, String>("func_152641_a", "onSerialization"));
            mInitMap.put(new Pair<String, String>("func_152655_a", "getGameProfileForUsername"));
            mInitMap.put(new Pair<String, String>("func_152678_f", "writeChanges"));
            mInitMap.put(new Pair<String, String>("func_152679_g", "readSavedFile"));
            mInitMap.put(new Pair<String, String>("func_152680_h", "removeExpired"));
            mInitMap.put(new Pair<String, String>("func_152681_a", "getObjectKey"));
            mInitMap.put(new Pair<String, String>("func_152682_a", "createEntry"));
            mInitMap.put(new Pair<String, String>("func_152683_b", "getEntry"));
            mInitMap.put(new Pair<String, String>("func_152684_c", "removeEntry"));
            mInitMap.put(new Pair<String, String>("func_152685_a", "getKeys"));
            mInitMap.put(new Pair<String, String>("func_152686_a", "setLanServer"));
            mInitMap.put(new Pair<String, String>("func_152687_a", "addEntry"));
            mInitMap.put(new Pair<String, String>("func_152688_e", "getValues"));
            mInitMap.put(new Pair<String, String>("func_152689_b", "isLanServer"));
            mInitMap.put(new Pair<String, String>("func_152690_d", "hasEntries"));
            mInitMap.put(new Pair<String, String>("func_152691_c", "getSaveFile"));
            mInitMap.put(new Pair<String, String>("func_152692_d", "hasEntry"));
            mInitMap.put(new Pair<String, String>("func_152700_a", "getGameProfileFromName"));
            mInitMap.put(new Pair<String, String>("func_152701_b", "getProfileId"));
            mInitMap.put(new Pair<String, String>("func_152702_a", "isBanned"));
            mInitMap.put(new Pair<String, String>("func_152703_a", "isUsernameBanned"));
            mInitMap.put(new Pair<String, String>("func_152707_c", "addressToString"));
            mInitMap.put(new Pair<String, String>("func_152708_a", "isBanned"));
            mInitMap.put(new Pair<String, String>("func_152709_b", "getBanEntry"));
            mInitMap.put(new Pair<String, String>("func_152710_d", "convertWhitelist"));
            mInitMap.put(new Pair<String, String>("func_152711_b", "mkdir"));
            mInitMap.put(new Pair<String, String>("func_152712_b", "hasUnconvertableFiles"));
            mInitMap.put(new Pair<String, String>("func_152713_b", "parseDate"));
            mInitMap.put(new Pair<String, String>("func_152714_a", "tryConvert"));
            mInitMap.put(new Pair<String, String>("func_152715_c", "hasUnconvertablePlayerFiles"));
            mInitMap.put(new Pair<String, String>("func_152717_a", "lookupNames"));
            mInitMap.put(new Pair<String, String>("func_152718_c", "convertOplist"));
            mInitMap.put(new Pair<String, String>("func_152721_a", "readFile"));
            mInitMap.put(new Pair<String, String>("func_152722_b", "convertIpBanlist"));
            mInitMap.put(new Pair<String, String>("func_152723_a", "convertSaveFiles"));
            mInitMap.put(new Pair<String, String>("func_152724_a", "convertUserBanlist"));
            mInitMap.put(new Pair<String, String>("func_152725_d", "getPlayersDirectory"));
            mInitMap.put(new Pair<String, String>("func_152727_c", "backupConverted"));
            mInitMap.put(new Pair<String, String>("func_152750_a", "deserializeEntry"));
            mInitMap.put(new Pair<String, String>("func_152751_a", "serializeEntry"));
            mInitMap.put(new Pair<String, String>("func_152754_s", "getJsonObject"));
            mInitMap.put(new Pair<String, String>("func_152755_a", "get"));
            mInitMap.put(new Pair<String, String>("func_152764_a", "parsePass"));
            mInitMap.put(new Pair<String, String>("func_152765_a", "parseGroup"));
            mInitMap.put(new Pair<String, String>("func_152767_b", "addStatToSnooper"));
            mInitMap.put(new Pair<String, String>("func_152768_a", "addClientStat"));
            mInitMap.put(new Pair<String, String>("func_152788_a", "loadSkinFromCache"));
            mInitMap.put(new Pair<String, String>("func_152789_a", "loadSkin"));
            mInitMap.put(new Pair<String, String>("func_152792_a", "loadSkin"));
            mInitMap.put(new Pair<String, String>("func_152825_o", "isIngestTesting"));
            mInitMap.put(new Pair<String, String>("func_152839_p", "isBroadcastPaused"));
            mInitMap.put(new Pair<String, String>("func_152850_m", "isBroadcasting"));
            mInitMap.put(new Pair<String, String>("func_152856_w", "isReady"));
            mInitMap.put(new Pair<String, String>("func_152919_o", "isPaused"));
            mInitMap.put(new Pair<String, String>("func_152923_i", "shutdownStream"));
            mInitMap.put(new Pair<String, String>("func_153157_c", "glGetShaderi"));
            mInitMap.put(new Pair<String, String>("func_153158_d", "glGetShaderInfoLog"));
            mInitMap.put(new Pair<String, String>("func_153159_d", "glUniform4"));
            mInitMap.put(new Pair<String, String>("func_153160_c", "glUniformMatrix4"));
            mInitMap.put(new Pair<String, String>("func_153161_d", "glUseProgram"));
            mInitMap.put(new Pair<String, String>("func_153162_d", "glUniform4"));
            mInitMap.put(new Pair<String, String>("func_153163_f", "glUniform1i"));
            mInitMap.put(new Pair<String, String>("func_153164_b", "glGetAttribLocation"));
            mInitMap.put(new Pair<String, String>("func_153166_e", "glGetProgramInfoLog"));
            mInitMap.put(new Pair<String, String>("func_153168_a", "glUniform1"));
            mInitMap.put(new Pair<String, String>("func_153169_a", "glShaderSource"));
            mInitMap.put(new Pair<String, String>("func_153170_c", "glCompileShader"));
            mInitMap.put(new Pair<String, String>("func_153173_a", "glUniformMatrix2"));
            mInitMap.put(new Pair<String, String>("func_153175_a", "glGetProgrami"));
            mInitMap.put(new Pair<String, String>("func_153177_b", "glUniform2"));
            mInitMap.put(new Pair<String, String>("func_153178_b", "glAttachShader"));
            mInitMap.put(new Pair<String, String>("func_153179_f", "glLinkProgram"));
            mInitMap.put(new Pair<String, String>("func_153180_a", "glDeleteShader"));
            mInitMap.put(new Pair<String, String>("func_153181_a", "glUniform1"));
            mInitMap.put(new Pair<String, String>("func_153182_b", "glUniform2"));
        }

        /*
         * Opcode count of 22538 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
         */
        private static void init3() {
            mInitMap.put(new Pair<String, String>("func_153183_d", "glCreateProgram"));
            mInitMap.put(new Pair<String, String>("func_153187_e", "glDeleteProgram"));
            mInitMap.put(new Pair<String, String>("func_153189_b", "glUniformMatrix3"));
            mInitMap.put(new Pair<String, String>("func_153191_c", "glUniform3"));
            mInitMap.put(new Pair<String, String>("func_153192_c", "glUniform3"));
            mInitMap.put(new Pair<String, String>("func_153194_a", "glGetUniformLocation"));
            mInitMap.put(new Pair<String, String>("func_153195_b", "glCreateShader"));
            mInitMap.put(new Pair<String, String>("func_154310_c", "getButtonHeight"));
            mInitMap.put(new Pair<String, String>("func_154311_a", "setText"));
            mInitMap.put(new Pair<String, String>("func_154313_b", "setEnabled"));
            mInitMap.put(new Pair<String, String>("func_154314_d", "getId"));
            mInitMap.put(new Pair<String, String>("func_154315_e", "getEnabled"));
            mInitMap.put(new Pair<String, String>("func_154316_f", "getPositionY"));
            mInitMap.put(new Pair<String, String>("func_154317_g", "getRealmsButton"));
            mInitMap.put(new Pair<String, String>("func_154331_x", "getLastActiveTime"));
            mInitMap.put(new Pair<String, String>("func_154346_a", "hasAcceptedEULA"));
            mInitMap.put(new Pair<String, String>("func_154347_a", "loadEULAFile"));
            mInitMap.put(new Pair<String, String>("func_154348_b", "createEULAFile"));
            mInitMap.put(new Pair<String, String>("func_155759_m", "setServerResourcePack"));
            mInitMap.put(new Pair<String, String>("func_70000_a", "addServerStatsToSnooper"));
            mInitMap.put(new Pair<String, String>("func_70001_b", "addServerTypeToSnooper"));
            mInitMap.put(new Pair<String, String>("func_70002_Q", "isSnooperEnabled"));
            mInitMap.put(new Pair<String, String>("func_70003_b", "canCommandSenderUseCommand"));
            mInitMap.put(new Pair<String, String>("func_70005_c_", "getCommandSenderName"));
            mInitMap.put(new Pair<String, String>("func_70007_b", "resetLog"));
            mInitMap.put(new Pair<String, String>("func_70008_c", "getLogContents"));
            mInitMap.put(new Pair<String, String>("func_70011_f", "getDistance"));
            mInitMap.put(new Pair<String, String>("func_70012_b", "setLocationAndAngles"));
            mInitMap.put(new Pair<String, String>("func_70013_c", "getBrightness"));
            mInitMap.put(new Pair<String, String>("func_70014_b", "writeEntityToNBT"));
            mInitMap.put(new Pair<String, String>("func_70015_d", "setFire"));
            mInitMap.put(new Pair<String, String>("func_70016_h", "setVelocity"));
            mInitMap.put(new Pair<String, String>("func_70018_K", "setBeenAttacked"));
            mInitMap.put(new Pair<String, String>("func_70019_c", "setEating"));
            mInitMap.put(new Pair<String, String>("func_70020_e", "readFromNBT"));
            mInitMap.put(new Pair<String, String>("func_70021_al", "getParts"));
            mInitMap.put(new Pair<String, String>("func_70022_Q", "getEntityString"));
            mInitMap.put(new Pair<String, String>("func_70024_g", "addVelocity"));
            mInitMap.put(new Pair<String, String>("func_70026_G", "isWet"));
            mInitMap.put(new Pair<String, String>("func_70027_ad", "isBurning"));
            mInitMap.put(new Pair<String, String>("func_70028_i", "isEntityEqual"));
            mInitMap.put(new Pair<String, String>("func_70029_a", "setWorld"));
            mInitMap.put(new Pair<String, String>("func_70030_z", "onEntityUpdate"));
            mInitMap.put(new Pair<String, String>("func_70031_b", "setSprinting"));
            mInitMap.put(new Pair<String, String>("func_70032_d", "getDistanceToEntity"));
            mInitMap.put(new Pair<String, String>("func_70033_W", "getYOffset"));
            mInitMap.put(new Pair<String, String>("func_70034_d", "setRotationYawHead"));
            mInitMap.put(new Pair<String, String>("func_70035_c", "getInventory"));
            mInitMap.put(new Pair<String, String>("func_70037_a", "readEntityFromNBT"));
            mInitMap.put(new Pair<String, String>("func_70038_c", "isOffsetPositionInLiquid"));
            mInitMap.put(new Pair<String, String>("func_70039_c", "writeToNBTOptional"));
            mInitMap.put(new Pair<String, String>("func_70040_Z", "getLookVec"));
            mInitMap.put(new Pair<String, String>("func_70041_e_", "canTriggerWalking"));
            mInitMap.put(new Pair<String, String>("func_70042_X", "getMountedYOffset"));
            mInitMap.put(new Pair<String, String>("func_70043_V", "updateRiderPosition"));
            mInitMap.put(new Pair<String, String>("func_70044_A", "setOnFireFromLava"));
            mInitMap.put(new Pair<String, String>("func_70045_F", "isImmuneToFire"));
            mInitMap.put(new Pair<String, String>("func_70046_E", "getBoundingBox"));
            mInitMap.put(new Pair<String, String>("func_70047_e", "getEyeHeight"));
            mInitMap.put(new Pair<String, String>("func_70049_a", "mInitMap.put(newFloatNBTList"));
            mInitMap.put(new Pair<String, String>("func_70050_g", "setAir"));
            mInitMap.put(new Pair<String, String>("func_70051_ag", "isSprinting"));
            mInitMap.put(new Pair<String, String>("func_70052_a", "setFlag"));
            mInitMap.put(new Pair<String, String>("func_70053_R", "getShadowSize"));
            mInitMap.put(new Pair<String, String>("func_70055_a", "isInsideOfMaterial"));
            mInitMap.put(new Pair<String, String>("func_70056_a", "setPositionAndRotation2"));
            mInitMap.put(new Pair<String, String>("func_70057_ab", "performHurtAnimation"));
            mInitMap.put(new Pair<String, String>("func_70058_J", "handleLavaMovement"));
            mInitMap.put(new Pair<String, String>("func_70060_a", "moveFlying"));
            mInitMap.put(new Pair<String, String>("func_70062_b", "setCurrentItemOrArmor"));
            mInitMap.put(new Pair<String, String>("func_70063_aa", "setInPortal"));
            mInitMap.put(new Pair<String, String>("func_70064_a", "updateFallState"));
            mInitMap.put(new Pair<String, String>("func_70065_x", "preparePlayerToSpawn"));
            mInitMap.put(new Pair<String, String>("func_70066_B", "extinguish"));
            mInitMap.put(new Pair<String, String>("func_70067_L", "canBeCollidedWith"));
            mInitMap.put(new Pair<String, String>("func_70068_e", "getDistanceSqToEntity"));
            mInitMap.put(new Pair<String, String>("func_70069_a", "fall"));
            mInitMap.put(new Pair<String, String>("func_70070_b", "getBrightnessForRender"));
            mInitMap.put(new Pair<String, String>("func_70071_h_", "onUpdate"));
            mInitMap.put(new Pair<String, String>("func_70072_I", "handleWaterMovement"));
            mInitMap.put(new Pair<String, String>("func_70074_a", "onKillEntity"));
            mInitMap.put(new Pair<String, String>("func_70075_an", "canAttackWithItem"));
            mInitMap.put(new Pair<String, String>("func_70076_C", "kill"));
            mInitMap.put(new Pair<String, String>("func_70077_a", "onStruckByLightning"));
            mInitMap.put(new Pair<String, String>("func_70078_a", "mountEntity"));
            mInitMap.put(new Pair<String, String>("func_70079_am", "getRotationYawHead"));
            mInitMap.put(new Pair<String, String>("func_70080_a", "setPositionAndRotation"));
            mInitMap.put(new Pair<String, String>("func_70081_e", "dealFireDamage"));
            mInitMap.put(new Pair<String, String>("func_70082_c", "setAngles"));
            mInitMap.put(new Pair<String, String>("func_70083_f", "getFlag"));
            mInitMap.put(new Pair<String, String>("func_70084_c", "addToPlayerScore"));
            mInitMap.put(new Pair<String, String>("func_70085_c", "interact"));
            mInitMap.put(new Pair<String, String>("func_70086_ai", "getAir"));
            mInitMap.put(new Pair<String, String>("func_70087_a", "mInitMap.put(newDoubleNBTList"));
            mInitMap.put(new Pair<String, String>("func_70088_a", "entityInit"));
            mInitMap.put(new Pair<String, String>("func_70089_S", "isEntityAlive"));
            mInitMap.put(new Pair<String, String>("func_70090_H", "isInWater"));
            mInitMap.put(new Pair<String, String>("func_70091_d", "moveEntity"));
            mInitMap.put(new Pair<String, String>("func_70092_e", "getDistanceSq"));
            mInitMap.put(new Pair<String, String>("func_70093_af", "isSneaking"));
            mInitMap.put(new Pair<String, String>("func_70094_T", "isEntityInsideOpaqueBlock"));
            mInitMap.put(new Pair<String, String>("func_70095_a", "setSneaking"));
            mInitMap.put(new Pair<String, String>("func_70096_w", "getDataWatcher"));
            mInitMap.put(new Pair<String, String>("func_70097_a", "attackEntityFrom"));
            mInitMap.put(new Pair<String, String>("func_70098_U", "updateRidden"));
            mInitMap.put(new Pair<String, String>("func_70099_a", "entityDropItem"));
            mInitMap.put(new Pair<String, String>("func_70100_b_", "onCollideWithPlayer"));
            mInitMap.put(new Pair<String, String>("func_70101_b", "setRotation"));
            mInitMap.put(new Pair<String, String>("func_70103_a", "handleHealthUpdate"));
            mInitMap.put(new Pair<String, String>("func_70104_M", "canBePushed"));
            mInitMap.put(new Pair<String, String>("func_70105_a", "setSize"));
            mInitMap.put(new Pair<String, String>("func_70106_y", "setDead"));
            mInitMap.put(new Pair<String, String>("func_70107_b", "setPosition"));
            mInitMap.put(new Pair<String, String>("func_70108_f", "applyEntityCollision"));
            mInitMap.put(new Pair<String, String>("func_70109_d", "writeToNBT"));
            mInitMap.put(new Pair<String, String>("func_70110_aj", "setInWeb"));
            mInitMap.put(new Pair<String, String>("func_70111_Y", "getCollisionBorderSize"));
            mInitMap.put(new Pair<String, String>("func_70112_a", "isInRangeToRenderDist"));
            mInitMap.put(new Pair<String, String>("func_70113_ah", "isEating"));
            mInitMap.put(new Pair<String, String>("func_70114_g", "getCollisionBox"));
            mInitMap.put(new Pair<String, String>("func_70115_ae", "isRiding"));
            mInitMap.put(new Pair<String, String>("func_70184_a", "onImpact"));
            mInitMap.put(new Pair<String, String>("func_70185_h", "getGravityVelocity"));
            mInitMap.put(new Pair<String, String>("func_70186_c", "setThrowableHeading"));
            mInitMap.put(new Pair<String, String>("func_70196_i", "getPotionDamage"));
            mInitMap.put(new Pair<String, String>("func_70220_a", "moveTowards"));
            mInitMap.put(new Pair<String, String>("func_70227_a", "onImpact"));
            mInitMap.put(new Pair<String, String>("func_70239_b", "setDamage"));
            mInitMap.put(new Pair<String, String>("func_70240_a", "setKnockbackStrength"));
            mInitMap.put(new Pair<String, String>("func_70241_g", "getIsCritical"));
            mInitMap.put(new Pair<String, String>("func_70242_d", "getDamage"));
            mInitMap.put(new Pair<String, String>("func_70243_d", "setIsCritical"));
            mInitMap.put(new Pair<String, String>("func_70265_b", "setTimeSinceHit"));
            mInitMap.put(new Pair<String, String>("func_70266_a", "setDamageTaken"));
            mInitMap.put(new Pair<String, String>("func_70267_i", "getForwardDirection"));
            mInitMap.put(new Pair<String, String>("func_70268_h", "getTimeSinceHit"));
            mInitMap.put(new Pair<String, String>("func_70269_c", "setForwardDirection"));
            mInitMap.put(new Pair<String, String>("func_70270_d", "setIsBoatEmpty"));
            mInitMap.put(new Pair<String, String>("func_70271_g", "getDamageTaken"));
            mInitMap.put(new Pair<String, String>("func_70288_d", "setAgeToCreativeDespawnTime"));
            mInitMap.put(new Pair<String, String>("func_70289_a", "combineItems"));
            mInitMap.put(new Pair<String, String>("func_70295_k_", "openChest"));
            mInitMap.put(new Pair<String, String>("func_70296_d", "markDirty"));
            mInitMap.put(new Pair<String, String>("func_70297_j_", "getInventoryStackLimit"));
            mInitMap.put(new Pair<String, String>("func_70298_a", "decrStackSize"));
            mInitMap.put(new Pair<String, String>("func_70299_a", "setInventorySlotContents"));
            mInitMap.put(new Pair<String, String>("func_70300_a", "isUseableByPlayer"));
            mInitMap.put(new Pair<String, String>("func_70301_a", "getStackInSlot"));
            mInitMap.put(new Pair<String, String>("func_70302_i_", "getSizeInventory"));
            mInitMap.put(new Pair<String, String>("func_70304_b", "getStackInSlotOnClosing"));
            mInitMap.put(new Pair<String, String>("func_70305_f", "closeChest"));
            mInitMap.put(new Pair<String, String>("func_70429_k", "decrementAnimations"));
            mInitMap.put(new Pair<String, String>("func_70430_l", "getTotalArmorValue"));
            mInitMap.put(new Pair<String, String>("func_70431_c", "hasItemStack"));
            mInitMap.put(new Pair<String, String>("func_70432_d", "storeItemStack"));
            mInitMap.put(new Pair<String, String>("func_70436_m", "dropAllItems"));
            mInitMap.put(new Pair<String, String>("func_70437_b", "setItemStack"));
            mInitMap.put(new Pair<String, String>("func_70440_f", "armorItemInSlot"));
            mInitMap.put(new Pair<String, String>("func_70441_a", "addItemStackToInventory"));
            mInitMap.put(new Pair<String, String>("func_70442_a", "writeToNBT"));
            mInitMap.put(new Pair<String, String>("func_70443_b", "readFromNBT"));
            mInitMap.put(new Pair<String, String>("func_70445_o", "getItemStack"));
            mInitMap.put(new Pair<String, String>("func_70447_i", "getFirstEmptyStack"));
            mInitMap.put(new Pair<String, String>("func_70448_g", "getCurrentItem"));
            mInitMap.put(new Pair<String, String>("func_70449_g", "damageArmor"));
            mInitMap.put(new Pair<String, String>("func_70451_h", "getHotbarSize"));
            mInitMap.put(new Pair<String, String>("func_70452_e", "storePartialItemStack"));
            mInitMap.put(new Pair<String, String>("func_70453_c", "changeCurrentItem"));
            mInitMap.put(new Pair<String, String>("func_70455_b", "copyInventory"));
            mInitMap.put(new Pair<String, String>("func_70463_b", "getStackInRowAndColumn"));
            mInitMap.put(new Pair<String, String>("func_70468_h", "getCurrentRecipe"));
            mInitMap.put(new Pair<String, String>("func_70469_d", "inventoryResetNeededOnSlotChange"));
            mInitMap.put(new Pair<String, String>("func_70470_g", "resetRecipeAndSlots"));
            mInitMap.put(new Pair<String, String>("func_70471_c", "setCurrentRecipeIndex"));
            mInitMap.put(new Pair<String, String>("func_70486_a", "loadInventoryFromNBT"));
            mInitMap.put(new Pair<String, String>("func_70487_g", "saveInventoryToNBT"));
            mInitMap.put(new Pair<String, String>("func_70491_i", "getDamage"));
            mInitMap.put(new Pair<String, String>("func_70492_c", "setDamage"));
            mInitMap.put(new Pair<String, String>("func_70493_k", "getRollingDirection"));
            mInitMap.put(new Pair<String, String>("func_70494_i", "setRollingDirection"));
            mInitMap.put(new Pair<String, String>("func_70496_j", "getRollingAmplitude"));
            mInitMap.put(new Pair<String, String>("func_70497_h", "setRollingAmplitude"));
            mInitMap.put(new Pair<String, String>("func_70515_d", "explode"));
            mInitMap.put(new Pair<String, String>("func_70518_d", "onValidSurface"));
            mInitMap.put(new Pair<String, String>("func_70526_d", "getXpValue"));
            mInitMap.put(new Pair<String, String>("func_70527_a", "getXPSplit"));
            mInitMap.put(new Pair<String, String>("func_70528_g", "getTextureByXP"));
            mInitMap.put(new Pair<String, String>("func_70534_d", "getRedColorF"));
            mInitMap.put(new Pair<String, String>("func_70535_g", "getBlueColorF"));
            mInitMap.put(new Pair<String, String>("func_70536_a", "setParticleTextureIndex"));
            mInitMap.put(new Pair<String, String>("func_70537_b", "getFXLayer"));
            mInitMap.put(new Pair<String, String>("func_70538_b", "setRBGColorF"));
            mInitMap.put(new Pair<String, String>("func_70539_a", "renderParticle"));
            mInitMap.put(new Pair<String, String>("func_70541_f", "multipleParticleScaleBy"));
            mInitMap.put(new Pair<String, String>("func_70542_f", "getGreenColorF"));
            mInitMap.put(new Pair<String, String>("func_70543_e", "multiplyVelocity"));
            mInitMap.put(new Pair<String, String>("func_70589_b", "setBaseSpellTextureIndex"));
            mInitMap.put(new Pair<String, String>("func_70596_a", "applyColourMultiplier"));
            mInitMap.put(new Pair<String, String>("func_70599_aP", "getSoundVolume"));
            mInitMap.put(new Pair<String, String>("func_70600_l", "dropRareDrop"));
            mInitMap.put(new Pair<String, String>("func_70601_bi", "getCanSpawnHere"));
            mInitMap.put(new Pair<String, String>("func_70603_bj", "getRenderSizeModifier"));
            mInitMap.put(new Pair<String, String>("func_70604_c", "setRevengeTarget"));
            mInitMap.put(new Pair<String, String>("func_70605_aq", "getMoveHelper"));
            mInitMap.put(new Pair<String, String>("func_70606_j", "setHealth"));
            mInitMap.put(new Pair<String, String>("func_70608_bn", "isPlayerSleeping"));
            mInitMap.put(new Pair<String, String>("func_70609_aI", "onDeathUpdate"));
            mInitMap.put(new Pair<String, String>("func_70610_aX", "isMovementBlocked"));
            mInitMap.put(new Pair<String, String>("func_70612_e", "moveEntityWithHeading"));
            mInitMap.put(new Pair<String, String>("func_70613_aW", "isServerWorld"));
            mInitMap.put(new Pair<String, String>("func_70614_a", "rayTrace"));
            mInitMap.put(new Pair<String, String>("func_70615_aA", "eatGrassBonus"));
            mInitMap.put(new Pair<String, String>("func_70617_f_", "isOnLadder"));
            mInitMap.put(new Pair<String, String>("func_70618_n", "removePotionEffectClient"));
            mInitMap.put(new Pair<String, String>("func_70619_bc", "updateAITasks"));
            mInitMap.put(new Pair<String, String>("func_70620_b", "getItemIcon"));
            mInitMap.put(new Pair<String, String>("func_70621_aR", "getHurtSound"));
            mInitMap.put(new Pair<String, String>("func_70623_bb", "despawnEntity"));
            mInitMap.put(new Pair<String, String>("func_70624_b", "setAttackTarget"));
            mInitMap.put(new Pair<String, String>("func_70625_a", "faceEntity"));
            mInitMap.put(new Pair<String, String>("func_70626_be", "updateEntityActionState"));
            mInitMap.put(new Pair<String, String>("func_70627_aG", "getTalkInterval"));
            mInitMap.put(new Pair<String, String>("func_70628_a", "dropFewItems"));
            mInitMap.put(new Pair<String, String>("func_70629_bd", "updateAITick"));
            mInitMap.put(new Pair<String, String>("func_70631_g_", "isChild"));
            mInitMap.put(new Pair<String, String>("func_70632_aY", "isBlocking"));
            mInitMap.put(new Pair<String, String>("func_70634_a", "setPositionAndUpdate"));
            mInitMap.put(new Pair<String, String>("func_70635_at", "getEntitySenses"));
            mInitMap.put(new Pair<String, String>("func_70636_d", "onLivingUpdate"));
            mInitMap.put(new Pair<String, String>("func_70637_d", "setJumping"));
            mInitMap.put(new Pair<String, String>("func_70638_az", "getAttackTarget"));
            mInitMap.put(new Pair<String, String>("func_70639_aQ", "getLivingSound"));
            mInitMap.put(new Pair<String, String>("func_70641_bl", "getMaxSpawnedInChunk"));
            mInitMap.put(new Pair<String, String>("func_70642_aH", "playLivingSound"));
            mInitMap.put(new Pair<String, String>("func_70643_av", "getAITarget"));
            mInitMap.put(new Pair<String, String>("func_70644_a", "isPotionActive"));
            mInitMap.put(new Pair<String, String>("func_70645_a", "onDeath"));
            mInitMap.put(new Pair<String, String>("func_70646_bf", "getVerticalFaceSpeed"));
            mInitMap.put(new Pair<String, String>("func_70647_i", "getSoundPitch"));
            mInitMap.put(new Pair<String, String>("func_70648_aU", "canBreatheUnderwater"));
            mInitMap.put(new Pair<String, String>("func_70650_aV", "isAIEnabled"));
            mInitMap.put(new Pair<String, String>("func_70651_bq", "getActivePotionEffects"));
            mInitMap.put(new Pair<String, String>("func_70652_k", "attackEntityAsMob"));
            mInitMap.put(new Pair<String, String>("func_70653_a", "knockBack"));
            mInitMap.put(new Pair<String, String>("func_70654_ax", "getAge"));
            mInitMap.put(new Pair<String, String>("func_70655_b", "applyArmorCalculations"));
            mInitMap.put(new Pair<String, String>("func_70656_aK", "spawnExplosionParticle"));
            mInitMap.put(new Pair<String, String>("func_70657_f", "setMoveForward"));
            mInitMap.put(new Pair<String, String>("func_70658_aO", "getTotalArmorValue"));
            mInitMap.put(new Pair<String, String>("func_70659_e", "setAIMoveSpeed"));
            mInitMap.put(new Pair<String, String>("func_70660_b", "getActivePotionEffect"));
            mInitMap.put(new Pair<String, String>("func_70661_as", "getNavigator"));
            mInitMap.put(new Pair<String, String>("func_70662_br", "isEntityUndead"));
            mInitMap.put(new Pair<String, String>("func_70663_b", "updateRotation"));
            mInitMap.put(new Pair<String, String>("func_70664_aZ", "jump"));
            mInitMap.put(new Pair<String, String>("func_70665_d", "damageEntity"));
            mInitMap.put(new Pair<String, String>("func_70666_h", "getPosition"));
            mInitMap.put(new Pair<String, String>("func_70668_bt", "getCreatureAttribute"));
            mInitMap.put(new Pair<String, String>("func_70669_a", "renderBrokenItemStack"));
            mInitMap.put(new Pair<String, String>("func_70670_a", "onmInitMap.put(newPotionEffect"));
            mInitMap.put(new Pair<String, String>("func_70671_ap", "getLookHelper"));
            mInitMap.put(new Pair<String, String>("func_70672_c", "applyPotionDamageCalculations"));
            mInitMap.put(new Pair<String, String>("func_70673_aS", "getDeathSound"));
            mInitMap.put(new Pair<String, String>("func_70674_bp", "clearActivePotions"));
            mInitMap.put(new Pair<String, String>("func_70675_k", "damageArmor"));
            mInitMap.put(new Pair<String, String>("func_70676_i", "getLook"));
            mInitMap.put(new Pair<String, String>("func_70678_g", "getSwingProgress"));
            mInitMap.put(new Pair<String, String>("func_70679_bo", "updatePotionEffects"));
            mInitMap.put(new Pair<String, String>("func_70681_au", "getRNG"));
            mInitMap.put(new Pair<String, String>("func_70682_h", "decreaseAirSupply"));
            mInitMap.put(new Pair<String, String>("func_70683_ar", "getJumpHelper"));
            mInitMap.put(new Pair<String, String>("func_70684_aJ", "isPlayer"));
            mInitMap.put(new Pair<String, String>("func_70685_l", "canEntityBeSeen"));
            mInitMap.put(new Pair<String, String>("func_70686_a", "canAttackClass"));
            mInitMap.put(new Pair<String, String>("func_70687_e", "isPotionApplicable"));
            mInitMap.put(new Pair<String, String>("func_70688_c", "onFinishedPotionEffect"));
            mInitMap.put(new Pair<String, String>("func_70689_ay", "getAIMoveSpeed"));
            mInitMap.put(new Pair<String, String>("func_70690_d", "addPotionEffect"));
            mInitMap.put(new Pair<String, String>("func_70691_i", "heal"));
            mInitMap.put(new Pair<String, String>("func_70692_ba", "canDespawn"));
            mInitMap.put(new Pair<String, String>("func_70693_a", "getExperiencePoints"));
            mInitMap.put(new Pair<String, String>("func_70694_bm", "getHeldItem"));
            mInitMap.put(new Pair<String, String>("func_70695_b", "onChangedPotionEffect"));
            mInitMap.put(new Pair<String, String>("func_70777_m", "getEntityToAttack"));
            mInitMap.put(new Pair<String, String>("func_70778_a", "setPathToEntity"));
            mInitMap.put(new Pair<String, String>("func_70779_j", "updateWanderPath"));
            mInitMap.put(new Pair<String, String>("func_70780_i", "isMovementCeased"));
            mInitMap.put(new Pair<String, String>("func_70781_l", "hasPath"));
            mInitMap.put(new Pair<String, String>("func_70782_k", "findPlayerToAttack"));
            mInitMap.put(new Pair<String, String>("func_70783_a", "getBlockPathWeight"));
            mInitMap.put(new Pair<String, String>("func_70784_b", "setTarget"));
            mInitMap.put(new Pair<String, String>("func_70785_a", "attackEntity"));
            mInitMap.put(new Pair<String, String>("func_70790_a", "isCourseTraversable"));
            mInitMap.put(new Pair<String, String>("func_70799_a", "setSlimeSize"));
            mInitMap.put(new Pair<String, String>("func_70800_m", "canDamagePlayer"));
            mInitMap.put(new Pair<String, String>("func_70801_i", "getSlimeParticle"));
            mInitMap.put(new Pair<String, String>("func_70802_j", "createInstance"));
            mInitMap.put(new Pair<String, String>("func_70803_o", "getJumpSound"));
            mInitMap.put(new Pair<String, String>("func_70804_p", "makesSoundOnLand"));
            mInitMap.put(new Pair<String, String>("func_70805_n", "getAttackStrength"));
            mInitMap.put(new Pair<String, String>("func_70806_k", "getJumpDelay"));
            mInitMap.put(new Pair<String, String>("func_70807_r", "makesSoundOnJump"));
            mInitMap.put(new Pair<String, String>("func_70808_l", "alterSquishAmount"));
            mInitMap.put(new Pair<String, String>("func_70809_q", "getSlimeSize"));
            mInitMap.put(new Pair<String, String>("func_70814_o", "isValidLightLevel"));
            mInitMap.put(new Pair<String, String>("func_70816_c", "teleportToEntity"));
            mInitMap.put(new Pair<String, String>("func_70817_b", "setCarryingData"));
            mInitMap.put(new Pair<String, String>("func_70819_e", "setScreaming"));
            mInitMap.put(new Pair<String, String>("func_70820_n", "teleportRandomly"));
            mInitMap.put(new Pair<String, String>("func_70821_d", "shouldAttackPlayer"));
            mInitMap.put(new Pair<String, String>("func_70823_r", "isScreaming"));
            mInitMap.put(new Pair<String, String>("func_70824_q", "getCarryingData"));
            mInitMap.put(new Pair<String, String>("func_70825_j", "teleportTo"));
            mInitMap.put(new Pair<String, String>("func_70829_a", "setCreeperState"));
            mInitMap.put(new Pair<String, String>("func_70830_n", "getPowered"));
            mInitMap.put(new Pair<String, String>("func_70831_j", "getCreeperFlashIntensity"));
            mInitMap.put(new Pair<String, String>("func_70832_p", "getCreeperState"));
            mInitMap.put(new Pair<String, String>("func_70835_c", "becomeAngryAt"));
            mInitMap.put(new Pair<String, String>("func_70839_e", "setBesideClimbableBlock"));
            mInitMap.put(new Pair<String, String>("func_70841_p", "isBesideClimbableBlock"));
            mInitMap.put(new Pair<String, String>("func_70849_f", "setPlayerCreated"));
            mInitMap.put(new Pair<String, String>("func_70850_q", "isPlayerCreated"));
            mInitMap.put(new Pair<String, String>("func_70851_e", "setHoldingRose"));
            mInitMap.put(new Pair<String, String>("func_70852_n", "getVillage"));
            mInitMap.put(new Pair<String, String>("func_70853_p", "getHoldRoseTick"));
            mInitMap.put(new Pair<String, String>("func_70854_o", "getAttackTimer"));
            mInitMap.put(new Pair<String, String>("func_70873_a", "setGrowingAge"));
            mInitMap.put(new Pair<String, String>("func_70874_b", "getGrowingAge"));
            mInitMap.put(new Pair<String, String>("func_70875_t", "resetInLove"));
            mInitMap.put(new Pair<String, String>("func_70876_c", "procreate"));
            mInitMap.put(new Pair<String, String>("func_70877_b", "isBreedingItem"));
            mInitMap.put(new Pair<String, String>("func_70878_b", "canMateWith"));
            mInitMap.put(new Pair<String, String>("func_70880_s", "isInLove"));
            mInitMap.put(new Pair<String, String>("func_70890_k", "getHeadRotationAngleX"));
            mInitMap.put(new Pair<String, String>("func_70891_b", "setFleeceColor"));
            mInitMap.put(new Pair<String, String>("func_70892_o", "getSheared"));
            mInitMap.put(new Pair<String, String>("func_70893_e", "setSheared"));
            mInitMap.put(new Pair<String, String>("func_70894_j", "getHeadRotationPointY"));
            mInitMap.put(new Pair<String, String>("func_70895_a", "getRandomFleeceColor"));
            mInitMap.put(new Pair<String, String>("func_70896_n", "getFleeceColor"));
            mInitMap.put(new Pair<String, String>("func_70900_e", "setSaddled"));
            mInitMap.put(new Pair<String, String>("func_70901_n", "getSaddled"));
            mInitMap.put(new Pair<String, String>("func_70902_q", "getOwner"));
            mInitMap.put(new Pair<String, String>("func_70903_f", "setTamed"));
            mInitMap.put(new Pair<String, String>("func_70904_g", "setSitting"));
            mInitMap.put(new Pair<String, String>("func_70906_o", "isSitting"));
            mInitMap.put(new Pair<String, String>("func_70907_r", "getAISit"));
            mInitMap.put(new Pair<String, String>("func_70908_e", "playTameEffect"));
            mInitMap.put(new Pair<String, String>("func_70909_n", "isTamed"));
            mInitMap.put(new Pair<String, String>("func_70912_b", "setTameSkin"));
            mInitMap.put(new Pair<String, String>("func_70913_u", "getTameSkin"));
            mInitMap.put(new Pair<String, String>("func_70915_j", "getShadingWhileWet"));
            mInitMap.put(new Pair<String, String>("func_70916_h", "setAngry"));
            mInitMap.put(new Pair<String, String>("func_70917_k", "getInterestedAngle"));
            mInitMap.put(new Pair<String, String>("func_70919_bu", "isAngry"));
            mInitMap.put(new Pair<String, String>("func_70920_v", "getTailRotation"));
            mInitMap.put(new Pair<String, String>("func_70921_u", "isWolfWet"));
            mInitMap.put(new Pair<String, String>("func_70923_f", "getShakeAngle"));
            mInitMap.put(new Pair<String, String>("func_70930_a", "setRecipes"));
            mInitMap.put(new Pair<String, String>("func_70931_l_", "getCustomer"));
            mInitMap.put(new Pair<String, String>("func_70932_a_", "setCustomer"));
            mInitMap.put(new Pair<String, String>("func_70933_a", "useRecipe"));
            mInitMap.put(new Pair<String, String>("func_70934_b", "getRecipes"));
            mInitMap.put(new Pair<String, String>("func_70938_b", "setProfession"));
            mInitMap.put(new Pair<String, String>("func_70939_f", "setPlaying"));
            mInitMap.put(new Pair<String, String>("func_70940_q", "isTrading"));
            mInitMap.put(new Pair<String, String>("func_70941_o", "isMating"));
            mInitMap.put(new Pair<String, String>("func_70942_a", "generateRandomParticles"));
            mInitMap.put(new Pair<String, String>("func_70945_p", "isPlaying"));
            mInitMap.put(new Pair<String, String>("func_70946_n", "getProfession"));
            mInitMap.put(new Pair<String, String>("func_70947_e", "setMating"));
            mInitMap.put(new Pair<String, String>("func_70950_c", "addDefaultEquipmentAndRecipies"));
            mInitMap.put(new Pair<String, String>("func_70965_a", "attackEntityFromPart"));
            mInitMap.put(new Pair<String, String>("func_70967_k", "setmInitMap.put(newTarget"));
            mInitMap.put(new Pair<String, String>("func_70969_j", "updateDragonEnderCrystal"));
            mInitMap.put(new Pair<String, String>("func_70970_a", "collideWithEntities"));
            mInitMap.put(new Pair<String, String>("func_70971_b", "attackEntitiesInList"));
            mInitMap.put(new Pair<String, String>("func_70972_a", "destroyBlocksInAABB"));
            mInitMap.put(new Pair<String, String>("func_70973_b", "simplifyAngle"));
            mInitMap.put(new Pair<String, String>("func_70974_a", "getMovementOffsets"));
            mInitMap.put(new Pair<String, String>("func_70975_a", "createEnderPortal"));
            mInitMap.put(new Pair<String, String>("func_70996_bM", "shouldHeal"));
            mInitMap.put(new Pair<String, String>("func_70997_bJ", "getBedLocation"));
            mInitMap.put(new Pair<String, String>("func_70998_m", "interactWith"));
            mInitMap.put(new Pair<String, String>("func_70999_a", "wakeUpPlayer"));
            mInitMap.put(new Pair<String, String>("func_71000_j", "addMovementStat"));
            mInitMap.put(new Pair<String, String>("func_71001_a", "onItemPickup"));
            mInitMap.put(new Pair<String, String>("func_71002_c", "displayGUIEnchantment"));
            mInitMap.put(new Pair<String, String>("func_71004_bE", "respawnPlayer"));
            mInitMap.put(new Pair<String, String>("func_71005_bN", "getInventoryEnderChest"));
            mInitMap.put(new Pair<String, String>("func_71007_a", "displayGUIChest"));
            mInitMap.put(new Pair<String, String>("func_71008_a", "setItemInUse"));
            mInitMap.put(new Pair<String, String>("func_71009_b", "onCriticalHit"));
            mInitMap.put(new Pair<String, String>("func_71010_c", "updateItemUse"));
            mInitMap.put(new Pair<String, String>("func_71011_bu", "getItemInUse"));
            mInitMap.put(new Pair<String, String>("func_71012_a", "joinEntityItemWithWorld"));
            mInitMap.put(new Pair<String, String>("func_71015_k", "addMountedMovementStat"));
            mInitMap.put(new Pair<String, String>("func_71016_p", "sendPlayerAbilities"));
            mInitMap.put(new Pair<String, String>("func_71018_a", "sleepInBedAt"));
            mInitMap.put(new Pair<String, String>("func_71019_a", "dropPlayerItemWithRandomChoice"));
            mInitMap.put(new Pair<String, String>("func_71020_j", "addExhaustion"));
            mInitMap.put(new Pair<String, String>("func_71023_q", "addExperience"));
            mInitMap.put(new Pair<String, String>("func_71024_bL", "getFoodStats"));
            mInitMap.put(new Pair<String, String>("func_71026_bH", "isPlayerFullyAsleep"));
            mInitMap.put(new Pair<String, String>("func_71027_c", "travelToDimension"));
            mInitMap.put(new Pair<String, String>("func_71028_bD", "destroyCurrentEquippedItem"));
            mInitMap.put(new Pair<String, String>("func_71029_a", "triggerAchievement"));
            mInitMap.put(new Pair<String, String>("func_71030_a", "displayGUIMerchant"));
            mInitMap.put(new Pair<String, String>("func_71033_a", "setGameType"));
            mInitMap.put(new Pair<String, String>("func_71034_by", "stopUsingItem"));
            mInitMap.put(new Pair<String, String>("func_71036_o", "onItemUseFinish"));
            mInitMap.put(new Pair<String, String>("func_71037_bA", "getScore"));
            mInitMap.put(new Pair<String, String>("func_71038_i", "swingItem"));
            mInitMap.put(new Pair<String, String>("func_71039_bw", "isUsingItem"));
            mInitMap.put(new Pair<String, String>("func_71040_bB", "dropOneItem"));
            mInitMap.put(new Pair<String, String>("func_71041_bz", "clearItemInUse"));
            mInitMap.put(new Pair<String, String>("func_71043_e", "canEat"));
            mInitMap.put(new Pair<String, String>("func_71044_o", "collideWithPlayer"));
            mInitMap.put(new Pair<String, String>("func_71045_bC", "getCurrentEquippedItem"));
            mInitMap.put(new Pair<String, String>("func_71047_c", "onEnchantmentCritical"));
            mInitMap.put(new Pair<String, String>("func_71048_c", "displayGUIBook"));
            mInitMap.put(new Pair<String, String>("func_71049_a", "clonePlayer"));
            mInitMap.put(new Pair<String, String>("func_71050_bK", "xpBarCap"));
            mInitMap.put(new Pair<String, String>("func_71051_bG", "getBedOrientationInDegrees"));
            mInitMap.put(new Pair<String, String>("func_71052_bv", "getItemInUseCount"));
            mInitMap.put(new Pair<String, String>("func_71053_j", "closeScreen"));
            mInitMap.put(new Pair<String, String>("func_71056_a", "verifyRespawnCoordinates"));
            mInitMap.put(new Pair<String, String>("func_71057_bx", "getItemInUseDuration"));
            mInitMap.put(new Pair<String, String>("func_71058_b", "displayGUIWorkbench"));
            mInitMap.put(new Pair<String, String>("func_71059_n", "attackTargetEntityWithCurrentItem"));
            mInitMap.put(new Pair<String, String>("func_71060_bI", "getSleepTimer"));
            mInitMap.put(new Pair<String, String>("func_71061_d_", "resetHeight"));
            mInitMap.put(new Pair<String, String>("func_71063_a", "setSpawnChunk"));
            mInitMap.put(new Pair<String, String>("func_71064_a", "addStat"));
            mInitMap.put(new Pair<String, String>("func_71065_l", "isInBed"));
            mInitMap.put(new Pair<String, String>("func_71110_a", "updateCraftingInventory"));
            mInitMap.put(new Pair<String, String>("func_71111_a", "sendSlotContents"));
            mInitMap.put(new Pair<String, String>("func_71112_a", "sendProgressBarUpdate"));
            mInitMap.put(new Pair<String, String>("func_71113_k", "updateHeldItem"));
            mInitMap.put(new Pair<String, String>("func_71114_r", "getPlayerIP"));
            mInitMap.put(new Pair<String, String>("func_71116_b", "addSelfToInternalCraftingInventory"));
            mInitMap.put(new Pair<String, String>("func_71117_bO", "getNextWindowId"));
            mInitMap.put(new Pair<String, String>("func_71118_n", "setPlayerHealthUpdated"));
            mInitMap.put(new Pair<String, String>("func_71120_a", "sendContainerToPlayer"));
            mInitMap.put(new Pair<String, String>("func_71121_q", "getServerForPlayer"));
            mInitMap.put(new Pair<String, String>("func_71122_b", "handleFalling"));
            mInitMap.put(new Pair<String, String>("func_71123_m", "mountEntityAndWakeUp"));
            mInitMap.put(new Pair<String, String>("func_71124_b", "getEquipmentInSlot"));
            mInitMap.put(new Pair<String, String>("func_71127_g", "onUpdateEntity"));
            mInitMap.put(new Pair<String, String>("func_71128_l", "closeContainer"));
            mInitMap.put(new Pair<String, String>("func_71150_b", "setPlayerSPHealth"));
            mInitMap.put(new Pair<String, String>("func_71151_f", "getFOVMultiplier"));
            mInitMap.put(new Pair<String, String>("func_71152_a", "setXPStats"));
            mInitMap.put(new Pair<String, String>("func_71153_f", "isBlockNormal"));
            mInitMap.put(new Pair<String, String>("func_71165_d", "sendChatMessage"));
            mInitMap.put(new Pair<String, String>("func_71166_b", "sendMotionUpdates"));
            mInitMap.put(new Pair<String, String>("func_71187_D", "getCommandManager"));
            mInitMap.put(new Pair<String, String>("func_71188_g", "setAllowPvp"));
            mInitMap.put(new Pair<String, String>("func_71189_e", "setHostname"));
            mInitMap.put(new Pair<String, String>("func_71190_q", "updateTimeLightAndEntities"));
            mInitMap.put(new Pair<String, String>("func_71191_d", "setBuildLimit"));
            mInitMap.put(new Pair<String, String>("func_71192_d", "setUserMessage"));
            mInitMap.put(new Pair<String, String>("func_71193_K", "allowSpawnMonsters"));
            mInitMap.put(new Pair<String, String>("func_71194_c", "canCreateBonusChest"));
            mInitMap.put(new Pair<String, String>("func_71195_b_", "getUserMessage"));
            mInitMap.put(new Pair<String, String>("func_71197_b", "startServer"));
            mInitMap.put(new Pair<String, String>("func_71198_k", "logDebug"));
            mInitMap.put(new Pair<String, String>("func_71199_h", "isHardcore"));
            mInitMap.put(new Pair<String, String>("func_71200_ad", "serverIsInRunLoop"));
            mInitMap.put(new Pair<String, String>("func_71201_j", "logSevere"));
            mInitMap.put(new Pair<String, String>("func_71203_ab", "getConfigurationManager"));
            mInitMap.put(new Pair<String, String>("func_71204_b", "setDemo"));
            mInitMap.put(new Pair<String, String>("func_71205_p", "setMOTD"));
            mInitMap.put(new Pair<String, String>("func_71206_a", "shareToLAN"));
            mInitMap.put(new Pair<String, String>("func_71207_Z", "getBuildLimit"));
            mInitMap.put(new Pair<String, String>("func_71208_b", "setServerPort"));
            mInitMap.put(new Pair<String, String>("func_71209_f", "getFile"));
            mInitMap.put(new Pair<String, String>("func_71211_k", "getServerHostname"));
            mInitMap.put(new Pair<String, String>("func_71213_z", "getAllUsernames"));
            mInitMap.put(new Pair<String, String>("func_71214_G", "getServerOwner"));
            mInitMap.put(new Pair<String, String>("func_71215_F", "getServerPort"));
            mInitMap.put(new Pair<String, String>("func_71216_a_", "outputPercentRemaining"));
            mInitMap.put(new Pair<String, String>("func_71217_p", "tick"));
            mInitMap.put(new Pair<String, String>("func_71218_a", "worldServerForDimension"));
            mInitMap.put(new Pair<String, String>("func_71219_W", "isPVPEnabled"));
            mInitMap.put(new Pair<String, String>("func_71220_V", "getCanSpawnNPCs"));
            mInitMap.put(new Pair<String, String>("func_71221_J", "getWorldName"));
            mInitMap.put(new Pair<String, String>("func_71222_d", "initialWorldChunkLoad"));
            mInitMap.put(new Pair<String, String>("func_71223_ag", "enableProfiling"));
            mInitMap.put(new Pair<String, String>("func_71224_l", "setServerOwner"));
            mInitMap.put(new Pair<String, String>("func_71225_e", "canStructuresSpawn"));
            mInitMap.put(new Pair<String, String>("func_71228_a", "finalTick"));
            mInitMap.put(new Pair<String, String>("func_71229_d", "setOnlineMode"));
            mInitMap.put(new Pair<String, String>("func_71230_b", "addServerInfoToCrashReport"));
            mInitMap.put(new Pair<String, String>("func_71231_X", "isFlightAllowed"));
            mInitMap.put(new Pair<String, String>("func_71233_x", "getCurrentPlayerCount"));
            mInitMap.put(new Pair<String, String>("func_71234_u", "getPort"));
            mInitMap.put(new Pair<String, String>("func_71235_a", "setGameType"));
            mInitMap.put(new Pair<String, String>("func_71236_h", "logWarning"));
            mInitMap.put(new Pair<String, String>("func_71237_c", "convertMapIfNeeded"));
            mInitMap.put(new Pair<String, String>("func_71238_n", "getDataDirectory"));
            mInitMap.put(new Pair<String, String>("func_71239_B", "isDebuggingEnabled"));
            mInitMap.put(new Pair<String, String>("func_71240_o", "systemExitNow"));
            mInitMap.put(new Pair<String, String>("func_71241_aa", "isServerStopped"));
            mInitMap.put(new Pair<String, String>("func_71242_L", "isDemo"));
            mInitMap.put(new Pair<String, String>("func_71243_i", "clearCurrentTask"));
            mInitMap.put(new Pair<String, String>("func_71244_g", "logInfo"));
            mInitMap.put(new Pair<String, String>("func_71245_h", "setAllowFlight"));
            mInitMap.put(new Pair<String, String>("func_71246_n", "setWorldName"));
            mInitMap.put(new Pair<String, String>("func_71247_a", "loadAllWorlds"));
            mInitMap.put(new Pair<String, String>("func_71248_a", "getPossibleCompletions"));
            mInitMap.put(new Pair<String, String>("func_71249_w", "getMinecraftVersion"));
            mInitMap.put(new Pair<String, String>("func_71250_E", "getKeyPair"));
            mInitMap.put(new Pair<String, String>("func_71251_e", "setCanSpawnAnimals"));
            mInitMap.put(new Pair<String, String>("func_71252_i", "handleRConCommand"));
            mInitMap.put(new Pair<String, String>("func_71253_a", "setKeyPair"));
            mInitMap.put(new Pair<String, String>("func_71254_M", "getActiveAnvilConverter"));
            mInitMap.put(new Pair<String, String>("func_71255_r", "getAllowNether"));
            mInitMap.put(new Pair<String, String>("func_71256_s", "startServerThread"));
            mInitMap.put(new Pair<String, String>("func_71257_f", "setCanSpawnNPCs"));
            mInitMap.put(new Pair<String, String>("func_71258_A", "getPlugins"));
            mInitMap.put(new Pair<String, String>("func_71259_af", "getTickCounter"));
            mInitMap.put(new Pair<String, String>("func_71260_j", "stopServer"));
            mInitMap.put(new Pair<String, String>("func_71261_m", "setFolderName"));
            mInitMap.put(new Pair<String, String>("func_71262_S", "isDedicatedServer"));
            mInitMap.put(new Pair<String, String>("func_71263_m", "initiateShutdown"));
            mInitMap.put(new Pair<String, String>("func_71264_H", "isSinglePlayer"));
            mInitMap.put(new Pair<String, String>("func_71265_f", "getGameType"));
            mInitMap.put(new Pair<String, String>("func_71266_T", "isServerInOnlineMode"));
            mInitMap.put(new Pair<String, String>("func_71267_a", "saveAllWorlds"));
            mInitMap.put(new Pair<String, String>("func_71268_U", "getCanSpawnAnimals"));
            mInitMap.put(new Pair<String, String>("func_71270_I", "getFolderName"));
            mInitMap.put(new Pair<String, String>("func_71272_O", "deleteWorldAndStopServer"));
            mInitMap.put(new Pair<String, String>("func_71273_Y", "getMOTD"));
            mInitMap.put(new Pair<String, String>("func_71274_v", "getMotd"));
            mInitMap.put(new Pair<String, String>("func_71275_y", "getMaxPlayers"));
            mInitMap.put(new Pair<String, String>("func_71276_C", "getServer"));
            mInitMap.put(new Pair<String, String>("func_71277_t", "getHostname"));
            mInitMap.put(new Pair<String, String>("func_71278_l", "isServerRunning"));
            mInitMap.put(new Pair<String, String>("func_71279_ae", "getGuiEnabled"));
            mInitMap.put(new Pair<String, String>("func_71326_a", "saveProperties"));
            mInitMap.put(new Pair<String, String>("func_71327_a", "getIntProperty"));
            mInitMap.put(new Pair<String, String>("func_71328_a", "setProperty"));
            mInitMap.put(new Pair<String, String>("func_71329_c", "getSettingsFilename"));
            mInitMap.put(new Pair<String, String>("func_71330_a", "getStringProperty"));
            mInitMap.put(new Pair<String, String>("func_71331_a", "addPendingCommand"));
            mInitMap.put(new Pair<String, String>("func_71332_a", "getBooleanProperty"));
            mInitMap.put(new Pair<String, String>("func_71333_ah", "executePendingCommands"));
            mInitMap.put(new Pair<String, String>("func_71344_c", "getPublic"));
            mInitMap.put(new Pair<String, String>("func_71351_a", "setServerData"));
            mInitMap.put(new Pair<String, String>("func_71352_k", "toggleFullscreen"));
            mInitMap.put(new Pair<String, String>("func_71353_a", "loadWorld"));
            mInitMap.put(new Pair<String, String>("func_71354_a", "setDimensionAndSpawnPlayer"));
            mInitMap.put(new Pair<String, String>("func_71355_q", "isDemo"));
            mInitMap.put(new Pair<String, String>("func_71356_B", "isSingleplayer"));
            mInitMap.put(new Pair<String, String>("func_71357_I", "loadScreen"));
            mInitMap.put(new Pair<String, String>("func_71359_d", "getSaveLoader"));
            mInitMap.put(new Pair<String, String>("func_71361_d", "checkGLError"));
            mInitMap.put(new Pair<String, String>("func_71363_D", "stopIntegratedServer"));
            mInitMap.put(new Pair<String, String>("func_71364_i", "setIngameNotInFocus"));
            mInitMap.put(new Pair<String, String>("func_71366_a", "displayDebugInfo"));
            mInitMap.put(new Pair<String, String>("func_71367_a", "setServer"));
            mInitMap.put(new Pair<String, String>("func_71369_N", "getGLMaximumTextureSize"));
            mInitMap.put(new Pair<String, String>("func_71370_a", "resize"));
            mInitMap.put(new Pair<String, String>("func_71371_a", "launchIntegratedServer"));
            mInitMap.put(new Pair<String, String>("func_71372_G", "isFullScreen"));
            mInitMap.put(new Pair<String, String>("func_71374_p", "debugInfoEntities"));
            mInitMap.put(new Pair<String, String>("func_71375_t", "isFancyGraphicsEnabled"));
            mInitMap.put(new Pair<String, String>("func_71377_b", "displayCrashReport"));
            mInitMap.put(new Pair<String, String>("func_71378_E", "getPlayerUsageSnooper"));
            mInitMap.put(new Pair<String, String>("func_71379_u", "isAmbientOcclusionEnabled"));
            mInitMap.put(new Pair<String, String>("func_71381_h", "setIngameFocus"));
            mInitMap.put(new Pair<String, String>("func_71382_s", "isGuiEnabled"));
            mInitMap.put(new Pair<String, String>("func_71383_b", "updateDebugProfilerName"));
            mInitMap.put(new Pair<String, String>("func_71384_a", "startGame"));
            mInitMap.put(new Pair<String, String>("func_71385_j", "displayInGameMenu"));
            mInitMap.put(new Pair<String, String>("func_71386_F", "getSystemTime"));
            mInitMap.put(new Pair<String, String>("func_71387_A", "isIntegratedServerRunning"));
            mInitMap.put(new Pair<String, String>("func_71388_o", "getWorldProviderName"));
            mInitMap.put(new Pair<String, String>("func_71389_H", "startTimerHackThread"));
            mInitMap.put(new Pair<String, String>("func_71392_a", "scaledTessellator"));
            mInitMap.put(new Pair<String, String>("func_71393_m", "debugInfoRenders"));
            mInitMap.put(new Pair<String, String>("func_71396_d", "addGraphicsAndWorldToCrashReport"));
            mInitMap.put(new Pair<String, String>("func_71398_f", "freeMemory"));
            mInitMap.put(new Pair<String, String>("func_71400_g", "shutdown"));
            mInitMap.put(new Pair<String, String>("func_71401_C", "getIntegratedServer"));
            mInitMap.put(new Pair<String, String>("func_71403_a", "loadWorld"));
            mInitMap.put(new Pair<String, String>("func_71404_a", "crashed"));
            mInitMap.put(new Pair<String, String>("func_71405_e", "shutdownMinecraftApplet"));
            mInitMap.put(new Pair<String, String>("func_71407_l", "runTick"));
            mInitMap.put(new Pair<String, String>("func_71408_n", "getEntityDebug"));
            mInitMap.put(new Pair<String, String>("func_71410_x", "getMinecraft"));
            mInitMap.put(new Pair<String, String>("func_71411_J", "runGameLoop"));
            mInitMap.put(new Pair<String, String>("func_71497_f", "getFile"));
            mInitMap.put(new Pair<String, String>("func_71498_d", "getCauseStackTraceOrString"));
            mInitMap.put(new Pair<String, String>("func_71499_a", "addCrashSectionThrowable"));
            mInitMap.put(new Pair<String, String>("func_71500_a", "addCrashSectionCallable"));
            mInitMap.put(new Pair<String, String>("func_71501_a", "getDescription"));
            mInitMap.put(new Pair<String, String>("func_71502_e", "getCompleteReport"));
            mInitMap.put(new Pair<String, String>("func_71503_h", "getWittyComment"));
            mInitMap.put(new Pair<String, String>("func_71504_g", "populateEnvironment"));
            mInitMap.put(new Pair<String, String>("func_71505_b", "getCrashCause"));
            mInitMap.put(new Pair<String, String>("func_71506_a", "getSectionsInStringBuilder"));
            mInitMap.put(new Pair<String, String>("func_71507_a", "addCrashSection"));
            mInitMap.put(new Pair<String, String>("func_71514_a", "getCommandAliases"));
            mInitMap.put(new Pair<String, String>("func_71515_b", "processCommand"));
            mInitMap.put(new Pair<String, String>("func_71516_a", "addTabCompletionOptions"));
            mInitMap.put(new Pair<String, String>("func_71517_b", "getCommandName"));
            mInitMap.put(new Pair<String, String>("func_71518_a", "getCommandUsage"));
            mInitMap.put(new Pair<String, String>("func_71519_b", "canCommandSenderUseCommand"));
            mInitMap.put(new Pair<String, String>("func_71521_c", "getCommandSenderAsPlayer"));
            mInitMap.put(new Pair<String, String>("func_71523_a", "doesStringStartWith"));
            mInitMap.put(new Pair<String, String>("func_71526_a", "parseInt"));
            mInitMap.put(new Pair<String, String>("func_71527_a", "joinNiceString"));
            mInitMap.put(new Pair<String, String>("func_71528_a", "parseIntWithMin"));
            mInitMap.put(new Pair<String, String>("func_71529_a", "setAdminCommander"));
            mInitMap.put(new Pair<String, String>("func_71530_a", "getListOfStringsMatchingLastWord"));
            mInitMap.put(new Pair<String, String>("func_71531_a", "getListOfStringsFromIterableMatchingLastWord"));
            mInitMap.put(new Pair<String, String>("func_71532_a", "parseIntBounded"));
            mInitMap.put(new Pair<String, String>("func_71534_d", "getSortedPossibleCommands"));
            mInitMap.put(new Pair<String, String>("func_71535_c", "getCommands"));
            mInitMap.put(new Pair<String, String>("func_71536_c", "getPlayers"));
            mInitMap.put(new Pair<String, String>("func_71538_c", "getListOfPlayerUsernames"));
            mInitMap.put(new Pair<String, String>("func_71539_b", "getGameModeFromCommand"));
            mInitMap.put(new Pair<String, String>("func_71541_a", "setGameType"));
            mInitMap.put(new Pair<String, String>("func_71542_c", "getAllUsernames"));
            mInitMap.put(new Pair<String, String>("func_71552_a", "setTime"));
            mInitMap.put(new Pair<String, String>("func_71553_b", "addTime"));
            mInitMap.put(new Pair<String, String>("func_71554_c", "toggleDownfall"));
            mInitMap.put(new Pair<String, String>("func_71555_a", "getCommands"));
            mInitMap.put(new Pair<String, String>("func_71556_a", "executeCommand"));
            mInitMap.put(new Pair<String, String>("func_71557_a", "getPossibleCommands"));
            mInitMap.put(new Pair<String, String>("func_71558_b", "getPossibleCommands"));
            mInitMap.put(new Pair<String, String>("func_71559_a", "dropFirstString"));
            mInitMap.put(new Pair<String, String>("func_71560_a", "registerCommand"));
            mInitMap.put(new Pair<String, String>("func_71565_a", "filterAllowedCharacters"));
            mInitMap.put(new Pair<String, String>("func_71566_a", "isAllowedCharacter"));
            mInitMap.put(new Pair<String, String>("func_71569_e", "getDistanceSquared"));
            mInitMap.put(new Pair<String, String>("func_71571_b", "set"));
            mInitMap.put(new Pair<String, String>("func_71575_a", "getCrashReport"));
            mInitMap.put(new Pair<String, String>("func_72314_b", "expand"));
            mInitMap.put(new Pair<String, String>("func_72315_c", "isVecInXZ"));
            mInitMap.put(new Pair<String, String>("func_72316_a", "calculateXOffset"));
            mInitMap.put(new Pair<String, String>("func_72317_d", "offset"));
            mInitMap.put(new Pair<String, String>("func_72318_a", "isVecInside"));
            mInitMap.put(new Pair<String, String>("func_72319_d", "isVecInXY"));
            mInitMap.put(new Pair<String, String>("func_72320_b", "getAverageEdgeLength"));
            mInitMap.put(new Pair<String, String>("func_72321_a", "addCoord"));
            mInitMap.put(new Pair<String, String>("func_72322_c", "calculateZOffset"));
            mInitMap.put(new Pair<String, String>("func_72323_b", "calculateYOffset"));
            mInitMap.put(new Pair<String, String>("func_72324_b", "setBounds"));
            mInitMap.put(new Pair<String, String>("func_72325_c", "getOffsetBoundingBox"));
            mInitMap.put(new Pair<String, String>("func_72326_a", "intersectsWith"));
            mInitMap.put(new Pair<String, String>("func_72327_a", "calculateIntercept"));
            mInitMap.put(new Pair<String, String>("func_72328_c", "setBB"));
            mInitMap.put(new Pair<String, String>("func_72329_c", "copy"));
            mInitMap.put(new Pair<String, String>("func_72330_a", "getBoundingBox"));
            mInitMap.put(new Pair<String, String>("func_72331_e", "contract"));
            mInitMap.put(new Pair<String, String>("func_72333_b", "isVecInYZ"));
            mInitMap.put(new Pair<String, String>("func_72352_l", "getMaxPlayers"));
            mInitMap.put(new Pair<String, String>("func_72354_b", "updateTimeAndWeatherForPlayer"));
            mInitMap.put(new Pair<String, String>("func_72355_a", "initializeConnectionToPlayer"));
            mInitMap.put(new Pair<String, String>("func_72356_a", "transferPlayerToDimension"));
            mInitMap.put(new Pair<String, String>("func_72358_d", "serverUpdateMountedMovingPlayer"));
            mInitMap.put(new Pair<String, String>("func_72362_j", "loadWhiteList"));
            mInitMap.put(new Pair<String, String>("func_72363_f", "getBannedIPs"));
            mInitMap.put(new Pair<String, String>("func_72364_a", "setPlayerManager"));
            mInitMap.put(new Pair<String, String>("func_72365_p", "getServerInstance"));
            mInitMap.put(new Pair<String, String>("func_72367_e", "playerLoggedOut"));
            mInitMap.put(new Pair<String, String>("func_72368_a", "recreatePlayerEntity"));
            mInitMap.put(new Pair<String, String>("func_72369_d", "getAllUsernames"));
            mInitMap.put(new Pair<String, String>("func_72371_a", "setWhiteListEnabled"));
            mInitMap.put(new Pair<String, String>("func_72372_a", "getEntityViewDistance"));
            mInitMap.put(new Pair<String, String>("func_72373_m", "getAvailablePlayerDat"));
            mInitMap.put(new Pair<String, String>("func_72374_b", "onTick"));
            mInitMap.put(new Pair<String, String>("func_72377_c", "playerLoggedIn"));
            mInitMap.put(new Pair<String, String>("func_72378_q", "getHostPlayerData"));
            mInitMap.put(new Pair<String, String>("func_72380_a", "readPlayerDataFromFile"));
            mInitMap.put(new Pair<String, String>("func_72382_j", "getPlayersMatchingAddress"));
            mInitMap.put(new Pair<String, String>("func_72383_n", "isWhiteListEnabled"));
            mInitMap.put(new Pair<String, String>("func_72385_f", "syncPlayerInventory"));
            mInitMap.put(new Pair<String, String>("func_72387_b", "setCommandsAllowedForAll"));
            mInitMap.put(new Pair<String, String>("func_72389_g", "saveAllPlayerData"));
            mInitMap.put(new Pair<String, String>("func_72391_b", "writePlayerData"));
            mInitMap.put(new Pair<String, String>("func_72392_r", "removeAllPlayers"));
            mInitMap.put(new Pair<String, String>("func_72394_k", "getCurrentPlayerCount"));
            mInitMap.put(new Pair<String, String>("func_72395_o", "getViewDistance"));
            mInitMap.put(new Pair<String, String>("func_72417_t", "loadOpsList"));
            mInitMap.put(new Pair<String, String>("func_72418_v", "readWhiteList"));
            mInitMap.put(new Pair<String, String>("func_72419_u", "saveOpsList"));
            mInitMap.put(new Pair<String, String>("func_72421_w", "saveWhiteList"));
            mInitMap.put(new Pair<String, String>("func_72429_b", "getIntermediateWithXValue"));
            mInitMap.put(new Pair<String, String>("func_72430_b", "dotProduct"));
            mInitMap.put(new Pair<String, String>("func_72431_c", "crossProduct"));
            mInitMap.put(new Pair<String, String>("func_72432_b", "normalize"));
            mInitMap.put(new Pair<String, String>("func_72433_c", "lengthVector"));
            mInitMap.put(new Pair<String, String>("func_72434_d", "getIntermediateWithZValue"));
            mInitMap.put(new Pair<String, String>("func_72435_c", "getIntermediateWithYValue"));
            mInitMap.put(new Pair<String, String>("func_72436_e", "squareDistanceTo"));
            mInitMap.put(new Pair<String, String>("func_72438_d", "distanceTo"));
            mInitMap.put(new Pair<String, String>("func_72439_b", "setComponents"));
            mInitMap.put(new Pair<String, String>("func_72440_a", "rotateAroundX"));
            mInitMap.put(new Pair<String, String>("func_72441_c", "addVector"));
            mInitMap.put(new Pair<String, String>("func_72442_b", "rotateAroundY"));
            mInitMap.put(new Pair<String, String>("func_72443_a", "createVectorHelper"));
            mInitMap.put(new Pair<String, String>("func_72444_a", "subtract"));
            mInitMap.put(new Pair<String, String>("func_72445_d", "squareDistanceTo"));
            mInitMap.put(new Pair<String, String>("func_72446_c", "rotateAroundZ"));
            mInitMap.put(new Pair<String, String>("func_72591_c", "getRequestId"));
            mInitMap.put(new Pair<String, String>("func_72592_a", "getRandomChallenge"));
            mInitMap.put(new Pair<String, String>("func_72593_a", "hasExpired"));
            mInitMap.put(new Pair<String, String>("func_72594_b", "getChallengeValue"));
            mInitMap.put(new Pair<String, String>("func_72601_a", "registerSocket"));
            mInitMap.put(new Pair<String, String>("func_72602_a", "startThread"));
            mInitMap.put(new Pair<String, String>("func_72603_d", "getNumberOfPlayers"));
            mInitMap.put(new Pair<String, String>("func_72604_a", "closeSocket"));
            mInitMap.put(new Pair<String, String>("func_72605_a", "closeServerSocket_do"));
            mInitMap.put(new Pair<String, String>("func_72606_c", "logWarning"));
            mInitMap.put(new Pair<String, String>("func_72607_a", "logDebug"));
            mInitMap.put(new Pair<String, String>("func_72608_b", "closeServerSocket"));
            mInitMap.put(new Pair<String, String>("func_72609_b", "logInfo"));
            mInitMap.put(new Pair<String, String>("func_72610_d", "logSevere"));
            mInitMap.put(new Pair<String, String>("func_72611_e", "closeAllSockets"));
            mInitMap.put(new Pair<String, String>("func_72612_a", "closeAllSockets_do"));
            mInitMap.put(new Pair<String, String>("func_72613_c", "isRunning"));
            mInitMap.put(new Pair<String, String>("func_72620_a", "sendResponsePacket"));
            mInitMap.put(new Pair<String, String>("func_72621_a", "parseIncomingPacket"));
            mInitMap.put(new Pair<String, String>("func_72622_d", "sendAuthChallenge"));
            mInitMap.put(new Pair<String, String>("func_72623_a", "stopWithException"));
            mInitMap.put(new Pair<String, String>("func_72624_b", "createQueryResponse"));
            mInitMap.put(new Pair<String, String>("func_72625_a", "getRequestID"));
            mInitMap.put(new Pair<String, String>("func_72626_g", "initQuerySystem"));
            mInitMap.put(new Pair<String, String>("func_72627_c", "verifyClientAuth"));
            mInitMap.put(new Pair<String, String>("func_72628_f", "cleanQueryClientsMap"));
            mInitMap.put(new Pair<String, String>("func_72645_g", "cleanClientThreadsMap"));
            mInitMap.put(new Pair<String, String>("func_72646_f", "initClientThreadList"));
            mInitMap.put(new Pair<String, String>("func_72653_g", "closeSocket"));
            mInitMap.put(new Pair<String, String>("func_72654_a", "sendResponse"));
            mInitMap.put(new Pair<String, String>("func_72655_a", "sendMultipacketResponse"));
            mInitMap.put(new Pair<String, String>("func_72656_f", "sendLoginFailedResponse"));
            mInitMap.put(new Pair<String, String>("func_72661_a", "getBytesAsString"));
            mInitMap.put(new Pair<String, String>("func_72662_b", "getRemainingBytesAsLEInt"));
            mInitMap.put(new Pair<String, String>("func_72663_a", "getByteAsHexString"));
            mInitMap.put(new Pair<String, String>("func_72664_c", "getBytesAsBEint"));
            mInitMap.put(new Pair<String, String>("func_72665_b", "getBytesAsLEInt"));
            mInitMap.put(new Pair<String, String>("func_72667_a", "writeInt"));
            mInitMap.put(new Pair<String, String>("func_72668_a", "writeShort"));
            mInitMap.put(new Pair<String, String>("func_72669_b", "reset"));
            mInitMap.put(new Pair<String, String>("func_72670_a", "writeByteArray"));
            mInitMap.put(new Pair<String, String>("func_72671_a", "writeString"));
            mInitMap.put(new Pair<String, String>("func_72672_a", "toByteArray"));
            mInitMap.put(new Pair<String, String>("func_72683_a", "addPlayer"));
            mInitMap.put(new Pair<String, String>("func_72684_a", "overlaps"));
            mInitMap.put(new Pair<String, String>("func_72685_d", "updateMountedMovingPlayer"));
            mInitMap.put(new Pair<String, String>("func_72686_a", "getFurthestViewableBlock"));
            mInitMap.put(new Pair<String, String>("func_72688_a", "getMinecraftServer"));
            mInitMap.put(new Pair<String, String>("func_72690_a", "getPlayerInstance"));
            mInitMap.put(new Pair<String, String>("func_72691_b", "filterChunkLoadQueue"));
            mInitMap.put(new Pair<String, String>("func_72693_b", "updatePlayerInstances"));
            mInitMap.put(new Pair<String, String>("func_72694_a", "isPlayerWatchingChunk"));
            mInitMap.put(new Pair<String, String>("func_72695_c", "removePlayer"));
            mInitMap.put(new Pair<String, String>("func_72702_a", "playRecord"));
            mInitMap.put(new Pair<String, String>("func_72703_a", "onEntityCreate"));
            mInitMap.put(new Pair<String, String>("func_72704_a", "playSound"));
            mInitMap.put(new Pair<String, String>("func_72706_a", "playAuxSFX"));
            mInitMap.put(new Pair<String, String>("func_72708_a", "spawnParticle"));
            mInitMap.put(new Pair<String, String>("func_72709_b", "onEntityDestroy"));
            mInitMap.put(new Pair<String, String>("func_72712_a", "loadRenderers"));
            mInitMap.put(new Pair<String, String>("func_72714_a", "renderSky"));
            mInitMap.put(new Pair<String, String>("func_72716_a", "updateRenderers"));
            mInitMap.put(new Pair<String, String>("func_72717_a", "drawBlockDamageTexture"));
            mInitMap.put(new Pair<String, String>("func_72718_b", "renderClouds"));
            mInitMap.put(new Pair<String, String>("func_72719_a", "sortAndRender"));
            mInitMap.put(new Pair<String, String>("func_72720_a", "checkOcclusionQueryResult"));
            mInitMap.put(new Pair<String, String>("func_72721_a", "hasCloudFog"));
            mInitMap.put(new Pair<String, String>("func_72722_c", "markRenderersFormInitMap.put(newPosition"));
            mInitMap.put(new Pair<String, String>("func_72723_d", "getDebugInfoEntities"));
            mInitMap.put(new Pair<String, String>("func_72724_a", "renderSortedRenderers"));
            mInitMap.put(new Pair<String, String>("func_72725_b", "markBlocksForUpdate"));
            mInitMap.put(new Pair<String, String>("func_72726_b", "doSpawnParticle"));
            mInitMap.put(new Pair<String, String>("func_72728_f", "deleteAllDisplayLists"));
            mInitMap.put(new Pair<String, String>("func_72729_a", "clipRenderersByFrustum"));
            mInitMap.put(new Pair<String, String>("func_72730_g", "renderStars"));
            mInitMap.put(new Pair<String, String>("func_72731_b", "drawSelectionBox"));
            mInitMap.put(new Pair<String, String>("func_72732_a", "setWorldAndLoadRenderers"));
            mInitMap.put(new Pair<String, String>("func_72733_a", "renderAllRenderLists"));
            mInitMap.put(new Pair<String, String>("func_72734_e", "updateClouds"));
            mInitMap.put(new Pair<String, String>("func_72735_c", "getDebugInfoRenders"));
            mInitMap.put(new Pair<String, String>("func_72736_c", "renderCloudsFancy"));
            mInitMap.put(new Pair<String, String>("func_72785_a", "addEntityToTracker"));
            mInitMap.put(new Pair<String, String>("func_72786_a", "trackEntity"));
            mInitMap.put(new Pair<String, String>("func_72787_a", "removePlayerFromTrackers"));
            mInitMap.put(new Pair<String, String>("func_72788_a", "updateTrackedEntities"));
            mInitMap.put(new Pair<String, String>("func_72790_b", "untrackEntity"));
            mInitMap.put(new Pair<String, String>("func_72791_a", "trackEntity"));
            mInitMap.put(new Pair<String, String>("func_72800_K", "getHeight"));
            mInitMap.put(new Pair<String, String>("func_72801_o", "getLightBrightness"));
            mInitMap.put(new Pair<String, String>("func_72802_i", "getLightBrightnessForSkyBlocks"));
            mInitMap.put(new Pair<String, String>("func_72805_g", "getBlockMetadata"));
            mInitMap.put(new Pair<String, String>("func_72806_N", "extendedLevelsInChunkCache"));
            mInitMap.put(new Pair<String, String>("func_72807_a", "getBiomeGenForCoords"));
            mInitMap.put(new Pair<String, String>("func_72810_a", "getSkyBlockTypeBrightness"));
            mInitMap.put(new Pair<String, String>("func_72812_b", "getSpecialBlockBrightness"));
            mInitMap.put(new Pair<String, String>("func_72819_i", "getWeightedThunderStrength"));
            mInitMap.put(new Pair<String, String>("func_72820_D", "getWorldTime"));
            mInitMap.put(new Pair<String, String>("func_72823_a", "setItemData"));
            mInitMap.put(new Pair<String, String>("func_72824_f", "getCloudColour"));
            mInitMap.put(new Pair<String, String>("func_72825_h", "getTopSolidOrLiquidBlock"));
            mInitMap.put(new Pair<String, String>("func_72826_c", "getCelestialAngle"));
            mInitMap.put(new Pair<String, String>("func_72827_u", "getProviderName"));
            mInitMap.put(new Pair<String, String>("func_72828_b", "unloadEntities"));
            mInitMap.put(new Pair<String, String>("func_72829_c", "checkBlockCollision"));
            mInitMap.put(new Pair<String, String>("func_72830_b", "isAABBInMaterial"));
            mInitMap.put(new Pair<String, String>("func_72833_a", "getSkyColor"));
            mInitMap.put(new Pair<String, String>("func_72834_c", "canBlockFreeze"));
            mInitMap.put(new Pair<String, String>("func_72835_b", "tick"));
            mInitMap.put(new Pair<String, String>("func_72838_d", "spawnEntityInWorld"));
            mInitMap.put(new Pair<String, String>("func_72839_b", "getEntitiesWithinAABBExcludingEntity"));
            mInitMap.put(new Pair<String, String>("func_72841_b", "getUniqueDataId"));
            mInitMap.put(new Pair<String, String>("func_72842_a", "getBlockDensity"));
            mInitMap.put(new Pair<String, String>("func_72843_D", "setRandomSeed"));
            mInitMap.put(new Pair<String, String>("func_72844_a", "getEntityPathToXYZ"));
            mInitMap.put(new Pair<String, String>("func_72846_b", "getClosestVulnerablePlayer"));
            mInitMap.put(new Pair<String, String>("func_72847_b", "onEntityRemoved"));
            mInitMap.put(new Pair<String, String>("func_72848_b", "removeWorldAccess"));
            mInitMap.put(new Pair<String, String>("func_72849_a", "getBlockLightValue_do"));
            mInitMap.put(new Pair<String, String>("func_72850_v", "isBlockFreezableNaturally"));
            mInitMap.put(new Pair<String, String>("func_72853_d", "getMoonPhase"));
            mInitMap.put(new Pair<String, String>("func_72854_c", "updateAllPlayersSleepingFlag"));
            mInitMap.put(new Pair<String, String>("func_72855_b", "checkNoEntityCollision"));
            mInitMap.put(new Pair<String, String>("func_72856_b", "getClosestVulnerablePlayerToEntity"));
            mInitMap.put(new Pair<String, String>("func_72857_a", "findNearestEntityWithinAABB"));
            mInitMap.put(new Pair<String, String>("func_72860_G", "getSaveHandler"));
            mInitMap.put(new Pair<String, String>("func_72861_E", "getSpawnPoint"));
            mInitMap.put(new Pair<String, String>("func_72863_F", "getChunkProvider"));
            mInitMap.put(new Pair<String, String>("func_72864_z", "isBlockIndirectlyGettingPowered"));
            mInitMap.put(new Pair<String, String>("func_72865_a", "getPathEntityToEntity"));
            mInitMap.put(new Pair<String, String>("func_72866_a", "updateEntityWithOptionalForce"));
            mInitMap.put(new Pair<String, String>("func_72867_j", "getRainStrength"));
            mInitMap.put(new Pair<String, String>("func_72868_a", "addLoadedEntities"));
            mInitMap.put(new Pair<String, String>("func_72869_a", "spawnParticle"));
            mInitMap.put(new Pair<String, String>("func_72870_g", "updateEntity"));
            mInitMap.put(new Pair<String, String>("func_72872_a", "getEntitiesWithinAABB"));
            mInitMap.put(new Pair<String, String>("func_72873_a", "doChunksNearChunkExist"));
            mInitMap.put(new Pair<String, String>("func_72874_g", "getPrecipitationHeight"));
            mInitMap.put(new Pair<String, String>("func_72875_a", "isMaterialInBB"));
            mInitMap.put(new Pair<String, String>("func_72876_a", "createExplosion"));
            mInitMap.put(new Pair<String, String>("func_72877_b", "setWorldTime"));
            mInitMap.put(new Pair<String, String>("func_72878_l", "getIndirectPowerLevelTo"));
            mInitMap.put(new Pair<String, String>("func_72879_k", "isBlockProvidingPowerTo"));
            mInitMap.put(new Pair<String, String>("func_72880_h", "getStarBrightness"));
            mInitMap.put(new Pair<String, String>("func_72882_A", "sendQuittingDisconnectingPacket"));
            mInitMap.put(new Pair<String, String>("func_72883_k", "getFullBlockLightValue"));
            mInitMap.put(new Pair<String, String>("func_72884_u", "isBlockFreezable"));
            mInitMap.put(new Pair<String, String>("func_72885_a", "mInitMap.put(newExplosion"));
            mInitMap.put(new Pair<String, String>("func_72886_a", "extinguishFire"));
            mInitMap.put(new Pair<String, String>("func_72889_a", "playAuxSFXAtEntity"));
            mInitMap.put(new Pair<String, String>("func_72890_a", "getClosestPlayerToEntity"));
            mInitMap.put(new Pair<String, String>("func_72891_a", "setAllowedSpawnTypes"));
            mInitMap.put(new Pair<String, String>("func_72894_k", "setRainStrength"));
            mInitMap.put(new Pair<String, String>("func_72896_J", "isRaining"));
            mInitMap.put(new Pair<String, String>("func_72897_h", "joinEntityInSurroundings"));
            mInitMap.put(new Pair<String, String>("func_72899_e", "blockExists"));
            mInitMap.put(new Pair<String, String>("func_72900_e", "removeEntity"));
            mInitMap.put(new Pair<String, String>("func_72901_a", "rayTraceBlocks"));
            mInitMap.put(new Pair<String, String>("func_72903_x", "setActivePlayerChunksAndCheckLight"));
            mInitMap.put(new Pair<String, String>("func_72904_c", "checkChunksExist"));
            mInitMap.put(new Pair<String, String>("func_72905_C", "getSeed"));
            mInitMap.put(new Pair<String, String>("func_72906_B", "checkSessionLock"));
            mInitMap.put(new Pair<String, String>("func_72907_a", "countEntities"));
            mInitMap.put(new Pair<String, String>("func_72908_a", "playSoundEffect"));
            mInitMap.put(new Pair<String, String>("func_72910_y", "getLoadedEntityList"));
            mInitMap.put(new Pair<String, String>("func_72911_I", "isThundering"));
            mInitMap.put(new Pair<String, String>("func_72912_H", "getWorldInfo"));
            mInitMap.put(new Pair<String, String>("func_72914_a", "addWorldInfoToCrashReport"));
            mInitMap.put(new Pair<String, String>("func_72915_b", "setLightValue"));
            mInitMap.put(new Pair<String, String>("func_72916_c", "chunkExists"));
            mInitMap.put(new Pair<String, String>("func_72917_a", "checkNoEntityCollision"));
            mInitMap.put(new Pair<String, String>("func_72918_a", "handleMaterialAcceleration"));
            mInitMap.put(new Pair<String, String>("func_72919_O", "getHorizon"));
            mInitMap.put(new Pair<String, String>("func_72920_a", "getPendingBlockUpdates"));
            mInitMap.put(new Pair<String, String>("func_72921_c", "setBlockMetadataWithNotify"));
            mInitMap.put(new Pair<String, String>("func_72923_a", "onEntityAdded"));
            mInitMap.put(new Pair<String, String>("func_72924_a", "getPlayerEntityByName"));
            mInitMap.put(new Pair<String, String>("func_72925_a", "getSkyBlockTypeBrightness"));
            mInitMap.put(new Pair<String, String>("func_72926_e", "playAuxSFX"));
            mInitMap.put(new Pair<String, String>("func_72929_e", "getCelestialAngleRadians"));
            mInitMap.put(new Pair<String, String>("func_72933_a", "rayTraceBlocks"));
            mInitMap.put(new Pair<String, String>("func_72934_a", "playRecord"));
            mInitMap.put(new Pair<String, String>("func_72935_r", "isDaytime"));
            mInitMap.put(new Pair<String, String>("func_72937_j", "canBlockSeeTheSky"));
            mInitMap.put(new Pair<String, String>("func_72938_d", "getChunkFromBlockCoords"));
            mInitMap.put(new Pair<String, String>("func_72939_s", "updateEntities"));
            mInitMap.put(new Pair<String, String>("func_72940_L", "getActualHeight"));
            mInitMap.put(new Pair<String, String>("func_72942_c", "addWeatherEffect"));
            mInitMap.put(new Pair<String, String>("func_72943_a", "loadItemData"));
            mInitMap.put(new Pair<String, String>("func_72945_a", "getCollidingBoundingBoxes"));
            mInitMap.put(new Pair<String, String>("func_72947_a", "calculateInitialWeather"));
            mInitMap.put(new Pair<String, String>("func_72948_g", "getFogColor"));
            mInitMap.put(new Pair<String, String>("func_72950_A", "setSpawnLocation"));
            mInitMap.put(new Pair<String, String>("func_72951_B", "isRainingAt"));
            mInitMap.put(new Pair<String, String>("func_72953_d", "isAnyLiquid"));
            mInitMap.put(new Pair<String, String>("func_72954_a", "addWorldAccess"));
            mInitMap.put(new Pair<String, String>("func_72955_a", "tickUpdates"));
            mInitMap.put(new Pair<String, String>("func_72956_a", "playSoundAtEntity"));
            mInitMap.put(new Pair<String, String>("func_72957_l", "getBlockLightValue"));
            mInitMap.put(new Pair<String, String>("func_72958_C", "isBlockHighHumidity"));
            mInitMap.put(new Pair<String, String>("func_72959_q", "getWorldChunkManager"));
            mInitMap.put(new Pair<String, String>("func_72960_a", "setEntityState"));
            mInitMap.put(new Pair<String, String>("func_72962_a", "canMineBlock"));
            mInitMap.put(new Pair<String, String>("func_72963_a", "initialize"));
            mInitMap.put(new Pair<String, String>("func_72964_e", "getChunkFromChunkCoords"));
            mInitMap.put(new Pair<String, String>("func_72966_v", "calculateInitialSkylight"));
            mInitMap.put(new Pair<String, String>("func_72967_a", "calculateSkylightSubtracted"));
            mInitMap.put(new Pair<String, String>("func_72970_h", "createChunkProvider"));
            mInitMap.put(new Pair<String, String>("func_72971_b", "getSunBrightness"));
            mInitMap.put(new Pair<String, String>("func_72972_b", "getSavedLightValue"));
            mInitMap.put(new Pair<String, String>("func_72973_f", "removePlayerEntityDangerously"));
            mInitMap.put(new Pair<String, String>("func_72974_f", "setSpawnLocation"));
            mInitMap.put(new Pair<String, String>("func_72975_g", "markBlocksDirtyVertical"));
            mInitMap.put(new Pair<String, String>("func_72976_f", "getHeightValue"));
            mInitMap.put(new Pair<String, String>("func_72977_a", "getClosestPlayer"));
            mInitMap.put(new Pair<String, String>("func_72979_l", "updateWeather"));
            mInitMap.put(new Pair<String, String>("func_72980_b", "playSound"));
            mInitMap.put(new Pair<String, String>("func_72981_t", "getDebugLoadedEntities"));
            mInitMap.put(new Pair<String, String>("func_73022_a", "removeAllEntities"));
            mInitMap.put(new Pair<String, String>("func_73025_a", "doPreChunk"));
            mInitMap.put(new Pair<String, String>("func_73027_a", "addEntityToWorld"));
            mInitMap.put(new Pair<String, String>("func_73028_b", "removeEntityFromWorld"));
            mInitMap.put(new Pair<String, String>("func_73029_E", "doVoidFogParticles"));
            mInitMap.put(new Pair<String, String>("func_73031_a", "invalidateBlockReceiveRegion"));
            mInitMap.put(new Pair<String, String>("func_73039_n", "getEntityTracker"));
            mInitMap.put(new Pair<String, String>("func_73040_p", "getPlayerManager"));
            mInitMap.put(new Pair<String, String>("func_73041_k", "flush"));
            mInitMap.put(new Pair<String, String>("func_73042_a", "saveLevel"));
            mInitMap.put(new Pair<String, String>("func_73044_a", "saveAllChunks"));
            mInitMap.put(new Pair<String, String>("func_73045_a", "getEntityByID"));
            mInitMap.put(new Pair<String, String>("func_73047_i", "createBonusChest"));
            mInitMap.put(new Pair<String, String>("func_73051_P", "resetRainAndThunder"));
            mInitMap.put(new Pair<String, String>("func_73052_b", "createSpawnPosition"));
            mInitMap.put(new Pair<String, String>("func_73053_d", "wakeAllPlayers"));
            mInitMap.put(new Pair<String, String>("func_73054_j", "getEntrancePortalLocation"));
            mInitMap.put(new Pair<String, String>("func_73056_e", "areAllPlayersAsleep"));
            mInitMap.put(new Pair<String, String>("func_73057_a", "spawnRandomCreature"));
            mInitMap.put(new Pair<String, String>("func_73073_c", "cancelDestroyingBlock"));
            mInitMap.put(new Pair<String, String>("func_73074_a", "onBlockClicked"));
            mInitMap.put(new Pair<String, String>("func_73075_a", "updateBlockRemoving"));
            mInitMap.put(new Pair<String, String>("func_73076_a", "setGameType"));
            mInitMap.put(new Pair<String, String>("func_73077_b", "initializeGameType"));
            mInitMap.put(new Pair<String, String>("func_73078_a", "activateBlockOrUseItem"));
            mInitMap.put(new Pair<String, String>("func_73079_d", "removeBlock"));
            mInitMap.put(new Pair<String, String>("func_73080_a", "setWorld"));
            mInitMap.put(new Pair<String, String>("func_73081_b", "getGameType"));
            mInitMap.put(new Pair<String, String>("func_73082_a", "blockRemoving"));
            mInitMap.put(new Pair<String, String>("func_73083_d", "isCreative"));
            mInitMap.put(new Pair<String, String>("func_73084_b", "tryHarvestBlock"));
            mInitMap.put(new Pair<String, String>("func_73085_a", "tryUseItem"));
            mInitMap.put(new Pair<String, String>("func_73101_e", "sendDemoReminder"));
            mInitMap.put(new Pair<String, String>("func_73106_e", "getPartialBlockDamage"));
            mInitMap.put(new Pair<String, String>("func_73107_a", "setPartialBlockDamage"));
            mInitMap.put(new Pair<String, String>("func_73108_d", "getPartialBlockZ"));
            mInitMap.put(new Pair<String, String>("func_73109_c", "getPartialBlockY"));
            mInitMap.put(new Pair<String, String>("func_73110_b", "getPartialBlockX"));
            mInitMap.put(new Pair<String, String>("func_73117_b", "updatePlayerEntity"));
            mInitMap.put(new Pair<String, String>("func_73118_a", "removeFromTrackedPlayers"));
            mInitMap.put(new Pair<String, String>("func_73119_a", "sendDestroyEntityPacketToTrackedPlayers"));
            mInitMap.put(new Pair<String, String>("func_73121_d", "isPlayerWatchingThisChunk"));
            mInitMap.put(new Pair<String, String>("func_73122_a", "updatePlayerList"));
            mInitMap.put(new Pair<String, String>("func_73123_c", "removeTrackedPlayerSymmetric"));
            mInitMap.put(new Pair<String, String>("func_73125_b", "updatePlayerEntities"));
            mInitMap.put(new Pair<String, String>("func_73148_d", "makeString"));
            mInitMap.put(new Pair<String, String>("func_73149_a", "chunkExists"));
            mInitMap.put(new Pair<String, String>("func_73151_a", "saveChunks"));
            mInitMap.put(new Pair<String, String>("func_73152_e", "getLoadedChunkCount"));
            mInitMap.put(new Pair<String, String>("func_73153_a", "populate"));
            mInitMap.put(new Pair<String, String>("func_73154_d", "provideChunk"));
            mInitMap.put(new Pair<String, String>("func_73155_a", "getPossibleCreatures"));
            mInitMap.put(new Pair<String, String>("func_73156_b", "unloadQueuedChunks"));
            mInitMap.put(new Pair<String, String>("func_73157_c", "canSave"));
            mInitMap.put(new Pair<String, String>("func_73158_c", "loadChunk"));
            mInitMap.put(new Pair<String, String>("func_73164_a", "initializeNoiseField"));
            mInitMap.put(new Pair<String, String>("func_73187_a", "initializeNoiseField"));
            mInitMap.put(new Pair<String, String>("func_73234_b", "unloadChunk"));
            mInitMap.put(new Pair<String, String>("func_73239_e", "loadChunkFromFile"));
            mInitMap.put(new Pair<String, String>("func_73240_a", "unloadAllChunks"));
            mInitMap.put(new Pair<String, String>("func_73241_b", "dropChunk"));
            mInitMap.put(new Pair<String, String>("func_73242_b", "saveChunkData"));
            mInitMap.put(new Pair<String, String>("func_73243_a", "saveChunkExtraData"));
            mInitMap.put(new Pair<String, String>("func_73252_b", "removePlayer"));
            mInitMap.put(new Pair<String, String>("func_73254_a", "onUpdate"));
            mInitMap.put(new Pair<String, String>("func_73255_a", "addPlayer"));
            mInitMap.put(new Pair<String, String>("func_73660_a", "update"));
            mInitMap.put(new Pair<String, String>("func_73665_c", "getPropertiesFile"));
            mInitMap.put(new Pair<String, String>("func_73666_a", "generatemInitMap.put(newProperties"));
            mInitMap.put(new Pair<String, String>("func_73667_a", "setProperty"));
            mInitMap.put(new Pair<String, String>("func_73668_b", "saveProperties"));
            mInitMap.put(new Pair<String, String>("func_73669_a", "getIntProperty"));
            mInitMap.put(new Pair<String, String>("func_73670_a", "getBooleanProperty"));
            mInitMap.put(new Pair<String, String>("func_73671_a", "getStringProperty"));
            mInitMap.put(new Pair<String, String>("func_73680_d", "getBanEndDate"));
            mInitMap.put(new Pair<String, String>("func_73682_e", "hasBanExpired"));
            mInitMap.put(new Pair<String, String>("func_73686_f", "getBanReason"));
            mInitMap.put(new Pair<String, String>("func_73718_a", "setLoadingProgress"));
            mInitMap.put(new Pair<String, String>("func_73719_c", "displayLoadingString"));
            mInitMap.put(new Pair<String, String>("func_73720_a", "displaySavingString"));
            mInitMap.put(new Pair<String, String>("func_73721_b", "resetProgressAndMessage"));
            mInitMap.put(new Pair<String, String>("func_73728_b", "drawVerticalLine"));
            mInitMap.put(new Pair<String, String>("func_73729_b", "drawTexturedModalRect"));
            mInitMap.put(new Pair<String, String>("func_73730_a", "drawHorizontalLine"));
            mInitMap.put(new Pair<String, String>("func_73731_b", "drawString"));
            mInitMap.put(new Pair<String, String>("func_73732_a", "drawCenteredString"));
            mInitMap.put(new Pair<String, String>("func_73733_a", "drawGradientRect"));
            mInitMap.put(new Pair<String, String>("func_73734_a", "drawRect"));
            mInitMap.put(new Pair<String, String>("func_73828_d", "renderBossHealth"));
            mInitMap.put(new Pair<String, String>("func_73829_a", "renderVignette"));
            mInitMap.put(new Pair<String, String>("func_73830_a", "renderGameOverlay"));
            mInitMap.put(new Pair<String, String>("func_73831_a", "updateTick"));
            mInitMap.put(new Pair<String, String>("func_73832_a", "renderInventorySlot"));
            mInitMap.put(new Pair<String, String>("func_73833_a", "setRecordPlayingMessage"));
            mInitMap.put(new Pair<String, String>("func_73834_c", "getUpdateCounter"));
            mInitMap.put(new Pair<String, String>("func_73836_a", "renderPumpkinBlur"));
            mInitMap.put(new Pair<String, String>("func_73863_a", "drawScreen"));
            mInitMap.put(new Pair<String, String>("func_73864_a", "mouseClicked"));
            mInitMap.put(new Pair<String, String>("func_73866_w_", "initGui"));
            mInitMap.put(new Pair<String, String>("func_73868_f", "doesGuiPauseGame"));
            mInitMap.put(new Pair<String, String>("func_73869_a", "keyTyped"));
            mInitMap.put(new Pair<String, String>("func_73876_c", "updateScreen"));
            mInitMap.put(new Pair<String, String>("func_73878_a", "confirmClicked"));
            mInitMap.put(new Pair<String, String>("func_73968_a", "rotateAndBlurSkybox"));
            mInitMap.put(new Pair<String, String>("func_73969_a", "addSingleplayerMultiplayerButtons"));
            mInitMap.put(new Pair<String, String>("func_73970_b", "drawPanorama"));
            mInitMap.put(new Pair<String, String>("func_73971_c", "renderSkybox"));
            mInitMap.put(new Pair<String, String>("func_73972_b", "addDemoButtons"));
            mInitMap.put(new Pair<String, String>("func_74275_a", "updateTimer"));
            mInitMap.put(new Pair<String, String>("func_74290_a", "getTimestampedPNGFileForDirectory"));
            mInitMap.put(new Pair<String, String>("func_74296_a", "getOptionFloatValue"));
            mInitMap.put(new Pair<String, String>("func_74297_c", "getKeyBinding"));
            mInitMap.put(new Pair<String, String>("func_74298_c", "getKeyDisplayString"));
            mInitMap.put(new Pair<String, String>("func_74299_a", "getTranslation"));
            mInitMap.put(new Pair<String, String>("func_74300_a", "loadOptions"));
            mInitMap.put(new Pair<String, String>("func_74303_b", "saveOptions"));
            mInitMap.put(new Pair<String, String>("func_74304_a", "setOptionFloatValue"));
            mInitMap.put(new Pair<String, String>("func_74305_a", "parseFloat"));
            mInitMap.put(new Pair<String, String>("func_74306_a", "setOptionValue"));
            mInitMap.put(new Pair<String, String>("func_74308_b", "getOptionOrdinalValue"));
            mInitMap.put(new Pair<String, String>("func_74309_c", "shouldRenderClouds"));
            mInitMap.put(new Pair<String, String>("func_74371_a", "checkARBOcclusion"));
            mInitMap.put(new Pair<String, String>("func_74372_a", "grabMouseCursor"));
            mInitMap.put(new Pair<String, String>("func_74373_b", "ungrabMouseCursor"));
            mInitMap.put(new Pair<String, String>("func_74374_c", "mouseXYChange"));
            mInitMap.put(new Pair<String, String>("func_74378_d", "getEnumString"));
            mInitMap.put(new Pair<String, String>("func_74379_a", "getEnumOptions"));
            mInitMap.put(new Pair<String, String>("func_74380_a", "getEnumFloat"));
            mInitMap.put(new Pair<String, String>("func_74381_c", "returnEnumOrdinal"));
            mInitMap.put(new Pair<String, String>("func_74382_b", "getEnumBoolean"));
            mInitMap.put(new Pair<String, String>("func_74428_b", "processReceivedPackets"));
            mInitMap.put(new Pair<String, String>("func_74430_c", "getRemoteAddress"));
            mInitMap.put(new Pair<String, String>("func_74505_d", "unpressKey"));
            mInitMap.put(new Pair<String, String>("func_74506_a", "unPressAllKeys"));
            mInitMap.put(new Pair<String, String>("func_74507_a", "onTick"));
            mInitMap.put(new Pair<String, String>("func_74508_b", "resetKeyBindingArrayAndHash"));
            mInitMap.put(new Pair<String, String>("func_74510_a", "setKeyBindState"));
            mInitMap.put(new Pair<String, String>("func_74517_a", "setColorBuffer"));
            mInitMap.put(new Pair<String, String>("func_74518_a", "disableStandardItemLighting"));
            mInitMap.put(new Pair<String, String>("func_74519_b", "enableStandardItemLighting"));
            mInitMap.put(new Pair<String, String>("func_74520_c", "enableGUIStandardItemLighting"));
            mInitMap.put(new Pair<String, String>("func_74521_a", "setColorBuffer"));
            mInitMap.put(new Pair<String, String>("func_74523_b", "deleteDisplayLists"));
            mInitMap.put(new Pair<String, String>("func_74524_c", "createDirectByteBuffer"));
            mInitMap.put(new Pair<String, String>("func_74525_a", "deleteTexturesAndDisplayLists"));
            mInitMap.put(new Pair<String, String>("func_74526_a", "generateDisplayLists"));
            mInitMap.put(new Pair<String, String>("func_74527_f", "createDirectIntBuffer"));
            mInitMap.put(new Pair<String, String>("func_74529_h", "createDirectFloatBuffer"));
            mInitMap.put(new Pair<String, String>("func_74535_a", "formatString"));
            mInitMap.put(new Pair<String, String>("func_74539_c", "getChatLineID"));
            mInitMap.put(new Pair<String, String>("func_74540_b", "getUpdatedCounter"));
            mInitMap.put(new Pair<String, String>("func_74583_a", "updateRenderInfo"));
            mInitMap.put(new Pair<String, String>("func_74585_b", "projectViewFromEntity"));
            mInitMap.put(new Pair<String, String>("func_74732_a", "getId"));
            mInitMap.put(new Pair<String, String>("func_74734_a", "write"));
            mInitMap.put(new Pair<String, String>("func_74737_b", "copy"));
            mInitMap.put(new Pair<String, String>("func_74742_a", "appendTag"));
            mInitMap.put(new Pair<String, String>("func_74744_a", "removeTag"));
            mInitMap.put(new Pair<String, String>("func_74745_c", "tagCount"));
            mInitMap.put(new Pair<String, String>("func_74757_a", "setBoolean"));
            mInitMap.put(new Pair<String, String>("func_74759_k", "getIntArray"));
            mInitMap.put(new Pair<String, String>("func_74760_g", "getFloat"));
            mInitMap.put(new Pair<String, String>("func_74762_e", "getInteger"));
            mInitMap.put(new Pair<String, String>("func_74763_f", "getLong"));
            mInitMap.put(new Pair<String, String>("func_74764_b", "hasKey"));
            mInitMap.put(new Pair<String, String>("func_74765_d", "getShort"));
            mInitMap.put(new Pair<String, String>("func_74767_n", "getBoolean"));
            mInitMap.put(new Pair<String, String>("func_74768_a", "setInteger"));
            mInitMap.put(new Pair<String, String>("func_74769_h", "getDouble"));
            mInitMap.put(new Pair<String, String>("func_74770_j", "getByteArray"));
            mInitMap.put(new Pair<String, String>("func_74771_c", "getByte"));
            mInitMap.put(new Pair<String, String>("func_74772_a", "setLong"));
            mInitMap.put(new Pair<String, String>("func_74773_a", "setByteArray"));
            mInitMap.put(new Pair<String, String>("func_74774_a", "setByte"));
            mInitMap.put(new Pair<String, String>("func_74775_l", "getCompoundTag"));
            mInitMap.put(new Pair<String, String>("func_74776_a", "setFloat"));
            mInitMap.put(new Pair<String, String>("func_74777_a", "setShort"));
            mInitMap.put(new Pair<String, String>("func_74778_a", "setString"));
            mInitMap.put(new Pair<String, String>("func_74779_i", "getString"));
            mInitMap.put(new Pair<String, String>("func_74780_a", "setDouble"));
            mInitMap.put(new Pair<String, String>("func_74781_a", "getTag"));
            mInitMap.put(new Pair<String, String>("func_74782_a", "setTag"));
            mInitMap.put(new Pair<String, String>("func_74783_a", "setIntArray"));
            mInitMap.put(new Pair<String, String>("func_74793_a", "safeWrite"));
            mInitMap.put(new Pair<String, String>("func_74794_a", "read"));
            mInitMap.put(new Pair<String, String>("func_74795_b", "write"));
            mInitMap.put(new Pair<String, String>("func_74796_a", "readCompressed"));
            mInitMap.put(new Pair<String, String>("func_74797_a", "read"));
            mInitMap.put(new Pair<String, String>("func_74798_a", "compress"));
            mInitMap.put(new Pair<String, String>("func_74799_a", "writeCompressed"));
            mInitMap.put(new Pair<String, String>("func_74800_a", "write"));
            mInitMap.put(new Pair<String, String>("func_74803_a", "translateKeyFormat"));
            mInitMap.put(new Pair<String, String>("func_74805_b", "translateKey"));
            mInitMap.put(new Pair<String, String>("func_74808_a", "getInstance"));
            mInitMap.put(new Pair<String, String>("func_74837_a", "translateToLocalFormatted"));
            mInitMap.put(new Pair<String, String>("func_74838_a", "translateToLocal"));
            mInitMap.put(new Pair<String, String>("func_74844_a", "getErrorOjbects"));
            mInitMap.put(new Pair<String, String>("func_74860_a", "isLiquidInStructureBoundingBox"));
            mInitMap.put(new Pair<String, String>("func_74861_a", "buildComponent"));
            mInitMap.put(new Pair<String, String>("func_74862_a", "getYWithOffset"));
            mInitMap.put(new Pair<String, String>("func_74865_a", "getXWithOffset"));
            mInitMap.put(new Pair<String, String>("func_74869_a", "generateStructureDispenserContents"));
            mInitMap.put(new Pair<String, String>("func_74871_b", "clearCurrentPositionBlocksUpwards"));
            mInitMap.put(new Pair<String, String>("func_74873_b", "getZWithOffset"));
            mInitMap.put(new Pair<String, String>("func_74874_b", "getBoundingBox"));
            mInitMap.put(new Pair<String, String>("func_74875_a", "addComponentParts"));
            mInitMap.put(new Pair<String, String>("func_74877_c", "getComponentType"));
            mInitMap.put(new Pair<String, String>("func_74878_a", "fillWithAir"));
            mInitMap.put(new Pair<String, String>("func_74879_a", "generateStructureChestContents"));
            mInitMap.put(new Pair<String, String>("func_74881_a", "placeDoorAtCurrentPosition"));
            mInitMap.put(new Pair<String, String>("func_74882_a", "fillWithRandomizedBlocks"));
            mInitMap.put(new Pair<String, String>("func_74883_a", "findIntersecting"));
            mInitMap.put(new Pair<String, String>("func_74888_b", "getVillagerType"));
            mInitMap.put(new Pair<String, String>("func_74889_b", "getAverageGroundLevel"));
            mInitMap.put(new Pair<String, String>("func_74891_a", "getNextComponentNN"));
            mInitMap.put(new Pair<String, String>("func_74893_a", "spawnVillagers"));
            mInitMap.put(new Pair<String, String>("func_74894_b", "getNextComponentPP"));
            mInitMap.put(new Pair<String, String>("func_74895_a", "canVillageGoDeeper"));
            mInitMap.put(new Pair<String, String>("func_74925_d", "getWorldChunkManager"));
            mInitMap.put(new Pair<String, String>("func_74950_a", "findValidPlacement"));
            mInitMap.put(new Pair<String, String>("func_74951_a", "findValidPlacement"));
            mInitMap.put(new Pair<String, String>("func_74954_a", "findValidPlacement"));
            mInitMap.put(new Pair<String, String>("func_74959_a", "getNextComponent"));
            mInitMap.put(new Pair<String, String>("func_74960_a", "getTotalWeight"));
            mInitMap.put(new Pair<String, String>("func_74961_b", "getNextComponentX"));
            mInitMap.put(new Pair<String, String>("func_74962_a", "getNextComponent"));
            mInitMap.put(new Pair<String, String>("func_74963_a", "getNextComponentNormal"));
            mInitMap.put(new Pair<String, String>("func_74964_a", "isAboveGround"));
            mInitMap.put(new Pair<String, String>("func_74965_c", "getNextComponentZ"));
            mInitMap.put(new Pair<String, String>("func_74966_a", "createValidComponent"));
            mInitMap.put(new Pair<String, String>("func_74973_a", "createValidComponent"));
            mInitMap.put(new Pair<String, String>("func_74974_a", "createValidComponent"));
            mInitMap.put(new Pair<String, String>("func_74975_a", "createValidComponent"));
            mInitMap.put(new Pair<String, String>("func_74977_a", "createValidComponent"));
            mInitMap.put(new Pair<String, String>("func_74978_a", "createValidComponent"));
            mInitMap.put(new Pair<String, String>("func_74979_a", "createValidComponent"));
            mInitMap.put(new Pair<String, String>("func_74980_a", "createValidComponent"));
            mInitMap.put(new Pair<String, String>("func_74981_a", "createValidComponent"));
            mInitMap.put(new Pair<String, String>("func_74982_a", "createValidComponent"));
            mInitMap.put(new Pair<String, String>("func_74983_a", "createValidComponent"));
            mInitMap.put(new Pair<String, String>("func_74984_a", "createValidComponent"));
            mInitMap.put(new Pair<String, String>("func_74985_a", "createValidComponent"));
            mInitMap.put(new Pair<String, String>("func_74986_a", "getNextComponentNormal"));
            mInitMap.put(new Pair<String, String>("func_74987_c", "getNextComponentZ"));
            mInitMap.put(new Pair<String, String>("func_74988_a", "getRandomDoor"));
            mInitMap.put(new Pair<String, String>("func_74989_b", "getNextComponentX"));
            mInitMap.put(new Pair<String, String>("func_74990_a", "placeDoor"));
            mInitMap.put(new Pair<String, String>("func_74991_a", "canStrongholdGoDeeper"));
            mInitMap.put(new Pair<String, String>("func_74994_a", "findValidPlacement"));
            mInitMap.put(new Pair<String, String>("func_75000_a", "findValidPlacement"));
            mInitMap.put(new Pair<String, String>("func_75004_a", "findValidPlacement"));
            mInitMap.put(new Pair<String, String>("func_75006_a", "findValidPlacement"));
            mInitMap.put(new Pair<String, String>("func_75010_a", "findValidPlacement"));
            mInitMap.put(new Pair<String, String>("func_75012_a", "findValidPlacement"));
            mInitMap.put(new Pair<String, String>("func_75016_a", "findValidPlacement"));
            mInitMap.put(new Pair<String, String>("func_75018_a", "findValidPlacement"));
            mInitMap.put(new Pair<String, String>("func_75022_a", "getStrongholdStairsComponent"));
            mInitMap.put(new Pair<String, String>("func_75028_a", "findValidPlacement"));
            mInitMap.put(new Pair<String, String>("func_75047_a", "canSpawnStructureAtCoords"));
            mInitMap.put(new Pair<String, String>("func_75048_a", "hasStructureAt"));
            mInitMap.put(new Pair<String, String>("func_75049_b", "getStructureStart"));
            mInitMap.put(new Pair<String, String>("func_75051_a", "generateStructuresInChunk"));
            mInitMap.put(new Pair<String, String>("func_75052_o_", "getCoordList"));
            mInitMap.put(new Pair<String, String>("func_75059_a", "getSpawnList"));
            mInitMap.put(new Pair<String, String>("func_75062_a", "selectBlocks"));
            mInitMap.put(new Pair<String, String>("func_75064_b", "getSelectedBlockMetaData"));
            mInitMap.put(new Pair<String, String>("func_75067_a", "markAvailableHeight"));
            mInitMap.put(new Pair<String, String>("func_75068_a", "generateStructure"));
            mInitMap.put(new Pair<String, String>("func_75069_d", "isSizeableStructure"));
            mInitMap.put(new Pair<String, String>("func_75070_a", "setRandomHeight"));
            mInitMap.put(new Pair<String, String>("func_75071_a", "getBoundingBox"));
            mInitMap.put(new Pair<String, String>("func_75072_c", "updateBoundingBox"));
            mInitMap.put(new Pair<String, String>("func_75073_b", "getComponents"));
            mInitMap.put(new Pair<String, String>("func_75077_d", "getNextVillageStructureComponent"));
            mInitMap.put(new Pair<String, String>("func_75080_e", "getNextComponentVillagePath"));
            mInitMap.put(new Pair<String, String>("func_75081_c", "getNextVillageComponent"));
            mInitMap.put(new Pair<String, String>("func_75084_a", "getStructureVillageWeightedPieceList"));
            mInitMap.put(new Pair<String, String>("func_75085_a", "canSpawnMoreVillagePiecesOfType"));
            mInitMap.put(new Pair<String, String>("func_75086_a", "canSpawnMoreVillagePieces"));
            mInitMap.put(new Pair<String, String>("func_75091_a", "writeCapabilitiesToNBT"));
            mInitMap.put(new Pair<String, String>("func_75092_a", "setFlySpeed"));
            mInitMap.put(new Pair<String, String>("func_75093_a", "getFlySpeed"));
            mInitMap.put(new Pair<String, String>("func_75094_b", "getWalkSpeed"));
            mInitMap.put(new Pair<String, String>("func_75095_b", "readCapabilitiesFromNBT"));
            mInitMap.put(new Pair<String, String>("func_75112_a", "readNBT"));
            mInitMap.put(new Pair<String, String>("func_75113_a", "addExhaustion"));
            mInitMap.put(new Pair<String, String>("func_75114_a", "setFoodLevel"));
            mInitMap.put(new Pair<String, String>("func_75115_e", "getSaturationLevel"));
            mInitMap.put(new Pair<String, String>("func_75116_a", "getFoodLevel"));
            mInitMap.put(new Pair<String, String>("func_75117_b", "writeNBT"));
            mInitMap.put(new Pair<String, String>("func_75118_a", "onUpdate"));
            mInitMap.put(new Pair<String, String>("func_75119_b", "setFoodSaturationLevel"));
            mInitMap.put(new Pair<String, String>("func_75120_b", "getPrevFoodLevel"));
            mInitMap.put(new Pair<String, String>("func_75121_c", "needFood"));
            mInitMap.put(new Pair<String, String>("func_75122_a", "addStats"));
            mInitMap.put(new Pair<String, String>("func_75128_a", "setCanCraft"));
            mInitMap.put(new Pair<String, String>("func_75129_b", "getCanCraft"));
            mInitMap.put(new Pair<String, String>("func_75130_a", "onCraftMatrixChanged"));
            mInitMap.put(new Pair<String, String>("func_75131_a", "putStacksInSlots"));
            mInitMap.put(new Pair<String, String>("func_75132_a", "onCraftGuiOpened"));
            mInitMap.put(new Pair<String, String>("func_75133_b", "retrySlotClick"));
            mInitMap.put(new Pair<String, String>("func_75134_a", "onContainerClosed"));
            mInitMap.put(new Pair<String, String>("func_75135_a", "mergeItemStack"));
            mInitMap.put(new Pair<String, String>("func_75136_a", "getNextTransactionID"));
            mInitMap.put(new Pair<String, String>("func_75137_b", "updateProgressBar"));
            mInitMap.put(new Pair<String, String>("func_75138_a", "getInventory"));
            mInitMap.put(new Pair<String, String>("func_75139_a", "getSlot"));
            mInitMap.put(new Pair<String, String>("func_75140_a", "enchantItem"));
            mInitMap.put(new Pair<String, String>("func_75141_a", "putStackInSlot"));
            mInitMap.put(new Pair<String, String>("func_75142_b", "detectAndSendChanges"));
            mInitMap.put(new Pair<String, String>("func_75144_a", "slotClick"));
            mInitMap.put(new Pair<String, String>("func_75145_c", "canInteractWith"));
            mInitMap.put(new Pair<String, String>("func_75146_a", "addSlotToContainer"));
            mInitMap.put(new Pair<String, String>("func_75147_a", "getSlotFromInventory"));
            mInitMap.put(new Pair<String, String>("func_75174_d", "getMerchantInventory"));
            mInitMap.put(new Pair<String, String>("func_75175_c", "setCurrentRecipeIndex"));
            mInitMap.put(new Pair<String, String>("func_75189_a", "canSpawnMoreStructuresOfType"));
            mInitMap.put(new Pair<String, String>("func_75190_a", "canSpawnMoreStructures"));
            mInitMap.put(new Pair<String, String>("func_75196_c", "getNextValidComponent"));
            mInitMap.put(new Pair<String, String>("func_75198_a", "prepareStructurePieces"));
            mInitMap.put(new Pair<String, String>("func_75200_a", "getStrongholdComponentFromWeightedPiece"));
            mInitMap.put(new Pair<String, String>("func_75201_b", "getNextComponent"));
            mInitMap.put(new Pair<String, String>("func_75202_c", "canAddStructurePieces"));
            mInitMap.put(new Pair<String, String>("func_75208_c", "onCrafting"));
            mInitMap.put(new Pair<String, String>("func_75209_a", "decrStackSize"));
            mInitMap.put(new Pair<String, String>("func_75210_a", "onCrafting"));
            mInitMap.put(new Pair<String, String>("func_75211_c", "getStack"));
            mInitMap.put(new Pair<String, String>("func_75212_b", "getBackgroundIconIndex"));
            mInitMap.put(new Pair<String, String>("func_75214_a", "isItemValid"));
            mInitMap.put(new Pair<String, String>("func_75215_d", "putStack"));
            mInitMap.put(new Pair<String, String>("func_75216_d", "getHasStack"));
            mInitMap.put(new Pair<String, String>("func_75217_a", "isHere"));
            mInitMap.put(new Pair<String, String>("func_75218_e", "onSlotChanged"));
            mInitMap.put(new Pair<String, String>("func_75219_a", "getSlotStackLimit"));
            mInitMap.put(new Pair<String, String>("func_75220_a", "onSlotChange"));
            mInitMap.put(new Pair<String, String>("func_75230_a", "doTrade"));
            mInitMap.put(new Pair<String, String>("func_75243_a_", "canHoldPotion"));
            mInitMap.put(new Pair<String, String>("func_75246_d", "updateTask"));
            mInitMap.put(new Pair<String, String>("func_75247_h", "getMutexBits"));
            mInitMap.put(new Pair<String, String>("func_75248_a", "setMutexBits"));
            mInitMap.put(new Pair<String, String>("func_75249_e", "startExecuting"));
            mInitMap.put(new Pair<String, String>("func_75250_a", "shouldExecute"));
            mInitMap.put(new Pair<String, String>("func_75251_c", "resetTask"));
            mInitMap.put(new Pair<String, String>("func_75252_g", "isInterruptible"));
            mInitMap.put(new Pair<String, String>("func_75253_b", "continueExecuting"));
            mInitMap.put(new Pair<String, String>("func_75270_a", "setSitting"));
            mInitMap.put(new Pair<String, String>("func_75277_f", "isRunning"));
            mInitMap.put(new Pair<String, String>("func_75295_a", "canEasilyReach"));
            mInitMap.put(new Pair<String, String>("func_75296_a", "isSuitableTarget"));
            mInitMap.put(new Pair<String, String>("func_75366_f", "findPossibleShelter"));
            mInitMap.put(new Pair<String, String>("func_75382_a", "hasPlayerGotBoneInHand"));
            mInitMap.put(new Pair<String, String>("func_75388_i", "spawnBaby"));
            mInitMap.put(new Pair<String, String>("func_75389_f", "getNearbyMate"));
            mInitMap.put(new Pair<String, String>("func_75446_f", "checkSufficientDoorsPresentFormInitMap.put(newVillager"));
            mInitMap.put(new Pair<String, String>("func_75447_i", "giveBirth"));
            mInitMap.put(new Pair<String, String>("func_75461_b", "findRandomTargetBlockAwayFrom"));
            mInitMap.put(new Pair<String, String>("func_75462_c", "findRandomTargetBlock"));
            mInitMap.put(new Pair<String, String>("func_75463_a", "findRandomTarget"));
            mInitMap.put(new Pair<String, String>("func_75464_a", "findRandomTargetBlockTowards"));
            mInitMap.put(new Pair<String, String>("func_75466_d", "resetDoorOpeningRestrictionCounter"));
            mInitMap.put(new Pair<String, String>("func_75467_a", "isInside"));
            mInitMap.put(new Pair<String, String>("func_75468_f", "getDoorOpeningRestrictionCounter"));
            mInitMap.put(new Pair<String, String>("func_75469_c", "getInsideDistanceSquare"));
            mInitMap.put(new Pair<String, String>("func_75470_e", "incrementDoorOpeningRestrictionCounter"));
            mInitMap.put(new Pair<String, String>("func_75471_a", "getInsidePosX"));
            mInitMap.put(new Pair<String, String>("func_75472_c", "getInsidePosZ"));
            mInitMap.put(new Pair<String, String>("func_75473_b", "getInsidePosY"));
            mInitMap.put(new Pair<String, String>("func_75474_b", "getDistanceSquared"));
            mInitMap.put(new Pair<String, String>("func_75483_a", "isSafeToStandAt"));
            mInitMap.put(new Pair<String, String>("func_75484_a", "setPath"));
            mInitMap.put(new Pair<String, String>("func_75485_k", "canNavigate"));
            mInitMap.put(new Pair<String, String>("func_75486_a", "getAvoidsWater"));
            mInitMap.put(new Pair<String, String>("func_75487_m", "removeSunnyPath"));
            mInitMap.put(new Pair<String, String>("func_75488_a", "getPathToXYZ"));
            mInitMap.put(new Pair<String, String>("func_75489_a", "setSpeed"));
            mInitMap.put(new Pair<String, String>("func_75490_c", "setEnterDoors"));
            mInitMap.put(new Pair<String, String>("func_75491_a", "setAvoidsWater"));
            mInitMap.put(new Pair<String, String>("func_75492_a", "tryMoveToXYZ"));
            mInitMap.put(new Pair<String, String>("func_75493_a", "isDirectPathBetweenPoints"));
            mInitMap.put(new Pair<String, String>("func_75494_a", "getPathToEntityLiving"));
            mInitMap.put(new Pair<String, String>("func_75495_e", "setCanSwim"));
            mInitMap.put(new Pair<String, String>("func_75496_b", "isPositionClear"));
            mInitMap.put(new Pair<String, String>("func_75497_a", "tryMoveToEntityLiving"));
            mInitMap.put(new Pair<String, String>("func_75498_b", "setBreakDoors"));
            mInitMap.put(new Pair<String, String>("func_75499_g", "clearPathEntity"));
            mInitMap.put(new Pair<String, String>("func_75500_f", "noPath"));
            mInitMap.put(new Pair<String, String>("func_75501_e", "onUpdateNavigation"));
            mInitMap.put(new Pair<String, String>("func_75502_i", "getEntityPosition"));
            mInitMap.put(new Pair<String, String>("func_75503_j", "getPathableYPos"));
            mInitMap.put(new Pair<String, String>("func_75504_d", "setAvoidSun"));
            mInitMap.put(new Pair<String, String>("func_75505_d", "getPath"));
            mInitMap.put(new Pair<String, String>("func_75506_l", "isInLiquid"));
            mInitMap.put(new Pair<String, String>("func_75507_c", "getCanBreakDoors"));
            mInitMap.put(new Pair<String, String>("func_75508_h", "pathFollow"));
            mInitMap.put(new Pair<String, String>("func_75522_a", "canSee"));
            mInitMap.put(new Pair<String, String>("func_75523_a", "clearSensingCache"));
            mInitMap.put(new Pair<String, String>("func_75528_a", "tick"));
            mInitMap.put(new Pair<String, String>("func_75530_c", "spawnZombie"));
            mInitMap.put(new Pair<String, String>("func_75540_b", "getVillageList"));
            mInitMap.put(new Pair<String, String>("func_75541_e", "isWoodenDoorAt"));
            mInitMap.put(new Pair<String, String>("func_75542_c", "addDoorTomInitMap.put(newListIfAppropriate"));
            mInitMap.put(new Pair<String, String>("func_75543_d", "dropOldestVillagerPosition"));
            mInitMap.put(new Pair<String, String>("func_75544_a", "tick"));
            mInitMap.put(new Pair<String, String>("func_75545_e", "addmInitMap.put(newDoorsToVillageOrCreateVillage"));
            mInitMap.put(new Pair<String, String>("func_75546_a", "addUnassignedWoodenDoorsAroundTomInitMap.put(newDoorsList"));
            mInitMap.put(new Pair<String, String>("func_75547_b", "getVillageDoorAt"));
            mInitMap.put(new Pair<String, String>("func_75548_d", "isVillagerPositionPresent"));
            mInitMap.put(new Pair<String, String>("func_75549_c", "removeAnnihilatedVillages"));
            mInitMap.put(new Pair<String, String>("func_75550_a", "findNearestVillage"));
            mInitMap.put(new Pair<String, String>("func_75551_a", "addVillagerPosition"));
            mInitMap.put(new Pair<String, String>("func_75557_k", "removeDeadAndOutOfRangeDoors"));
            mInitMap.put(new Pair<String, String>("func_75558_f", "getVillageDoorInfoList"));
            mInitMap.put(new Pair<String, String>("func_75559_a", "tryGetIronGolemSpawningLocation"));
            mInitMap.put(new Pair<String, String>("func_75560_a", "tick"));
            mInitMap.put(new Pair<String, String>("func_75561_d", "getTicksSinceLastDoorAdding"));
            mInitMap.put(new Pair<String, String>("func_75562_e", "getNumVillagers"));
            mInitMap.put(new Pair<String, String>("func_75563_b", "isValidIronGolemSpawningLocation"));
            mInitMap.put(new Pair<String, String>("func_75564_b", "findNearestDoor"));
            mInitMap.put(new Pair<String, String>("func_75565_j", "removeDeadAndOldAgressors"));
            mInitMap.put(new Pair<String, String>("func_75566_g", "isAnnihilated"));
            mInitMap.put(new Pair<String, String>("func_75567_c", "getNumVillageDoors"));
            mInitMap.put(new Pair<String, String>("func_75568_b", "getVillageRadius"));
            mInitMap.put(new Pair<String, String>("func_75569_c", "findNearestDoorUnrestricted"));
            mInitMap.put(new Pair<String, String>("func_75570_a", "isInRange"));
            mInitMap.put(new Pair<String, String>("func_75571_b", "findNearestVillageAggressor"));
            mInitMap.put(new Pair<String, String>("func_75572_i", "updateNumVillagers"));
            mInitMap.put(new Pair<String, String>("func_75573_l", "updateVillageRadiusAndCenter"));
            mInitMap.put(new Pair<String, String>("func_75574_f", "isBlockDoor"));
            mInitMap.put(new Pair<String, String>("func_75575_a", "addOrRemInitMap.put(newAgressor"));
            mInitMap.put(new Pair<String, String>("func_75576_a", "addVillageDoorInfo"));
            mInitMap.put(new Pair<String, String>("func_75577_a", "getCenter"));
            mInitMap.put(new Pair<String, String>("func_75578_e", "getVillageDoorAt"));
            mInitMap.put(new Pair<String, String>("func_75579_h", "updateNumIronGolems"));
            mInitMap.put(new Pair<String, String>("func_75598_a", "getCreatureClass"));
            mInitMap.put(new Pair<String, String>("func_75599_d", "getPeacefulCreature"));
            mInitMap.put(new Pair<String, String>("func_75600_c", "getCreatureMaterial"));
            mInitMap.put(new Pair<String, String>("func_75601_b", "getMaxNumberOfCreature"));
            mInitMap.put(new Pair<String, String>("func_75614_a", "addMapping"));
            mInitMap.put(new Pair<String, String>("func_75615_a", "createEntityFromNBT"));
            mInitMap.put(new Pair<String, String>("func_75616_a", "createEntityByID"));
            mInitMap.put(new Pair<String, String>("func_75617_a", "getStringFromID"));
            mInitMap.put(new Pair<String, String>("func_75618_a", "addMapping"));
            mInitMap.put(new Pair<String, String>("func_75619_a", "getEntityID"));
            mInitMap.put(new Pair<String, String>("func_75620_a", "createEntityByName"));
            mInitMap.put(new Pair<String, String>("func_75621_b", "getEntityString"));
            mInitMap.put(new Pair<String, String>("func_75630_a", "multiplyBy32AndRound"));
            mInitMap.put(new Pair<String, String>("func_75638_b", "getSpeed"));
            mInitMap.put(new Pair<String, String>("func_75639_a", "limitAngle"));
            mInitMap.put(new Pair<String, String>("func_75640_a", "isUpdating"));
            mInitMap.put(new Pair<String, String>("func_75641_c", "onUpdateMoveHelper"));
            mInitMap.put(new Pair<String, String>("func_75642_a", "setMoveTo"));
            mInitMap.put(new Pair<String, String>("func_75649_a", "onUpdateLook"));
            mInitMap.put(new Pair<String, String>("func_75650_a", "setLookPosition"));
            mInitMap.put(new Pair<String, String>("func_75651_a", "setLookPositionWithEntity"));
            mInitMap.put(new Pair<String, String>("func_75652_a", "updateRotation"));
            mInitMap.put(new Pair<String, String>("func_75660_a", "setJumping"));
            mInitMap.put(new Pair<String, String>("func_75661_b", "doJump"));
            mInitMap.put(new Pair<String, String>("func_75664_a", "updateRenderAngles"));
            mInitMap.put(new Pair<String, String>("func_75665_a", "computeAngleWithBound"));
            mInitMap.put(new Pair<String, String>("func_75669_b", "getObject"));
            mInitMap.put(new Pair<String, String>("func_75670_d", "isWatched"));
            mInitMap.put(new Pair<String, String>("func_75671_a", "setWatched"));
            mInitMap.put(new Pair<String, String>("func_75672_a", "getDataValueId"));
            mInitMap.put(new Pair<String, String>("func_75673_a", "setObject"));
            mInitMap.put(new Pair<String, String>("func_75674_c", "getObjectType"));
            mInitMap.put(new Pair<String, String>("func_75679_c", "getWatchableObjectInt"));
            mInitMap.put(new Pair<String, String>("func_75681_e", "getWatchableObjectString"));
            mInitMap.put(new Pair<String, String>("func_75682_a", "addObject"));
            mInitMap.put(new Pair<String, String>("func_75683_a", "getWatchableObjectByte"));
            mInitMap.put(new Pair<String, String>("func_75684_a", "hasObjectChanged"));
            mInitMap.put(new Pair<String, String>("func_75685_c", "getAllWatched"));
            mInitMap.put(new Pair<String, String>("func_75687_a", "updateWatchedObjectsFromList"));
            mInitMap.put(new Pair<String, String>("func_75688_b", "getChanged"));
            mInitMap.put(new Pair<String, String>("func_75691_i", "getWatchedObject"));
            mInitMap.put(new Pair<String, String>("func_75692_b", "updateObject"));
            mInitMap.put(new Pair<String, String>("func_75693_b", "getWatchableObjectShort"));
            mInitMap.put(new Pair<String, String>("func_75734_a", "waitForFinish"));
            mInitMap.put(new Pair<String, String>("func_75735_a", "queueIO"));
            mInitMap.put(new Pair<String, String>("func_75736_b", "processQueue"));
            mInitMap.put(new Pair<String, String>("func_75742_a", "loadData"));
            mInitMap.put(new Pair<String, String>("func_75743_a", "getUniqueDataId"));
            mInitMap.put(new Pair<String, String>("func_75744_a", "saveAllData"));
            mInitMap.put(new Pair<String, String>("func_75745_a", "setData"));
            mInitMap.put(new Pair<String, String>("func_75746_b", "loadIdCounts"));
            mInitMap.put(new Pair<String, String>("func_75747_a", "saveData"));
            mInitMap.put(new Pair<String, String>("func_75752_b", "readPlayerData"));
            mInitMap.put(new Pair<String, String>("func_75753_a", "writePlayerData"));
            mInitMap.put(new Pair<String, String>("func_75754_f", "getAvailablePlayerDat"));
            mInitMap.put(new Pair<String, String>("func_75755_a", "saveWorldInfoWithPlayer"));
            mInitMap.put(new Pair<String, String>("func_75756_e", "getPlayerNBTManager"));
            mInitMap.put(new Pair<String, String>("func_75757_d", "loadWorldInfo"));
            mInitMap.put(new Pair<String, String>("func_75758_b", "getMapFileFromName"));
            mInitMap.put(new Pair<String, String>("func_75759_a", "flush"));
            mInitMap.put(new Pair<String, String>("func_75760_g", "getWorldDirectoryName"));
            mInitMap.put(new Pair<String, String>("func_75761_a", "saveWorldInfo"));
            mInitMap.put(new Pair<String, String>("func_75762_c", "checkSessionLock"));
            mInitMap.put(new Pair<String, String>("func_75763_a", "getChunkLoader"));
            mInitMap.put(new Pair<String, String>("func_75765_b", "getWorldDirectory"));
            mInitMap.put(new Pair<String, String>("func_75766_h", "setSessionLock"));
            mInitMap.put(new Pair<String, String>("func_75773_a", "canContinue"));
            mInitMap.put(new Pair<String, String>("func_75774_a", "onUpdateTasks"));
            mInitMap.put(new Pair<String, String>("func_75775_b", "canUse"));
            mInitMap.put(new Pair<String, String>("func_75776_a", "addTask"));
            mInitMap.put(new Pair<String, String>("func_75777_a", "areTasksCompatible"));
            mInitMap.put(new Pair<String, String>("func_75783_h", "getCheatsEnabled"));
            mInitMap.put(new Pair<String, String>("func_75784_e", "getLastTimePlayed"));
            mInitMap.put(new Pair<String, String>("func_75785_d", "requiresConversion"));
            mInitMap.put(new Pair<String, String>("func_75786_a", "getFileName"));
            mInitMap.put(new Pair<String, String>("func_75788_b", "getDisplayName"));
            mInitMap.put(new Pair<String, String>("func_75789_g", "isHardcoreModeEnabled"));
            mInitMap.put(new Pair<String, String>("func_75790_f", "getEnumGameType"));
            mInitMap.put(new Pair<String, String>("func_75799_b", "getSaveList"));
            mInitMap.put(new Pair<String, String>("func_75800_d", "flushCache"));
            mInitMap.put(new Pair<String, String>("func_75801_b", "isOldMapFormat"));
            mInitMap.put(new Pair<String, String>("func_75802_e", "deleteWorldDirectory"));
            mInitMap.put(new Pair<String, String>("func_75803_c", "getWorldInfo"));
            mInitMap.put(new Pair<String, String>("func_75804_a", "getSaveLoader"));
            mInitMap.put(new Pair<String, String>("func_75805_a", "convertMapFormat"));
            mInitMap.put(new Pair<String, String>("func_75806_a", "renameWorld"));
            mInitMap.put(new Pair<String, String>("func_75807_a", "deleteFiles"));
            mInitMap.put(new Pair<String, String>("func_75809_f", "createFile"));
            mInitMap.put(new Pair<String, String>("func_75810_a", "addRegionFilesToCollection"));
            mInitMap.put(new Pair<String, String>("func_75811_a", "convertChunks"));
            mInitMap.put(new Pair<String, String>("func_75812_c", "getSaveVersion"));
            mInitMap.put(new Pair<String, String>("func_75813_a", "convertFile"));
            mInitMap.put(new Pair<String, String>("func_75814_c", "writeNextIO"));
            mInitMap.put(new Pair<String, String>("func_75815_a", "loadChunk"));
            mInitMap.put(new Pair<String, String>("func_75816_a", "saveChunk"));
            mInitMap.put(new Pair<String, String>("func_75817_a", "chunkTick"));
            mInitMap.put(new Pair<String, String>("func_75818_b", "saveExtraData"));
            mInitMap.put(new Pair<String, String>("func_75819_b", "saveExtraChunkData"));
            mInitMap.put(new Pair<String, String>("func_75820_a", "writeChunkToNBT"));
            mInitMap.put(new Pair<String, String>("func_75821_a", "writeChunkNBTTags"));
            mInitMap.put(new Pair<String, String>("func_75822_a", "checkedReadChunkFromNBT"));
            mInitMap.put(new Pair<String, String>("func_75823_a", "readChunkFromNBT"));
            mInitMap.put(new Pair<String, String>("func_75824_a", "addChunkToPending"));
            mInitMap.put(new Pair<String, String>("func_75829_a", "distanceTo"));
            mInitMap.put(new Pair<String, String>("func_75830_a", "makeHash"));
            mInitMap.put(new Pair<String, String>("func_75831_a", "isAssigned"));
            mInitMap.put(new Pair<String, String>("func_75832_b", "distanceToSquared"));
            mInitMap.put(new Pair<String, String>("func_75843_a", "format"));
            mInitMap.put(new Pair<String, String>("func_75844_c", "dequeue"));
            mInitMap.put(new Pair<String, String>("func_75845_e", "isPathEmpty"));
            mInitMap.put(new Pair<String, String>("func_75846_b", "sortForward"));
            mInitMap.put(new Pair<String, String>("func_75847_a", "sortBack"));
            mInitMap.put(new Pair<String, String>("func_75848_a", "clearPath"));
            mInitMap.put(new Pair<String, String>("func_75849_a", "addPoint"));
            mInitMap.put(new Pair<String, String>("func_75850_a", "changeDistance"));
            mInitMap.put(new Pair<String, String>("func_75853_a", "createEntityPath"));
            mInitMap.put(new Pair<String, String>("func_75854_a", "openPoint"));
            mInitMap.put(new Pair<String, String>("func_75855_a", "canEntityStandAt"));
            mInitMap.put(new Pair<String, String>("func_75856_a", "createEntityPathTo"));
            mInitMap.put(new Pair<String, String>("func_75857_a", "createEntityPathTo"));
            mInitMap.put(new Pair<String, String>("func_75858_a", "getSafePoint"));
            mInitMap.put(new Pair<String, String>("func_75859_a", "createEntityPathTo"));
            mInitMap.put(new Pair<String, String>("func_75860_b", "findPathOptions"));
            mInitMap.put(new Pair<String, String>("func_75861_a", "addToPath"));
            mInitMap.put(new Pair<String, String>("func_75870_c", "getFinalPathPoint"));
            mInitMap.put(new Pair<String, String>("func_75871_b", "setCurrentPathLength"));
            mInitMap.put(new Pair<String, String>("func_75872_c", "setCurrentPathIndex"));
            mInitMap.put(new Pair<String, String>("func_75873_e", "getCurrentPathIndex"));
            mInitMap.put(new Pair<String, String>("func_75874_d", "getCurrentPathLength"));
            mInitMap.put(new Pair<String, String>("func_75875_a", "incrementPathIndex"));
            mInitMap.put(new Pair<String, String>("func_75876_a", "isSamePath"));
            mInitMap.put(new Pair<String, String>("func_75877_a", "getPathPointFromIndex"));
            mInitMap.put(new Pair<String, String>("func_75878_a", "getPosition"));
            mInitMap.put(new Pair<String, String>("func_75879_b", "isFinished"));
            mInitMap.put(new Pair<String, String>("func_75880_b", "isDestinationSame"));
            mInitMap.put(new Pair<String, String>("func_75881_a", "getVectorFromIndex"));
            mInitMap.put(new Pair<String, String>("func_75885_a", "cipherOperation"));
            mInitMap.put(new Pair<String, String>("func_75886_a", "createTheCipherInstance"));
            mInitMap.put(new Pair<String, String>("func_75887_a", "decryptSharedKey"));
            mInitMap.put(new Pair<String, String>("func_75889_b", "decryptData"));
            mInitMap.put(new Pair<String, String>("func_75890_a", "createmInitMap.put(newSharedKey"));
            mInitMap.put(new Pair<String, String>("func_75891_b", "generateKeyPair"));
            mInitMap.put(new Pair<String, String>("func_75893_a", "digestOperation"));
            mInitMap.put(new Pair<String, String>("func_75894_a", "encryptData"));
            mInitMap.put(new Pair<String, String>("func_75895_a", "getServerIdHash"));
            mInitMap.put(new Pair<String, String>("func_75896_a", "decodePublicKey"));
            mInitMap.put(new Pair<String, String>("func_75901_a", "initializeAllBiomeGenerators"));
            mInitMap.put(new Pair<String, String>("func_75902_a", "nextInt"));
            mInitMap.put(new Pair<String, String>("func_75903_a", "initChunkSeed"));
            mInitMap.put(new Pair<String, String>("func_75904_a", "getInts"));
            mInitMap.put(new Pair<String, String>("func_75905_a", "initWorldGenSeed"));
            mInitMap.put(new Pair<String, String>("func_75915_a", "magnify"));
            mInitMap.put(new Pair<String, String>("func_75918_d", "initCraftableStats"));
            mInitMap.put(new Pair<String, String>("func_75924_a", "replaceAllSimilarBlocks"));
            mInitMap.put(new Pair<String, String>("func_75925_c", "initStats"));
            mInitMap.put(new Pair<String, String>("func_75966_h", "initIndependentStat"));
            mInitMap.put(new Pair<String, String>("func_75967_d", "isAchievement"));
            mInitMap.put(new Pair<String, String>("func_75971_g", "registerStat"));
            mInitMap.put(new Pair<String, String>("func_75984_f", "getSpecial"));
            mInitMap.put(new Pair<String, String>("func_75987_b", "setSpecial"));
            mInitMap.put(new Pair<String, String>("func_75988_a", "setStatStringFormatter"));
            mInitMap.put(new Pair<String, String>("func_75989_e", "getDescription"));
            mInitMap.put(new Pair<String, String>("func_75997_a", "init"));
            mInitMap.put(new Pair<String, String>("func_76030_b", "getValue"));
            mInitMap.put(new Pair<String, String>("func_76031_a", "getHash"));
            mInitMap.put(new Pair<String, String>("func_76036_e", "removeEntry"));
            mInitMap.put(new Pair<String, String>("func_76037_b", "containsItem"));
            mInitMap.put(new Pair<String, String>("func_76038_a", "addKey"));
            mInitMap.put(new Pair<String, String>("func_76040_a", "insert"));
            mInitMap.put(new Pair<String, String>("func_76041_a", "lookup"));
            mInitMap.put(new Pair<String, String>("func_76043_a", "getSlotIndex"));
            mInitMap.put(new Pair<String, String>("func_76044_g", "computeHash"));
            mInitMap.put(new Pair<String, String>("func_76045_c", "lookupEntry"));
            mInitMap.put(new Pair<String, String>("func_76046_c", "clearMap"));
            mInitMap.put(new Pair<String, String>("func_76047_h", "grow"));
            mInitMap.put(new Pair<String, String>("func_76048_a", "copyTo"));
            mInitMap.put(new Pair<String, String>("func_76049_d", "removeObject"));
            mInitMap.put(new Pair<String, String>("func_76056_b", "setSpawnY"));
            mInitMap.put(new Pair<String, String>("func_76057_l", "getLastTimePlayed"));
            mInitMap.put(new Pair<String, String>("func_76058_a", "setSpawnX"));
            mInitMap.put(new Pair<String, String>("func_76059_o", "isRaining"));
            mInitMap.put(new Pair<String, String>("func_76060_a", "setGameType"));
            mInitMap.put(new Pair<String, String>("func_76061_m", "isThundering"));
            mInitMap.put(new Pair<String, String>("func_76062_a", "setWorldName"));
            mInitMap.put(new Pair<String, String>("func_76063_b", "getSeed"));
            mInitMap.put(new Pair<String, String>("func_76064_a", "updateTagCompound"));
            mInitMap.put(new Pair<String, String>("func_76065_j", "getWorldName"));
            mInitMap.put(new Pair<String, String>("func_76066_a", "getNBTTagCompound"));
            mInitMap.put(new Pair<String, String>("func_76067_t", "getTerrainType"));
            mInitMap.put(new Pair<String, String>("func_76068_b", "setWorldTime"));
            mInitMap.put(new Pair<String, String>("func_76069_a", "setThundering"));
            mInitMap.put(new Pair<String, String>("func_76070_v", "isInitialized"));
            mInitMap.put(new Pair<String, String>("func_76071_n", "getThunderTime"));
            mInitMap.put(new Pair<String, String>("func_76072_h", "getPlayerNBTTagCompound"));
            mInitMap.put(new Pair<String, String>("func_76073_f", "getWorldTime"));
            mInitMap.put(new Pair<String, String>("func_76074_e", "getSpawnZ"));
            mInitMap.put(new Pair<String, String>("func_76075_d", "getSpawnY"));
            mInitMap.put(new Pair<String, String>("func_76076_i", "getDimension"));
            mInitMap.put(new Pair<String, String>("func_76077_q", "getGameType"));
            mInitMap.put(new Pair<String, String>("func_76078_e", "setSaveVersion"));
            mInitMap.put(new Pair<String, String>("func_76079_c", "getSpawnX"));
            mInitMap.put(new Pair<String, String>("func_76080_g", "setRainTime"));
            mInitMap.put(new Pair<String, String>("func_76081_a", "setSpawnPosition"));
            mInitMap.put(new Pair<String, String>("func_76082_a", "cloneNBTCompound"));
            mInitMap.put(new Pair<String, String>("func_76083_p", "getRainTime"));
            mInitMap.put(new Pair<String, String>("func_76084_b", "setRaining"));
            mInitMap.put(new Pair<String, String>("func_76085_a", "setTerrainType"));
            mInitMap.put(new Pair<String, String>("func_76086_u", "areCommandsAllowed"));
            mInitMap.put(new Pair<String, String>("func_76087_c", "setSpawnZ"));
            mInitMap.put(new Pair<String, String>("func_76088_k", "getSaveVersion"));
            mInitMap.put(new Pair<String, String>("func_76089_r", "isMapFeaturesEnabled"));
            mInitMap.put(new Pair<String, String>("func_76090_f", "setThunderTime"));
            mInitMap.put(new Pair<String, String>("func_76091_d", "setServerInitialized"));
            mInitMap.put(new Pair<String, String>("func_76092_g", "getSizeOnDisk"));
            mInitMap.put(new Pair<String, String>("func_76093_s", "isHardcoreModeEnabled"));
            mInitMap.put(new Pair<String, String>("func_76123_f", "ceiling_float_int"));
            mInitMap.put(new Pair<String, String>("func_76124_d", "floor_double_long"));
            mInitMap.put(new Pair<String, String>("func_76125_a", "clamp_int"));
            mInitMap.put(new Pair<String, String>("func_76126_a", "sin"));
            mInitMap.put(new Pair<String, String>("func_76127_a", "average"));
            mInitMap.put(new Pair<String, String>("func_76128_c", "floor_double"));
            mInitMap.put(new Pair<String, String>("func_76129_c", "sqrt_float"));
            mInitMap.put(new Pair<String, String>("func_76130_a", "abs_int"));
            mInitMap.put(new Pair<String, String>("func_76131_a", "clamp_float"));
            mInitMap.put(new Pair<String, String>("func_76132_a", "abs_max"));
            mInitMap.put(new Pair<String, String>("func_76133_a", "sqrt_double"));
            mInitMap.put(new Pair<String, String>("func_76134_b", "cos"));
            mInitMap.put(new Pair<String, String>("func_76135_e", "abs"));
            mInitMap.put(new Pair<String, String>("func_76136_a", "getRandomIntegerInRange"));
            mInitMap.put(new Pair<String, String>("func_76137_a", "bucketInt"));
            mInitMap.put(new Pair<String, String>("func_76138_g", "wrapAngleTo180_double"));
            mInitMap.put(new Pair<String, String>("func_76139_a", "stringNullOrLengthZero"));
            mInitMap.put(new Pair<String, String>("func_76140_b", "truncateDoubleToInt"));
            mInitMap.put(new Pair<String, String>("func_76141_d", "floor_float"));
            mInitMap.put(new Pair<String, String>("func_76142_g", "wrapAngleTo180_float"));
            mInitMap.put(new Pair<String, String>("func_76143_f", "ceiling_double_int"));
            mInitMap.put(new Pair<String, String>("func_76145_b", "getValue"));
            mInitMap.put(new Pair<String, String>("func_76146_a", "getKey"));
            mInitMap.put(new Pair<String, String>("func_76152_e", "removeKey"));
            mInitMap.put(new Pair<String, String>("func_76153_b", "resizeTable"));
            mInitMap.put(new Pair<String, String>("func_76154_a", "copyHashTableTo"));
            mInitMap.put(new Pair<String, String>("func_76155_g", "getHashedKey"));
            mInitMap.put(new Pair<String, String>("func_76156_a", "createKey"));
            mInitMap.put(new Pair<String, String>("func_76157_a", "hash"));
            mInitMap.put(new Pair<String, String>("func_76158_a", "getHashIndex"));
            mInitMap.put(new Pair<String, String>("func_76159_d", "remove"));
            mInitMap.put(new Pair<String, String>("func_76160_c", "getEntry"));
            mInitMap.put(new Pair<String, String>("func_76161_b", "containsItem"));
            mInitMap.put(new Pair<String, String>("func_76162_a", "getNumHashElements"));
            mInitMap.put(new Pair<String, String>("func_76163_a", "add"));
            mInitMap.put(new Pair<String, String>("func_76164_a", "getValueByKey"));
            mInitMap.put(new Pair<String, String>("func_76179_a", "buildPostString"));
            mInitMap.put(new Pair<String, String>("func_76181_a", "getSuitableLanPort"));
            mInitMap.put(new Pair<String, String>("func_76184_a", "readFromNBT"));
            mInitMap.put(new Pair<String, String>("func_76185_a", "markDirty"));
            mInitMap.put(new Pair<String, String>("func_76186_a", "setDirty"));
            mInitMap.put(new Pair<String, String>("func_76187_b", "writeToNBT"));
            mInitMap.put(new Pair<String, String>("func_76188_b", "isDirty"));
            mInitMap.put(new Pair<String, String>("func_76191_a", "updateVisiblePlayers"));
            mInitMap.put(new Pair<String, String>("func_76192_a", "updateMPMapData"));
            mInitMap.put(new Pair<String, String>("func_76193_a", "getUpdatePacketData"));
            mInitMap.put(new Pair<String, String>("func_76194_a", "setColumnDirty"));
            mInitMap.put(new Pair<String, String>("func_76204_a", "getPlayersOnMap"));
            mInitMap.put(new Pair<String, String>("func_76217_h", "getCanBurn"));
            mInitMap.put(new Pair<String, String>("func_76218_k", "isOpaque"));
            mInitMap.put(new Pair<String, String>("func_76219_n", "setNoPushMobility"));
            mInitMap.put(new Pair<String, String>("func_76220_a", "isSolid"));
            mInitMap.put(new Pair<String, String>("func_76221_f", "setRequiresTool"));
            mInitMap.put(new Pair<String, String>("func_76222_j", "isReplaceable"));
            mInitMap.put(new Pair<String, String>("func_76223_p", "setTranslucent"));
            mInitMap.put(new Pair<String, String>("func_76224_d", "isLiquid"));
            mInitMap.put(new Pair<String, String>("func_76225_o", "setImmovableMobility"));
            mInitMap.put(new Pair<String, String>("func_76226_g", "setBurning"));
            mInitMap.put(new Pair<String, String>("func_76227_m", "getMaterialMobility"));
            mInitMap.put(new Pair<String, String>("func_76228_b", "blocksLight"));
            mInitMap.put(new Pair<String, String>("func_76229_l", "isToolNotRequired"));
            mInitMap.put(new Pair<String, String>("func_76230_c", "blocksMovement"));
            mInitMap.put(new Pair<String, String>("func_76231_i", "setReplaceable"));
            mInitMap.put(new Pair<String, String>("func_76269_a", "getRandomItem"));
            mInitMap.put(new Pair<String, String>("func_76270_a", "getTotalWeight"));
            mInitMap.put(new Pair<String, String>("func_76271_a", "getRandomItem"));
            mInitMap.put(new Pair<String, String>("func_76272_a", "getTotalWeight"));
            mInitMap.put(new Pair<String, String>("func_76273_a", "getRandomItem"));
            mInitMap.put(new Pair<String, String>("func_76274_a", "getRandomItem"));
            mInitMap.put(new Pair<String, String>("func_76293_a", "generateChestContents"));
            mInitMap.put(new Pair<String, String>("func_76304_a", "generateNoiseOctaves"));
            mInitMap.put(new Pair<String, String>("func_76305_a", "generateNoiseOctaves"));
            mInitMap.put(new Pair<String, String>("func_76308_a", "populateNoiseArray"));
            mInitMap.put(new Pair<String, String>("func_76310_a", "grad"));
            mInitMap.put(new Pair<String, String>("func_76311_b", "lerp"));
            mInitMap.put(new Pair<String, String>("func_76316_a", "onInventoryChanged"));
            mInitMap.put(new Pair<String, String>("func_76317_a", "clearProfiling"));
            mInitMap.put(new Pair<String, String>("func_76318_c", "endStartSection"));
            mInitMap.put(new Pair<String, String>("func_76319_b", "endSection"));
            mInitMap.put(new Pair<String, String>("func_76320_a", "startSection"));
            mInitMap.put(new Pair<String, String>("func_76321_b", "getProfilingData"));
            mInitMap.put(new Pair<String, String>("func_76322_c", "getNameOfLastSection"));
            mInitMap.put(new Pair<String, String>("func_76333_a", "smooth"));
            mInitMap.put(new Pair<String, String>("func_76337_a", "ticksToElapsedTime"));
            mInitMap.put(new Pair<String, String>("func_76338_a", "stripControlCodes"));
            mInitMap.put(new Pair<String, String>("func_76340_b", "getSecond"));
            mInitMap.put(new Pair<String, String>("func_76341_a", "getFirst"));
            mInitMap.put(new Pair<String, String>("func_76345_d", "getHungerDamage"));
            mInitMap.put(new Pair<String, String>("func_76346_g", "getEntity"));
            mInitMap.put(new Pair<String, String>("func_76347_k", "isFireDamage"));
            mInitMap.put(new Pair<String, String>("func_76348_h", "setDamageBypassesArmor"));
            mInitMap.put(new Pair<String, String>("func_76349_b", "setProjectile"));
            mInitMap.put(new Pair<String, String>("func_76350_n", "isDifficultyScaled"));
            mInitMap.put(new Pair<String, String>("func_76351_m", "setDifficultyScaled"));
            mInitMap.put(new Pair<String, String>("func_76352_a", "isProjectile"));
            mInitMap.put(new Pair<String, String>("func_76353_a", "causeArrowDamage"));
            mInitMap.put(new Pair<String, String>("func_76354_b", "causeIndirectMagicDamage"));
            mInitMap.put(new Pair<String, String>("func_76355_l", "getDamageType"));
            mInitMap.put(new Pair<String, String>("func_76356_a", "causeThrownDamage"));
            mInitMap.put(new Pair<String, String>("func_76357_e", "canHarmInCreative"));
            mInitMap.put(new Pair<String, String>("func_76358_a", "causeMobDamage"));
            mInitMap.put(new Pair<String, String>("func_76359_i", "setDamageAllowedInCreativeMode"));
            mInitMap.put(new Pair<String, String>("func_76361_j", "setFireDamage"));
            mInitMap.put(new Pair<String, String>("func_76362_a", "causeFireballDamage"));
            mInitMap.put(new Pair<String, String>("func_76363_c", "isUnblockable"));
            mInitMap.put(new Pair<String, String>("func_76364_f", "getSourceOfDamage"));
            mInitMap.put(new Pair<String, String>("func_76365_a", "causePlayerDamage"));
            mInitMap.put(new Pair<String, String>("func_76388_g", "getEffectiveness"));
            mInitMap.put(new Pair<String, String>("func_76389_a", "getDurationString"));
            mInitMap.put(new Pair<String, String>("func_76390_b", "setPotionName"));
            mInitMap.put(new Pair<String, String>("func_76392_e", "getStatusIconIndex"));
            mInitMap.put(new Pair<String, String>("func_76393_a", "getName"));
            mInitMap.put(new Pair<String, String>("func_76394_a", "performEffect"));
            mInitMap.put(new Pair<String, String>("func_76395_i", "isUsable"));
            mInitMap.put(new Pair<String, String>("func_76396_c", "getId"));
            mInitMap.put(new Pair<String, String>("func_76397_a", "isReady"));
            mInitMap.put(new Pair<String, String>("func_76398_f", "isBadEffect"));
            mInitMap.put(new Pair<String, String>("func_76399_b", "setIconIndex"));
            mInitMap.put(new Pair<String, String>("func_76400_d", "hasStatusIcon"));
            mInitMap.put(new Pair<String, String>("func_76401_j", "getLiquidColor"));
            mInitMap.put(new Pair<String, String>("func_76402_a", "affectEntity"));
            mInitMap.put(new Pair<String, String>("func_76403_b", "isInstant"));
            mInitMap.put(new Pair<String, String>("func_76404_a", "setEffectiveness"));
            mInitMap.put(new Pair<String, String>("func_76445_a", "getIntCache"));
            mInitMap.put(new Pair<String, String>("func_76446_a", "resetIntCache"));
            mInitMap.put(new Pair<String, String>("func_76452_a", "combine"));
            mInitMap.put(new Pair<String, String>("func_76453_d", "getEffectName"));
            mInitMap.put(new Pair<String, String>("func_76454_e", "deincrementDuration"));
            mInitMap.put(new Pair<String, String>("func_76455_a", "onUpdate"));
            mInitMap.put(new Pair<String, String>("func_76456_a", "getPotionID"));
            mInitMap.put(new Pair<String, String>("func_76457_b", "performEffect"));
            mInitMap.put(new Pair<String, String>("func_76458_c", "getAmplifier"));
            mInitMap.put(new Pair<String, String>("func_76459_b", "getDuration"));
            mInitMap.put(new Pair<String, String>("func_76463_a", "startSnooper"));
            mInitMap.put(new Pair<String, String>("func_76465_c", "getCurrentStats"));
            mInitMap.put(new Pair<String, String>("func_76467_g", "addJvmArgsToSnooper"));
            mInitMap.put(new Pair<String, String>("func_76468_d", "isSnooperRunning"));
            mInitMap.put(new Pair<String, String>("func_76470_e", "stopSnooper"));
            mInitMap.put(new Pair<String, String>("func_76471_b", "addMemoryStatsToSnooper"));
            mInitMap.put(new Pair<String, String>("func_76484_a", "generate"));
            mInitMap.put(new Pair<String, String>("func_76487_a", "setScale"));
            mInitMap.put(new Pair<String, String>("func_76489_a", "generateLeafNodeList"));
            mInitMap.put(new Pair<String, String>("func_76490_a", "layerSize"));
            mInitMap.put(new Pair<String, String>("func_76491_a", "generateLeafNode"));
            mInitMap.put(new Pair<String, String>("func_76493_c", "leafNodeNeedsBase"));
            mInitMap.put(new Pair<String, String>("func_76494_d", "generateLeafNodeBases"));
            mInitMap.put(new Pair<String, String>("func_76495_b", "leafSize"));
            mInitMap.put(new Pair<String, String>("func_76496_a", "checkBlockLine"));
            mInitMap.put(new Pair<String, String>("func_76497_e", "validTreeLocation"));
            mInitMap.put(new Pair<String, String>("func_76498_b", "generateLeaves"));
            mInitMap.put(new Pair<String, String>("func_76499_c", "generateTrunk"));
            mInitMap.put(new Pair<String, String>("func_76529_b", "growVines"));
            mInitMap.put(new Pair<String, String>("func_76536_b", "generateVines"));
            mInitMap.put(new Pair<String, String>("func_76543_b", "pickMobSpawner"));
            mInitMap.put(new Pair<String, String>("func_76549_c", "getChunkInputStream"));
            mInitMap.put(new Pair<String, String>("func_76550_a", "createOrLoadRegionFile"));
            mInitMap.put(new Pair<String, String>("func_76551_a", "clearRegionFileReferences"));
            mInitMap.put(new Pair<String, String>("func_76552_d", "getChunkOutputStream"));
            mInitMap.put(new Pair<String, String>("func_76554_h", "getEntrancePortalLocation"));
            mInitMap.put(new Pair<String, String>("func_76555_c", "createChunkGenerator"));
            mInitMap.put(new Pair<String, String>("func_76556_a", "generateLightBrightnessTable"));
            mInitMap.put(new Pair<String, String>("func_76557_i", "getAverageGroundLevel"));
            mInitMap.put(new Pair<String, String>("func_76558_a", "registerWorld"));
            mInitMap.put(new Pair<String, String>("func_76559_b", "getMoonPhase"));
            mInitMap.put(new Pair<String, String>("func_76560_a", "calcSunriseSunsetColors"));
            mInitMap.put(new Pair<String, String>("func_76561_g", "isSkyColored"));
            mInitMap.put(new Pair<String, String>("func_76562_b", "getFogColor"));
            mInitMap.put(new Pair<String, String>("func_76563_a", "calculateCelestialAngle"));
            mInitMap.put(new Pair<String, String>("func_76564_j", "getWorldHasVoidParticles"));
            mInitMap.put(new Pair<String, String>("func_76565_k", "getVoidFogYFactor"));
            mInitMap.put(new Pair<String, String>("func_76566_a", "canCoordinateBeSpawn"));
            mInitMap.put(new Pair<String, String>("func_76567_e", "canRespawnHere"));
            mInitMap.put(new Pair<String, String>("func_76568_b", "doesXZShowFog"));
            mInitMap.put(new Pair<String, String>("func_76569_d", "isSurfaceWorld"));
            mInitMap.put(new Pair<String, String>("func_76570_a", "getProviderForDimension"));
            mInitMap.put(new Pair<String, String>("func_76571_f", "getCloudHeight"));
            mInitMap.put(new Pair<String, String>("func_76572_b", "registerWorldChunkManager"));
            mInitMap.put(new Pair<String, String>("func_76581_a", "set"));
            mInitMap.put(new Pair<String, String>("func_76582_a", "get"));
            mInitMap.put(new Pair<String, String>("func_76587_i", "getBlockStorageArray"));
            mInitMap.put(new Pair<String, String>("func_76588_a", "getEntitiesWithinAABBForEntity"));
            mInitMap.put(new Pair<String, String>("func_76589_b", "setBlockMetadata"));
            mInitMap.put(new Pair<String, String>("func_76590_a", "generateHeightMap"));
            mInitMap.put(new Pair<String, String>("func_76591_a", "getBiomeGenForWorldCoords"));
            mInitMap.put(new Pair<String, String>("func_76594_o", "enqueueRelightChecks"));
            mInitMap.put(new Pair<String, String>("func_76595_e", "propagateSkylightOcclusion"));
            mInitMap.put(new Pair<String, String>("func_76599_g", "checkSkylightNeighborHeight"));
            mInitMap.put(new Pair<String, String>("func_76600_a", "isAtLocation"));
            mInitMap.put(new Pair<String, String>("func_76601_a", "needsSaving"));
            mInitMap.put(new Pair<String, String>("func_76602_a", "setStorageArrays"));
            mInitMap.put(new Pair<String, String>("func_76603_b", "generateSkylightMap"));
            mInitMap.put(new Pair<String, String>("func_76605_m", "getBiomeArray"));
            mInitMap.put(new Pair<String, String>("func_76606_c", "getAreLevelsEmpty"));
            mInitMap.put(new Pair<String, String>("func_76607_a", "fillChunk"));
            mInitMap.put(new Pair<String, String>("func_76608_a", "removeEntityAtIndex"));
            mInitMap.put(new Pair<String, String>("func_76609_d", "updateSkylightNeighborHeight"));
            mInitMap.put(new Pair<String, String>("func_76611_b", "getHeightValue"));
            mInitMap.put(new Pair<String, String>("func_76612_a", "addEntity"));
            mInitMap.put(new Pair<String, String>("func_76613_n", "resetRelightChecks"));
            mInitMap.put(new Pair<String, String>("func_76614_a", "getSavedLightValue"));
            mInitMap.put(new Pair<String, String>("func_76615_h", "relightBlock"));
            mInitMap.put(new Pair<String, String>("func_76616_a", "setBiomeArray"));
            mInitMap.put(new Pair<String, String>("func_76617_a", "getRandomWithSeed"));
            mInitMap.put(new Pair<String, String>("func_76618_a", "getEntitiesOfTypeWithinAAAB"));
            mInitMap.put(new Pair<String, String>("func_76619_d", "canBlockSeeTheSky"));
            mInitMap.put(new Pair<String, String>("func_76621_g", "isEmpty"));
            mInitMap.put(new Pair<String, String>("func_76622_b", "removeEntity"));
            mInitMap.put(new Pair<String, String>("func_76623_d", "onChunkUnload"));
            mInitMap.put(new Pair<String, String>("func_76624_a", "populateChunk"));
            mInitMap.put(new Pair<String, String>("func_76625_h", "getTopFilledSegment"));
            mInitMap.put(new Pair<String, String>("func_76626_d", "getPrecipitationHeight"));
            mInitMap.put(new Pair<String, String>("func_76628_c", "getBlockMetadata"));
            mInitMap.put(new Pair<String, String>("func_76629_c", "getBlockLightValue"));
            mInitMap.put(new Pair<String, String>("func_76630_e", "setChunkModified"));
            mInitMap.put(new Pair<String, String>("func_76631_c", "onChunkLoad"));
            mInitMap.put(new Pair<String, String>("func_76632_l", "getChunkCoordIntPair"));
            mInitMap.put(new Pair<String, String>("func_76633_a", "setLightValue"));
            mInitMap.put(new Pair<String, String>("func_76654_b", "setExtBlockMetadata"));
            mInitMap.put(new Pair<String, String>("func_76657_c", "setExtSkylightValue"));
            mInitMap.put(new Pair<String, String>("func_76658_g", "getBlockLSBArray"));
            mInitMap.put(new Pair<String, String>("func_76659_c", "setBlocklightArray"));
            mInitMap.put(new Pair<String, String>("func_76660_i", "getBlockMSBArray"));
            mInitMap.put(new Pair<String, String>("func_76661_k", "getBlocklightArray"));
            mInitMap.put(new Pair<String, String>("func_76662_d", "getYLocation"));
            mInitMap.put(new Pair<String, String>("func_76663_a", "isEmpty"));
            mInitMap.put(new Pair<String, String>("func_76664_a", "setBlockLSBArray"));
            mInitMap.put(new Pair<String, String>("func_76665_b", "getExtBlockMetadata"));
            mInitMap.put(new Pair<String, String>("func_76666_d", "setSkylightArray"));
            mInitMap.put(new Pair<String, String>("func_76667_m", "createBlockMSBArray"));
            mInitMap.put(new Pair<String, String>("func_76668_b", "setBlockMetadataArray"));
            mInitMap.put(new Pair<String, String>("func_76669_j", "getMetadataArray"));
            mInitMap.put(new Pair<String, String>("func_76670_c", "getExtSkylightValue"));
            mInitMap.put(new Pair<String, String>("func_76671_l", "getSkylightArray"));
            mInitMap.put(new Pair<String, String>("func_76672_e", "removeInvalidBlocks"));
            mInitMap.put(new Pair<String, String>("func_76673_a", "setBlockMSBArray"));
            mInitMap.put(new Pair<String, String>("func_76674_d", "getExtBlocklightValue"));
            mInitMap.put(new Pair<String, String>("func_76675_b", "getNeedsRandomTick"));
            mInitMap.put(new Pair<String, String>("func_76676_h", "clearMSBArray"));
            mInitMap.put(new Pair<String, String>("func_76677_d", "setExtBlocklightValue"));
            mInitMap.put(new Pair<String, String>("func_76686_a", "get"));
            mInitMap.put(new Pair<String, String>("func_76690_a", "convertToAnvilFormat"));
            mInitMap.put(new Pair<String, String>("func_76691_a", "load"));
            mInitMap.put(new Pair<String, String>("func_76704_a", "getChunkDataInputStream"));
            mInitMap.put(new Pair<String, String>("func_76705_d", "outOfBounds"));
            mInitMap.put(new Pair<String, String>("func_76706_a", "write"));
            mInitMap.put(new Pair<String, String>("func_76707_e", "getOffset"));
            mInitMap.put(new Pair<String, String>("func_76708_c", "close"));
            mInitMap.put(new Pair<String, String>("func_76709_c", "isChunkSaved"));
            mInitMap.put(new Pair<String, String>("func_76710_b", "getChunkDataOutputStream"));
            mInitMap.put(new Pair<String, String>("func_76711_a", "setOffset"));
            mInitMap.put(new Pair<String, String>("func_76712_a", "write"));
            mInitMap.put(new Pair<String, String>("func_76713_b", "setChunkTimestamp"));
            mInitMap.put(new Pair<String, String>("func_76727_i", "getFloatRainfall"));
            mInitMap.put(new Pair<String, String>("func_76728_a", "decorate"));
            mInitMap.put(new Pair<String, String>("func_76729_a", "createBiomeDecorator"));
            mInitMap.put(new Pair<String, String>("func_76730_b", "getRandomWorldGenForGrass"));
            mInitMap.put(new Pair<String, String>("func_76731_a", "getSkyColorByTemp"));
            mInitMap.put(new Pair<String, String>("func_76732_a", "setTemperatureRainfall"));
            mInitMap.put(new Pair<String, String>("func_76735_a", "setBiomeName"));
            mInitMap.put(new Pair<String, String>("func_76736_e", "isHighHumidity"));
            mInitMap.put(new Pair<String, String>("func_76738_d", "canSpawnLightningBolt"));
            mInitMap.put(new Pair<String, String>("func_76739_b", "setColor"));
            mInitMap.put(new Pair<String, String>("func_76741_f", "getSpawningChance"));
            mInitMap.put(new Pair<String, String>("func_76742_b", "setEnableSnow"));
            mInitMap.put(new Pair<String, String>("func_76744_g", "getIntRainfall"));
            mInitMap.put(new Pair<String, String>("func_76745_m", "setDisableRain"));
            mInitMap.put(new Pair<String, String>("func_76746_c", "getEnableSnow"));
            mInitMap.put(new Pair<String, String>("func_76747_a", "getSpawnableList"));
            mInitMap.put(new Pair<String, String>("func_76793_b", "genStandardOre2"));
            mInitMap.put(new Pair<String, String>("func_76795_a", "genStandardOre1"));
            mInitMap.put(new Pair<String, String>("func_76797_b", "generateOres"));
            mInitMap.put(new Pair<String, String>("func_76837_b", "getBiomeGenAt"));
            mInitMap.put(new Pair<String, String>("func_76838_a", "cleanupCache"));
            mInitMap.put(new Pair<String, String>("func_76839_e", "getCachedBiomes"));
            mInitMap.put(new Pair<String, String>("func_76840_a", "getBiomeCacheBlock"));
            mInitMap.put(new Pair<String, String>("func_76885_a", "getBiomeGenAt"));
            mInitMap.put(new Pair<String, String>("func_76931_a", "getBiomeGenAt"));
            mInitMap.put(new Pair<String, String>("func_76932_a", "getBiomesToSpawnIn"));
            mInitMap.put(new Pair<String, String>("func_76933_b", "loadBlockGeneratorData"));
            mInitMap.put(new Pair<String, String>("func_76935_a", "getBiomeGenAt"));
            mInitMap.put(new Pair<String, String>("func_76936_a", "getRainfall"));
            mInitMap.put(new Pair<String, String>("func_76937_a", "getBiomesForGeneration"));
            mInitMap.put(new Pair<String, String>("func_76938_b", "cleanupCache"));
            mInitMap.put(new Pair<String, String>("func_76939_a", "getTemperatureAtHeight"));
            mInitMap.put(new Pair<String, String>("func_76940_a", "areBiomesViable"));
            mInitMap.put(new Pair<String, String>("func_76975_c", "renderShadow"));
            mInitMap.put(new Pair<String, String>("func_76976_a", "setRenderManager"));
            mInitMap.put(new Pair<String, String>("func_76977_a", "renderEntityOnFire"));
            mInitMap.put(new Pair<String, String>("func_76978_a", "renderOffsetAABB"));
            mInitMap.put(new Pair<String, String>("func_76979_b", "doRenderShadowAndFire"));
            mInitMap.put(new Pair<String, String>("func_76980_a", "renderAABB"));
            mInitMap.put(new Pair<String, String>("func_76982_b", "getWorldFromRenderManager"));
            mInitMap.put(new Pair<String, String>("func_76983_a", "getFontRendererFromRenderManager"));
            mInitMap.put(new Pair<String, String>("func_76986_a", "doRender"));
            mInitMap.put(new Pair<String, String>("func_77015_a", "renderItemIntoGUI"));
            mInitMap.put(new Pair<String, String>("func_77017_a", "renderQuad"));
            mInitMap.put(new Pair<String, String>("func_77018_a", "renderGlint"));
            mInitMap.put(new Pair<String, String>("func_77020_a", "renderDroppedItem"));
            mInitMap.put(new Pair<String, String>("func_77021_b", "renderItemOverlayIntoGUI"));
            mInitMap.put(new Pair<String, String>("func_77026_a", "renderEntity"));
            mInitMap.put(new Pair<String, String>("func_77029_c", "renderEquippedItems"));
            mInitMap.put(new Pair<String, String>("func_77030_a", "getColorMultiplier"));
            mInitMap.put(new Pair<String, String>("func_77032_a", "shouldRenderPass"));
            mInitMap.put(new Pair<String, String>("func_77033_b", "passSpecialRender"));
            mInitMap.put(new Pair<String, String>("func_77034_a", "interpolateRotation"));
            mInitMap.put(new Pair<String, String>("func_77035_b", "inheritRenderPass"));
            mInitMap.put(new Pair<String, String>("func_77036_a", "renderModel"));
            mInitMap.put(new Pair<String, String>("func_77037_a", "getDeathMaxRotation"));
            mInitMap.put(new Pair<String, String>("func_77039_a", "renderLivingAt"));
            mInitMap.put(new Pair<String, String>("func_77040_d", "getSwingProgress"));
            mInitMap.put(new Pair<String, String>("func_77041_b", "preRenderCallback"));
            mInitMap.put(new Pair<String, String>("func_77042_a", "setRenderPassModel"));
            mInitMap.put(new Pair<String, String>("func_77043_a", "rotateCorpse"));
            mInitMap.put(new Pair<String, String>("func_77044_a", "handleRotationFloat"));
            mInitMap.put(new Pair<String, String>("func_77124_a", "setCanBeCreated"));
            mInitMap.put(new Pair<String, String>("func_77125_e", "isVersioned"));
            mInitMap.put(new Pair<String, String>("func_77126_d", "getCanBeCreated"));
            mInitMap.put(new Pair<String, String>("func_77127_a", "getWorldTypeName"));
            mInitMap.put(new Pair<String, String>("func_77128_b", "getTranslateName"));
            mInitMap.put(new Pair<String, String>("func_77129_f", "setVersioned"));
            mInitMap.put(new Pair<String, String>("func_77130_a", "parseWorldType"));
            mInitMap.put(new Pair<String, String>("func_77131_c", "getGeneratorVersion"));
            mInitMap.put(new Pair<String, String>("func_77132_a", "getWorldTypeForGeneratorVersion"));
            mInitMap.put(new Pair<String, String>("func_77142_a", "getByName"));
            mInitMap.put(new Pair<String, String>("func_77144_e", "isSurvivalOrAdventure"));
            mInitMap.put(new Pair<String, String>("func_77145_d", "isCreative"));
            mInitMap.put(new Pair<String, String>("func_77146_a", "getByID"));
            mInitMap.put(new Pair<String, String>("func_77147_a", "configurePlayerCapabilities"));
            mInitMap.put(new Pair<String, String>("func_77148_a", "getID"));
            mInitMap.put(new Pair<String, String>("func_77149_b", "getName"));
            mInitMap.put(new Pair<String, String>("func_77158_f", "getHardcoreEnabled"));
            mInitMap.put(new Pair<String, String>("func_77159_a", "enableBonusChest"));
            mInitMap.put(new Pair<String, String>("func_77160_d", "getSeed"));
            mInitMap.put(new Pair<String, String>("func_77161_a", "getGameTypeById"));
            mInitMap.put(new Pair<String, String>("func_77162_e", "getGameType"));
            mInitMap.put(new Pair<String, String>("func_77163_i", "areCommandsAllowed"));
            mInitMap.put(new Pair<String, String>("func_77164_g", "isMapFeaturesEnabled"));
            mInitMap.put(new Pair<String, String>("func_77165_h", "getTerrainType"));
            mInitMap.put(new Pair<String, String>("func_77166_b", "enableCommands"));
            mInitMap.put(new Pair<String, String>("func_77167_c", "isBonusChestEnabled"));
            mInitMap.put(new Pair<String, String>("func_77176_a", "setScheduledTime"));
            mInitMap.put(new Pair<String, String>("func_77184_b", "placeInExistingPortal"));
            mInitMap.put(new Pair<String, String>("func_77185_a", "placeInPortal"));
            mInitMap.put(new Pair<String, String>("func_77190_a", "canCreatureTypeSpawnAtLocation"));
            mInitMap.put(new Pair<String, String>("func_77191_a", "performWorldGenSpawning"));
            mInitMap.put(new Pair<String, String>("func_77192_a", "findChunksForSpawning"));
            mInitMap.put(new Pair<String, String>("func_77201_a", "readRecipiesFromTags"));
            mInitMap.put(new Pair<String, String>("func_77202_a", "getRecipiesAsTags"));
            mInitMap.put(new Pair<String, String>("func_77203_a", "canRecipeBeUsed"));
            mInitMap.put(new Pair<String, String>("func_77205_a", "addToListWithCheck"));
            mInitMap.put(new Pair<String, String>("func_77272_a", "chunkXZ2Int"));
            mInitMap.put(new Pair<String, String>("func_77273_a", "getCenterXPos"));
            mInitMap.put(new Pair<String, String>("func_77274_b", "getCenterZPosition"));
            mInitMap.put(new Pair<String, String>("func_77278_a", "doExplosionA"));
            mInitMap.put(new Pair<String, String>("func_77279_a", "doExplosionB"));
            mInitMap.put(new Pair<String, String>("func_77316_c", "getTranslatedName"));
            mInitMap.put(new Pair<String, String>("func_77317_b", "getMaxEnchantability"));
            mInitMap.put(new Pair<String, String>("func_77318_a", "calcModifierDamage"));
            mInitMap.put(new Pair<String, String>("func_77319_d", "getMinLevel"));
            mInitMap.put(new Pair<String, String>("func_77320_a", "getName"));
            mInitMap.put(new Pair<String, String>("func_77321_a", "getMinEnchantability"));
            mInitMap.put(new Pair<String, String>("func_77322_b", "setName"));
            mInitMap.put(new Pair<String, String>("func_77324_c", "getWeight"));
            mInitMap.put(new Pair<String, String>("func_77325_b", "getMaxLevel"));
            mInitMap.put(new Pair<String, String>("func_77326_a", "canApplyTogether"));
            mInitMap.put(new Pair<String, String>("func_77390_a", "readFromTags"));
            mInitMap.put(new Pair<String, String>("func_77391_b", "hasSameItemsAs"));
            mInitMap.put(new Pair<String, String>("func_77393_a", "hasSameIDsAs"));
            mInitMap.put(new Pair<String, String>("func_77394_a", "getItemToBuy"));
            mInitMap.put(new Pair<String, String>("func_77395_g", "writeToTags"));
            mInitMap.put(new Pair<String, String>("func_77396_b", "getSecondItemToBuy"));
            mInitMap.put(new Pair<String, String>("func_77397_d", "getItemToSell"));
            mInitMap.put(new Pair<String, String>("func_77398_c", "hasSecondItemToBuy"));
            mInitMap.put(new Pair<String, String>("func_77399_f", "incrementToolUses"));
            mInitMap.put(new Pair<String, String>("func_77442_b", "canUnlockAchievement"));
            mInitMap.put(new Pair<String, String>("func_77443_a", "hasAchievementUnlocked"));
            mInitMap.put(new Pair<String, String>("func_77444_a", "writeStat"));
            mInitMap.put(new Pair<String, String>("func_77466_a", "getFoliageColorPine"));
            mInitMap.put(new Pair<String, String>("func_77467_a", "setFoliageBiomeColorizer"));
            mInitMap.put(new Pair<String, String>("func_77468_c", "getFoliageColorBasic"));
            mInitMap.put(new Pair<String, String>("func_77469_b", "getFoliageColorBirch"));
            mInitMap.put(new Pair<String, String>("func_77470_a", "getFoliageColor"));
            mInitMap.put(new Pair<String, String>("func_77472_b", "setClientActiveTexture"));
            mInitMap.put(new Pair<String, String>("func_77473_a", "setActiveTexture"));
            mInitMap.put(new Pair<String, String>("func_77474_a", "initializeTextures"));
            mInitMap.put(new Pair<String, String>("func_77475_a", "setLightmapTextureCoords"));
            mInitMap.put(new Pair<String, String>("func_77479_a", "setGrassBiomeColorizer"));
            mInitMap.put(new Pair<String, String>("func_77480_a", "getGrassColor"));
            mInitMap.put(new Pair<String, String>("func_77487_a", "getServerMotd"));
            mInitMap.put(new Pair<String, String>("func_77488_b", "getServerIpPort"));
            mInitMap.put(new Pair<String, String>("func_77489_c", "updateLastSeen"));
            mInitMap.put(new Pair<String, String>("func_77493_a", "calculateModifier"));
            mInitMap.put(new Pair<String, String>("func_77501_a", "getRespiration"));
            mInitMap.put(new Pair<String, String>("func_77502_d", "getSilkTouchModifier"));
            mInitMap.put(new Pair<String, String>("func_77504_a", "addRandomEnchantment"));
            mInitMap.put(new Pair<String, String>("func_77505_b", "mapEnchantmentData"));
            mInitMap.put(new Pair<String, String>("func_77506_a", "getEnchantmentLevel"));
            mInitMap.put(new Pair<String, String>("func_77507_b", "getKnockbackModifier"));
            mInitMap.put(new Pair<String, String>("func_77508_a", "getEnchantmentModifierDamage"));
            mInitMap.put(new Pair<String, String>("func_77509_b", "getEfficiencyModifier"));
            mInitMap.put(new Pair<String, String>("func_77510_g", "getAquaAffinityModifier"));
            mInitMap.put(new Pair<String, String>("func_77511_a", "getMaxEnchantmentLevel"));
            mInitMap.put(new Pair<String, String>("func_77512_a", "getEnchantmentModifierLiving"));
            mInitMap.put(new Pair<String, String>("func_77513_b", "buildEnchantmentList"));
            mInitMap.put(new Pair<String, String>("func_77514_a", "calcItemStackEnchantability"));
            mInitMap.put(new Pair<String, String>("func_77516_a", "applyEnchantmentModifierArray"));
            mInitMap.put(new Pair<String, String>("func_77517_e", "getFortuneModifier"));
            mInitMap.put(new Pair<String, String>("func_77518_a", "applyEnchantmentModifier"));
            mInitMap.put(new Pair<String, String>("func_77519_f", "getLootingModifier"));
            mInitMap.put(new Pair<String, String>("func_77523_b", "getAdFromPingResponse"));
            mInitMap.put(new Pair<String, String>("func_77524_a", "getMotdFromPingResponse"));
            mInitMap.put(new Pair<String, String>("func_77525_a", "getPingResponse"));
            mInitMap.put(new Pair<String, String>("func_77552_b", "setWasNotUpdated"));
            mInitMap.put(new Pair<String, String>("func_77553_a", "getWasUpdated"));
            mInitMap.put(new Pair<String, String>("func_77554_c", "getLanServers"));
            mInitMap.put(new Pair<String, String>("func_77557_a", "canEnchantItem"));
            mInitMap.put(new Pair<String, String>("func_77569_a", "matches"));
            mInitMap.put(new Pair<String, String>("func_77570_a", "getRecipeSize"));
            mInitMap.put(new Pair<String, String>("func_77571_b", "getRecipeOutput"));
            mInitMap.put(new Pair<String, String>("func_77572_b", "getCraftingResult"));
            mInitMap.put(new Pair<String, String>("func_77573_a", "checkMatch"));
            mInitMap.put(new Pair<String, String>("func_77583_a", "addRecipes"));
            mInitMap.put(new Pair<String, String>("func_77586_a", "addRecipes"));
            mInitMap.put(new Pair<String, String>("func_77589_a", "addRecipes"));
            mInitMap.put(new Pair<String, String>("func_77590_a", "addRecipes"));
            mInitMap.put(new Pair<String, String>("func_77592_b", "getRecipeList"));
            mInitMap.put(new Pair<String, String>("func_77594_a", "getInstance"));
            mInitMap.put(new Pair<String, String>("func_77596_b", "addShapelessRecipe"));
            mInitMap.put(new Pair<String, String>("func_77599_b", "getSmeltingList"));
            mInitMap.put(new Pair<String, String>("func_77602_a", "instance"));
            mInitMap.put(new Pair<String, String>("func_77607_a", "addRecipes"));
            mInitMap.put(new Pair<String, String>("func_77608_a", "addRecipes"));
            mInitMap.put(new Pair<String, String>("func_77609_a", "addRecipes"));
            mInitMap.put(new Pair<String, String>("func_77612_l", "getMaxDurability"));
            mInitMap.put(new Pair<String, String>("func_77613_e", "getRarity"));
            mInitMap.put(new Pair<String, String>("func_77614_k", "getHasSubtypes"));
            mInitMap.put(new Pair<String, String>("func_77615_a", "onPlayerStoppedUsing"));
            mInitMap.put(new Pair<String, String>("func_77616_k", "isItemTool"));
            mInitMap.put(new Pair<String, String>("func_77617_a", "getIconFromDamage"));
            mInitMap.put(new Pair<String, String>("func_77618_c", "getIconFromDamageForRenderPass"));
            mInitMap.put(new Pair<String, String>("func_77619_b", "getItemEnchantability"));
            mInitMap.put(new Pair<String, String>("func_77620_a", "getColorFromDamage"));
            mInitMap.put(new Pair<String, String>("func_77621_a", "getMovingObjectPositionFromPlayer"));
            mInitMap.put(new Pair<String, String>("func_77622_d", "onCreated"));
            mInitMap.put(new Pair<String, String>("func_77623_v", "requiresMultipleRenderPasses"));
            mInitMap.put(new Pair<String, String>("func_77624_a", "addInformation"));
            mInitMap.put(new Pair<String, String>("func_77625_d", "setMaxStackSize"));
            mInitMap.put(new Pair<String, String>("func_77626_a", "getMaxItemUseDuration"));
            mInitMap.put(new Pair<String, String>("func_77627_a", "setHasSubtypes"));
            mInitMap.put(new Pair<String, String>("func_77629_n_", "shouldRotateAroundWhenRendering"));
            mInitMap.put(new Pair<String, String>("func_77630_h", "doesContainerItemLeaveCraftingGrid"));
            mInitMap.put(new Pair<String, String>("func_77631_c", "setPotionEffect"));
            mInitMap.put(new Pair<String, String>("func_77634_r", "hasContainerItem"));
            mInitMap.put(new Pair<String, String>("func_77636_d", "hasEffect"));
            mInitMap.put(new Pair<String, String>("func_77637_a", "setCreativeTab"));
            mInitMap.put(new Pair<String, String>("func_77639_j", "getItemStackLimit"));
            mInitMap.put(new Pair<String, String>("func_77640_w", "getCreativeTab"));
            mInitMap.put(new Pair<String, String>("func_77642_a", "setContainerItem"));
            mInitMap.put(new Pair<String, String>("func_77643_m_", "isMap"));
            mInitMap.put(new Pair<String, String>("func_77644_a", "hitEntity"));
            mInitMap.put(new Pair<String, String>("func_77645_m", "isDamageable"));
            mInitMap.put(new Pair<String, String>("func_77647_b", "getMetadata"));
            mInitMap.put(new Pair<String, String>("func_77648_a", "onItemUse"));
            mInitMap.put(new Pair<String, String>("func_77650_f", "getIconIndex"));
            mInitMap.put(new Pair<String, String>("func_77651_p", "getShareTag"));
            mInitMap.put(new Pair<String, String>("func_77653_i", "getItemStackDisplayName"));
            mInitMap.put(new Pair<String, String>("func_77654_b", "onItemUseFinish"));
            mInitMap.put(new Pair<String, String>("func_77655_b", "setUnlocalizedName"));
            mInitMap.put(new Pair<String, String>("func_77656_e", "setMaxDurability"));
            mInitMap.put(new Pair<String, String>("func_77657_g", "getUnlocalizedNameInefficiently"));
            mInitMap.put(new Pair<String, String>("func_77658_a", "getUnlocalizedName"));
            mInitMap.put(new Pair<String, String>("func_77659_a", "onItemRightClick"));
            mInitMap.put(new Pair<String, String>("func_77661_b", "getItemUseAction"));
            mInitMap.put(new Pair<String, String>("func_77662_d", "isFull3D"));
            mInitMap.put(new Pair<String, String>("func_77663_a", "onUpdate"));
            mInitMap.put(new Pair<String, String>("func_77664_n", "setFull3D"));
            mInitMap.put(new Pair<String, String>("func_77667_c", "getUnlocalizedName"));
            mInitMap.put(new Pair<String, String>("func_77668_q", "getContainerItem"));
            mInitMap.put(new Pair<String, String>("func_77828_a", "validBookTagContents"));
            mInitMap.put(new Pair<String, String>("func_77831_g", "isSplash"));
            mInitMap.put(new Pair<String, String>("func_77832_l", "getEffects"));
            mInitMap.put(new Pair<String, String>("func_77833_h", "isEffectInstant"));
            mInitMap.put(new Pair<String, String>("func_77834_f", "getEffects"));
            mInitMap.put(new Pair<String, String>("func_77840_a", "spawnCreature"));
            mInitMap.put(new Pair<String, String>("func_77842_f", "getMaterialName"));
            mInitMap.put(new Pair<String, String>("func_77844_a", "setPotionEffect"));
            mInitMap.put(new Pair<String, String>("func_77845_h", "isWolfsFavoriteMeat"));
            mInitMap.put(new Pair<String, String>("func_77848_i", "setAlwaysEdible"));
            mInitMap.put(new Pair<String, String>("func_77849_c", "onFoodEaten"));
            mInitMap.put(new Pair<String, String>("func_77861_e", "getToolMaterialName"));
            mInitMap.put(new Pair<String, String>("func_77872_a", "updateMapData"));
            mInitMap.put(new Pair<String, String>("func_77873_a", "getMapData"));
            mInitMap.put(new Pair<String, String>("func_77875_a", "tryPlaceContainedLiquid"));
            mInitMap.put(new Pair<String, String>("func_77906_a", "brewBitOperations"));
            mInitMap.put(new Pair<String, String>("func_77907_h", "countSetFlags"));
            mInitMap.put(new Pair<String, String>("func_77910_c", "isFlagSet"));
            mInitMap.put(new Pair<String, String>("func_77911_a", "calcPotionLiquidColor"));
            mInitMap.put(new Pair<String, String>("func_77912_a", "parsePotionEffects"));
            mInitMap.put(new Pair<String, String>("func_77913_a", "applyIngredient"));
            mInitMap.put(new Pair<String, String>("func_77914_a", "checkFlag"));
            mInitMap.put(new Pair<String, String>("func_77916_d", "isFlagUnset"));
            mInitMap.put(new Pair<String, String>("func_77917_b", "getPotionEffects"));
            mInitMap.put(new Pair<String, String>("func_77942_o", "hasTagCompound"));
            mInitMap.put(new Pair<String, String>("func_77943_a", "tryPlaceItemIntoWorld"));
            mInitMap.put(new Pair<String, String>("func_77944_b", "copyItemStack"));
            mInitMap.put(new Pair<String, String>("func_77945_a", "updateAnimation"));
            mInitMap.put(new Pair<String, String>("func_77946_l", "copy"));
            mInitMap.put(new Pair<String, String>("func_77948_v", "isItemEnchanted"));
            mInitMap.put(new Pair<String, String>("func_77949_a", "loadItemStackFromNBT"));
            mInitMap.put(new Pair<String, String>("func_77950_b", "onItemUseFinish"));
            mInitMap.put(new Pair<String, String>("func_77951_h", "isItemDamaged"));
            mInitMap.put(new Pair<String, String>("func_77952_i", "getCurrentDurability"));
            mInitMap.put(new Pair<String, String>("func_77953_t", "getRarity"));
            mInitMap.put(new Pair<String, String>("func_77954_c", "getIconIndex"));
            mInitMap.put(new Pair<String, String>("func_77955_b", "writeToNBT"));
            mInitMap.put(new Pair<String, String>("func_77956_u", "isItemEnchantable"));
            mInitMap.put(new Pair<String, String>("func_77957_a", "useItemRightClick"));
            mInitMap.put(new Pair<String, String>("func_77958_k", "getMaxDurability"));
            mInitMap.put(new Pair<String, String>("func_77959_d", "isItemStackEqual"));
            mInitMap.put(new Pair<String, String>("func_77960_j", "getMetadata"));
            mInitMap.put(new Pair<String, String>("func_77961_a", "hitEntity"));
            mInitMap.put(new Pair<String, String>("func_77962_s", "hasEffect"));
            mInitMap.put(new Pair<String, String>("func_77963_c", "readFromNBT"));
            mInitMap.put(new Pair<String, String>("func_77964_b", "setMetadata"));
            mInitMap.put(new Pair<String, String>("func_77966_a", "addEnchantment"));
            mInitMap.put(new Pair<String, String>("func_77969_a", "isItemEqual"));
            mInitMap.put(new Pair<String, String>("func_77970_a", "areItemStackTagsEqual"));
            mInitMap.put(new Pair<String, String>("func_77972_a", "damageItem"));
            mInitMap.put(new Pair<String, String>("func_77973_b", "getItem"));
            mInitMap.put(new Pair<String, String>("func_77974_b", "onPlayerStoppedUsing"));
            mInitMap.put(new Pair<String, String>("func_77975_n", "getItemUseAction"));
            mInitMap.put(new Pair<String, String>("func_77976_d", "getMaxStackSize"));
            mInitMap.put(new Pair<String, String>("func_77977_a", "getUnlocalizedName"));
            mInitMap.put(new Pair<String, String>("func_77978_p", "getTagCompound"));
            mInitMap.put(new Pair<String, String>("func_77979_a", "splitStack"));
            mInitMap.put(new Pair<String, String>("func_77980_a", "onCrafting"));
            mInitMap.put(new Pair<String, String>("func_77981_g", "getHasSubtypes"));
            mInitMap.put(new Pair<String, String>("func_77982_d", "setTagCompound"));
            mInitMap.put(new Pair<String, String>("func_77983_a", "setTagInfo"));
            mInitMap.put(new Pair<String, String>("func_77984_f", "isItemStackDamageable"));
            mInitMap.put(new Pair<String, String>("func_77985_e", "isStackable"));
            mInitMap.put(new Pair<String, String>("func_77986_q", "getEnchantmentTagList"));
            mInitMap.put(new Pair<String, String>("func_77988_m", "getMaxItemUseDuration"));
            mInitMap.put(new Pair<String, String>("func_77989_b", "areItemStacksEqual"));
            mInitMap.put(new Pair<String, String>("func_77995_e", "getEnchantability"));
            mInitMap.put(new Pair<String, String>("func_77996_d", "getHarvestLevel"));
            mInitMap.put(new Pair<String, String>("func_77997_a", "getMaxUses"));
            mInitMap.put(new Pair<String, String>("func_77998_b", "getEfficiencyOnProperMaterial"));
            mInitMap.put(new Pair<String, String>("func_78000_c", "getDamageVsEntity"));
            mInitMap.put(new Pair<String, String>("func_78013_b", "getTabLabel"));
            mInitMap.put(new Pair<String, String>("func_78014_h", "setNoTitle"));
            mInitMap.put(new Pair<String, String>("func_78015_f", "getBackgroundImageName"));
            mInitMap.put(new Pair<String, String>("func_78016_d", "getTabIconItem"));
            mInitMap.put(new Pair<String, String>("func_78017_i", "shouldHidePlayerInventory"));
            mInitMap.put(new Pair<String, String>("func_78018_a", "displayAllReleventItems"));
            mInitMap.put(new Pair<String, String>("func_78019_g", "drawInForegroundOfTab"));
            mInitMap.put(new Pair<String, String>("func_78020_k", "getTabColumn"));
            mInitMap.put(new Pair<String, String>("func_78021_a", "getTabIndex"));
            mInitMap.put(new Pair<String, String>("func_78022_j", "setNoScrollbar"));
            mInitMap.put(new Pair<String, String>("func_78023_l", "isTabInFirstRow"));
            mInitMap.put(new Pair<String, String>("func_78024_c", "getTranslatedTabLabel"));
            mInitMap.put(new Pair<String, String>("func_78025_a", "setBackgroundImageName"));
            mInitMap.put(new Pair<String, String>("func_78044_b", "getDamageReductionAmount"));
            mInitMap.put(new Pair<String, String>("func_78045_a", "getEnchantability"));
            mInitMap.put(new Pair<String, String>("func_78046_a", "getDurability"));
            mInitMap.put(new Pair<String, String>("func_78084_a", "getTextureOffset"));
            mInitMap.put(new Pair<String, String>("func_78085_a", "setTextureOffset"));
            mInitMap.put(new Pair<String, String>("func_78086_a", "setLivingAnimations"));
            mInitMap.put(new Pair<String, String>("func_78087_a", "setRotationAngles"));
            mInitMap.put(new Pair<String, String>("func_78088_a", "render"));
            mInitMap.put(new Pair<String, String>("func_78110_b", "renderEars"));
            mInitMap.put(new Pair<String, String>("func_78111_c", "renderCloak"));
            mInitMap.put(new Pair<String, String>("func_78164_a", "renderSign"));
            mInitMap.put(new Pair<String, String>("func_78214_a", "updateRotations"));
            mInitMap.put(new Pair<String, String>("func_78231_a", "renderAll"));
            mInitMap.put(new Pair<String, String>("func_78235_a", "flipFace"));
            mInitMap.put(new Pair<String, String>("func_78236_a", "draw"));
            mInitMap.put(new Pair<String, String>("func_78240_a", "setTexturePosition"));
            mInitMap.put(new Pair<String, String>("func_78245_a", "render"));
            mInitMap.put(new Pair<String, String>("func_78255_a", "renderStringAtPos"));
            mInitMap.put(new Pair<String, String>("func_78256_a", "getStringWidth"));
            mInitMap.put(new Pair<String, String>("func_78257_a", "loadGlyphTexture"));
            mInitMap.put(new Pair<String, String>("func_78258_a", "renderString"));
            mInitMap.put(new Pair<String, String>("func_78259_e", "sizeStringToWidth"));
            mInitMap.put(new Pair<String, String>("func_78260_a", "getBidiFlag"));
            mInitMap.put(new Pair<String, String>("func_78261_a", "drawStringWithShadow"));
            mInitMap.put(new Pair<String, String>("func_78262_a", "trimStringToWidth"));
            mInitMap.put(new Pair<String, String>("func_78263_a", "getCharWidth"));
            mInitMap.put(new Pair<String, String>("func_78264_a", "setUnicodeFlag"));
            mInitMap.put(new Pair<String, String>("func_78265_b", "resetStyles"));
            mInitMap.put(new Pair<String, String>("func_78266_a", "renderDefaultChar"));
            mInitMap.put(new Pair<String, String>("func_78267_b", "splitStringWidth"));
            mInitMap.put(new Pair<String, String>("func_78268_b", "renderSplitString"));
            mInitMap.put(new Pair<String, String>("func_78269_a", "trimStringToWidth"));
            mInitMap.put(new Pair<String, String>("func_78270_c", "isFormatSpecial"));
            mInitMap.put(new Pair<String, String>("func_78271_c", "listFormattedStringToWidth"));
            mInitMap.put(new Pair<String, String>("func_78272_b", "isFormatColor"));
            mInitMap.put(new Pair<String, String>("func_78273_d", "trimStringmInitMap.put(newline"));
            mInitMap.put(new Pair<String, String>("func_78274_b", "renderStringAligned"));
            mInitMap.put(new Pair<String, String>("func_78275_b", "setBidiFlag"));
            mInitMap.put(new Pair<String, String>("func_78276_b", "drawString"));
            mInitMap.put(new Pair<String, String>("func_78277_a", "renderUnicodeChar"));
            mInitMap.put(new Pair<String, String>("func_78278_a", "renderCharAtPos"));
            mInitMap.put(new Pair<String, String>("func_78279_b", "drawSplitString"));
            mInitMap.put(new Pair<String, String>("func_78280_d", "wrapFormattedStringToWidth"));
            mInitMap.put(new Pair<String, String>("func_78282_e", "getFormatFromString"));
            mInitMap.put(new Pair<String, String>("func_78324_d", "getScaledHeight_double"));
            mInitMap.put(new Pair<String, String>("func_78325_e", "getScaleFactor"));
            mInitMap.put(new Pair<String, String>("func_78326_a", "getScaledWidth"));
            mInitMap.put(new Pair<String, String>("func_78327_c", "getScaledWidth_double"));
            mInitMap.put(new Pair<String, String>("func_78328_b", "getScaledHeight"));
            mInitMap.put(new Pair<String, String>("func_78369_a", "setColorRGBA_F"));
            mInitMap.put(new Pair<String, String>("func_78370_a", "setColorRGBA"));
            mInitMap.put(new Pair<String, String>("func_78371_b", "startDrawing"));
            mInitMap.put(new Pair<String, String>("func_78372_c", "addTranslation"));
            mInitMap.put(new Pair<String, String>("func_78373_b", "setTranslation"));
            mInitMap.put(new Pair<String, String>("func_78374_a", "addVertexWithUV"));
            mInitMap.put(new Pair<String, String>("func_78375_b", "setNormal"));
            mInitMap.put(new Pair<String, String>("func_78376_a", "setColorOpaque"));
            mInitMap.put(new Pair<String, String>("func_78377_a", "addVertex"));
            mInitMap.put(new Pair<String, String>("func_78378_d", "setColorOpaque_I"));
            mInitMap.put(new Pair<String, String>("func_78379_d", "reset"));
            mInitMap.put(new Pair<String, String>("func_78380_c", "setBrightness"));
            mInitMap.put(new Pair<String, String>("func_78381_a", "draw"));
            mInitMap.put(new Pair<String, String>("func_78382_b", "startDrawingQuads"));
            mInitMap.put(new Pair<String, String>("func_78383_c", "disableColor"));
            mInitMap.put(new Pair<String, String>("func_78384_a", "setColorRGBA_I"));
            mInitMap.put(new Pair<String, String>("func_78385_a", "setTextureUV"));
            mInitMap.put(new Pair<String, String>("func_78386_a", "setColorOpaque_F"));
            mInitMap.put(new Pair<String, String>("func_78418_a", "rendersChunk"));
            mInitMap.put(new Pair<String, String>("func_78419_a", "callLists"));
            mInitMap.put(new Pair<String, String>("func_78420_a", "addGLRenderList"));
            mInitMap.put(new Pair<String, String>("func_78421_b", "resetList"));
            mInitMap.put(new Pair<String, String>("func_78422_a", "setupRenderList"));
            mInitMap.put(new Pair<String, String>("func_78432_a", "parseUserSkin"));
            mInitMap.put(new Pair<String, String>("func_78433_b", "setAreaOpaque"));
            mInitMap.put(new Pair<String, String>("func_78434_a", "setAreaTransparent"));
            mInitMap.put(new Pair<String, String>("func_78435_c", "hasTransparency"));
            mInitMap.put(new Pair<String, String>("func_78439_a", "renderItemIn2D"));
            mInitMap.put(new Pair<String, String>("func_78440_a", "renderItemInFirstPerson"));
            mInitMap.put(new Pair<String, String>("func_78441_a", "updateEquippedItem"));
            mInitMap.put(new Pair<String, String>("func_78442_d", "renderFireInFirstPerson"));
            mInitMap.put(new Pair<String, String>("func_78443_a", "renderItem"));
            mInitMap.put(new Pair<String, String>("func_78444_b", "resetEquippedProgress"));
            mInitMap.put(new Pair<String, String>("func_78445_c", "resetEquippedProgress2"));
            mInitMap.put(new Pair<String, String>("func_78446_a", "renderInsideOfBlock"));
            mInitMap.put(new Pair<String, String>("func_78447_b", "renderOverlays"));
            mInitMap.put(new Pair<String, String>("func_78448_c", "renderWaterOverlayTexture"));
            mInitMap.put(new Pair<String, String>("func_78463_b", "enableLightmap"));
            mInitMap.put(new Pair<String, String>("func_78464_a", "updateRenderer"));
            mInitMap.put(new Pair<String, String>("func_78466_h", "updateFogColor"));
            mInitMap.put(new Pair<String, String>("func_78467_g", "orientCamera"));
            mInitMap.put(new Pair<String, String>("func_78468_a", "setupFog"));
            mInitMap.put(new Pair<String, String>("func_78469_a", "setFogColorBuffer"));
            mInitMap.put(new Pair<String, String>("func_78470_f", "updateTorchFlicker"));
            mInitMap.put(new Pair<String, String>("func_78471_a", "renderWorld"));
            mInitMap.put(new Pair<String, String>("func_78472_g", "updateLightmap"));
            mInitMap.put(new Pair<String, String>("func_78473_a", "getMouseOver"));
            mInitMap.put(new Pair<String, String>("func_78474_d", "renderRainSnow"));
            mInitMap.put(new Pair<String, String>("func_78475_f", "setupViewBobbing"));
            mInitMap.put(new Pair<String, String>("func_78476_b", "renderHand"));
            mInitMap.put(new Pair<String, String>("func_78477_e", "updateFovModifierHand"));
            mInitMap.put(new Pair<String, String>("func_78478_c", "setupOverlayRendering"));
            mInitMap.put(new Pair<String, String>("func_78479_a", "setupCameraTransform"));
            mInitMap.put(new Pair<String, String>("func_78480_b", "updateCameraAndRender"));
            mInitMap.put(new Pair<String, String>("func_78481_a", "getFOVModifier"));
            mInitMap.put(new Pair<String, String>("func_78482_e", "hurtCameraEffect"));
            mInitMap.put(new Pair<String, String>("func_78483_a", "disableLightmap"));
            mInitMap.put(new Pair<String, String>("func_78484_h", "addRainParticles"));
            mInitMap.put(new Pair<String, String>("func_78546_a", "isBoundingBoxInFrustum"));
            mInitMap.put(new Pair<String, String>("func_78547_a", "setPosition"));
            mInitMap.put(new Pair<String, String>("func_78548_b", "isBoxInFrustum"));
            mInitMap.put(new Pair<String, String>("func_78553_b", "isBoxInFrustum"));
            mInitMap.put(new Pair<String, String>("func_78558_a", "getInstance"));
            mInitMap.put(new Pair<String, String>("func_78559_a", "normalize"));
            mInitMap.put(new Pair<String, String>("func_78560_b", "init"));
            mInitMap.put(new Pair<String, String>("func_78713_a", "getEntityRenderObject"));
            mInitMap.put(new Pair<String, String>("func_78714_a", "getDistanceToCamera"));
            mInitMap.put(new Pair<String, String>("func_78715_a", "getEntityClassRenderObject"));
            mInitMap.put(new Pair<String, String>("func_78716_a", "getFontRenderer"));
            mInitMap.put(new Pair<String, String>("func_78717_a", "set"));
            mInitMap.put(new Pair<String, String>("func_78738_b", "createNextComponentRandom"));
            mInitMap.put(new Pair<String, String>("func_78743_b", "clickBlock"));
            mInitMap.put(new Pair<String, String>("func_78744_a", "clickBlockCreative"));
            mInitMap.put(new Pair<String, String>("func_78745_b", "flipPlayer"));
            mInitMap.put(new Pair<String, String>("func_78746_a", "setGameType"));
            mInitMap.put(new Pair<String, String>("func_78747_a", "enableEverythingIsScrewedUpMode"));
            mInitMap.put(new Pair<String, String>("func_78748_a", "setPlayerCapabilities"));
            mInitMap.put(new Pair<String, String>("func_78749_i", "extendedReach"));
            mInitMap.put(new Pair<String, String>("func_78750_j", "syncCurrentPlayItem"));
            mInitMap.put(new Pair<String, String>("func_78751_a", "onPlayerDestroyBlock"));
            mInitMap.put(new Pair<String, String>("func_78752_a", "sendPacketDropItem"));
            mInitMap.put(new Pair<String, String>("func_78753_a", "windowClick"));
            mInitMap.put(new Pair<String, String>("func_78755_b", "shouldDrawHUD"));
            mInitMap.put(new Pair<String, String>("func_78756_a", "sendEnchantPacket"));
            mInitMap.put(new Pair<String, String>("func_78757_d", "getBlockReachDistance"));
            mInitMap.put(new Pair<String, String>("func_78758_h", "isInCreativeMode"));
            mInitMap.put(new Pair<String, String>("func_78759_c", "onPlayerDamageBlock"));
            mInitMap.put(new Pair<String, String>("func_78760_a", "onPlayerRightClick"));
            mInitMap.put(new Pair<String, String>("func_78761_a", "sendSlotPacket"));
            mInitMap.put(new Pair<String, String>("func_78762_g", "isNotCreative"));
            mInitMap.put(new Pair<String, String>("func_78763_f", "gameIsSurvivalOrAdventure"));
            mInitMap.put(new Pair<String, String>("func_78764_a", "attackEntity"));
            mInitMap.put(new Pair<String, String>("func_78765_e", "updateController"));
            mInitMap.put(new Pair<String, String>("func_78766_c", "onStoppedUsingItem"));
            mInitMap.put(new Pair<String, String>("func_78767_c", "resetBlockRemoving"));
            mInitMap.put(new Pair<String, String>("func_78768_b", "interactWithEntitySendPacket"));
            mInitMap.put(new Pair<String, String>("func_78769_a", "sendUseItem"));
            mInitMap.put(new Pair<String, String>("func_78784_a", "setTextureOffset"));
            mInitMap.put(new Pair<String, String>("func_78785_a", "render"));
            mInitMap.put(new Pair<String, String>("func_78786_a", "addBox"));
            mInitMap.put(new Pair<String, String>("func_78787_b", "setTextureSize"));
            mInitMap.put(new Pair<String, String>("func_78788_d", "compileDisplayList"));
            mInitMap.put(new Pair<String, String>("func_78789_a", "addBox"));
            mInitMap.put(new Pair<String, String>("func_78790_a", "addBox"));
            mInitMap.put(new Pair<String, String>("func_78791_b", "renderWithRotation"));
            mInitMap.put(new Pair<String, String>("func_78792_a", "addChild"));
            mInitMap.put(new Pair<String, String>("func_78793_a", "setRotationPoint"));
            mInitMap.put(new Pair<String, String>("func_78794_c", "postRender"));
            mInitMap.put(new Pair<String, String>("func_78815_a", "getRandomComponent"));
            mInitMap.put(new Pair<String, String>("func_78817_b", "getNextMineShaftComponent"));
            mInitMap.put(new Pair<String, String>("func_78836_a", "getNBTCompound"));
            mInitMap.put(new Pair<String, String>("func_78837_a", "getServerDataFromNBTCompound"));
            mInitMap.put(new Pair<String, String>("func_78849_a", "addServerData"));
            mInitMap.put(new Pair<String, String>("func_78850_a", "getServerData"));
            mInitMap.put(new Pair<String, String>("func_78851_b", "removeServerData"));
            mInitMap.put(new Pair<String, String>("func_78853_a", "loadServerList"));
            mInitMap.put(new Pair<String, String>("func_78855_b", "saveServerList"));
            mInitMap.put(new Pair<String, String>("func_78856_c", "countServers"));
            mInitMap.put(new Pair<String, String>("func_78857_a", "swapServers"));
            mInitMap.put(new Pair<String, String>("func_78861_a", "getIP"));
            mInitMap.put(new Pair<String, String>("func_78862_a", "parseIntWithDefault"));
            mInitMap.put(new Pair<String, String>("func_78863_b", "getServerAddress"));
            mInitMap.put(new Pair<String, String>("func_78864_b", "getPort"));
            mInitMap.put(new Pair<String, String>("func_78867_a", "addBlockHitEffects"));
            mInitMap.put(new Pair<String, String>("func_78868_a", "updateEffects"));
            mInitMap.put(new Pair<String, String>("func_78869_b", "getStatistics"));
            mInitMap.put(new Pair<String, String>("func_78870_a", "clearEffects"));
            mInitMap.put(new Pair<String, String>("func_78872_b", "renderLitParticles"));
            mInitMap.put(new Pair<String, String>("func_78873_a", "addEffect"));
            mInitMap.put(new Pair<String, String>("func_78874_a", "renderParticles"));
            mInitMap.put(new Pair<String, String>("func_78879_f", "getCenterY"));
            mInitMap.put(new Pair<String, String>("func_78880_d", "getZSize"));
            mInitMap.put(new Pair<String, String>("func_78881_e", "getCenterX"));
            mInitMap.put(new Pair<String, String>("func_78882_c", "getYSize"));
            mInitMap.put(new Pair<String, String>("func_78883_b", "getXSize"));
            mInitMap.put(new Pair<String, String>("func_78884_a", "intersectsWith"));
            mInitMap.put(new Pair<String, String>("func_78885_a", "intersectsWith"));
            mInitMap.put(new Pair<String, String>("func_78886_a", "offset"));
            mInitMap.put(new Pair<String, String>("func_78887_a", "getmInitMap.put(newBoundingBox"));
            mInitMap.put(new Pair<String, String>("func_78888_b", "expandTo"));
            mInitMap.put(new Pair<String, String>("func_78889_a", "getComponentToAddBoundingBox"));
            mInitMap.put(new Pair<String, String>("func_78890_b", "isVecInside"));
            mInitMap.put(new Pair<String, String>("func_78891_g", "getCenterZ"));
            mInitMap.put(new Pair<String, String>("func_78898_a", "updatePlayerMoveState"));
            mInitMap.put(new Pair<String, String>("func_78904_d", "callOcclusionQueryList"));
            mInitMap.put(new Pair<String, String>("func_78905_g", "setupGLTranslation"));
            mInitMap.put(new Pair<String, String>("func_78906_e", "skipAllRenderPasses"));
            mInitMap.put(new Pair<String, String>("func_78908_a", "updateInFrustum"));
            mInitMap.put(new Pair<String, String>("func_78909_a", "getGLCallListForPass"));
            mInitMap.put(new Pair<String, String>("func_78910_b", "setDontDraw"));
            mInitMap.put(new Pair<String, String>("func_78911_c", "stopRendering"));
            mInitMap.put(new Pair<String, String>("func_78912_a", "distanceToEntitySquared"));
            mInitMap.put(new Pair<String, String>("func_78913_a", "setPosition"));
            mInitMap.put(new Pair<String, String>("func_78914_f", "markDirty"));
            mInitMap.put(new Pair<String, String>("func_80003_ah", "getPlayerUsageSnooper"));
            mInitMap.put(new Pair<String, String>("func_80006_f", "getUniqueID"));
            mInitMap.put(new Pair<String, String>("func_80007_l", "getDimensionName"));
            mInitMap.put(new Pair<String, String>("func_82114_b", "getCommandSenderPosition"));
            mInitMap.put(new Pair<String, String>("func_82141_a", "copyDataFrom"));
            mInitMap.put(new Pair<String, String>("func_82142_c", "setInvisible"));
            mInitMap.put(new Pair<String, String>("func_82143_as", "getMaxFallHeight"));
            mInitMap.put(new Pair<String, String>("func_82145_z", "getMaxInPortalTime"));
            mInitMap.put(new Pair<String, String>("func_82147_ab", "getPortalCooldown"));
            mInitMap.put(new Pair<String, String>("func_82148_at", "getTeleportDirection"));
            mInitMap.put(new Pair<String, String>("func_82149_j", "copyLocationAndAnglesFrom"));
            mInitMap.put(new Pair<String, String>("func_82150_aj", "isInvisible"));
            mInitMap.put(new Pair<String, String>("func_82159_b", "getArmorPosition"));
            mInitMap.put(new Pair<String, String>("func_82160_b", "dropEquipment"));
            mInitMap.put(new Pair<String, String>("func_82161_a", "getArmorItemForSlot"));
            mInitMap.put(new Pair<String, String>("func_82162_bC", "enchantEquipment"));
            mInitMap.put(new Pair<String, String>("func_82164_bB", "addRandomArmor"));
            mInitMap.put(new Pair<String, String>("func_82165_m", "isPotionActive"));
            mInitMap.put(new Pair<String, String>("func_82166_i", "getArmSwingAnimationEnd"));
            mInitMap.put(new Pair<String, String>("func_82167_n", "collideWithEntity"));
            mInitMap.put(new Pair<String, String>("func_82168_bl", "updateArmSwingProgress"));
            mInitMap.put(new Pair<String, String>("func_82169_q", "getCurrentArmor"));
            mInitMap.put(new Pair<String, String>("func_82170_o", "removePotionEffect"));
            mInitMap.put(new Pair<String, String>("func_82171_bF", "canBeSteered"));
            mInitMap.put(new Pair<String, String>("func_82183_n", "getAIControlledByPlayer"));
            mInitMap.put(new Pair<String, String>("func_82185_r", "setCollarColor"));
            mInitMap.put(new Pair<String, String>("func_82186_bH", "getCollarColor"));
            mInitMap.put(new Pair<String, String>("func_82187_q", "setLookingForHome"));
            mInitMap.put(new Pair<String, String>("func_82188_j", "adjustProbability"));
            mInitMap.put(new Pair<String, String>("func_82196_d", "attackEntityWithRangedAttack"));
            mInitMap.put(new Pair<String, String>("func_82197_f", "setAggressive"));
            mInitMap.put(new Pair<String, String>("func_82198_m", "getAggressive"));
            mInitMap.put(new Pair<String, String>("func_82201_a", "setSkeletonType"));
            mInitMap.put(new Pair<String, String>("func_82202_m", "getSkeletonType"));
            mInitMap.put(new Pair<String, String>("func_82203_t", "getWatchedTargetId"));
            mInitMap.put(new Pair<String, String>("func_82205_o", "isArmored"));
            mInitMap.put(new Pair<String, String>("func_82209_a", "launchWitherSkullToCoords"));
            mInitMap.put(new Pair<String, String>("func_82212_n", "getInvulTime"));
            mInitMap.put(new Pair<String, String>("func_82215_s", "setInvulTime"));
            mInitMap.put(new Pair<String, String>("func_82216_a", "launchWitherSkullToEntity"));
            mInitMap.put(new Pair<String, String>("func_82227_f", "setChild"));
            mInitMap.put(new Pair<String, String>("func_82228_a", "startConversion"));
            mInitMap.put(new Pair<String, String>("func_82229_g", "setVillager"));
            mInitMap.put(new Pair<String, String>("func_82230_o", "isConverting"));
            mInitMap.put(new Pair<String, String>("func_82231_m", "isVillager"));
            mInitMap.put(new Pair<String, String>("func_82232_p", "convertToVillager"));
            mInitMap.put(new Pair<String, String>("func_82233_q", "getConversionTimeBoost"));
            mInitMap.put(new Pair<String, String>("func_82235_h", "getIsBatHanging"));
            mInitMap.put(new Pair<String, String>("func_82236_f", "setIsBatHanging"));
            mInitMap.put(new Pair<String, String>("func_82238_cc", "getHideCape"));
            mInitMap.put(new Pair<String, String>("func_82239_b", "setHideCape"));
            mInitMap.put(new Pair<String, String>("func_82241_s", "getHideCape"));
            mInitMap.put(new Pair<String, String>("func_82242_a", "addExperienceLevel"));
            mInitMap.put(new Pair<String, String>("func_82243_bO", "getArmorVisibility"));
            mInitMap.put(new Pair<String, String>("func_82244_d", "displayGUIAnvil"));
            mInitMap.put(new Pair<String, String>("func_82245_bX", "isSpawnForced"));
            mInitMap.put(new Pair<String, String>("func_82246_f", "isCurrentToolAdventureModeExempt"));
            mInitMap.put(new Pair<String, String>("func_82247_a", "canPlayerEdit"));
            mInitMap.put(new Pair<String, String>("func_82328_a", "setDirection"));
            mInitMap.put(new Pair<String, String>("func_82329_d", "getWidthPixels"));
            mInitMap.put(new Pair<String, String>("func_82330_g", "getHeightPixels"));
            mInitMap.put(new Pair<String, String>("func_82333_j", "getRotation"));
            mInitMap.put(new Pair<String, String>("func_82334_a", "setDisplayedItem"));
            mInitMap.put(new Pair<String, String>("func_82335_i", "getDisplayedItem"));
            mInitMap.put(new Pair<String, String>("func_82336_g", "setItemRotation"));
            mInitMap.put(new Pair<String, String>("func_82338_g", "setAlphaF"));
            mInitMap.put(new Pair<String, String>("func_82340_a", "setPotionDamage"));
            mInitMap.put(new Pair<String, String>("func_82341_c", "getMotionFactor"));
            mInitMap.put(new Pair<String, String>("func_82342_d", "isInvulnerable"));
            mInitMap.put(new Pair<String, String>("func_82343_e", "setInvulnerable"));
            mInitMap.put(new Pair<String, String>("func_82356_Z", "isCommandBlockEnabled"));
            mInitMap.put(new Pair<String, String>("func_82357_ak", "getSpawnProtectionSize"));
            mInitMap.put(new Pair<String, String>("func_82358_a", "isUsernameIndex"));
            mInitMap.put(new Pair<String, String>("func_82359_c", "getPlayer"));
            mInitMap.put(new Pair<String, String>("func_82360_a", "getStringFromNthArg"));
            mInitMap.put(new Pair<String, String>("func_82362_a", "getRequiredPermissionLevel"));
            mInitMap.put(new Pair<String, String>("func_82363_b", "parseDouble"));
            mInitMap.put(new Pair<String, String>("func_82366_d", "getGameRules"));
            mInitMap.put(new Pair<String, String>("func_82370_a", "getUsernameIndex"));
            mInitMap.put(new Pair<String, String>("func_82371_e", "getDistanceSquaredToChunkCoordinates"));
            mInitMap.put(new Pair<String, String>("func_82372_a", "getMovementDirection"));
            mInitMap.put(new Pair<String, String>("func_82375_f", "getDefaultMinimumLevel"));
            mInitMap.put(new Pair<String, String>("func_82376_e", "getDefaultMaximumLevel"));
            mInitMap.put(new Pair<String, String>("func_82377_a", "matchesMultiplePlayers"));
            mInitMap.put(new Pair<String, String>("func_82378_b", "hasArguments"));
            mInitMap.put(new Pair<String, String>("func_82379_d", "getDefaultMaximumRange"));
            mInitMap.put(new Pair<String, String>("func_82380_c", "matchPlayers"));
            mInitMap.put(new Pair<String, String>("func_82381_h", "getArgumentMap"));
            mInitMap.put(new Pair<String, String>("func_82382_g", "getDefaultCount"));
            mInitMap.put(new Pair<String, String>("func_82383_a", "hasTheseArguments"));
            mInitMap.put(new Pair<String, String>("func_82384_c", "getDefaultMinimumRange"));
            mInitMap.put(new Pair<String, String>("func_82386_a", "matchOnePlayer"));
            mInitMap.put(new Pair<String, String>("func_82403_a", "renderFrameItemAsBlock"));
            mInitMap.put(new Pair<String, String>("func_82406_b", "renderItemAndEffectIntoGUI"));
            mInitMap.put(new Pair<String, String>("func_82441_a", "renderFirstPersonArm"));
            mInitMap.put(new Pair<String, String>("func_82448_a", "transferEntityToWorld"));
            mInitMap.put(new Pair<String, String>("func_82449_a", "findPlayers"));
            mInitMap.put(new Pair<String, String>("func_82482_a", "dispense"));
            mInitMap.put(new Pair<String, String>("func_82485_a", "playDispenseSound"));
            mInitMap.put(new Pair<String, String>("func_82486_a", "doDispense"));
            mInitMap.put(new Pair<String, String>("func_82487_b", "dispenseStack"));
            mInitMap.put(new Pair<String, String>("func_82489_a", "spawnDispenseParticles"));
            mInitMap.put(new Pair<String, String>("func_82499_a", "getProjectileEntity"));
            mInitMap.put(new Pair<String, String>("func_82565_a", "canEntityStandAt"));
            mInitMap.put(new Pair<String, String>("func_82571_y", "getGeneratorOptions"));
            mInitMap.put(new Pair<String, String>("func_82572_b", "incrementTotalWorldTime"));
            mInitMap.put(new Pair<String, String>("func_82573_f", "getWorldTotalTime"));
            mInitMap.put(new Pair<String, String>("func_82574_x", "getGameRulesInstance"));
            mInitMap.put(new Pair<String, String>("func_82580_o", "removeTag"));
            mInitMap.put(new Pair<String, String>("func_82581_a", "createCrashReport"));
            mInitMap.put(new Pair<String, String>("func_82582_d", "hasNoTags"));
            mInitMap.put(new Pair<String, String>("func_82594_a", "getObject"));
            mInitMap.put(new Pair<String, String>("func_82595_a", "putObject"));
            mInitMap.put(new Pair<String, String>("func_82599_e", "getFrontOffsetZ"));
            mInitMap.put(new Pair<String, String>("func_82600_a", "getFront"));
            mInitMap.put(new Pair<String, String>("func_82601_c", "getFrontOffsetX"));
            mInitMap.put(new Pair<String, String>("func_82615_a", "getX"));
            mInitMap.put(new Pair<String, String>("func_82616_c", "getZ"));
            mInitMap.put(new Pair<String, String>("func_82617_b", "getY"));
            mInitMap.put(new Pair<String, String>("func_82618_k", "getWorld"));
            mInitMap.put(new Pair<String, String>("func_82620_h", "getBlockMetadata"));
            mInitMap.put(new Pair<String, String>("func_82621_f", "getZInt"));
            mInitMap.put(new Pair<String, String>("func_82622_e", "getYInt"));
            mInitMap.put(new Pair<String, String>("func_82623_d", "getXInt"));
            mInitMap.put(new Pair<String, String>("func_82632_g", "boostSpeed"));
            mInitMap.put(new Pair<String, String>("func_82633_h", "isControlledByPlayer"));
            mInitMap.put(new Pair<String, String>("func_82634_f", "isSpeedBoosted"));
            mInitMap.put(new Pair<String, String>("func_82644_b", "getWorldFeatures"));
            mInitMap.put(new Pair<String, String>("func_82647_a", "setBiome"));
            mInitMap.put(new Pair<String, String>("func_82648_a", "getBiome"));
            mInitMap.put(new Pair<String, String>("func_82649_e", "getDefaultFlatGenerator"));
            mInitMap.put(new Pair<String, String>("func_82650_c", "getFlatLayers"));
            mInitMap.put(new Pair<String, String>("func_82651_a", "createFlatGeneratorFromString"));
            mInitMap.put(new Pair<String, String>("func_82656_d", "getMinY"));
            mInitMap.put(new Pair<String, String>("func_82657_a", "getLayerCount"));
            mInitMap.put(new Pair<String, String>("func_82658_c", "getFillBlockMeta"));
            mInitMap.put(new Pair<String, String>("func_82660_d", "setMinY"));
            mInitMap.put(new Pair<String, String>("func_82667_a", "getScatteredFeatureSpawnList"));
            mInitMap.put(new Pair<String, String>("func_82683_b", "setDefaultPlayerReputation"));
            mInitMap.put(new Pair<String, String>("func_82684_a", "getReputationForPlayer"));
            mInitMap.put(new Pair<String, String>("func_82686_i", "isMatingSeason"));
            mInitMap.put(new Pair<String, String>("func_82687_d", "isPlayerReputationTooLow"));
            mInitMap.put(new Pair<String, String>("func_82688_a", "setReputationForPlayer"));
            mInitMap.put(new Pair<String, String>("func_82689_b", "writeVillageDataToNBT"));
            mInitMap.put(new Pair<String, String>("func_82690_a", "readVillageDataFromNBT"));
            mInitMap.put(new Pair<String, String>("func_82692_h", "endMatingSeason"));
            mInitMap.put(new Pair<String, String>("func_82695_e", "recreateStructures"));
            mInitMap.put(new Pair<String, String>("func_82704_a", "isEntityApplicable"));
            mInitMap.put(new Pair<String, String>("func_82705_e", "getAnimal"));
            mInitMap.put(new Pair<String, String>("func_82708_h", "setObjectWatched"));
            mInitMap.put(new Pair<String, String>("func_82709_a", "addObjectByDataType"));
            mInitMap.put(new Pair<String, String>("func_82710_f", "getWatchableObjectItemStack"));
            mInitMap.put(new Pair<String, String>("func_82712_a", "parseDoubleWithDefault"));
            mInitMap.put(new Pair<String, String>("func_82713_a", "parseDoubleWithDefaultAndMax"));
            mInitMap.put(new Pair<String, String>("func_82714_a", "parseIntWithDefaultAndMax"));
            mInitMap.put(new Pair<String, String>("func_82715_a", "parseIntWithDefault"));
            mInitMap.put(new Pair<String, String>("func_82716_a", "getRandomDoubleInRange"));
            mInitMap.put(new Pair<String, String>("func_82719_a", "writeCustomPotionEffectToNBT"));
            mInitMap.put(new Pair<String, String>("func_82720_e", "getIsAmbient"));
            mInitMap.put(new Pair<String, String>("func_82721_a", "setSplashPotion"));
            mInitMap.put(new Pair<String, String>("func_82722_b", "readCustomPotionEffectFromNBT"));
            mInitMap.put(new Pair<String, String>("func_82725_o", "isMagicDamage"));
            mInitMap.put(new Pair<String, String>("func_82726_p", "setMagicDamage"));
            mInitMap.put(new Pair<String, String>("func_82733_a", "selectEntitiesWithinAABB"));
            mInitMap.put(new Pair<String, String>("func_82734_g", "getChunkHeightMapMinimum"));
            mInitMap.put(new Pair<String, String>("func_82736_K", "getGameRules"));
            mInitMap.put(new Pair<String, String>("func_82737_E", "getTotalWorldTime"));
            mInitMap.put(new Pair<String, String>("func_82739_e", "playBroadcastSound"));
            mInitMap.put(new Pair<String, String>("func_82742_i", "resetUpdateEntityTick"));
            mInitMap.put(new Pair<String, String>("func_82743_f", "getCreationCloudUpdateTick"));
            mInitMap.put(new Pair<String, String>("func_82744_b", "setCloudUpdateTick"));
            mInitMap.put(new Pair<String, String>("func_82746_a", "broadcastSound"));
            mInitMap.put(new Pair<String, String>("func_82747_f", "getWorldTypeID"));
            mInitMap.put(new Pair<String, String>("func_82750_a", "setWorldName"));
            mInitMap.put(new Pair<String, String>("func_82752_c", "isAdventure"));
            mInitMap.put(new Pair<String, String>("func_82753_a", "setPriority"));
            mInitMap.put(new Pair<String, String>("func_82756_a", "getGameRuleStringValue"));
            mInitMap.put(new Pair<String, String>("func_82757_a", "setValue"));
            mInitMap.put(new Pair<String, String>("func_82758_b", "getGameRuleBooleanValue"));
            mInitMap.put(new Pair<String, String>("func_82763_b", "getRules"));
            mInitMap.put(new Pair<String, String>("func_82764_b", "setOrCreateGameRule"));
            mInitMap.put(new Pair<String, String>("func_82765_e", "hasRule"));
            mInitMap.put(new Pair<String, String>("func_82766_b", "getGameRuleBooleanValue"));
            mInitMap.put(new Pair<String, String>("func_82767_a", "getGameRuleStringValue"));
            mInitMap.put(new Pair<String, String>("func_82768_a", "readGameRulesFromNBT"));
            mInitMap.put(new Pair<String, String>("func_82769_a", "addGameRule"));
            mInitMap.put(new Pair<String, String>("func_82770_a", "writeGameRulesToNBT"));
            mInitMap.put(new Pair<String, String>("func_82781_a", "getEnchantments"));
            mInitMap.put(new Pair<String, String>("func_82782_a", "setEnchantments"));
            mInitMap.put(new Pair<String, String>("func_82784_g", "isRecipeDisabled"));
            mInitMap.put(new Pair<String, String>("func_82787_a", "findMatchingRecipe"));
            mInitMap.put(new Pair<String, String>("func_82788_x", "canItemEditBlocks"));
            mInitMap.put(new Pair<String, String>("func_82789_a", "getIsRepairable"));
            mInitMap.put(new Pair<String, String>("func_82790_a", "getColorFromItemStack"));
            mInitMap.put(new Pair<String, String>("func_82810_a", "createHangingEntity"));
            mInitMap.put(new Pair<String, String>("func_82812_d", "getArmorMaterial"));
            mInitMap.put(new Pair<String, String>("func_82814_b", "getColor"));
            mInitMap.put(new Pair<String, String>("func_82815_c", "removeColor"));
            mInitMap.put(new Pair<String, String>("func_82816_b_", "hasColor"));
            mInitMap.put(new Pair<String, String>("func_82824_a", "setBossStatus"));
            mInitMap.put(new Pair<String, String>("func_82829_a", "renderCloudsCheck"));
            mInitMap.put(new Pair<String, String>("func_82830_a", "getNightVisionBrightness"));
            mInitMap.put(new Pair<String, String>("func_82833_r", "getDisplayName"));
            mInitMap.put(new Pair<String, String>("func_82835_x", "canEditBlocks"));
            mInitMap.put(new Pair<String, String>("func_82836_z", "getItemFrame"));
            mInitMap.put(new Pair<String, String>("func_82837_s", "hasDisplayName"));
            mInitMap.put(new Pair<String, String>("func_82838_A", "getRepairCost"));
            mInitMap.put(new Pair<String, String>("func_82839_y", "isOnItemFrame"));
            mInitMap.put(new Pair<String, String>("func_82840_a", "getTooltip"));
            mInitMap.put(new Pair<String, String>("func_82841_c", "setRepairCost"));
            mInitMap.put(new Pair<String, String>("func_82842_a", "setItemFrame"));
            mInitMap.put(new Pair<String, String>("func_82846_b", "transferStackInSlot"));
            mInitMap.put(new Pair<String, String>("func_82847_b", "removeCraftingFromCrafters"));
            mInitMap.put(new Pair<String, String>("func_82848_d", "updateRepairOutput"));
            mInitMap.put(new Pair<String, String>("func_82850_a", "updateItemName"));
            mInitMap.put(new Pair<String, String>("func_82869_a", "canTakeStack"));
            mInitMap.put(new Pair<String, String>("func_82870_a", "onPickupFromSlot"));
            mInitMap.put(new Pair<String, String>("func_82877_b", "setPlayerWalkSpeed"));
            mInitMap.put(new Pair<String, String>("func_82879_c", "sendSettingsToServer"));
            mInitMap.put(new Pair<String, String>("func_82883_a", "getUnicodeFlag"));
            mInitMap.put(new Pair<String, String>("func_82889_a", "getBatSize"));
            mInitMap.put(new Pair<String, String>("func_83015_S", "getCurrentDate"));
            mInitMap.put(new Pair<String, String>("func_85029_a", "addEntityCrashInfo"));
            mInitMap.put(new Pair<String, String>("func_85030_a", "playSound"));
            mInitMap.put(new Pair<String, String>("func_85031_j", "hitByEntity"));
            mInitMap.put(new Pair<String, String>("func_85032_ar", "isEntityInvulnerable"));
            mInitMap.put(new Pair<String, String>("func_85033_bc", "collideWithNearbyEntities"));
            mInitMap.put(new Pair<String, String>("func_85034_r", "setArrowCountInEntity"));
            mInitMap.put(new Pair<String, String>("func_85035_bI", "getArrowCountInEntity"));
            mInitMap.put(new Pair<String, String>("func_85036_m", "setCombatTask"));
            mInitMap.put(new Pair<String, String>("func_85039_t", "addScore"));
            mInitMap.put(new Pair<String, String>("func_85040_s", "setScore"));
            mInitMap.put(new Pair<String, String>("func_85052_h", "getThrower"));
            mInitMap.put(new Pair<String, String>("func_85054_d", "searchForOtherItemsNearby"));
            mInitMap.put(new Pair<String, String>("func_85055_a", "makeCrashReport"));
            mInitMap.put(new Pair<String, String>("func_85056_g", "getCategory"));
            mInitMap.put(new Pair<String, String>("func_85057_a", "makeCategoryDepth"));
            mInitMap.put(new Pair<String, String>("func_85058_a", "makeCategory"));
            mInitMap.put(new Pair<String, String>("func_85069_a", "firstTwoElementsOfStackTraceMatch"));
            mInitMap.put(new Pair<String, String>("func_85070_b", "trimStackTraceEntriesFromBottom"));
            mInitMap.put(new Pair<String, String>("func_85071_a", "getLocationInfo"));
            mInitMap.put(new Pair<String, String>("func_85072_a", "appendToStringBuilder"));
            mInitMap.put(new Pair<String, String>("func_85073_a", "getPrunedStackTrace"));
            mInitMap.put(new Pair<String, String>("func_85093_e", "renderArrowsStuckInEntity"));
            mInitMap.put(new Pair<String, String>("func_85094_b", "renderDebugBoundingBox"));
            mInitMap.put(new Pair<String, String>("func_85102_a", "playSoundToNearExcept"));
            mInitMap.put(new Pair<String, String>("func_85118_a", "addToCrashReport"));
            mInitMap.put(new Pair<String, String>("func_85144_b", "getCacheSizes"));
            mInitMap.put(new Pair<String, String>("func_85151_d", "getLowerChestInventory"));
            mInitMap.put(new Pair<String, String>("func_85156_a", "removeTask"));
            mInitMap.put(new Pair<String, String>("func_85157_q", "isAdventureModeExempt"));
            mInitMap.put(new Pair<String, String>("func_85158_p", "setAdventureModeExempt"));
            mInitMap.put(new Pair<String, String>("func_85173_a", "playSoundToNearExcept"));
            mInitMap.put(new Pair<String, String>("func_85176_s", "getDefaultTeleporter"));
            mInitMap.put(new Pair<String, String>("func_85181_a", "getRandomModelBox"));
            mInitMap.put(new Pair<String, String>("func_85182_a", "sameToolAndBlock"));
            mInitMap.put(new Pair<String, String>("func_85187_a", "drawString"));
            mInitMap.put(new Pair<String, String>("func_85188_a", "makePortal"));
            mInitMap.put(new Pair<String, String>("func_85189_a", "removeStalePortalLocations"));
            mInitMap.put(new Pair<String, String>("func_90010_a", "isPartOfLargeChest"));
            mInitMap.put(new Pair<String, String>("func_90011_a", "createChild"));
            mInitMap.put(new Pair<String, String>("func_90013_b", "getDyeFromFleeceColor"));
            mInitMap.put(new Pair<String, String>("func_90014_a", "getDyeBasedOnParents"));
            mInitMap.put(new Pair<String, String>("func_90019_g", "applyRenderColor"));
            mInitMap.put(new Pair<String, String>("func_90020_K", "getLimitFramerate"));
            mInitMap.put(new Pair<String, String>("func_90022_d", "getListOfPlayers"));
            mInitMap.put(new Pair<String, String>("func_90033_f", "canLoadWorld"));
            mInitMap.put(new Pair<String, String>("func_90035_a", "getClassFromID"));
            mInitMap.put(new Pair<String, String>("func_90036_a", "getFireAspectModifier"));
            mInitMap.put(new Pair<String, String>("func_90999_ad", "canRenderOnFire"));
            mInitMap.put(new Pair<String, String>("func_92015_f", "closeScreenNoPacket"));
            mInitMap.put(new Pair<String, String>("func_92034_a", "createParticle"));
            mInitMap.put(new Pair<String, String>("func_92035_a", "createBall"));
            mInitMap.put(new Pair<String, String>("func_92036_a", "createBurst"));
            mInitMap.put(new Pair<String, String>("func_92038_a", "createShaped"));
            mInitMap.put(new Pair<String, String>("func_92043_f", "setTwinkle"));
            mInitMap.put(new Pair<String, String>("func_92044_a", "setColour"));
            mInitMap.put(new Pair<String, String>("func_92045_e", "setTrail"));
            mInitMap.put(new Pair<String, String>("func_92046_g", "setFadeColour"));
            mInitMap.put(new Pair<String, String>("func_92058_a", "setEntityItemStack"));
            mInitMap.put(new Pair<String, String>("func_92059_d", "getEntityItem"));
            mInitMap.put(new Pair<String, String>("func_92085_d", "getIsBlank"));
            mInitMap.put(new Pair<String, String>("func_92087_a", "causeThornsDamage"));
            mInitMap.put(new Pair<String, String>("func_92088_a", "makeFireworks"));
            mInitMap.put(new Pair<String, String>("func_92089_a", "canApply"));
            mInitMap.put(new Pair<String, String>("func_92093_a", "getFireTimeForEntity"));
            mInitMap.put(new Pair<String, String>("func_92097_a", "negateDamage"));
            mInitMap.put(new Pair<String, String>("func_92103_a", "addRecipe"));
            mInitMap.put(new Pair<String, String>("func_92111_a", "getEnchantedItemStack"));
            mInitMap.put(new Pair<String, String>("func_92115_a", "addEnchantment"));
            mInitMap.put(new Pair<String, String>("func_92116_a", "addEnchantmentBooksToList"));
            mInitMap.put(new Pair<String, String>("func_94041_b", "isItemValidForSlot"));
            mInitMap.put(new Pair<String, String>("func_94053_h", "nextTextureIndexX"));
            mInitMap.put(new Pair<String, String>("func_94056_bM", "hasCustomNameTag"));
            mInitMap.put(new Pair<String, String>("func_94057_bL", "getCustomNameTag"));
            mInitMap.put(new Pair<String, String>("func_94058_c", "setCustomNameTag"));
            mInitMap.put(new Pair<String, String>("func_94059_bO", "getAlwaysRenderNameTagForRender"));
            mInitMap.put(new Pair<String, String>("func_94061_f", "setAlwaysRenderNameTag"));
            mInitMap.put(new Pair<String, String>("func_94062_bN", "getAlwaysRenderNameTag"));
            mInitMap.put(new Pair<String, String>("func_94065_a", "drawTexturedModelRectFromIcon"));
            mInitMap.put(new Pair<String, String>("func_94083_c", "getTntPlacedBy"));
            mInitMap.put(new Pair<String, String>("func_94085_r", "getDefaultDisplayTileOffset"));
            mInitMap.put(new Pair<String, String>("func_94086_l", "setDisplayTileOffset"));
            mInitMap.put(new Pair<String, String>("func_94087_l", "getMinecartType"));
            mInitMap.put(new Pair<String, String>("func_94090_a", "createMinecart"));
            mInitMap.put(new Pair<String, String>("func_94092_k", "setDisplayTileData"));
            mInitMap.put(new Pair<String, String>("func_94095_a", "killMinecart"));
            mInitMap.put(new Pair<String, String>("func_94096_e", "setHasDisplayTile"));
            mInitMap.put(new Pair<String, String>("func_94097_p", "getDefaultDisplayTileData"));
            mInitMap.put(new Pair<String, String>("func_94098_o", "getDisplayTileData"));
            mInitMap.put(new Pair<String, String>("func_94099_q", "getDisplayTileOffset"));
            mInitMap.put(new Pair<String, String>("func_94100_s", "hasDisplayTile"));
            mInitMap.put(new Pair<String, String>("func_94101_h", "applyDrag"));
            mInitMap.put(new Pair<String, String>("func_94103_c", "explodeCart"));
            mInitMap.put(new Pair<String, String>("func_94105_c", "ignite"));
            mInitMap.put(new Pair<String, String>("func_94107_f", "setMinecartPowered"));
            mInitMap.put(new Pair<String, String>("func_94108_c", "isMinecartPowered"));
            mInitMap.put(new Pair<String, String>("func_94128_d", "getSlotsForFace"));
            mInitMap.put(new Pair<String, String>("func_94140_a", "registerDestroyBlockIcons"));
            mInitMap.put(new Pair<String, String>("func_94143_a", "updateIcons"));
            mInitMap.put(new Pair<String, String>("func_94148_a", "renderItemOverlayIntoGUI"));
            mInitMap.put(new Pair<String, String>("func_94149_a", "renderIcon"));
            mInitMap.put(new Pair<String, String>("func_94178_a", "updateIcons"));
            mInitMap.put(new Pair<String, String>("func_94182_a", "addSlot"));
            mInitMap.put(new Pair<String, String>("func_94183_a", "getStitchHolder"));
            mInitMap.put(new Pair<String, String>("func_94184_a", "getAllStitchSlots"));
            mInitMap.put(new Pair<String, String>("func_94185_c", "getOriginY"));
            mInitMap.put(new Pair<String, String>("func_94186_b", "getOriginX"));
            mInitMap.put(new Pair<String, String>("func_94194_d", "rotate"));
            mInitMap.put(new Pair<String, String>("func_94195_e", "isRotated"));
            mInitMap.put(new Pair<String, String>("func_94196_a", "setmInitMap.put(newDimension"));
            mInitMap.put(new Pair<String, String>("func_94197_a", "getWidth"));
            mInitMap.put(new Pair<String, String>("func_94199_b", "getHeight"));
            mInitMap.put(new Pair<String, String>("func_94206_g", "getMinV"));
            mInitMap.put(new Pair<String, String>("func_94207_b", "getInterpolatedV"));
            mInitMap.put(new Pair<String, String>("func_94209_e", "getMinU"));
            mInitMap.put(new Pair<String, String>("func_94210_h", "getMaxV"));
            mInitMap.put(new Pair<String, String>("func_94211_a", "getIconWidth"));
            mInitMap.put(new Pair<String, String>("func_94212_f", "getMaxU"));
            mInitMap.put(new Pair<String, String>("func_94214_a", "getInterpolatedU"));
            mInitMap.put(new Pair<String, String>("func_94215_i", "getIconName"));
            mInitMap.put(new Pair<String, String>("func_94216_b", "getIconHeight"));
            mInitMap.put(new Pair<String, String>("func_94217_a", "copyFrom"));
            mInitMap.put(new Pair<String, String>("func_94219_l", "updateAnimation"));
            mInitMap.put(new Pair<String, String>("func_94241_a", "updateCompass"));
            mInitMap.put(new Pair<String, String>("func_94245_a", "registerIcon"));
            mInitMap.put(new Pair<String, String>("func_94248_c", "updateAnimations"));
            mInitMap.put(new Pair<String, String>("func_94277_a", "bindTexture"));
            mInitMap.put(new Pair<String, String>("func_94305_f", "doStitch"));
            mInitMap.put(new Pair<String, String>("func_94309_g", "getStichSlots"));
            mInitMap.put(new Pair<String, String>("func_94310_b", "allocateSlot"));
            mInitMap.put(new Pair<String, String>("func_94311_c", "expandAndAllocateSlot"));
            mInitMap.put(new Pair<String, String>("func_94520_b", "isKeyTranslated"));
            mInitMap.put(new Pair<String, String>("func_94522_b", "canTranslate"));
            mInitMap.put(new Pair<String, String>("func_94525_a", "computeStackSize"));
            mInitMap.put(new Pair<String, String>("func_94526_b", "calcRedstoneFromInventory"));
            mInitMap.put(new Pair<String, String>("func_94527_a", "canAddItemToSlot"));
            mInitMap.put(new Pair<String, String>("func_94528_d", "isValidDragMode"));
            mInitMap.put(new Pair<String, String>("func_94529_b", "extractDragMode"));
            mInitMap.put(new Pair<String, String>("func_94531_b", "canDragIntoSlot"));
            mInitMap.put(new Pair<String, String>("func_94532_c", "getDragEvent"));
            mInitMap.put(new Pair<String, String>("func_94533_d", "resetDrag"));
            mInitMap.put(new Pair<String, String>("func_94539_a", "setExplosionSource"));
            mInitMap.put(new Pair<String, String>("func_94540_d", "setExplosion"));
            mInitMap.put(new Pair<String, String>("func_94541_c", "isExplosion"));
            mInitMap.put(new Pair<String, String>("func_94560_a", "getDamageSrc"));
            mInitMap.put(new Pair<String, String>("func_94572_D", "getStrongestIndirectPower"));
            mInitMap.put(new Pair<String, String>("func_94574_k", "getIndirectPowerOutput"));
            mInitMap.put(new Pair<String, String>("func_94576_a", "getEntitiesWithinAABBExcludingEntity"));
            mInitMap.put(new Pair<String, String>("func_94577_B", "getBlockPowerInput"));
            mInitMap.put(new Pair<String, String>("func_94581_a", "registerIcons"));
            mInitMap.put(new Pair<String, String>("func_94599_c", "getItemIconForUseDuration"));
            mInitMap.put(new Pair<String, String>("func_94602_b", "getBackgroundIcon"));
            mInitMap.put(new Pair<String, String>("func_94608_d", "getItemSpriteNumber"));
            mInitMap.put(new Pair<String, String>("func_94613_c", "getExplosivePlacedBy"));
            mInitMap.put(new Pair<String, String>("func_94901_k", "getSpriteNumber"));
            mInitMap.put(new Pair<String, String>("func_96092_aw", "isPushedByWater"));
            mInitMap.put(new Pair<String, String>("func_96094_a", "setMinecartName"));
            mInitMap.put(new Pair<String, String>("func_96095_a", "onActivatorRailPass"));
            mInitMap.put(new Pair<String, String>("func_96096_ay", "isIgnited"));
            mInitMap.put(new Pair<String, String>("func_96107_aA", "getXPos"));
            mInitMap.put(new Pair<String, String>("func_96108_aC", "getZPos"));
            mInitMap.put(new Pair<String, String>("func_96109_aB", "getYPos"));
            mInitMap.put(new Pair<String, String>("func_96110_f", "setBlocked"));
            mInitMap.put(new Pair<String, String>("func_96111_ay", "getBlocked"));
            mInitMap.put(new Pair<String, String>("func_96120_a", "setEquipmentDropChance"));
            mInitMap.put(new Pair<String, String>("func_96122_a", "canAttackPlayer"));
            mInitMap.put(new Pair<String, String>("func_96123_co", "getWorldScoreboard"));
            mInitMap.put(new Pair<String, String>("func_96124_cp", "getTeam"));
            mInitMap.put(new Pair<String, String>("func_96125_a", "displayGUIHopperMinecart"));
            mInitMap.put(new Pair<String, String>("func_96136_a", "renderScoreboard"));
            mInitMap.put(new Pair<String, String>("func_96290_a", "isBlockProtected"));
            mInitMap.put(new Pair<String, String>("func_96296_a", "getValidValues"));
            mInitMap.put(new Pair<String, String>("func_96297_d", "getFriendlyName"));
            mInitMap.put(new Pair<String, String>("func_96298_a", "getFormattingCode"));
            mInitMap.put(new Pair<String, String>("func_96300_b", "getValueByName"));
            mInitMap.put(new Pair<String, String>("func_96301_b", "isFancyStyling"));
            mInitMap.put(new Pair<String, String>("func_96302_c", "isColor"));
            mInitMap.put(new Pair<String, String>("func_96332_d", "getPlayerName"));
            mInitMap.put(new Pair<String, String>("func_96333_a", "joinNiceStringFromCollection"));
            mInitMap.put(new Pair<String, String>("func_96441_U", "getScoreboard"));
            mInitMap.put(new Pair<String, String>("func_96443_a", "setWorldScoreboard"));
            mInitMap.put(new Pair<String, String>("func_96449_a", "renderOffsetLivingLabel"));
            mInitMap.put(new Pair<String, String>("func_96457_a", "matchesScoreboardCriteria"));
            mInitMap.put(new Pair<String, String>("func_96508_e", "getTeam"));
            mInitMap.put(new Pair<String, String>("func_96509_i", "getPlayersTeam"));
            mInitMap.put(new Pair<String, String>("func_96511_d", "removeTeam"));
            mInitMap.put(new Pair<String, String>("func_96512_b", "removePlayerFromTeam"));
            mInitMap.put(new Pair<String, String>("func_96514_c", "getScoreObjectives"));
            mInitMap.put(new Pair<String, String>("func_96517_b", "getObjectiveDisplaySlot"));
            mInitMap.put(new Pair<String, String>("func_96518_b", "getObjective"));
            mInitMap.put(new Pair<String, String>("func_96523_a", "broadcastTeamCreated"));
            mInitMap.put(new Pair<String, String>("func_96524_g", "removePlayerFromTeams"));
            mInitMap.put(new Pair<String, String>("func_96525_g", "getTeams"));
            mInitMap.put(new Pair<String, String>("func_96526_d", "getObjectiveNames"));
            mInitMap.put(new Pair<String, String>("func_96527_f", "createTeam"));
            mInitMap.put(new Pair<String, String>("func_96529_a", "getValueFromObjective"));
            mInitMap.put(new Pair<String, String>("func_96530_a", "setObjectiveInDisplaySlot"));
            mInitMap.put(new Pair<String, String>("func_96531_f", "getTeamNames"));
            mInitMap.put(new Pair<String, String>("func_96534_i", "getSortedScores"));
            mInitMap.put(new Pair<String, String>("func_96535_a", "addScoreObjective"));
            mInitMap.put(new Pair<String, String>("func_96537_j", "getObjectiveDisplaySlotNumber"));
            mInitMap.put(new Pair<String, String>("func_96538_b", "broadcastTeamRemoved"));
            mInitMap.put(new Pair<String, String>("func_96539_a", "getObjectiveInDisplaySlot"));
            mInitMap.put(new Pair<String, String>("func_96559_d", "getFrontOffsetY"));
            mInitMap.put(new Pair<String, String>("func_96631_a", "attemptDamageItem"));
            mInitMap.put(new Pair<String, String>("func_96636_a", "getName"));
            mInitMap.put(new Pair<String, String>("func_96637_b", "isReadOnly"));
            mInitMap.put(new Pair<String, String>("func_96646_b", "decreaseScore"));
            mInitMap.put(new Pair<String, String>("func_96647_c", "setScorePoints"));
            mInitMap.put(new Pair<String, String>("func_96649_a", "increseScore"));
            mInitMap.put(new Pair<String, String>("func_96650_f", "getScoreScoreboard"));
            mInitMap.put(new Pair<String, String>("func_96652_c", "getScorePoints"));
            mInitMap.put(new Pair<String, String>("func_96653_e", "getPlayerName"));
            mInitMap.put(new Pair<String, String>("func_96660_a", "setAllowFriendlyFire"));
            mInitMap.put(new Pair<String, String>("func_96661_b", "getRegisteredName"));
            mInitMap.put(new Pair<String, String>("func_96662_c", "setNameSuffix"));
            mInitMap.put(new Pair<String, String>("func_96663_f", "getColorSuffix"));
            mInitMap.put(new Pair<String, String>("func_96664_a", "setTeamName"));
            mInitMap.put(new Pair<String, String>("func_96665_g", "getAllowFriendlyFire"));
            mInitMap.put(new Pair<String, String>("func_96666_b", "setNamePrefix"));
            mInitMap.put(new Pair<String, String>("func_96667_a", "formatPlayerName"));
            mInitMap.put(new Pair<String, String>("func_96668_e", "getColorPrefix"));
            mInitMap.put(new Pair<String, String>("func_96670_d", "getMembershipCollection"));
            mInitMap.put(new Pair<String, String>("func_96678_d", "getDisplayName"));
            mInitMap.put(new Pair<String, String>("func_96679_b", "getName"));
            mInitMap.put(new Pair<String, String>("func_96680_c", "getCriteria"));
            mInitMap.put(new Pair<String, String>("func_96681_a", "setDisplayName"));
            mInitMap.put(new Pair<String, String>("func_96682_a", "getScoreboard"));
            mInitMap.put(new Pair<String, String>("func_98034_c", "isInvisibleToPlayer"));
            mInitMap.put(new Pair<String, String>("func_98035_c", "writeMountToNBT"));
            mInitMap.put(new Pair<String, String>("func_98042_n", "setTransferTicker"));
            mInitMap.put(new Pair<String, String>("func_98043_aE", "canTransfer"));
            mInitMap.put(new Pair<String, String>("func_98052_bS", "canPickUpLoot"));
            mInitMap.put(new Pair<String, String>("func_98053_h", "setCanPickUpLoot"));
            mInitMap.put(new Pair<String, String>("func_98054_a", "setScaleForAge"));
            mInitMap.put(new Pair<String, String>("func_98055_j", "setScale"));
            mInitMap.put(new Pair<String, String>("func_98150_a", "getAtlasSprite"));
            mInitMap.put(new Pair<String, String>("func_98152_d", "getAllUsernames"));
            mInitMap.put(new Pair<String, String>("func_98179_a", "computeLightValue"));
            mInitMap.put(new Pair<String, String>("func_98265_a", "spawnEntity"));
            mInitMap.put(new Pair<String, String>("func_98266_d", "getSpawnerZ"));
            mInitMap.put(new Pair<String, String>("func_98268_b", "setDelayToMin"));
            mInitMap.put(new Pair<String, String>("func_98269_i", "getRandomEntity"));
            mInitMap.put(new Pair<String, String>("func_98270_a", "readFromNBT"));
            mInitMap.put(new Pair<String, String>("func_98271_a", "getSpawnerWorld"));
            mInitMap.put(new Pair<String, String>("func_98272_a", "setEntityName"));
            mInitMap.put(new Pair<String, String>("func_98273_j", "resetTimer"));
            mInitMap.put(new Pair<String, String>("func_98274_c", "getSpawnerY"));
            mInitMap.put(new Pair<String, String>("func_98275_b", "getSpawnerX"));
            mInitMap.put(new Pair<String, String>("func_98276_e", "getEntityNameToSpawn"));
            mInitMap.put(new Pair<String, String>("func_98277_a", "setRandomEntity"));
            mInitMap.put(new Pair<String, String>("func_98278_g", "updateSpawner"));
            mInitMap.put(new Pair<String, String>("func_98279_f", "isActivated"));
            mInitMap.put(new Pair<String, String>("func_98280_b", "writeToNBT"));
            mInitMap.put(new Pair<String, String>("func_98281_h", "getEntityToRender"));
            mInitMap.put(new Pair<String, String>("func_98300_b", "setSeeFriendlyInvisiblesEnabled"));
            mInitMap.put(new Pair<String, String>("func_98306_d", "readGlyphSizes"));
            mInitMap.put(new Pair<String, String>("func_99999_d", "run"));
        }

        /*
         * Opcode count of 14658 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
         */
        public static void init4() {
            mObInitMap.put(new Pair<String, String>("aqc", "net/minecraft/world/chunk/storage/IChunkLoader"));
            mObInitMap.put(new Pair<String, String>("amd", "net/minecraft/block/BlockMycelium"));
            mObInitMap.put(new Pair<String, String>("aag", "net/minecraft/inventory/ContainerEnchantment"));
            mObInitMap.put(new Pair<String, String>("aie", "net/minecraft/world/biome/WorldChunkManagerHell"));
            mObInitMap.put(new Pair<String, String>("aub", "net/minecraft/world/gen/structure/ComponentScatteredFeaturePieces$DesertPyramid"));
            mObInitMap.put(new Pair<String, String>("bue", "net/minecraft/client/stream/ChatController"));
            mObInitMap.put(new Pair<String, String>("bqf", "net/minecraft/client/renderer/texture/TextureManager"));
            mObInitMap.put(new Pair<String, String>("bei", "net/minecraft/client/gui/achievement/GuiAchievements"));
            mObInitMap.put(new Pair<String, String>("bih", "net/minecraft/client/model/ModelSquid"));
            mObInitMap.put(new Pair<String, String>("bmg", "net/minecraft/client/shader/Framebuffer"));
            mObInitMap.put(new Pair<String, String>("na", "net/minecraft/client/network/NetHandlerHandshakeMemory"));
            mObInitMap.put(new Pair<String, String>("jb", "net/minecraft/network/play/client/C02PacketUseEntity$Action"));
            mObInitMap.put(new Pair<String, String>("fc", "net/minecraft/util/MessageDeserializer2"));
            mObInitMap.put(new Pair<String, String>("bd", "net/minecraft/command/server/CommandPardonIp"));
            mObInitMap.put(new Pair<String, String>("amw", "net/minecraft/block/BlockPumpkin"));
            mObInitMap.put(new Pair<String, String>("aey", "net/minecraft/item/crafting/RecipeFireworks"));
            mObInitMap.put(new Pair<String, String>("aaz", "net/minecraft/inventory/ContainerDispenser"));
            mObInitMap.put(new Pair<String, String>("aix", "net/minecraft/world/biome/BiomeGenEnd"));
            mObInitMap.put(new Pair<String, String>("z", "net/minecraft/command/CommandHandler"));
            mObInitMap.put(new Pair<String, String>("bqy", "net/minecraft/client/resources/IResourceManager"));
            mObInitMap.put(new Pair<String, String>("nt", "net/minecraft/server/management/PlayerProfileCache$1"));
            mObInitMap.put(new Pair<String, String>("ju", "net/minecraft/network/login/server/S00PacketDisconnect"));
            mObInitMap.put(new Pair<String, String>("fv", "net/minecraft/network/play/INetHandlerPlayClient"));
            mObInitMap.put(new Pair<String, String>("abn", "net/minecraft/item/ItemSoup"));
            mObInitMap.put(new Pair<String, String>("afm", "net/minecraft/enchantment/EnchantmentArrowDamage"));
            mObInitMap.put(new Pair<String, String>("brm", "net/minecraft/client/resources/SkinManager$3"));
            mObInitMap.put(new Pair<String, String>("aqu", "net/minecraft/world/gen/ChunkProviderFlat"));
            mObInitMap.put(new Pair<String, String>("aut", "net/minecraft/world/gen/structure/StructureStrongholdPieces$Prison"));
            mObInitMap.put(new Pair<String, String>("ays", "net/minecraft/world/storage/WorldInfo"));
            mObInitMap.put(new Pair<String, String>("bbq", "net/minecraft/util/MinecraftError"));
            mObInitMap.put(new Pair<String, String>("bfp", "net/minecraft/util/EnchantmentNameParts"));
            mObInitMap.put(new Pair<String, String>("bjo", "net/minecraft/client/multiplayer/ServerData$ServerResourceMode"));
            mObInitMap.put(new Pair<String, String>("bnn", "net/minecraft/client/renderer/entity/RenderManager"));
            mObInitMap.put(new Pair<String, String>("ck", "net/minecraft/dispenser/IBlockSource"));
            mObInitMap.put(new Pair<String, String>("zp", "net/minecraft/entity/projectile/EntityWitherSkull"));
            mObInitMap.put(new Pair<String, String>("vq", "net/minecraft/entity/ai/EntityAINearestAttackableTarget$Sorter"));
            mObInitMap.put(new Pair<String, String>("rr", "net/minecraft/potion/PotionAbsoption"));
            mObInitMap.put(new Pair<String, String>("ns", "net/minecraft/server/management/PlayerProfileCache"));
            mObInitMap.put(new Pair<String, String>("anj", "net/minecraft/block/BlockSapling"));
            mObInitMap.put(new Pair<String, String>("afl", "net/minecraft/item/crafting/RecipesWeapons"));
            mObInitMap.put(new Pair<String, String>("ajk", "net/minecraft/block/Block$2"));
            mObInitMap.put(new Pair<String, String>("avh", "net/minecraft/world/gen/structure/MapGenStructure$3"));
            mObInitMap.put(new Pair<String, String>("bce", "net/minecraft/client/gui/GuiLabel"));
            mObInitMap.put(new Pair<String, String>("bgd", "net/minecraft/client/gui/ServerListEntryNormal$1"));
            mObInitMap.put(new Pair<String, String>("brl", "net/minecraft/client/resources/SkinManager$2"));
            mObInitMap.put(new Pair<String, String>("we", "net/minecraft/entity/passive/EntityBat"));
            mObInitMap.put(new Pair<String, String>("og", "net/minecraft/server/management/PreYggdrasilConverter$7"));
            mObInitMap.put(new Pair<String, String>("kh", "net/minecraft/network/status/INetHandlerStatusServer"));
            mObInitMap.put(new Pair<String, String>("gi", "net/minecraft/network/play/server/S3APacketTabComplete"));
            mObInitMap.put(new Pair<String, String>("aca", "net/minecraft/creativetab/CreativeTabs$4"));
            mObInitMap.put(new Pair<String, String>("azz", "net/minecraft/scoreboard/Score"));
            mObInitMap.put(new Pair<String, String>("bgc", "net/minecraft/client/gui/ServerListEntryNormal"));
            mObInitMap.put(new Pair<String, String>("boa", "net/minecraft/client/renderer/entity/RenderItem$2"));
            mObInitMap.put(new Pair<String, String>("wx", "net/minecraft/entity/IEntityMultiPart"));
            mObInitMap.put(new Pair<String, String>("sy", "net/minecraft/entity/IEntityLivingData"));
            mObInitMap.put(new Pair<String, String>("oz", "net/minecraft/network/rcon/RConThreadClient"));
            mObInitMap.put(new Pair<String, String>("aoq", "net/minecraft/tileentity/TileEntityBeacon"));
            mObInitMap.put(new Pair<String, String>("akr", "net/minecraft/block/BlockDynamicLiquid"));
            mObInitMap.put(new Pair<String, String>("act", "net/minecraft/item/ItemFishFood"));
            mObInitMap.put(new Pair<String, String>("ags", "net/minecraft/block/BlockEventData"));
            mObInitMap.put(new Pair<String, String>("bss", "net/minecraft/client/audio/SoundListSerializer"));
            mObInitMap.put(new Pair<String, String>("bot", "net/minecraft/client/renderer/entity/RenderSlime"));
            mObInitMap.put(new Pair<String, String>("azy", "net/minecraft/scoreboard/ScorePlayerTeam"));
            mObInitMap.put(new Pair<String, String>("bcw", "net/minecraft/client/gui/GuiYesNo"));
            mObInitMap.put(new Pair<String, String>("bgv", "net/minecraft/client/main/Main$2"));
            mObInitMap.put(new Pair<String, String>("bku", "net/minecraft/client/particle/EntityReddustFX"));
            mObInitMap.put(new Pair<String, String>("pn", "net/minecraft/util/TupleIntJsonSerializable"));
            mObInitMap.put(new Pair<String, String>("lo", "net/minecraft/network/rcon/IServer"));
            mObInitMap.put(new Pair<String, String>("hp", "net/minecraft/network/play/server/S0APacketUseBed"));
            mObInitMap.put(new Pair<String, String>("dq", "net/minecraft/nbt/NBTTagList"));
            mObInitMap.put(new Pair<String, String>("adh", "net/minecraft/item/ItemMap"));
            mObInitMap.put(new Pair<String, String>("bph", "net/minecraft/client/shader/ShaderDefault"));
            mObInitMap.put(new Pair<String, String>("aso", "net/minecraft/world/gen/feature/WorldGenSwamp"));
            mObInitMap.put(new Pair<String, String>("aop", "net/minecraft/block/BlockCarpet"));
            mObInitMap.put(new Pair<String, String>("bdk", "net/minecraft/client/gui/GuiLanguage$List"));
            mObInitMap.put(new Pair<String, String>("bhj", "net/minecraft/client/model/ModelCreeper"));
            mObInitMap.put(new Pair<String, String>("bli", "net/minecraft/util/MovementInput"));
            mObInitMap.put(new Pair<String, String>("ee", "net/minecraft/nbt/JsonToNBT$List"));
            mObInitMap.put(new Pair<String, String>("af", "net/minecraft/command/server/CommandBanIp"));
            mObInitMap.put(new Pair<String, String>("xk", "net/minecraft/entity/item/EntityItem"));
            mObInitMap.put(new Pair<String, String>("tl", "net/minecraft/entity/ai/attributes/BaseAttributeMap"));
            mObInitMap.put(new Pair<String, String>("pm", "net/minecraft/stats/IStatType"));
            mObInitMap.put(new Pair<String, String>("atc", "net/minecraft/world/gen/structure/StructureMineshaftStart"));
            mObInitMap.put(new Pair<String, String>("apd", "net/minecraft/tileentity/TileEntityEnchantmentTable"));
            mObInitMap.put(new Pair<String, String>("ale", "net/minecraft/block/BlockFurnace"));
            mObInitMap.put(new Pair<String, String>("adg", "net/minecraft/item/ItemLeaves"));
            mObInitMap.put(new Pair<String, String>("ahf", "net/minecraft/world/World$4"));
            mObInitMap.put(new Pair<String, String>("axb", "net/minecraft/world/gen/layer/GenLayerAddIsland"));
            mObInitMap.put(new Pair<String, String>("bpg", "net/minecraft/client/util/JsonBlendingMode"));
            mObInitMap.put(new Pair<String, String>("net/minecraft/realms/RealmsMth", "net/minecraft/realms/RealmsMth"));
            mObInitMap.put(new Pair<String, String>("qa", "net/minecraft/util/IntHashMap$Entry"));
            mObInitMap.put(new Pair<String, String>("mb", "net/minecraft/server/gui/MinecraftServerGui$3"));
            mObInitMap.put(new Pair<String, String>("ic", "net/minecraft/network/play/server/S3BPacketScoreboardObjective"));
            mObInitMap.put(new Pair<String, String>("ed", "net/minecraft/nbt/JsonToNBT$Compound"));
            mObInitMap.put(new Pair<String, String>("net/minecraft/realms/RendererUtility", "net/minecraft/realms/RendererUtility"));
            mObInitMap.put(new Pair<String, String>("atv", "net/minecraft/world/gen/structure/StructureNetherBridgePieces$Stairs"));
            mObInitMap.put(new Pair<String, String>("apw", "net/minecraft/world/chunk/EmptyChunk"));
            mObInitMap.put(new Pair<String, String>("alx", "net/minecraft/block/BlockLog"));
            mObInitMap.put(new Pair<String, String>("adz", "net/minecraft/item/ItemSign"));
            mObInitMap.put(new Pair<String, String>("ahy", "net/minecraft/world/biome/BiomeCache"));
            mObInitMap.put(new Pair<String, String>("axu", "net/minecraft/world/gen/layer/GenLayerRiver"));
            mObInitMap.put(new Pair<String, String>("bpz", "net/minecraft/client/renderer/texture/TextureMap"));
            mObInitMap.put(new Pair<String, String>("yr", "net/minecraft/entity/monster/EntityZombie$1"));
            mObInitMap.put(new Pair<String, String>("us", "net/minecraft/entity/ai/EntityAIMoveThroughVillage"));
            mObInitMap.put(new Pair<String, String>("mu", "net/minecraft/world/WorldServer$1"));
            mObInitMap.put(new Pair<String, String>("iv", "net/minecraft/network/play/client/C0FPacketConfirmTransaction"));
            mObInitMap.put(new Pair<String, String>("ew", "net/minecraft/network/NetworkStatistics$PacketStat"));
            mObInitMap.put(new Pair<String, String>("ax", "net/minecraft/command/server/CommandListBans"));
            mObInitMap.put(new Pair<String, String>("net/minecraft/realms/ServerPing", "net/minecraft/realms/ServerPing"));
            mObInitMap.put(new Pair<String, String>("aqk", "net/minecraft/world/chunk/storage/AnvilChunkLoader"));
            mObInitMap.put(new Pair<String, String>("aml", "net/minecraft/block/BlockOldLeaf"));
            mObInitMap.put(new Pair<String, String>("aen", "net/minecraft/potion/PotionHelper"));
            mObInitMap.put(new Pair<String, String>("aao", "net/minecraft/inventory/ContainerHorseInventory$2"));
            mObInitMap.put(new Pair<String, String>("aim", "net/minecraft/world/biome/BiomeGenMushroomIsland"));
            mObInitMap.put(new Pair<String, String>("o", "net/minecraft/crash/CrashReportCategory$Entry"));
            mObInitMap.put(new Pair<String, String>("bum", "net/minecraft/client/stream/IStream"));
            mObInitMap.put(new Pair<String, String>("bqn", "net/minecraft/client/resources/AbstractResourcePack"));
            mObInitMap.put(new Pair<String, String>("bar", "net/minecraft/client/Minecraft$11"));
            mObInitMap.put(new Pair<String, String>("beq", "net/minecraft/client/gui/achievement/GuiStats$Stats"));
            mObInitMap.put(new Pair<String, String>("bip", "net/minecraft/client/model/ModelZombie"));
            mObInitMap.put(new Pair<String, String>("bmo", "net/minecraft/client/renderer/tileentity/TileEntityEnderChestRenderer"));
            mObInitMap.put(new Pair<String, String>("ni", "net/minecraft/network/NetHandlerPlayServer$1"));
            mObInitMap.put(new Pair<String, String>("jj", "net/minecraft/network/play/client/C0BPacketEntityAction"));
            mObInitMap.put(new Pair<String, String>("fk", "net/minecraft/util/IChatComponent$Serializer"));
            mObInitMap.put(new Pair<String, String>("bl", "net/minecraft/command/ServerCommandManager"));
            mObInitMap.put(new Pair<String, String>("yq", "net/minecraft/entity/monster/EntityZombie"));
            mObInitMap.put(new Pair<String, String>("abc", "net/minecraft/item/ItemArmor$1"));
            mObInitMap.put(new Pair<String, String>("afb", "net/minecraft/item/crafting/RecipesMapCloning"));
            mObInitMap.put(new Pair<String, String>("brb", "net/minecraft/client/resources/ResourcePackFileNotFoundException"));
            mObInitMap.put(new Pair<String, String>("aqj", "net/minecraft/world/chunk/storage/RegionFileCache"));
            mObInitMap.put(new Pair<String, String>("aui", "net/minecraft/world/gen/structure/StructureStrongholdPieces"));
            mObInitMap.put(new Pair<String, String>("bbf", "net/minecraft/client/Minecraft$9"));
            mObInitMap.put(new Pair<String, String>("bfe", "net/minecraft/client/gui/GuiScreenBook"));
            mObInitMap.put(new Pair<String, String>("bjd", "net/minecraft/client/multiplayer/ChunkProviderClient"));
            mObInitMap.put(new Pair<String, String>("bnc", "net/minecraft/client/renderer/entity/RenderBat"));
            mObInitMap.put(new Pair<String, String>("ze", "net/minecraft/entity/projectile/EntityFireball"));
            mObInitMap.put(new Pair<String, String>("vf", "net/minecraft/entity/ai/EntityAIRestrictSun"));
            mObInitMap.put(new Pair<String, String>("rg", "net/minecraft/client/renderer/texture/IIconRegister"));
            mObInitMap.put(new Pair<String, String>("afa", "net/minecraft/item/crafting/FurnaceRecipes"));
            mObInitMap.put(new Pair<String, String>("bby", "net/minecraft/client/gui/MapItemRenderer$1"));
            mObInitMap.put(new Pair<String, String>("bfx", "net/minecraft/client/gui/inventory/GuiEditSign"));
            mObInitMap.put(new Pair<String, String>("bra", "net/minecraft/client/resources/IResourcePack"));
            mObInitMap.put(new Pair<String, String>("zx", "net/minecraft/inventory/ContainerBeacon"));
            mObInitMap.put(new Pair<String, String>("vy", "net/minecraft/village/VillageDoorInfo"));
            mObInitMap.put(new Pair<String, String>("arq", "net/minecraft/world/gen/feature/WorldGenFire"));
            mObInitMap.put(new Pair<String, String>("anr", "net/minecraft/block/BlockStainedGlassPane"));
            mObInitMap.put(new Pair<String, String>("abu", "net/minecraft/creativetab/CreativeTabs$1"));
            mObInitMap.put(new Pair<String, String>("aft", "net/minecraft/enchantment/Enchantment"));
            mObInitMap.put(new Pair<String, String>("ajs", "net/minecraft/block/BlockButton"));
            mObInitMap.put(new Pair<String, String>("avp", "net/minecraft/world/gen/structure/StructureVillagePieces"));
            mObInitMap.put(new Pair<String, String>("azo", "net/minecraft/world/storage/SaveHandlerMP"));
            mObInitMap.put(new Pair<String, String>("brt", "net/minecraft/client/resources/data/BaseMetadataSectionSerializer"));
            mObInitMap.put(new Pair<String, String>("bfw", "net/minecraft/client/gui/GuiMerchant$MerchantButton"));
            mObInitMap.put(new Pair<String, String>("bjv", "net/minecraft/client/particle/EntityBubbleFX"));
            mObInitMap.put(new Pair<String, String>("bnu", "net/minecraft/client/renderer/entity/RenderGiantZombie"));
            mObInitMap.put(new Pair<String, String>("wm", "net/minecraft/entity/passive/EntityMooshroom"));
            mObInitMap.put(new Pair<String, String>("oo", "net/minecraft/server/management/UserList$Serializer"));
            mObInitMap.put(new Pair<String, String>("kp", "net/minecraft/init/Bootstrap$12"));
            mObInitMap.put(new Pair<String, String>("gq", "net/minecraft/network/play/server/S2FPacketSetSlot"));
            mObInitMap.put(new Pair<String, String>("cr", "net/minecraft/util/EnumFacing"));
            mObInitMap.put(new Pair<String, String>("aof", "net/minecraft/block/BlockTripWire"));
            mObInitMap.put(new Pair<String, String>("akg", "net/minecraft/block/BlockDaylightDetector"));
            mObInitMap.put(new Pair<String, String>("aci", "net/minecraft/item/ItemDoublePlant"));
            mObInitMap.put(new Pair<String, String>("agh", "net/minecraft/enchantment/EnchantmentOxygen"));
            mObInitMap.put(new Pair<String, String>("bsh", "net/minecraft/client/resources/data/PackMetadataSectionSerializer"));
            mObInitMap.put(new Pair<String, String>("bcl", "net/minecraft/client/gui/GuiOptionsRowList$Row"));
            mObInitMap.put(new Pair<String, String>("bgk", "net/minecraft/client/gui/GuiResourcePackList"));
            mObInitMap.put(new Pair<String, String>("bkj", "net/minecraft/client/particle/EntityHugeExplodeFX"));
            mObInitMap.put(new Pair<String, String>("boi", "net/minecraft/client/renderer/entity/RenderMinecart"));
            mObInitMap.put(new Pair<String, String>("pc", "net/minecraft/stats/AchievementList"));
            mObInitMap.put(new Pair<String, String>("ld", "net/minecraft/client/util/JsonException$Entry"));
            mObInitMap.put(new Pair<String, String>("he", "net/minecraft/network/play/server/S34PacketMaps"));
            mObInitMap.put(new Pair<String, String>("df", "net/minecraft/nbt/NBTTagByteArray"));
            mObInitMap.put(new Pair<String, String>("asd", "net/minecraft/world/gen/feature/WorldGenDungeons"));
            mObInitMap.put(new Pair<String, String>("awc", "net/minecraft/world/gen/structure/StructureVillagePieces$House3"));
            mObInitMap.put(new Pair<String, String>("dy", "net/minecraft/nbt/NBTBase"));
            mObInitMap.put(new Pair<String, String>("ta", "net/minecraft/entity/IEntityOwnable"));
            mObInitMap.put(new Pair<String, String>("pb", "net/minecraft/stats/Achievement"));
            mObInitMap.put(new Pair<String, String>("asw", "net/minecraft/world/gen/structure/MapGenMineshaft"));
            mObInitMap.put(new Pair<String, String>("aox", "net/minecraft/tileentity/TileEntityCommandBlock"));
            mObInitMap.put(new Pair<String, String>("aky", "net/minecraft/block/BlockFarmland"));
            mObInitMap.put(new Pair<String, String>("agz", "net/minecraft/world/GameRules$Value"));
            mObInitMap.put(new Pair<String, String>("awv", "net/minecraft/block/material/MapColor"));
            mObInitMap.put(new Pair<String, String>("bds", "net/minecraft/client/gui/GuiFlatPresets$ListSlot"));
            mObInitMap.put(new Pair<String, String>("bhr", "net/minecraft/client/model/ModelBase"));
            mObInitMap.put(new Pair<String, String>("bsz", "net/minecraft/server/integrated/IntegratedServer$2"));
            mObInitMap.put(new Pair<String, String>("xs", "net/minecraft/entity/item/EntityMinecartEmpty"));
            mObInitMap.put(new Pair<String, String>("tt", "net/minecraft/entity/ai/EntityJumpHelper"));
            mObInitMap.put(new Pair<String, String>("pu", "net/minecraft/util/JsonUtils"));
            mObInitMap.put(new Pair<String, String>("lv", "net/minecraft/server/dedicated/DedicatedServer$2"));
            mObInitMap.put(new Pair<String, String>("hw", "net/minecraft/network/play/server/S1CPacketEntityMetadata"));
            mObInitMap.put(new Pair<String, String>("dx", "net/minecraft/nbt/NBTTagString"));
            mObInitMap.put(new Pair<String, String>("atk", "net/minecraft/world/gen/structure/StructureNetherBridgePieces$Corridor4"));
            mObInitMap.put(new Pair<String, String>("apl", "net/minecraft/tileentity/TileEntityNote"));
            mObInitMap.put(new Pair<String, String>("alm", "net/minecraft/block/BlockHay"));
            mObInitMap.put(new Pair<String, String>("ado", "net/minecraft/item/ItemPiston"));
            mObInitMap.put(new Pair<String, String>("ahn", "net/minecraft/world/EnumSkyBlock"));
            mObInitMap.put(new Pair<String, String>("axj", "net/minecraft/world/gen/layer/GenLayerFuzzyZoom"));
            mObInitMap.put(new Pair<String, String>("btn", "net/minecraft/client/audio/SoundManager$SoundSystemStarterThread"));
            mObInitMap.put(new Pair<String, String>("bpo", "net/minecraft/client/shader/ShaderUniform"));
            mObInitMap.put(new Pair<String, String>("bhq", "net/minecraft/client/model/ModelMinecart"));
            mObInitMap.put(new Pair<String, String>("blp", "net/minecraft/client/renderer/RenderSorter"));
            mObInitMap.put(new Pair<String, String>("yg", "net/minecraft/entity/monster/EntityMob"));
            mObInitMap.put(new Pair<String, String>("uh", "net/minecraft/entity/ai/EntityAIFollowParent"));
            mObInitMap.put(new Pair<String, String>("qi", "net/minecraft/profiler/Profiler"));
            mObInitMap.put(new Pair<String, String>("mj", "net/minecraft/client/renderer/DestroyBlockProgress"));
            mObInitMap.put(new Pair<String, String>("ik", "net/minecraft/network/play/server/S18PacketEntityTeleport"));
            mObInitMap.put(new Pair<String, String>("el", "net/minecraft/network/NetworkManager$2"));
            mObInitMap.put(new Pair<String, String>("am", "net/minecraft/command/CommandEffect"));
            mObInitMap.put(new Pair<String, String>("ama", "net/minecraft/block/BlockMobSpawner"));
            mObInitMap.put(new Pair<String, String>("aec", "net/minecraft/item/ItemSnow"));
            mObInitMap.put(new Pair<String, String>("aad", "net/minecraft/inventory/ContainerChest"));
            mObInitMap.put(new Pair<String, String>("aib", "net/minecraft/world/biome/WorldChunkManager"));
            mObInitMap.put(new Pair<String, String>("d", "net/minecraft/crash/CrashReport$2"));
            mObInitMap.put(new Pair<String, String>("bub", "net/minecraft/client/stream/BroadcastController$SwitchBroadcastState"));
            mObInitMap.put(new Pair<String, String>("bqc", "net/minecraft/client/renderer/texture/TextureMap$3"));
            mObInitMap.put(new Pair<String, String>("bag", "net/minecraft/scoreboard/ScoreHealthCriteria"));
            mObInitMap.put(new Pair<String, String>("bef", "net/minecraft/client/gui/GuiVideoSettings"));
            mObInitMap.put(new Pair<String, String>("bie", "net/minecraft/client/model/ModelSlime"));
            mObInitMap.put(new Pair<String, String>("bmd", "net/minecraft/client/renderer/RenderList"));
            mObInitMap.put(new Pair<String, String>("ba", "net/minecraft/command/server/CommandMessageRaw"));
            mObInitMap.put(new Pair<String, String>("aev", "net/minecraft/item/crafting/RecipesArmor"));
            mObInitMap.put(new Pair<String, String>("aaw", "net/minecraft/inventory/InventoryCraftResult"));
            mObInitMap.put(new Pair<String, String>("w", "net/minecraft/client/audio/SoundCategory"));
            mObInitMap.put(new Pair<String, String>("bqv", "net/minecraft/client/resources/IReloadableResourceManager"));
            mObInitMap.put(new Pair<String, String>("baz", "net/minecraft/client/Minecraft$3"));
            mObInitMap.put(new Pair<String, String>("bey", "net/minecraft/client/gui/GuiRepair"));
            mObInitMap.put(new Pair<String, String>("bix", "net/minecraft/client/model/ModelRenderer"));
            mObInitMap.put(new Pair<String, String>("bmw", "net/minecraft/client/renderer/culling/ClippingHelperImpl"));
            mObInitMap.put(new Pair<String, String>("fs", "net/minecraft/util/ChatComponentTranslationFormatException"));
            mObInitMap.put(new Pair<String, String>("bt", "net/minecraft/command/server/CommandStop"));
            mObInitMap.put(new Pair<String, String>("yy", "net/minecraft/entity/player/InventoryPlayer$1"));
            mObInitMap.put(new Pair<String, String>("uz", "net/minecraft/entity/ai/EntityAIPanic"));
            mObInitMap.put(new Pair<String, String>("aqr", "net/minecraft/world/WorldProviderEnd"));
            mObInitMap.put(new Pair<String, String>("ams", "net/minecraft/block/BlockCompressedPowered"));
            mObInitMap.put(new Pair<String, String>("aeu", "net/minecraft/item/crafting/RecipesArmorDyes"));
            mObInitMap.put(new Pair<String, String>("ait", "net/minecraft/world/biome/BiomeGenSavanna$Mutated"));
            mObInitMap.put(new Pair<String, String>("auq", "net/minecraft/world/gen/structure/StructureStrongholdPieces$Library"));
            mObInitMap.put(new Pair<String, String>("ayp", "net/minecraft/world/storage/DerivedWorldInfo"));
            mObInitMap.put(new Pair<String, String>("bbn", "net/minecraft/client/settings/GameSettings$Options$1"));
            mObInitMap.put(new Pair<String, String>("bfm", "net/minecraft/client/gui/inventory/GuiContainerCreative$ContainerCreative"));
            mObInitMap.put(new Pair<String, String>("but", "net/minecraft/realms/RealmsServerStatusPinger$1"));
            mObInitMap.put(new Pair<String, String>("bqu", "net/minecraft/client/resources/GrassColorReloadListener"));
            mObInitMap.put(new Pair<String, String>("zm", "net/minecraft/entity/item/EntityEnderPearl"));
            mObInitMap.put(new Pair<String, String>("vn", "net/minecraft/entity/ai/EntityAIHurtByTarget"));
            mObInitMap.put(new Pair<String, String>("ro", "net/minecraft/util/DamageSource"));
            mObInitMap.put(new Pair<String, String>("np", "net/minecraft/server/network/NetHandlerLoginServer$LoginState"));
            mObInitMap.put(new Pair<String, String>("jq", "net/minecraft/network/handshake/INetHandlerHandshakeServer"));
            mObInitMap.put(new Pair<String, String>("fr", "net/minecraft/util/ChatComponentTranslation"));
            mObInitMap.put(new Pair<String, String>("arf", "net/minecraft/world/gen/feature/WorldGenBlockBlob"));
            mObInitMap.put(new Pair<String, String>("ang", "net/minecraft/block/BlockRotatedPillar"));
            mObInitMap.put(new Pair<String, String>("abj", "net/minecraft/item/ItemBoat"));
            mObInitMap.put(new Pair<String, String>("afi", "net/minecraft/item/crafting/ShapelessRecipes"));
            mObInitMap.put(new Pair<String, String>("ajh", "net/minecraft/block/BlockBed"));
            mObInitMap.put(new Pair<String, String>("ave", "net/minecraft/world/gen/structure/MapGenStructure"));
            mObInitMap.put(new Pair<String, String>("azd", "net/minecraft/client/AnvilConverterException"));
            mObInitMap.put(new Pair<String, String>("net/minecraft/client/main/Main", "net/minecraft/client/main/Main"));
            mObInitMap.put(new Pair<String, String>("bri", "net/minecraft/client/resources/SimpleResource"));
            mObInitMap.put(new Pair<String, String>("bfl", "net/minecraft/client/gui/inventory/GuiContainerCreative"));
            mObInitMap.put(new Pair<String, String>("bjk", "net/minecraft/client/entity/EntityClientPlayerMP"));
            mObInitMap.put(new Pair<String, String>("bnj", "net/minecraft/client/renderer/entity/RenderEntity"));
            mObInitMap.put(new Pair<String, String>("wb", "net/minecraft/village/VillageSiege"));
            mObInitMap.put(new Pair<String, String>("sc", "net/minecraft/entity/Entity$2"));
            mObInitMap.put(new Pair<String, String>("od", "net/minecraft/server/management/PreYggdrasilConverter$4"));
            mObInitMap.put(new Pair<String, String>("ke", "net/minecraft/network/ServerStatusResponse$Serializer"));
            mObInitMap.put(new Pair<String, String>("gf", "net/minecraft/network/play/server/S35PacketUpdateTileEntity"));
            mObInitMap.put(new Pair<String, String>("cg", "net/minecraft/command/PlayerNotFoundException"));
            mObInitMap.put(new Pair<String, String>("ary", "net/minecraft/world/gen/feature/WorldGenGlowStone1"));
            mObInitMap.put(new Pair<String, String>("anz", "net/minecraft/block/BlockTallGrass"));
            mObInitMap.put(new Pair<String, String>("bca", "net/minecraft/client/gui/ScaledResolution"));
            mObInitMap.put(new Pair<String, String>("ow", "net/minecraft/network/rcon/RConThreadBase"));
            mObInitMap.put(new Pair<String, String>("kx", "net/minecraft/init/Bootstrap$6"));
            mObInitMap.put(new Pair<String, String>("gy", "net/minecraft/network/play/server/S21PacketChunkData$Extracted"));
            mObInitMap.put(new Pair<String, String>("cz", "net/minecraft/util/IRegistry"));
            mObInitMap.put(new Pair<String, String>("acq", "net/minecraft/item/ItemFireball"));
            mObInitMap.put(new Pair<String, String>("agp", "net/minecraft/command/server/CommandBlockLogic"));
            mObInitMap.put(new Pair<String, String>("bsp", "net/minecraft/client/audio/SoundList"));
            mObInitMap.put(new Pair<String, String>("boq", "net/minecraft/client/renderer/entity/RenderSheep"));
            mObInitMap.put(new Pair<String, String>("arx", "net/minecraft/world/gen/feature/WorldGenLakes"));
            mObInitMap.put(new Pair<String, String>("avw", "net/minecraft/world/gen/structure/StructureVillagePieces$House4Garden"));
            mObInitMap.put(new Pair<String, String>("azv", "net/minecraft/util/MovingObjectPosition$MovingObjectType"));
            mObInitMap.put(new Pair<String, String>("bct", "net/minecraft/client/gui/GuiChat"));
            mObInitMap.put(new Pair<String, String>("bgs", "net/minecraft/client/gui/stream/GuiTwitchUserMode"));
            mObInitMap.put(new Pair<String, String>("bkr", "net/minecraft/client/particle/EffectRenderer$4"));
            mObInitMap.put(new Pair<String, String>("dn", "net/minecraft/nbt/NBTTagIntArray"));
            mObInitMap.put(new Pair<String, String>("wt", "net/minecraft/entity/monster/EntityIronGolem"));
            mObInitMap.put(new Pair<String, String>("su", "net/minecraft/entity/EntityLeashKnot"));
            mObInitMap.put(new Pair<String, String>("asl", "net/minecraft/world/gen/feature/WorldGenSpikes"));
            mObInitMap.put(new Pair<String, String>("aom", "net/minecraft/block/BlockWood"));
            mObInitMap.put(new Pair<String, String>("akn", "net/minecraft/block/BlockDoor"));
            mObInitMap.put(new Pair<String, String>("ago", "net/minecraft/village/MerchantRecipeList"));
            mObInitMap.put(new Pair<String, String>("awk", "net/minecraft/world/gen/NoiseGeneratorOctaves"));
            mObInitMap.put(new Pair<String, String>("bdh", "net/minecraft/client/gui/GuiErrorScreen"));
            mObInitMap.put(new Pair<String, String>("bhg", "net/minecraft/client/model/ModelChest"));
            mObInitMap.put(new Pair<String, String>("bso", "net/minecraft/client/audio/PositionedSoundRecord"));
            mObInitMap.put(new Pair<String, String>("xh", "net/minecraft/entity/effect/EntityLightningBolt"));
            mObInitMap.put(new Pair<String, String>("ti", "net/minecraft/entity/ai/attributes/IAttributeInstance"));
            mObInitMap.put(new Pair<String, String>("pj", "net/minecraft/stats/StatBase$2"));
            mObInitMap.put(new Pair<String, String>("lk", "net/minecraft/server/MinecraftServer$4"));
            mObInitMap.put(new Pair<String, String>("apa", "net/minecraft/tileentity/TileEntityDaylightDetector"));
            mObInitMap.put(new Pair<String, String>("alb", "net/minecraft/block/BlockFire"));
            mObInitMap.put(new Pair<String, String>("add", "net/minecraft/item/ItemStack"));
            mObInitMap.put(new Pair<String, String>("ahc", "net/minecraft/world/World$1"));
            mObInitMap.put(new Pair<String, String>("btc", "net/minecraft/client/network/LanServerDetector$ThreadLanServerFind"));
            mObInitMap.put(new Pair<String, String>("bpd", "net/minecraft/client/renderer/tileentity/RenderWitherSkull"));
            mObInitMap.put(new Pair<String, String>("bhf", "net/minecraft/client/model/ModelBook"));
            mObInitMap.put(new Pair<String, String>("ble", "net/minecraft/client/particle/EntityFishWakeFX"));
            mObInitMap.put(new Pair<String, String>("ea", "net/minecraft/nbt/NBTException"));
            mObInitMap.put(new Pair<String, String>("ab", "net/minecraft/command/ICommandManager"));
            mObInitMap.put(new Pair<String, String>("adw", "net/minecraft/item/ItemSeeds"));
            mObInitMap.put(new Pair<String, String>("ahv", "net/minecraft/world/biome/BiomeGenBase$Height"));
            mObInitMap.put(new Pair<String, String>("btv", "net/minecraft/client/audio/SoundEventAccessor"));
            mObInitMap.put(new Pair<String, String>("bpw", "net/minecraft/client/renderer/texture/Stitcher$Holder"));
            mObInitMap.put(new Pair<String, String>("bdz", "net/minecraft/client/gui/GuiShareToLan"));
            mObInitMap.put(new Pair<String, String>("bhy", "net/minecraft/client/model/ModelSheep2"));
            mObInitMap.put(new Pair<String, String>("blx", "net/minecraft/client/renderer/IImageBuffer"));
            mObInitMap.put(new Pair<String, String>("mr", "net/minecraft/server/management/PlayerManager$PlayerInstance"));
            mObInitMap.put(new Pair<String, String>("is", "net/minecraft/network/play/client/C16PacketClientStatus"));
            mObInitMap.put(new Pair<String, String>("et", "net/minecraft/network/PacketBuffer"));
            mObInitMap.put(new Pair<String, String>("au", "net/minecraft/command/CommandHelp"));
            mObInitMap.put(new Pair<String, String>("aek", "net/minecraft/item/ItemCloth"));
            mObInitMap.put(new Pair<String, String>("aal", "net/minecraft/inventory/ContainerHopper"));
            mObInitMap.put(new Pair<String, String>("l", "net/minecraft/crash/CrashReportCategory$1"));
            mObInitMap.put(new Pair<String, String>("bqk", "net/minecraft/client/renderer/texture/ITickableTextureObject"));
            mObInitMap.put(new Pair<String, String>("atr", "net/minecraft/world/gen/structure/StructureNetherBridgePieces$Throne"));
            mObInitMap.put(new Pair<String, String>("aps", "net/minecraft/tileentity/TileEntityPiston"));
            mObInitMap.put(new Pair<String, String>("axq", "net/minecraft/world/gen/layer/GenLayerRareBiome"));
            mObInitMap.put(new Pair<String, String>("bao", "net/minecraft/client/Minecraft"));
            mObInitMap.put(new Pair<String, String>("ben", "net/minecraft/client/gui/achievement/GuiStats$StatsItem"));
            mObInitMap.put(new Pair<String, String>("bim", "net/minecraft/client/model/ModelWitch"));
            mObInitMap.put(new Pair<String, String>("bml", "net/minecraft/client/renderer/tileentity/TileEntitySpecialRenderer"));
            mObInitMap.put(new Pair<String, String>("fh", "net/minecraft/event/ClickEvent"));
            mObInitMap.put(new Pair<String, String>("bi", "net/minecraft/command/server/CommandSaveOff"));
            mObInitMap.put(new Pair<String, String>("yn", "net/minecraft/entity/monster/EntitySpider"));
            mObInitMap.put(new Pair<String, String>("uo", "net/minecraft/entity/ai/EntityAILookAtTradePlayer"));
            mObInitMap.put(new Pair<String, String>("aqg", "net/minecraft/world/chunk/storage/ChunkLoader$AnvilConverterData"));
            mObInitMap.put(new Pair<String, String>("amh", "net/minecraft/block/BlockNewLeaf"));
            mObInitMap.put(new Pair<String, String>("aii", "net/minecraft/world/biome/BiomeGenHell"));
            mObInitMap.put(new Pair<String, String>("auf", "net/minecraft/world/gen/structure/ComponentScatteredFeaturePieces$SwampHut"));
            mObInitMap.put(new Pair<String, String>("aye", "net/minecraft/pathfinding/PathPoint"));
            mObInitMap.put(new Pair<String, String>("bbc", "net/minecraft/client/Minecraft$6"));
            mObInitMap.put(new Pair<String, String>("bfb", "net/minecraft/client/gui/inventory/GuiBeacon$ConfirmButton"));
            mObInitMap.put(new Pair<String, String>("bui", "net/minecraft/client/stream/IngestServerTester"));
            mObInitMap.put(new Pair<String, String>("bqj", "net/minecraft/client/renderer/texture/ITickable"));
            mObInitMap.put(new Pair<String, String>("zb", "net/minecraft/entity/player/EntityPlayer$EnumChatVisibility"));
            mObInitMap.put(new Pair<String, String>("vc", "net/minecraft/entity/ai/EntityAIWander"));
            mObInitMap.put(new Pair<String, String>("rd", "net/minecraft/world/EnumDifficulty"));
            mObInitMap.put(new Pair<String, String>("ne", "net/minecraft/network/NetworkSystem$2"));
            mObInitMap.put(new Pair<String, String>("jf", "net/minecraft/network/play/client/C03PacketPlayer$C06PacketPlayerPosLook"));
            mObInitMap.put(new Pair<String, String>("fg", "net/minecraft/util/ChatComponentStyle$2"));
            mObInitMap.put(new Pair<String, String>("aqz", "net/minecraft/world/gen/ChunkProviderGenerate"));
            mObInitMap.put(new Pair<String, String>("auy", "net/minecraft/world/gen/structure/StructureStrongholdPieces$Stairs"));
            mObInitMap.put(new Pair<String, String>("ayx", "net/minecraft/world/storage/WorldInfo$5"));
            mObInitMap.put(new Pair<String, String>("net/minecraft/realms/RealmsSliderButton", "net/minecraft/realms/RealmsSliderButton"));
            mObInitMap.put(new Pair<String, String>("zu", "net/minecraft/inventory/ContainerRepair"));
            mObInitMap.put(new Pair<String, String>("vv", "net/minecraft/pathfinding/PathNavigate"));
            mObInitMap.put(new Pair<String, String>("rw", "net/minecraft/potion/PotionEffect"));
            mObInitMap.put(new Pair<String, String>("nx", "net/minecraft/server/management/BanList"));
            mObInitMap.put(new Pair<String, String>("jy", "net/minecraft/network/status/INetHandlerStatusClient"));
            mObInitMap.put(new Pair<String, String>("fz", "net/minecraft/network/play/server/S0FPacketSpawnMob"));
            mObInitMap.put(new Pair<String, String>("arn", "net/minecraft/world/gen/feature/WorldGenerator"));
            mObInitMap.put(new Pair<String, String>("ano", "net/minecraft/block/BlockSoulSand"));
            mObInitMap.put(new Pair<String, String>("abr", "net/minecraft/item/ItemColored"));
            mObInitMap.put(new Pair<String, String>("afq", "net/minecraft/enchantment/EnchantmentDamage"));
            mObInitMap.put(new Pair<String, String>("ajp", "net/minecraft/block/BlockBookshelf"));
            mObInitMap.put(new Pair<String, String>("brq", "net/minecraft/client/resources/Language"));
            mObInitMap.put(new Pair<String, String>("bbu", "net/minecraft/client/gui/FontRenderer"));
            mObInitMap.put(new Pair<String, String>("bft", "net/minecraft/client/gui/inventory/GuiScreenHorseInventory"));
            mObInitMap.put(new Pair<String, String>("bjs", "net/minecraft/client/network/OldServerPinger$2"));
            mObInitMap.put(new Pair<String, String>("bnr", "net/minecraft/client/renderer/entity/RenderFireball"));
            mObInitMap.put(new Pair<String, String>("sk", "net/minecraft/command/IEntitySelector$1"));
            mObInitMap.put(new Pair<String, String>("ol", "net/minecraft/server/management/UserListEntry"));
            mObInitMap.put(new Pair<String, String>("km", "net/minecraft/init/Bootstrap$1"));
            mObInitMap.put(new Pair<String, String>("gn", "net/minecraft/network/play/server/S2DPacketOpenWindow"));
            mObInitMap.put(new Pair<String, String>("co", "net/minecraft/util/RegistryDefaulted"));
            mObInitMap.put(new Pair<String, String>("acf", "net/minecraft/creativetab/CreativeTabs$9"));
            mObInitMap.put(new Pair<String, String>("age", "net/minecraft/enchantment/EnchantmentFishingSpeed"));
            mObInitMap.put(new Pair<String, String>("bse", "net/minecraft/client/resources/data/LanguageMetadataSection"));
            mObInitMap.put(new Pair<String, String>("arm", "net/minecraft/world/gen/feature/WorldGenDoublePlant"));
            mObInitMap.put(new Pair<String, String>("avl", "net/minecraft/world/gen/structure/StructureComponent$BlockSelector"));
            mObInitMap.put(new Pair<String, String>("bci", "net/minecraft/client/gui/GuiListExtended$IGuiListEntry"));
            mObInitMap.put(new Pair<String, String>("bgh", "net/minecraft/client/resources/ResourcePackListEntryDefault"));
            mObInitMap.put(new Pair<String, String>("bkg", "net/minecraft/client/particle/EntityFootStepFX"));
            mObInitMap.put(new Pair<String, String>("bof", "net/minecraft/client/renderer/entity/RenderLeashKnot"));
            mObInitMap.put(new Pair<String, String>("net/minecraft/server/MinecraftServer", "net/minecraft/server/MinecraftServer"));
            mObInitMap.put(new Pair<String, String>("hb", "net/minecraft/network/play/server/S2APacketParticles"));
            mObInitMap.put(new Pair<String, String>("wi", "net/minecraft/entity/passive/EntityHorse"));
            mObInitMap.put(new Pair<String, String>("sj", "net/minecraft/command/IEntitySelector"));
            mObInitMap.put(new Pair<String, String>("asa", "net/minecraft/world/gen/feature/WorldGenMegaPineTree"));
            mObInitMap.put(new Pair<String, String>("aob", "net/minecraft/block/BlockTNT"));
            mObInitMap.put(new Pair<String, String>("akc", "net/minecraft/block/BlockRedstoneComparator"));
            mObInitMap.put(new Pair<String, String>("agd", "net/minecraft/enchantment/EnchantmentFireAspect"));
            mObInitMap.put(new Pair<String, String>("bsd", "net/minecraft/client/resources/data/FontMetadataSectionSerializer"));
            mObInitMap.put(new Pair<String, String>("ha", "net/minecraft/network/play/server/S28PacketEffect"));
            mObInitMap.put(new Pair<String, String>("ast", "net/minecraft/world/gen/FlatLayerInfo"));
            mObInitMap.put(new Pair<String, String>("aou", "net/minecraft/tileentity/TileEntity$3"));
            mObInitMap.put(new Pair<String, String>("akv", "net/minecraft/block/BlockEnderChest"));
            mObInitMap.put(new Pair<String, String>("acx", "net/minecraft/item/ItemFood"));
            mObInitMap.put(new Pair<String, String>("agw", "net/minecraft/world/Explosion"));
            mObInitMap.put(new Pair<String, String>("aws", "net/minecraft/block/material/MaterialLiquid"));
            mObInitMap.put(new Pair<String, String>("bsw", "net/minecraft/server/integrated/IntegratedPlayerList"));
            mObInitMap.put(new Pair<String, String>("box", "net/minecraft/client/renderer/entity/RenderTntMinecart"));
            mObInitMap.put(new Pair<String, String>("bky", "net/minecraft/client/particle/EntitySplashFX"));
            mObInitMap.put(new Pair<String, String>("xp", "net/minecraft/entity/item/EntityMinecartContainer"));
            mObInitMap.put(new Pair<String, String>("tq", "net/minecraft/entity/ai/attributes/ServersideAttributeMap"));
            mObInitMap.put(new Pair<String, String>("pr", "net/minecraft/util/JsonSerializableSet"));
            mObInitMap.put(new Pair<String, String>("ls", "net/minecraft/server/dedicated/DedicatedPlayerList"));
            mObInitMap.put(new Pair<String, String>("ht", "net/minecraft/network/play/server/S19PacketEntityHeadLook"));
            mObInitMap.put(new Pair<String, String>("du", "net/minecraft/nbt/CompressedStreamTools"));
            mObInitMap.put(new Pair<String, String>("api", "net/minecraft/tileentity/TileEntityHopper"));
            mObInitMap.put(new Pair<String, String>("alj", "net/minecraft/block/BlockSlab"));
            mObInitMap.put(new Pair<String, String>("adl", "net/minecraft/item/ItemMultiTexture"));
            mObInitMap.put(new Pair<String, String>("ahk", "net/minecraft/world/WorldSettings$GameType"));
            mObInitMap.put(new Pair<String, String>("btk", "net/minecraft/client/audio/SoundManager$1"));
            mObInitMap.put(new Pair<String, String>("bpl", "net/minecraft/client/shader/ShaderLoader"));
            mObInitMap.put(new Pair<String, String>("bdo", "net/minecraft/client/gui/GuiMemoryErrorScreen"));
            mObInitMap.put(new Pair<String, String>("bhn", "net/minecraft/client/model/ModelLargeChest"));
            mObInitMap.put(new Pair<String, String>("blm", "net/minecraft/client/renderer/RenderBlocks"));
            mObInitMap.put(new Pair<String, String>("qf", "net/minecraft/util/EnumTypeAdapterFactory"));
            mObInitMap.put(new Pair<String, String>("mg", "net/minecraft/server/gui/StatsComponent$1"));
            mObInitMap.put(new Pair<String, String>("ih", "net/minecraft/network/play/server/S03PacketTimeUpdate"));
            mObInitMap.put(new Pair<String, String>("ei", "net/minecraft/network/NettyEncryptingEncoder"));
            mObInitMap.put(new Pair<String, String>("aj", "net/minecraft/command/server/CommandDeOp"));
            mObInitMap.put(new Pair<String, String>("aaa", "net/minecraft/inventory/ContainerBrewingStand$Ingredient"));
            mObInitMap.put(new Pair<String, String>("a", "net/minecraft/util/EnumChatFormatting"));
            mObInitMap.put(new Pair<String, String>("atg", "net/minecraft/world/gen/structure/StructureNetherBridgePieces$Crossing3"));
            mObInitMap.put(new Pair<String, String>("axf", "net/minecraft/world/gen/layer/GenLayerBiome"));
            mObInitMap.put(new Pair<String, String>("bad", "net/minecraft/scoreboard/ScoreboardSaveData"));
            mObInitMap.put(new Pair<String, String>("bec", "net/minecraft/client/gui/GuiScreenOptionsSounds"));
            mObInitMap.put(new Pair<String, String>("bib", "net/minecraft/client/model/ModelSkeletonHead"));
            mObInitMap.put(new Pair<String, String>("bma", "net/minecraft/client/renderer/RenderGlobal"));
            mObInitMap.put(new Pair<String, String>("yc", "net/minecraft/entity/monster/IMob$1"));
            mObInitMap.put(new Pair<String, String>("ud", "net/minecraft/entity/ai/EntityAIEatGrass"));
            mObInitMap.put(new Pair<String, String>("qe", "net/minecraft/util/LongHashMap$Entry"));
            mObInitMap.put(new Pair<String, String>("t", "net/minecraft/util/ChatAllowedCharacters"));
            mObInitMap.put(new Pair<String, String>("atz", "net/minecraft/world/gen/structure/ComponentScatteredFeaturePieces"));
            mObInitMap.put(new Pair<String, String>("baw", "net/minecraft/client/Minecraft$16"));
            mObInitMap.put(new Pair<String, String>("bev", "net/minecraft/client/gui/GuiKeyBindingList$KeyEntry"));
            mObInitMap.put(new Pair<String, String>("yv", "net/minecraft/entity/passive/EntityVillager"));
            mObInitMap.put(new Pair<String, String>("uw", "net/minecraft/entity/ai/EntityAIOcelotSit"));
            mObInitMap.put(new Pair<String, String>("qx", "net/minecraft/util/WeightedRandomChestContent"));
            mObInitMap.put(new Pair<String, String>("my", "net/minecraft/entity/EntityTrackerEntry"));
            mObInitMap.put(new Pair<String, String>("iz", "net/minecraft/network/play/client/C17PacketCustomPayload"));
            mObInitMap.put(new Pair<String, String>("aqo", "net/minecraft/world/WorldProvider"));
            mObInitMap.put(new Pair<String, String>("amp", "net/minecraft/block/BlockPortal"));
            mObInitMap.put(new Pair<String, String>("aas", "net/minecraft/inventory/InventoryMerchant"));
            mObInitMap.put(new Pair<String, String>("aun", "net/minecraft/world/gen/structure/StructureStrongholdPieces$Corridor"));
            mObInitMap.put(new Pair<String, String>("aym", "net/minecraft/world/chunk/storage/AnvilSaveHandler"));
            mObInitMap.put(new Pair<String, String>("buq", "net/minecraft/client/stream/TwitchStream$1$1"));
            mObInitMap.put(new Pair<String, String>("bqr", "net/minecraft/client/resources/FileResourcePack"));
            mObInitMap.put(new Pair<String, String>("bms", "net/minecraft/client/renderer/tileentity/TileEntitySkullRenderer"));
            mObInitMap.put(new Pair<String, String>("zj", "net/minecraft/entity/projectile/EntitySnowball"));
            mObInitMap.put(new Pair<String, String>("vk", "net/minecraft/entity/ai/EntityAITempt"));
            mObInitMap.put(new Pair<String, String>("rl", "net/minecraft/inventory/ISidedInventory"));
            mObInitMap.put(new Pair<String, String>("nm", "net/minecraft/server/network/NetHandlerHandshakeTCP$SwitchEnumConnectionState"));
            mObInitMap.put(new Pair<String, String>("jn", "net/minecraft/network/play/client/C12PacketUpdateSign"));
            mObInitMap.put(new Pair<String, String>("fo", "net/minecraft/util/ChatStyle$1"));
            mObInitMap.put(new Pair<String, String>("bp", "net/minecraft/command/CommandSetSpawnpoint"));
            mObInitMap.put(new Pair<String, String>("net/minecraft/realms/RealmsServerAddress", "net/minecraft/realms/RealmsServerAddress"));
            mObInitMap.put(new Pair<String, String>("arc", "net/minecraft/world/gen/feature/WorldGenAbstractTree"));
            mObInitMap.put(new Pair<String, String>("and", "net/minecraft/block/BlockRedstoneTorch$Toggle"));
            mObInitMap.put(new Pair<String, String>("abg", "net/minecraft/item/ItemBed"));
            mObInitMap.put(new Pair<String, String>("aff", "net/minecraft/item/crafting/CraftingManager$1"));
            mObInitMap.put(new Pair<String, String>("aje", "net/minecraft/block/BlockRailBase"));
            mObInitMap.put(new Pair<String, String>("brf", "net/minecraft/client/resources/ResourcePackRepository$Entry"));
            mObInitMap.put(new Pair<String, String>("bbj", "net/minecraft/client/settings/GameSettings"));
            mObInitMap.put(new Pair<String, String>("bfi", "net/minecraft/client/gui/inventory/GuiChest"));
            mObInitMap.put(new Pair<String, String>("bjh", "net/minecraft/client/multiplayer/WorldClient$2"));
            mObInitMap.put(new Pair<String, String>("bng", "net/minecraft/client/renderer/entity/RenderChicken"));
            mObInitMap.put(new Pair<String, String>("oa", "net/minecraft/server/management/PreYggdrasilConverter$1"));
            mObInitMap.put(new Pair<String, String>("kb", "net/minecraft/network/ServerStatusResponse"));
            mObInitMap.put(new Pair<String, String>("gc", "net/minecraft/network/play/server/S0BPacketAnimation"));
            mObInitMap.put(new Pair<String, String>("cd", "net/minecraft/command/CommandException"));
            mObInitMap.put(new Pair<String, String>("abz", "net/minecraft/creativetab/CreativeTabs$3"));
            mObInitMap.put(new Pair<String, String>("afy", "net/minecraft/enchantment/EnchantmentHelper$HurtIterator"));
            mObInitMap.put(new Pair<String, String>("bry", "net/minecraft/client/resources/data/IMetadataSerializer$Registration"));
            mObInitMap.put(new Pair<String, String>("ava", "net/minecraft/world/gen/structure/StructureStrongholdPieces$Straight"));
            mObInitMap.put(new Pair<String, String>("bnz", "net/minecraft/client/renderer/entity/RenderItem$1"));
            mObInitMap.put(new Pair<String, String>("gv", "net/minecraft/network/play/server/S2BPacketChangeGameState"));
            mObInitMap.put(new Pair<String, String>("cw", "net/minecraft/util/RegistryNamespaced"));
            mObInitMap.put(new Pair<String, String>("net/minecraft/realms/RealmsScrolledSelectionList", "net/minecraft/realms/RealmsScrolledSelectionList"));
            mObInitMap.put(new Pair<String, String>("aru", "net/minecraft/world/gen/feature/WorldGenBigMushroom"));
            mObInitMap.put(new Pair<String, String>("anv", "net/minecraft/block/BlockStone"));
            mObInitMap.put(new Pair<String, String>("afx", "net/minecraft/enchantment/EnchantmentHelper$DamageIterator"));
            mObInitMap.put(new Pair<String, String>("ajw", "net/minecraft/block/BlockCauldron"));
            mObInitMap.put(new Pair<String, String>("avt", "net/minecraft/world/gen/structure/StructureVillagePieces$Torch"));
            mObInitMap.put(new Pair<String, String>("azs", "net/minecraft/world/storage/IThreadedFileIO"));
            mObInitMap.put(new Pair<String, String>("bcq", "net/minecraft/client/gui/GuiScreenRealmsProxy"));
            mObInitMap.put(new Pair<String, String>("bgp", "net/minecraft/client/gui/stream/GuiStreamUnavailable"));
            mObInitMap.put(new Pair<String, String>("brx", "net/minecraft/client/resources/data/IMetadataSerializer$1"));
            mObInitMap.put(new Pair<String, String>("wq", "net/minecraft/entity/passive/EntitySheep$1"));
            mObInitMap.put(new Pair<String, String>("sr", "net/minecraft/entity/EntityFlying"));
            mObInitMap.put(new Pair<String, String>("os", "net/minecraft/server/management/UserListWhitelistEntry"));
            mObInitMap.put(new Pair<String, String>("kt", "net/minecraft/init/Bootstrap$3"));
            mObInitMap.put(new Pair<String, String>("gu", "net/minecraft/network/play/server/S27PacketExplosion"));
            mObInitMap.put(new Pair<String, String>("asi", "net/minecraft/world/gen/feature/WorldGenCanopyTree"));
            mObInitMap.put(new Pair<String, String>("aoj", "net/minecraft/block/BlockLilyPad"));
            mObInitMap.put(new Pair<String, String>("akk", "net/minecraft/block/BlockDirectional"));
            mObInitMap.put(new Pair<String, String>("acm", "net/minecraft/item/ItemEnchantedBook"));
            mObInitMap.put(new Pair<String, String>("agl", "net/minecraft/enchantment/EnchantmentWaterWorker"));
            mObInitMap.put(new Pair<String, String>("bsl", "net/minecraft/client/audio/MovingSound"));
            mObInitMap.put(new Pair<String, String>("bom", "net/minecraft/client/renderer/entity/RenderOcelot"));
            mObInitMap.put(new Pair<String, String>("bgo", "net/minecraft/client/gui/stream/GuiStreamOptions"));
            mObInitMap.put(new Pair<String, String>("bkn", "net/minecraft/client/particle/EffectRenderer"));
            mObInitMap.put(new Pair<String, String>("net/minecraft/realms/RealmsScreen", "net/minecraft/realms/RealmsScreen"));
            mObInitMap.put(new Pair<String, String>("xe", "net/minecraft/entity/projectile/EntityFishHook"));
            mObInitMap.put(new Pair<String, String>("tf", "net/minecraft/entity/DataWatcher$WatchableObject"));
            mObInitMap.put(new Pair<String, String>("pg", "net/minecraft/stats/StatisticsFile"));
            mObInitMap.put(new Pair<String, String>("lh", "net/minecraft/server/MinecraftServer$1"));
            mObInitMap.put(new Pair<String, String>("hi", "net/minecraft/network/play/server/S14PacketEntity$S16PacketEntityLook"));
            mObInitMap.put(new Pair<String, String>("dj", "net/minecraft/nbt/NBTTagCompound$2"));
            mObInitMap.put(new Pair<String, String>("ada", "net/minecraft/item/ItemHoe"));
            mObInitMap.put(new Pair<String, String>("bpa", "net/minecraft/client/renderer/entity/RenderVillager"));
            mObInitMap.put(new Pair<String, String>("bdd", "net/minecraft/client/gui/GuiScreenDemo"));
            mObInitMap.put(new Pair<String, String>("bhc", "net/minecraft/client/model/ModelBat"));
            mObInitMap.put(new Pair<String, String>("blb", "net/minecraft/client/particle/EntityPickupFX"));
            mObInitMap.put(new Pair<String, String>("pz", "net/minecraft/util/IntHashMap"));
            mObInitMap.put(new Pair<String, String>("adt", "net/minecraft/item/ItemSaddle"));
            mObInitMap.put(new Pair<String, String>("ahs", "net/minecraft/world/NextTickListEntry"));
            mObInitMap.put(new Pair<String, String>("bts", "net/minecraft/client/audio/SoundHandler$SwitchType"));
            mObInitMap.put(new Pair<String, String>("bpt", "net/minecraft/client/renderer/texture/LayeredTexture"));
            mObInitMap.put(new Pair<String, String>("awz", "net/minecraft/world/gen/layer/GenLayerEdge$SwitchMode"));
            mObInitMap.put(new Pair<String, String>("bdw", "net/minecraft/client/gui/GuiScreen"));
            mObInitMap.put(new Pair<String, String>("bhv", "net/minecraft/client/model/TexturedQuad"));
            mObInitMap.put(new Pair<String, String>("blu", "net/minecraft/client/renderer/EntityRenderer$1"));
            mObInitMap.put(new Pair<String, String>("ip", "net/minecraft/network/play/client/C0APacketAnimation"));
            mObInitMap.put(new Pair<String, String>("eq", "net/minecraft/network/EnumConnectionState$4"));
            mObInitMap.put(new Pair<String, String>("ar", "net/minecraft/command/CommandGameMode"));
            mObInitMap.put(new Pair<String, String>("xw", "net/minecraft/entity/item/EntityTNTPrimed"));
            mObInitMap.put(new Pair<String, String>("tx", "net/minecraft/entity/ai/EntityAIAvoidEntity$1"));
            mObInitMap.put(new Pair<String, String>("i", "net/minecraft/crash/CrashReport$7"));
            mObInitMap.put(new Pair<String, String>("ato", "net/minecraft/world/gen/structure/StructureNetherBridgePieces$Corridor5"));
            mObInitMap.put(new Pair<String, String>("app", "net/minecraft/block/BlockPistonBase"));
            mObInitMap.put(new Pair<String, String>("alq", "net/minecraft/block/BlockJukebox"));
            mObInitMap.put(new Pair<String, String>("ahr", "net/minecraft/world/ChunkCache"));
            mObInitMap.put(new Pair<String, String>("axn", "net/minecraft/world/gen/layer/GenLayer"));
            mObInitMap.put(new Pair<String, String>("bal", "net/minecraft/client/settings/KeyBinding"));
            mObInitMap.put(new Pair<String, String>("bek", "net/minecraft/client/gui/achievement/GuiStats$StatsBlock"));
            mObInitMap.put(new Pair<String, String>("bij", "net/minecraft/client/model/ModelIronGolem"));
            mObInitMap.put(new Pair<String, String>("btr", "net/minecraft/client/audio/SoundHandler$2"));
            mObInitMap.put(new Pair<String, String>("yk", "net/minecraft/entity/monster/EntitySilverfish"));
            mObInitMap.put(new Pair<String, String>("ul", "net/minecraft/entity/ai/EntityAIWatchClosest2"));
            mObInitMap.put(new Pair<String, String>("qm", "net/minecraft/util/MouseFilter"));
            mObInitMap.put(new Pair<String, String>("mn", "net/minecraft/entity/EntityTracker"));
            mObInitMap.put(new Pair<String, String>("io", "net/minecraft/network/play/INetHandlerPlayServer"));
            mObInitMap.put(new Pair<String, String>("aeg", "net/minecraft/item/ItemSlab"));
            mObInitMap.put(new Pair<String, String>("aah", "net/minecraft/inventory/ContainerEnchantment$1"));
            mObInitMap.put(new Pair<String, String>("aif", "net/minecraft/world/biome/BiomeGenForest"));
            mObInitMap.put(new Pair<String, String>("auc", "net/minecraft/world/gen/structure/ComponentScatteredFeaturePieces$JunglePyramid"));
            mObInitMap.put(new Pair<String, String>("ayb", "net/minecraft/world/gen/layer/GenLayerVoronoiZoom"));
            mObInitMap.put(new Pair<String, String>("buf", "net/minecraft/client/stream/ChatController$SwitchChatState"));
            mObInitMap.put(new Pair<String, String>("bqg", "net/minecraft/client/renderer/texture/TextureManager$1"));
            mObInitMap.put(new Pair<String, String>("bii", "net/minecraft/client/model/PositionTextureVertex"));
            mObInitMap.put(new Pair<String, String>("bmh", "net/minecraft/client/renderer/Tessellator"));
            mObInitMap.put(new Pair<String, String>("ra", "net/minecraft/inventory/InventoryLargeChest"));
            mObInitMap.put(new Pair<String, String>("nb", "net/minecraft/client/network/NetHandlerHandshakeMemory$SwitchEnumConnectionState"));
            mObInitMap.put(new Pair<String, String>("jc", "net/minecraft/network/play/client/C00PacketKeepAlive"));
            mObInitMap.put(new Pair<String, String>("fd", "net/minecraft/util/MessageSerializer2"));
            mObInitMap.put(new Pair<String, String>("be", "net/minecraft/command/server/CommandPardonPlayer"));
            mObInitMap.put(new Pair<String, String>("aqw", "net/minecraft/world/gen/MapGenCaves"));
            mObInitMap.put(new Pair<String, String>("amx", "net/minecraft/block/BlockQuartz"));
            mObInitMap.put(new Pair<String, String>("aez", "net/minecraft/item/crafting/RecipesFood"));
            mObInitMap.put(new Pair<String, String>("aiy", "net/minecraft/world/biome/BiomeEndDecorator"));
            mObInitMap.put(new Pair<String, String>("bqz", "net/minecraft/client/resources/IResourceManagerReloadListener"));
            mObInitMap.put(new Pair<String, String>("rt", "net/minecraft/potion/PotionHealthBoost"));
            mObInitMap.put(new Pair<String, String>("nu", "net/minecraft/server/management/PlayerProfileCache$2"));
            mObInitMap.put(new Pair<String, String>("jv", "net/minecraft/network/login/INetHandlerLoginServer"));
            mObInitMap.put(new Pair<String, String>("fw", "net/minecraft/network/play/server/S0EPacketSpawnObject"));
            mObInitMap.put(new Pair<String, String>("bx", "net/minecraft/command/server/CommandTestForBlock"));
            mObInitMap.put(new Pair<String, String>("abo", "net/minecraft/item/ItemBucket"));
            mObInitMap.put(new Pair<String, String>("afn", "net/minecraft/enchantment/EnchantmentArrowFire"));
            mObInitMap.put(new Pair<String, String>("brn", "net/minecraft/client/resources/SkinManager$3$1"));
            mObInitMap.put(new Pair<String, String>("aqv", "net/minecraft/world/gen/ChunkProviderHell"));
            mObInitMap.put(new Pair<String, String>("auu", "net/minecraft/world/gen/structure/StructureStrongholdPieces$RightTurn"));
            mObInitMap.put(new Pair<String, String>("ayt", "net/minecraft/world/storage/WorldInfo$1"));
            mObInitMap.put(new Pair<String, String>("bbr", "net/minecraft/util/Timer"));
            mObInitMap.put(new Pair<String, String>("bfq", "net/minecraft/client/gui/GuiEnchantment"));
            mObInitMap.put(new Pair<String, String>("bjp", "net/minecraft/client/multiplayer/ServerList"));
            mObInitMap.put(new Pair<String, String>("bno", "net/minecraft/client/renderer/entity/Render"));
            mObInitMap.put(new Pair<String, String>("net/minecraft/realms/RealmsLevelSummary", "net/minecraft/realms/RealmsLevelSummary"));
            mObInitMap.put(new Pair<String, String>("gk", "net/minecraft/network/play/server/S22PacketMultiBlockChange"));
            mObInitMap.put(new Pair<String, String>("cl", "net/minecraft/block/BlockSourceImpl"));
            mObInitMap.put(new Pair<String, String>("vr", "net/minecraft/entity/ai/EntityAITargetNonTamed"));
            mObInitMap.put(new Pair<String, String>("rs", "net/minecraft/potion/PotionAttackDamage"));
            mObInitMap.put(new Pair<String, String>("arj", "net/minecraft/world/gen/feature/WorldGenClay"));
            mObInitMap.put(new Pair<String, String>("ank", "net/minecraft/block/BlockSign"));
            mObInitMap.put(new Pair<String, String>("ajl", "net/minecraft/block/Block$3"));
            mObInitMap.put(new Pair<String, String>("avi", "net/minecraft/world/gen/structure/MapGenStructureIO"));
            mObInitMap.put(new Pair<String, String>("bcf", "net/minecraft/client/gui/GuiButtonLanguage"));
            mObInitMap.put(new Pair<String, String>("bge", "net/minecraft/client/gui/ServerSelectionList"));
            mObInitMap.put(new Pair<String, String>("wf", "net/minecraft/entity/passive/EntityAnimal"));
            mObInitMap.put(new Pair<String, String>("sg", "net/minecraft/entity/EntityList"));
            mObInitMap.put(new Pair<String, String>("oh", "net/minecraft/server/management/PreYggdrasilConverter$ConversionError"));
            mObInitMap.put(new Pair<String, String>("ki", "net/minecraft/network/status/client/C01PacketPing"));
            mObInitMap.put(new Pair<String, String>("gj", "net/minecraft/network/play/server/S02PacketChat"));
            mObInitMap.put(new Pair<String, String>("acb", "net/minecraft/creativetab/CreativeTabs$5"));
            mObInitMap.put(new Pair<String, String>("aga", "net/minecraft/enchantment/EnchantmentHelper$ModifierLiving"));
            mObInitMap.put(new Pair<String, String>("bsa", "net/minecraft/client/resources/data/AnimationMetadataSection"));
            mObInitMap.put(new Pair<String, String>("bkc", "net/minecraft/client/particle/EntityFireworkOverlayFX"));
            mObInitMap.put(new Pair<String, String>("bob", "net/minecraft/client/renderer/entity/RenderItem$3"));
            mObInitMap.put(new Pair<String, String>("wy", "net/minecraft/entity/boss/EntityDragonPart"));
            mObInitMap.put(new Pair<String, String>("sz", "net/minecraft/entity/EnumCreatureAttribute"));
            mObInitMap.put(new Pair<String, String>("asq", "net/minecraft/world/gen/feature/WorldGenTrees"));
            mObInitMap.put(new Pair<String, String>("aor", "net/minecraft/tileentity/TileEntity"));
            mObInitMap.put(new Pair<String, String>("aks", "net/minecraft/block/BlockEnchantmentTable"));
            mObInitMap.put(new Pair<String, String>("acu", "net/minecraft/item/ItemFishFood$FishType"));
            mObInitMap.put(new Pair<String, String>("agt", "net/minecraft/world/ChunkPosition"));
            mObInitMap.put(new Pair<String, String>("bst", "net/minecraft/client/audio/ISound"));
            mObInitMap.put(new Pair<String, String>("bou", "net/minecraft/client/renderer/entity/RenderSnowMan"));
            mObInitMap.put(new Pair<String, String>("bcx", "net/minecraft/client/multiplayer/GuiConnecting"));
            mObInitMap.put(new Pair<String, String>("bgw", "net/minecraft/client/main/Main$3"));
            mObInitMap.put(new Pair<String, String>("bkv", "net/minecraft/client/particle/EntitySmokeFX"));
            mObInitMap.put(new Pair<String, String>("tn", "net/minecraft/entity/ai/attributes/ModifiableAttributeInstance"));
            mObInitMap.put(new Pair<String, String>("po", "net/minecraft/util/IJsonSerializable"));
            mObInitMap.put(new Pair<String, String>("lp", "net/minecraft/scoreboard/ServerScoreboard"));
            mObInitMap.put(new Pair<String, String>("hq", "net/minecraft/network/play/server/S13PacketDestroyEntities"));
            mObInitMap.put(new Pair<String, String>("dr", "net/minecraft/nbt/NBTTagLong"));
            mObInitMap.put(new Pair<String, String>("adi", "net/minecraft/item/ItemBucketMilk"));
            mObInitMap.put(new Pair<String, String>("ahh", "net/minecraft/world/IWorldAccess"));
            mObInitMap.put(new Pair<String, String>("bth", "net/minecraft/client/audio/MusicTicker$MusicType"));
            mObInitMap.put(new Pair<String, String>("bpi", "net/minecraft/client/shader/ShaderManager"));
            mObInitMap.put(new Pair<String, String>("asp", "net/minecraft/world/gen/feature/WorldGenTallGrass"));
            mObInitMap.put(new Pair<String, String>("awo", "net/minecraft/world/gen/NoiseGeneratorSimplex"));
            mObInitMap.put(new Pair<String, String>("bhk", "net/minecraft/client/model/ModelEnderman"));
            mObInitMap.put(new Pair<String, String>("blj", "net/minecraft/util/MovementInputFromOptions"));
            mObInitMap.put(new Pair<String, String>("ie", "net/minecraft/network/play/server/S3CPacketUpdateScore"));
            mObInitMap.put(new Pair<String, String>("ef", "net/minecraft/nbt/JsonToNBT$Primitive"));
            mObInitMap.put(new Pair<String, String>("ag", "net/minecraft/command/server/CommandBanPlayer"));
            mObInitMap.put(new Pair<String, String>("xl", "net/minecraft/entity/item/EntityMinecart"));
            mObInitMap.put(new Pair<String, String>("atd", "net/minecraft/world/gen/structure/MapGenNetherBridge"));
            mObInitMap.put(new Pair<String, String>("ape", "net/minecraft/tileentity/TileEntityEnderChest"));
            mObInitMap.put(new Pair<String, String>("alf", "net/minecraft/block/BlockGlass"));
            mObInitMap.put(new Pair<String, String>("ahg", "net/minecraft/world/MinecraftException"));
            mObInitMap.put(new Pair<String, String>("axc", "net/minecraft/world/gen/layer/GenLayerAddMushroomIsland"));
            mObInitMap.put(new Pair<String, String>("baa", "net/minecraft/scoreboard/Score$1"));
            mObInitMap.put(new Pair<String, String>("net/minecraft/realms/DisconnectedOnlineScreen", "net/minecraft/realms/DisconnectedOnlineScreen"));
            mObInitMap.put(new Pair<String, String>("btg", "net/minecraft/client/audio/MusicTicker"));
            mObInitMap.put(new Pair<String, String>("ua", "net/minecraft/entity/ai/EntityAIMate"));
            mObInitMap.put(new Pair<String, String>("mc", "net/minecraft/server/gui/MinecraftServerGui$4"));
            mObInitMap.put(new Pair<String, String>("id", "net/minecraft/network/play/server/S3EPacketTeams"));
            mObInitMap.put(new Pair<String, String>("q", "net/minecraft/util/Facing"));
            mObInitMap.put(new Pair<String, String>("atw", "net/minecraft/world/gen/structure/StructureNetherBridgePieces$Start"));
            mObInitMap.put(new Pair<String, String>("apx", "net/minecraft/world/chunk/Chunk"));
            mObInitMap.put(new Pair<String, String>("aly", "net/minecraft/block/BlockMelon"));
            mObInitMap.put(new Pair<String, String>("ahz", "net/minecraft/world/biome/BiomeCache$Block"));
            mObInitMap.put(new Pair<String, String>("axv", "net/minecraft/world/gen/layer/GenLayerRiverMix"));
            mObInitMap.put(new Pair<String, String>("btz", "net/minecraft/client/stream/Metadata"));
            mObInitMap.put(new Pair<String, String>("ys", "net/minecraft/entity/monster/EntityZombie$GroupData"));
            mObInitMap.put(new Pair<String, String>("ut", "net/minecraft/entity/ai/EntityAIMoveTowardsRestriction"));
            mObInitMap.put(new Pair<String, String>("qu", "net/minecraft/util/Tuple"));
            mObInitMap.put(new Pair<String, String>("mv", "net/minecraft/world/WorldServer$ServerBlockEventList"));
            mObInitMap.put(new Pair<String, String>("iw", "net/minecraft/network/play/client/C11PacketEnchantItem"));
            mObInitMap.put(new Pair<String, String>("ex", "net/minecraft/network/NetworkStatistics$Tracker"));
            mObInitMap.put(new Pair<String, String>("ay", "net/minecraft/command/server/CommandListPlayers"));
            mObInitMap.put(new Pair<String, String>("aql", "net/minecraft/world/chunk/storage/AnvilChunkLoader$PendingChunk"));
            mObInitMap.put(new Pair<String, String>("amm", "net/minecraft/block/BlockOldLog"));
            mObInitMap.put(new Pair<String, String>("aap", "net/minecraft/inventory/ContainerPlayer"));
            mObInitMap.put(new Pair<String, String>("ain", "net/minecraft/world/biome/BiomeGenMutated"));
            mObInitMap.put(new Pair<String, String>("p", "net/minecraft/util/Direction"));
            mObInitMap.put(new Pair<String, String>("bun", "net/minecraft/client/stream/IStream$AuthFailureReason"));
            mObInitMap.put(new Pair<String, String>("bqo", "net/minecraft/client/resources/ResourceIndex"));
            mObInitMap.put(new Pair<String, String>("bas", "net/minecraft/client/Minecraft$12"));
            mObInitMap.put(new Pair<String, String>("ber", "net/minecraft/client/gui/IProgressMeter"));
            mObInitMap.put(new Pair<String, String>("biq", "net/minecraft/client/model/ModelDragon"));
            mObInitMap.put(new Pair<String, String>("bmp", "net/minecraft/client/renderer/tileentity/TileEntityMobSpawnerRenderer"));
            mObInitMap.put(new Pair<String, String>("ri", "net/minecraft/profiler/PlayerUsageSnooper"));
            mObInitMap.put(new Pair<String, String>("nj", "net/minecraft/network/NetHandlerPlayServer$2"));
            mObInitMap.put(new Pair<String, String>("jk", "net/minecraft/network/play/client/C0CPacketInput"));
            mObInitMap.put(new Pair<String, String>("fl", "net/minecraft/event/HoverEvent"));
            mObInitMap.put(new Pair<String, String>("bm", "net/minecraft/command/server/CommandSetBlock"));
            mObInitMap.put(new Pair<String, String>("abd", "net/minecraft/item/ItemArmor$ArmorMaterial"));
            mObInitMap.put(new Pair<String, String>("afc", "net/minecraft/item/crafting/RecipesMapExtending"));
            mObInitMap.put(new Pair<String, String>("ajb", "net/minecraft/block/BlockAnvil"));
            mObInitMap.put(new Pair<String, String>("brc", "net/minecraft/client/resources/ResourcePackRepository"));
            mObInitMap.put(new Pair<String, String>("auj", "net/minecraft/world/gen/structure/StructureStrongholdPieces$1"));
            mObInitMap.put(new Pair<String, String>("ayi", "net/minecraft/world/storage/MapData"));
            mObInitMap.put(new Pair<String, String>("bbg", "net/minecraft/util/MouseHelper"));
            mObInitMap.put(new Pair<String, String>("bff", "net/minecraft/client/gui/GuiScreenBook$NextPageButton"));
            mObInitMap.put(new Pair<String, String>("bje", "net/minecraft/client/multiplayer/PlayerControllerMP"));
            mObInitMap.put(new Pair<String, String>("bnd", "net/minecraft/client/renderer/entity/RenderBlaze"));
            mObInitMap.put(new Pair<String, String>("ca", "net/minecraft/command/CommandToggleDownfall"));
            mObInitMap.put(new Pair<String, String>("zf", "net/minecraft/entity/item/EntityFireworkRocket"));
            mObInitMap.put(new Pair<String, String>("vg", "net/minecraft/entity/ai/EntityAIRunAroundLikeCrazy"));
            mObInitMap.put(new Pair<String, String>("rh", "net/minecraft/inventory/InventoryBasic"));
            mObInitMap.put(new Pair<String, String>("aja", "net/minecraft/block/BlockAir"));
            mObInitMap.put(new Pair<String, String>("bbz", "net/minecraft/client/gui/MapItemRenderer$Instance"));
            mObInitMap.put(new Pair<String, String>("bfy", "net/minecraft/client/gui/inventory/GuiDispenser"));
            mObInitMap.put(new Pair<String, String>("bjx", "net/minecraft/client/particle/EntityCritFX"));
            mObInitMap.put(new Pair<String, String>("zy", "net/minecraft/inventory/ContainerBeacon$BeaconSlot"));
            mObInitMap.put(new Pair<String, String>("vz", "net/minecraft/village/Village"));
            mObInitMap.put(new Pair<String, String>("arr", "net/minecraft/world/gen/feature/WorldGenGlowStone2"));
            mObInitMap.put(new Pair<String, String>("ans", "net/minecraft/block/BlockStairs"));
            mObInitMap.put(new Pair<String, String>("abv", "net/minecraft/creativetab/CreativeTabs$10"));
            mObInitMap.put(new Pair<String, String>("afu", "net/minecraft/enchantment/EnumEnchantmentType"));
            mObInitMap.put(new Pair<String, String>("ajt", "net/minecraft/block/BlockCactus"));
            mObInitMap.put(new Pair<String, String>("avq", "net/minecraft/world/gen/structure/StructureVillagePieces$House1"));
            mObInitMap.put(new Pair<String, String>("azp", "net/minecraft/world/storage/IPlayerFileData"));
            mObInitMap.put(new Pair<String, String>("bru", "net/minecraft/client/resources/data/IMetadataSection"));
            mObInitMap.put(new Pair<String, String>("bjw", "net/minecraft/client/particle/EntityCrit2FX"));
            mObInitMap.put(new Pair<String, String>("bnv", "net/minecraft/client/renderer/entity/RenderHorse"));
            mObInitMap.put(new Pair<String, String>("wn", "net/minecraft/entity/passive/EntityOcelot"));
            mObInitMap.put(new Pair<String, String>("op", "net/minecraft/server/management/UserListBans"));
            mObInitMap.put(new Pair<String, String>("kq", "net/minecraft/init/Bootstrap$13"));
            mObInitMap.put(new Pair<String, String>("gr", "net/minecraft/network/play/server/S3FPacketCustomPayload"));
            mObInitMap.put(new Pair<String, String>("cs", "net/minecraft/util/IObjectIntIterable"));
            mObInitMap.put(new Pair<String, String>("asf", "net/minecraft/world/gen/feature/WorldGenTaiga1"));
            mObInitMap.put(new Pair<String, String>("aog", "net/minecraft/block/BlockTripWireHook"));
            mObInitMap.put(new Pair<String, String>("akh", "net/minecraft/block/BlockDeadBush"));
            mObInitMap.put(new Pair<String, String>("acj", "net/minecraft/item/ItemDye"));
            mObInitMap.put(new Pair<String, String>("agi", "net/minecraft/enchantment/EnchantmentProtection"));
            mObInitMap.put(new Pair<String, String>("bsi", "net/minecraft/client/resources/data/TextureMetadataSection"));
            mObInitMap.put(new Pair<String, String>("bcm", "net/minecraft/client/gui/GuiSlot"));
            mObInitMap.put(new Pair<String, String>("bgl", "net/minecraft/client/gui/GuiResourcePackSelected"));
            mObInitMap.put(new Pair<String, String>("bkk", "net/minecraft/client/particle/EntityLavaFX"));
            mObInitMap.put(new Pair<String, String>("boj", "net/minecraft/client/renderer/entity/RenderMinecartMobSpawner"));
            mObInitMap.put(new Pair<String, String>("tc", "net/minecraft/entity/item/EntityPainting$EnumArt"));
            mObInitMap.put(new Pair<String, String>("pd", "net/minecraft/stats/IStatStringFormat"));
            mObInitMap.put(new Pair<String, String>("le", "net/minecraft/command/ServerCommand"));
            mObInitMap.put(new Pair<String, String>("hf", "net/minecraft/network/play/server/S14PacketEntity"));
            mObInitMap.put(new Pair<String, String>("dg", "net/minecraft/nbt/NBTTagByte"));
            mObInitMap.put(new Pair<String, String>("ase", "net/minecraft/world/gen/feature/WorldGenMinable"));
            mObInitMap.put(new Pair<String, String>("awd", "net/minecraft/world/gen/structure/StructureVillagePieces$Village"));
            mObInitMap.put(new Pair<String, String>("bda", "net/minecraft/client/gui/GuiCreateFlatWorld$Details"));
            mObInitMap.put(new Pair<String, String>("hy", "net/minecraft/network/play/server/S12PacketEntityVelocity"));
            mObInitMap.put(new Pair<String, String>("dz", "net/minecraft/nbt/NBTBase$NBTPrimitive"));
            mObInitMap.put(new Pair<String, String>("xa", "net/minecraft/entity/boss/EntityDragon"));
            mObInitMap.put(new Pair<String, String>("tb", "net/minecraft/entity/item/EntityPainting"));
            mObInitMap.put(new Pair<String, String>("asx", "net/minecraft/world/gen/structure/StructureMineshaftPieces"));
            mObInitMap.put(new Pair<String, String>("aoy", "net/minecraft/tileentity/TileEntityCommandBlock$1"));
            mObInitMap.put(new Pair<String, String>("akz", "net/minecraft/block/BlockFence"));
            mObInitMap.put(new Pair<String, String>("aww", "net/minecraft/block/material/MaterialPortal"));
            mObInitMap.put(new Pair<String, String>("bdt", "net/minecraft/client/gui/GuiScreenWorking"));
            mObInitMap.put(new Pair<String, String>("bhs", "net/minecraft/client/model/ModelHorse"));
            mObInitMap.put(new Pair<String, String>("xt", "net/minecraft/entity/ai/EntityMinecartMobSpawner"));
            mObInitMap.put(new Pair<String, String>("tu", "net/minecraft/entity/ai/EntityLookHelper"));
            mObInitMap.put(new Pair<String, String>("pv", "net/minecraft/util/HttpUtil"));
            mObInitMap.put(new Pair<String, String>("lw", "net/minecraft/server/dedicated/DedicatedServer$3"));
            mObInitMap.put(new Pair<String, String>("hx", "net/minecraft/network/play/server/S1BPacketEntityAttach"));
            mObInitMap.put(new Pair<String, String>("f", "net/minecraft/crash/CrashReport$4"));
            mObInitMap.put(new Pair<String, String>("atl", "net/minecraft/world/gen/structure/StructureNetherBridgePieces$Entrance"));
            mObInitMap.put(new Pair<String, String>("apm", "net/minecraft/tileentity/TileEntitySign"));
            mObInitMap.put(new Pair<String, String>("aln", "net/minecraft/block/BlockHopper"));
            mObInitMap.put(new Pair<String, String>("adp", "net/minecraft/item/ItemPotion"));
            mObInitMap.put(new Pair<String, String>("aho", "net/minecraft/world/SpawnerAnimals"));
            mObInitMap.put(new Pair<String, String>("bai", "net/minecraft/stats/ObjectiveStat"));
            mObInitMap.put(new Pair<String, String>("bto", "net/minecraft/client/audio/SoundEventAccessorComposite"));
            mObInitMap.put(new Pair<String, String>("bpp", "net/minecraft/client/renderer/texture/AbstractTexture"));
            mObInitMap.put(new Pair<String, String>("blq", "net/minecraft/client/renderer/EntitySorter"));
            mObInitMap.put(new Pair<String, String>("yh", "net/minecraft/entity/monster/EntityPigZombie"));
            mObInitMap.put(new Pair<String, String>("ui", "net/minecraft/entity/ai/EntityAIBase"));
            mObInitMap.put(new Pair<String, String>("qj", "net/minecraft/profiler/Profiler$Result"));
            mObInitMap.put(new Pair<String, String>("net/minecraft/realms/RealmsServerStatusPinger", "net/minecraft/realms/RealmsServerStatusPinger"));
            mObInitMap.put(new Pair<String, String>("mk", "net/minecraft/world/demo/DemoWorldServer"));
            mObInitMap.put(new Pair<String, String>("il", "net/minecraft/network/play/server/S20PacketEntityProperties"));
            mObInitMap.put(new Pair<String, String>("em", "net/minecraft/network/NetworkManager$3"));
            mObInitMap.put(new Pair<String, String>("an", "net/minecraft/command/server/CommandEmote"));
            mObInitMap.put(new Pair<String, String>("aqa", "net/minecraft/world/chunk/storage/NibbleArrayReader"));
            mObInitMap.put(new Pair<String, String>("amb", "net/minecraft/block/BlockSilverfish"));
            mObInitMap.put(new Pair<String, String>("aed", "net/minecraft/item/ItemSnowball"));
            mObInitMap.put(new Pair<String, String>("aae", "net/minecraft/inventory/InventoryCrafting"));
            mObInitMap.put(new Pair<String, String>("aic", "net/minecraft/world/biome/BiomeGenDesert"));
            mObInitMap.put(new Pair<String, String>("e", "net/minecraft/crash/CrashReport$3"));
            mObInitMap.put(new Pair<String, String>("buc", "net/minecraft/client/stream/BroadcastController$BroadcastState"));
            mObInitMap.put(new Pair<String, String>("bqd", "net/minecraft/client/renderer/texture/TextureAtlasSprite"));
            mObInitMap.put(new Pair<String, String>("bah", "net/minecraft/scoreboard/IScoreObjectiveCriteria"));
            mObInitMap.put(new Pair<String, String>("beg", "net/minecraft/client/gui/GuiWinGame"));
            mObInitMap.put(new Pair<String, String>("bif", "net/minecraft/client/model/ModelSnowMan"));
            mObInitMap.put(new Pair<String, String>("bme", "net/minecraft/client/util/QuadComparator"));
            mObInitMap.put(new Pair<String, String>("fa", "net/minecraft/util/MessageSerializer"));
            mObInitMap.put(new Pair<String, String>("bb", "net/minecraft/command/server/CommandNetstat"));
            mObInitMap.put(new Pair<String, String>("aew", "net/minecraft/item/crafting/RecipeBookCloning"));
            mObInitMap.put(new Pair<String, String>("aax", "net/minecraft/inventory/SlotCrafting"));
            mObInitMap.put(new Pair<String, String>("aiv", "net/minecraft/world/biome/BiomeGenSwamp"));
            mObInitMap.put(new Pair<String, String>("x", "net/minecraft/command/IAdminCommand"));
            mObInitMap.put(new Pair<String, String>("bqw", "net/minecraft/client/resources/IResource"));
            mObInitMap.put(new Pair<String, String>("bez", "net/minecraft/client/gui/inventory/GuiBeacon"));
            mObInitMap.put(new Pair<String, String>("biy", "net/minecraft/client/model/TextureOffset"));
            mObInitMap.put(new Pair<String, String>("bmx", "net/minecraft/client/renderer/culling/Frustrum"));
            mObInitMap.put(new Pair<String, String>("js", "net/minecraft/network/login/server/S02PacketLoginSuccess"));
            mObInitMap.put(new Pair<String, String>("ft", "net/minecraft/network/Packet"));
            mObInitMap.put(new Pair<String, String>("bu", "net/minecraft/command/server/CommandSummon"));
            mObInitMap.put(new Pair<String, String>("yz", "net/minecraft/entity/player/EntityPlayer"));
            mObInitMap.put(new Pair<String, String>("aqs", "net/minecraft/world/gen/MapGenRavine"));
            mObInitMap.put(new Pair<String, String>("amt", "net/minecraft/block/BlockRailPowered"));
            mObInitMap.put(new Pair<String, String>("aiu", "net/minecraft/world/biome/BiomeGenStoneBeach"));
            mObInitMap.put(new Pair<String, String>("aur", "net/minecraft/world/gen/structure/StructureStrongholdPieces$PieceWeight"));
            mObInitMap.put(new Pair<String, String>("ayq", "net/minecraft/world/storage/SaveHandler"));
            mObInitMap.put(new Pair<String, String>("bbo", "net/minecraft/client/LoadingScreenRenderer"));
            mObInitMap.put(new Pair<String, String>("bfn", "net/minecraft/client/gui/inventory/GuiContainerCreative$CreativeSlot"));
            mObInitMap.put(new Pair<String, String>("bjm", "net/minecraft/client/multiplayer/ServerAddress"));
            mObInitMap.put(new Pair<String, String>("buu", "net/minecraft/client/renderer/OpenGlHelper"));
            mObInitMap.put(new Pair<String, String>("zn", "net/minecraft/entity/item/EntityExpBottle"));
            mObInitMap.put(new Pair<String, String>("vo", "net/minecraft/entity/ai/EntityAINearestAttackableTarget"));
            mObInitMap.put(new Pair<String, String>("rp", "net/minecraft/util/EntityDamageSource"));
            mObInitMap.put(new Pair<String, String>("nq", "net/minecraft/server/network/NetHandlerStatusServer"));
            mObInitMap.put(new Pair<String, String>("jr", "net/minecraft/network/login/INetHandlerLoginClient"));
            mObInitMap.put(new Pair<String, String>("arg", "net/minecraft/world/gen/feature/WorldGeneratorBonusChest"));
            mObInitMap.put(new Pair<String, String>("anh", "net/minecraft/block/BlockSand"));
            mObInitMap.put(new Pair<String, String>("abk", "net/minecraft/item/ItemBook"));
            mObInitMap.put(new Pair<String, String>("afj", "net/minecraft/item/crafting/RecipesCrafting"));
            mObInitMap.put(new Pair<String, String>("aji", "net/minecraft/block/Block"));
            mObInitMap.put(new Pair<String, String>("avf", "net/minecraft/world/gen/structure/MapGenStructure$1"));
            mObInitMap.put(new Pair<String, String>("aze", "net/minecraft/world/storage/ISaveFormat"));
            mObInitMap.put(new Pair<String, String>("brj", "net/minecraft/client/resources/SkinManager"));
            mObInitMap.put(new Pair<String, String>("bjl", "net/minecraft/client/gui/GuiPlayerInfo"));
            mObInitMap.put(new Pair<String, String>("bnk", "net/minecraft/client/renderer/tileentity/RenderEnderCrystal"));
            mObInitMap.put(new Pair<String, String>("wc", "net/minecraft/village/VillageCollection"));
            mObInitMap.put(new Pair<String, String>("sd", "net/minecraft/entity/Entity$SwitchEnumEntitySize"));
            mObInitMap.put(new Pair<String, String>("oe", "net/minecraft/server/management/PreYggdrasilConverter$5"));
            mObInitMap.put(new Pair<String, String>("kf", "net/minecraft/network/ServerStatusResponse$MinecraftProtocolVersionIdentifier"));
            mObInitMap.put(new Pair<String, String>("gg", "net/minecraft/network/play/server/S24PacketBlockAction"));
            mObInitMap.put(new Pair<String, String>("ch", "net/minecraft/command/CommandNotFoundException"));
            mObInitMap.put(new Pair<String, String>("arz", "net/minecraft/world/gen/feature/WorldGenMegaJungle"));
            mObInitMap.put(new Pair<String, String>("bcb", "net/minecraft/client/gui/GuiButton"));
            mObInitMap.put(new Pair<String, String>("bga", "net/minecraft/client/gui/ServerListEntryLanScan"));
            mObInitMap.put(new Pair<String, String>("sw", "net/minecraft/entity/EntityLiving"));
            mObInitMap.put(new Pair<String, String>("ox", "net/minecraft/network/rcon/RConThreadQuery"));
            mObInitMap.put(new Pair<String, String>("ky", "net/minecraft/init/Bootstrap$7"));
            mObInitMap.put(new Pair<String, String>("gz", "net/minecraft/network/play/server/S26PacketMapChunkBulk"));
            mObInitMap.put(new Pair<String, String>("akp", "net/minecraft/block/BlockDragonEgg"));
            mObInitMap.put(new Pair<String, String>("acr", "net/minecraft/item/ItemFireworkCharge"));
            mObInitMap.put(new Pair<String, String>("agq", "net/minecraft/tileentity/MobSpawnerBaseLogic"));
            mObInitMap.put(new Pair<String, String>("bsq", "net/minecraft/client/audio/SoundList$SoundEntry"));
            mObInitMap.put(new Pair<String, String>("bor", "net/minecraft/client/renderer/entity/RenderSilverfish"));
            mObInitMap.put(new Pair<String, String>("avx", "net/minecraft/world/gen/structure/StructureVillagePieces$WoodHut"));
            mObInitMap.put(new Pair<String, String>("azw", "net/minecraft/util/Vec3"));
            mObInitMap.put(new Pair<String, String>("bcu", "net/minecraft/client/gui/GuiConfirmOpenLink"));
            mObInitMap.put(new Pair<String, String>("bgt", "net/minecraft/client/main/Main$1"));
            mObInitMap.put(new Pair<String, String>("bks", "net/minecraft/client/particle/EntityCloudFX"));
            mObInitMap.put(new Pair<String, String>("wu", "net/minecraft/entity/passive/EntityWaterMob"));
            mObInitMap.put(new Pair<String, String>("sv", "net/minecraft/entity/EntityLivingBase"));
            mObInitMap.put(new Pair<String, String>("asm", "net/minecraft/world/gen/feature/WorldGenLiquids"));
            mObInitMap.put(new Pair<String, String>("aon", "net/minecraft/block/BlockButtonWood"));
            mObInitMap.put(new Pair<String, String>("ako", "net/minecraft/block/BlockDoublePlant"));
            mObInitMap.put(new Pair<String, String>("awl", "net/minecraft/world/gen/NoiseGeneratorPerlin"));
            mObInitMap.put(new Pair<String, String>("bdi", "net/minecraft/client/gui/GuiSleepMP"));
            mObInitMap.put(new Pair<String, String>("bhh", "net/minecraft/client/model/ModelChicken"));
            mObInitMap.put(new Pair<String, String>("blg", "net/minecraft/client/entity/AbstractClientPlayer"));
            mObInitMap.put(new Pair<String, String>("xi", "net/minecraft/entity/item/EntityBoat"));
            mObInitMap.put(new Pair<String, String>("tj", "net/minecraft/entity/ai/attributes/AttributeModifier"));
            mObInitMap.put(new Pair<String, String>("pk", "net/minecraft/stats/StatBase$3"));
            mObInitMap.put(new Pair<String, String>("ll", "net/minecraft/server/MinecraftServer$5"));
            mObInitMap.put(new Pair<String, String>("ata", "net/minecraft/world/gen/structure/StructureMineshaftPieces$Room"));
            mObInitMap.put(new Pair<String, String>("apb", "net/minecraft/tileentity/TileEntityDispenser"));
            mObInitMap.put(new Pair<String, String>("alc", "net/minecraft/block/BlockFlower"));
            mObInitMap.put(new Pair<String, String>("ade", "net/minecraft/init/Items"));
            mObInitMap.put(new Pair<String, String>("ahd", "net/minecraft/world/World$2"));
            mObInitMap.put(new Pair<String, String>("btd", "net/minecraft/client/network/LanServerDetector$LanServerList"));
            mObInitMap.put(new Pair<String, String>("bpe", "net/minecraft/client/renderer/entity/RenderWolf"));
            mObInitMap.put(new Pair<String, String>("blf", "net/minecraft/client/particle/EntityRainFX"));
            mObInitMap.put(new Pair<String, String>("ia", "net/minecraft/network/play/server/S1FPacketSetExperience"));
            mObInitMap.put(new Pair<String, String>("eb", "net/minecraft/nbt/JsonToNBT"));
            mObInitMap.put(new Pair<String, String>("ac", "net/minecraft/command/ICommandSender"));
            mObInitMap.put(new Pair<String, String>("att", "net/minecraft/world/gen/structure/StructureNetherBridgePieces$PieceWeight"));
            mObInitMap.put(new Pair<String, String>("apu", "net/minecraft/world/chunk/IChunkProvider"));
            mObInitMap.put(new Pair<String, String>("alv", "net/minecraft/block/BlockLever"));
            mObInitMap.put(new Pair<String, String>("adx", "net/minecraft/item/ItemShears"));
            mObInitMap.put(new Pair<String, String>("ahw", "net/minecraft/world/biome/BiomeGenBase$TempCategory"));
            mObInitMap.put(new Pair<String, String>("btw", "net/minecraft/client/stream/MetadataAchievement"));
            mObInitMap.put(new Pair<String, String>("bpx", "net/minecraft/client/renderer/texture/Stitcher$Slot"));
            mObInitMap.put(new Pair<String, String>("bhz", "net/minecraft/client/model/ModelSign"));
            mObInitMap.put(new Pair<String, String>("bly", "net/minecraft/client/renderer/ItemRenderer"));
            mObInitMap.put(new Pair<String, String>("uq", "net/minecraft/entity/ai/EntityAIAttackOnCollide"));
            mObInitMap.put(new Pair<String, String>("ms", "net/minecraft/world/gen/ChunkProviderServer"));
            mObInitMap.put(new Pair<String, String>("it", "net/minecraft/network/play/client/C16PacketClientStatus$EnumState"));
            mObInitMap.put(new Pair<String, String>("eu", "net/minecraft/network/NetworkStatistics"));
            mObInitMap.put(new Pair<String, String>("av", "net/minecraft/command/CommandServerKick"));
            mObInitMap.put(new Pair<String, String>("ael", "net/minecraft/item/ItemWritableBook"));
            mObInitMap.put(new Pair<String, String>("aam", "net/minecraft/inventory/ContainerHorseInventory"));
            mObInitMap.put(new Pair<String, String>("aik", "net/minecraft/world/biome/BiomeGenJungle"));
            mObInitMap.put(new Pair<String, String>("m", "net/minecraft/crash/CrashReportCategory$2"));
            mObInitMap.put(new Pair<String, String>("buk", "net/minecraft/client/stream/IngestServerTester$IngestTestListener"));
            mObInitMap.put(new Pair<String, String>("bql", "net/minecraft/client/renderer/texture/TextureClock"));
            mObInitMap.put(new Pair<String, String>("ats", "net/minecraft/world/gen/structure/StructureNetherBridgePieces$Piece"));
            mObInitMap.put(new Pair<String, String>("axr", "net/minecraft/world/gen/layer/GenLayerHills"));
            mObInitMap.put(new Pair<String, String>("bap", "net/minecraft/client/Minecraft$1"));
            mObInitMap.put(new Pair<String, String>("beo", "net/minecraft/client/gui/achievement/GuiStats$StatsItem$1"));
            mObInitMap.put(new Pair<String, String>("bin", "net/minecraft/client/model/ModelWither"));
            mObInitMap.put(new Pair<String, String>("bmm", "net/minecraft/client/renderer/tileentity/TileEntityChestRenderer"));
            mObInitMap.put(new Pair<String, String>("jh", "net/minecraft/network/play/client/C13PacketPlayerAbilities"));
            mObInitMap.put(new Pair<String, String>("fi", "net/minecraft/event/ClickEvent$Action"));
            mObInitMap.put(new Pair<String, String>("bj", "net/minecraft/command/server/CommandSaveOn"));
            mObInitMap.put(new Pair<String, String>("yo", "net/minecraft/entity/monster/EntitySpider$GroupData"));
            mObInitMap.put(new Pair<String, String>("up", "net/minecraft/entity/ai/EntityAIVillagerMate"));
            mObInitMap.put(new Pair<String, String>("aqh", "net/minecraft/world/chunk/storage/RegionFile"));
            mObInitMap.put(new Pair<String, String>("ami", "net/minecraft/block/BlockNewLog"));
            mObInitMap.put(new Pair<String, String>("aij", "net/minecraft/world/biome/BiomeGenSnow"));
            mObInitMap.put(new Pair<String, String>("aug", "net/minecraft/world/gen/structure/MapGenStronghold"));
            mObInitMap.put(new Pair<String, String>("ayf", "net/minecraft/pathfinding/PathEntity"));
            mObInitMap.put(new Pair<String, String>("bbd", "net/minecraft/client/Minecraft$7"));
            mObInitMap.put(new Pair<String, String>("bfc", "net/minecraft/client/gui/inventory/GuiBeacon$PowerButton"));
            mObInitMap.put(new Pair<String, String>("bjb", "net/minecraft/client/network/NetHandlerPlayClient"));
            mObInitMap.put(new Pair<String, String>("buj", "net/minecraft/client/stream/IngestServerTester$SwitchStatType"));
            mObInitMap.put(new Pair<String, String>("zc", "net/minecraft/entity/projectile/EntityArrow"));
            mObInitMap.put(new Pair<String, String>("vd", "net/minecraft/entity/ai/EntityAIArrowAttack"));
            mObInitMap.put(new Pair<String, String>("re", "net/minecraft/client/renderer/IconFlipped"));
            mObInitMap.put(new Pair<String, String>("nf", "net/minecraft/network/NetworkSystem$3"));
            mObInitMap.put(new Pair<String, String>("jg", "net/minecraft/network/play/client/C03PacketPlayer$C05PacketPlayerLook"));
            mObInitMap.put(new Pair<String, String>("auz", "net/minecraft/world/gen/structure/StructureStrongholdPieces$Stairs2"));
            mObInitMap.put(new Pair<String, String>("ayy", "net/minecraft/world/storage/WorldInfo$6"));
            mObInitMap.put(new Pair<String, String>("bja", "net/minecraft/client/network/NetHandlerLoginClient$1"));
            mObInitMap.put(new Pair<String, String>("net/minecraft/realms/RealmsSharedConstants", "net/minecraft/realms/RealmsSharedConstants"));
            mObInitMap.put(new Pair<String, String>("zv", "net/minecraft/inventory/ContainerRepair$1"));
            mObInitMap.put(new Pair<String, String>("vw", "net/minecraft/entity/ai/EntitySenses"));
            mObInitMap.put(new Pair<String, String>("rx", "net/minecraft/entity/EntityAgeable"));
            mObInitMap.put(new Pair<String, String>("ny", "net/minecraft/server/management/IPBanEntry"));
            mObInitMap.put(new Pair<String, String>("jz", "net/minecraft/network/status/server/S01PacketPong"));
            mObInitMap.put(new Pair<String, String>("aro", "net/minecraft/world/gen/feature/WorldGenFlowers"));
            mObInitMap.put(new Pair<String, String>("anp", "net/minecraft/block/BlockSponge"));
            mObInitMap.put(new Pair<String, String>("abs", "net/minecraft/item/ItemMapBase"));
            mObInitMap.put(new Pair<String, String>("afr", "net/minecraft/enchantment/EnchantmentDurability"));
            mObInitMap.put(new Pair<String, String>("ajq", "net/minecraft/block/BlockBrewingStand"));
            mObInitMap.put(new Pair<String, String>("avn", "net/minecraft/world/gen/structure/MapGenVillage"));
            mObInitMap.put(new Pair<String, String>("brr", "net/minecraft/client/resources/LanguageManager"));
            mObInitMap.put(new Pair<String, String>("bbv", "net/minecraft/client/gui/GuiIngame"));
            mObInitMap.put(new Pair<String, String>("bfu", "net/minecraft/client/gui/inventory/GuiInventory"));
            mObInitMap.put(new Pair<String, String>("bjt", "net/minecraft/client/network/OldServerPinger$2$1"));
            mObInitMap.put(new Pair<String, String>("bns", "net/minecraft/client/renderer/entity/RenderFish"));
            mObInitMap.put(new Pair<String, String>("sl", "net/minecraft/command/IEntitySelector$2"));
            mObInitMap.put(new Pair<String, String>("om", "net/minecraft/server/management/UserList"));
            mObInitMap.put(new Pair<String, String>("kn", "net/minecraft/init/Bootstrap$10"));
            mObInitMap.put(new Pair<String, String>("go", "net/minecraft/network/play/server/S30PacketWindowItems"));
            mObInitMap.put(new Pair<String, String>("cp", "net/minecraft/dispenser/IBehaviorDispenseItem"));
            mObInitMap.put(new Pair<String, String>("ake", "net/minecraft/block/BlockWorkbench"));
            mObInitMap.put(new Pair<String, String>("acg", "net/minecraft/item/ItemTool"));
            mObInitMap.put(new Pair<String, String>("agf", "net/minecraft/enchantment/EnchantmentKnockback"));
            mObInitMap.put(new Pair<String, String>("bsf", "net/minecraft/client/resources/data/LanguageMetadataSectionSerializer"));
            mObInitMap.put(new Pair<String, String>("avm", "net/minecraft/world/gen/structure/StructureStart"));
            mObInitMap.put(new Pair<String, String>("bcj", "net/minecraft/client/gui/GuiOptionButton"));
            mObInitMap.put(new Pair<String, String>("bgi", "net/minecraft/client/resources/ResourcePackListEntryFound"));
            mObInitMap.put(new Pair<String, String>("bkh", "net/minecraft/client/particle/EntityHeartFX"));
            mObInitMap.put(new Pair<String, String>("bog", "net/minecraft/client/renderer/entity/RenderLightningBolt"));
            mObInitMap.put(new Pair<String, String>("lb", "net/minecraft/client/util/JsonException"));
            mObInitMap.put(new Pair<String, String>("hc", "net/minecraft/network/play/server/S29PacketSoundEffect"));
            mObInitMap.put(new Pair<String, String>("dd", "net/minecraft/util/StatCollector"));
            mObInitMap.put(new Pair<String, String>("wj", "net/minecraft/entity/passive/EntityHorse$1"));
            mObInitMap.put(new Pair<String, String>("asb", "net/minecraft/world/gen/feature/WorldGenHugeTrees"));
            mObInitMap.put(new Pair<String, String>("aoc", "net/minecraft/block/BlockTorch"));
            mObInitMap.put(new Pair<String, String>("awa", "net/minecraft/world/gen/structure/StructureVillagePieces$Start"));
            mObInitMap.put(new Pair<String, String>("la", "net/minecraft/init/Bootstrap$9"));
            mObInitMap.put(new Pair<String, String>("aov", "net/minecraft/tileentity/TileEntityBrewingStand"));
            mObInitMap.put(new Pair<String, String>("akw", "net/minecraft/block/ITileEntityProvider"));
            mObInitMap.put(new Pair<String, String>("acy", "net/minecraft/item/ItemAppleGold"));
            mObInitMap.put(new Pair<String, String>("agx", "net/minecraft/world/ColorizerFoliage"));
            mObInitMap.put(new Pair<String, String>("awt", "net/minecraft/block/material/Material"));
            mObInitMap.put(new Pair<String, String>("bsx", "net/minecraft/server/integrated/IntegratedServer"));
            mObInitMap.put(new Pair<String, String>("boy", "net/minecraft/client/renderer/entity/RenderTNTPrimed"));
            mObInitMap.put(new Pair<String, String>("bkz", "net/minecraft/client/particle/EntitySuspendFX"));
            mObInitMap.put(new Pair<String, String>("xq", "net/minecraft/entity/item/EntityMinecartFurnace"));
            mObInitMap.put(new Pair<String, String>("tr", "net/minecraft/entity/EntityBodyHelper"));
            mObInitMap.put(new Pair<String, String>("lt", "net/minecraft/server/dedicated/DedicatedServer"));
            mObInitMap.put(new Pair<String, String>("hu", "net/minecraft/network/play/server/S09PacketHeldItemChange"));
            mObInitMap.put(new Pair<String, String>("dv", "net/minecraft/nbt/NBTUtil"));
            mObInitMap.put(new Pair<String, String>("ati", "net/minecraft/world/gen/structure/StructureNetherBridgePieces$Straight"));
            mObInitMap.put(new Pair<String, String>("apj", "net/minecraft/tileentity/TileEntityMobSpawner"));
            mObInitMap.put(new Pair<String, String>("alk", "net/minecraft/block/BlockBreakable"));
            mObInitMap.put(new Pair<String, String>("adm", "net/minecraft/item/ItemNameTag"));
            mObInitMap.put(new Pair<String, String>("ahl", "net/minecraft/world/IBlockAccess"));
            mObInitMap.put(new Pair<String, String>("btl", "net/minecraft/client/audio/SoundManager$2"));
            mObInitMap.put(new Pair<String, String>("bpm", "net/minecraft/client/shader/ShaderLoader$ShaderType"));
            mObInitMap.put(new Pair<String, String>("bdp", "net/minecraft/client/gui/GuiIngameMenu"));
            mObInitMap.put(new Pair<String, String>("bho", "net/minecraft/client/model/ModelMagmaCube"));
            mObInitMap.put(new Pair<String, String>("bln", "net/minecraft/entity/boss/BossStatus"));
            mObInitMap.put(new Pair<String, String>("uf", "net/minecraft/entity/ai/EntityAISwimming"));
            mObInitMap.put(new Pair<String, String>("qg", "net/minecraft/util/EnumTypeAdapterFactory$1"));
            mObInitMap.put(new Pair<String, String>("ii", "net/minecraft/network/play/server/S33PacketUpdateSign"));
            mObInitMap.put(new Pair<String, String>("ej", "net/minecraft/network/NetworkManager"));
            mObInitMap.put(new Pair<String, String>("ak", "net/minecraft/command/CommandDebug"));
            mObInitMap.put(new Pair<String, String>("aea", "net/minecraft/item/ItemSimpleFoiled"));
            mObInitMap.put(new Pair<String, String>("aab", "net/minecraft/inventory/ContainerBrewingStand$Potion"));
            mObInitMap.put(new Pair<String, String>("b", "net/minecraft/crash/CrashReport"));
            mObInitMap.put(new Pair<String, String>("bqa", "net/minecraft/client/renderer/texture/TextureMap$1"));
            mObInitMap.put(new Pair<String, String>("ath", "net/minecraft/world/gen/structure/StructureNetherBridgePieces$End"));
            mObInitMap.put(new Pair<String, String>("bae", "net/minecraft/scoreboard/Team"));
            mObInitMap.put(new Pair<String, String>("bed", "net/minecraft/client/gui/GuiScreenOptionsSounds$Button"));
            mObInitMap.put(new Pair<String, String>("bic", "net/minecraft/client/model/ModelSkeleton"));
            mObInitMap.put(new Pair<String, String>("bmb", "net/minecraft/client/renderer/RenderGlobal$1"));
            mObInitMap.put(new Pair<String, String>("yd", "net/minecraft/entity/monster/EntityGhast"));
            mObInitMap.put(new Pair<String, String>("ue", "net/minecraft/entity/ai/EntityAIFleeSun"));
            mObInitMap.put(new Pair<String, String>("aau", "net/minecraft/inventory/SlotMerchantResult"));
            mObInitMap.put(new Pair<String, String>("u", "net/minecraft/util/Util"));
            mObInitMap.put(new Pair<String, String>("bax", "net/minecraft/client/Minecraft$SwitchMovingObjectType"));
            mObInitMap.put(new Pair<String, String>("bew", "net/minecraft/client/gui/GuiControls"));
            mObInitMap.put(new Pair<String, String>("yw", "net/minecraft/entity/player/PlayerCapabilities"));
            mObInitMap.put(new Pair<String, String>("ux", "net/minecraft/entity/ai/EntityAILookAtVillager"));
            mObInitMap.put(new Pair<String, String>("mz", "net/minecraft/network/PingResponseHandler"));
            mObInitMap.put(new Pair<String, String>("aqp", "net/minecraft/world/WorldProviderHell"));
            mObInitMap.put(new Pair<String, String>("amq", "net/minecraft/block/BlockPortal$Size"));
            mObInitMap.put(new Pair<String, String>("aat", "net/minecraft/inventory/ContainerMerchant"));
            mObInitMap.put(new Pair<String, String>("air", "net/minecraft/world/biome/BiomeGenRiver"));
            mObInitMap.put(new Pair<String, String>("auo", "net/minecraft/world/gen/structure/StructureStrongholdPieces$Crossing"));
            mObInitMap.put(new Pair<String, String>("ayn", "net/minecraft/world/chunk/storage/AnvilSaveConverter"));
            mObInitMap.put(new Pair<String, String>("bbl", "net/minecraft/client/settings/GameSettings$SwitchOptions"));
            mObInitMap.put(new Pair<String, String>("bur", "net/minecraft/client/stream/NullStream"));
            mObInitMap.put(new Pair<String, String>("bqs", "net/minecraft/client/resources/FolderResourcePack"));
            mObInitMap.put(new Pair<String, String>("bmt", "net/minecraft/client/renderer/tileentity/RenderEndPortal"));
            mObInitMap.put(new Pair<String, String>("zk", "net/minecraft/entity/projectile/EntityThrowable"));
            mObInitMap.put(new Pair<String, String>("vl", "net/minecraft/entity/ai/EntityAITradePlayer"));
            mObInitMap.put(new Pair<String, String>("rm", "net/minecraft/util/CombatEntry"));
            mObInitMap.put(new Pair<String, String>("nn", "net/minecraft/server/network/NetHandlerLoginServer"));
            mObInitMap.put(new Pair<String, String>("jo", "net/minecraft/network/play/client/C08PacketPlayerBlockPlacement"));
            mObInitMap.put(new Pair<String, String>("fp", "net/minecraft/util/ChatStyle$Serializer"));
            mObInitMap.put(new Pair<String, String>("bq", "net/minecraft/command/CommandShowSeed"));
            mObInitMap.put(new Pair<String, String>("ard", "net/minecraft/world/gen/feature/WorldGenBigTree"));
            mObInitMap.put(new Pair<String, String>("ane", "net/minecraft/block/BlockReed"));
            mObInitMap.put(new Pair<String, String>("abh", "net/minecraft/item/ItemBlock"));
            mObInitMap.put(new Pair<String, String>("afg", "net/minecraft/item/crafting/IRecipe"));
            mObInitMap.put(new Pair<String, String>("ajf", "net/minecraft/block/BlockRailBase$Rail"));
            mObInitMap.put(new Pair<String, String>("avc", "net/minecraft/world/gen/structure/StructureStrongholdPieces$Stronghold"));
            mObInitMap.put(new Pair<String, String>("brg", "net/minecraft/client/resources/SimpleReloadableResourceManager"));
            mObInitMap.put(new Pair<String, String>("bbk", "net/minecraft/client/settings/GameSettings$1"));
            mObInitMap.put(new Pair<String, String>("bfj", "net/minecraft/client/gui/inventory/GuiCrafting"));
            mObInitMap.put(new Pair<String, String>("bji", "net/minecraft/client/multiplayer/WorldClient$3"));
            mObInitMap.put(new Pair<String, String>("bnh", "net/minecraft/client/renderer/entity/RenderCow"));
            mObInitMap.put(new Pair<String, String>("sa", "net/minecraft/entity/Entity"));
            mObInitMap.put(new Pair<String, String>("ob", "net/minecraft/server/management/PreYggdrasilConverter$2"));
            mObInitMap.put(new Pair<String, String>("kc", "net/minecraft/network/ServerStatusResponse$PlayerCountData"));
            mObInitMap.put(new Pair<String, String>("gd", "net/minecraft/network/play/server/S37PacketStatistics"));
            mObInitMap.put(new Pair<String, String>("ce", "net/minecraft/command/NumberInvalidException"));
            mObInitMap.put(new Pair<String, String>("net/minecraft/realms/Realms", "net/minecraft/realms/Realms"));
            mObInitMap.put(new Pair<String, String>("ajy", "net/minecraft/block/BlockClay"));
            mObInitMap.put(new Pair<String, String>("afz", "net/minecraft/enchantment/EnchantmentHelper$IModifier"));
            mObInitMap.put(new Pair<String, String>("brz", "net/minecraft/client/resources/data/AnimationFrame"));
            mObInitMap.put(new Pair<String, String>("avb", "net/minecraft/world/gen/structure/StructureStrongholdPieces$StairsStraight"));
            mObInitMap.put(new Pair<String, String>("aza", "net/minecraft/world/storage/WorldInfo$8"));
            mObInitMap.put(new Pair<String, String>("kv", "net/minecraft/init/Bootstrap$5"));
            mObInitMap.put(new Pair<String, String>("gw", "net/minecraft/network/play/server/S00PacketKeepAlive"));
            mObInitMap.put(new Pair<String, String>("cx", "net/minecraft/dispenser/IPosition"));
            mObInitMap.put(new Pair<String, String>("arv", "net/minecraft/world/gen/feature/WorldGenIcePath"));
            mObInitMap.put(new Pair<String, String>("anw", "net/minecraft/block/BlockStoneBrick"));
            mObInitMap.put(new Pair<String, String>("ajx", "net/minecraft/block/BlockChest"));
            mObInitMap.put(new Pair<String, String>("avu", "net/minecraft/world/gen/structure/StructureVillagePieces$PieceWeight"));
            mObInitMap.put(new Pair<String, String>("azt", "net/minecraft/util/AxisAlignedBB"));
            mObInitMap.put(new Pair<String, String>("bcr", "net/minecraft/client/gui/GuiSlotRealmsProxy"));
            mObInitMap.put(new Pair<String, String>("bgq", "net/minecraft/client/gui/stream/GuiStreamUnavailable$SwitchReason"));
            mObInitMap.put(new Pair<String, String>("bkp", "net/minecraft/client/particle/EffectRenderer$2"));
            mObInitMap.put(new Pair<String, String>("wr", "net/minecraft/entity/monster/EntitySnowman"));
            mObInitMap.put(new Pair<String, String>("ss", "net/minecraft/entity/EntityHanging"));
            mObInitMap.put(new Pair<String, String>("ot", "net/minecraft/network/rcon/RConOutputStream"));
            mObInitMap.put(new Pair<String, String>("ku", "net/minecraft/init/Bootstrap$4"));
            mObInitMap.put(new Pair<String, String>("asj", "net/minecraft/world/gen/feature/WorldGenSand"));
            mObInitMap.put(new Pair<String, String>("aok", "net/minecraft/block/BlockWeb"));
            mObInitMap.put(new Pair<String, String>("akl", "net/minecraft/block/BlockDirt"));
            mObInitMap.put(new Pair<String, String>("acn", "net/minecraft/item/ItemEnderEye"));
            mObInitMap.put(new Pair<String, String>("agm", "net/minecraft/entity/IMerchant"));
            mObInitMap.put(new Pair<String, String>("bsm", "net/minecraft/client/audio/MovingSoundMinecart"));
            mObInitMap.put(new Pair<String, String>("bon", "net/minecraft/client/renderer/entity/RenderPainting"));
            mObInitMap.put(new Pair<String, String>("bko", "net/minecraft/client/particle/EffectRenderer$1"));
            mObInitMap.put(new Pair<String, String>("xf", "net/minecraft/util/WeightedRandomFishable"));
            mObInitMap.put(new Pair<String, String>("tg", "net/minecraft/entity/passive/EntityTameable"));
            mObInitMap.put(new Pair<String, String>("ph", "net/minecraft/stats/StatBase"));
            mObInitMap.put(new Pair<String, String>("li", "net/minecraft/server/MinecraftServer$2"));
            mObInitMap.put(new Pair<String, String>("hj", "net/minecraft/network/play/server/S36PacketSignEditorOpen"));
            mObInitMap.put(new Pair<String, String>("dk", "net/minecraft/nbt/NBTTagDouble"));
            mObInitMap.put(new Pair<String, String>("adb", "net/minecraft/item/Item"));
            mObInitMap.put(new Pair<String, String>("aha", "net/minecraft/world/ColorizerGrass"));
            mObInitMap.put(new Pair<String, String>("bta", "net/minecraft/client/network/LanServerDetector"));
            mObInitMap.put(new Pair<String, String>("bpb", "net/minecraft/client/renderer/entity/RenderWitch"));
            mObInitMap.put(new Pair<String, String>("bde", "net/minecraft/client/gui/GuiScreenServerList"));
            mObInitMap.put(new Pair<String, String>("bhd", "net/minecraft/client/model/ModelBlaze"));
            mObInitMap.put(new Pair<String, String>("blc", "net/minecraft/client/particle/EntityBlockDustFX"));
            mObInitMap.put(new Pair<String, String>("tz", "net/minecraft/entity/ai/EntityAIBreakDoor"));
            mObInitMap.put(new Pair<String, String>("als", "net/minecraft/block/BlockLadder"));
            mObInitMap.put(new Pair<String, String>("aht", "net/minecraft/world/biome/BiomeGenBeach"));
            mObInitMap.put(new Pair<String, String>("btt", "net/minecraft/client/audio/SoundRegistry"));
            mObInitMap.put(new Pair<String, String>("bpu", "net/minecraft/client/renderer/texture/SimpleTexture"));
            mObInitMap.put(new Pair<String, String>("bdx", "net/minecraft/client/gui/GuiSelectWorld"));
            mObInitMap.put(new Pair<String, String>("bhw", "net/minecraft/client/model/ModelQuadruped"));
            mObInitMap.put(new Pair<String, String>("blv", "net/minecraft/client/renderer/EntityRenderer$2"));
            mObInitMap.put(new Pair<String, String>("iq", "net/minecraft/network/play/client/C14PacketTabComplete"));
            mObInitMap.put(new Pair<String, String>("er", "net/minecraft/network/EnumConnectionState$3"));
            mObInitMap.put(new Pair<String, String>("as", "net/minecraft/command/CommandGameRule"));
            mObInitMap.put(new Pair<String, String>("xx", "net/minecraft/entity/monster/EntityBlaze"));
            mObInitMap.put(new Pair<String, String>("ty", "net/minecraft/entity/ai/EntityAIBeg"));
            mObInitMap.put(new Pair<String, String>("aaj", "net/minecraft/inventory/ContainerFurnace"));
            mObInitMap.put(new Pair<String, String>("j", "net/minecraft/crash/CrashReport$8"));
            mObInitMap.put(new Pair<String, String>("atp", "net/minecraft/world/gen/structure/StructureNetherBridgePieces$Corridor2"));
            mObInitMap.put(new Pair<String, String>("apq", "net/minecraft/block/BlockPistonExtension"));
            mObInitMap.put(new Pair<String, String>("alr", "net/minecraft/block/BlockJukebox$TileEntityJukebox"));
            mObInitMap.put(new Pair<String, String>("axo", "net/minecraft/world/gen/layer/GenLayer$1"));
            mObInitMap.put(new Pair<String, String>("bam", "net/minecraft/client/renderer/RenderHelper"));
            mObInitMap.put(new Pair<String, String>("bel", "net/minecraft/client/gui/achievement/GuiStats$StatsBlock$1"));
            mObInitMap.put(new Pair<String, String>("bik", "net/minecraft/client/model/ModelVillager"));
            mObInitMap.put(new Pair<String, String>("bmj", "net/minecraft/client/renderer/tileentity/TileEntityBeaconRenderer"));
            mObInitMap.put(new Pair<String, String>("bg", "net/minecraft/command/server/CommandPublishLocalServer"));
            mObInitMap.put(new Pair<String, String>("yl", "net/minecraft/entity/monster/EntitySkeleton"));
            mObInitMap.put(new Pair<String, String>("um", "net/minecraft/entity/ai/EntityAILeapAtTarget"));
            mObInitMap.put(new Pair<String, String>("qn", "net/minecraft/util/StringUtils"));
            mObInitMap.put(new Pair<String, String>("mo", "net/minecraft/entity/EntityTracker$1"));
            mObInitMap.put(new Pair<String, String>("amf", "net/minecraft/block/BlockNetherWart"));
            mObInitMap.put(new Pair<String, String>("aeh", "net/minecraft/item/ItemSword"));
            mObInitMap.put(new Pair<String, String>("aai", "net/minecraft/inventory/ContainerEnchantment$2"));
            mObInitMap.put(new Pair<String, String>("aig", "net/minecraft/world/biome/BiomeGenForest$1"));
            mObInitMap.put(new Pair<String, String>("aud", "net/minecraft/world/gen/structure/ComponentScatteredFeaturePieces$JunglePyramid$Stones"));
            mObInitMap.put(new Pair<String, String>("ayc", "net/minecraft/world/gen/layer/GenLayerZoom"));
            mObInitMap.put(new Pair<String, String>("bba", "net/minecraft/client/Minecraft$4"));
            mObInitMap.put(new Pair<String, String>("bug", "net/minecraft/client/stream/ChatController$ChatState"));
            mObInitMap.put(new Pair<String, String>("bqh", "net/minecraft/client/renderer/texture/ITextureObject"));
            mObInitMap.put(new Pair<String, String>("bmi", "net/minecraft/client/shader/TesselatorVertexState"));
            mObInitMap.put(new Pair<String, String>("va", "net/minecraft/entity/ai/EntityAIPlay"));
            mObInitMap.put(new Pair<String, String>("rb", "net/minecraft/inventory/IInventory"));
            mObInitMap.put(new Pair<String, String>("nc", "net/minecraft/network/NetworkSystem"));
            mObInitMap.put(new Pair<String, String>("jd", "net/minecraft/network/play/client/C03PacketPlayer"));
            mObInitMap.put(new Pair<String, String>("fe", "net/minecraft/util/ChatComponentStyle"));
            mObInitMap.put(new Pair<String, String>("bf", "net/minecraft/command/CommandPlaySound"));
            mObInitMap.put(new Pair<String, String>("aqx", "net/minecraft/world/gen/MapGenBase"));
            mObInitMap.put(new Pair<String, String>("amy", "net/minecraft/block/BlockRail"));
            mObInitMap.put(new Pair<String, String>("aiz", "net/minecraft/world/gen/feature/WorldGenWaterlily"));
            mObInitMap.put(new Pair<String, String>("auw", "net/minecraft/world/gen/structure/StructureStrongholdPieces$Stones"));
            mObInitMap.put(new Pair<String, String>("vt", "net/minecraft/entity/ai/EntityAIOwnerHurtTarget"));
            mObInitMap.put(new Pair<String, String>("ru", "net/minecraft/potion/PotionHealth"));
            mObInitMap.put(new Pair<String, String>("nv", "net/minecraft/server/management/PlayerProfileCache$ProfileEntry"));
            mObInitMap.put(new Pair<String, String>("jw", "net/minecraft/network/login/client/C00PacketLoginStart"));
            mObInitMap.put(new Pair<String, String>("fx", "net/minecraft/network/play/server/S11PacketSpawnExperienceOrb"));
            mObInitMap.put(new Pair<String, String>("by", "net/minecraft/command/server/CommandTestFor"));
            mObInitMap.put(new Pair<String, String>("abp", "net/minecraft/item/ItemCarrotOnAStick"));
            mObInitMap.put(new Pair<String, String>("afo", "net/minecraft/enchantment/EnchantmentArrowInfinite"));
            mObInitMap.put(new Pair<String, String>("ajn", "net/minecraft/init/Blocks"));
            mObInitMap.put(new Pair<String, String>("bro", "net/minecraft/client/resources/SkinManager$SkinAvailableCallback"));
            mObInitMap.put(new Pair<String, String>("auv", "net/minecraft/world/gen/structure/StructureStrongholdPieces$RoomCrossing"));
            mObInitMap.put(new Pair<String, String>("ayu", "net/minecraft/world/storage/WorldInfo$2"));
            mObInitMap.put(new Pair<String, String>("bbs", "net/minecraft/util/Session"));
            mObInitMap.put(new Pair<String, String>("bfr", "net/minecraft/client/gui/inventory/GuiFurnace"));
            mObInitMap.put(new Pair<String, String>("bjq", "net/minecraft/client/network/OldServerPinger"));
            mObInitMap.put(new Pair<String, String>("bnp", "net/minecraft/client/renderer/entity/RenderXPOrb"));
            mObInitMap.put(new Pair<String, String>("kk", "net/minecraft/dispenser/BehaviorProjectileDispense"));
            mObInitMap.put(new Pair<String, String>("gl", "net/minecraft/network/play/server/S32PacketConfirmTransaction"));
            mObInitMap.put(new Pair<String, String>("cm", "net/minecraft/dispenser/BehaviorDefaultDispenseItem"));
            mObInitMap.put(new Pair<String, String>("zr", "net/minecraft/util/FoodStats"));
            mObInitMap.put(new Pair<String, String>("vs", "net/minecraft/entity/ai/EntityAIOwnerHurtByTarget"));
            mObInitMap.put(new Pair<String, String>("ark", "net/minecraft/world/gen/feature/WorldGenDeadBush"));
            mObInitMap.put(new Pair<String, String>("anl", "net/minecraft/block/BlockSkull"));
            mObInitMap.put(new Pair<String, String>("ajm", "net/minecraft/block/Block$SoundType"));
            mObInitMap.put(new Pair<String, String>("avj", "net/minecraft/world/gen/structure/MapGenStructureData"));
            mObInitMap.put(new Pair<String, String>("bgf", "net/minecraft/client/gui/GuiScreenResourcePacks"));
            mObInitMap.put(new Pair<String, String>("bke", "net/minecraft/client/particle/EntityFireworkStarterFX"));
            mObInitMap.put(new Pair<String, String>("wg", "net/minecraft/entity/passive/EntityChicken"));
            mObInitMap.put(new Pair<String, String>("sh", "net/minecraft/entity/EntityList$EntityEggInfo"));
            mObInitMap.put(new Pair<String, String>("oi", "net/minecraft/server/management/ServerConfigurationManager"));
            mObInitMap.put(new Pair<String, String>("kj", "net/minecraft/network/status/client/C00PacketServerQuery"));
            mObInitMap.put(new Pair<String, String>("aka", "net/minecraft/block/BlockColored"));
            mObInitMap.put(new Pair<String, String>("acc", "net/minecraft/creativetab/CreativeTabs$6"));
            mObInitMap.put(new Pair<String, String>("agb", "net/minecraft/enchantment/EnchantmentHelper$ModifierDamage"));
            mObInitMap.put(new Pair<String, String>("bsb", "net/minecraft/client/resources/data/AnimationMetadataSectionSerializer"));
            mObInitMap.put(new Pair<String, String>("bkd", "net/minecraft/client/particle/EntityFireworkSparkFX"));
            mObInitMap.put(new Pair<String, String>("boc", "net/minecraft/client/renderer/entity/RenderItem$4"));
            mObInitMap.put(new Pair<String, String>("wz", "net/minecraft/entity/item/EntityEnderCrystal"));
            mObInitMap.put(new Pair<String, String>("asr", "net/minecraft/world/gen/feature/WorldGenVines"));
            mObInitMap.put(new Pair<String, String>("aos", "net/minecraft/tileentity/TileEntity$1"));
            mObInitMap.put(new Pair<String, String>("akt", "net/minecraft/block/BlockEndPortal"));
            mObInitMap.put(new Pair<String, String>("acv", "net/minecraft/item/ItemFishingRod"));
            mObInitMap.put(new Pair<String, String>("agu", "net/minecraft/world/ChunkCoordIntPair"));
            mObInitMap.put(new Pair<String, String>("awq", "net/minecraft/block/material/MaterialLogic"));
            mObInitMap.put(new Pair<String, String>("bsu", "net/minecraft/client/audio/ISound$AttenuationType"));
            mObInitMap.put(new Pair<String, String>("bov", "net/minecraft/client/renderer/entity/RenderSpider"));
            mObInitMap.put(new Pair<String, String>("bcy", "net/minecraft/client/multiplayer/GuiConnecting$1"));
            mObInitMap.put(new Pair<String, String>("bkw", "net/minecraft/client/particle/EntitySnowShovelFX"));
            mObInitMap.put(new Pair<String, String>("net/minecraft/realms/RealmsAnvilLevelStorageSource", "net/minecraft/realms/RealmsAnvilLevelStorageSource"));
            mObInitMap.put(new Pair<String, String>("to", "net/minecraft/entity/ai/attributes/RangedAttribute"));
            mObInitMap.put(new Pair<String, String>("pp", "net/minecraft/stats/StatList"));
            mObInitMap.put(new Pair<String, String>("lq", "net/minecraft/server/dedicated/PropertyManager"));
            mObInitMap.put(new Pair<String, String>("hr", "net/minecraft/network/play/server/S1EPacketRemoveEntityEffect"));
            mObInitMap.put(new Pair<String, String>("ds", "net/minecraft/nbt/NBTSizeTracker"));
            mObInitMap.put(new Pair<String, String>("alh", "net/minecraft/block/BlockGrass"));
            mObInitMap.put(new Pair<String, String>("adj", "net/minecraft/item/ItemMinecart"));
            mObInitMap.put(new Pair<String, String>("bti", "net/minecraft/client/audio/SoundPoolEntry"));
            mObInitMap.put(new Pair<String, String>("bpj", "net/minecraft/client/shader/ShaderGroup"));
            mObInitMap.put(new Pair<String, String>("awp", "net/minecraft/world/gen/NoiseGenerator"));
            mObInitMap.put(new Pair<String, String>("bdm", "net/minecraft/client/gui/GuiOptions"));
            mObInitMap.put(new Pair<String, String>("bhl", "net/minecraft/client/model/ModelGhast"));
            mObInitMap.put(new Pair<String, String>("blk", "net/minecraft/client/entity/EntityPlayerSP"));
            mObInitMap.put(new Pair<String, String>("me", "net/minecraft/server/gui/PlayerListComponent"));
            mObInitMap.put(new Pair<String, String>("eg", "net/minecraft/network/NettyEncryptionTranslator"));
            mObInitMap.put(new Pair<String, String>("ah", "net/minecraft/command/server/CommandBroadcast"));
            mObInitMap.put(new Pair<String, String>("xm", "net/minecraft/entity/item/EntityMinecartChest"));
            mObInitMap.put(new Pair<String, String>("net/minecraft/realms/Tezzelator", "net/minecraft/realms/Tezzelator"));
            mObInitMap.put(new Pair<String, String>("ate", "net/minecraft/world/gen/structure/MapGenNetherBridge$Start"));
            mObInitMap.put(new Pair<String, String>("apf", "net/minecraft/tileentity/TileEntityFlowerPot"));
            mObInitMap.put(new Pair<String, String>("alg", "net/minecraft/block/BlockGlowstone"));
            mObInitMap.put(new Pair<String, String>("axd", "net/minecraft/world/gen/layer/GenLayerAddSnow"));
            mObInitMap.put(new Pair<String, String>("bea", "net/minecraft/client/gui/GuiSnooper"));
            mObInitMap.put(new Pair<String, String>("ya", "net/minecraft/entity/monster/EntityEnderman"));
            mObInitMap.put(new Pair<String, String>("ub", "net/minecraft/entity/ai/EntityAIControlledByPlayer"));
            mObInitMap.put(new Pair<String, String>("qc", "net/minecraft/util/ThreadSafeBoundList"));
            mObInitMap.put(new Pair<String, String>("md", "net/minecraft/server/gui/MinecraftServerGui$5"));
            mObInitMap.put(new Pair<String, String>("r", "net/minecraft/util/ChunkCoordinates"));
            mObInitMap.put(new Pair<String, String>("atx", "net/minecraft/world/gen/structure/MapGenScatteredFeature"));
            mObInitMap.put(new Pair<String, String>("apy", "net/minecraft/world/chunk/Chunk$1"));
            mObInitMap.put(new Pair<String, String>("alz", "net/minecraft/block/BlockCompressed"));
            mObInitMap.put(new Pair<String, String>("axw", "net/minecraft/world/gen/layer/GenLayerShore"));
            mObInitMap.put(new Pair<String, String>("bau", "net/minecraft/client/Minecraft$14"));
            mObInitMap.put(new Pair<String, String>("yt", "net/minecraft/entity/NpcMerchant"));
            mObInitMap.put(new Pair<String, String>("uu", "net/minecraft/entity/ai/EntityAIMoveTowardsTarget"));
            mObInitMap.put(new Pair<String, String>("qv", "net/minecraft/util/WeightedRandom"));
            mObInitMap.put(new Pair<String, String>("mw", "net/minecraft/entity/player/EntityPlayerMP"));
            mObInitMap.put(new Pair<String, String>("ix", "net/minecraft/network/play/client/C0EPacketClickWindow"));
            mObInitMap.put(new Pair<String, String>("ey", "net/minecraft/network/NetworkStatistics$PacketStatData"));
            mObInitMap.put(new Pair<String, String>("az", "net/minecraft/command/server/CommandMessage"));
            mObInitMap.put(new Pair<String, String>("amn", "net/minecraft/block/BlockOre"));
            mObInitMap.put(new Pair<String, String>("aaq", "net/minecraft/inventory/ContainerPlayer$1"));
            mObInitMap.put(new Pair<String, String>("aio", "net/minecraft/world/biome/BiomeGenOcean"));
            mObInitMap.put(new Pair<String, String>("aul", "net/minecraft/world/gen/structure/StructureStrongholdPieces$SwitchDoor"));
            mObInitMap.put(new Pair<String, String>("buo", "net/minecraft/client/stream/TwitchStream"));
            mObInitMap.put(new Pair<String, String>("bqp", "net/minecraft/client/resources/DefaultResourcePack"));
            mObInitMap.put(new Pair<String, String>("bat", "net/minecraft/client/Minecraft$13"));
            mObInitMap.put(new Pair<String, String>("bes", "net/minecraft/client/gui/GuiKeyBindingList"));
            mObInitMap.put(new Pair<String, String>("bir", "net/minecraft/client/model/ModelEnderCrystal"));
            mObInitMap.put(new Pair<String, String>("bmq", "net/minecraft/client/renderer/tileentity/TileEntityRendererPiston"));
            mObInitMap.put(new Pair<String, String>("vi", "net/minecraft/entity/ai/EntityAICreeperSwell"));
            mObInitMap.put(new Pair<String, String>("rj", "net/minecraft/profiler/PlayerUsageSnooper$1"));
            mObInitMap.put(new Pair<String, String>("nk", "net/minecraft/network/NetHandlerPlayServer$SwitchEnumState"));
            mObInitMap.put(new Pair<String, String>("jl", "net/minecraft/network/play/client/C09PacketHeldItemChange"));
            mObInitMap.put(new Pair<String, String>("fm", "net/minecraft/event/HoverEvent$Action"));
            mObInitMap.put(new Pair<String, String>("bn", "net/minecraft/command/server/CommandSetDefaultSpawnpoint"));
            mObInitMap.put(new Pair<String, String>("abe", "net/minecraft/item/ItemBlockWithMetadata"));
            mObInitMap.put(new Pair<String, String>("afd", "net/minecraft/item/crafting/RecipesIngots"));
            mObInitMap.put(new Pair<String, String>("ajc", "net/minecraft/block/BlockContainer"));
            mObInitMap.put(new Pair<String, String>("brd", "net/minecraft/client/resources/ResourcePackRepository$1"));
            mObInitMap.put(new Pair<String, String>("auk", "net/minecraft/world/gen/structure/StructureStrongholdPieces$2"));
            mObInitMap.put(new Pair<String, String>("ayj", "net/minecraft/world/storage/MapData$MapInfo"));
            mObInitMap.put(new Pair<String, String>("bbh", "net/minecraft/client/renderer/OpenGlCapsChecker"));
            mObInitMap.put(new Pair<String, String>("bfg", "net/minecraft/client/gui/inventory/GuiBrewingStand"));
            mObInitMap.put(new Pair<String, String>("bjf", "net/minecraft/client/multiplayer/WorldClient"));
            mObInitMap.put(new Pair<String, String>("bne", "net/minecraft/client/renderer/entity/RenderBoat"));
            mObInitMap.put(new Pair<String, String>("ga", "net/minecraft/network/play/server/S10PacketSpawnPainting"));
            mObInitMap.put(new Pair<String, String>("cb", "net/minecraft/command/CommandWeather"));
            mObInitMap.put(new Pair<String, String>("zg", "net/minecraft/entity/projectile/EntityLargeFireball"));
            mObInitMap.put(new Pair<String, String>("vh", "net/minecraft/entity/ai/EntityAISit"));
            mObInitMap.put(new Pair<String, String>("abx", "net/minecraft/creativetab/CreativeTabs$12"));
            mObInitMap.put(new Pair<String, String>("ana", "net/minecraft/block/BlockRedstoneWire"));
            mObInitMap.put(new Pair<String, String>("bfz", "net/minecraft/client/gui/GuiMultiplayer"));
            mObInitMap.put(new Pair<String, String>("bjy", "net/minecraft/client/particle/EntityDropParticleFX"));
            mObInitMap.put(new Pair<String, String>("zz", "net/minecraft/inventory/ContainerBrewingStand"));
            mObInitMap.put(new Pair<String, String>("ars", "net/minecraft/world/gen/feature/WorldGenHellLava"));
            mObInitMap.put(new Pair<String, String>("ant", "net/minecraft/block/BlockStaticLiquid"));
            mObInitMap.put(new Pair<String, String>("abw", "net/minecraft/creativetab/CreativeTabs$11"));
            mObInitMap.put(new Pair<String, String>("afv", "net/minecraft/enchantment/EnchantmentHelper"));
            mObInitMap.put(new Pair<String, String>("aju", "net/minecraft/block/BlockCake"));
            mObInitMap.put(new Pair<String, String>("avr", "net/minecraft/world/gen/structure/StructureVillagePieces$Field1"));
            mObInitMap.put(new Pair<String, String>("azq", "net/minecraft/world/storage/MapStorage"));
            mObInitMap.put(new Pair<String, String>("bco", "net/minecraft/client/gui/GuiStreamIndicator"));
            mObInitMap.put(new Pair<String, String>("brv", "net/minecraft/client/resources/data/IMetadataSectionSerializer"));
            mObInitMap.put(new Pair<String, String>("bnw", "net/minecraft/client/renderer/entity/RenderBiped"));
            mObInitMap.put(new Pair<String, String>("wo", "net/minecraft/entity/passive/EntityPig"));
            mObInitMap.put(new Pair<String, String>("sp", "net/minecraft/command/IEntitySelector$ArmoredMob"));
            mObInitMap.put(new Pair<String, String>("oq", "net/minecraft/server/management/UserListBansEntry"));
            mObInitMap.put(new Pair<String, String>("kr", "net/minecraft/init/Bootstrap$14"));
            mObInitMap.put(new Pair<String, String>("gs", "net/minecraft/network/play/server/S40PacketDisconnect"));
            mObInitMap.put(new Pair<String, String>("ct", "net/minecraft/util/ObjectIntIdentityMap"));
            mObInitMap.put(new Pair<String, String>("net/minecraft/realms/RealmsEditBox", "net/minecraft/realms/RealmsEditBox"));
            mObInitMap.put(new Pair<String, String>("asg", "net/minecraft/world/gen/feature/WorldGenPumpkin"));
            mObInitMap.put(new Pair<String, String>("aoh", "net/minecraft/block/BlockVine"));
            mObInitMap.put(new Pair<String, String>("aki", "net/minecraft/block/BlockRailDetector"));
            mObInitMap.put(new Pair<String, String>("ack", "net/minecraft/item/ItemEgg"));
            mObInitMap.put(new Pair<String, String>("agj", "net/minecraft/enchantment/EnchantmentThorns"));
            mObInitMap.put(new Pair<String, String>("awf", "net/minecraft/world/gen/structure/StructureVillagePieces$Well"));
            mObInitMap.put(new Pair<String, String>("bsj", "net/minecraft/client/resources/data/TextureMetadataSectionSerializer"));
            mObInitMap.put(new Pair<String, String>("bok", "net/minecraft/client/renderer/entity/RenderLiving"));
            mObInitMap.put(new Pair<String, String>("bcn", "net/minecraft/client/gui/GuiOptionSlider"));
            mObInitMap.put(new Pair<String, String>("bgm", "net/minecraft/client/gui/stream/GuiIngestServers"));
            mObInitMap.put(new Pair<String, String>("bkl", "net/minecraft/client/particle/EntityNoteFX"));
            mObInitMap.put(new Pair<String, String>("xc", "net/minecraft/entity/boss/EntityWither"));
            mObInitMap.put(new Pair<String, String>("td", "net/minecraft/entity/EntityCreature"));
            mObInitMap.put(new Pair<String, String>("pe", "net/minecraft/stats/StatBasic"));
            mObInitMap.put(new Pair<String, String>("hg", "net/minecraft/network/play/server/S14PacketEntity$S15PacketEntityRelMove"));
            mObInitMap.put(new Pair<String, String>("dh", "net/minecraft/nbt/NBTTagCompound"));
            mObInitMap.put(new Pair<String, String>("awe", "net/minecraft/world/gen/structure/StructureVillagePieces$Road"));
            mObInitMap.put(new Pair<String, String>("bdb", "net/minecraft/client/gui/GuiCreateWorld"));
            mObInitMap.put(new Pair<String, String>("ly", "net/minecraft/server/gui/MinecraftServerGui"));
            mObInitMap.put(new Pair<String, String>("hz", "net/minecraft/network/play/server/S04PacketEntityEquipment"));
            mObInitMap.put(new Pair<String, String>("asy", "net/minecraft/world/gen/structure/StructureMineshaftPieces$Corridor"));
            mObInitMap.put(new Pair<String, String>("aoz", "net/minecraft/tileentity/TileEntityComparator"));
            mObInitMap.put(new Pair<String, String>("awx", "net/minecraft/world/gen/layer/GenLayerDeepOcean"));
            mObInitMap.put(new Pair<String, String>("bdu", "net/minecraft/client/gui/GuiDownloadTerrain"));
            mObInitMap.put(new Pair<String, String>("bht", "net/minecraft/client/model/ModelOcelot"));
            mObInitMap.put(new Pair<String, String>("bls", "net/minecraft/client/renderer/tileentity/TileEntityRendererChestHelper"));
            mObInitMap.put(new Pair<String, String>("ap", "net/minecraft/command/CommandXP"));
            mObInitMap.put(new Pair<String, String>("xu", "net/minecraft/entity/ai/EntityMinecartMobSpawner$1"));
            mObInitMap.put(new Pair<String, String>("tv", "net/minecraft/entity/ai/EntityMoveHelper"));
            mObInitMap.put(new Pair<String, String>("pw", "net/minecraft/util/HttpUtil$1"));
            mObInitMap.put(new Pair<String, String>("lx", "net/minecraft/server/dedicated/DedicatedServer$4"));
            mObInitMap.put(new Pair<String, String>("g", "net/minecraft/crash/CrashReport$5"));
            mObInitMap.put(new Pair<String, String>("atm", "net/minecraft/world/gen/structure/StructureNetherBridgePieces$Crossing2"));
            mObInitMap.put(new Pair<String, String>("apn", "net/minecraft/tileentity/TileEntitySkull"));
            mObInitMap.put(new Pair<String, String>("alo", "net/minecraft/block/BlockHugeMushroom"));
            mObInitMap.put(new Pair<String, String>("adq", "net/minecraft/item/EnumRarity"));
            mObInitMap.put(new Pair<String, String>("ahp", "net/minecraft/world/Teleporter"));
            mObInitMap.put(new Pair<String, String>("axl", "net/minecraft/world/gen/layer/IntCache"));
            mObInitMap.put(new Pair<String, String>("baj", "net/minecraft/client/renderer/ActiveRenderInfo"));
            mObInitMap.put(new Pair<String, String>("btp", "net/minecraft/client/audio/SoundHandler"));
            mObInitMap.put(new Pair<String, String>("bpq", "net/minecraft/client/renderer/texture/DynamicTexture"));
            mObInitMap.put(new Pair<String, String>("blr", "net/minecraft/client/util/RenderDistanceSorter"));
            mObInitMap.put(new Pair<String, String>("yi", "net/minecraft/entity/IRangedAttackMob"));
            mObInitMap.put(new Pair<String, String>("uj", "net/minecraft/entity/ai/EntityAITasks"));
            mObInitMap.put(new Pair<String, String>("qk", "net/minecraft/util/IProgressUpdate"));
            mObInitMap.put(new Pair<String, String>("ml", "net/minecraft/world/demo/DemoWorldManager"));
            mObInitMap.put(new Pair<String, String>("im", "net/minecraft/network/play/server/S20PacketEntityProperties$Snapshot"));
            mObInitMap.put(new Pair<String, String>("en", "net/minecraft/network/NetworkManager$InboundHandlerTuplePacketListener"));
            mObInitMap.put(new Pair<String, String>("ao", "net/minecraft/command/CommandEnchant"));
            mObInitMap.put(new Pair<String, String>("amc", "net/minecraft/block/BlockMushroom"));
            mObInitMap.put(new Pair<String, String>("aee", "net/minecraft/item/ItemMonsterPlacer"));
            mObInitMap.put(new Pair<String, String>("aaf", "net/minecraft/inventory/ContainerWorkbench"));
            mObInitMap.put(new Pair<String, String>("aid", "net/minecraft/world/biome/BiomeGenHills"));
            mObInitMap.put(new Pair<String, String>("aua", "net/minecraft/world/gen/structure/ComponentScatteredFeaturePieces$1"));
            mObInitMap.put(new Pair<String, String>("bud", "net/minecraft/client/stream/BroadcastController$BroadcastListener"));
            mObInitMap.put(new Pair<String, String>("bqe", "net/minecraft/client/renderer/texture/TextureAtlasSprite$1"));
            mObInitMap.put(new Pair<String, String>("beh", "net/minecraft/client/gui/achievement/GuiAchievement"));
            mObInitMap.put(new Pair<String, String>("big", "net/minecraft/client/model/ModelSpider"));
            mObInitMap.put(new Pair<String, String>("ja", "net/minecraft/network/play/client/C02PacketUseEntity"));
            mObInitMap.put(new Pair<String, String>("fb", "net/minecraft/network/INetHandler"));
            mObInitMap.put(new Pair<String, String>("bc", "net/minecraft/command/server/CommandOp"));
            mObInitMap.put(new Pair<String, String>("amv", "net/minecraft/block/BlockPressurePlate$Sensitivity"));
            mObInitMap.put(new Pair<String, String>("aex", "net/minecraft/item/crafting/RecipesDyes"));
            mObInitMap.put(new Pair<String, String>("aay", "net/minecraft/inventory/Slot"));
            mObInitMap.put(new Pair<String, String>("aiw", "net/minecraft/world/biome/BiomeGenTaiga"));
            mObInitMap.put(new Pair<String, String>("y", "net/minecraft/command/CommandBase"));
            mObInitMap.put(new Pair<String, String>("bqx", "net/minecraft/util/ResourceLocation"));
            mObInitMap.put(new Pair<String, String>("biz", "net/minecraft/client/network/NetHandlerLoginClient"));
            mObInitMap.put(new Pair<String, String>("bmy", "net/minecraft/client/renderer/culling/ClippingHelper"));
            mObInitMap.put(new Pair<String, String>("jt", "net/minecraft/network/login/server/S01PacketEncryptionRequest"));
            mObInitMap.put(new Pair<String, String>("fu", "net/minecraft/network/play/server/S08PacketPlayerPosLook"));
            mObInitMap.put(new Pair<String, String>("bv", "net/minecraft/command/server/CommandTeleport"));
            mObInitMap.put(new Pair<String, String>("net/minecraft/realms/RealmsConnect", "net/minecraft/realms/RealmsConnect"));
            mObInitMap.put(new Pair<String, String>("abm", "net/minecraft/item/ItemBow"));
            mObInitMap.put(new Pair<String, String>("amu", "net/minecraft/block/BlockPressurePlate"));
            mObInitMap.put(new Pair<String, String>("aus", "net/minecraft/world/gen/structure/StructureStrongholdPieces$PortalRoom"));
            mObInitMap.put(new Pair<String, String>("ayr", "net/minecraft/world/storage/SaveFormatOld"));
            mObInitMap.put(new Pair<String, String>("bbp", "net/minecraft/util/ScreenShotHelper"));
            mObInitMap.put(new Pair<String, String>("bfo", "net/minecraft/client/renderer/InventoryEffectRenderer"));
            mObInitMap.put(new Pair<String, String>("bjn", "net/minecraft/client/multiplayer/ServerData"));
            mObInitMap.put(new Pair<String, String>("bnm", "net/minecraft/client/renderer/entity/RenderEnderman"));
            mObInitMap.put(new Pair<String, String>("zo", "net/minecraft/entity/projectile/EntityPotion"));
            mObInitMap.put(new Pair<String, String>("vp", "net/minecraft/entity/ai/EntityAINearestAttackableTarget$1"));
            mObInitMap.put(new Pair<String, String>("rq", "net/minecraft/util/EntityDamageSourceIndirect"));
            mObInitMap.put(new Pair<String, String>("nr", "net/minecraft/server/management/BanEntry"));
            mObInitMap.put(new Pair<String, String>("arh", "net/minecraft/world/gen/feature/WorldGenCactus"));
            mObInitMap.put(new Pair<String, String>("ani", "net/minecraft/block/BlockSandStone"));
            mObInitMap.put(new Pair<String, String>("abl", "net/minecraft/item/ItemGlassBottle"));
            mObInitMap.put(new Pair<String, String>("afk", "net/minecraft/item/crafting/RecipesTools"));
            mObInitMap.put(new Pair<String, String>("ajj", "net/minecraft/block/Block$1"));
            mObInitMap.put(new Pair<String, String>("avg", "net/minecraft/world/gen/structure/MapGenStructure$2"));
            mObInitMap.put(new Pair<String, String>("azf", "net/minecraft/world/storage/SaveFormatComparator"));
            mObInitMap.put(new Pair<String, String>("bcd", "net/minecraft/client/gui/GuiTextField"));
            mObInitMap.put(new Pair<String, String>("brk", "net/minecraft/client/resources/SkinManager$1"));
            mObInitMap.put(new Pair<String, String>("bnl", "net/minecraft/client/renderer/entity/RenderDragon"));
            mObInitMap.put(new Pair<String, String>("wd", "net/minecraft/entity/passive/EntityAmbientCreature"));
            mObInitMap.put(new Pair<String, String>("se", "net/minecraft/entity/Entity$EnumEntitySize"));
            mObInitMap.put(new Pair<String, String>("of", "net/minecraft/server/management/PreYggdrasilConverter$6"));
            mObInitMap.put(new Pair<String, String>("kg", "net/minecraft/network/ServerStatusResponse$MinecraftProtocolVersionIdentifier$Serializer"));
            mObInitMap.put(new Pair<String, String>("gh", "net/minecraft/network/play/server/S23PacketBlockChange"));
            mObInitMap.put(new Pair<String, String>("ci", "net/minecraft/command/WrongUsageException"));
            mObInitMap.put(new Pair<String, String>("avz", "net/minecraft/world/gen/structure/StructureVillagePieces$House2"));
            mObInitMap.put(new Pair<String, String>("net/minecraft/realms/RealmsButton", "net/minecraft/realms/RealmsButton"));
            mObInitMap.put(new Pair<String, String>("bcc", "net/minecraft/client/gui/GuiNewChat"));
            mObInitMap.put(new Pair<String, String>("bgb", "net/minecraft/client/gui/ServerListEntryLanDetected"));
            mObInitMap.put(new Pair<String, String>("bka", "net/minecraft/client/particle/EntityExplodeFX"));
            mObInitMap.put(new Pair<String, String>("ww", "net/minecraft/entity/boss/IBossDisplayData"));
            mObInitMap.put(new Pair<String, String>("sx", "net/minecraft/entity/EnumCreatureType"));
            mObInitMap.put(new Pair<String, String>("oy", "net/minecraft/network/rcon/RConThreadQuery$Auth"));
            mObInitMap.put(new Pair<String, String>("kz", "net/minecraft/init/Bootstrap$8"));
            mObInitMap.put(new Pair<String, String>("akq", "net/minecraft/block/BlockDropper"));
            mObInitMap.put(new Pair<String, String>("acs", "net/minecraft/item/ItemFirework"));
            mObInitMap.put(new Pair<String, String>("agr", "net/minecraft/tileentity/MobSpawnerBaseLogic$WeightedRandomMinecart"));
            mObInitMap.put(new Pair<String, String>("bsr", "net/minecraft/client/audio/SoundList$SoundEntry$Type"));
            mObInitMap.put(new Pair<String, String>("bos", "net/minecraft/client/renderer/entity/RenderSkeleton"));
            mObInitMap.put(new Pair<String, String>("avy", "net/minecraft/world/gen/structure/StructureVillagePieces$Church"));
            mObInitMap.put(new Pair<String, String>("azx", "net/minecraft/scoreboard/ScoreObjective"));
            mObInitMap.put(new Pair<String, String>("bcv", "net/minecraft/client/gui/GuiYesNoCallback"));
            mObInitMap.put(new Pair<String, String>("bgu", "net/minecraft/client/main/Main$1$1"));
            mObInitMap.put(new Pair<String, String>("bkt", "net/minecraft/client/particle/EntityPortalFX"));
            mObInitMap.put(new Pair<String, String>("ln", "net/minecraft/server/management/PlayerPositionComparator"));
            mObInitMap.put(new Pair<String, String>("ho", "net/minecraft/network/play/server/S38PacketPlayerListItem"));
            mObInitMap.put(new Pair<String, String>("dp", "net/minecraft/nbt/NBTTagInt"));
            mObInitMap.put(new Pair<String, String>("wv", "net/minecraft/entity/passive/EntityWolf"));
            mObInitMap.put(new Pair<String, String>("asn", "net/minecraft/world/gen/feature/WorldGenTaiga2"));
            mObInitMap.put(new Pair<String, String>("aoo", "net/minecraft/block/BlockWoodSlab"));
            mObInitMap.put(new Pair<String, String>("bdj", "net/minecraft/client/gui/GuiLanguage"));
            mObInitMap.put(new Pair<String, String>("bhi", "net/minecraft/client/model/ModelCow"));
            mObInitMap.put(new Pair<String, String>("blh", "net/minecraft/client/entity/AbstractClientPlayer$SwitchType"));
            mObInitMap.put(new Pair<String, String>("ae", "net/minecraft/command/server/CommandAchievement"));
            mObInitMap.put(new Pair<String, String>("xj", "net/minecraft/entity/item/EntityFallingBlock"));
            mObInitMap.put(new Pair<String, String>("tk", "net/minecraft/entity/ai/attributes/BaseAttribute"));
            mObInitMap.put(new Pair<String, String>("pl", "net/minecraft/stats/StatBase$4"));
            mObInitMap.put(new Pair<String, String>("lm", "net/minecraft/server/MinecraftServer$6"));
            mObInitMap.put(new Pair<String, String>("atb", "net/minecraft/world/gen/structure/StructureMineshaftPieces$Stairs"));
            mObInitMap.put(new Pair<String, String>("apc", "net/minecraft/tileentity/TileEntityDropper"));
            mObInitMap.put(new Pair<String, String>("ald", "net/minecraft/block/BlockFlowerPot"));
            mObInitMap.put(new Pair<String, String>("adf", "net/minecraft/item/ItemLead"));
            mObInitMap.put(new Pair<String, String>("ahe", "net/minecraft/world/World$3"));
            mObInitMap.put(new Pair<String, String>("axa", "net/minecraft/world/gen/layer/GenLayerEdge$Mode"));
            mObInitMap.put(new Pair<String, String>("bte", "net/minecraft/client/multiplayer/ThreadLanServerPing"));
            mObInitMap.put(new Pair<String, String>("bpf", "net/minecraft/client/renderer/entity/RenderZombie"));
            mObInitMap.put(new Pair<String, String>("ma", "net/minecraft/server/gui/MinecraftServerGui$2"));
            mObInitMap.put(new Pair<String, String>("ib", "net/minecraft/network/play/server/S06PacketUpdateHealth"));
            mObInitMap.put(new Pair<String, String>("ec", "net/minecraft/nbt/JsonToNBT$Any"));
            mObInitMap.put(new Pair<String, String>("ad", "net/minecraft/command/PlayerSelector"));
            mObInitMap.put(new Pair<String, String>("atu", "net/minecraft/world/gen/structure/StructureNetherBridgePieces$Crossing"));
            mObInitMap.put(new Pair<String, String>("apv", "net/minecraft/world/chunk/NibbleArray"));
            mObInitMap.put(new Pair<String, String>("alw", "net/minecraft/block/BlockLiquid"));
            mObInitMap.put(new Pair<String, String>("ady", "net/minecraft/item/ItemSpade"));
            mObInitMap.put(new Pair<String, String>("ahx", "net/minecraft/world/biome/BiomeGenBase$SpawnListEntry"));
            mObInitMap.put(new Pair<String, String>("axt", "net/minecraft/world/gen/layer/GenLayerRiverInit"));
            mObInitMap.put(new Pair<String, String>("bpy", "net/minecraft/client/renderer/StitcherException"));
            mObInitMap.put(new Pair<String, String>("ur", "net/minecraft/entity/ai/EntityAIMoveIndoors"));
            mObInitMap.put(new Pair<String, String>("mt", "net/minecraft/world/WorldServer"));
            mObInitMap.put(new Pair<String, String>("iu", "net/minecraft/network/play/client/C15PacketClientSettings"));
            mObInitMap.put(new Pair<String, String>("ev", "net/minecraft/network/NetworkStatistics$1"));
            mObInitMap.put(new Pair<String, String>("aw", "net/minecraft/command/CommandKill"));
            mObInitMap.put(new Pair<String, String>("amk", "net/minecraft/block/BlockObsidian"));
            mObInitMap.put(new Pair<String, String>("aem", "net/minecraft/item/ItemEditableBook"));
            mObInitMap.put(new Pair<String, String>("aan", "net/minecraft/inventory/ContainerHorseInventory$1"));
            mObInitMap.put(new Pair<String, String>("ail", "net/minecraft/world/biome/BiomeGenMesa"));
            mObInitMap.put(new Pair<String, String>("n", "net/minecraft/crash/CrashReportCategory$3"));
            mObInitMap.put(new Pair<String, String>("bul", "net/minecraft/client/stream/IngestServerTester$IngestTestState"));
            mObInitMap.put(new Pair<String, String>("bqm", "net/minecraft/client/renderer/texture/TextureCompass"));
            mObInitMap.put(new Pair<String, String>("axs", "net/minecraft/world/gen/layer/GenLayerRemoveTooMuchOcean"));
            mObInitMap.put(new Pair<String, String>("baq", "net/minecraft/client/Minecraft$10"));
            mObInitMap.put(new Pair<String, String>("bep", "net/minecraft/client/gui/achievement/GuiStats$StatsMobsList"));
            mObInitMap.put(new Pair<String, String>("bio", "net/minecraft/client/model/ModelWolf"));
            mObInitMap.put(new Pair<String, String>("bmn", "net/minecraft/client/renderer/entity/RenderEnchantmentTable"));
            mObInitMap.put(new Pair<String, String>("nh", "net/minecraft/network/NetHandlerPlayServer"));
            mObInitMap.put(new Pair<String, String>("ji", "net/minecraft/network/play/client/C07PacketPlayerDigging"));
            mObInitMap.put(new Pair<String, String>("fj", "net/minecraft/util/IChatComponent"));
            mObInitMap.put(new Pair<String, String>("bk", "net/minecraft/command/server/CommandScoreboard"));
            mObInitMap.put(new Pair<String, String>("yp", "net/minecraft/entity/monster/EntityWitch"));
            mObInitMap.put(new Pair<String, String>("abb", "net/minecraft/item/ItemArmor"));
            mObInitMap.put(new Pair<String, String>("aqi", "net/minecraft/world/chunk/storage/RegionFile$ChunkBuffer"));
            mObInitMap.put(new Pair<String, String>("amj", "net/minecraft/block/BlockNote"));
            mObInitMap.put(new Pair<String, String>("auh", "net/minecraft/world/gen/structure/MapGenStronghold$Start"));
            mObInitMap.put(new Pair<String, String>("ayg", "net/minecraft/pathfinding/PathFinder"));
            mObInitMap.put(new Pair<String, String>("bbe", "net/minecraft/client/Minecraft$8"));
            mObInitMap.put(new Pair<String, String>("bfd", "net/minecraft/client/gui/inventory/GuiBeacon$Button"));
            mObInitMap.put(new Pair<String, String>("bjc", "net/minecraft/client/network/NetHandlerPlayClient$1"));
            mObInitMap.put(new Pair<String, String>("bnb", "net/minecraft/client/renderer/entity/RenderArrow"));
            mObInitMap.put(new Pair<String, String>("zd", "net/minecraft/entity/item/EntityEnderEye"));
            mObInitMap.put(new Pair<String, String>("ve", "net/minecraft/entity/ai/EntityAIRestrictOpenDoor"));
            mObInitMap.put(new Pair<String, String>("rf", "net/minecraft/util/IIcon"));
            mObInitMap.put(new Pair<String, String>("ng", "net/minecraft/network/NetworkSystem$4"));
            mObInitMap.put(new Pair<String, String>("aba", "net/minecraft/item/ItemAnvilBlock"));
            mObInitMap.put(new Pair<String, String>("ayz", "net/minecraft/world/storage/WorldInfo$7"));
            mObInitMap.put(new Pair<String, String>("bbx", "net/minecraft/client/gui/MapItemRenderer"));
            mObInitMap.put(new Pair<String, String>("zw", "net/minecraft/inventory/ContainerRepair$2"));
            mObInitMap.put(new Pair<String, String>("vx", "net/minecraft/entity/ai/RandomPositionGenerator"));
            mObInitMap.put(new Pair<String, String>("ry", "net/minecraft/entity/passive/IAnimals"));
            mObInitMap.put(new Pair<String, String>("nz", "net/minecraft/server/management/PreYggdrasilConverter"));
            mObInitMap.put(new Pair<String, String>("arp", "net/minecraft/world/gen/feature/WorldGenShrub"));
            mObInitMap.put(new Pair<String, String>("anq", "net/minecraft/block/BlockStainedGlass"));
            mObInitMap.put(new Pair<String, String>("abt", "net/minecraft/creativetab/CreativeTabs"));
            mObInitMap.put(new Pair<String, String>("afs", "net/minecraft/enchantment/EnchantmentDigging"));
            mObInitMap.put(new Pair<String, String>("ajr", "net/minecraft/block/BlockBush"));
            mObInitMap.put(new Pair<String, String>("avo", "net/minecraft/world/gen/structure/MapGenVillage$Start"));
            mObInitMap.put(new Pair<String, String>("brs", "net/minecraft/client/resources/Locale"));
            mObInitMap.put(new Pair<String, String>("bbw", "net/minecraft/client/gui/Gui"));
            mObInitMap.put(new Pair<String, String>("bfv", "net/minecraft/client/gui/GuiMerchant"));
            mObInitMap.put(new Pair<String, String>("bju", "net/minecraft/client/particle/EntityBreakingFX"));
            mObInitMap.put(new Pair<String, String>("bnt", "net/minecraft/client/renderer/entity/RenderGhast"));
            mObInitMap.put(new Pair<String, String>("wl", "net/minecraft/entity/monster/EntityGolem"));
            mObInitMap.put(new Pair<String, String>("sm", "net/minecraft/command/IEntitySelector$3"));
            mObInitMap.put(new Pair<String, String>("on", "net/minecraft/server/management/UserList$1"));
            mObInitMap.put(new Pair<String, String>("ko", "net/minecraft/init/Bootstrap$11"));
            mObInitMap.put(new Pair<String, String>("gp", "net/minecraft/network/play/server/S31PacketWindowProperty"));
            mObInitMap.put(new Pair<String, String>("cq", "net/minecraft/dispenser/IBehaviorDispenseItem$1"));
            mObInitMap.put(new Pair<String, String>("aoe", "net/minecraft/block/BlockTrapDoor"));
            mObInitMap.put(new Pair<String, String>("akf", "net/minecraft/block/BlockCrops"));
            mObInitMap.put(new Pair<String, String>("ach", "net/minecraft/item/ItemDoor"));
            mObInitMap.put(new Pair<String, String>("agg", "net/minecraft/enchantment/EnchantmentLootBonus"));
            mObInitMap.put(new Pair<String, String>("bsg", "net/minecraft/client/resources/data/PackMetadataSection"));
            mObInitMap.put(new Pair<String, String>("bck", "net/minecraft/client/gui/GuiOptionsRowList"));
            mObInitMap.put(new Pair<String, String>("bgj", "net/minecraft/client/gui/GuiResourcePackAvailable"));
            mObInitMap.put(new Pair<String, String>("bki", "net/minecraft/client/particle/EntityLargeExplodeFX"));
            mObInitMap.put(new Pair<String, String>("boh", "net/minecraft/client/renderer/entity/RendererLivingEntity"));
            mObInitMap.put(new Pair<String, String>("lc", "net/minecraft/client/util/JsonException$1"));
            mObInitMap.put(new Pair<String, String>("hd", "net/minecraft/network/play/server/S01PacketJoinGame"));
            mObInitMap.put(new Pair<String, String>("de", "net/minecraft/util/StringTranslate"));
            mObInitMap.put(new Pair<String, String>("wk", "net/minecraft/entity/passive/EntityHorse$GroupData"));
            mObInitMap.put(new Pair<String, String>("asc", "net/minecraft/world/gen/feature/WorldGenMelon"));
            mObInitMap.put(new Pair<String, String>("aod", "net/minecraft/block/BlockLeavesBase"));
            mObInitMap.put(new Pair<String, String>("awb", "net/minecraft/world/gen/structure/StructureVillagePieces$Path"));
            mObInitMap.put(new Pair<String, String>("pa", "net/minecraft/network/rcon/RConThreadMain"));
            mObInitMap.put(new Pair<String, String>("asv", "net/minecraft/world/gen/structure/StructureBoundingBox"));
            mObInitMap.put(new Pair<String, String>("aow", "net/minecraft/tileentity/TileEntityChest"));
            mObInitMap.put(new Pair<String, String>("akx", "net/minecraft/block/BlockFalling"));
            mObInitMap.put(new Pair<String, String>("acz", "net/minecraft/item/ItemHangingEntity"));
            mObInitMap.put(new Pair<String, String>("agy", "net/minecraft/world/GameRules"));
            mObInitMap.put(new Pair<String, String>("awu", "net/minecraft/block/material/Material$1"));
            mObInitMap.put(new Pair<String, String>("bdr", "net/minecraft/client/gui/GuiFlatPresets$LayerItem"));
            mObInitMap.put(new Pair<String, String>("bsy", "net/minecraft/server/integrated/IntegratedServer$1"));
            mObInitMap.put(new Pair<String, String>("boz", "net/minecraft/client/renderer/entity/RenderIronGolem"));
            mObInitMap.put(new Pair<String, String>("xr", "net/minecraft/entity/item/EntityMinecartHopper"));
            mObInitMap.put(new Pair<String, String>("pt", "net/minecraft/util/CryptManager"));
            mObInitMap.put(new Pair<String, String>("lu", "net/minecraft/server/dedicated/DedicatedServer$1"));
            mObInitMap.put(new Pair<String, String>("hv", "net/minecraft/network/play/server/S3DPacketDisplayScoreboard"));
            mObInitMap.put(new Pair<String, String>("dw", "net/minecraft/nbt/NBTTagShort"));
            mObInitMap.put(new Pair<String, String>("atj", "net/minecraft/world/gen/structure/StructureNetherBridgePieces$Corridor3"));
            mObInitMap.put(new Pair<String, String>("apk", "net/minecraft/tileentity/TileEntityMobSpawner$1"));
            mObInitMap.put(new Pair<String, String>("all", "net/minecraft/block/BlockHardenedClay"));
            mObInitMap.put(new Pair<String, String>("adn", "net/minecraft/item/ItemPickaxe"));
            mObInitMap.put(new Pair<String, String>("ahm", "net/minecraft/world/WorldType"));
            mObInitMap.put(new Pair<String, String>("btm", "net/minecraft/client/audio/SoundManager$2$1"));
            mObInitMap.put(new Pair<String, String>("bpn", "net/minecraft/client/shader/ShaderLinkHelper"));
            mObInitMap.put(new Pair<String, String>("bdq", "net/minecraft/client/gui/GuiFlatPresets"));
            mObInitMap.put(new Pair<String, String>("bhp", "net/minecraft/client/model/ModelLeashKnot"));
            mObInitMap.put(new Pair<String, String>("blo", "net/minecraft/client/renderer/WorldRenderer"));
            mObInitMap.put(new Pair<String, String>("yf", "net/minecraft/entity/monster/EntityMagmaCube"));
            mObInitMap.put(new Pair<String, String>("ug", "net/minecraft/entity/ai/EntityAIFollowOwner"));
            mObInitMap.put(new Pair<String, String>("qh", "net/minecraft/util/MathHelper"));
            mObInitMap.put(new Pair<String, String>("ij", "net/minecraft/network/play/server/S0DPacketCollectItem"));
            mObInitMap.put(new Pair<String, String>("ek", "net/minecraft/network/NetworkManager$1"));
            mObInitMap.put(new Pair<String, String>("al", "net/minecraft/command/CommandDefaultGameMode"));
            mObInitMap.put(new Pair<String, String>("aeb", "net/minecraft/item/ItemSkull"));
            mObInitMap.put(new Pair<String, String>("aac", "net/minecraft/inventory/ICrafting"));
            mObInitMap.put(new Pair<String, String>("aia", "net/minecraft/world/biome/BiomeDecorator"));
            mObInitMap.put(new Pair<String, String>("c", "net/minecraft/crash/CrashReport$1"));
            mObInitMap.put(new Pair<String, String>("bua", "net/minecraft/client/stream/BroadcastController"));
            mObInitMap.put(new Pair<String, String>("bqb", "net/minecraft/client/renderer/texture/TextureMap$2"));
            mObInitMap.put(new Pair<String, String>("baf", "net/minecraft/scoreboard/ScoreDummyCriteria"));
            mObInitMap.put(new Pair<String, String>("bee", "net/minecraft/client/gui/GuiMainMenu"));
            mObInitMap.put(new Pair<String, String>("bmc", "net/minecraft/client/renderer/ImageBufferDownload"));
            mObInitMap.put(new Pair<String, String>("ye", "net/minecraft/entity/monster/EntityGiantZombie"));
            mObInitMap.put(new Pair<String, String>("aav", "net/minecraft/inventory/InventoryEnderChest"));
            mObInitMap.put(new Pair<String, String>("v", "net/minecraft/util/Util$EnumOS"));
            mObInitMap.put(new Pair<String, String>("bay", "net/minecraft/client/Minecraft$2"));
            mObInitMap.put(new Pair<String, String>("bex", "net/minecraft/client/gui/inventory/GuiContainer"));
            mObInitMap.put(new Pair<String, String>("bmv", "net/minecraft/client/renderer/culling/ICamera"));
            mObInitMap.put(new Pair<String, String>("bs", "net/minecraft/command/CommandSpreadPlayers$Position"));
            mObInitMap.put(new Pair<String, String>("yx", "net/minecraft/entity/player/InventoryPlayer"));
            mObInitMap.put(new Pair<String, String>("uy", "net/minecraft/entity/ai/EntityAIOpenDoor"));
            mObInitMap.put(new Pair<String, String>("aqq", "net/minecraft/world/WorldProviderSurface"));
            mObInitMap.put(new Pair<String, String>("amr", "net/minecraft/block/BlockPotato"));
            mObInitMap.put(new Pair<String, String>("ais", "net/minecraft/world/biome/BiomeGenSavanna"));
            mObInitMap.put(new Pair<String, String>("aup", "net/minecraft/world/gen/structure/StructureStrongholdPieces$LeftTurn"));
            mObInitMap.put(new Pair<String, String>("ayo", "net/minecraft/world/chunk/storage/AnvilSaveConverter$1"));
            mObInitMap.put(new Pair<String, String>("bbm", "net/minecraft/client/settings/GameSettings$Options"));
            mObInitMap.put(new Pair<String, String>("bus", "net/minecraft/realms/RealmsConnect$1"));
            mObInitMap.put(new Pair<String, String>("bqt", "net/minecraft/client/resources/FoliageColorReloadListener"));
            mObInitMap.put(new Pair<String, String>("zl", "net/minecraft/entity/projectile/EntityEgg"));
            mObInitMap.put(new Pair<String, String>("vm", "net/minecraft/entity/ai/EntityAIDefendVillage"));
            mObInitMap.put(new Pair<String, String>("rn", "net/minecraft/util/CombatTracker"));
            mObInitMap.put(new Pair<String, String>("no", "net/minecraft/server/network/NetHandlerLoginServer$1"));
            mObInitMap.put(new Pair<String, String>("jp", "net/minecraft/network/handshake/client/C00Handshake"));
            mObInitMap.put(new Pair<String, String>("fq", "net/minecraft/util/ChatComponentText"));
            mObInitMap.put(new Pair<String, String>("br", "net/minecraft/command/CommandSpreadPlayers"));
            mObInitMap.put(new Pair<String, String>("are", "net/minecraft/world/gen/feature/WorldGenForest"));
            mObInitMap.put(new Pair<String, String>("anf", "net/minecraft/block/BlockRedstoneRepeater"));
            mObInitMap.put(new Pair<String, String>("abi", "net/minecraft/item/ItemReed"));
            mObInitMap.put(new Pair<String, String>("afh", "net/minecraft/item/crafting/ShapedRecipes"));
            mObInitMap.put(new Pair<String, String>("ajg", "net/minecraft/block/BlockBeacon"));
            mObInitMap.put(new Pair<String, String>("avd", "net/minecraft/world/gen/structure/StructureStrongholdPieces$Stronghold$Door"));
            mObInitMap.put(new Pair<String, String>("azc", "net/minecraft/world/storage/ISaveHandler"));
            mObInitMap.put(new Pair<String, String>("brh", "net/minecraft/client/resources/SimpleReloadableResourceManager$1"));
            mObInitMap.put(new Pair<String, String>("bfk", "net/minecraft/client/gui/inventory/CreativeCrafting"));
            mObInitMap.put(new Pair<String, String>("bjj", "net/minecraft/client/multiplayer/WorldClient$4"));
            mObInitMap.put(new Pair<String, String>("bni", "net/minecraft/client/renderer/entity/RenderCreeper"));
            mObInitMap.put(new Pair<String, String>("wa", "net/minecraft/village/Village$VillageAgressor"));
            mObInitMap.put(new Pair<String, String>("sb", "net/minecraft/entity/Entity$1"));
            mObInitMap.put(new Pair<String, String>("oc", "net/minecraft/server/management/PreYggdrasilConverter$3"));
            mObInitMap.put(new Pair<String, String>("kd", "net/minecraft/network/ServerStatusResponse$PlayerCountData$Serializer"));
            mObInitMap.put(new Pair<String, String>("ge", "net/minecraft/network/play/server/S25PacketBlockBreakAnim"));
            mObInitMap.put(new Pair<String, String>("cf", "net/minecraft/command/SyntaxErrorException"));
            mObInitMap.put(new Pair<String, String>("any", "net/minecraft/block/BlockStoneSlab"));
            mObInitMap.put(new Pair<String, String>("ajz", "net/minecraft/block/BlockCocoa"));
            mObInitMap.put(new Pair<String, String>("azb", "net/minecraft/world/storage/WorldInfo$9"));
            mObInitMap.put(new Pair<String, String>("ov", "net/minecraft/network/rcon/RConConsoleSource"));
            mObInitMap.put(new Pair<String, String>("kw", "net/minecraft/init/Bootstrap$5$1"));
            mObInitMap.put(new Pair<String, String>("gx", "net/minecraft/network/play/server/S21PacketChunkData"));
            mObInitMap.put(new Pair<String, String>("cy", "net/minecraft/dispenser/PositionImpl"));
            mObInitMap.put(new Pair<String, String>("acp", "net/minecraft/item/ItemExpBottle"));
            mObInitMap.put(new Pair<String, String>("bop", "net/minecraft/client/renderer/entity/RenderPlayer"));
            mObInitMap.put(new Pair<String, String>("arw", "net/minecraft/world/gen/feature/WorldGenIceSpike"));
            mObInitMap.put(new Pair<String, String>("anx", "net/minecraft/block/BlockButtonStone"));
            mObInitMap.put(new Pair<String, String>("avv", "net/minecraft/world/gen/structure/StructureVillagePieces$Hall"));
            mObInitMap.put(new Pair<String, String>("azu", "net/minecraft/util/MovingObjectPosition"));
            mObInitMap.put(new Pair<String, String>("bcs", "net/minecraft/client/gui/ScreenChatOptions"));
            mObInitMap.put(new Pair<String, String>("bgr", "net/minecraft/client/gui/stream/GuiStreamUnavailable$Reason"));
            mObInitMap.put(new Pair<String, String>("bkq", "net/minecraft/client/particle/EffectRenderer$3"));
            mObInitMap.put(new Pair<String, String>("dm", "net/minecraft/nbt/NBTTagFloat"));
            mObInitMap.put(new Pair<String, String>("ws", "net/minecraft/entity/passive/EntitySquid"));
            mObInitMap.put(new Pair<String, String>("st", "net/minecraft/entity/item/EntityItemFrame"));
            mObInitMap.put(new Pair<String, String>("ou", "net/minecraft/network/rcon/RConUtils"));
            mObInitMap.put(new Pair<String, String>("ask", "net/minecraft/world/gen/feature/WorldGenSavannaTree"));
            mObInitMap.put(new Pair<String, String>("aol", "net/minecraft/block/BlockPressurePlateWeighted"));
            mObInitMap.put(new Pair<String, String>("akm", "net/minecraft/block/BlockDispenser"));
            mObInitMap.put(new Pair<String, String>("aco", "net/minecraft/item/ItemEnderPearl"));
            mObInitMap.put(new Pair<String, String>("agn", "net/minecraft/village/MerchantRecipe"));
            mObInitMap.put(new Pair<String, String>("awj", "net/minecraft/world/gen/NoiseGeneratorImproved"));
            mObInitMap.put(new Pair<String, String>("bdg", "net/minecraft/client/gui/GuiScreenAddServer"));
            mObInitMap.put(new Pair<String, String>("bsn", "net/minecraft/client/audio/MovingSoundMinecartRiding"));
            mObInitMap.put(new Pair<String, String>("boo", "net/minecraft/client/renderer/entity/RenderPig"));
            mObInitMap.put(new Pair<String, String>("xg", "net/minecraft/entity/effect/EntityWeatherEffect"));
            mObInitMap.put(new Pair<String, String>("th", "net/minecraft/entity/ai/attributes/IAttribute"));
            mObInitMap.put(new Pair<String, String>("pi", "net/minecraft/stats/StatBase$1"));
            mObInitMap.put(new Pair<String, String>("lj", "net/minecraft/server/MinecraftServer$3"));
            mObInitMap.put(new Pair<String, String>("hk", "net/minecraft/network/play/server/S39PacketPlayerAbilities"));
            mObInitMap.put(new Pair<String, String>("dl", "net/minecraft/nbt/NBTTagEnd"));
            mObInitMap.put(new Pair<String, String>("ala", "net/minecraft/block/BlockFenceGate"));
            mObInitMap.put(new Pair<String, String>("adc", "net/minecraft/item/Item$ToolMaterial"));
            mObInitMap.put(new Pair<String, String>("ahb", "net/minecraft/world/World"));
            mObInitMap.put(new Pair<String, String>("btb", "net/minecraft/client/network/LanServerDetector$LanServer"));
            mObInitMap.put(new Pair<String, String>("bpc", "net/minecraft/client/renderer/entity/RenderWither"));
            mObInitMap.put(new Pair<String, String>("bdf", "net/minecraft/client/gui/GuiDisconnected"));
            mObInitMap.put(new Pair<String, String>("bhe", "net/minecraft/client/model/ModelBoat"));
            mObInitMap.put(new Pair<String, String>("bld", "net/minecraft/client/particle/EntityDiggingFX"));
            mObInitMap.put(new Pair<String, String>("xz", "net/minecraft/entity/monster/EntityCreeper"));
            mObInitMap.put(new Pair<String, String>("aa", "net/minecraft/command/ICommand"));
            mObInitMap.put(new Pair<String, String>("alt", "net/minecraft/block/BlockLeaves"));
            mObInitMap.put(new Pair<String, String>("adv", "net/minecraft/item/ItemSeedFood"));
            mObInitMap.put(new Pair<String, String>("ahu", "net/minecraft/world/biome/BiomeGenBase"));
            mObInitMap.put(new Pair<String, String>("btu", "net/minecraft/client/audio/ISoundEventAccessor"));
            mObInitMap.put(new Pair<String, String>("bpv", "net/minecraft/client/renderer/texture/Stitcher"));
            mObInitMap.put(new Pair<String, String>("bdy", "net/minecraft/client/gui/GuiSelectWorld$List"));
            mObInitMap.put(new Pair<String, String>("bhx", "net/minecraft/client/model/ModelSheep1"));
            mObInitMap.put(new Pair<String, String>("blw", "net/minecraft/client/renderer/EntityRenderer$3"));
            mObInitMap.put(new Pair<String, String>("mq", "net/minecraft/server/management/PlayerManager"));
            mObInitMap.put(new Pair<String, String>("ir", "net/minecraft/network/play/client/C01PacketChatMessage"));
            mObInitMap.put(new Pair<String, String>("es", "net/minecraft/network/EnumConnectionState$1"));
            mObInitMap.put(new Pair<String, String>("at", "net/minecraft/command/CommandGive"));
            mObInitMap.put(new Pair<String, String>("xy", "net/minecraft/entity/monster/EntityCaveSpider"));
            mObInitMap.put(new Pair<String, String>("aej", "net/minecraft/item/ItemLilyPad"));
            mObInitMap.put(new Pair<String, String>("aak", "net/minecraft/inventory/SlotFurnace"));
            mObInitMap.put(new Pair<String, String>("k", "net/minecraft/crash/CrashReportCategory"));
            mObInitMap.put(new Pair<String, String>("atq", "net/minecraft/world/gen/structure/StructureNetherBridgePieces$NetherStalkRoom"));
            mObInitMap.put(new Pair<String, String>("apr", "net/minecraft/block/BlockPistonMoving"));
            mObInitMap.put(new Pair<String, String>("axp", "net/minecraft/world/gen/layer/GenLayer$2"));
            mObInitMap.put(new Pair<String, String>("ban", "net/minecraft/client/renderer/GLAllocation"));
            mObInitMap.put(new Pair<String, String>("bem", "net/minecraft/client/gui/achievement/GuiStats$StatsGeneral"));
            mObInitMap.put(new Pair<String, String>("bil", "net/minecraft/client/model/ModelZombieVillager"));
            mObInitMap.put(new Pair<String, String>("bmk", "net/minecraft/client/renderer/tileentity/TileEntityRendererDispatcher"));
            mObInitMap.put(new Pair<String, String>("bh", "net/minecraft/command/server/CommandSaveAll"));
            mObInitMap.put(new Pair<String, String>("ym", "net/minecraft/entity/monster/EntitySlime"));
            mObInitMap.put(new Pair<String, String>("un", "net/minecraft/entity/ai/EntityAIWatchClosest"));
            mObInitMap.put(new Pair<String, String>("mp", "net/minecraft/world/WorldManager"));
            mObInitMap.put(new Pair<String, String>("aqf", "net/minecraft/world/chunk/storage/ChunkLoader"));
            mObInitMap.put(new Pair<String, String>("amg", "net/minecraft/block/BlockNetherrack"));
            mObInitMap.put(new Pair<String, String>("aei", "net/minecraft/item/EnumAction"));
            mObInitMap.put(new Pair<String, String>("aih", "net/minecraft/world/biome/BiomeGenForest$2"));
            mObInitMap.put(new Pair<String, String>("aue", "net/minecraft/world/gen/structure/ComponentScatteredFeaturePieces$Feature"));
            mObInitMap.put(new Pair<String, String>("ayd", "net/minecraft/pathfinding/Path"));
            mObInitMap.put(new Pair<String, String>("bbb", "net/minecraft/client/Minecraft$5"));
            mObInitMap.put(new Pair<String, String>("bfa", "net/minecraft/client/gui/inventory/GuiBeacon$CancelButton"));
            mObInitMap.put(new Pair<String, String>("buh", "net/minecraft/client/stream/ChatController$ChatListener"));
            mObInitMap.put(new Pair<String, String>("bqi", "net/minecraft/client/renderer/texture/TextureUtil"));
            mObInitMap.put(new Pair<String, String>("za", "net/minecraft/entity/player/EntityPlayer$EnumStatus"));
            mObInitMap.put(new Pair<String, String>("vb", "net/minecraft/entity/ai/EntityAILookIdle"));
            mObInitMap.put(new Pair<String, String>("rc", "net/minecraft/inventory/IInvBasic"));
            mObInitMap.put(new Pair<String, String>("nd", "net/minecraft/network/NetworkSystem$1"));
            mObInitMap.put(new Pair<String, String>("je", "net/minecraft/network/play/client/C03PacketPlayer$C04PacketPlayerPosition"));
            mObInitMap.put(new Pair<String, String>("ff", "net/minecraft/util/ChatComponentStyle$1"));
            mObInitMap.put(new Pair<String, String>("aqy", "net/minecraft/world/gen/MapGenCavesHell"));
            mObInitMap.put(new Pair<String, String>("amz", "net/minecraft/block/BlockRedstoneOre"));
            mObInitMap.put(new Pair<String, String>("ayw", "net/minecraft/world/storage/WorldInfo$4"));
            mObInitMap.put(new Pair<String, String>("zt", "net/minecraft/inventory/AnimalChest"));
            mObInitMap.put(new Pair<String, String>("vu", "net/minecraft/entity/ai/EntityAITarget"));
            mObInitMap.put(new Pair<String, String>("rv", "net/minecraft/potion/Potion"));
            mObInitMap.put(new Pair<String, String>("nw", "net/minecraft/server/management/PlayerProfileCache$Serializer"));
            mObInitMap.put(new Pair<String, String>("jx", "net/minecraft/network/login/client/C01PacketEncryptionResponse"));
            mObInitMap.put(new Pair<String, String>("fy", "net/minecraft/network/play/server/S2CPacketSpawnGlobalEntity"));
            mObInitMap.put(new Pair<String, String>("bz", "net/minecraft/command/CommandTime"));
            mObInitMap.put(new Pair<String, String>("ann", "net/minecraft/block/BlockSnow"));
            mObInitMap.put(new Pair<String, String>("abq", "net/minecraft/item/ItemCoal"));
            mObInitMap.put(new Pair<String, String>("afp", "net/minecraft/enchantment/EnchantmentArrowKnockback"));
            mObInitMap.put(new Pair<String, String>("ajo", "net/minecraft/block/IGrowable"));
            mObInitMap.put(new Pair<String, String>("brp", "net/minecraft/client/resources/I18n"));
            mObInitMap.put(new Pair<String, String>("ayv", "net/minecraft/world/storage/WorldInfo$3"));
            mObInitMap.put(new Pair<String, String>("bbt", "net/minecraft/util/Session$Type"));
            mObInitMap.put(new Pair<String, String>("bfs", "net/minecraft/client/gui/GuiHopper"));
            mObInitMap.put(new Pair<String, String>("bjr", "net/minecraft/client/network/OldServerPinger$1"));
            mObInitMap.put(new Pair<String, String>("bnq", "net/minecraft/client/renderer/entity/RenderFallingBlock"));
            mObInitMap.put(new Pair<String, String>("ok", "net/minecraft/server/management/UserListOpsEntry"));
            mObInitMap.put(new Pair<String, String>("kl", "net/minecraft/init/Bootstrap"));
            mObInitMap.put(new Pair<String, String>("gm", "net/minecraft/network/play/server/S2EPacketCloseWindow"));
            mObInitMap.put(new Pair<String, String>("cn", "net/minecraft/util/RegistryNamespacedDefaultedByKey"));
            mObInitMap.put(new Pair<String, String>("zs", "net/minecraft/inventory/Container"));
            mObInitMap.put(new Pair<String, String>("ace", "net/minecraft/creativetab/CreativeTabs$8"));
            mObInitMap.put(new Pair<String, String>("arl", "net/minecraft/world/gen/feature/WorldGenDesertWells"));
            mObInitMap.put(new Pair<String, String>("anm", "net/minecraft/block/BlockSnowBlock"));
            mObInitMap.put(new Pair<String, String>("avk", "net/minecraft/world/gen/structure/StructureComponent"));
            mObInitMap.put(new Pair<String, String>("bch", "net/minecraft/client/gui/GuiListExtended"));
            mObInitMap.put(new Pair<String, String>("bgg", "net/minecraft/client/resources/ResourcePackListEntry"));
            mObInitMap.put(new Pair<String, String>("bkf", "net/minecraft/client/particle/EntityFlameFX"));
            mObInitMap.put(new Pair<String, String>("boe", "net/minecraft/client/renderer/entity/RenderMagmaCube"));
            mObInitMap.put(new Pair<String, String>("wh", "net/minecraft/entity/passive/EntityCow"));
            mObInitMap.put(new Pair<String, String>("oj", "net/minecraft/server/management/UserListOps"));
            mObInitMap.put(new Pair<String, String>("aoa", "net/minecraft/block/BlockPane"));
            mObInitMap.put(new Pair<String, String>("akb", "net/minecraft/block/BlockCommandBlock"));
            mObInitMap.put(new Pair<String, String>("acd", "net/minecraft/creativetab/CreativeTabs$7"));
            mObInitMap.put(new Pair<String, String>("agc", "net/minecraft/enchantment/EnchantmentData"));
            mObInitMap.put(new Pair<String, String>("bsc", "net/minecraft/client/resources/data/FontMetadataSection"));
            mObInitMap.put(new Pair<String, String>("bod", "net/minecraft/client/renderer/entity/RenderSnowball"));
            mObInitMap.put(new Pair<String, String>("net/minecraft/realms/RealmsBridge", "net/minecraft/realms/RealmsBridge"));
            mObInitMap.put(new Pair<String, String>("da", "net/minecraft/util/RegistrySimple"));
            mObInitMap.put(new Pair<String, String>("ass", "net/minecraft/world/gen/FlatGeneratorInfo"));
            mObInitMap.put(new Pair<String, String>("aot", "net/minecraft/tileentity/TileEntity$2"));
            mObInitMap.put(new Pair<String, String>("aku", "net/minecraft/block/BlockEndPortalFrame"));
            mObInitMap.put(new Pair<String, String>("acw", "net/minecraft/item/ItemFlintAndSteel"));
            mObInitMap.put(new Pair<String, String>("awr", "net/minecraft/block/material/MaterialTransparent"));
            mObInitMap.put(new Pair<String, String>("bsv", "net/minecraft/client/audio/ITickableSound"));
            mObInitMap.put(new Pair<String, String>("bow", "net/minecraft/client/renderer/entity/RenderSquid"));
            mObInitMap.put(new Pair<String, String>("bcz", "net/minecraft/client/gui/GuiCreateFlatWorld"));
            mObInitMap.put(new Pair<String, String>("bkx", "net/minecraft/client/particle/EntitySpellParticleFX"));
            mObInitMap.put(new Pair<String, String>("xo", "net/minecraft/entity/EntityMinecartCommandBlock$1"));
            mObInitMap.put(new Pair<String, String>("pq", "net/minecraft/stats/StatFileWriter"));
            mObInitMap.put(new Pair<String, String>("lr", "net/minecraft/server/gui/IUpdatePlayerListBox"));
            mObInitMap.put(new Pair<String, String>("hs", "net/minecraft/network/play/server/S07PacketRespawn"));
            mObInitMap.put(new Pair<String, String>("dt", "net/minecraft/nbt/NBTSizeTracker$1"));
            mObInitMap.put(new Pair<String, String>("aph", "net/minecraft/tileentity/IHopper"));
            mObInitMap.put(new Pair<String, String>("ali", "net/minecraft/block/BlockGravel"));
            mObInitMap.put(new Pair<String, String>("adk", "net/minecraft/item/ItemMinecart$1"));
            mObInitMap.put(new Pair<String, String>("ahj", "net/minecraft/world/WorldSettings"));
            mObInitMap.put(new Pair<String, String>("btj", "net/minecraft/client/audio/SoundManager"));
            mObInitMap.put(new Pair<String, String>("bpk", "net/minecraft/client/shader/Shader"));
            mObInitMap.put(new Pair<String, String>("bdn", "net/minecraft/client/gui/GuiOptions$1"));
            mObInitMap.put(new Pair<String, String>("bhm", "net/minecraft/client/model/ModelBiped"));
            mObInitMap.put(new Pair<String, String>("bll", "net/minecraft/client/entity/EntityOtherPlayerMP"));
            mObInitMap.put(new Pair<String, String>("mf", "net/minecraft/server/gui/StatsComponent"));
            mObInitMap.put(new Pair<String, String>("ig", "net/minecraft/network/play/server/S05PacketSpawnPosition"));
            mObInitMap.put(new Pair<String, String>("eh", "net/minecraft/network/NettyEncryptingDecoder"));
            mObInitMap.put(new Pair<String, String>("ai", "net/minecraft/command/CommandClearInventory"));
            mObInitMap.put(new Pair<String, String>("xn", "net/minecraft/entity/EntityMinecartCommandBlock"));
            mObInitMap.put(new Pair<String, String>("atf", "net/minecraft/world/gen/structure/StructureNetherBridgePieces"));
            mObInitMap.put(new Pair<String, String>("apg", "net/minecraft/tileentity/TileEntityFurnace"));
            mObInitMap.put(new Pair<String, String>("axe", "net/minecraft/world/gen/layer/GenLayerBiomeEdge"));
            mObInitMap.put(new Pair<String, String>("bac", "net/minecraft/scoreboard/Scoreboard"));
            mObInitMap.put(new Pair<String, String>("beb", "net/minecraft/client/gui/GuiSnooper$List"));
            mObInitMap.put(new Pair<String, String>("bia", "net/minecraft/client/model/ModelSilverfish"));
            mObInitMap.put(new Pair<String, String>("yb", "net/minecraft/entity/monster/IMob"));
            mObInitMap.put(new Pair<String, String>("uc", "net/minecraft/entity/ai/EntityAIDoorInteract"));
            mObInitMap.put(new Pair<String, String>("qd", "net/minecraft/util/LongHashMap"));
            mObInitMap.put(new Pair<String, String>("s", "net/minecraft/util/ReportedException"));
            mObInitMap.put(new Pair<String, String>("net/minecraft/client/ClientBrandRetriever", "net/minecraft/client/ClientBrandRetriever"));
            mObInitMap.put(new Pair<String, String>("apz", "net/minecraft/world/chunk/storage/ExtendedBlockStorage"));
            mObInitMap.put(new Pair<String, String>("aty", "net/minecraft/world/gen/structure/MapGenScatteredFeature$Start"));
            mObInitMap.put(new Pair<String, String>("axx", "net/minecraft/world/gen/layer/GenLayerSmooth"));
            mObInitMap.put(new Pair<String, String>("bav", "net/minecraft/client/Minecraft$15"));
            mObInitMap.put(new Pair<String, String>("beu", "net/minecraft/client/gui/GuiKeyBindingList$CategoryEntry"));
            mObInitMap.put(new Pair<String, String>("yu", "net/minecraft/entity/INpc"));
            mObInitMap.put(new Pair<String, String>("uv", "net/minecraft/entity/ai/EntityAIOcelotAttack"));
            mObInitMap.put(new Pair<String, String>("qw", "net/minecraft/util/WeightedRandom$Item"));
            mObInitMap.put(new Pair<String, String>("mx", "net/minecraft/server/management/ItemInWorldManager"));
            mObInitMap.put(new Pair<String, String>("iy", "net/minecraft/network/play/client/C0DPacketCloseWindow"));
            mObInitMap.put(new Pair<String, String>("ez", "net/minecraft/util/MessageDeserializer"));
            mObInitMap.put(new Pair<String, String>("amo", "net/minecraft/block/BlockPackedIce"));
            mObInitMap.put(new Pair<String, String>("aip", "net/minecraft/world/biome/BiomeGenPlains"));
            mObInitMap.put(new Pair<String, String>("aum", "net/minecraft/world/gen/structure/StructureStrongholdPieces$ChestCorridor"));
            mObInitMap.put(new Pair<String, String>("ayl", "net/minecraft/world/WorldSavedData"));
            mObInitMap.put(new Pair<String, String>("bup", "net/minecraft/client/stream/TwitchStream$1"));
            mObInitMap.put(new Pair<String, String>("bqq", "net/minecraft/client/resources/FallbackResourceManager"));
            mObInitMap.put(new Pair<String, String>("bet", "net/minecraft/client/gui/GuiKeyBindingList$1"));
            mObInitMap.put(new Pair<String, String>("bis", "net/minecraft/client/model/ModelBox"));
            mObInitMap.put(new Pair<String, String>("bmr", "net/minecraft/client/renderer/tileentity/TileEntitySignRenderer"));
            mObInitMap.put(new Pair<String, String>("zi", "net/minecraft/entity/projectile/EntitySmallFireball"));
            mObInitMap.put(new Pair<String, String>("vj", "net/minecraft/entity/ai/EntityAIFollowGolem"));
            mObInitMap.put(new Pair<String, String>("rk", "net/minecraft/profiler/IPlayerUsage"));
            mObInitMap.put(new Pair<String, String>("nl", "net/minecraft/server/network/NetHandlerHandshakeTCP"));
            mObInitMap.put(new Pair<String, String>("jm", "net/minecraft/network/play/client/C10PacketCreativeInventoryAction"));
            mObInitMap.put(new Pair<String, String>("fn", "net/minecraft/util/ChatStyle"));
            mObInitMap.put(new Pair<String, String>("bo", "net/minecraft/command/CommandSetPlayerTimeout"));
            mObInitMap.put(new Pair<String, String>("anc", "net/minecraft/block/BlockRedstoneTorch"));
            mObInitMap.put(new Pair<String, String>("abf", "net/minecraft/item/ItemAxe"));
            mObInitMap.put(new Pair<String, String>("afe", "net/minecraft/item/crafting/CraftingManager"));
            mObInitMap.put(new Pair<String, String>("ajd", "net/minecraft/block/BlockBasePressurePlate"));
            mObInitMap.put(new Pair<String, String>("bre", "net/minecraft/client/resources/ResourcePackRepository$2"));
            mObInitMap.put(new Pair<String, String>("ayk", "net/minecraft/world/storage/MapData$MapCoord"));
            mObInitMap.put(new Pair<String, String>("bfh", "net/minecraft/client/gui/GuiCommandBlock"));
            mObInitMap.put(new Pair<String, String>("bjg", "net/minecraft/client/multiplayer/WorldClient$1"));
            mObInitMap.put(new Pair<String, String>("bnf", "net/minecraft/client/renderer/entity/RenderCaveSpider"));
            mObInitMap.put(new Pair<String, String>("ka", "net/minecraft/network/status/server/S00PacketServerInfo"));
            mObInitMap.put(new Pair<String, String>("gb", "net/minecraft/network/play/server/S0CPacketSpawnPlayer"));
            mObInitMap.put(new Pair<String, String>("cc", "net/minecraft/command/server/CommandWhitelist"));
            mObInitMap.put(new Pair<String, String>("zh", "net/minecraft/entity/IProjectile"));
            mObInitMap.put(new Pair<String, String>("aby", "net/minecraft/creativetab/CreativeTabs$2"));
            mObInitMap.put(new Pair<String, String>("ara", "net/minecraft/world/gen/ChunkProviderEnd"));
            mObInitMap.put(new Pair<String, String>("anb", "net/minecraft/block/BlockRedstoneLight"));
            mObInitMap.put(new Pair<String, String>("bjz", "net/minecraft/client/particle/EntityEnchantmentTableParticleFX"));
            mObInitMap.put(new Pair<String, String>("bny", "net/minecraft/client/renderer/entity/RenderItem"));
            mObInitMap.put(new Pair<String, String>("cv", "net/minecraft/dispenser/ILocation"));
            mObInitMap.put(new Pair<String, String>("anu", "net/minecraft/block/BlockStem"));
            mObInitMap.put(new Pair<String, String>("afw", "net/minecraft/enchantment/EnchantmentHelper$1"));
            mObInitMap.put(new Pair<String, String>("ajv", "net/minecraft/block/BlockCarrot"));
            mObInitMap.put(new Pair<String, String>("avs", "net/minecraft/world/gen/structure/StructureVillagePieces$Field2"));
            mObInitMap.put(new Pair<String, String>("azr", "net/minecraft/world/storage/ThreadedFileIOBase"));
            mObInitMap.put(new Pair<String, String>("bcp", "net/minecraft/client/gui/GuiButtonRealmsProxy"));
            mObInitMap.put(new Pair<String, String>("brw", "net/minecraft/client/resources/data/IMetadataSerializer"));
            mObInitMap.put(new Pair<String, String>("bnx", "net/minecraft/client/renderer/tileentity/RenderItemFrame"));
            mObInitMap.put(new Pair<String, String>("wp", "net/minecraft/entity/passive/EntitySheep"));
            mObInitMap.put(new Pair<String, String>("sq", "net/minecraft/entity/item/EntityXPOrb"));
            mObInitMap.put(new Pair<String, String>("or", "net/minecraft/server/management/UserListWhitelist"));
            mObInitMap.put(new Pair<String, String>("ks", "net/minecraft/init/Bootstrap$2"));
            mObInitMap.put(new Pair<String, String>("gt", "net/minecraft/network/play/server/S19PacketEntityStatus"));
            mObInitMap.put(new Pair<String, String>("cu", "net/minecraft/dispenser/ILocatableSource"));
            mObInitMap.put(new Pair<String, String>("ash", "net/minecraft/world/gen/feature/WorldGenReed"));
            mObInitMap.put(new Pair<String, String>("aoi", "net/minecraft/block/BlockWall"));
            mObInitMap.put(new Pair<String, String>("akj", "net/minecraft/block/BlockRedstoneDiode"));
            mObInitMap.put(new Pair<String, String>("acl", "net/minecraft/item/ItemEmptyMap"));
            mObInitMap.put(new Pair<String, String>("agk", "net/minecraft/enchantment/EnchantmentUntouching"));
            mObInitMap.put(new Pair<String, String>("bsk", "net/minecraft/client/audio/PositionedSound"));
            mObInitMap.put(new Pair<String, String>("bol", "net/minecraft/client/renderer/entity/RenderMooshroom"));
            mObInitMap.put(new Pair<String, String>("bgn", "net/minecraft/client/gui/stream/GuiIngestServers$ServerList"));
            mObInitMap.put(new Pair<String, String>("bkm", "net/minecraft/client/particle/EntityFX"));
            mObInitMap.put(new Pair<String, String>("xd", "net/minecraft/entity/boss/EntityWither$1"));
            mObInitMap.put(new Pair<String, String>("te", "net/minecraft/entity/DataWatcher"));
            mObInitMap.put(new Pair<String, String>("pf", "net/minecraft/stats/StatCrafting"));
            mObInitMap.put(new Pair<String, String>("lg", "net/minecraft/server/ServerEula"));
            mObInitMap.put(new Pair<String, String>("hh", "net/minecraft/network/play/server/S14PacketEntity$S17PacketEntityLookMove"));
            mObInitMap.put(new Pair<String, String>("di", "net/minecraft/nbt/NBTTagCompound$1"));
            mObInitMap.put(new Pair<String, String>("bdc", "net/minecraft/client/gui/GuiGameOver"));
            mObInitMap.put(new Pair<String, String>("bla", "net/minecraft/client/particle/EntityAuraFX"));
            mObInitMap.put(new Pair<String, String>("py", "net/minecraft/server/management/LowerStringMap"));
            mObInitMap.put(new Pair<String, String>("lz", "net/minecraft/server/gui/MinecraftServerGui$1"));
            mObInitMap.put(new Pair<String, String>("ads", "net/minecraft/item/ItemRedstone"));
            mObInitMap.put(new Pair<String, String>("bps", "net/minecraft/client/renderer/ThreadDownloadImageData$1"));
            mObInitMap.put(new Pair<String, String>("asz", "net/minecraft/world/gen/structure/StructureMineshaftPieces$Cross"));
            mObInitMap.put(new Pair<String, String>("awy", "net/minecraft/world/gen/layer/GenLayerEdge"));
            mObInitMap.put(new Pair<String, String>("bdv", "net/minecraft/client/gui/GuiRenameWorld"));
            mObInitMap.put(new Pair<String, String>("bhu", "net/minecraft/client/model/ModelPig"));
            mObInitMap.put(new Pair<String, String>("blt", "net/minecraft/client/renderer/EntityRenderer"));
            mObInitMap.put(new Pair<String, String>("ep", "net/minecraft/network/EnumConnectionState$2"));
            mObInitMap.put(new Pair<String, String>("aq", "net/minecraft/command/CommandDifficulty"));
            mObInitMap.put(new Pair<String, String>("xv", "net/minecraft/entity/item/EntityMinecartTNT"));
            mObInitMap.put(new Pair<String, String>("tw", "net/minecraft/entity/ai/EntityAIAvoidEntity"));
            mObInitMap.put(new Pair<String, String>("px", "net/minecraft/util/HttpUtil$DownloadListener"));
            mObInitMap.put(new Pair<String, String>("h", "net/minecraft/crash/CrashReport$6"));
            mObInitMap.put(new Pair<String, String>("atn", "net/minecraft/world/gen/structure/StructureNetherBridgePieces$Corridor"));
            mObInitMap.put(new Pair<String, String>("apo", "net/minecraft/tileentity/TileEntityEndPortal"));
            mObInitMap.put(new Pair<String, String>("alp", "net/minecraft/block/BlockIce"));
            mObInitMap.put(new Pair<String, String>("adr", "net/minecraft/item/ItemRecord"));
            mObInitMap.put(new Pair<String, String>("ahq", "net/minecraft/world/Teleporter$PortalPosition"));
            mObInitMap.put(new Pair<String, String>("axm", "net/minecraft/world/gen/layer/GenLayerIsland"));
            mObInitMap.put(new Pair<String, String>("bak", "net/minecraft/client/gui/ChatLine"));
            mObInitMap.put(new Pair<String, String>("bej", "net/minecraft/client/gui/achievement/GuiStats"));
            mObInitMap.put(new Pair<String, String>("btq", "net/minecraft/client/audio/SoundHandler$1"));
            mObInitMap.put(new Pair<String, String>("bpr", "net/minecraft/client/renderer/ThreadDownloadImageData"));
            mObInitMap.put(new Pair<String, String>("yj", "net/minecraft/entity/SharedMonsterAttributes"));
        }

        static /* synthetic */ boolean access$000() {
            return DevHelperInternals.init();
        }
    }
}

