/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.machines;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GT_UIInfos;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_TieredMachineBlock;
import gregtech.api.objects.GT_RenderedTexture;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import gtPlusPlus.core.util.player.PlayerCache;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class GregtechMetaSafeBlockBase
extends GT_MetaTileEntity_TieredMachineBlock {
    public boolean bOutput = false;
    public boolean bRedstoneIfFull = false;
    public boolean bInvert = false;
    public boolean bUnbreakable = false;
    public int mSuccess = 0;
    public int mTargetStackSize = 0;
    public UUID ownerUUID;

    public GregtechMetaSafeBlockBase(int aID, String aName, String aNameRegional, int aTier, int aInvSlotCount, String aDescription) {
        super(aID, aName, aNameRegional, aTier, aInvSlotCount, aDescription, new ITexture[0]);
    }

    public GregtechMetaSafeBlockBase(String aName, int aTier, int aInvSlotCount, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aInvSlotCount, aDescription, aTextures);
    }

    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[6][17][];
        ITexture tIcon = this.getOverlayIcon();
        GT_RenderedTexture tOut = new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_QCHEST);
        GT_RenderedTexture tUp = new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.MACHINE_CASING_VENT);
        for (int i = -1; i < 16; i = (int)((byte)(i + 1))) {
            rTextures[0][i + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i + 1], tUp, tIcon};
            rTextures[1][i + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i + 1], tIcon};
            rTextures[2][i + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i + 1], tIcon};
            rTextures[3][i + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i + 1], tIcon};
            rTextures[4][i + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i + 1], tIcon};
            rTextures[5][i + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i + 1], tOut};
        }
        return rTextures;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            return this.mTextures[5][aColorIndex + 1];
        }
        if (side.getOpposite() == facing) {
            return this.mTextures[0][aColorIndex + 1];
        }
        switch (facing) {
            case DOWN: {
                return this.mTextures[4][aColorIndex + 1];
            }
            case UP: {
                return this.mTextures[2][aColorIndex + 1];
            }
            case NORTH: {
                switch (side) {
                    case DOWN: {
                        return this.mTextures[2][aColorIndex + 1];
                    }
                    case UP: {
                        return this.mTextures[2][aColorIndex + 1];
                    }
                    case WEST: {
                        return this.mTextures[1][aColorIndex + 1];
                    }
                    case EAST: {
                        return this.mTextures[3][aColorIndex + 1];
                    }
                }
            }
            case SOUTH: {
                switch (side) {
                    case DOWN: {
                        return this.mTextures[4][aColorIndex + 1];
                    }
                    case UP: {
                        return this.mTextures[4][aColorIndex + 1];
                    }
                    case WEST: {
                        return this.mTextures[3][aColorIndex + 1];
                    }
                    case EAST: {
                        return this.mTextures[1][aColorIndex + 1];
                    }
                }
            }
            case WEST: {
                switch (side) {
                    case DOWN: {
                        return this.mTextures[3][aColorIndex + 1];
                    }
                    case UP: {
                        return this.mTextures[1][aColorIndex + 1];
                    }
                    case NORTH: {
                        return this.mTextures[3][aColorIndex + 1];
                    }
                    case SOUTH: {
                        return this.mTextures[1][aColorIndex + 1];
                    }
                }
            }
            case EAST: {
                switch (side) {
                    case DOWN: {
                        return this.mTextures[1][aColorIndex + 1];
                    }
                    case UP: {
                        return this.mTextures[3][aColorIndex + 1];
                    }
                    case NORTH: {
                        return this.mTextures[1][aColorIndex + 1];
                    }
                    case SOUTH: {
                        return this.mTextures[3][aColorIndex + 1];
                    }
                }
            }
        }
        return this.mTextures[5][aColorIndex + 1];
    }

    public boolean isSimpleMachine() {
        return false;
    }

    public boolean isValidSlot(int aIndex) {
        return aIndex < this.mInventory.length - 1;
    }

    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    public boolean isEnetInput() {
        return true;
    }

    public boolean isEnetOutput() {
        return true;
    }

    public boolean isInputFacing(ForgeDirection side) {
        return !this.isOutputFacing(side);
    }

    public boolean isOutputFacing(ForgeDirection side) {
        return this.getBaseMetaTileEntity().getBackFacing() == side;
    }

    public boolean isTeleporterCompatible() {
        return false;
    }

    public long getMinimumStoredEU() {
        return 512L;
    }

    public long maxEUStore() {
        return 512L + GT_Values.V[this.mTier] * 50L;
    }

    public long maxEUInput() {
        return GT_Values.V[this.mTier];
    }

    public long maxEUOutput() {
        return this.bOutput ? GT_Values.V[this.mTier] : 0L;
    }

    public long maxAmperesIn() {
        return 1L;
    }

    public long maxAmperesOut() {
        return 1L;
    }

    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public abstract ITexture getOverlayIcon();

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        if (aPlayer != null) {
            UUID tempUUID = aPlayer.func_110124_au();
            if (this.ownerUUID == null) {
                Logger.INFO("No owner yet for this block.");
            } else {
                Logger.INFO("Current Owner: " + PlayerCache.lookupPlayerByUUID(this.ownerUUID) + " - UUID: " + this.ownerUUID);
            }
            Logger.WARNING("Is ownerUUID Null");
            if (this.ownerUUID == null) {
                Logger.WARNING("OwnerUUID is Null, let's set it.");
                Logger.WARNING("Accessing Players UUID is: " + tempUUID);
                this.ownerUUID = tempUUID;
                Logger.WARNING("Block Owner is now set to: " + this.ownerUUID);
            }
            Logger.WARNING("No, it is not.");
            Logger.WARNING("Checking ownerUUID.");
            if (this.ownerUUID != null) {
                Logger.WARNING("ownerUUID != Null, if accessor == owner.");
                Logger.WARNING("Accessing is: " + PlayerCache.lookupPlayerByUUID(tempUUID));
                if (this.ownerUUID.equals(tempUUID)) {
                    Logger.WARNING("Owner's UUID: " + this.ownerUUID);
                    GT_UIInfos.openGTTileEntityUI((IHasWorldObjectAndCoords)aBaseMetaTileEntity, (EntityPlayer)aPlayer);
                } else {
                    PlayerUtils.messagePlayer(aPlayer, "Access Denied, This does not belong to you.");
                    PlayerUtils.messagePlayer(aPlayer, "it is owned by: " + PlayerCache.lookupPlayerByUUID(this.ownerUUID));
                    Logger.WARNING("Expecting Player : " + PlayerCache.lookupPlayerByUUID(this.ownerUUID));
                    Logger.ERROR("Access Denied.");
                    return true;
                }
            }
        }
        return true;
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74757_a("bUnbreakable", this.bUnbreakable);
        aNBT.func_74757_a("bOutput", this.bOutput);
        aNBT.func_74757_a("bRedstoneIfFull", this.bRedstoneIfFull);
        aNBT.func_74768_a("mTargetStackSize", this.mTargetStackSize);
        if (this.ownerUUID != null) {
            aNBT.func_74778_a("ownerUUID", this.ownerUUID.toString());
        }
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        this.bUnbreakable = aNBT.func_74767_n("bUnbreakable");
        this.bOutput = aNBT.func_74767_n("bOutput");
        this.bRedstoneIfFull = aNBT.func_74767_n("bRedstoneIfFull");
        this.mTargetStackSize = aNBT.func_74762_e("mTargetStackSize");
        if (aNBT.func_74764_b("ownerUUID")) {
            this.ownerUUID = UUID.fromString(aNBT.func_74779_i("ownerUUID"));
        }
    }

    public void setItemNBT(NBTTagCompound aNBT) {
        super.setItemNBT(aNBT);
        if (this.mTargetStackSize > 0) {
            aNBT.func_74768_a("mTargetStackSize", this.mTargetStackSize);
        }
    }

    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return side != aBaseMetaTileEntity.getBackFacing();
    }
}

