/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.loaders;

import gregtech.api.enums.GT_Values;
import gtPlusPlus.api.interfaces.RunnableWithInfo;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.material.MaterialGenerator;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.gregtech.loaders.RecipeGen_Base;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.item.ItemStack;

public class RecipeGen_Assembler
extends RecipeGen_Base {
    public static final Set<RunnableWithInfo<Material>> mRecipeGenMap = new HashSet<RunnableWithInfo<Material>>();

    public RecipeGen_Assembler(Material M) {
        this.toGenerate = M;
        mRecipeGenMap.add(this);
    }

    @Override
    public void run() {
        this.generateRecipes(this.toGenerate);
    }

    private void generateRecipes(Material material) {
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{material.getRod(1), material.getFrameBox(1)})) {
            GT_Values.RA.addAssemblerRecipe(material.getRod(4), ItemUtils.getGregtechCircuit(4), material.getFrameBox(1), 60, material.vVoltageMultiplier);
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{material.getPlate(1), material.getRing(1), material.getRotor(1)})) {
            RecipeGen_Assembler.addAssemblerRecipe(material.getPlate(4), material.getRing(1), material.getRotor(1), 240, material.vVoltageMultiplier);
        }
    }

    private static void addAssemblerRecipe(ItemStack input1, ItemStack input2, ItemStack output1, int seconds, int euCost) {
        GT_Values.RA.addAssemblerRecipe(input1, input2, FluidUtils.getFluidStack("molten.solderingalloy", 16), output1, seconds, euCost);
        GT_Values.RA.addAssemblerRecipe(input1, input2, FluidUtils.getFluidStack("molten.tin", 32), output1, seconds, euCost);
        GT_Values.RA.addAssemblerRecipe(input1, input2, FluidUtils.getFluidStack("molten.lead", 48), output1, seconds, euCost);
    }

    static {
        MaterialGenerator.mRecipeMapsToGenerate.put(mRecipeGenMap);
    }
}

